/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleToolDurability;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.api.upgrades.UpgradeDataProvider;
import dan200.computercraft.impl.PlatformHelper;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jspecify.annotations.Nullable;

public abstract class TurtleUpgradeDataProvider
extends UpgradeDataProvider<ITurtleUpgrade, TurtleUpgradeSerialiser<?>> {
    private static final ResourceLocation TOOL_ID = new ResourceLocation("computercraft", "tool");

    public TurtleUpgradeDataProvider(PackOutput output) {
        super(output, "Turtle Upgrades", "computercraft/turtle_upgrades", TurtleUpgradeSerialiser.registryId());
    }

    public final ToolBuilder tool(ResourceLocation id, Item item) {
        return new ToolBuilder(id, (TurtleUpgradeSerialiser)this.existingSerialiser(TOOL_ID), item);
    }

    public static class ToolBuilder {
        private final ResourceLocation id;
        private final TurtleUpgradeSerialiser<?> serialiser;
        private final Item toolItem;
        private @Nullable String adjective;
        private @Nullable Item craftingItem;
        private @Nullable Float damageMultiplier = null;
        private @Nullable TagKey<Block> breakable;
        private boolean allowEnchantments = false;
        private TurtleToolDurability consumeDurability = TurtleToolDurability.NEVER;

        ToolBuilder(ResourceLocation id, TurtleUpgradeSerialiser<?> serialiser, Item toolItem) {
            this.id = id;
            this.serialiser = serialiser;
            this.toolItem = toolItem;
            this.craftingItem = null;
        }

        public ToolBuilder adjective(String adjective) {
            this.adjective = adjective;
            return this;
        }

        public ToolBuilder craftingItem(Item craftingItem) {
            this.craftingItem = craftingItem;
            return this;
        }

        public ToolBuilder damageMultiplier(float damageMultiplier) {
            this.damageMultiplier = Float.valueOf(damageMultiplier);
            return this;
        }

        public ToolBuilder allowEnchantments() {
            this.allowEnchantments = true;
            return this;
        }

        public ToolBuilder consumeDurability(TurtleToolDurability durability) {
            this.consumeDurability = durability;
            return this;
        }

        public ToolBuilder breakable(TagKey<Block> breakable) {
            this.breakable = breakable;
            return this;
        }

        public void add(Consumer<UpgradeDataProvider.Upgrade<TurtleUpgradeSerialiser<?>>> add) {
            add.accept(new UpgradeDataProvider.Upgrade(this.id, this.serialiser, s -> {
                s.addProperty("item", PlatformHelper.get().getRegistryKey(Registries.f_256913_, this.toolItem).toString());
                if (this.adjective != null) {
                    s.addProperty("adjective", this.adjective);
                }
                if (this.craftingItem != null) {
                    s.addProperty("craftItem", PlatformHelper.get().getRegistryKey(Registries.f_256913_, this.craftingItem).toString());
                }
                if (this.damageMultiplier != null) {
                    s.addProperty("damageMultiplier", (Number)this.damageMultiplier);
                }
                if (this.breakable != null) {
                    s.addProperty("breakable", this.breakable.f_203868_().toString());
                }
                if (this.allowEnchantments) {
                    s.addProperty("allowEnchantments", Boolean.valueOf(true));
                }
                if (this.consumeDurability != TurtleToolDurability.NEVER) {
                    s.addProperty("consumeDurability", this.consumeDurability.m_7912_());
                }
            }));
        }
    }
}

