/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.util;

import java.util.HashSet;
import java.util.Set;

public record SanitisedError(Throwable error) {
    private static final int MAX_LENGTH = 200;
    private static final String CAUSED_BY = "Caused by: ";
    private static final String SUPPRESSED = "Suppressed: ";

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder();
        SanitisedError.printStackTrace(output, this.error);
        return output.toString();
    }

    public static void printStackTrace(StringBuilder output, Throwable error) {
        StackTraceElement[] trace;
        SanitisedError.appendMessage(output, error);
        for (StackTraceElement traceElement : trace = error.getStackTrace()) {
            output.append("\tat ").append(traceElement).append("\n");
        }
        HashSet<Throwable> seen = new HashSet<Throwable>();
        seen.add(error);
        SanitisedError.printAdditionalErrors(output, error, trace, "", seen);
    }

    private static void appendMessage(StringBuilder output, Throwable self) {
        String message = self.toString();
        int length = message.length();
        int limit = Math.min(200, length);
        block6: for (int i = 0; i < limit; ++i) {
            char c = message.charAt(i);
            switch (c) {
                case '\\': {
                    output.append("\\\\");
                    continue block6;
                }
                case '\n': {
                    output.append("\\n");
                    continue block6;
                }
                case '\r': {
                    output.append("\\r");
                    continue block6;
                }
                case '\t': {
                    output.append("\\t");
                    continue block6;
                }
                default: {
                    if (c >= ' ') {
                        output.append(c);
                        continue block6;
                    }
                    output.append("\\u{").append(Integer.toHexString(c)).append("}");
                }
            }
        }
        if (length > 200) {
            output.append("... (message truncated)");
        }
        output.append("\n");
    }

    private static void printAdditionalErrors(StringBuilder output, Throwable self, StackTraceElement[] trace, String indent, Set<Throwable> seen) {
        for (Throwable se : self.getSuppressed()) {
            SanitisedError.printAdditionalError(output, se, trace, SUPPRESSED, indent + "\t", seen);
        }
        Throwable ourCause = self.getCause();
        if (ourCause != null) {
            SanitisedError.printAdditionalError(output, ourCause, trace, CAUSED_BY, indent, seen);
        }
    }

    private static void printAdditionalError(StringBuilder output, Throwable self, StackTraceElement[] parent, String label, String indent, Set<Throwable> seen) {
        if (!seen.add(self)) {
            output.append("[DUPLICATE ERROR: ");
            SanitisedError.appendMessage(output, self);
            output.append("]\n");
            return;
        }
        output.append(indent).append(label);
        SanitisedError.appendMessage(output, self);
        StackTraceElement[] trace = self.getStackTrace();
        int traceIdx = trace.length - 1;
        for (int parentIdx = parent.length - 1; traceIdx >= 0 && parentIdx >= 0 && trace[traceIdx].equals(parent[parentIdx]); --traceIdx, --parentIdx) {
        }
        for (int i = 0; i <= traceIdx; ++i) {
            output.append(indent).append("\tat ").append(trace[traceIdx]).append("\n");
        }
        int remaining = trace.length - traceIdx - 1;
        if (remaining >= 0) {
            output.append(indent).append("\t... ").append(remaining).append(" more\n");
        }
        SanitisedError.printAdditionalErrors(output, self, trace, indent + "\t", seen);
    }
}

