/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.metrics;

import com.google.common.base.CaseFormat;
import dan200.computercraft.core.metrics.Metric;
import dan200.computercraft.core.metrics.Metrics;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.metrics.ComputerMetricsObserver;
import dan200.computercraft.shared.computer.metrics.basic.Aggregate;
import dan200.computercraft.shared.computer.metrics.basic.AggregatedMetric;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import net.minecraft.server.MinecraftServer;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComputerMBean
implements DynamicMBean,
ComputerMetricsObserver {
    private static final Logger LOG = LoggerFactory.getLogger(ComputerMBean.class);
    private static @Nullable ComputerMBean instance;
    private final Map<String, LongSupplier> attributes = new HashMap<String, LongSupplier>();
    private final Int2ObjectMap<Counter> values = new Int2ObjectOpenHashMap();
    private final MBeanInfo info;

    private ComputerMBean() {
        Metrics.init();
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        for (Map.Entry<String, Metric> field : Metric.metrics().entrySet()) {
            String name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getKey());
            this.add(name, field.getValue(), attributes);
        }
        this.info = new MBeanInfo(ComputerMBean.class.getSimpleName(), "metrics about all computers on the server", attributes.toArray(new MBeanAttributeInfo[0]), null, null, null);
    }

    public static void register() {
        if (instance != null) {
            return;
        }
        try {
            instance = new ComputerMBean();
            ManagementFactory.getPlatformMBeanServer().registerMBean(instance, new ObjectName("dan200.computercraft:type=Computers"));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            LOG.warn("Failed to register JMX bean", (Throwable)e);
        }
    }

    public static void start(MinecraftServer server) {
        if (instance != null) {
            ServerContext.get(server).metrics().addObserver(instance);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException {
        LongSupplier value = this.attributes.get(attribute);
        if (value == null) {
            throw new AttributeNotFoundException();
        }
        return value.getAsLong();
    }

    @Override
    public void setAttribute(Attribute attribute) throws InvalidAttributeValueException {
        throw new InvalidAttributeValueException("Cannot set attribute");
    }

    @Override
    public AttributeList getAttributes(String[] names) {
        AttributeList result = new AttributeList(names.length);
        for (String name : names) {
            LongSupplier value = this.attributes.get(name);
            if (value == null) continue;
            result.add(new Attribute(name, value.getAsLong()));
        }
        return result;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    @Override
    public @Nullable Object invoke(String actionName, Object[] params, String[] signature) {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    private void observe(Metric field, long change) {
        Counter counter = (Counter)this.values.get(field.id());
        counter.value.addAndGet(change);
        counter.count.incrementAndGet();
    }

    @Override
    public void observe(ServerComputer computer, Metric.Counter counter) {
        this.observe(counter, 1L);
    }

    @Override
    public void observe(ServerComputer computer, Metric.Event event, long value) {
        this.observe(event, value);
    }

    private MBeanAttributeInfo addAttribute(String name, String description, LongSupplier value) {
        this.attributes.put(name, value);
        return new MBeanAttributeInfo(name, "long", description, true, false, false);
    }

    private void add(String name, Metric field, List<MBeanAttributeInfo> attributes) {
        Counter counter = new Counter();
        this.values.put(field.id(), (Object)counter);
        String prettyName = new AggregatedMetric(field, Aggregate.NONE).displayName().getString();
        attributes.add(this.addAttribute(name, prettyName, counter.value::longValue));
        if (field instanceof Metric.Event) {
            String countName = new AggregatedMetric(field, Aggregate.COUNT).displayName().getString();
            attributes.add(this.addAttribute(name + "Count", countName, counter.count::longValue));
        }
    }

    private static final class Counter {
        final AtomicLong value = new AtomicLong();
        final AtomicLong count = new AtomicLong();

        private Counter() {
        }
    }
}

