/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleRefuelHandler;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import java.util.OptionalInt;
import net.minecraft.world.item.ItemStack;

public final class FurnaceRefuelHandler
implements TurtleRefuelHandler {
    @Override
    public OptionalInt refuel(ITurtleAccess turtle, ItemStack currentStack, int slot, int limit) {
        int fuelPerItem = FurnaceRefuelHandler.getFuelPerItem(currentStack);
        if (fuelPerItem <= 0) {
            return OptionalInt.empty();
        }
        if (limit == 0) {
            return OptionalInt.of(0);
        }
        int fuelSpaceLeft = turtle.getFuelLimit() - turtle.getFuelLevel();
        int fuelItemLimit = (int)Math.ceil((double)fuelSpaceLeft / (double)fuelPerItem);
        if (limit > fuelItemLimit) {
            limit = fuelItemLimit;
        }
        ItemStack stack = turtle.getInventory().m_7407_(slot, limit);
        int fuelToGive = fuelPerItem * stack.m_41613_();
        ItemStack replacementStack = PlatformHelper.get().getCraftingRemainingItem(stack);
        if (!replacementStack.m_41619_()) {
            TurtleUtil.storeItemOrDrop(turtle, replacementStack);
        }
        turtle.getInventory().m_6596_();
        return OptionalInt.of(fuelToGive);
    }

    private static int getFuelPerItem(ItemStack stack) {
        return PlatformHelper.get().getBurnTime(stack) * 5 / 100;
    }
}

