/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.hiero;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.tools.hiero.unicodefont.UnicodeFont;
import com.badlogic.gdx.tools.hiero.unicodefont.effects.ConfigurableEffect;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public class HieroSettings {
    private static final String RENDER_TYPE = "render_type";
    private String fontName = "Arial";
    private int fontSize = 12;
    private boolean bold;
    private boolean italic;
    private boolean mono;
    private float gamma;
    private int paddingTop;
    private int paddingLeft;
    private int paddingBottom;
    private int paddingRight;
    private int paddingAdvanceX;
    private int paddingAdvanceY;
    private int glyphPageWidth = 512;
    private int glyphPageHeight = 512;
    private String glyphText = "";
    private final List effects = new ArrayList();
    private boolean nativeRendering;
    private boolean font2Active = false;
    private String font2File = "";
    private int renderType = UnicodeFont.RenderType.FreeType.ordinal();

    public HieroSettings() {
    }

    public HieroSettings(String hieroFileRef) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(Gdx.files.absolute(hieroFileRef).read(), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                String[] pieces = line.split("=", 2);
                String name2 = pieces[0].trim();
                String value = pieces[1];
                if (name2.equals("font.name")) {
                    this.fontName = value;
                    continue;
                }
                if (name2.equals("font.size")) {
                    this.fontSize = Integer.parseInt(value);
                    continue;
                }
                if (name2.equals("font.gamma")) {
                    this.gamma = Float.parseFloat(value);
                    continue;
                }
                if (name2.equals("font.mono")) {
                    this.mono = Boolean.parseBoolean(value);
                    continue;
                }
                if (name2.equals("font.size")) {
                    this.fontSize = Integer.parseInt(value);
                    continue;
                }
                if (name2.equals("font.bold")) {
                    this.bold = Boolean.parseBoolean(value);
                    continue;
                }
                if (name2.equals("font.italic")) {
                    this.italic = Boolean.parseBoolean(value);
                    continue;
                }
                if (name2.equals("font2.file")) {
                    this.font2File = value;
                    continue;
                }
                if (name2.equals("font2.use")) {
                    this.font2Active = Boolean.parseBoolean(value);
                    continue;
                }
                if (name2.equals("pad.top")) {
                    this.paddingTop = Integer.parseInt(value);
                    continue;
                }
                if (name2.equals("pad.right")) {
                    this.paddingRight = Integer.parseInt(value);
                    continue;
                }
                if (name2.equals("pad.bottom")) {
                    this.paddingBottom = Integer.parseInt(value);
                    continue;
                }
                if (name2.equals("pad.left")) {
                    this.paddingLeft = Integer.parseInt(value);
                    continue;
                }
                if (name2.equals("pad.advance.x")) {
                    this.paddingAdvanceX = Integer.parseInt(value);
                    continue;
                }
                if (name2.equals("pad.advance.y")) {
                    this.paddingAdvanceY = Integer.parseInt(value);
                    continue;
                }
                if (name2.equals("glyph.page.width")) {
                    this.glyphPageWidth = Integer.parseInt(value);
                    continue;
                }
                if (name2.equals("glyph.page.height")) {
                    this.glyphPageHeight = Integer.parseInt(value);
                    continue;
                }
                if (name2.equals("glyph.native.rendering")) {
                    this.nativeRendering = Boolean.parseBoolean(value);
                    continue;
                }
                if (name2.equals("glyph.text")) {
                    this.glyphText = value;
                    continue;
                }
                if (name2.equals(RENDER_TYPE)) {
                    this.renderType = Integer.parseInt(value);
                    continue;
                }
                if (name2.equals("effect.class")) {
                    try {
                        this.effects.add(Class.forName(value).newInstance());
                        continue;
                    }
                    catch (Throwable ex) {
                        throw new GdxRuntimeException("Unable to create effect instance: " + value, ex);
                    }
                }
                if (!name2.startsWith("effect.")) continue;
                name2 = name2.substring(7);
                ConfigurableEffect effect = (ConfigurableEffect)this.effects.get(this.effects.size() - 1);
                List values2 = effect.getValues();
                for (ConfigurableEffect.Value effectValue : values2) {
                    if (!effectValue.getName().equals(name2)) continue;
                    effectValue.setString(value);
                    break;
                }
                effect.setValues(values2);
            }
            reader.close();
        }
        catch (Throwable ex) {
            throw new GdxRuntimeException("Unable to load Hiero font file: " + hieroFileRef, ex);
        }
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
    }

    public int getPaddingAdvanceX() {
        return this.paddingAdvanceX;
    }

    public void setPaddingAdvanceX(int paddingAdvanceX) {
        this.paddingAdvanceX = paddingAdvanceX;
    }

    public int getPaddingAdvanceY() {
        return this.paddingAdvanceY;
    }

    public void setPaddingAdvanceY(int paddingAdvanceY) {
        this.paddingAdvanceY = paddingAdvanceY;
    }

    public int getGlyphPageWidth() {
        return this.glyphPageWidth;
    }

    public void setGlyphPageWidth(int glyphPageWidth) {
        this.glyphPageWidth = glyphPageWidth;
    }

    public int getGlyphPageHeight() {
        return this.glyphPageHeight;
    }

    public void setGlyphPageHeight(int glyphPageHeight) {
        this.glyphPageHeight = glyphPageHeight;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public List getEffects() {
        return this.effects;
    }

    public boolean getNativeRendering() {
        return this.nativeRendering;
    }

    public void setNativeRendering(boolean nativeRendering) {
        this.nativeRendering = nativeRendering;
    }

    public String getGlyphText() {
        return this.glyphText.replace("\\n", "\n");
    }

    public void setGlyphText(String text2) {
        this.glyphText = text2.replace("\n", "\\n");
    }

    public String getFont2File() {
        return this.font2File;
    }

    public void setFont2File(String filename) {
        this.font2File = filename;
    }

    public boolean isFont2Active() {
        return this.font2Active;
    }

    public void setFont2Active(boolean active) {
        this.font2Active = active;
    }

    public boolean isMono() {
        return this.mono;
    }

    public void setMono(boolean mono) {
        this.mono = mono;
    }

    public float getGamma() {
        return this.gamma;
    }

    public void setGamma(float gamma) {
        this.gamma = gamma;
    }

    public void save(File file) throws IOException {
        PrintStream out2 = new PrintStream(file, "UTF-8");
        out2.println("font.name=" + this.fontName);
        out2.println("font.size=" + this.fontSize);
        out2.println("font.bold=" + this.bold);
        out2.println("font.italic=" + this.italic);
        out2.println("font.gamma=" + this.gamma);
        out2.println("font.mono=" + this.mono);
        out2.println();
        out2.println("font2.file=" + this.font2File);
        out2.println("font2.use=" + this.font2Active);
        out2.println();
        out2.println("pad.top=" + this.paddingTop);
        out2.println("pad.right=" + this.paddingRight);
        out2.println("pad.bottom=" + this.paddingBottom);
        out2.println("pad.left=" + this.paddingLeft);
        out2.println("pad.advance.x=" + this.paddingAdvanceX);
        out2.println("pad.advance.y=" + this.paddingAdvanceY);
        out2.println();
        out2.println("glyph.native.rendering=" + this.nativeRendering);
        out2.println("glyph.page.width=" + this.glyphPageWidth);
        out2.println("glyph.page.height=" + this.glyphPageHeight);
        out2.println("glyph.text=" + this.glyphText);
        out2.println();
        out2.println("render_type=" + this.renderType);
        out2.println();
        for (ConfigurableEffect effect : this.effects) {
            out2.println("effect.class=" + effect.getClass().getName());
            for (ConfigurableEffect.Value value : effect.getValues()) {
                out2.println("effect." + value.getName() + "=" + value.getString());
            }
            out2.println();
        }
        out2.close();
    }

    public void setRenderType(int renderType) {
        this.renderType = renderType;
    }

    public int getRenderType() {
        return this.renderType;
    }
}

