/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Predicate;
import com.badlogic.gdx.utils.Select;
import com.badlogic.gdx.utils.Sort;
import com.badlogic.gdx.utils.StringBuilder;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Array<T>
implements Iterable<T> {
    public T[] items;
    public int size;
    public boolean ordered;
    private transient ArrayIterable<T> iterable;
    private transient Predicate.PredicateIterable<T> predicateIterable;

    public Array() {
        this(true, 16);
    }

    public Array(int capacity) {
        this(true, capacity);
    }

    public Array(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new Object[capacity];
    }

    public Array(boolean ordered, int capacity, Class arrayType) {
        this.ordered = ordered;
        this.items = (Object[])ArrayReflection.newInstance(arrayType, capacity);
    }

    public Array(Class arrayType) {
        this(true, 16, arrayType);
    }

    public Array(Array<? extends T> array) {
        this(array.ordered, array.size, array.items.getClass().getComponentType());
        this.size = array.size;
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public Array(T[] array) {
        this(true, array, 0, array.length);
    }

    public Array(boolean ordered, T[] array, int start2, int count2) {
        this(ordered, count2, array.getClass().getComponentType());
        this.size = count2;
        System.arraycopy(array, start2, this.items, 0, this.size);
    }

    public void add(T value) {
        T[] items2 = this.items;
        if (this.size == items2.length) {
            items2 = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items2[this.size++] = value;
    }

    public void add(T value1, T value2) {
        T[] items2 = this.items;
        if (this.size + 1 >= items2.length) {
            items2 = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items2[this.size] = value1;
        items2[this.size + 1] = value2;
        this.size += 2;
    }

    public void add(T value1, T value2, T value3) {
        T[] items2 = this.items;
        if (this.size + 2 >= items2.length) {
            items2 = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items2[this.size] = value1;
        items2[this.size + 1] = value2;
        items2[this.size + 2] = value3;
        this.size += 3;
    }

    public void add(T value1, T value2, T value3, T value4) {
        T[] items2 = this.items;
        if (this.size + 3 >= items2.length) {
            items2 = this.resize(Math.max(8, (int)((float)this.size * 1.8f)));
        }
        items2[this.size] = value1;
        items2[this.size + 1] = value2;
        items2[this.size + 2] = value3;
        items2[this.size + 3] = value4;
        this.size += 4;
    }

    public void addAll(Array<? extends T> array) {
        this.addAll(array.items, 0, array.size);
    }

    public void addAll(Array<? extends T> array, int start2, int count2) {
        if (start2 + count2 > array.size) {
            throw new IllegalArgumentException("start + count must be <= size: " + start2 + " + " + count2 + " <= " + array.size);
        }
        this.addAll(array.items, start2, count2);
    }

    public void addAll(T ... array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(T[] array, int start2, int count2) {
        int sizeNeeded = this.size + count2;
        T[] items2 = this.items;
        if (sizeNeeded > items2.length) {
            items2 = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(array, start2, items2, this.size, count2);
        this.size = sizeNeeded;
    }

    public T get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, T value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void insert(int index, T value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        T[] items2 = this.items;
        if (this.size == items2.length) {
            items2 = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(items2, index, items2, index + 1, this.size - index);
        } else {
            items2[this.size] = items2[index];
        }
        ++this.size;
        items2[index] = value;
    }

    public void insertRange(int index, int count2) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        int sizeNeeded = this.size + count2;
        if (sizeNeeded > this.items.length) {
            this.items = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(this.items, index, this.items, index + count2, this.size - index);
        this.size = sizeNeeded;
    }

    public void swap(int first2, int second2) {
        if (first2 >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first2 + " >= " + this.size);
        }
        if (second2 >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second2 + " >= " + this.size);
        }
        T[] items2 = this.items;
        T firstValue = items2[first2];
        items2[first2] = items2[second2];
        items2[second2] = firstValue;
    }

    public boolean replaceFirst(@Null T value, boolean identity, T replacement) {
        T[] items2 = this.items;
        if (identity || value == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (items2[i] != value) continue;
                items2[i] = replacement;
                return true;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!value.equals(items2[i])) continue;
                items2[i] = replacement;
                return true;
            }
        }
        return false;
    }

    public int replaceAll(@Null T value, boolean identity, @Null T replacement) {
        T[] items2 = this.items;
        int replacements = 0;
        if (identity || value == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (items2[i] != value) continue;
                items2[i] = replacement;
                ++replacements;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!value.equals(items2[i])) continue;
                items2[i] = replacement;
                ++replacements;
            }
        }
        return replacements;
    }

    public boolean contains(@Null T value, boolean identity) {
        T[] items2 = this.items;
        int i = this.size - 1;
        if (identity || value == null) {
            while (i >= 0) {
                if (items2[i--] != value) continue;
                return true;
            }
        } else {
            while (i >= 0) {
                if (!value.equals(items2[i--])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsAll(Array<? extends T> values2, boolean identity) {
        T[] items2 = values2.items;
        int n = values2.size;
        for (int i = 0; i < n; ++i) {
            if (this.contains(items2[i], identity)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(Array<? extends T> values2, boolean identity) {
        T[] items2 = values2.items;
        int n = values2.size;
        for (int i = 0; i < n; ++i) {
            if (!this.contains(items2[i], identity)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(@Null T value, boolean identity) {
        T[] items2 = this.items;
        if (identity || value == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (items2[i] != value) continue;
                return i;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!value.equals(items2[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(@Null T value, boolean identity) {
        T[] items2 = this.items;
        if (identity || value == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (items2[i] != value) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!value.equals(items2[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean removeValue(@Null T value, boolean identity) {
        T[] items2 = this.items;
        if (identity || value == null) {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (items2[i] != value) continue;
                this.removeIndex(i);
                return true;
            }
        } else {
            int n = this.size;
            for (int i = 0; i < n; ++i) {
                if (!value.equals(items2[i])) continue;
                this.removeIndex(i);
                return true;
            }
        }
        return false;
    }

    public T removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        T[] items2 = this.items;
        T value = items2[index];
        --this.size;
        if (this.ordered) {
            System.arraycopy(items2, index + 1, items2, index, this.size - index);
        } else {
            items2[index] = items2[this.size];
        }
        items2[this.size] = null;
        return value;
    }

    public void removeRange(int start2, int end2) {
        int i;
        int n = this.size;
        if (end2 >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end2 + " >= " + this.size);
        }
        if (start2 > end2) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start2 + " > " + end2);
        }
        T[] items2 = this.items;
        int count2 = end2 - start2 + 1;
        int lastIndex = n - count2;
        if (this.ordered) {
            System.arraycopy(items2, start2 + count2, items2, start2, n - (start2 + count2));
        } else {
            i = Math.max(lastIndex, end2 + 1);
            System.arraycopy(items2, i, items2, start2, n - i);
        }
        for (i = lastIndex; i < n; ++i) {
            items2[i] = null;
        }
        this.size = n - count2;
    }

    public boolean removeAll(Array<? extends T> array, boolean identity) {
        int size2;
        int startSize = size2 = this.size;
        T[] items2 = this.items;
        if (identity) {
            int n = array.size;
            block0: for (int i = 0; i < n; ++i) {
                T item = array.get(i);
                for (int ii = 0; ii < size2; ++ii) {
                    if (item != items2[ii]) continue;
                    this.removeIndex(ii);
                    --size2;
                    continue block0;
                }
            }
        } else {
            int n = array.size;
            block2: for (int i = 0; i < n; ++i) {
                T item = array.get(i);
                for (int ii = 0; ii < size2; ++ii) {
                    if (!item.equals(items2[ii])) continue;
                    this.removeIndex(ii);
                    --size2;
                    continue block2;
                }
            }
        }
        return size2 != startSize;
    }

    public T pop() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        --this.size;
        T item = this.items[this.size];
        this.items[this.size] = null;
        return item;
    }

    public T peek() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[this.size - 1];
    }

    public T first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Arrays.fill(this.items, 0, this.size, null);
        this.size = 0;
    }

    public T[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public T[] ensureCapacity(int additionalCapacity) {
        if (additionalCapacity < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: " + additionalCapacity);
        }
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded > this.items.length) {
            this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        return this.items;
    }

    public T[] setSize(int newSize) {
        this.truncate(newSize);
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected T[] resize(int newSize) {
        T[] items2 = this.items;
        Object[] newItems = (Object[])ArrayReflection.newInstance(items2.getClass().getComponentType(), newSize);
        System.arraycopy(items2, 0, newItems, 0, Math.min(this.size, newItems.length));
        this.items = newItems;
        return newItems;
    }

    public void sort() {
        Sort.instance().sort(this.items, 0, this.size);
    }

    public void sort(Comparator<? super T> comparator) {
        Sort.instance().sort(this.items, comparator, 0, this.size);
    }

    public T selectRanked(Comparator<T> comparator, int kthLowest) {
        if (kthLowest < 1) {
            throw new GdxRuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.instance().select(this.items, comparator, kthLowest, this.size);
    }

    public int selectRankedIndex(Comparator<T> comparator, int kthLowest) {
        if (kthLowest < 1) {
            throw new GdxRuntimeException("nth_lowest must be greater than 0, 1 = first, 2 = second...");
        }
        return Select.instance().selectIndex(this.items, comparator, kthLowest, this.size);
    }

    public void reverse() {
        T[] items2 = this.items;
        int lastIndex = this.size - 1;
        int n = this.size / 2;
        for (int i = 0; i < n; ++i) {
            int ii = lastIndex - i;
            T temp = items2[i];
            items2[i] = items2[ii];
            items2[ii] = temp;
        }
    }

    public void shuffle() {
        T[] items2 = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int ii = MathUtils.random(i);
            T temp = items2[i];
            items2[i] = items2[ii];
            items2[ii] = temp;
        }
    }

    @Override
    public ArrayIterator<T> iterator() {
        if (Collections.allocateIterators) {
            return new ArrayIterator(this, true);
        }
        if (this.iterable == null) {
            this.iterable = new ArrayIterable(this);
        }
        return this.iterable.iterator();
    }

    public Iterable<T> select(Predicate<T> predicate) {
        if (Collections.allocateIterators) {
            return new Predicate.PredicateIterable<T>(this, predicate);
        }
        if (this.predicateIterable == null) {
            this.predicateIterable = new Predicate.PredicateIterable<T>(this, predicate);
        } else {
            this.predicateIterable.set(this, predicate);
        }
        return this.predicateIterable;
    }

    public void truncate(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("newSize must be >= 0: " + newSize);
        }
        if (this.size <= newSize) {
            return;
        }
        for (int i = newSize; i < this.size; ++i) {
            this.items[i] = null;
        }
        this.size = newSize;
    }

    @Null
    public T random() {
        if (this.size == 0) {
            return null;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public T[] toArray() {
        return this.toArray(this.items.getClass().getComponentType());
    }

    public <V> V[] toArray(Class<V> type2) {
        Object[] result2 = (Object[])ArrayReflection.newInstance(type2, this.size);
        System.arraycopy(this.items, 0, result2, 0, this.size);
        return result2;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        T[] items2 = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h *= 31;
            T item = items2[i];
            if (item == null) continue;
            h += item.hashCode();
        }
        return h;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof Array)) {
            return false;
        }
        Array array = (Array)object;
        if (!array.ordered) {
            return false;
        }
        int n = this.size;
        if (n != array.size) {
            return false;
        }
        T[] items1 = this.items;
        T[] items2 = array.items;
        for (int i = 0; i < n; ++i) {
            T o1 = items1[i];
            T o2 = items2[i];
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof Array)) {
            return false;
        }
        Array array = (Array)object;
        if (!array.ordered) {
            return false;
        }
        int n = this.size;
        if (n != array.size) {
            return false;
        }
        T[] items1 = this.items;
        T[] items2 = array.items;
        for (int i = 0; i < n; ++i) {
            if (items1[i] == items2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        T[] items2 = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(items2[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(items2[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        T[] items2 = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(items2[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(separator);
            buffer.append(items2[i]);
        }
        return buffer.toString();
    }

    public static <T> Array<T> of(Class<T> arrayType) {
        return new Array<T>(arrayType);
    }

    public static <T> Array<T> of(boolean ordered, int capacity, Class<T> arrayType) {
        return new Array<T>(ordered, capacity, arrayType);
    }

    public static <T> Array<T> with(T ... array) {
        return new Array<T>(array);
    }

    public static class ArrayIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        private final Array<T> array;
        private final boolean allowRemove;
        int index;
        boolean valid = true;

        public ArrayIterator(Array<T> array) {
            this(array, true);
        }

        public ArrayIterator(Array<T> array, boolean allowRemove) {
            this.array = array;
            this.allowRemove = allowRemove;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.array.size;
        }

        @Override
        public T next() {
            if (this.index >= this.array.size) {
                throw new NoSuchElementException(String.valueOf(this.index));
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.array.items[this.index++];
        }

        @Override
        public void remove() {
            if (!this.allowRemove) {
                throw new GdxRuntimeException("Remove not allowed.");
            }
            --this.index;
            this.array.removeIndex(this.index);
        }

        public void reset() {
            this.index = 0;
        }

        @Override
        public ArrayIterator<T> iterator() {
            return this;
        }
    }

    public static class ArrayIterable<T>
    implements Iterable<T> {
        private final Array<T> array;
        private final boolean allowRemove;
        private transient ArrayIterator<T> iterator1;
        private transient ArrayIterator<T> iterator2;

        public ArrayIterable(Array<T> array) {
            this(array, true);
        }

        public ArrayIterable(Array<T> array, boolean allowRemove) {
            this.array = array;
            this.allowRemove = allowRemove;
        }

        @Override
        public ArrayIterator<T> iterator() {
            if (Collections.allocateIterators) {
                return new ArrayIterator<T>(this.array, this.allowRemove);
            }
            if (this.iterator1 == null) {
                this.iterator1 = new ArrayIterator<T>(this.array, this.allowRemove);
                this.iterator2 = new ArrayIterator<T>(this.array, this.allowRemove);
            }
            if (!this.iterator1.valid) {
                this.iterator1.index = 0;
                this.iterator1.valid = true;
                this.iterator2.valid = false;
                return this.iterator1;
            }
            this.iterator2.index = 0;
            this.iterator2.valid = true;
            this.iterator1.valid = false;
            return this.iterator2;
        }
    }
}

