/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.Gdx;

public class Logger {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    private final String tag;
    private int level;

    public Logger(String tag) {
        this(tag, 1);
    }

    public Logger(String tag, int level) {
        this.tag = tag;
        this.level = level;
    }

    public void debug(String message2) {
        if (this.level >= 3) {
            Gdx.app.debug(this.tag, message2);
        }
    }

    public void debug(String message2, Exception exception2) {
        if (this.level >= 3) {
            Gdx.app.debug(this.tag, message2, exception2);
        }
    }

    public void info(String message2) {
        if (this.level >= 2) {
            Gdx.app.log(this.tag, message2);
        }
    }

    public void info(String message2, Exception exception2) {
        if (this.level >= 2) {
            Gdx.app.log(this.tag, message2, exception2);
        }
    }

    public void error(String message2) {
        if (this.level >= 1) {
            Gdx.app.error(this.tag, message2);
        }
    }

    public void error(String message2, Throwable exception2) {
        if (this.level >= 1) {
            Gdx.app.error(this.tag, message2, exception2);
        }
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }
}

