/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Arrays;

public class LongArray {
    public long[] items;
    public int size;
    public boolean ordered;

    public LongArray() {
        this(true, 16);
    }

    public LongArray(int capacity) {
        this(true, capacity);
    }

    public LongArray(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new long[capacity];
    }

    public LongArray(LongArray array) {
        this.ordered = array.ordered;
        this.size = array.size;
        this.items = new long[this.size];
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public LongArray(long[] array) {
        this(true, array, 0, array.length);
    }

    public LongArray(boolean ordered, long[] array, int startIndex, int count2) {
        this(ordered, count2);
        this.size = count2;
        System.arraycopy(array, startIndex, this.items, 0, count2);
    }

    public void add(long value) {
        long[] items2 = this.items;
        if (this.size == items2.length) {
            items2 = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items2[this.size++] = value;
    }

    public void add(long value1, long value2) {
        long[] items2 = this.items;
        if (this.size + 1 >= items2.length) {
            items2 = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items2[this.size] = value1;
        items2[this.size + 1] = value2;
        this.size += 2;
    }

    public void add(long value1, long value2, long value3) {
        long[] items2 = this.items;
        if (this.size + 2 >= items2.length) {
            items2 = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items2[this.size] = value1;
        items2[this.size + 1] = value2;
        items2[this.size + 2] = value3;
        this.size += 3;
    }

    public void add(long value1, long value2, long value3, long value4) {
        long[] items2 = this.items;
        if (this.size + 3 >= items2.length) {
            items2 = this.resize(Math.max(8, (int)((float)this.size * 1.8f)));
        }
        items2[this.size] = value1;
        items2[this.size + 1] = value2;
        items2[this.size + 2] = value3;
        items2[this.size + 3] = value4;
        this.size += 4;
    }

    public void addAll(LongArray array) {
        this.addAll(array.items, 0, array.size);
    }

    public void addAll(LongArray array, int offset, int length) {
        if (offset + length > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.size);
        }
        this.addAll(array.items, offset, length);
    }

    public void addAll(long ... array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(long[] array, int offset, int length) {
        int sizeNeeded = this.size + length;
        long[] items2 = this.items;
        if (sizeNeeded > items2.length) {
            items2 = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(array, offset, items2, this.size, length);
        this.size += length;
    }

    public long get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        return this.items[index];
    }

    public void set(int index, long value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        this.items[index] = value;
    }

    public void incr(int index, long value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] + value;
    }

    public void incr(long value) {
        long[] items2 = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items2[n2] = items2[n2] + value;
        }
    }

    public void mul(int index, long value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        int n = index;
        this.items[n] = this.items[n] * value;
    }

    public void mul(long value) {
        long[] items2 = this.items;
        int i = 0;
        int n = this.size;
        while (i < n) {
            int n2 = i++;
            items2[n2] = items2[n2] * value;
        }
    }

    public void insert(int index, long value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        long[] items2 = this.items;
        if (this.size == items2.length) {
            items2 = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(items2, index, items2, index + 1, this.size - index);
        } else {
            items2[this.size] = items2[index];
        }
        ++this.size;
        items2[index] = value;
    }

    public void insertRange(int index, int count2) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        int sizeNeeded = this.size + count2;
        if (sizeNeeded > this.items.length) {
            this.items = this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        System.arraycopy(this.items, index, this.items, index + count2, this.size - index);
        this.size = sizeNeeded;
    }

    public void swap(int first2, int second2) {
        if (first2 >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first2 + " >= " + this.size);
        }
        if (second2 >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second2 + " >= " + this.size);
        }
        long[] items2 = this.items;
        long firstValue = items2[first2];
        items2[first2] = items2[second2];
        items2[second2] = firstValue;
    }

    public boolean contains(long value) {
        int i = this.size - 1;
        long[] items2 = this.items;
        while (i >= 0) {
            if (items2[i--] != value) continue;
            return true;
        }
        return false;
    }

    public int indexOf(long value) {
        long[] items2 = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items2[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long value) {
        long[] items2 = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (items2[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean removeValue(long value) {
        long[] items2 = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items2[i] != value) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    public long removeIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        long[] items2 = this.items;
        long value = items2[index];
        --this.size;
        if (this.ordered) {
            System.arraycopy(items2, index + 1, items2, index, this.size - index);
        } else {
            items2[index] = items2[this.size];
        }
        return value;
    }

    public void removeRange(int start2, int end2) {
        int n = this.size;
        if (end2 >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end2 + " >= " + this.size);
        }
        if (start2 > end2) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start2 + " > " + end2);
        }
        int count2 = end2 - start2 + 1;
        int lastIndex = n - count2;
        if (this.ordered) {
            System.arraycopy(this.items, start2 + count2, this.items, start2, n - (start2 + count2));
        } else {
            int i = Math.max(lastIndex, end2 + 1);
            System.arraycopy(this.items, i, this.items, start2, n - i);
        }
        this.size = n - count2;
    }

    public boolean removeAll(LongArray array) {
        int size2;
        int startSize = size2 = this.size;
        long[] items2 = this.items;
        int n = array.size;
        block0: for (int i = 0; i < n; ++i) {
            long item = array.get(i);
            for (int ii = 0; ii < size2; ++ii) {
                if (item != items2[ii]) continue;
                this.removeIndex(ii);
                --size2;
                continue block0;
            }
        }
        return size2 != startSize;
    }

    public long pop() {
        if (this.size <= 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[--this.size];
    }

    public long peek() {
        if (this.size <= 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[this.size - 1];
    }

    public long first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    public long[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public long[] ensureCapacity(int additionalCapacity) {
        if (additionalCapacity < 0) {
            throw new IllegalArgumentException("additionalCapacity must be >= 0: " + additionalCapacity);
        }
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded > this.items.length) {
            this.resize(Math.max(Math.max(8, sizeNeeded), (int)((float)this.size * 1.75f)));
        }
        return this.items;
    }

    public long[] setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("newSize must be >= 0: " + newSize);
        }
        if (newSize > this.items.length) {
            this.resize(Math.max(8, newSize));
        }
        this.size = newSize;
        return this.items;
    }

    protected long[] resize(int newSize) {
        long[] newItems = new long[newSize];
        long[] items2 = this.items;
        System.arraycopy(items2, 0, newItems, 0, Math.min(this.size, newItems.length));
        this.items = newItems;
        return newItems;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        long[] items2 = this.items;
        int lastIndex = this.size - 1;
        int n = this.size / 2;
        for (int i = 0; i < n; ++i) {
            int ii = lastIndex - i;
            long temp = items2[i];
            items2[i] = items2[ii];
            items2[ii] = temp;
        }
    }

    public void shuffle() {
        long[] items2 = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int ii = MathUtils.random(i);
            long temp = items2[i];
            items2[i] = items2[ii];
            items2[ii] = temp;
        }
    }

    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.size = newSize;
        }
    }

    public long random() {
        if (this.size == 0) {
            return 0L;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public long[] toArray() {
        long[] array = new long[this.size];
        System.arraycopy(this.items, 0, array, 0, this.size);
        return array;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        long[] items2 = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            long item = items2[i];
            h = h * 31 + (int)(item ^ item >>> 32);
        }
        return h;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof LongArray)) {
            return false;
        }
        LongArray array = (LongArray)object;
        if (!array.ordered) {
            return false;
        }
        int n = this.size;
        if (n != array.size) {
            return false;
        }
        long[] items1 = this.items;
        long[] items2 = array.items;
        for (int i = 0; i < n; ++i) {
            if (items1[i] == items2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        long[] items2 = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(items2[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(items2[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        long[] items2 = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(items2[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(separator);
            buffer.append(items2[i]);
        }
        return buffer.toString();
    }

    public static LongArray with(long ... array) {
        return new LongArray(array);
    }
}

