/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UBJsonWriter
implements Closeable {
    final DataOutputStream out;
    private JsonObject current;
    private boolean named;
    private final Array<JsonObject> stack = new Array();

    public UBJsonWriter(OutputStream out2) {
        if (!(out2 instanceof DataOutputStream)) {
            out2 = new DataOutputStream(out2);
        }
        this.out = (DataOutputStream)out2;
    }

    public UBJsonWriter object() throws IOException {
        if (this.current != null && !this.current.array) {
            if (!this.named) {
                throw new IllegalStateException("Name must be set.");
            }
            this.named = false;
        }
        this.current = new JsonObject(false);
        this.stack.add(this.current);
        return this;
    }

    public UBJsonWriter object(String name2) throws IOException {
        this.name(name2).object();
        return this;
    }

    public UBJsonWriter array() throws IOException {
        if (this.current != null && !this.current.array) {
            if (!this.named) {
                throw new IllegalStateException("Name must be set.");
            }
            this.named = false;
        }
        this.current = new JsonObject(true);
        this.stack.add(this.current);
        return this;
    }

    public UBJsonWriter array(String name2) throws IOException {
        this.name(name2).array();
        return this;
    }

    public UBJsonWriter name(String name2) throws IOException {
        if (this.current == null || this.current.array) {
            throw new IllegalStateException("Current item must be an object.");
        }
        byte[] bytes = name2.getBytes("UTF-8");
        if (bytes.length <= 127) {
            this.out.writeByte(105);
            this.out.writeByte(bytes.length);
        } else if (bytes.length <= Short.MAX_VALUE) {
            this.out.writeByte(73);
            this.out.writeShort(bytes.length);
        } else {
            this.out.writeByte(108);
            this.out.writeInt(bytes.length);
        }
        this.out.write(bytes);
        this.named = true;
        return this;
    }

    public UBJsonWriter value(byte value) throws IOException {
        this.checkName();
        this.out.writeByte(105);
        this.out.writeByte(value);
        return this;
    }

    public UBJsonWriter value(short value) throws IOException {
        this.checkName();
        this.out.writeByte(73);
        this.out.writeShort(value);
        return this;
    }

    public UBJsonWriter value(int value) throws IOException {
        this.checkName();
        this.out.writeByte(108);
        this.out.writeInt(value);
        return this;
    }

    public UBJsonWriter value(long value) throws IOException {
        this.checkName();
        this.out.writeByte(76);
        this.out.writeLong(value);
        return this;
    }

    public UBJsonWriter value(float value) throws IOException {
        this.checkName();
        this.out.writeByte(100);
        this.out.writeFloat(value);
        return this;
    }

    public UBJsonWriter value(double value) throws IOException {
        this.checkName();
        this.out.writeByte(68);
        this.out.writeDouble(value);
        return this;
    }

    public UBJsonWriter value(boolean value) throws IOException {
        this.checkName();
        this.out.writeByte(value ? 84 : 70);
        return this;
    }

    public UBJsonWriter value(char value) throws IOException {
        this.checkName();
        this.out.writeByte(73);
        this.out.writeChar(value);
        return this;
    }

    public UBJsonWriter value(String value) throws IOException {
        this.checkName();
        byte[] bytes = value.getBytes("UTF-8");
        this.out.writeByte(83);
        if (bytes.length <= 127) {
            this.out.writeByte(105);
            this.out.writeByte(bytes.length);
        } else if (bytes.length <= Short.MAX_VALUE) {
            this.out.writeByte(73);
            this.out.writeShort(bytes.length);
        } else {
            this.out.writeByte(108);
            this.out.writeInt(bytes.length);
        }
        this.out.write(bytes);
        return this;
    }

    public UBJsonWriter value(byte[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(105);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeByte(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(short[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(73);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeShort(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(int[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(108);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeInt(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(long[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(76);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeLong(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(float[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(100);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeFloat(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(double[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(68);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeDouble(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(boolean[] values2) throws IOException {
        this.array();
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeByte(values2[i] ? 84 : 70);
        }
        this.pop();
        return this;
    }

    public UBJsonWriter value(char[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(67);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            this.out.writeChar(values2[i]);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(String[] values2) throws IOException {
        this.array();
        this.out.writeByte(36);
        this.out.writeByte(83);
        this.out.writeByte(35);
        this.value(values2.length);
        int n = values2.length;
        for (int i = 0; i < n; ++i) {
            byte[] bytes = values2[i].getBytes("UTF-8");
            if (bytes.length <= 127) {
                this.out.writeByte(105);
                this.out.writeByte(bytes.length);
            } else if (bytes.length <= Short.MAX_VALUE) {
                this.out.writeByte(73);
                this.out.writeShort(bytes.length);
            } else {
                this.out.writeByte(108);
                this.out.writeInt(bytes.length);
            }
            this.out.write(bytes);
        }
        this.pop(true);
        return this;
    }

    public UBJsonWriter value(JsonValue value) throws IOException {
        if (value.isObject()) {
            if (value.name != null) {
                this.object(value.name);
            } else {
                this.object();
            }
            JsonValue child = value.child;
            while (child != null) {
                this.value(child);
                child = child.next;
            }
            this.pop();
        } else if (value.isArray()) {
            if (value.name != null) {
                this.array(value.name);
            } else {
                this.array();
            }
            JsonValue child = value.child;
            while (child != null) {
                this.value(child);
                child = child.next;
            }
            this.pop();
        } else if (value.isBoolean()) {
            if (value.name != null) {
                this.name(value.name);
            }
            this.value(value.asBoolean());
        } else if (value.isDouble()) {
            if (value.name != null) {
                this.name(value.name);
            }
            this.value(value.asDouble());
        } else if (value.isLong()) {
            if (value.name != null) {
                this.name(value.name);
            }
            this.value(value.asLong());
        } else if (value.isString()) {
            if (value.name != null) {
                this.name(value.name);
            }
            this.value(value.asString());
        } else if (value.isNull()) {
            if (value.name != null) {
                this.name(value.name);
            }
            this.value();
        } else {
            throw new IOException("Unhandled JsonValue type");
        }
        return this;
    }

    public UBJsonWriter value(Object object) throws IOException {
        if (object == null) {
            return this.value();
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (object instanceof Byte) {
                return this.value(number.byteValue());
            }
            if (object instanceof Short) {
                return this.value(number.shortValue());
            }
            if (object instanceof Integer) {
                return this.value(number.intValue());
            }
            if (object instanceof Long) {
                return this.value(number.longValue());
            }
            if (object instanceof Float) {
                return this.value(number.floatValue());
            }
            if (object instanceof Double) {
                return this.value(number.doubleValue());
            }
        } else {
            if (object instanceof Character) {
                return this.value(((Character)object).charValue());
            }
            if (object instanceof CharSequence) {
                return this.value(object.toString());
            }
            throw new IOException("Unknown object type.");
        }
        return this;
    }

    public UBJsonWriter value() throws IOException {
        this.checkName();
        this.out.writeByte(90);
        return this;
    }

    public UBJsonWriter set(String name2, byte value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, short value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, int value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, long value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, float value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, double value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, boolean value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, char value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, String value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, byte[] value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, short[] value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, int[] value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, long[] value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, float[] value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, double[] value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, boolean[] value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, char[] value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2, String[] value) throws IOException {
        return this.name(name2).value(value);
    }

    public UBJsonWriter set(String name2) throws IOException {
        return this.name(name2).value();
    }

    private void checkName() {
        if (this.current != null && !this.current.array) {
            if (!this.named) {
                throw new IllegalStateException("Name must be set.");
            }
            this.named = false;
        }
    }

    public UBJsonWriter pop() throws IOException {
        return this.pop(false);
    }

    protected UBJsonWriter pop(boolean silent) throws IOException {
        if (this.named) {
            throw new IllegalStateException("Expected an object, array, or value since a name was set.");
        }
        if (silent) {
            this.stack.pop();
        } else {
            this.stack.pop().close();
        }
        this.current = this.stack.size == 0 ? null : this.stack.peek();
        return this;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        while (this.stack.size > 0) {
            this.pop();
        }
        this.out.close();
    }

    private class JsonObject {
        final boolean array;

        JsonObject(boolean array) throws IOException {
            this.array = array;
            UBJsonWriter.this.out.writeByte(array ? 91 : 123);
        }

        void close() throws IOException {
            UBJsonWriter.this.out.writeByte(this.array ? 93 : 125);
        }
    }
}

