/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.sun.jna.platform.win32.Kernel32Util;
import com.unciv.UncivGame;
import com.unciv.app.desktop.DiscordGameInfo;
import com.unciv.app.desktop.DiscordUpdater;
import com.unciv.app.desktop.HardenGdxAudio;
import com.unciv.app.desktop.UncivWindowListener;
import com.unciv.logic.GameInfo;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/unciv/app/desktop/DesktopGame;", "Lcom/unciv/UncivGame;", "config", "Lcom/badlogic/gdx/backends/lwjgl3/Lwjgl3ApplicationConfiguration;", "customDataDirectory", "", "(Lcom/badlogic/gdx/backends/lwjgl3/Lwjgl3ApplicationConfiguration;Ljava/lang/String;)V", "getCustomDataDirectory", "()Ljava/lang/String;", "setCustomDataDirectory", "(Ljava/lang/String;)V", "discordUpdater", "Lcom/unciv/app/desktop/DiscordUpdater;", "windowListener", "Lcom/unciv/app/desktop/UncivWindowListener;", "dispose", "", "getSystemErrorMessage", "errorCode", "", "installAudioHooks", "notifyTurnStarted", "desktop"})
public final class DesktopGame
extends UncivGame {
    @Nullable
    private String customDataDirectory;
    @NotNull
    private DiscordUpdater discordUpdater;
    @NotNull
    private final UncivWindowListener windowListener;

    public DesktopGame(@NotNull Lwjgl3ApplicationConfiguration config2, @Nullable String customDataDirectory) {
        Intrinsics.checkNotNullParameter(config2, "config");
        super(false, 1, null);
        this.customDataDirectory = customDataDirectory;
        this.discordUpdater = new DiscordUpdater();
        this.windowListener = new UncivWindowListener();
        config2.setWindowListener(this.windowListener);
        this.discordUpdater.setOnUpdate(new Function0<DiscordGameInfo>(){

            @Override
            @Nullable
            public final DiscordGameInfo invoke() {
                if (!this.isInitialized()) {
                    return null;
                }
                DiscordGameInfo info2 = new DiscordGameInfo(null, null, 0, 7, null);
                GameInfo game = this.getGameInfo();
                if (game != null) {
                    info2.setGameTurn(game.getTurns());
                    info2.setGameLeader(game.getCurrentPlayerCivilization().getNation().getLeaderName());
                    info2.setGameNation(game.getCurrentPlayerCivilization().getNation().getName());
                }
                return info2;
            }
        });
        this.discordUpdater.startUpdates();
    }

    @Override
    @Nullable
    public String getCustomDataDirectory() {
        return this.customDataDirectory;
    }

    @Override
    public void setCustomDataDirectory(@Nullable String string) {
        this.customDataDirectory = string;
    }

    @Override
    public void installAudioHooks() {
        Application application = Gdx.app;
        Intrinsics.checkNotNull(application, "null cannot be cast to non-null type com.unciv.app.desktop.HardenGdxAudio");
        ((HardenGdxAudio)application).installHooks(this.getMusicController().getAudioLoopCallback(), this.getMusicController().getAudioExceptionHandler());
    }

    @Override
    public void notifyTurnStarted() {
        this.windowListener.turnStarted();
    }

    @Override
    public void dispose() {
        this.discordUpdater.stopUpdates();
        super.dispose();
    }

    @Override
    @Nullable
    public String getSystemErrorMessage(int errorCode) {
        String string;
        try {
            String string2 = System.getProperty("os.name");
            string = (string2 != null ? StringsKt.contains$default((CharSequence)string2, "Windows", false, 2, null) : false) ? Kernel32Util.formatMessage(errorCode) : null;
        }
        catch (Throwable _) {
            string = null;
        }
        return string;
    }
}

