/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.app.desktop;

import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import com.badlogic.gdx.utils.Os;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import com.unciv.UncivGame;
import com.unciv.app.desktop.DesktopDisplay;
import com.unciv.app.desktop.DesktopFont;
import com.unciv.app.desktop.DesktopGame;
import com.unciv.app.desktop.DesktopLogBackend;
import com.unciv.app.desktop.DesktopSaverLoader;
import com.unciv.app.desktop.DesktopScreenMode;
import com.unciv.app.desktop.HardenGdxAudio;
import com.unciv.app.desktop.ImagePacker;
import com.unciv.app.desktop.LinuxX11SaverLoader;
import com.unciv.app.desktop.UiElementDocsWriter;
import com.unciv.app.desktop.UniqueDocsWriter;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.files.PlatformSaverLoader;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.validation.RulesetError;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.models.ruleset.validation.RulesetValidator;
import com.unciv.models.ruleset.validation.UniqueAutoUpdater;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.utils.Display;
import com.unciv.utils.Log;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Taskbar;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.Configuration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/unciv/app/desktop/DesktopLauncher;", "", "()V", "main", "", "arg", "", "", "([Ljava/lang/String;)V", "updateDockIconForMacOs", "fileName", "desktop"})
@SourceDebugExtension(value={"SMAP\nDesktopLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopLauncher.kt\ncom/unciv/app/desktop/DesktopLauncher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1747#2,3:144\n1#3:147\n*S KotlinDebug\n*F\n+ 1 DesktopLauncher.kt\ncom/unciv/app/desktop/DesktopLauncher\n*L\n54#1:144,3\n*E\n"})
public final class DesktopLauncher {
    @NotNull
    public static final DesktopLauncher INSTANCE = new DesktopLauncher();

    private DesktopLauncher() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] arg) {
        String string;
        String customDataDirPrefix;
        block13: {
            Intrinsics.checkNotNullParameter(arg, "arg");
            if (!(arg.length == 0) && Intrinsics.areEqual(arg[0], "mod-ci")) {
                boolean bl;
                block12: {
                    ImagePacker.packImagesPerMod$default(ImagePacker.INSTANCE, ".", ".", null, 4, null);
                    Ruleset ruleset2 = new Ruleset();
                    ruleset2.setFolderLocation(new FileHandle("."));
                    FileHandle jsonsFolder = new FileHandle("jsons");
                    if (jsonsFolder.exists()) {
                        RulesetCache.INSTANCE.loadRulesets(true, true);
                        ruleset2.load(jsonsFolder);
                    }
                    UniqueAutoUpdater.autoupdateUniques$default(UniqueAutoUpdater.INSTANCE, ruleset2, null, 2, null);
                    RulesetErrorList errors = new RulesetValidator(ruleset2).getErrorList(true);
                    System.out.println((Object)errors.getErrorText(true));
                    Iterable $this$any$iv = errors;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            RulesetError rulesetError = (RulesetError)element$iv;
                            boolean bl2 = false;
                            if (!(rulesetError.getErrorSeverityToReport() == RulesetErrorSeverity.Error)) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                System.exit(bl ? 1 : 0);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            if (!(arg.length == 0) && Intrinsics.areEqual(arg[0], "--version")) {
                System.out.println((Object)UncivGame.Companion.getVERSION().getText());
                System.exit(0);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            if (SharedLibraryLoader.os == Os.MacOsX) {
                Configuration.GLFW_LIBRARY_NAME.set("glfw_async");
                GraphicsEnvironment.getLocalGraphicsEnvironment();
            }
            customDataDirPrefix = "--data-dir=";
            String[] $i$f$any = arg;
            int element$iv = $i$f$any.length;
            for (int i = 0; i < element$iv; ++i) {
                String object2;
                String it = object2 = $i$f$any[i];
                boolean bl = false;
                if (!StringsKt.startsWith$default(it, customDataDirPrefix, false, 2, null)) continue;
                string = object2;
                break block13;
            }
            string = null;
        }
        String customDataDir = string != null ? StringsKt.removePrefix(string, (CharSequence)customDataDirPrefix) : null;
        Log.INSTANCE.setBackend(new DesktopLogBackend());
        Display.INSTANCE.setPlatform(new DesktopDisplay());
        Fonts.INSTANCE.setFontImplementation(new DesktopFont());
        UncivFiles.Companion.setSaverLoader(LinuxX11SaverLoader.Companion.isRequired() ? (PlatformSaverLoader)new LinuxX11SaverLoader() : (PlatformSaverLoader)new DesktopSaverLoader());
        UncivFiles.Companion.setPreferExternalStorage(false);
        System.setProperty("org.lwjgl.opengl.Display.allowSoftwareOpenGL", "true");
        String string2 = customDataDir;
        if (string2 == null) {
            string2 = ".";
        }
        String dataDirectory = string2;
        boolean isRunFromJAR = INSTANCE.getClass().getPackage().getSpecificationVersion() != null;
        ImagePacker.INSTANCE.packImages(isRunFromJAR, dataDirectory);
        Lwjgl3ApplicationConfiguration config2 = new Lwjgl3ApplicationConfiguration();
        String[] stringArray = new String[]{"ExtraImages/Icons/Unciv32.png", "ExtraImages/Icons/Unciv128.png"};
        config2.setWindowIcon(stringArray);
        if (SharedLibraryLoader.os == Os.MacOsX) {
            INSTANCE.updateDockIconForMacOs("ExtraImages/Icons/Unciv128.png");
        }
        config2.setTitle("Unciv");
        config2.setHdpiMode(HdpiMode.Logical);
        config2.setWindowSizeLimits(120, 80, -1, -1);
        Rectangle maximumWindowBounds = DesktopScreenMode.Companion.getMaximumWindowBounds$desktop$default(DesktopScreenMode.Companion, null, 1, null);
        GameSettings settings = UncivFiles.Companion.getSettingsForPlatformLaunchers(dataDirectory);
        if (settings.isFreshlyCreated()) {
            settings.setScreenSize(GameSettings.ScreenSize.Large);
            settings.setWindowState(new GameSettings.WindowState(maximumWindowBounds));
            new FileHandle(dataDirectory + File.separator + "GameSettings.json").writeString(UncivJsonKt.json().toJson(settings), false, Charsets.UTF_8.name());
        }
        GameSettings.WindowState windowState = settings.getWindowState().coerceIn(maximumWindowBounds);
        int width = windowState.component1();
        int height = windowState.component2();
        config2.setWindowedMode(width, height);
        config2.setInitialBackgroundColor(BaseScreen.Companion.getClearColor());
        if (!isRunFromJAR) {
            new UniqueDocsWriter().write();
            new UiElementDocsWriter().write();
        }
        new HardenGdxAudio(new DesktopGame(config2, customDataDir), config2);
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void updateDockIconForMacOs(String fileName) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Intrinsics.checkNotNullExpressionValue(toolkit, "getDefaultToolkit(...)");
            Toolkit defaultToolkit = toolkit;
            URL uRL = new FileHandle(fileName).file().toURI().toURL();
            Intrinsics.checkNotNullExpressionValue(uRL, "toURL(...)");
            URL imageResource = uRL;
            Image image2 = defaultToolkit.getImage(imageResource);
            Intrinsics.checkNotNullExpressionValue(image2, "getImage(...)");
            Image image3 = image2;
            Taskbar taskbar = Taskbar.getTaskbar();
            taskbar.setIconImage(image3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

