/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic;

import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameStarter;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.managers.PolicyManager;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.civilization.managers.UnitManager;
import com.unciv.logic.files.MapSaver;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.MapGenerator;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.metadata.GameSetupInfo;
import com.unciv.models.metadata.Player;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J.\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J:\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\u0004H\u0002J<\u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\"\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020%0$j\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020%`&2\u0006\u0010\u000b\u001a\u00020\fH\u0002JH\u0010'\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(0\u001e2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\"\u0010-\u001a\u001e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(0$j\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(`&H\u0002JL\u0010.\u001a\u0004\u0018\u00010%2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020%0\u001b2\"\u0010-\u001a\u001e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(0$j\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(`&H\u0002J$\u00100\u001a\b\u0012\u0004\u0012\u00020\u00190\u00142\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00190\u00142\u0006\u0010+\u001a\u00020,H\u0002J>\u00102\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00104\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J2\u00105\u001a\b\u0012\u0004\u0012\u00020%0\u001b2\u0006\u0010+\u001a\u00020,2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(0\u001e2\u0006\u00107\u001a\u00020*H\u0002JJ\u00108\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020%0\u001b2\"\u0010-\u001a\u001e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(0$j\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(`&H\u0002Jr\u00109\u001a\u001e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020%0$j\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020%`&2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00190\u00142\u0006\u0010+\u001a\u00020,2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(0\u001e2\"\u0010-\u001a\u001e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(0$j\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(`&H\u0002Jx\u0010:\u001a\"\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020%\u0018\u00010$j\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020%\u0018\u0001`&2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00190\u00142\u0006\u0010+\u001a\u00020,2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020%0\u001b2\"\u0010-\u001a\u001e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(0$j\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020(`&2\u0006\u00107\u001a\u00020*H\u0002J.\u0010<\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010=\u001a\u00020\u001cH\u0002JJ\u0010>\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010?\u001a\u00020%2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00104\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u0010\u0010@\u001a\u00020\b2\u0006\u0010?\u001a\u00020%H\u0002J\u001e\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\u001c2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\b0DH\u0002J\u000e\u0010E\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/unciv/logic/GameStarter;", "", "()V", "consoleTimings", "", "gameSetupInfo", "Lcom/unciv/models/metadata/GameSetupInfo;", "addCivPolicies", "", "gameInfo", "Lcom/unciv/logic/GameInfo;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "addCivStartingUnits", "addCivStats", "addCivTechs", "addCivilizations", "newGameParameters", "Lcom/unciv/models/metadata/GameParameters;", "chosenPlayers", "", "Lcom/unciv/models/metadata/Player;", "addPlayerIntros", "adjustStartingUnitsForCityStatesAndOneCityChallenge", "civ", "Lcom/unciv/logic/civilization/Civilization;", "startingUnits", "", "", "settlerLikeUnits", "", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "chooseCivilizations", "existingMap", "determineStartingUnitsAndLocations", "startingLocations", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/collections/HashMap;", "getCandidateLand", "", "civCount", "", "tileMap", "Lcom/unciv/logic/map/TileMap;", "startScores", "getCivStartingLocation", "freeTiles", "getCivsOrderedByAvailableLocations", "civs", "getEquivalentUnit", "unitParam", "eraUnitReplacement", "getFreeTiles", "landTilesInBigEnoughGroup", "minimumDistanceBetweenStartingLocations", "getOneStartingLocation", "getStartingLocations", "getStartingLocationsForCivs", "civsOrderedByAvailableLocations", "getStartingUnitsForEraAndDifficulty", "startingEra", "placeStartingUnits", "startingLocation", "removeAncientRuinsNearStartingLocation", "runAndMeasure", "text", "action", "Lkotlin/Function0;", "startNewGame", "core"})
@SourceDebugExtension(value={"SMAP\nGameStarter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameStarter.kt\ncom/unciv/logic/GameStarter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,671:1\n288#2,2:672\n766#2:674\n857#2,2:675\n1855#2,2:677\n766#2:679\n857#2,2:680\n766#2:682\n857#2,2:683\n766#2:685\n857#2,2:686\n1549#2:688\n1620#2,3:689\n766#2:699\n857#2,2:700\n1774#2,4:702\n766#2:706\n857#2,2:707\n1054#2:709\n766#2:710\n857#2,2:711\n819#2:713\n847#2,2:714\n1549#2:717\n1620#2,3:718\n766#2:721\n857#2,2:722\n766#2:724\n857#2,2:725\n766#2:734\n857#2,2:735\n766#2:737\n857#2,2:738\n766#2:754\n857#2,2:755\n766#2:757\n857#2,2:758\n1045#2:768\n1054#2:769\n1747#2,3:771\n766#2:775\n857#2:776\n858#2:779\n766#2:780\n857#2:781\n858#2:784\n526#3:692\n511#3,6:693\n526#3:727\n511#3,6:728\n526#3:740\n511#3,6:741\n526#3:747\n511#3,6:748\n526#3:761\n511#3,6:762\n614#4:716\n614#4:760\n603#4:770\n614#4:774\n1247#4,2:777\n1247#4,2:782\n*S KotlinDebug\n*F\n+ 1 GameStarter.kt\ncom/unciv/logic/GameStarter\n*L\n46#1:672,2\n159#1:674\n159#1:675,2\n162#1:677,2\n178#1:679\n178#1:680,2\n208#1:682\n208#1:683,2\n232#1:685\n232#1:686,2\n248#1:688\n248#1:689,3\n262#1:699\n262#1:700,2\n276#1:702,4\n286#1:706\n286#1:707,2\n288#1:709\n313#1:710\n313#1:711,2\n314#1:713\n314#1:714,2\n360#1:717\n360#1:718,3\n396#1:721\n396#1:722,2\n401#1:724\n401#1:725,2\n435#1:734\n435#1:735,2\n446#1:737\n446#1:738,2\n502#1:754\n502#1:755,2\n510#1:757\n510#1:758,2\n568#1:768\n576#1:769\n640#1:771,3\n654#1:775\n654#1:776\n654#1:779\n661#1:780\n661#1:781\n661#1:784\n253#1:692\n253#1:693,6\n433#1:727\n433#1:728,6\n476#1:740\n476#1:741,6\n484#1:747\n484#1:748,6\n545#1:761\n545#1:762,6\n341#1:716\n534#1:760\n584#1:770\n644#1:774\n655#1:777,2\n662#1:782,2\n*E\n"})
public final class GameStarter {
    @NotNull
    public static final GameStarter INSTANCE = new GameStarter();
    private static final boolean consoleTimings = false;
    private static GameSetupInfo gameSetupInfo;

    private GameStarter() {
    }

    @NotNull
    public final GameInfo startNewGame(@NotNull GameSetupInfo gameSetupInfo) {
        TileMap tileMap;
        TileMap tileMap2;
        TileMap tileMap3;
        Object v1;
        Ref.ObjectRef<TileMap> tileMap4;
        GameInfo gameInfo;
        block15: {
            Intrinsics.checkNotNullParameter(gameSetupInfo, "gameSetupInfo");
            GameStarter.gameSetupInfo = gameSetupInfo;
            gameInfo = new GameInfo();
            tileMap4 = new Ref.ObjectRef<TileMap>();
            CollectionsKt.removeAll((Iterable)gameSetupInfo.getGameParameters().getMods(), (Function1)startNewGame.1.INSTANCE);
            Iterable $this$firstOrNull$iv = gameSetupInfo.getGameParameters().getMods();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Object object = RulesetCache.INSTANCE.get((Object)it);
                Intrinsics.checkNotNull(object);
                if (!((Ruleset)object).getModOptions().isBaseRuleset()) continue;
                v1 = element$iv;
                break block15;
            }
            v1 = null;
        }
        String baseRulesetInMods = v1;
        if (baseRulesetInMods != null) {
            gameSetupInfo.getGameParameters().setBaseRuleset(baseRulesetInMods);
        }
        if (!RulesetCache.INSTANCE.containsKey((Object)gameSetupInfo.getGameParameters().getBaseRuleset())) {
            gameSetupInfo.getGameParameters().setBaseRuleset(RulesetCache.INSTANCE.getVanillaRuleset().getName());
        }
        gameInfo.setGameParameters(gameSetupInfo.getGameParameters());
        Ruleset ruleset2 = RulesetCache.INSTANCE.getComplexRuleset(gameInfo.getGameParameters());
        MapGenerator mapGen = new MapGenerator(ruleset2, null, 2, null);
        if (!ruleset2.getSpeeds().containsKey(gameSetupInfo.getGameParameters().getSpeed())) {
            GameParameters gameParameters = gameSetupInfo.getGameParameters();
            Set<String> set2 = ruleset2.getSpeeds().keySet();
            Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
            gameParameters.setSpeed((String)CollectionsKt.first((Iterable)set2));
        }
        Ref.ObjectRef<List<Player>> phaseOneChosenCivs = new Ref.ObjectRef<List<Player>>();
        phaseOneChosenCivs.element = CollectionsKt.emptyList();
        if (!Intrinsics.areEqual(gameSetupInfo.getMapParameters().getName(), "")) {
            this.runAndMeasure("loadMap", new Function0<Unit>(tileMap4, gameSetupInfo, phaseOneChosenCivs, gameInfo, ruleset2){
                final /* synthetic */ Ref.ObjectRef<TileMap> $tileMap;
                final /* synthetic */ GameSetupInfo $gameSetupInfo;
                final /* synthetic */ Ref.ObjectRef<List<Player>> $phaseOneChosenCivs;
                final /* synthetic */ GameInfo $gameInfo;
                final /* synthetic */ Ruleset $ruleset;
                {
                    this.$tileMap = $tileMap;
                    this.$gameSetupInfo = $gameSetupInfo;
                    this.$phaseOneChosenCivs = $phaseOneChosenCivs;
                    this.$gameInfo = $gameInfo;
                    this.$ruleset = $ruleset;
                    super(0);
                }

                public final void invoke() {
                    FileHandle fileHandle = this.$gameSetupInfo.getMapFile();
                    Intrinsics.checkNotNull(fileHandle);
                    this.$tileMap.element = MapSaver.INSTANCE.loadMap(fileHandle);
                    this.$phaseOneChosenCivs.element = GameStarter.access$chooseCivilizations(GameStarter.INSTANCE, this.$gameSetupInfo.getGameParameters(), this.$gameInfo, this.$ruleset, true);
                }
            });
        } else {
            this.runAndMeasure("generateMap", new Function0<Unit>(phaseOneChosenCivs, gameSetupInfo, gameInfo, ruleset2, tileMap4, mapGen){
                final /* synthetic */ Ref.ObjectRef<List<Player>> $phaseOneChosenCivs;
                final /* synthetic */ GameSetupInfo $gameSetupInfo;
                final /* synthetic */ GameInfo $gameInfo;
                final /* synthetic */ Ruleset $ruleset;
                final /* synthetic */ Ref.ObjectRef<TileMap> $tileMap;
                final /* synthetic */ MapGenerator $mapGen;
                {
                    this.$phaseOneChosenCivs = $phaseOneChosenCivs;
                    this.$gameSetupInfo = $gameSetupInfo;
                    this.$gameInfo = $gameInfo;
                    this.$ruleset = $ruleset;
                    this.$tileMap = $tileMap;
                    this.$mapGen = $mapGen;
                    super(0);
                }

                public final void invoke() {
                    TileMap tileMap;
                    this.$phaseOneChosenCivs.element = GameStarter.access$chooseCivilizations(GameStarter.INSTANCE, this.$gameSetupInfo.getGameParameters(), this.$gameInfo, this.$ruleset, false);
                    GameStarter.access$addCivilizations(GameStarter.INSTANCE, this.$gameSetupInfo.getGameParameters(), this.$gameInfo, this.$ruleset, (List)this.$phaseOneChosenCivs.element);
                    this.$tileMap.element = this.$mapGen.generateMap(this.$gameSetupInfo.getMapParameters(), this.$gameSetupInfo.getGameParameters(), this.$gameInfo.getCivilizations());
                    if (this.$tileMap.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("tileMap");
                        tileMap = null;
                    } else {
                        tileMap = (TileMap)this.$tileMap.element;
                    }
                    tileMap.setMapParameters(this.$gameSetupInfo.getMapParameters());
                    this.$gameInfo.getCivilizations().clear();
                }
            });
        }
        this.runAndMeasure("addCivilizations", new Function0<Unit>(gameInfo, tileMap4, gameSetupInfo, ruleset2, phaseOneChosenCivs){
            final /* synthetic */ GameInfo $gameInfo;
            final /* synthetic */ Ref.ObjectRef<TileMap> $tileMap;
            final /* synthetic */ GameSetupInfo $gameSetupInfo;
            final /* synthetic */ Ruleset $ruleset;
            final /* synthetic */ Ref.ObjectRef<List<Player>> $phaseOneChosenCivs;
            {
                this.$gameInfo = $gameInfo;
                this.$tileMap = $tileMap;
                this.$gameSetupInfo = $gameSetupInfo;
                this.$ruleset = $ruleset;
                this.$phaseOneChosenCivs = $phaseOneChosenCivs;
                super(0);
            }

            public final void invoke() {
                TileMap tileMap;
                TileMap tileMap2;
                if (this.$tileMap.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("tileMap");
                    tileMap2 = null;
                } else {
                    tileMap2 = (TileMap)this.$tileMap.element;
                }
                this.$gameInfo.setTileMap(tileMap2);
                if (this.$tileMap.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("tileMap");
                    tileMap = null;
                } else {
                    tileMap = (TileMap)this.$tileMap.element;
                }
                tileMap.setGameInfo(this.$gameInfo);
                GameStarter.access$addCivilizations(GameStarter.INSTANCE, this.$gameSetupInfo.getGameParameters(), this.$gameInfo, this.$ruleset, (List)this.$phaseOneChosenCivs.element);
            }
        });
        this.runAndMeasure("Remove units", new Function0<Unit>(tileMap4, gameInfo, ruleset2){
            final /* synthetic */ Ref.ObjectRef<TileMap> $tileMap;
            final /* synthetic */ GameInfo $gameInfo;
            final /* synthetic */ Ruleset $ruleset;
            {
                this.$tileMap = $tileMap;
                this.$gameInfo = $gameInfo;
                this.$ruleset = $ruleset;
                super(0);
            }

            public final void invoke() {
                TileMap tileMap;
                if (this.$tileMap.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("tileMap");
                    tileMap = null;
                } else {
                    tileMap = (TileMap)this.$tileMap.element;
                }
                for (Tile tile : tileMap.getValues()) {
                    Iterator<MapUnit> iterator2 = tile.getUnits().iterator();
                    while (iterator2.hasNext()) {
                        boolean bl;
                        MapUnit unit;
                        block7: {
                            unit = iterator2.next();
                            Iterable $this$none$iv = this.$gameInfo.getCivilizations();
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (T element$iv : $this$none$iv) {
                                    Civilization it = (Civilization)element$iv;
                                    boolean bl2 = false;
                                    if (!Intrinsics.areEqual(it.getCivName(), unit.getOwner())) continue;
                                    bl = false;
                                    break block7;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) continue;
                        unit.setCurrentTile(tile);
                        unit.setTransients(this.$ruleset);
                        unit.removeFromTile();
                    }
                }
            }
        });
        if (tileMap4.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileMap");
            tileMap3 = null;
        } else {
            tileMap3 = (TileMap)tileMap4.element;
        }
        if (tileMap3.getContinentSizes().isEmpty()) {
            this.runAndMeasure("assignContinents", new Function0<Unit>(tileMap4){
                final /* synthetic */ Ref.ObjectRef<TileMap> $tileMap;
                {
                    this.$tileMap = $tileMap;
                    super(0);
                }

                public final void invoke() {
                    TileMap tileMap;
                    if (this.$tileMap.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("tileMap");
                        tileMap = null;
                    } else {
                        tileMap = (TileMap)this.$tileMap.element;
                    }
                    tileMap.assignContinents(TileMap.AssignContinentsMode.Ensure);
                }
            });
        }
        this.runAndMeasure("setTransients", new Function0<Unit>(gameInfo, tileMap4, ruleset2, gameSetupInfo){
            final /* synthetic */ GameInfo $gameInfo;
            final /* synthetic */ Ref.ObjectRef<TileMap> $tileMap;
            final /* synthetic */ Ruleset $ruleset;
            final /* synthetic */ GameSetupInfo $gameSetupInfo;
            {
                this.$gameInfo = $gameInfo;
                this.$tileMap = $tileMap;
                this.$ruleset = $ruleset;
                this.$gameSetupInfo = $gameSetupInfo;
                super(0);
            }

            public final void invoke() {
                TileMap tileMap;
                TileMap tileMap2;
                this.$gameInfo.setHistoryStartTurn(0);
                if (this.$tileMap.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("tileMap");
                    tileMap2 = null;
                } else {
                    tileMap2 = (TileMap)this.$tileMap.element;
                }
                TileMap.setTransients$default(tileMap2, this.$ruleset, false, 2, null);
                if (this.$tileMap.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("tileMap");
                    tileMap = null;
                } else {
                    tileMap = (TileMap)this.$tileMap.element;
                }
                tileMap.setStartingLocationsTransients();
                this.$gameInfo.setDifficulty(this.$gameSetupInfo.getGameParameters().getDifficulty());
                this.$gameInfo.setTransients();
            }
        });
        this.runAndMeasure("addCivStartingUnits", new Function0<Unit>(gameInfo){
            final /* synthetic */ GameInfo $gameInfo;
            {
                this.$gameInfo = $gameInfo;
                super(0);
            }

            public final void invoke() {
                GameStarter.access$addCivStartingUnits(GameStarter.INSTANCE, this.$gameInfo);
            }
        });
        this.runAndMeasure("Policies", new Function0<Unit>(gameInfo, ruleset2){
            final /* synthetic */ GameInfo $gameInfo;
            final /* synthetic */ Ruleset $ruleset;
            {
                this.$gameInfo = $gameInfo;
                this.$ruleset = $ruleset;
                super(0);
            }

            public final void invoke() {
                GameStarter.access$addCivPolicies(GameStarter.INSTANCE, this.$gameInfo, this.$ruleset);
            }
        });
        this.runAndMeasure("Techs and Stats", new Function0<Unit>(gameInfo, ruleset2, gameSetupInfo){
            final /* synthetic */ GameInfo $gameInfo;
            final /* synthetic */ Ruleset $ruleset;
            final /* synthetic */ GameSetupInfo $gameSetupInfo;
            {
                this.$gameInfo = $gameInfo;
                this.$ruleset = $ruleset;
                this.$gameSetupInfo = $gameSetupInfo;
                super(0);
            }

            public final void invoke() {
                GameStarter.access$addCivTechs(GameStarter.INSTANCE, this.$gameInfo, this.$ruleset, this.$gameSetupInfo);
            }
        });
        this.runAndMeasure("Starting stats", new Function0<Unit>(gameInfo){
            final /* synthetic */ GameInfo $gameInfo;
            {
                this.$gameInfo = $gameInfo;
                super(0);
            }

            public final void invoke() {
                GameStarter.access$addCivStats(GameStarter.INSTANCE, this.$gameInfo);
            }
        });
        if (tileMap4.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileMap");
            tileMap2 = null;
        } else {
            tileMap2 = (TileMap)tileMap4.element;
        }
        tileMap2.clearStartingLocations();
        if (tileMap4.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileMap");
            tileMap = null;
        } else {
            tileMap = (TileMap)tileMap4.element;
        }
        Object object = tileMap.getValues().iterator();
        while (object.hasNext()) {
            Tile tile = object.next();
            Iterator<MapUnit> bl = tile.getUnits().iterator();
            while (bl.hasNext()) {
                MapUnit unit = bl.next();
                unit.setCurrentMovement(MapUnit.getMaxMovement$default(unit, false, 1, null));
            }
        }
        this.addPlayerIntros(gameInfo);
        Object $this$startNewGame_u24lambda_u241 = object = UncivGame.Companion.getCurrent().getSettings();
        boolean bl = false;
        ((GameSettings)$this$startNewGame_u24lambda_u241).setLastGameSetup(gameSetupInfo);
        ((GameSettings)$this$startNewGame_u24lambda_u241).save();
        return gameInfo;
    }

    private final void runAndMeasure(String text2, Function0<Unit> action2) {
        action2.invoke();
    }

    /*
     * WARNING - void declaration
     */
    private final void addPlayerIntros(GameInfo gameInfo) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = gameInfo.getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            boolean bl2 = it.getPlayerType() == PlayerType.Human && ((CharSequence)it.getNation().getStartIntroPart1()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Civilization it = (Civilization)element$iv;
            boolean bl = false;
            it.getPopupAlerts().add(new PopupAlert(AlertType.StartIntro, ""));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCivTechs(GameInfo gameInfo, Ruleset ruleset2, GameSetupInfo gameSetupInfo) {
        for (Civilization civInfo : gameInfo.getCivilizations()) {
            void $this$filterTo$iv$iv;
            if (civInfo.isBarbarian()) continue;
            Collection<Technology> collection = ruleset2.getTechnologies().values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable iterable = collection;
            boolean $i$f$filter = false;
            Iterable iterable2 = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Technology it = (Technology)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.StartingTech, null, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (Technology technology2 : (List)destination$iv$iv) {
                GameStarter.addCivTechs$addTechSilently(civInfo, ruleset2, technology2.getName());
            }
            if (!civInfo.isHuman()) {
                for (String string : gameInfo.getDifficulty().getAiFreeTechs()) {
                    Intrinsics.checkNotNull(string);
                    GameStarter.addCivTechs$addTechSilently(civInfo, ruleset2, string);
                }
            }
            Iterator<Object> iterator2 = Civilization.getMatchingUniques$default(civInfo, UniqueType.StartsWithTech, null, 2, null).iterator();
            while (iterator2.hasNext()) {
                Unique unique = (Unique)iterator2.next();
                GameStarter.addCivTechs$addTechSilently(civInfo, ruleset2, unique.getParams().get(0));
            }
            if (civInfo.isSpectator()) {
                for (Technology technology3 : ruleset2.getTechnologies().values()) {
                    GameStarter.addCivTechs$addTechSilently(civInfo, ruleset2, technology3.getName());
                }
            }
            Era era2 = ruleset2.getEras().get(gameSetupInfo.getGameParameters().getStartingEra());
            Intrinsics.checkNotNull(era2);
            int startingEraNumber = era2.getEraNumber();
            for (Technology tech : ruleset2.getTechnologies().values()) {
                Era era3 = ruleset2.getEras().get(tech.era());
                Intrinsics.checkNotNull(era3);
                if (era3.getEraNumber() >= startingEraNumber) continue;
                TechManager techManager = civInfo.getTech();
                Intrinsics.checkNotNull(tech);
                if (techManager.isUnresearchable(tech)) continue;
                GameStarter.addCivTechs$addTechSilently(civInfo, ruleset2, tech.getName());
            }
            civInfo.getPopupAlerts().clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCivPolicies(GameInfo gameInfo, Ruleset ruleset2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = gameInfo.getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBarbarian())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Civilization civInfo : (List)destination$iv$iv) {
            Iterator iterator2 = Civilization.getMatchingUniques$default(civInfo, UniqueType.StartsWithPolicy, null, 2, null).iterator();
            while (iterator2.hasNext()) {
                Policy policyToAdopt2;
                Unique unique = (Unique)iterator2.next();
                String policyName = unique.getParams().get(0);
                if (!ruleset2.getPolicies().containsKey(policyName) || civInfo.getPolicies().isAdopted(policyName)) continue;
                Intrinsics.checkNotNull(ruleset2.getPolicies().get(policyName));
                PolicyManager $this$addCivPolicies_u24lambda_u246 = civInfo.getPolicies();
                boolean bl = false;
                int n = $this$addCivPolicies_u24lambda_u246.getFreePolicies();
                $this$addCivPolicies_u24lambda_u246.setFreePolicies(n + 1);
                PolicyManager.adopt$default($this$addCivPolicies_u24lambda_u246, policyToAdopt2, false, 2, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCivStats(GameInfo gameInfo) {
        void $this$filterTo$iv$iv;
        Ruleset ruleSet = gameInfo.getRuleset();
        String startingEra = gameInfo.getGameParameters().getStartingEra();
        Era era2 = ruleSet.getEras().get(startingEra);
        Intrinsics.checkNotNull(era2);
        Era era3 = era2;
        Iterable $this$filter$iv = gameInfo.getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBarbarian() && !it.isSpectator())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Civilization civInfo : (List)destination$iv$iv) {
            civInfo.addGold((int)((float)era3.getStartingGold() * gameInfo.getSpeed().getGoldCostModifier()));
            civInfo.getPolicies().addCulture((int)((float)era3.getStartingCulture() * gameInfo.getSpeed().getCultureCostModifier()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Player> chooseCivilizations(GameParameters newGameParameters, GameInfo gameInfo, Ruleset ruleset2, boolean existingMap) {
        void $this$sortedByDescending$iv;
        int n;
        void $this$filterNotTo$iv$iv;
        void $this$filterTo$iv$iv;
        Player it;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv;
        Set<Object> set2;
        Iterable $this$filterTo$iv$iv3;
        Sequence sequence;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List chosenPlayers = new ArrayList();
        int dequeCapacity = ruleset2.getNations().size();
        Iterable iterable = newGameParameters.getPlayers();
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Player player = (Player)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it2.getChosenCiv());
        }
        Set<String> selectedPlayerNames = CollectionsKt.toSet((List)destination$iv$iv);
        GameSetupInfo gameSetupInfo = GameStarter.gameSetupInfo;
        if (gameSetupInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
            gameSetupInfo = null;
        }
        if (gameSetupInfo.getGameParameters().getEnableRandomNationsPool()) {
            GameSetupInfo gameSetupInfo2 = GameStarter.gameSetupInfo;
            if (gameSetupInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                gameSetupInfo2 = null;
            }
            sequence = CollectionsKt.asSequence((Iterable)gameSetupInfo2.getGameParameters().getRandomNationsPool());
        } else {
            Object item$iv$iv;
            Map $this$filter$iv2 = ruleset2.getNations();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            item$iv$iv = $this$filterTo$iv$iv3.entrySet().iterator();
            while (item$iv$iv.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it3 = element$iv$iv = (Map.Entry)item$iv$iv.next();
                boolean bl = false;
                if (!(((Nation)it3.getValue()).isMajorCiv() && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it3.getValue(), UniqueType.WillNotBeChosenForNewGames, null, 2, null))) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            sequence = CollectionsKt.asSequence(destination$iv$iv2.keySet());
        }
        ArrayDeque randomNationsPool2 = (ArrayDeque)SequencesKt.toCollection(SequencesKt.shuffled(SequencesKt.filter(sequence, (Function1)new Function1<String, Boolean>(selectedPlayerNames){
            final /* synthetic */ Set<String> $selectedPlayerNames;
            {
                this.$selectedPlayerNames = $selectedPlayerNames;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !this.$selectedPlayerNames.contains(it);
            }
        })), (Collection)new ArrayDeque(dequeCapacity));
        if (existingMap) {
            Set<String> set3 = gameInfo.getTileMap().getStartingLocationsByNation().keySet();
            set2 = set3;
            Intrinsics.checkNotNullExpressionValue(set3, "<get-keys>(...)");
        } else {
            set2 = SetsKt.emptySet();
        }
        Set civNamesWithStartingLocations = set2;
        $this$filterTo$iv$iv3 = randomNationsPool2;
        boolean $i$f$filter = false;
        void $i$f$filterTo = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it4 = (String)element$iv$iv;
            boolean bl = false;
            if (!civNamesWithStartingLocations.contains(it4)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        ArrayDeque presetRandomNationsPool = (ArrayDeque)CollectionsKt.toCollection(CollectionsKt.shuffled((List)destination$iv$iv3), (Collection)new ArrayDeque(dequeCapacity));
        randomNationsPool2.removeAll(presetRandomNationsPool);
        int extraRandomAIPlayers = 0;
        Ref.ObjectRef<List<Player>> selectedAIToSkip = new Ref.ObjectRef<List<Player>>();
        selectedAIToSkip.element = CollectionsKt.emptyList();
        if (newGameParameters.getRandomNumberOfPlayers()) {
            int n2;
            int min = RangesKt.coerceAtMost(newGameParameters.getMinNumberOfPlayers(), newGameParameters.getMaxNumberOfPlayers());
            int max = RangesKt.coerceAtLeast(newGameParameters.getMaxNumberOfPlayers(), newGameParameters.getMinNumberOfPlayers());
            Iterable $this$count$iv = newGameParameters.getPlayers();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (Player)element$iv;
                    boolean bl = false;
                    if (!(it.getPlayerType() == PlayerType.Human || it.getChosenCiv() == "Spectator") || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int nonAICount = n2;
            int desiredNumberOfPlayers = RangesKt.random(new IntRange(RangesKt.coerceAtLeast(min, nonAICount), RangesKt.coerceAtLeast(max, nonAICount)), (Random)Random.Default);
            if (desiredNumberOfPlayers > newGameParameters.getPlayers().size()) {
                extraRandomAIPlayers = desiredNumberOfPlayers - newGameParameters.getPlayers().size();
            } else if (desiredNumberOfPlayers < newGameParameters.getPlayers().size()) {
                void $this$sortedByDescending$iv2;
                void $this$filterTo$iv$iv4;
                Iterable $this$filter$iv3;
                Object element$iv;
                int extraPlayers = newGameParameters.getPlayers().size() - desiredNumberOfPlayers;
                Iterable count$iv = newGameParameters.getPlayers();
                object = selectedAIToSkip;
                boolean $i$f$filter2 = false;
                element$iv = $this$filter$iv3;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv4) {
                    Player it5 = (Player)element$iv$iv;
                    boolean bl = false;
                    if (!(it5.getPlayerType() == PlayerType.AI)) continue;
                    destination$iv$iv4.add(element$iv$iv);
                }
                $this$filter$iv3 = CollectionsKt.shuffled((List)destination$iv$iv4);
                boolean $i$f$sortedByDescending = false;
                ((Ref.ObjectRef)object).element = CollectionsKt.sortedWith($this$sortedByDescending$iv2, new Comparator(){

                    public final int compare(T a, T b) {
                        Player it = (Player)b;
                        boolean bl = false;
                        Comparable comparable = Boolean.valueOf(Intrinsics.areEqual(it.getChosenCiv(), "Random"));
                        it = (Player)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, Intrinsics.areEqual(it.getChosenCiv(), "Random"));
                    }
                }).subList(0, extraPlayers);
            }
        }
        Comparator min = new Comparator(){

            public final int compare(T a, T b) {
                Player it = (Player)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(Intrinsics.areEqual(it.getChosenCiv(), "Random"));
                it = (Player)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, Intrinsics.areEqual(it.getChosenCiv(), "Random"));
            }
        };
        SequencesKt.toCollection(SequencesKt.mapNotNull(SequencesKt.plus(SequencesKt.sortedWith(SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)newGameParameters.getPlayers()), (Function1)new Function1<Player, Boolean>(selectedAIToSkip){
            final /* synthetic */ Ref.ObjectRef<List<Player>> $selectedAIToSkip;
            {
                this.$selectedAIToSkip = $selectedAIToSkip;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Player it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return ((List)this.$selectedAIToSkip.element).contains(it);
            }
        }), new Comparator(min){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Player it = (Player)a;
                    boolean bl = false;
                    boolean bl2 = it.getPlayerType() == PlayerType.AI;
                    it = (Player)b;
                    Comparable comparable = Boolean.valueOf(bl2);
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable, it.getPlayerType() == PlayerType.AI);
                }
                return n;
            }
        }), SequencesKt.map(CollectionsKt.asSequence(RangesKt.until(0, extraRandomAIPlayers)), chooseCivilizations.6.INSTANCE)), (Function1)new Function1<Player, Player>((ArrayDeque<String>)presetRandomNationsPool, (ArrayDeque<String>)randomNationsPool2){
            final /* synthetic */ ArrayDeque<String> $presetRandomNationsPool;
            final /* synthetic */ ArrayDeque<String> $randomNationsPool;
            {
                this.$presetRandomNationsPool = $presetRandomNationsPool;
                this.$randomNationsPool = $randomNationsPool;
                super(1);
            }

            @Nullable
            public final Player invoke(@NotNull Player it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !Intrinsics.areEqual(it.getChosenCiv(), "Random") ? it : (!((Collection)this.$presetRandomNationsPool).isEmpty() ? new Player(this.$presetRandomNationsPool.removeLast(), it.getPlayerType(), it.getPlayerId()) : (!((Collection)this.$randomNationsPool).isEmpty() ? new Player(this.$randomNationsPool.removeLast(), it.getPlayerType(), it.getPlayerId()) : null));
            }
        }), (Collection)chosenPlayers);
        Iterable $this$filter$iv4 = chosenPlayers;
        boolean $i$f$filter3 = false;
        Iterable desiredNumberOfPlayers = $this$filter$iv4;
        Iterable destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterTo4 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Player)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getChosenCiv(), "Spectator")) continue;
            destination$iv$iv5.add(element$iv$iv);
        }
        List spectators = (List)destination$iv$iv5;
        Iterable $this$filterNot$iv = chosenPlayers;
        boolean $i$f$filterNot = false;
        destination$iv$iv5 = $this$filterNot$iv;
        Collection destination$iv$iv6 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Player it6 = (Player)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual(it6.getChosenCiv(), "Spectator")) continue;
            destination$iv$iv6.add(element$iv$iv);
        }
        List otherPlayers = CollectionsKt.toMutableList((List)destination$iv$iv6);
        if (newGameParameters.getShufflePlayerOrder()) {
            Collections.shuffle(otherPlayers);
        }
        chosenPlayers.clear();
        chosenPlayers.addAll(spectators);
        chosenPlayers.addAll(otherPlayers);
        if (newGameParameters.getRandomNumberOfCityStates()) {
            int min2 = RangesKt.coerceAtMost(newGameParameters.getMinNumberOfCityStates(), newGameParameters.getMaxNumberOfCityStates());
            int max = RangesKt.coerceAtLeast(newGameParameters.getMaxNumberOfCityStates(), newGameParameters.getMinNumberOfCityStates());
            n = RangesKt.random(new IntRange(min2, max), (Random)Random.Default);
        } else {
            n = newGameParameters.getNumberOfCityStates();
        }
        int numberOfCityStates = n;
        Sequence min2 = SequencesKt.shuffled(SequencesKt.map(SequencesKt.filter(MapsKt.asSequence((Map)ruleset2.getNations()), chooseCivilizations.8.INSTANCE), chooseCivilizations.9.INSTANCE));
        boolean $i$f$sortedByDescending = false;
        SequencesKt.toCollection(SequencesKt.map(SequencesKt.take(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(civNamesWithStartingLocations){
            final /* synthetic */ Set $civNamesWithStartingLocations$inlined;
            {
                this.$civNamesWithStartingLocations$inlined = set2;
            }

            public final int compare(T a, T b) {
                String it = (String)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(this.$civNamesWithStartingLocations$inlined.contains(it));
                it = (String)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, this.$civNamesWithStartingLocations$inlined.contains(it));
            }
        }), numberOfCityStates), chooseCivilizations.11.INSTANCE), (Collection)chosenPlayers);
        return chosenPlayers;
    }

    /*
     * WARNING - void declaration
     */
    private final void addCivilizations(GameParameters newGameParameters, GameInfo gameInfo, Ruleset ruleset2, List<Player> chosenPlayers) {
        void $this$mapTo$iv$iv;
        if (!newGameParameters.getNoBarbarians() && ruleset2.getNations().containsKey("Barbarians")) {
            Civilization barbarianCivilization = new Civilization("Barbarians");
            gameInfo.getCivilizations().add(barbarianCivilization);
        }
        Iterable $this$map$iv = chosenPlayers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Player player = (Player)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getChosenCiv());
        }
        Set<String> usedCivNames = CollectionsKt.toSet((List)destination$iv$iv);
        Sequence<String> usedMajorCivs2 = SequencesKt.filter(SequencesKt.map(SequencesKt.filter(MapsKt.asSequence((Map)ruleset2.getNations()), addCivilizations.usedMajorCivs.1.INSTANCE), addCivilizations.usedMajorCivs.2.INSTANCE), (Function1)new Function1<String, Boolean>(usedCivNames){
            final /* synthetic */ Set<String> $usedCivNames;
            {
                this.$usedCivNames = $usedCivNames;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$usedCivNames.contains(it);
            }
        });
        for (Player player : chosenPlayers) {
            Civilization civ = new Civilization(player.getChosenCiv());
            String string = player.getChosenCiv();
            if (SequencesKt.contains(usedMajorCivs2, string) ? true : Intrinsics.areEqual(string, "Spectator")) {
                civ.setPlayerType(player.getPlayerType());
                civ.setPlayerId(player.getPlayerId());
            } else if (!civ.getCityStateFunctions().initCityState(ruleset2, newGameParameters.getStartingEra(), usedMajorCivs2)) continue;
            gameInfo.getCivilizations().add(civ);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCivStartingUnits(GameInfo gameInfo) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Ruleset ruleSet = gameInfo.getRuleset();
        TileMap tileMap = gameInfo.getTileMap();
        Object object = new TileImprovement[]{ruleSet.getTileImprovements().get("City center")};
        Unique unique = (Unique)SequencesKt.firstOrNull(SequencesKt.flatMap(SequencesKt.filterNotNull(SequencesKt.sequenceOf(object)), addCivStartingUnits.cityCenterMinStats.1.INSTANCE));
        Object cityCenterMinStats2 = unique != null && (object = unique.getStats()) != null ? object : Stats.Companion.getDefaultCityCenterMinimum();
        HashMap<Tile, Float> startScores = new HashMap<Tile, Float>(tileMap.getValues().size());
        for (Tile tile : tileMap.getValues()) {
            ((Map)startScores).put(tile, Float.valueOf(tile.getStats().getTileStartScore((Stats)cityCenterMinStats2)));
        }
        Iterable $this$filter$iv = gameInfo.getCivilizations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBarbarian())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allCivs = (List)destination$iv$iv;
        Map<Tile, Float> landTilesInBigEnoughGroup = this.getCandidateLand(allCivs.size(), tileMap, startScores);
        Set<String> set2 = tileMap.getStartingLocationsByNation().keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Set<String> civNamesWithStartingLocations = set2;
        Iterable $this$filter$iv2 = allCivs;
        boolean $i$f$filter2 = false;
        Map.Entry entry2 = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !(it.isCityState() && !civNamesWithStartingLocations.contains(it.getCivName()) || it.isSpectator());
            if (!bl2) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List bestCivs = (List)destination$iv$iv2;
        HashMap<Civilization, Tile> bestLocations = this.getStartingLocations(bestCivs, tileMap, landTilesInBigEnoughGroup, startScores);
        for (Map.Entry entry2 : ((Map)bestLocations).entrySet()) {
            Civilization civ = (Civilization)entry2.getKey();
            Tile tile = (Tile)entry2.getValue();
            tileMap.removeStartingLocations(civ.getCivName());
            TileMap.addStartingLocation$default(tileMap, civ.getCivName(), tile, null, 4, null);
        }
        HashMap<Civilization, Tile> startingLocations = this.getStartingLocations(allCivs, tileMap, landTilesInBigEnoughGroup, startScores);
        this.determineStartingUnitsAndLocations(gameInfo, startingLocations, ruleSet);
    }

    private final void removeAncientRuinsNearStartingLocation(Tile startingLocation) {
        Iterator<Tile> iterator2 = startingLocation.getTilesInDistance(3).iterator();
        while (iterator2.hasNext()) {
            Tile tile = iterator2.next();
            if (tile.getImprovement() == null) continue;
            TileImprovement tileImprovement = tile.getTileImprovement();
            Intrinsics.checkNotNull(tileImprovement);
            if (!tileImprovement.isAncientRuinsEquivalent()) continue;
            tile.removeImprovement();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void determineStartingUnitsAndLocations(GameInfo gameInfo, HashMap<Civilization, Tile> startingLocations, Ruleset ruleset2) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        String startingEra = gameInfo.getGameParameters().getStartingEra();
        Map $this$filter$iv = ruleset2.getUnits();
        boolean $i$f$filter = false;
        Map map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry it = entry = iterator2.next();
            boolean bl = false;
            if (!((BaseUnit)it.getValue()).isCityFounder()) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        Map settlerLikeUnits = destination$iv$iv;
        Iterable $this$filter$iv2 = gameInfo.getCivilizations();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Civilization it = (Civilization)element$iv$iv;
            boolean bl = false;
            if (!(!it.isBarbarian() && !it.isSpectator())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        for (Civilization civ : (List)destination$iv$iv2) {
            void $this$filterTo$iv$iv3;
            Tile startingLocation;
            Intrinsics.checkNotNull(startingLocations.get(civ));
            this.removeAncientRuinsNearStartingLocation(startingLocation);
            List<String> startingUnits = this.getStartingUnitsForEraAndDifficulty(civ, gameInfo, ruleset2, startingEra);
            this.adjustStartingUnitsForCityStatesAndOneCityChallenge(civ, gameInfo, startingUnits, settlerLikeUnits);
            Era era2 = ruleset2.getEras().get(startingEra);
            Intrinsics.checkNotNull(era2);
            this.placeStartingUnits(civ, startingLocation, startingUnits, ruleset2, era2.getStartingMilitaryUnit(), settlerLikeUnits);
            List startingTriggers = CollectionsKt.plus((Collection)ruleset2.getGlobalUniques().getUniqueObjects(), (Iterable)civ.getNation().getUniqueObjects());
            Iterable iterable = startingTriggers;
            boolean $i$f$filter3 = false;
            Iterable it = iterable;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                Unique it2 = (Unique)element$iv$iv;
                boolean bl = false;
                if (!(!it2.hasTriggerConditional() && it2.conditionalsApply(civ.getState()))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            for (Unique unique : (List)destination$iv$iv3) {
                UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, civ, null, null, startingLocation, null, null, 108, null);
            }
        }
    }

    private final List<String> getStartingUnitsForEraAndDifficulty(Civilization civ, GameInfo gameInfo, Ruleset ruleset2, String startingEra) {
        Object object = ruleset2.getEras().get(startingEra);
        if (object == null || (object = ((Era)object).getStartingUnits(ruleset2)) == null) {
            throw new Exception("Era " + startingEra + " does not exist in the ruleset!");
        }
        Object startingUnits = object;
        startingUnits.addAll((Collection)(civ.isHuman() ? gameInfo.getDifficulty().getPlayerBonusStartingUnits() : (civ.isMajorCiv() ? gameInfo.getDifficulty().getAiMajorCivBonusStartingUnits() : gameInfo.getDifficulty().getAiCityStateBonusStartingUnits())));
        return startingUnits;
    }

    /*
     * WARNING - void declaration
     */
    private final BaseUnit getEquivalentUnit(Civilization civ, String unitParam, Ruleset ruleset2, String eraUnitReplacement, Map<String, BaseUnit> settlerLikeUnits) {
        String unit = unitParam;
        if (Intrinsics.areEqual(unit, "Era Starting Unit")) {
            unit = eraUnitReplacement;
        }
        if (Intrinsics.areEqual(unit, "Settler") && !((Map)ruleset2.getUnits()).containsKey("Settler")) {
            void $this$filterTo$iv$iv;
            Map<String, BaseUnit> $this$filter$iv = settlerLikeUnits;
            boolean $i$f$filter = false;
            Map<String, BaseUnit> map2 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                boolean bl2 = ((BaseUnit)it.getValue()).isBuildable(civ) && ((BaseUnit)it.getValue()).isCivilian();
                if (!bl2) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map buildableSettlerLikeUnits = destination$iv$iv;
            if (buildableSettlerLikeUnits.isEmpty()) {
                return null;
            }
            return civ.getEquivalentUnit((String)CollectionsKt.random(buildableSettlerLikeUnits.keySet(), Random.Default));
        }
        if (Intrinsics.areEqual(unit, "Worker") && !((Map)ruleset2.getUnits()).containsKey("Worker")) {
            Map $this$filter$iv = ruleset2.getUnits();
            boolean $i$f$filter = false;
            Map $this$filterTo$iv$iv = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator3.next();
                boolean bl = false;
                boolean bl3 = IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it.getValue(), UniqueType.BuildImprovements, null, 2, null) && ((BaseUnit)it.getValue()).isBuildable(civ) && ((BaseUnit)it.getValue()).isCivilian();
                if (!bl3) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map buildableWorkerLikeUnits = destination$iv$iv;
            if (buildableWorkerLikeUnits.isEmpty()) {
                return null;
            }
            return civ.getEquivalentUnit((String)CollectionsKt.random(buildableWorkerLikeUnits.keySet(), Random.Default));
        }
        return civ.getEquivalentUnit(unit);
    }

    private final void adjustStartingUnitsForCityStatesAndOneCityChallenge(Civilization civ, GameInfo gameInfo, List<String> startingUnits, Map<String, BaseUnit> settlerLikeUnits) {
        List startingSettlers;
        String it;
        Iterable $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Collection destination$iv$iv;
        boolean $i$f$filter;
        Iterable $this$filter$iv;
        if (civ.isCityState() && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)gameInfo.getRuleset().getModOptions(), UniqueType.AllowCityStatesSpawnUnits, null, 2, null)) {
            $this$filter$iv = startingUnits;
            $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!settlerLikeUnits.containsKey(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            startingSettlers = (List)destination$iv$iv;
            startingUnits.clear();
            startingUnits.add((String)CollectionsKt.random(startingSettlers, Random.Default));
        }
        if (civ.getPlayerType() == PlayerType.Human && gameInfo.getGameParameters().getOneCityChallenge()) {
            $this$filter$iv = startingUnits;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (!settlerLikeUnits.containsKey(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            startingSettlers = (List)destination$iv$iv;
            startingUnits.removeAll(startingSettlers);
            startingUnits.add((String)CollectionsKt.random(startingSettlers, Random.Default));
        }
    }

    private final void placeStartingUnits(Civilization civ, Tile startingLocation, List<String> startingUnits, Ruleset ruleset2, String eraUnitReplacement, Map<String, BaseUnit> settlerLikeUnits) {
        for (String unit : startingUnits) {
            BaseUnit unitToAdd = this.getEquivalentUnit(civ, unit, ruleset2, eraUnitReplacement, settlerLikeUnits);
            if (unitToAdd == null) continue;
            UnitManager.placeUnitNearTile$default(civ.getUnits(), startingLocation.getPosition(), unitToAdd, null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Tile, Float> getCandidateLand(int civCount, TileMap tileMap, HashMap<Tile, Float> startScores) {
        void $this$filterTo$iv$iv;
        tileMap.assignContinents(TileMap.AssignContinentsMode.Ensure);
        Sequence $this$sortedByDescending$iv = MapsKt.asSequence((Map)tileMap.getContinentSizes());
        boolean $i$f$sortedByDescending = false;
        List orderedContinents = SequencesKt.toList(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getValue()));
            }
        }));
        Collection<Integer> collection = tileMap.getContinentSizes().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        int totalArea = CollectionsKt.sumOfInt((Iterable<Integer>)collection);
        int candidateArea = 0;
        HashSet candidateContinents = new HashSet();
        Iterator iterator2 = orderedContinents.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            Map.Entry continentSize = iterator2.next();
            candidateContinents.add(continentSize.getKey());
            if (!((float)(candidateArea += ((Number)continentSize.getValue()).intValue()) >= (float)totalArea * 0.9f) && index < civCount) continue;
        }
        Map $this$filter$iv = startScores;
        boolean $i$f$filter = false;
        Map index = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator3.next();
            boolean bl = false;
            if (!candidateContinents.contains(((Tile)it.getKey()).getContinent())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    private final HashMap<Civilization, Tile> getStartingLocations(List<Civilization> civs, TileMap tileMap, Map<Tile, Float> landTilesInBigEnoughGroup, HashMap<Tile, Float> startScores) {
        List<Civilization> civsOrderedByAvailableLocations = this.getCivsOrderedByAvailableLocations(civs, tileMap);
        for (int minimumDistanceBetweenStartingLocations = tileMap.getTileMatrix().size() / 6; -1 < minimumDistanceBetweenStartingLocations; --minimumDistanceBetweenStartingLocations) {
            HashMap<Civilization, Tile> startingLocations;
            List<Tile> freeTiles = this.getFreeTiles(tileMap, landTilesInBigEnoughGroup, minimumDistanceBetweenStartingLocations);
            HashMap<Civilization, Tile> hashMap = startingLocations = this.getStartingLocationsForCivs(civsOrderedByAvailableLocations, tileMap, freeTiles, startScores, minimumDistanceBetweenStartingLocations);
            if (hashMap == null) continue;
            return hashMap;
        }
        throw new Exception("Didn't manage to get starting tiles even with distance of 1?");
    }

    private final List<Civilization> getCivsOrderedByAvailableLocations(List<Civilization> civs, TileMap tileMap) {
        Iterable $this$sortedBy$iv = CollectionsKt.shuffled((Iterable)civs);
        boolean $i$f$sortedBy = false;
        Iterable $this$sortedByDescending$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(tileMap){
            final /* synthetic */ TileMap $tileMap$inlined;
            {
                this.$tileMap$inlined = tileMap;
            }

            /*
             * Unable to fully structure code
             */
            public final int compare(T a, T b) {
                block23: {
                    block25: {
                        block24: {
                            block17: {
                                block22: {
                                    block19: {
                                        block21: {
                                            block20: {
                                                block16: {
                                                    block18: {
                                                        civ = (Civilization)a;
                                                        $i$a$-sortedBy-GameStarter$getCivsOrderedByAvailableLocations$1 = false;
                                                        if (!((Map)this.$tileMap$inlined.getStartingLocationsByNation()).containsKey(civ.getCivName())) break block18;
                                                        v0 = 1;
                                                        break block19;
                                                    }
                                                    $this$any$iv = civ.getNation().getStartBias();
                                                    $i$f$any = false;
                                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                        v1 = false;
                                                    } else {
                                                        for (T element$iv : $this$any$iv) {
                                                            it = (String)element$iv;
                                                            $i$a$-any-GameStarter$getCivsOrderedByAvailableLocations$1$1 = false;
                                                            if (!this.$tileMap$inlined.getNaturalWonders().contains(it)) continue;
                                                            v1 = true;
                                                            break block16;
                                                        }
                                                        v1 = false;
                                                    }
                                                }
                                                if (!v1) break block20;
                                                v2 = GameStarter.access$getGameSetupInfo$p();
                                                if (v2 == null) {
                                                    Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                                                    v2 = null;
                                                }
                                                if (v2.getGameParameters().getNoStartBias()) break block20;
                                                v0 = 2;
                                                break block19;
                                            }
                                            if (!civ.getNation().getStartBias().contains("Tundra")) break block21;
                                            v3 = GameStarter.access$getGameSetupInfo$p();
                                            if (v3 == null) {
                                                Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                                                v3 = null;
                                            }
                                            if (v3.getGameParameters().getNoStartBias()) break block21;
                                            v0 = 3;
                                            break block19;
                                        }
                                        if (!(((Collection)civ.getNation().getStartBias()).isEmpty() == false)) ** GOTO lbl-1000
                                        v4 = GameStarter.access$getGameSetupInfo$p();
                                        if (v4 == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                                            v4 = null;
                                        }
                                        if (!v4.getGameParameters().getNoStartBias()) {
                                            v0 = 4;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v0 = 5;
                                        }
                                    }
                                    civ = (Civilization)b;
                                    var11_11 = Integer.valueOf(v0);
                                    $i$a$-sortedBy-GameStarter$getCivsOrderedByAvailableLocations$1 = false;
                                    if (!((Map)this.$tileMap$inlined.getStartingLocationsByNation()).containsKey(civ.getCivName())) break block22;
                                    v5 = 1;
                                    break block23;
                                }
                                $this$any$iv = civ.getNation().getStartBias();
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    v6 = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        it = (String)element$iv;
                                        $i$a$-any-GameStarter$getCivsOrderedByAvailableLocations$1$1 = false;
                                        if (!this.$tileMap$inlined.getNaturalWonders().contains(it)) continue;
                                        v6 = true;
                                        break block17;
                                    }
                                    v6 = false;
                                }
                            }
                            if (!v6) break block24;
                            v7 = GameStarter.access$getGameSetupInfo$p();
                            if (v7 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                                v7 = null;
                            }
                            if (v7.getGameParameters().getNoStartBias()) break block24;
                            v5 = 2;
                            break block23;
                        }
                        if (!civ.getNation().getStartBias().contains("Tundra")) break block25;
                        v8 = GameStarter.access$getGameSetupInfo$p();
                        if (v8 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                            v8 = null;
                        }
                        if (v8.getGameParameters().getNoStartBias()) break block25;
                        v5 = 3;
                        break block23;
                    }
                    if (!(((Collection)civ.getNation().getStartBias()).isEmpty() == false)) ** GOTO lbl-1000
                    v9 = GameStarter.access$getGameSetupInfo$p();
                    if (v9 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                        v9 = null;
                    }
                    if (!v9.getGameParameters().getNoStartBias()) {
                        v5 = 4;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = 5;
                    }
                }
                return ComparisonsKt.compareValues(var11_11, v5);
            }
        });
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Civilization it = (Civilization)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.isHuman());
                it = (Civilization)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.isHuman());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<Tile> getFreeTiles(TileMap tileMap, Map<Tile, Float> landTilesInBigEnoughGroup, int minimumDistanceBetweenStartingLocations) {
        void $this$sortedBy$iv;
        Sequence<Map.Entry<Tile, Float>> sequence = SequencesKt.filter(MapsKt.asSequence(landTilesInBigEnoughGroup), (Function1)new Function1<Map.Entry<? extends Tile, ? extends Float>, Boolean>(tileMap, minimumDistanceBetweenStartingLocations){
            final /* synthetic */ TileMap $tileMap;
            final /* synthetic */ int $minimumDistanceBetweenStartingLocations;
            {
                this.$tileMap = $tileMap;
                this.$minimumDistanceBetweenStartingLocations = $minimumDistanceBetweenStartingLocations;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<Tile, Float> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return HexMath.INSTANCE.getDistanceFromEdge(it.getKey().getPosition(), this.$tileMap.getMapParameters()) >= this.$minimumDistanceBetweenStartingLocations * 2 / 3;
            }
        });
        boolean $i$f$sortedBy = false;
        return SequencesKt.toMutableList(SequencesKt.map(SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Float)it.getValue();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)it.getValue()));
            }
        }), getFreeTiles.3.INSTANCE));
    }

    private final HashMap<Civilization, Tile> getStartingLocationsForCivs(List<Civilization> civsOrderedByAvailableLocations, TileMap tileMap, List<Tile> freeTiles, HashMap<Tile, Float> startScores, int minimumDistanceBetweenStartingLocations) {
        Civilization civ;
        Tile startingLocation;
        HashMap<Civilization, Tile> startingLocations = new HashMap<Civilization, Tile>();
        Iterator<Civilization> iterator2 = civsOrderedByAvailableLocations.iterator();
        while (iterator2.hasNext() && (startingLocation = this.getCivStartingLocation(civ = iterator2.next(), tileMap, freeTiles, startScores)) != null) {
            ((Map)startingLocations).put(civ, startingLocation);
            int distanceToNext = minimumDistanceBetweenStartingLocations / (civ.isCityState() ? 2 : 1);
            freeTiles.removeAll((Collection)SequencesKt.toSet(tileMap.getTilesInDistance(startingLocation.getPosition(), distanceToNext)));
        }
        return startingLocations.size() < civsOrderedByAvailableLocations.size() ? null : startingLocations;
    }

    private final Tile getCivStartingLocation(Civilization civ, TileMap tileMap, List<Tile> freeTiles, HashMap<Tile, Float> startScores) {
        Tile startingLocation;
        HashSet<Tile> hashSet = tileMap.getStartingLocationsByNation().get(civ.getCivName());
        Tile tile = startingLocation = hashSet != null ? (Tile)CollectionsKt.randomOrNull((Collection)hashSet, Random.Default) : null;
        if (startingLocation == null) {
            HashSet<Tile> hashSet2 = tileMap.getStartingLocationsByNation().get("Spectator");
            Tile tile2 = startingLocation = hashSet2 != null ? (Tile)CollectionsKt.randomOrNull((Collection)hashSet2, Random.Default) : null;
            if (startingLocation != null) {
                HashSet<Tile> hashSet3 = tileMap.getStartingLocationsByNation().get("Spectator");
                if (hashSet3 != null) {
                    hashSet3.remove(startingLocation);
                }
            }
        }
        if (startingLocation == null && !((Collection)freeTiles).isEmpty()) {
            startingLocation = this.getOneStartingLocation(civ, tileMap, freeTiles, startScores);
        }
        return startingLocation;
    }

    /*
     * WARNING - void declaration
     */
    private final Tile getOneStartingLocation(Civilization civ, TileMap tileMap, List<Tile> freeTiles, HashMap<Tile, Float> startScores) {
        boolean bl;
        block17: {
            GameSetupInfo gameSetupInfo = GameStarter.gameSetupInfo;
            if (gameSetupInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException("gameSetupInfo");
                gameSetupInfo = null;
            }
            if (gameSetupInfo.getGameParameters().getNoStartBias()) {
                return (Tile)CollectionsKt.random((Collection)freeTiles, Random.Default);
            }
            Iterable $this$any$iv = civ.getNation().getStartBias();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!tileMap.getNaturalWonders().contains(it)) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$sortedByDescending$iv;
            Sequence $i$f$any = SequencesKt.filter(CollectionsKt.asSequence((Iterable)tileMap.getValues()), (Function1)new Function1<Tile, Boolean>(civ){
                final /* synthetic */ Civilization $civ;
                {
                    this.$civ = $civ;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (it.isNaturalWonder()) {
                        ArrayList<String> arrayList = this.$civ.getNation().getStartBias();
                        String string = it.getNaturalWonder();
                        Intrinsics.checkNotNull(string);
                        if (arrayList.contains(string)) {
                            bl = true;
                            return bl;
                        }
                    }
                    bl = false;
                    return bl;
                }
            });
            boolean $i$f$sortedByDescending = false;
            Tile wonderNeighbor2 = (Tile)SequencesKt.firstOrNull(SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(startScores){
                final /* synthetic */ HashMap $startScores$inlined;
                {
                    this.$startScores$inlined = hashMap;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)b;
                    boolean bl = false;
                    Comparable comparable = (Float)this.$startScores$inlined.get(it);
                    it = (Tile)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Float)this.$startScores$inlined.get(it)));
                }
            }));
            if (wonderNeighbor2 != null) {
                return wonderNeighbor2;
            }
        }
        List preferredTiles = CollectionsKt.toList((Iterable)freeTiles);
        for (String startBias : civ.getNation().getStartBias()) {
            List list2;
            Intrinsics.checkNotNull(startBias);
            if (TranslationsKt.equalsPlaceholderText(startBias, "Avoid []")) {
                void $this$filterTo$iv$iv;
                String tileToAvoid = TranslationsKt.getPlaceholderParameters(startBias).get(0);
                Iterable $this$filter$iv = preferredTiles;
                boolean $i$f$filter2 = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl3;
                    block18: {
                        Tile tile = (Tile)element$iv$iv;
                        boolean bl4 = false;
                        Sequence<Tile> $this$any$iv = tile.getTilesInDistance(1);
                        boolean $i$f$any = false;
                        Iterator<Tile> iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            Tile element$iv;
                            Tile it = element$iv = iterator2.next();
                            boolean bl5 = false;
                            if (!Tile.matchesTerrainFilter$default(it, tileToAvoid, null, false, 4, null)) continue;
                            bl3 = true;
                            break block18;
                        }
                        bl3 = false;
                    }
                    boolean bl6 = !bl3;
                    if (!bl6) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else if (tileMap.getNaturalWonders().contains(startBias)) {
                list2 = preferredTiles;
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = preferredTiles;
                boolean $i$f$filter = false;
                Iterable $i$f$filter2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl7;
                    block19: {
                        Tile tile = (Tile)element$iv$iv;
                        boolean bl8 = false;
                        Sequence<Tile> $this$any$iv = tile.getTilesInDistance(1);
                        boolean $i$f$any = false;
                        Iterator<Tile> iterator3 = $this$any$iv.iterator();
                        while (iterator3.hasNext()) {
                            Tile element$iv;
                            Tile it = element$iv = iterator3.next();
                            boolean bl9 = false;
                            if (!Tile.matchesTerrainFilter$default(it, startBias, null, false, 4, null)) continue;
                            bl7 = true;
                            break block19;
                        }
                        bl7 = false;
                    }
                    if (!bl7) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            }
            preferredTiles = list2;
        }
        Tile tile = (Tile)CollectionsKt.randomOrNull(preferredTiles, Random.Default);
        if (tile == null) {
            tile = (Tile)CollectionsKt.random((Collection)freeTiles, Random.Default);
        }
        return tile;
    }

    private static final void addCivTechs$addTechSilently(Civilization $this$addCivTechs_u24addTechSilently, Ruleset $ruleset, String name2) {
        if (!$ruleset.getTechnologies().containsKey(name2)) {
            return;
        }
        if ($this$addCivTechs_u24addTechSilently.getTech().isResearched(name2)) {
            return;
        }
        $this$addCivTechs_u24addTechSilently.getTech().addTechnology(name2, false);
    }

    public static final /* synthetic */ List access$chooseCivilizations(GameStarter $this, GameParameters newGameParameters, GameInfo gameInfo, Ruleset ruleset2, boolean existingMap) {
        return $this.chooseCivilizations(newGameParameters, gameInfo, ruleset2, existingMap);
    }

    public static final /* synthetic */ void access$addCivilizations(GameStarter $this, GameParameters newGameParameters, GameInfo gameInfo, Ruleset ruleset2, List chosenPlayers) {
        $this.addCivilizations(newGameParameters, gameInfo, ruleset2, chosenPlayers);
    }

    public static final /* synthetic */ void access$addCivStartingUnits(GameStarter $this, GameInfo gameInfo) {
        $this.addCivStartingUnits(gameInfo);
    }

    public static final /* synthetic */ void access$addCivPolicies(GameStarter $this, GameInfo gameInfo, Ruleset ruleset2) {
        $this.addCivPolicies(gameInfo, ruleset2);
    }

    public static final /* synthetic */ void access$addCivTechs(GameStarter $this, GameInfo gameInfo, Ruleset ruleset2, GameSetupInfo gameSetupInfo) {
        $this.addCivTechs(gameInfo, ruleset2, gameSetupInfo);
    }

    public static final /* synthetic */ void access$addCivStats(GameStarter $this, GameInfo gameInfo) {
        $this.addCivStats(gameInfo);
    }

    public static final /* synthetic */ GameSetupInfo access$getGameSetupInfo$p() {
        return gameSetupInfo;
    }
}

