/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic;

import com.unciv.logic.HolidayDates;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/unciv/logic/HolidayDates;", "", "()V", "getHolidayByDate", "Lcom/unciv/logic/HolidayDates$Holidays;", "date", "Ljava/time/LocalDate;", "getHolidayByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "holiday", "year", "", "getMonth", "Ljava/time/Month;", "closestWeekday", "day", "Ljava/time/DayOfWeek;", "DateRange", "Holidays", "Tables", "core"})
@SourceDebugExtension(value={"SMAP\nHolidayDates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n288#2,2:397\n*S KotlinDebug\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates\n*L\n156#1:397,2\n*E\n"})
public final class HolidayDates {
    @NotNull
    public static final HolidayDates INSTANCE = new HolidayDates();

    private HolidayDates() {
    }

    @NotNull
    public final DateRange getHolidayByYear(@NotNull Holidays holiday, int year2) {
        Intrinsics.checkNotNullParameter((Object)holiday, "holiday");
        return holiday.getByYear(year2);
    }

    @Nullable
    public final Holidays getHolidayByDate(@NotNull LocalDate date) {
        Object object;
        block4: {
            Object v2;
            block2: {
                block3: {
                    Intrinsics.checkNotNullParameter(date, "date");
                    object = System.getProperty("easterEgg");
                    if (object == null) break block3;
                    String it = object;
                    boolean bl = false;
                    Holidays holidays = Holidays.Companion.safeValueOf(it);
                    object = holidays;
                    if (holidays != null) break block4;
                }
                Iterable $this$firstOrNull$iv = Holidays.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Holidays it = (Holidays)((Object)element$iv);
                    boolean bl = false;
                    DateRange range = it.getByYear(date.getYear());
                    if (!(range.contains((Comparable)date) && Random.Default.nextFloat() <= it.getChance())) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            object = v2;
        }
        return object;
    }

    public static /* synthetic */ Holidays getHolidayByDate$default(HolidayDates holidayDates, LocalDate localDate, int n, Object object) {
        if ((n & 1) != 0) {
            LocalDate localDate2 = LocalDate.now();
            Intrinsics.checkNotNullExpressionValue(localDate2, "now(...)");
            localDate = localDate2;
        }
        return holidayDates.getHolidayByDate(localDate);
    }

    @NotNull
    public final Month getMonth() {
        Month month;
        Month month2;
        Month month3;
        Object object = System.getProperty("month");
        if (object != null && (object = StringsKt.toIntOrNull((String)object)) != null) {
            int it = ((Number)object).intValue();
            boolean bl = false;
            month3 = Month.of(it);
        } else {
            month3 = month2 = null;
        }
        if (month2 == null) {
            Month month4 = LocalDate.now().getMonth();
            month = month4;
            Intrinsics.checkNotNullExpressionValue(month4, "getMonth(...)");
        } else {
            month = month2;
        }
        return month;
    }

    private final LocalDate closestWeekday(LocalDate $this$closestWeekday, DayOfWeek day2) {
        LocalDate localDate;
        int delta = (7 + $this$closestWeekday.getDayOfWeek().ordinal() - day2.ordinal()) % 7;
        if (delta < 4) {
            LocalDate localDate2 = $this$closestWeekday.plusDays(delta);
            localDate = localDate2;
            Intrinsics.checkNotNullExpressionValue(localDate2, "plusDays(...)");
        } else {
            LocalDate localDate3 = $this$closestWeekday.minusDays(7 - delta);
            localDate = localDate3;
            Intrinsics.checkNotNullExpressionValue(localDate3, "minusDays(...)");
        }
        return localDate;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/unciv/logic/HolidayDates$DateRange;", "Lkotlin/ranges/ClosedRange;", "Ljava/time/LocalDate;", "start", "endInclusive", "(Ljava/time/LocalDate;Ljava/time/LocalDate;)V", "getEndInclusive", "()Ljava/time/LocalDate;", "length", "", "getLength", "()I", "getStart", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "core"})
    public static class DateRange
    implements ClosedRange<LocalDate> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final LocalDate start;
        @NotNull
        private final LocalDate endInclusive;
        @NotNull
        private static final DateRange never;

        public DateRange(@NotNull LocalDate start2, @NotNull LocalDate endInclusive) {
            Intrinsics.checkNotNullParameter(start2, "start");
            Intrinsics.checkNotNullParameter(endInclusive, "endInclusive");
            this.start = start2;
            this.endInclusive = endInclusive;
        }

        @Override
        @NotNull
        public LocalDate getStart() {
            return this.start;
        }

        @Override
        @NotNull
        public LocalDate getEndInclusive() {
            return this.endInclusive;
        }

        public final int getLength() {
            return RangesKt.coerceAtLeast((int)this.getStart().until(this.getEndInclusive(), ChronoUnit.DAYS), 0);
        }

        @NotNull
        public String toString() {
            return this.getStart() + ".." + this.getEndInclusive();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DateRange)) {
                return false;
            }
            return Intrinsics.areEqual(this.getStart(), ((DateRange)other).getStart()) && Intrinsics.areEqual(this.getEndInclusive(), ((DateRange)other).getEndInclusive());
        }

        public int hashCode() {
            return 31 * this.getStart().hashCode() + this.getEndInclusive().hashCode();
        }

        @Override
        public boolean contains(@NotNull LocalDate value) {
            return ClosedRange.DefaultImpls.contains(this, (Comparable)value);
        }

        @Override
        public boolean isEmpty() {
            return ClosedRange.DefaultImpls.isEmpty(this);
        }

        static {
            LocalDate localDate = LocalDate.now();
            Intrinsics.checkNotNullExpressionValue(localDate, "now(...)");
            LocalDate localDate2 = LocalDate.now().plusDays(-1L);
            Intrinsics.checkNotNullExpressionValue(localDate2, "plusDays(...)");
            never = new DateRange(localDate, localDate2);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bJ&\u0010\u0007\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/unciv/logic/HolidayDates$DateRange$Companion;", "", "()V", "never", "Lcom/unciv/logic/HolidayDates$DateRange;", "getNever", "()Lcom/unciv/logic/HolidayDates$DateRange;", "of", "date", "Ljava/time/LocalDate;", "duration", "", "year", "month", "day", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DateRange of(@NotNull LocalDate date) {
                Intrinsics.checkNotNullParameter(date, "date");
                return new DateRange(date, date);
            }

            @NotNull
            public final DateRange of(int year2, int month, int day2) {
                LocalDate localDate = LocalDate.of(year2, month, day2);
                Intrinsics.checkNotNullExpressionValue(localDate, "of(...)");
                return this.of(localDate);
            }

            @NotNull
            public final DateRange of(@NotNull LocalDate date, int duration) {
                Intrinsics.checkNotNullParameter(date, "date");
                LocalDate localDate = date.plusDays((long)duration - 1L);
                Intrinsics.checkNotNullExpressionValue(localDate, "plusDays(...)");
                return new DateRange(date, localDate);
            }

            @NotNull
            public final DateRange of(int year2, int month, int day2, int duration) {
                LocalDate localDate = LocalDate.of(year2, month, day2);
                Intrinsics.checkNotNullExpressionValue(localDate, "of(...)");
                return this.of(localDate, duration);
            }

            @NotNull
            public final DateRange getNever() {
                return never;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\b\u0086\u0081\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001aB\u0011\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays;", "", "chance", "", "(Ljava/lang/String;IF)V", "getChance", "()F", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "Easter", "Samhain", "Xmas", "DiaDeLosMuertos", "YuleGoat", "Qingming", "Diwali", "LunarNewYear", "AprilFoolsDay", "PrideDay", "TowelDay", "UncivBirthday", "Friday13th", "StarWarsDay", "Passover", "Companion", "core"})
    public static final abstract class Holidays
    extends Enum<Holidays> {
        @NotNull
        public static final Companion Companion;
        private final float chance;
        public static final /* enum */ Holidays Easter;
        public static final /* enum */ Holidays Samhain;
        public static final /* enum */ Holidays Xmas;
        public static final /* enum */ Holidays DiaDeLosMuertos;
        public static final /* enum */ Holidays YuleGoat;
        public static final /* enum */ Holidays Qingming;
        public static final /* enum */ Holidays Diwali;
        public static final /* enum */ Holidays LunarNewYear;
        public static final /* enum */ Holidays AprilFoolsDay;
        public static final /* enum */ Holidays PrideDay;
        public static final /* enum */ Holidays TowelDay;
        public static final /* enum */ Holidays UncivBirthday;
        public static final /* enum */ Holidays Friday13th;
        public static final /* enum */ Holidays StarWarsDay;
        public static final /* enum */ Holidays Passover;
        private static final /* synthetic */ Holidays[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Holidays(float chance) {
            this.chance = chance;
        }

        /* synthetic */ Holidays(String string, int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                f = 1.0f;
            }
            this(f);
        }

        public final float getChance() {
            return this.chance;
        }

        @NotNull
        public abstract DateRange getByYear(int var1);

        public static Holidays[] values() {
            return (Holidays[])$VALUES.clone();
        }

        public static Holidays valueOf(String value) {
            return Enum.valueOf(Holidays.class, value);
        }

        @NotNull
        public static EnumEntries<Holidays> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Holidays(String $enum$name, int $enum$ordinal, float chance, DefaultConstructorMarker $constructor_marker) {
            this(chance);
        }

        static {
            Easter = new Easter("Easter", 0);
            Samhain = new Samhain("Samhain", 1);
            Xmas = new Xmas("Xmas", 2);
            DiaDeLosMuertos = new DiaDeLosMuertos("DiaDeLosMuertos", 3);
            YuleGoat = new YuleGoat("YuleGoat", 4);
            Qingming = new Qingming("Qingming", 5);
            Diwali = new Diwali("Diwali", 6);
            LunarNewYear = new LunarNewYear("LunarNewYear", 7);
            AprilFoolsDay = new AprilFoolsDay("AprilFoolsDay", 8);
            PrideDay = new PrideDay("PrideDay", 9);
            TowelDay = new TowelDay("TowelDay", 10);
            UncivBirthday = new UncivBirthday("UncivBirthday", 11);
            Friday13th = new Friday13th("Friday13th", 12);
            StarWarsDay = new StarWarsDay("StarWarsDay", 13);
            Passover = new Passover("Passover", 14);
            $VALUES = holidaysArray = new Holidays[]{Holidays.Easter, Holidays.Samhain, Holidays.Xmas, Holidays.DiaDeLosMuertos, Holidays.YuleGoat, Holidays.Qingming, Holidays.Diwali, Holidays.LunarNewYear, Holidays.AprilFoolsDay, Holidays.PrideDay, Holidays.TowelDay, Holidays.UncivBirthday, Holidays.Friday13th, Holidays.StarWarsDay, Holidays.Passover};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$AprilFoolsDay;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class AprilFoolsDay
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            AprilFoolsDay() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 4, 1);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$Companion;", "", "()V", "safeValueOf", "Lcom/unciv/logic/HolidayDates$Holidays;", "name", "", "core"})
        @SourceDebugExtension(value={"SMAP\nHolidayDates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates$Holidays$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n288#2,2:397\n*S KotlinDebug\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates$Holidays$Companion\n*L\n126#1:397,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Holidays safeValueOf(@NotNull String name2) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter(name2, "name");
                    Iterable $this$firstOrNull$iv = Holidays.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Holidays it = (Holidays)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.name(), name2)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$DiaDeLosMuertos;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class DiaDeLosMuertos
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            DiaDeLosMuertos() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 11, 1, 2);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$Diwali;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Diwali
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Diwali() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                LocalDate localDate = Tables.INSTANCE.getDiwali().get(year2);
                if (localDate == null) {
                    return DateRange.Companion.getNever();
                }
                LocalDate knownValue = localDate;
                LocalDate localDate2 = knownValue.plusDays(-2L);
                Intrinsics.checkNotNullExpressionValue(localDate2, "plusDays(...)");
                return DateRange.Companion.of(localDate2, 5);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$Easter;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Easter
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Easter() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                int a = year2 % 19;
                int b = year2 / 100;
                int c = year2 % 100;
                int d = b / 4;
                int e = b % 4;
                int g = (8 * b + 13) / 25;
                int h = (19 * a + b - d - g + 15) % 30;
                int i = c / 4;
                int k = c % 4;
                int l = (32 + 2 * e + 2 * i - h - k) % 7;
                int m = (a + 11 * h + 19 * l) / 433;
                int n = (h + l - 7 * m + 90) / 25;
                int p = (h + l - 7 * m + 33 * n + 19) % 32;
                LocalDate sunday = LocalDate.of(year2, n, p);
                LocalDate localDate = sunday.minusDays(2L);
                Intrinsics.checkNotNullExpressionValue(localDate, "minusDays(...)");
                return DateRange.Companion.of(localDate, 4);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$Friday13th;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        @SourceDebugExtension(value={"SMAP\nHolidayDates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates$Holidays$Friday13th\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,396:1\n1549#2:397\n1620#2,3:398\n766#2:401\n857#2,2:402\n1#3:404\n*S KotlinDebug\n*F\n+ 1 HolidayDates.kt\ncom/unciv/logic/HolidayDates$Holidays$Friday13th\n*L\n101#1:397\n101#1:398,3\n102#1:401\n102#1:402,2\n*E\n"})
        static final class Friday13th
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Friday13th() {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                DateRange dateRange;
                void $this$filterTo$iv$iv;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = new IntRange(1, 12);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(LocalDate.of(year2, (int)it, 13));
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    LocalDate it = (LocalDate)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getDayOfWeek() == DayOfWeek.FRIDAY)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                LocalDate localDate = (LocalDate)CollectionsKt.randomOrNull((List)destination$iv$iv, Random.Default);
                if (localDate != null) {
                    LocalDate it = localDate;
                    boolean bl = false;
                    DateRange dateRange2 = DateRange.Companion.of(it);
                    if (dateRange2 != null) {
                        dateRange = dateRange2;
                        return dateRange;
                    }
                }
                dateRange = DateRange.Companion.getNever();
                return dateRange;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$LunarNewYear;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class LunarNewYear
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            LunarNewYear() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                LocalDate localDate = Tables.INSTANCE.getLunarNewYear().get(year2);
                if (localDate == null) {
                    return DateRange.Companion.getNever();
                }
                LocalDate knownValue = localDate;
                return DateRange.Companion.of(knownValue);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$Passover;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Passover
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Passover() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                LocalDate localDate = Tables.INSTANCE.getPassover().get(year2);
                if (localDate == null) {
                    return DateRange.Companion.getNever();
                }
                LocalDate knownValue = localDate;
                LocalDate localDate2 = knownValue.plusDays(-2L);
                Intrinsics.checkNotNullExpressionValue(localDate2, "plusDays(...)");
                return DateRange.Companion.of(localDate2, 5);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$PrideDay;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class PrideDay
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            PrideDay() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 6, 28, 3);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$Qingming;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Qingming
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Qingming() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                Instant instant = Tables.INSTANCE.getEquinoxes().get(year2);
                if (instant == null) {
                    return DateRange.Companion.getNever();
                }
                Instant springEquinoxInstant = instant;
                LocalDate springEquinox = springEquinoxInstant.atZone(ZoneId.systemDefault()).toLocalDate();
                LocalDate localDate = springEquinox.plusDays(15L);
                Intrinsics.checkNotNullExpressionValue(localDate, "plusDays(...)");
                return DateRange.Companion.of(localDate);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$Samhain;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Samhain
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Samhain() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 10, 31);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$StarWarsDay;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class StarWarsDay
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            StarWarsDay() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 5, 4);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$TowelDay;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class TowelDay
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            TowelDay() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 5, 25);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$UncivBirthday;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class UncivBirthday
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            UncivBirthday() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 11, 21);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$Xmas;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class Xmas
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            Xmas() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                return DateRange.Companion.of(year2, 12, 24, 4);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/logic/HolidayDates$Holidays$YuleGoat;", "Lcom/unciv/logic/HolidayDates$Holidays;", "getByYear", "Lcom/unciv/logic/HolidayDates$DateRange;", "year", "", "core"})
        static final class YuleGoat
        extends Holidays {
            /*
             * WARNING - void declaration
             */
            YuleGoat() {
                void var1_1;
            }

            @Override
            @NotNull
            public DateRange getByYear(int year2) {
                LocalDate localDate = LocalDate.of(year2, 11, 30);
                Intrinsics.checkNotNullExpressionValue(localDate, "of(...)");
                return DateRange.Companion.of(INSTANCE.closestWeekday(localDate, DayOfWeek.SUNDAY));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R/\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR/\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\r0\r0\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u000b\u001a\u0004\b\u000e\u0010\tR/\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000b\u001a\u0004\b\u0011\u0010\tR/\u0010\u0013\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000b\u001a\u0004\b\u0014\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/unciv/logic/HolidayDates$Tables;", "", "()V", "diwali", "", "", "Ljava/time/LocalDate;", "kotlin.jvm.PlatformType", "getDiwali", "()Ljava/util/Map;", "diwali$delegate", "Lkotlin/Lazy;", "equinoxes", "Ljava/time/Instant;", "getEquinoxes", "equinoxes$delegate", "lunarNewYear", "getLunarNewYear", "lunarNewYear$delegate", "passover", "getPassover", "passover$delegate", "core"})
    private static final class Tables {
        @NotNull
        public static final Tables INSTANCE = new Tables();
        @NotNull
        private static final Lazy equinoxes$delegate = LazyKt.lazy(equinoxes.2.INSTANCE);
        @NotNull
        private static final Lazy passover$delegate = LazyKt.lazy(passover.2.INSTANCE);
        @NotNull
        private static final Lazy diwali$delegate = LazyKt.lazy(diwali.2.INSTANCE);
        @NotNull
        private static final Lazy lunarNewYear$delegate = LazyKt.lazy(lunarNewYear.2.INSTANCE);

        private Tables() {
        }

        @NotNull
        public final Map<Integer, Instant> getEquinoxes() {
            Lazy lazy = equinoxes$delegate;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final Map<Integer, LocalDate> getPassover() {
            Lazy lazy = passover$delegate;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final Map<Integer, LocalDate> getDiwali() {
            Lazy lazy = diwali$delegate;
            return (Map)lazy.getValue();
        }

        @NotNull
        public final Map<Integer, LocalDate> getLunarNewYear() {
            Lazy lazy = lunarNewYear$delegate;
            return (Map)lazy.getValue();
        }
    }
}

