/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.UncivGame;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.unit.AirUnitAutomation;
import com.unciv.logic.automation.unit.BattleHelper;
import com.unciv.logic.automation.unit.CivilianUnitAutomation;
import com.unciv.logic.automation.unit.HeadTowardsEnemyCityAutomation;
import com.unciv.logic.automation.unit.UnitAutomation;
import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.BattleDamage;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.TargetHelper;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.managers.ThreatManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.UnitPromotions;
import com.unciv.logic.map.mapunit.UnitUpgradeManager;
import com.unciv.logic.map.mapunit.movement.PathsToTilesWithinTurn;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UnitAction;
import com.unciv.models.UpgradeUnitAction;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.AutoPlay;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsPillage;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsUpgrade;
import com.unciv.utils.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\"\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\"\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010#\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nJ\u0015\u0010$\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b%J\u0010\u0010&\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010'\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010(\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010)\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010*\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010+\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010,\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010-\u001a\u00020\rJ\u0010\u0010.\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010/\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u00100\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u00101\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0015\u00102\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b3J(\u00104\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u00105\u001a\u00020\r2\u000e\b\u0002\u00106\u001a\b\u0012\u0004\u0012\u00020\u001607R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/unciv/logic/automation/unit/UnitAutomation;", "", "()V", "CLOSE_ENEMY_TILES_AWAY_LIMIT", "", "CLOSE_ENEMY_TURNS_AWAY_LIMIT", "", "automateUnitMoves", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "automatedExplore", "canUnitHealInTurnsOnCurrentTile", "", "turns", "noEnemyDistance", "chooseBombardTarget", "Lcom/unciv/logic/battle/ICombatant;", "city", "Lcom/unciv/logic/city/City;", "getDangerousTiles", "Ljava/util/HashSet;", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/collections/HashSet;", "getUnitsToUpgradeTo", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "isCityThatNeedsDefendingInWartime", "isGoodTileForFogBusting", "tile", "isGoodTileToExplore", "tryAccompanySettlerOrGreatPerson", "tryAdvanceTowardsCloseEnemy", "tryAttacking", "tryBombardEnemy", "tryEnterOwnClosestCity", "tryExplore", "tryExplore$core", "tryFogBust", "tryGarrisoningRangedLandUnit", "tryGoToRuinAndEncampment", "tryHeadTowardsEncampment", "tryHeadTowardsOurSiegedCity", "tryHealUnit", "tryPillageImprovement", "onlyPillageToHeal", "tryPrepare", "tryRetreat", "tryStationingMeleeNavalUnit", "tryTakeBackCapturedCity", "tryUpgradeUnit", "tryUpgradeUnit$core", "wander", "stayInTerritory", "tilesToAvoid", "", "core"})
@SourceDebugExtension(value={"SMAP\nUnitAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitAutomation.kt\ncom/unciv/logic/automation/unit/UnitAutomation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,732:1\n1247#2,2:733\n1247#2,2:735\n1224#2,2:757\n1224#2,2:762\n1247#2,2:764\n1814#2,14:780\n179#2,2:797\n603#2:800\n179#2,2:801\n603#2:817\n614#2:818\n603#2:839\n179#2,2:840\n603#2:920\n179#2,2:921\n179#2,2:923\n1247#2,2:925\n603#2:927\n179#2,2:928\n603#2:930\n179#2,2:931\n759#2,2:933\n775#2,4:935\n603#2:946\n179#2,2:947\n603#2:952\n179#2,2:953\n179#2,2:968\n179#2,2:970\n2159#2,2:980\n1247#2,2:985\n766#3:737\n857#3,2:738\n1054#3:740\n1963#3,14:741\n288#3,2:755\n766#3:759\n857#3,2:760\n1747#3,3:794\n2333#3,14:803\n766#3:819\n857#3,2:820\n1477#3:822\n1502#3,3:823\n1505#3,3:833\n1726#3,3:836\n766#3:842\n857#3,2:843\n2333#3,14:845\n1963#3,14:859\n766#3:880\n857#3,2:881\n1963#3,14:883\n766#3:897\n857#3,2:898\n819#3:900\n847#3,2:901\n766#3:903\n857#3,2:904\n2333#3,14:906\n766#3:949\n857#3,2:950\n766#3:955\n857#3,2:956\n1549#3:958\n1620#3,3:959\n1360#3:962\n1446#3,5:963\n766#3:972\n857#3,2:973\n766#3:975\n857#3,2:976\n766#3:978\n857#3:979\n858#3:982\n288#3,2:983\n526#4:766\n511#4,6:767\n526#4:773\n511#4,6:774\n372#4,7:826\n526#4:873\n511#4,6:874\n526#4:939\n511#4,6:940\n1#5:799\n*S KotlinDebug\n*F\n+ 1 UnitAutomation.kt\ncom/unciv/logic/automation/unit/UnitAutomation\n*L\n35#1:733,2\n36#1:735,2\n84#1:757,2\n107#1:762,2\n109#1:764,2\n137#1:780,14\n146#1:797,2\n289#1:800\n290#1:801,2\n310#1:817\n315#1:818\n380#1:839\n381#1:840,2\n528#1:920\n533#1:921,2\n543#1:923,2\n562#1:925,2\n567#1:927\n568#1:928,2\n581#1:930\n582#1:931,2\n614#1:933,2\n614#1:935,4\n639#1:946\n640#1:947,2\n675#1:952\n676#1:953,2\n696#1:968,2\n701#1:970,2\n711#1:980,2\n162#1:985,2\n47#1:737\n47#1:738,2\n50#1:740\n51#1:741,14\n69#1:755,2\n89#1:759\n89#1:760,2\n139#1:794,3\n305#1:803,14\n373#1:819\n373#1:820,2\n374#1:822\n374#1:823,3\n374#1:833,3\n376#1:836,3\n393#1:842\n393#1:843,2\n394#1:845,14\n405#1:859,14\n454#1:880\n454#1:881,2\n459#1:883,14\n485#1:897\n485#1:898,2\n494#1:900\n494#1:901,2\n497#1:903\n497#1:904,2\n498#1:906,14\n655#1:949\n655#1:950,2\n685#1:955\n685#1:956,2\n686#1:958\n686#1:959,3\n686#1:962\n686#1:963,5\n707#1:972\n707#1:973,2\n708#1:975\n708#1:976,2\n709#1:978\n709#1:979\n709#1:982\n713#1:983,2\n117#1:766\n117#1:767,6\n124#1:773\n124#1:774,6\n374#1:826,7\n453#1:873\n453#1:874,6\n618#1:939\n618#1:940,6\n*E\n"})
public final class UnitAutomation {
    @NotNull
    public static final UnitAutomation INSTANCE = new UnitAutomation();
    private static final int CLOSE_ENEMY_TILES_AWAY_LIMIT = 5;
    private static final float CLOSE_ENEMY_TURNS_AWAY_LIMIT = 3.0f;

    private UnitAutomation() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isGoodTileToExplore(MapUnit unit, Tile tile) {
        Tile element$iv;
        Tile it;
        if (tile.getOwner() != null) {
            Civilization civilization = tile.getOwner();
            Intrinsics.checkNotNull(civilization);
            if (civilization.isCityState()) return false;
        }
        Sequence<Tile> $this$any$iv = tile.getNeighbors();
        boolean $i$f$any = false;
        Iterator<Tile> iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            it = element$iv = iterator2.next();
            boolean bl = false;
        } while (!(!unit.getCiv().hasExplored(it)));
        boolean bl = true;
        if (!bl) return false;
        if (unit.getCiv().isCityState()) {
            $this$any$iv = tile.getNeighbors();
            $i$f$any = false;
            iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                it = element$iv = iterator2.next();
                boolean bl2 = false;
            } while (!Intrinsics.areEqual(it.getOwner(), unit.getCiv()));
            boolean bl3 = true;
            if (!bl3) return false;
        }
        if (unit.getDamageFromTerrain(tile) > 0) return false;
        if (ThreatManager.getDistanceToClosestEnemyUnit$default(unit.getCiv().getThreatManager(), tile, 3, false, 4, null) <= 3) return false;
        if (!UnitMovement.canMoveTo$default(unit.getMovement(), tile, false, false, false, 14, null)) return false;
        if (!unit.getMovement().canReach(tile)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryExplore$core(@NotNull MapUnit unit) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (this.tryGoToRuinAndEncampment(unit) && (!unit.hasMovement() || unit.isDestroyed())) {
            return true;
        }
        Set<Tile> set2 = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null).keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Iterable $this$filter$iv = set2;
        boolean $i$f$filter2 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!INSTANCE.isGoodTileToExplore(unit, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List explorableTilesThisTurn = (List)destination$iv$iv;
        if (CollectionsKt.any(explorableTilesThisTurn)) {
            Object v1;
            void $this$maxByOrNull$iv;
            Iterable $this$sortedByDescending$iv;
            Iterable $i$f$filter2 = explorableTilesThisTurn;
            boolean $i$f$sortedByDescending = false;
            $this$sortedByDescending$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Tile it = (Tile)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getTileHeight());
                    it = (Tile)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getTileHeight());
                }
            });
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    Tile it = (Tile)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.aerialDistanceTo(unit.getCurrentTile());
                    do {
                        Object e$iv = iterator$iv.next();
                        Tile it2 = (Tile)e$iv;
                        $i$a$-maxByOrNull-UnitAutomation$tryExplore$bestTile$2 = false;
                        int v$iv = it2.aerialDistanceTo(unit.getCurrentTile());
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v1);
            Tile bestTile = v1;
            unit.getMovement().headTowards(bestTile);
            return true;
        }
        Iterator<Tile> iterator2 = unit.getCurrentTile().getTilesInDistance(5).iterator();
        while (iterator2.hasNext()) {
            Tile tile = iterator2.next();
            if (!this.isGoodTileToExplore(unit, tile)) continue;
            unit.getMovement().headTowards(tile);
            return true;
        }
        return false;
    }

    private final boolean tryGoToRuinAndEncampment(MapUnit unit) {
        Object v2;
        block3: {
            if (!unit.getCiv().isMajorCiv()) {
                return false;
            }
            Iterable $this$firstOrNull$iv = unit.getViewableTiles();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Tile it = (Tile)element$iv;
                boolean bl = false;
                TileImprovement tileImprovement = it.getTileImprovement();
                boolean bl2 = ((tileImprovement != null ? tileImprovement.isAncientRuinsEquivalent() : false) || Intrinsics.areEqual(it.getImprovement(), "Barbarian encampment")) && UnitMovement.canMoveTo$default(unit.getMovement(), it, false, false, false, 14, null) && unit.getMovement().canReach(it);
                if (!bl2) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        Tile tile = v2;
        if (tile == null) {
            return false;
        }
        Tile tileWithRuinOrEncampment = tile;
        unit.getMovement().headTowards(tileWithRuinOrEncampment);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryFogBust(MapUnit unit) {
        void $this$filterTo$iv$iv;
        boolean bl;
        Object element$iv;
        block6: {
            if (!Automation.INSTANCE.afraidOfBarbarians(unit.getCiv())) {
                return false;
            }
            Sequence<Tile> $this$all$iv = unit.getCurrentTile().getTilesInDistance(5);
            boolean $i$f$all = false;
            Iterator<Tile> iterator2 = $this$all$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                Tile it = element$iv;
                boolean bl2 = false;
                if (it.isVisible(unit.getCiv())) continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        if (bl) {
            return false;
        }
        Set<Tile> set2 = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null).keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Iterable $this$filter$iv = set2;
        boolean $i$f$filter = false;
        element$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull(it);
            if (!INSTANCE.isGoodTileForFogBusting(unit, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List reachableTilesThisTurn = (List)destination$iv$iv;
        if (CollectionsKt.any(reachableTilesThisTurn)) {
            UnitMovement unitMovement = unit.getMovement();
            Object t = CollectionsKt.random(reachableTilesThisTurn, Random.Default);
            Intrinsics.checkNotNullExpressionValue(t, "random(...)");
            unitMovement.headTowards((Tile)t);
            return true;
        }
        Iterator<Tile> iterator3 = unit.getCurrentTile().getTilesInDistance(5).iterator();
        while (iterator3.hasNext()) {
            Tile tile = iterator3.next();
            if (!this.isGoodTileForFogBusting(unit, tile)) continue;
            unit.getMovement().headTowards(tile);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isGoodTileForFogBusting(MapUnit unit, Tile tile) {
        Tile it;
        Tile element$iv;
        if (!UnitMovement.canMoveTo$default(unit.getMovement(), tile, false, false, false, 14, null)) return false;
        if (tile.getOwner() != null) return false;
        Sequence<Tile> $this$all$iv = tile.getNeighbors();
        boolean $i$f$all = false;
        Iterator<Tile> iterator2 = $this$all$iv.iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            if (it.getOwner() != null) return false;
            boolean bl2 = true;
            if (bl2) continue;
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        if (!unit.getCiv().hasExplored(tile)) return false;
        Sequence<Tile> $this$any$iv = tile.getTilesInDistance(2);
        boolean $i$f$any = false;
        iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            it = element$iv = iterator2.next();
            boolean bl3 = false;
        } while (!Intrinsics.areEqual(it.getOwner(), unit.getCiv()));
        boolean bl4 = true;
        if (!bl4) return false;
        if (unit.getDamageFromTerrain(tile) > 0) return false;
        if (!unit.getMovement().canReach(tile)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void wander(@NotNull MapUnit unit, boolean stayInTerritory, @NotNull Set<Tile> tilesToAvoid) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Map reachableTiles2;
        void $this$filterTo$iv$iv2;
        void $this$filter$iv2;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tilesToAvoid, "tilesToAvoid");
        PathsToTilesWithinTurn unitDistanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
        Map map2 = unitDistanceToTiles;
        boolean $i$f$filter22 = false;
        void var8_8 = $this$filter$iv2;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            boolean bl2 = !tilesToAvoid.contains(it.getKey()) && UnitMovement.canMoveTo$default(unit.getMovement(), (Tile)it.getKey(), false, false, false, 14, null) && unit.getMovement().canReach((Tile)it.getKey());
            if (!bl2) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $i$f$filter22 = reachableTiles2 = destination$iv$iv;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator3.next();
            boolean bl = false;
            boolean bl3 = ((UnitMovement.ParentTileAndTotalMovement)it.getValue()).getTotalMovement() == unit.getCurrentMovement() && unit.getDamageFromTerrain((Tile)it.getKey()) <= 0 && (!stayInTerritory || Intrinsics.areEqual(((Tile)it.getKey()).getOwner(), unit.getCiv()));
            if (!bl3) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map reachableTilesMaxWalkingDistance = destination$iv$iv2;
        if (MapsKt.any(reachableTilesMaxWalkingDistance)) {
            UnitMovement.moveToTile$default(unit.getMovement(), (Tile)((Pair)CollectionsKt.random(MapsKt.toList(reachableTilesMaxWalkingDistance), Random.Default)).getFirst(), false, 2, null);
        } else if (MapsKt.any(reachableTiles2)) {
            UnitMovement.moveToTile$default(unit.getMovement(), (Tile)CollectionsKt.random(reachableTiles2.keySet(), Random.Default), false, 2, null);
        }
    }

    public static /* synthetic */ void wander$default(UnitAutomation unitAutomation, MapUnit mapUnit, boolean bl, Set set2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            set2 = SetsKt.emptySet();
        }
        unitAutomation.wander(mapUnit, bl, set2);
    }

    public final boolean tryUpgradeUnit$core(@NotNull MapUnit unit) {
        Unit unit2;
        Object object;
        UnitAction unitAction2;
        block16: {
            Sequence<UnitAction> upgradeActions;
            boolean bl;
            BaseUnit upgradedUnit;
            block15: {
                BaseUnit baseUnit;
                Sequence<BaseUnit> upgradeUnits;
                Intrinsics.checkNotNullParameter(unit, "unit");
                if (unit.getCiv().isHuman() && !UncivGame.Companion.getCurrent().getSettings().getAutomatedUnitsCanUpgrade()) {
                    Object object2 = UncivGame.Companion.getCurrent().getWorldScreen();
                    boolean bl2 = object2 != null && (object2 = ((WorldScreen)object2).getAutoPlay()) != null ? !((AutoPlay)object2).isAutoPlayingAndFullAutoPlayAI() : false;
                    if (bl2) {
                        return false;
                    }
                }
                if (SequencesKt.none(upgradeUnits = this.getUnitsToUpgradeTo(unit))) {
                    return false;
                }
                Sequence<BaseUnit> $this$minBy$iv = upgradeUnits;
                boolean $i$f$minByOrThrow = false;
                Iterator<BaseUnit> iterator$iv = $this$minBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                BaseUnit minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    baseUnit = minElem$iv;
                } else {
                    BaseUnit it = minElem$iv;
                    boolean bl3 = false;
                    int minValue$iv = it.getCost();
                    do {
                        BaseUnit e$iv;
                        BaseUnit it2 = e$iv = iterator$iv.next();
                        $i$a$-minByOrThrow-UnitAutomation$tryUpgradeUnit$upgradedUnit$1 = false;
                        int v$iv = it2.getCost();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    baseUnit = minElem$iv;
                }
                upgradedUnit = baseUnit;
                Set<String> set2 = upgradedUnit.getResourceRequirementsPerTurn(unit.getCache().getState()).keySet();
                Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
                Iterable $this$any$iv = set2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull(it);
                        if (!(!unit.requiresResource(it))) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl && !Automation.allowSpendingResource$default(Automation.INSTANCE, unit.getCiv(), upgradedUnit, null, 4, null)) {
                return false;
            }
            Sequence<UnitAction> $this$firstOrNull$iv = upgradeActions = UnitActionsUpgrade.INSTANCE.getUpgradeActions(unit);
            boolean $i$f$firstOrNull = false;
            Iterator<UnitAction> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                UnitAction element$iv;
                UnitAction it = element$iv = iterator2.next();
                boolean bl5 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type com.unciv.models.UpgradeUnitAction");
                if (!Intrinsics.areEqual(((UpgradeUnitAction)it).getUnitToUpgradeTo(), upgradedUnit)) continue;
                unitAction2 = element$iv;
                break block16;
            }
            unitAction2 = null;
        }
        if ((object = (UnitAction)unitAction2) != null && (object = ((UnitAction)object).getAction()) != null) {
            object.invoke();
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        if (unit2 == null) {
            return false;
        }
        return unit.isDestroyed();
    }

    private final Sequence<BaseUnit> getUnitsToUpgradeTo(MapUnit unit) {
        return SequencesKt.filter(SequencesKt.map(unit.getBaseUnit().getRulesetUpgradeUnits(unit.getCache().getState()), (Function1)new Function1<BaseUnit, BaseUnit>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final BaseUnit invoke(@NotNull BaseUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$unit.getCiv().getEquivalentUnit(it);
            }
        }), (Function1)new Function1<BaseUnit, Boolean>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BaseUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !UnitAutomation.access$getUnitsToUpgradeTo$isInvalidUpgradeDestination(this.$unit, it) && UnitUpgradeManager.canUpgrade$default(this.$unit.getUpgrade(), it, false, false, 6, null);
            }
        });
    }

    public final void automateUnitMoves(@NotNull MapUnit unit) {
        Sequence<Promotion> availablePromotions2;
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (!(!unit.getCiv().isBarbarian())) {
            boolean $i$a$-check-UnitAutomation$automateUnitMoves$22 = false;
            String $i$a$-check-UnitAutomation$automateUnitMoves$22 = "Barbarians is not allowed here.";
            throw new IllegalStateException($i$a$-check-UnitAutomation$automateUnitMoves$22.toString());
        }
        if (MapUnit.getDamageFromTerrain$default(unit, null, 1, null) > 0 && this.tryHealUnit(unit)) {
            return;
        }
        if (unit.isCivilian()) {
            CivilianUnitAutomation.INSTANCE.automateCivilianUnit(unit, this.getDangerousTiles(unit));
            return;
        }
        while (unit.getPromotions().canBePromoted() && (UncivGame.Companion.getCurrent().getSettings().getAutomatedUnitsChoosePromotions() || unit.getCiv().isAI()) && !SequencesKt.none(availablePromotions2 = SequencesKt.filterNot(unit.getPromotions().getAvailablePromotions(), automateUnitMoves.availablePromotions.1.INSTANCE))) {
            List<Promotion> freePromotions2 = SequencesKt.toList(SequencesKt.filter(availablePromotions2, automateUnitMoves.freePromotions.1.INSTANCE));
            StateForConditionals stateForConditionals = unit.getCache().getState();
            Promotion chosenPromotion2 = !((Collection)freePromotions2).isEmpty() ? (Promotion)CollectionExtensionsKt.randomWeighted$default(freePromotions2, null, new Function1<Promotion, Float>(stateForConditionals){
                final /* synthetic */ StateForConditionals $stateForConditionals;
                {
                    this.$stateForConditionals = $stateForConditionals;
                    super(1);
                }

                @NotNull
                public final Float invoke(@NotNull Promotion it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Float.valueOf(it.getWeightForAiDecision(this.$stateForConditionals));
                }
            }, 1, null) : (Promotion)CollectionExtensionsKt.randomWeighted$default(SequencesKt.toList(availablePromotions2), null, new Function1<Promotion, Float>(stateForConditionals){
                final /* synthetic */ StateForConditionals $stateForConditionals;
                {
                    this.$stateForConditionals = $stateForConditionals;
                    super(1);
                }

                @NotNull
                public final Float invoke(@NotNull Promotion it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Float.valueOf(it.getWeightForAiDecision(this.$stateForConditionals));
                }
            }, 1, null);
            UnitPromotions.addPromotion$default(unit.getPromotions(), chosenPromotion2.getName(), false, 2, null);
        }
        if ((MapUnit.hasUnique$default(unit, UniqueType.BuildImprovements, null, false, 6, null) || MapUnit.hasUnique$default(unit, UniqueType.FoundCity, null, false, 6, null) || MapUnit.hasUnique$default(unit, UniqueType.ReligiousUnit, null, false, 6, null) || MapUnit.hasUnique$default(unit, UniqueType.CreateWaterImprovements, null, false, 6, null)) && !unit.getCiv().isAtWar()) {
            CivilianUnitAutomation.INSTANCE.automateCivilianUnit(unit, this.getDangerousTiles(unit));
            return;
        }
        if (unit.isNuclearWeapon()) {
            AirUnitAutomation.INSTANCE.automateNukes(unit);
            return;
        }
        if (unit.getBaseUnit().isAirUnit()) {
            if (unit.canIntercept()) {
                AirUnitAutomation.INSTANCE.automateFighter(unit);
                return;
            }
            if (MapUnit.hasUnique$default(unit, UniqueType.SelfDestructs, null, false, 6, null)) {
                AirUnitAutomation.INSTANCE.automateMissile(unit);
                return;
            }
            AirUnitAutomation.INSTANCE.automateBomber(unit);
            return;
        }
        if (this.tryAccompanySettlerOrGreatPerson(unit)) {
            return;
        }
        if (this.tryGoToRuinAndEncampment(unit) && !unit.hasMovement()) {
            return;
        }
        if (unit.getHealth() < 50 && (this.tryRetreat(unit) || this.tryHealUnit(unit))) {
            return;
        }
        if (unit.getHealth() < 100 && this.canUnitHealInTurnsOnCurrentTile(unit, 2, 4)) {
            return;
        }
        if (this.tryHeadTowardsOurSiegedCity(unit)) {
            return;
        }
        if (BattleHelper.INSTANCE.tryDisembarkUnitToAttackPosition(unit)) {
            return;
        }
        if (this.tryAttacking(unit)) {
            return;
        }
        if (this.tryTakeBackCapturedCity(unit)) {
            return;
        }
        if (HeadTowardsEnemyCityAutomation.INSTANCE.tryHeadTowardsEnemyCity(unit)) {
            return;
        }
        if (this.tryGarrisoningRangedLandUnit(unit)) {
            return;
        }
        if (this.tryStationingMeleeNavalUnit(unit)) {
            return;
        }
        if (unit.getHealth() < 80 && this.tryHealUnit(unit)) {
            return;
        }
        if (this.tryAdvanceTowardsCloseEnemy(unit)) {
            return;
        }
        if (this.tryHeadTowardsEncampment(unit)) {
            return;
        }
        if (unit.getHealth() < 100 && this.tryHealUnit(unit)) {
            return;
        }
        if (this.tryPrepare(unit)) {
            return;
        }
        if (this.tryExplore$core(unit)) {
            return;
        }
        if (this.tryFogBust(unit)) {
            return;
        }
        if (unit.getCiv().isCityState()) {
            UnitAutomation.wander$default(this, unit, true, null, 4, null);
        }
    }

    private final boolean tryAttacking(MapUnit unit) {
        int n = unit.maxAttacksPerTurn() - unit.getAttacksThisTurn();
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            if (BattleHelper.tryAttackNearbyEnemy$default(BattleHelper.INSTANCE, unit, false, 2, null)) {
                return true;
            }
            if (unit.getHealth() >= 50 || !INSTANCE.tryRetreat(unit)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryHeadTowardsEncampment(MapUnit unit) {
        Object v0;
        block3: {
            void $this$sortedBy$iv;
            Sequence encampmentsCloseToCities2;
            if (MapUnit.hasUnique$default(unit, UniqueType.SelfDestructs, null, false, 6, null)) {
                return false;
            }
            Sequence knownEncampments2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)unit.getCiv().getGameInfo().getTileMap().getValues()), (Function1)new Function1<Tile, Boolean>(unit){
                final /* synthetic */ MapUnit $unit;
                {
                    this.$unit = $unit;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it.getImprovement(), "Barbarian encampment") && this.$unit.getCiv().hasExplored(it);
                }
            });
            List<City> cities = unit.getCiv().getCities();
            Sequence sequence = SequencesKt.filter(knownEncampments2, (Function1)new Function1<Tile, Boolean>(cities){
                final /* synthetic */ List<City> $cities;
                {
                    this.$cities = $cities;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    boolean bl;
                    block3: {
                        Intrinsics.checkNotNullParameter(it, "it");
                        Iterable $this$any$iv = this.$cities;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                City city2 = (City)element$iv;
                                boolean bl2 = false;
                                if (!(city2.getCenterTile().aerialDistanceTo(it) < 6)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            });
            boolean $i$f$sortedBy = false;
            Sequence $this$firstOrNull$iv = encampmentsCloseToCities2 = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Tile it = (Tile)element$iv;
                boolean bl = false;
                if (!unit.getMovement().canReach(it)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Tile tile = v0;
        if (tile == null) {
            return false;
        }
        Tile encampmentToHeadTowards = tile;
        unit.getMovement().headTowards(encampmentToHeadTowards);
        return true;
    }

    private final boolean tryRetreat(MapUnit unit) {
        Sequence sequence;
        Object closestCity;
        Object object;
        Object v0;
        if (unit.isCivilian()) {
            return false;
        }
        if (unit.getBaseUnit().isAirUnit()) {
            return false;
        }
        if (unit.getCiv().getThreatManager().getDistanceToClosestEnemyUnit(unit.getTile(), 6, true) > 4) {
            return false;
        }
        PathsToTilesWithinTurn unitDistanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
        Object $this$minByOrNull$iv = unit.getCiv().getCities();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                City it = (City)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getCenterTile().aerialDistanceTo(unit.getTile());
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    $i$a$-minByOrNull-UnitAutomation$tryRetreat$closestCity$1 = false;
                    int v$iv = it2.getCenterTile().aerialDistanceTo(unit.getTile());
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        City city2 = v0;
        if (city2 != null) {
            Object it = $this$minByOrNull$iv = city2;
            boolean bl = false;
            object = ((City)it).getCenterTile().aerialDistanceTo(unit.getTile()) < 20 ? $this$minByOrNull$iv : null;
        } else {
            object = closestCity = null;
        }
        if (closestCity != null) {
            Sequence $this$sortedBy$iv = SequencesKt.map(MapsKt.asSequence(unitDistanceToTiles), tryRetreat.sortedTilesToRetreatTo.1.INSTANCE);
            boolean $i$f$sortedBy = false;
            sequence = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator((City)closestCity){
                final /* synthetic */ City $closestCity$inlined;
                {
                    this.$closestCity$inlined = city2;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$closestCity$inlined.getCenterTile()));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$closestCity$inlined.getCenterTile()));
                }
            });
        } else {
            Sequence $this$sortedByDescending$iv = SequencesKt.map(MapsKt.asSequence(unitDistanceToTiles), tryRetreat.sortedTilesToRetreatTo.3.INSTANCE);
            boolean $i$f$sortedByDescending = false;
            sequence = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(this.$unit$inlined.getCiv().getThreatManager().getDistanceToClosestEnemyUnit(it, 3, false));
                    it = (Tile)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, this.$unit$inlined.getCiv().getThreatManager().getDistanceToClosestEnemyUnit(it, 3, false));
                }
            });
        }
        Sequence sortedTilesToRetreatTo2 = sequence;
        int ourDistanceToClosestEnemy = unit.getCiv().getThreatManager().getDistanceToClosestEnemyUnit(unit.getTile(), 6, false);
        Iterator iterator2 = sortedTilesToRetreatTo2.iterator();
        while (iterator2.hasNext()) {
            int range;
            Tile retreatTile = (Tile)iterator2.next();
            int tileDistanceToClosestEnemy = unit.getCiv().getThreatManager().getDistanceToClosestEnemyUnit(retreatTile, 6, false);
            if (ourDistanceToClosestEnemy >= tileDistanceToClosestEnemy) continue;
            MapUnit otherUnit = retreatTile.getMilitaryUnit();
            if (otherUnit == null) {
                if (!UnitMovement.canMoveTo$default(unit.getMovement(), retreatTile, false, false, false, 14, null)) continue;
                UnitMovement.moveToTile$default(unit.getMovement(), retreatTile, false, 2, null);
                return true;
            }
            if (!Intrinsics.areEqual(otherUnit.getCiv(), unit.getCiv()) || otherUnit.getHealth() <= 80 || otherUnit.getBaseUnit().isRanged() && ourDistanceToClosestEnemy < (range = otherUnit.getBaseUnit().getRange()) || !unit.getMovement().canUnitSwapTo(retreatTile)) continue;
            unit.getMovement().headTowards(retreatTile);
            if (SequencesKt.contains(unit.getCurrentTile().getNeighbors(), otherUnit.getCurrentTile()) && unit.getMovement().canUnitSwapTo(retreatTile)) {
                unit.getMovement().swapMoveToTile(retreatTile);
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean tryHealUnit(MapUnit unit) {
        block41: {
            if (unit.getBaseUnit().isRanged() && MapUnit.hasUnique$default(unit, UniqueType.HealsEvenAfterAction, null, false, 6, null)) {
                return false;
            }
            while (this.tryPillageImprovement(unit, false)) {
                if (unit.hasMovement() && unit.getHealth() != 100) continue;
                return unit.hasMovement() == false;
            }
            unitDistanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
            if (unitDistanceToTiles.isEmpty()) {
                return true;
            }
            if (UnitAutomation.canUnitHealInTurnsOnCurrentTile$default(this, unit, 3, 0, 4, null)) {
                return true;
            }
            currentUnitTile = unit.getTile();
            dangerousTiles = unit.getCiv().getThreatManager().getDangerousTiles(unit, 4);
            v0 = unitDistanceToTiles.keySet();
            Intrinsics.checkNotNullExpressionValue(v0, "<get-keys>(...)");
            var6_5 = v0;
            $i$f$filter = false;
            var8_8 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filter-UnitAutomation$tryHealUnit$viableTilesForHealing$1 = false;
                if (dangerousTiles.contains(it)) ** GOTO lbl-1000
                v1 = unit.getMovement();
                Intrinsics.checkNotNull(it);
                if (UnitMovement.canMoveTo$default(v1, it, false, false, false, 14, null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            viableTilesForHealing = (List)destination$iv$iv;
            $this$groupBy$iv = viableTilesForHealing;
            $i$f$groupBy = false;
            destination$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap<K, V>();
            $i$f$groupByTo = false;
            element$iv$iv = $this$groupByTo$iv$iv.iterator();
            while (element$iv$iv.hasNext()) {
                element$iv$iv = element$iv$iv.next();
                it = (Tile)element$iv$iv;
                $i$a$-groupBy-UnitAutomation$tryHealUnit$tilesByHealingRate$1 = false;
                Intrinsics.checkNotNull(it);
                key$iv$iv = unit.rankTileForHealing(it);
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                    answer$iv$iv$iv = new ArrayList<E>();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    v3 /* !! */  = answer$iv$iv$iv;
                } else {
                    v3 /* !! */  = value$iv$iv$iv;
                }
                list$iv$iv = (List)v3 /* !! */ ;
                list$iv$iv.add(element$iv$iv);
            }
            tilesByHealingRate = destination$iv$iv;
            $this$all$iv = tilesByHealingRate.keySet();
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v4 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = ((Number)element$iv).intValue();
                    $i$a$-all-UnitAutomation$tryHealUnit$1 = false;
                    if (it == 0) continue;
                    v4 = false;
                    break block41;
                }
                v4 = true;
            }
        }
        if (v4) {
            if (!unit.getBaseUnit().getMovesLikeAirUnits()) {
                block42: {
                    $i$f$all = SequencesKt.map(CollectionsKt.asSequence((Iterable)unit.getCiv().getCities()), tryHealUnit.reachableCityTile.1.INSTANCE);
                    $i$f$sortedBy = false;
                    $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                        final /* synthetic */ MapUnit $unit$inlined;
                        {
                            this.$unit$inlined = mapUnit;
                        }

                        public final int compare(T a, T b) {
                            Tile it = (Tile)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                            it = (Tile)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                        }
                    });
                    $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        it = (Tile)element$iv;
                        $i$a$-firstOrNull-UnitAutomation$tryHealUnit$reachableCityTile$3 = false;
                        if (!unit.getMovement().canReach(it)) continue;
                        v5 = element$iv;
                        break block42;
                    }
                    v5 = null;
                }
                reachableCityTile = v5;
                if (reachableCityTile != null) {
                    unit.getMovement().headTowards(reachableCityTile);
                } else {
                    UnitAutomation.wander$default(this, unit, false, null, 6, null);
                }
                return true;
            }
            emptyCities = SequencesKt.filter(SequencesKt.map(CollectionsKt.asSequence((Iterable)unit.getCiv().getCities()), tryHealUnit.emptyCities.1.INSTANCE), (Function1)new Function1<Tile, Boolean>(unit){
                final /* synthetic */ MapUnit $unit;
                {
                    this.$unit = $unit;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Tile it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return UnitMovement.canMoveTo$default(this.$unit.getMovement(), it, false, false, false, 14, null);
                }
            });
            if (SequencesKt.none(emptyCities)) {
                return false;
            }
            v6 = unitDistanceToTiles.keySet();
            Intrinsics.checkNotNullExpressionValue(v6, "<get-keys>(...)");
            element$iv = v6;
            $i$f$filter = false;
            $i$a$-firstOrNull-UnitAutomation$tryHealUnit$reachableCityTile$3 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filter-UnitAutomation$tryHealUnit$nextTileToMove$1 = false;
                v7 = unit.getMovement();
                Intrinsics.checkNotNull(it);
                if (!UnitMovement.canMoveTo$default(v7, it, false, false, false, 14, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v8 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v8 = minElem$iv;
                } else {
                    tile = (Tile)minElem$iv;
                    $i$a$-minByOrNull-UnitAutomation$tryHealUnit$nextTileToMove$2 = false;
                    element$iv$iv = emptyCities.iterator();
                    if (!element$iv$iv.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    city = (Tile)element$iv$iv.next();
                    $i$a$-minOf-UnitAutomation$tryHealUnit$nextTileToMove$2$1 = false;
                    Intrinsics.checkNotNull(tile);
                    city = city.aerialDistanceTo(tile);
                    while (element$iv$iv.hasNext()) {
                        city = (Tile)element$iv$iv.next();
                        $i$a$-minOf-UnitAutomation$tryHealUnit$nextTileToMove$2$1 = false;
                        var19_62 = city.aerialDistanceTo(tile);
                        if (city <= var19_62) continue;
                        city = var19_62;
                    }
                    minValue$iv = city;
                    do {
                        e$iv = iterator$iv.next();
                        tile = (Tile)e$iv;
                        $i$a$-minByOrNull-UnitAutomation$tryHealUnit$nextTileToMove$2 = false;
                        var19_64 = emptyCities.iterator();
                        if (!var19_64.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        city = (Tile)var19_64.next();
                        $i$a$-minOf-UnitAutomation$tryHealUnit$nextTileToMove$2$1 = false;
                        Intrinsics.checkNotNull(tile);
                        var20_69 = city.aerialDistanceTo(tile);
                        while (var19_64.hasNext()) {
                            city = (Tile)var19_64.next();
                            $i$a$-minOf-UnitAutomation$tryHealUnit$nextTileToMove$2$1 = false;
                            var21_71 = city.aerialDistanceTo(tile);
                            if (var20_69 <= var21_71) continue;
                            var20_69 = var21_71;
                        }
                        v$iv = var20_69;
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v8 = minElem$iv;
                }
            }
            v9 = v8;
            if (v9 == null) {
                return false;
            }
            nextTileToMove = v9;
            UnitMovement.moveToTile$default(unit.getMovement(), nextTileToMove, false, 2, null);
            return true;
        }
        $i$f$firstOrNull = tilesByHealingRate.entrySet();
        element$iv = $i$f$firstOrNull.iterator();
        if (!element$iv.hasNext()) {
            v10 = null;
        } else {
            $this$minByOrNull$iv = element$iv.next();
            if (!element$iv.hasNext()) {
                v10 = $this$minByOrNull$iv;
            } else {
                it = (Map.Entry)$this$minByOrNull$iv;
                $i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTilesForHealing$1 = false;
                it = ((Number)it.getKey()).intValue();
                do {
                    $i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTilesForHealing$1 = element$iv.next();
                    it = (Map.Entry)$i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTilesForHealing$1;
                    $i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTilesForHealing$1 = false;
                    it = ((Number)it.getKey()).intValue();
                    if (it >= it) continue;
                    $this$minByOrNull$iv = $i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTilesForHealing$1;
                    it = it;
                } while (element$iv.hasNext());
                v10 = $this$minByOrNull$iv;
            }
        }
        v11 = v10;
        Intrinsics.checkNotNull(v11);
        bestTilesForHealing = (List)v11.getValue();
        $this$maxByOrNull$iv = bestTilesForHealing;
        $i$f$maxByOrNull = false;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v12 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v12 = maxElem$iv;
            } else {
                it = (Tile)maxElem$iv;
                $i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTileForHealing$1 = false;
                Intrinsics.checkNotNull(it);
                maxValue$iv = Tile.getDefensiveBonus$default(it, false, unit, 1, null);
                do {
                    e$iv = iterator$iv.next();
                    it = (Tile)e$iv;
                    $i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTileForHealing$1 = false;
                    Intrinsics.checkNotNull(it);
                    v$iv = Tile.getDefensiveBonus$default(it, false, unit, 1, null);
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v12 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v12);
        bestTileForHealing = v12;
        bestTileForHealingRank = unit.rankTileForHealing(bestTileForHealing);
        if (!Intrinsics.areEqual(currentUnitTile, bestTileForHealing) && bestTileForHealingRank > unit.rankTileForHealing(currentUnitTile) - MapUnit.getDamageFromTerrain$default(unit, null, 1, null)) {
            UnitMovement.moveToTile$default(unit.getMovement(), bestTileForHealing, false, 2, null);
        }
        unit.fortifyIfCan();
        return true;
    }

    private final boolean canUnitHealInTurnsOnCurrentTile(MapUnit unit, int turns, int noEnemyDistance) {
        int healthRequiredPerTurn;
        block6: {
            block5: {
                if (MapUnit.hasUnique$default(unit, UniqueType.HealsEvenAfterAction, null, false, 6, null)) {
                    return false;
                }
                if (!unit.getTile().isCityCenter()) break block5;
                City city2 = unit.getTile().getCity();
                Intrinsics.checkNotNull(city2);
                if (city2.getHealth() > 50) break block6;
            }
            if (ThreatManager.getDistanceToClosestEnemyUnit$default(unit.getCiv().getThreatManager(), unit.getTile(), noEnemyDistance, false, 4, null) <= noEnemyDistance) {
                return false;
            }
        }
        return (healthRequiredPerTurn = (100 - unit.getHealth()) / turns) <= unit.rankTileForHealing(unit.getTile());
    }

    static /* synthetic */ boolean canUnitHealInTurnsOnCurrentTile$default(UnitAutomation unitAutomation, MapUnit mapUnit, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 3;
        }
        return unitAutomation.canUnitHealInTurnsOnCurrentTile(mapUnit, n, n2);
    }

    private final HashSet<Tile> getDangerousTiles(MapUnit unit) {
        Sequence nearbyEnemyUnits2 = SequencesKt.flatMap(unit.getCurrentTile().getTilesInDistance(3), (Function1)new Function1<Tile, Sequence<? extends MapUnit>>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final Sequence<MapUnit> invoke(@NotNull Tile tile) {
                Intrinsics.checkNotNullParameter(tile, "tile");
                return SequencesKt.filter(tile.getUnits(), (Function1)new Function1<MapUnit, Boolean>(this.$unit){
                    final /* synthetic */ MapUnit $unit;
                    {
                        this.$unit = $unit;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull MapUnit it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.$unit.getCiv().isAtWarWith(it.getCiv());
                    }
                });
            }
        });
        Sequence tilesInRangeOfAttack2 = SequencesKt.flatMap(nearbyEnemyUnits2, getDangerousTiles.tilesInRangeOfAttack.1.INSTANCE);
        Sequence tilesWithinBombardmentRange2 = SequencesKt.flatMap(SequencesKt.filter(unit.getCurrentTile().getTilesInDistance(3), (Function1)new Function1<Tile, Boolean>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.isCityCenter()) {
                    City city2 = it.getCity();
                    Intrinsics.checkNotNull(city2);
                    if (city2.getCiv().isAtWarWith(this.$unit.getCiv())) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }), getDangerousTiles.tilesWithinBombardmentRange.2.INSTANCE);
        Sequence<Tile> tilesWithTerrainDamage2 = SequencesKt.filter(unit.getCurrentTile().getTilesInDistance(3), (Function1)new Function1<Tile, Boolean>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$unit.getDamageFromTerrain(it) > 0;
            }
        });
        return SequencesKt.toHashSet(SequencesKt.plus(SequencesKt.plus(tilesInRangeOfAttack2, tilesWithinBombardmentRange2), tilesWithTerrainDamage2));
    }

    /*
     * Unable to fully structure code
     */
    public final boolean tryPillageImprovement(@NotNull MapUnit unit, boolean onlyPillageToHeal) {
        block14: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            if (unit.isCivilian()) {
                return false;
            }
            unitDistanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
            var5_4 = unitDistanceToTiles;
            $i$f$filter = false;
            var7_7 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap<K, V>();
            $i$f$filterTo = false;
            for (Map.Entry<K, V> element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                it = element$iv$iv;
                $i$a$-filter-UnitAutomation$tryPillageImprovement$tilesThatCanWalkToAndThenPillage$1 = false;
                if (!(((UnitMovement.ParentTileAndTotalMovement)it.getValue()).getTotalMovement() < unit.getCurrentMovement())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv.keySet();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Map.Entry<K, V> element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filter-UnitAutomation$tryPillageImprovement$tilesThatCanWalkToAndThenPillage$2 = false;
                if (!UnitMovement.canMoveTo$default(unit.getMovement(), (Tile)it, false, false, false, 14, null) || !UnitActionsPillage.INSTANCE.canPillage(unit, (Tile)it)) ** GOTO lbl-1000
                if (it.canPillageTileImprovement()) ** GOTO lbl-1000
                if (!onlyPillageToHeal && it.canPillageRoad() && it.getRoadOwner() != null) {
                    v0 = unit.getCiv();
                    v1 = it.getRoadOwner();
                    Intrinsics.checkNotNull(v1);
                    ** if (!v0.isAtWarWith((Civilization)v1)) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v2 = true;
                    ** GOTO lbl39
                }
lbl-1000:
                // 3 sources

                {
                    v2 = false;
                }
lbl39:
                // 2 sources

                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            tilesThatCanWalkToAndThenPillage = (List)destination$iv$iv;
            if (tilesThatCanWalkToAndThenPillage.isEmpty()) {
                return false;
            }
            $this$maxByOrNull$iv = tilesThatCanWalkToAndThenPillage;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = maxElem$iv;
                } else {
                    it = (Tile)maxElem$iv;
                    $i$a$-maxByOrNull-UnitAutomation$tryPillageImprovement$tileToPillage$1 = false;
                    maxValue$iv = it.getDefensiveBonus(false, unit);
                    do {
                        e$iv = iterator$iv.next();
                        it = (Tile)e$iv;
                        $i$a$-maxByOrNull-UnitAutomation$tryPillageImprovement$tileToPillage$1 = false;
                        v$iv = it.getDefensiveBonus(false, unit);
                        if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v3);
            tileToPillage = v3;
            if (!Intrinsics.areEqual(unit.getTile(), tileToPillage)) {
                UnitMovement.moveToTile$default(unit.getMovement(), tileToPillage, false, 2, null);
            }
            if (!Intrinsics.areEqual(unit.getCurrentTile(), tileToPillage)) {
                return false;
            }
            v4 = UnitActionsPillage.INSTANCE.getPillageAction$core(unit, unit.getCurrentTile());
            if (v4 == null || (v4 = v4.getAction()) == null) break block14;
            v4.invoke();
        }
        return true;
    }

    public static /* synthetic */ boolean tryPillageImprovement$default(UnitAutomation unitAutomation, MapUnit mapUnit, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return unitAutomation.tryPillageImprovement(mapUnit, bl);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean tryAdvanceTowardsCloseEnemy(MapUnit unit) {
        block11: {
            unitDistanceToTiles = UnitMovement.getMovementToTilesAtPosition$default(unit.getMovement(), unit.getTile().getPosition(), (float)MapUnit.getMaxMovement$default(unit, false, 1, null) * 3.0f, false, null, null, null, false, 124, null);
            var4_3 = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, unitDistanceToTiles, SequencesKt.toList(unit.getTile().getTilesInDistance(5)), false, 8, null);
            $i$f$filter = false;
            var6_6 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (AttackableTile)element$iv$iv /* !! */ ;
                $i$a$-filter-UnitAutomation$tryAdvanceTowardsCloseEnemy$closeEnemies$1 = false;
                v0 = new MapUnitCombatant(unit);
                v1 = Battle.INSTANCE.getMapCombatantOfTile(it.getTileToAttack());
                Intrinsics.checkNotNull(v1);
                v2 = BattleDamage.calculateDamageToAttacker$default(BattleDamage.INSTANCE, v0, v1, null, 0.0f, 12, null) < unit.getHealth() || unit.getDamageFromTerrain(it.getTileToAttackFrom()) > 0;
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv /* !! */ );
            }
            closeEnemies = (List)destination$iv$iv;
            if (!unit.getBaseUnit().isRanged()) break block11;
            $this$filterNot$iv = closeEnemies;
            $i$f$filterNot = false;
            $this$filterTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterNotTo = false;
            for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (AttackableTile)element$iv$iv /* !! */ ;
                $i$a$-filterNot-UnitAutomation$tryAdvanceTowardsCloseEnemy$1 = false;
                if (!it.getTileToAttack().isCityCenter()) ** GOTO lbl-1000
                v3 = it.getTileToAttack().getCity();
                Intrinsics.checkNotNull(v3);
                if (v3.getHealth() == 1) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if (v4) continue;
                destination$iv$iv.add(element$iv$iv /* !! */ );
            }
            closeEnemies = (List)destination$iv$iv;
        }
        $i$f$filterNot = closeEnemies;
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (E element$iv$iv : $this$filterTo$iv$iv) {
            it = (AttackableTile)element$iv$iv;
            $i$a$-filter-UnitAutomation$tryAdvanceTowardsCloseEnemy$closestEnemy$1 = false;
            if (!(unit.getDamageFromTerrain(it.getTileToAttackFrom()) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$minByOrNull = false;
        iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v5 = null;
        } else {
            minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v5 = minElem$iv;
            } else {
                it = (AttackableTile)minElem$iv;
                $i$a$-minByOrNull-UnitAutomation$tryAdvanceTowardsCloseEnemy$closestEnemy$2 = false;
                minValue$iv = it.getTileToAttack().aerialDistanceTo(unit.getTile());
                do {
                    e$iv = iterator$iv.next();
                    it = (AttackableTile)e$iv;
                    $i$a$-minByOrNull-UnitAutomation$tryAdvanceTowardsCloseEnemy$closestEnemy$2 = false;
                    v$iv = it.getTileToAttack().aerialDistanceTo(unit.getTile());
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v5 = minElem$iv;
            }
        }
        closestEnemy = v5;
        if (closestEnemy != null) {
            unit.getMovement().headTowards(closestEnemy.getTileToAttackFrom());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryPrepare(MapUnit unit) {
        void $this$sortedBy$iv;
        Object object;
        Civilization civInfo = unit.getCiv();
        Set<Civilization> hostileCivs2 = SequencesKt.toSet(SequencesKt.filter(civInfo.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(civInfo){
            final /* synthetic */ Civilization $civInfo;
            {
                this.$civInfo = $civInfo;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isAtWarWith(this.$civInfo) || UnitAutomation.access$tryPrepare$hasPreparationFlag(this.$civInfo, it);
            }
        }));
        Sequence<Pair<City, City>> closeCities2 = SequencesKt.filter(civInfo.getThreatManager().getNeighboringCitiesOfOtherCivs(), (Function1)new Function1<Pair<? extends City, ? extends City>, Boolean>(hostileCivs2){
            final /* synthetic */ Set<Civilization> $hostileCivs;
            {
                this.$hostileCivs = $hostileCivs;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<City, City> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$hostileCivs.contains(it.getSecond().getCiv());
            }
        });
        Iterator<Pair<City, City>> iterator2 = closeCities2.iterator();
        if (!iterator2.hasNext()) {
            object = null;
        } else {
            Object it = iterator2.next();
            boolean bl = false;
            it = ((Pair)it).getFirst().getCenterTile().aerialDistanceTo(((Pair)it).getSecond().getCenterTile());
            while (iterator2.hasNext()) {
                Pair<City, City> it2 = iterator2.next();
                $i$a$-minOfOrNull-UnitAutomation$tryPrepare$closestDistance$1 = false;
                Comparable comparable = Integer.valueOf(it2.getFirst().getCenterTile().aerialDistanceTo(it2.getSecond().getCenterTile()));
                if (it.compareTo(comparable) <= 0) continue;
                it = comparable;
            }
            object = it;
        }
        Integer n = (Integer)object;
        if (n == null) {
            return false;
        }
        int closestDistance = n;
        Object object2 = SequencesKt.distinct(SequencesKt.map(SequencesKt.filter(closeCities2, (Function1)new Function1<Pair<? extends City, ? extends City>, Boolean>(closestDistance){
            final /* synthetic */ int $closestDistance;
            {
                this.$closestDistance = $closestDistance;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Pair<City, City> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getFirst().getCenterTile().aerialDistanceTo(it.getSecond().getCenterTile()) <= this.$closestDistance + 2;
            }
        }), tryPrepare.citiesToDefend.2.INSTANCE));
        boolean $i$f$sortedBy = false;
        Sequence citiesToDefend2 = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
            final /* synthetic */ MapUnit $unit$inlined;
            {
                this.$unit$inlined = mapUnit;
            }

            public final int compare(T a, T b) {
                City it = (City)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(this.$unit$inlined.getTile().aerialDistanceTo(it.getCenterTile()));
                it = (City)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, this.$unit$inlined.getTile().aerialDistanceTo(it.getCenterTile()));
            }
        });
        object2 = citiesToDefend2.iterator();
        while (object2.hasNext()) {
            Tile tile;
            block7: {
                City city2 = (City)object2.next();
                if (unit.getTile().aerialDistanceTo(city2.getCenterTile()) <= 2) {
                    return true;
                }
                Sequence<Tile> $this$firstOrNull$iv = city2.getCenterTile().getTilesInDistance(2);
                boolean $i$f$firstOrNull = false;
                Iterator<Tile> iterator3 = $this$firstOrNull$iv.iterator();
                while (iterator3.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator3.next();
                    boolean bl = false;
                    if (!(UnitMovement.canMoveTo$default(unit.getMovement(), it, false, false, false, 14, null) && unit.getMovement().canReach(it))) continue;
                    tile = element$iv;
                    break block7;
                }
                tile = null;
            }
            Tile tile2 = tile;
            if (tile2 == null) continue;
            Tile tileToMoveTo2 = tile2;
            unit.getMovement().headTowards(tileToMoveTo2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryAccompanySettlerOrGreatPerson(MapUnit unit) {
        Object v1;
        block2: {
            void $this$firstOrNull$iv;
            PathsToTilesWithinTurn distanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
            Sequence<MapUnit> sequence = unit.getCiv().getUnits().getCivUnits();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MapUnit it = (MapUnit)element$iv;
                boolean bl = false;
                Tile tile = it.getCurrentTile();
                boolean bl2 = it.isCivilian() && (MapUnit.hasUnique$default(it, UniqueType.FoundCity, null, false, 6, null) || unit.isGreatPerson()) && (Intrinsics.areEqual(tile, unit.getCurrentTile()) || tile.getMilitaryUnit() == null && UnitMovement.canMoveTo$default(unit.getMovement(), tile, false, false, false, 14, null)) && distanceToTiles.containsKey((Object)tile);
                if (!bl2) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        MapUnit mapUnit = v1;
        if (mapUnit == null) {
            return false;
        }
        MapUnit settlerOrGreatPersonToAccompany = mapUnit;
        unit.getMovement().headTowards(settlerOrGreatPersonToAccompany.getCurrentTile());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryHeadTowardsOurSiegedCity(MapUnit unit) {
        Object v2;
        block5: {
            void $this$firstOrNull$iv;
            Sequence $this$sortedBy$iv;
            boolean bl;
            Sequence siegedCities2;
            block4: {
                Sequence $this$any$iv = siegedCities2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)unit.getCiv().getCities()), (Function1)new Function1<City, Boolean>(unit){
                    final /* synthetic */ MapUnit $unit;
                    {
                        this.$unit = $unit;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull City it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return Intrinsics.areEqual(this.$unit.getCiv(), it.getCiv()) && (double)it.getHealth() < (double)it.getMaxHealth$core() * 0.75;
                    }
                });
                boolean $i$f$any = false;
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    City it = (City)element$iv;
                    boolean bl2 = false;
                    if (!(it.getCenterTile().aerialDistanceTo(unit.getTile()) <= 2)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
            Sequence $i$f$any = SequencesKt.flatMap(siegedCities2, tryHeadTowardsOurSiegedCity.reachableTileNearSiegedCity.1.INSTANCE);
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Tile it = (Tile)element$iv;
                boolean bl3 = false;
                boolean bl4 = UnitMovement.canMoveTo$default(unit.getMovement(), it, false, false, false, 14, null) && unit.getMovement().canReach(it) && unit.getDamageFromTerrain(it) <= 0;
                if (!bl4) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        Tile reachableTileNearSiegedCity2 = v2;
        if (reachableTileNearSiegedCity2 != null) {
            unit.getMovement().headTowards(reachableTileNearSiegedCity2);
        }
        return !unit.hasMovement();
    }

    public final boolean tryEnterOwnClosestCity(@NotNull MapUnit unit) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Sequence $this$sortedBy$iv = CollectionsKt.asSequence((Iterable)unit.getCiv().getCities());
            boolean $i$f$sortedBy = false;
            Sequence $this$firstOrNull$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    City it = (City)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getCenterTile().aerialDistanceTo(this.$unit$inlined.getTile()));
                    it = (City)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getCenterTile().aerialDistanceTo(this.$unit$inlined.getTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                City it = (City)element$iv;
                boolean bl = false;
                if (!unit.getMovement().canReach(it.getCenterTile())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        City city2 = v0;
        if (city2 == null) {
            return false;
        }
        City closestCity = city2;
        unit.getMovement().headTowards(closestCity.getCenterTile());
        return true;
    }

    public final boolean tryBombardEnemy(@NotNull City city2) {
        Intrinsics.checkNotNullParameter(city2, "city");
        if (!city2.canBombard()) {
            return false;
        }
        ICombatant iCombatant = this.chooseBombardTarget(city2);
        if (iCombatant == null) {
            return false;
        }
        ICombatant enemy = iCombatant;
        Battle.INSTANCE.attack(new CityCombatant(city2), enemy);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final ICombatant chooseBombardTarget(City city2) {
        Iterator<Object> iterator2;
        ICombatant target;
        Iterator<Object> iterator3;
        void $this$filterTo$iv$iv;
        Map hitsToKill;
        Iterator it;
        Sequence targets2 = SequencesKt.filterNot(SequencesKt.map(TargetHelper.INSTANCE.getBombardableTiles(city2), chooseBombardTarget.targets.1.INSTANCE), chooseBombardTarget.targets.2.INSTANCE);
        if (SequencesKt.none(targets2)) {
            return null;
        }
        Sequence siegeUnits2 = SequencesKt.filter(targets2, chooseBombardTarget.siegeUnits.1.INSTANCE);
        Sequence nonEmbarkedSiege2 = SequencesKt.filter(siegeUnits2, chooseBombardTarget.nonEmbarkedSiege.1.INSTANCE);
        if (SequencesKt.any(nonEmbarkedSiege2)) {
            targets2 = nonEmbarkedSiege2;
        } else if (SequencesKt.any(siegeUnits2)) {
            targets2 = siegeUnits2;
        } else {
            Sequence rangedUnits2 = SequencesKt.filter(targets2, chooseBombardTarget.rangedUnits.1.INSTANCE);
            if (SequencesKt.any(rangedUnits2)) {
                targets2 = rangedUnits2;
            }
        }
        Sequence $this$associateWith$iv = targets2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Sequence $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo22 = false;
        Iterator<Object> iterator4 = $this$associateWithTo$iv$iv.iterator();
        while (iterator4.hasNext()) {
            Object element$iv$iv = iterator4.next();
            ICombatant iCombatant = (ICombatant)element$iv$iv;
            Object r = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Float f = Float.valueOf((float)it.getHealth() / RangesKt.coerceAtLeast((float)BattleDamage.calculateDamageToDefender$default(BattleDamage.INSTANCE, new CityCombatant(city2), it, null, 0.0f, 12, null), 1.0f));
            map2.put(r, f);
        }
        Map $this$filter$iv = hitsToKill = (Map)result$iv;
        boolean $i$f$filter = false;
        Map $i$f$associateWithTo22 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        it = $this$filterTo$iv$iv.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it2 = element$iv$iv = it.next();
            boolean bl = false;
            if (!(((Number)it2.getValue()).floatValue() <= 1.0f)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterable iterable = destination$iv$iv.entrySet();
        Iterator iterator5 = iterable.iterator();
        if (!iterator5.hasNext()) {
            iterator3 = null;
        } else {
            iterator4 = iterator5.next();
            if (!iterator5.hasNext()) {
                iterator3 = iterator4;
            } else {
                Map.Entry it22 = (Map.Entry)((Object)iterator4);
                boolean bl2 = false;
                int it22 = ((ICombatant)it22.getKey()).getAttackingStrength();
                do {
                    Object bl2 = iterator5.next();
                    Map.Entry it32 = (Map.Entry)bl2;
                    boolean $i$a$-maxByOrNull-UnitAutomation$chooseBombardTarget$target$3 = false;
                    int it32 = ((ICombatant)it32.getKey()).getAttackingStrength();
                    if (it22 >= it32) continue;
                    iterator4 = bl2;
                    it22 = it32;
                } while (iterator5.hasNext());
                iterator3 = iterator4;
            }
        }
        Map.Entry entry = (Map.Entry)((Object)iterator3);
        ICombatant iCombatant = target = entry != null ? (ICombatant)entry.getKey() : null;
        if (iCombatant != null) {
            return iCombatant;
        }
        iterable = hitsToKill.entrySet();
        iterator5 = iterable.iterator();
        if (!iterator5.hasNext()) {
            iterator2 = null;
        } else {
            iterator4 = iterator5.next();
            if (!iterator5.hasNext()) {
                iterator2 = iterator4;
            } else {
                Map.Entry it3 = (Map.Entry)((Object)iterator4);
                boolean bl = false;
                float f = ((Number)it3.getValue()).floatValue();
                do {
                    Object t = iterator5.next();
                    Map.Entry it4 = (Map.Entry)t;
                    $i$a$-minByOrNull-UnitAutomation$chooseBombardTarget$1 = false;
                    float f2 = ((Number)it4.getValue()).floatValue();
                    if (Float.compare(f, f2) <= 0) continue;
                    iterator4 = t;
                    f = f2;
                } while (iterator5.hasNext());
                iterator2 = iterator4;
            }
        }
        Map.Entry entry2 = (Map.Entry)((Object)iterator2);
        return entry2 != null ? (ICombatant)entry2.getKey() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryTakeBackCapturedCity(MapUnit unit) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            Sequence $this$sortedBy$iv;
            Sequence capturedCities2 = SequencesKt.filter(SequencesKt.flatMap(unit.getCiv().getKnownCivs(), tryTakeBackCapturedCity.capturedCities.1.INSTANCE), (Function1)new Function1<City, Boolean>(unit){
                final /* synthetic */ MapUnit $unit;
                {
                    this.$unit = $unit;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull City it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$unit.getCiv().isAtWarWith(it.getCiv()) && Intrinsics.areEqual(this.$unit.getCiv().getCivName(), it.getFoundingCiv()) && it.isInResistance() && it.getHealth() < it.getMaxHealth$core();
                }
            });
            if (unit.getBaseUnit().isRanged()) {
                capturedCities2 = SequencesKt.filterNot(capturedCities2, tryTakeBackCapturedCity.1.INSTANCE);
            }
            Sequence sequence = SequencesKt.map(capturedCities2, tryTakeBackCapturedCity.closestReachableCapturedCity.1.INSTANCE);
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getTile()));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Tile it = (Tile)element$iv;
                boolean bl = false;
                if (!unit.getMovement().canReach(it)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Tile closestReachableCapturedCity2 = v0;
        if (closestReachableCapturedCity2 != null) {
            return HeadTowardsEnemyCityAutomation.INSTANCE.headTowardsEnemyCity(unit, closestReachableCapturedCity2, UnitMovement.getShortestPath$default(unit.getMovement(), closestReachableCapturedCity2, false, 2, null));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryGarrisoningRangedLandUnit(MapUnit unit) {
        Object v3;
        block9: {
            void $this$firstOrNull$iv;
            Sequence $this$sortedBy$iv;
            Sequence sequence;
            City it;
            void $this$filterTo$iv$iv;
            if (unit.getBaseUnit().isMelee() || unit.getBaseUnit().isWaterUnit()) {
                return false;
            }
            Iterable $this$filter$iv = unit.getCiv().getCities();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (City)element$iv$iv;
                boolean bl = false;
                Tile centerTile = it.getCenterTile();
                boolean bl2 = centerTile.getMilitaryUnit() == null && UnitMovement.canMoveTo$default(unit.getMovement(), centerTile, false, false, false, 14, null);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List citiesWithoutGarrison = (List)destination$iv$iv;
            if (!unit.getCiv().isAtWar()) {
                if (unit.getTile().isCityCenter()) {
                    return true;
                }
                sequence = CollectionsKt.asSequence(citiesWithoutGarrison);
            } else {
                Sequence citiesWithoutGarrisonThatNeedDefending2;
                if (unit.getTile().isCityCenter()) {
                    City city2 = unit.getTile().getCity();
                    Intrinsics.checkNotNull(city2);
                    if (this.isCityThatNeedsDefendingInWartime(city2)) {
                        return true;
                    }
                }
                sequence = SequencesKt.any(citiesWithoutGarrisonThatNeedDefending2 = SequencesKt.filter(CollectionsKt.asSequence(citiesWithoutGarrison), tryGarrisoningRangedLandUnit.citiesToTry.citiesWithoutGarrisonThatNeedDefending.1.INSTANCE)) ? citiesWithoutGarrisonThatNeedDefending2 : CollectionsKt.asSequence(citiesWithoutGarrison);
            }
            Sequence citiesToTry2 = sequence;
            destination$iv$iv = citiesToTry2;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    City it = (City)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getCenterTile().aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                    it = (City)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getCenterTile().aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (City)element$iv;
                boolean bl = false;
                if (!unit.getMovement().canReach(it.getCenterTile())) continue;
                v3 = element$iv;
                break block9;
            }
            v3 = null;
        }
        City city3 = v3;
        if (city3 == null) {
            return false;
        }
        City closestReachableCityNeedsDefending = city3;
        unit.getMovement().headTowards(closestReachableCityNeedsDefending.getCenterTile());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCityThatNeedsDefendingInWartime(City city2) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        IsPartOfGameInfoSerialization it;
        Iterable $this$filterTo$iv$iv;
        if (city2.getHealth() < city2.getMaxHealth$core()) {
            return true;
        }
        Collection<DiplomacyManager> collection = city2.getCiv().getDiplomacy().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DiplomacyManager)element$iv$iv;
            boolean bl = false;
            if (!(((DiplomacyManager)it).getDiplomaticStatus() == DiplomaticStatus.War)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DiplomacyManager)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((DiplomacyManager)it).otherCiv());
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ((Civilization)it).getCities();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        for (City enemyCivCity : (List)destination$iv$iv) {
            if (city2.getCenterTile().aerialDistanceTo(enemyCivCity.getCenterTile()) > 5) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryStationingMeleeNavalUnit(MapUnit unit) {
        Object v3;
        block14: {
            City it;
            Iterable $this$filterTo$iv$iv;
            Tile tile;
            IsPartOfGameInfoSerialization it2;
            Object element$iv;
            Iterator<Tile> iterator2;
            boolean $i$f$firstOrNull;
            Sequence<Tile> $this$firstOrNull$iv;
            block11: {
                if (!UnitAutomation.tryStationingMeleeNavalUnit$isMeleeNaval(unit)) {
                    return false;
                }
                $this$firstOrNull$iv = unit.getTile().getTilesInDistance(3);
                $i$f$firstOrNull = false;
                iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    it2 = element$iv;
                    boolean bl = false;
                    if (!it2.isCityCenter()) continue;
                    tile = element$iv;
                    break block11;
                }
                tile = null;
            }
            Tile closeCity = tile;
            if (closeCity != null) {
                Object object;
                block12: {
                    $this$firstOrNull$iv = SequencesKt.flatMap(closeCity.getTilesInDistance(3), tryStationingMeleeNavalUnit.1.INSTANCE);
                    $i$f$firstOrNull = false;
                    iterator2 = $this$firstOrNull$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        it2 = (MapUnit)element$iv;
                        boolean bl = false;
                        if (!UnitAutomation.tryStationingMeleeNavalUnit$isMeleeNaval((MapUnit)it2)) continue;
                        object = element$iv;
                        break block12;
                    }
                    object = null;
                }
                if (Intrinsics.areEqual(object, unit) && unit.getMovement().canReach(closeCity)) {
                    unit.getMovement().headTowards(closeCity);
                    return true;
                }
            }
            Iterable $this$filter$iv = unit.getCiv().getCities();
            boolean $i$f$filter = false;
            element$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (City)element$iv$iv;
                boolean bl = false;
                if (!it.isCoastal()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (City)element$iv$iv;
                boolean bl = false;
                if (!(it.getCenterTile().aerialDistanceTo(unit.getTile()) < 20)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block13: {
                    void $this$none$iv;
                    it = (City)element$iv$iv;
                    boolean bl2 = false;
                    Sequence sequence = SequencesKt.flatMap(it.getCenterTile().getTilesInDistance(3), tryStationingMeleeNavalUnit.citiesWithoutNavalDefence.3.1.INSTANCE);
                    boolean $i$f$none = false;
                    for (Object element$iv2 : $this$none$iv) {
                        MapUnit it3 = (MapUnit)element$iv2;
                        boolean bl3 = false;
                        if (!UnitAutomation.tryStationingMeleeNavalUnit$isMeleeNaval(it3)) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List citiesWithoutNavalDefence2 = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv2 = citiesWithoutNavalDefence2;
            boolean $i$f$firstOrNull2 = false;
            for (Object element$iv3 : $this$firstOrNull$iv2) {
                City it4 = (City)element$iv3;
                boolean bl = false;
                if (!unit.getMovement().canReach(it4.getCenterTile())) continue;
                v3 = element$iv3;
                break block14;
            }
            v3 = null;
        }
        City city2 = v3;
        if (city2 == null) {
            return false;
        }
        City reachableCity = city2;
        unit.getMovement().headTowards(reachableCity.getCenterTile());
        return true;
    }

    public final void automatedExplore(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (this.tryGoToRuinAndEncampment(unit) && (!unit.hasMovement() || unit.isDestroyed())) {
            return;
        }
        if (unit.getHealth() < 80 && this.tryHealUnit(unit)) {
            return;
        }
        if (this.tryExplore$core(unit)) {
            return;
        }
        String[] stringArray = new String[]{unit.getName(), "OtherIcons/Sleep"};
        unit.getCiv().addNotification(unit.shortDisplayName() + " finished exploring.", new MapUnitAction(unit), Notification.NotificationCategory.Units, stringArray);
        unit.setAction(null);
    }

    private static final boolean getUnitsToUpgradeTo$isInvalidUpgradeDestination(MapUnit $unit, BaseUnit baseUnit) {
        boolean bl;
        block3: {
            if (!$unit.getCiv().getTech().isResearched(baseUnit)) {
                return true;
            }
            if ($unit.getCiv().isBarbarian() && IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)baseUnit, UniqueType.CannotBeBarbarian, null, 2, null)) {
                return true;
            }
            Sequence<Unique> $this$any$iv = baseUnit.getMatchingUniques(UniqueType.OnlyAvailable, StateForConditionals.Companion.getIgnoreConditionals());
            boolean $i$f$any = false;
            Iterator<Unique> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Unique element$iv;
                Unique it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(!it.conditionalsApply($unit.getCache().getState()))) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean tryPrepare$hasPreparationFlag(Civilization civInfo, Civilization targetCiv) {
        DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(targetCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diploManager = diplomacyManager;
        if (diploManager.hasFlag(DiplomacyFlags.Denunciation) || diploManager.otherCivDiplomacy().hasFlag(DiplomacyFlags.Denunciation)) {
            return true;
        }
        return diploManager.hasFlag(DiplomacyFlags.WaryOf) && diploManager.getFlag(DiplomacyFlags.WaryOf) < 0;
    }

    private static final boolean tryStationingMeleeNavalUnit$isMeleeNaval(MapUnit mapUnit) {
        return mapUnit.getBaseUnit().isMelee() && mapUnit.getType().isWaterUnit();
    }

    public static final /* synthetic */ boolean access$getUnitsToUpgradeTo$isInvalidUpgradeDestination(MapUnit $unit, BaseUnit baseUnit) {
        return UnitAutomation.getUnitsToUpgradeTo$isInvalidUpgradeDestination($unit, baseUnit);
    }

    public static final /* synthetic */ boolean access$tryPrepare$hasPreparationFlag(Civilization civInfo, Civilization targetCiv) {
        return UnitAutomation.tryPrepare$hasPreparationFlag(civInfo, targetCiv);
    }

    public static final /* synthetic */ boolean access$isCityThatNeedsDefendingInWartime(UnitAutomation $this, City city2) {
        return $this.isCityThatNeedsDefendingInWartime(city2);
    }
}

