/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city;

import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.city.ConstructionAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.city.StatTreeNode;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.CivilopediaAction;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.UnitPromotions;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.multiplayer.MultiplayerKt;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.RejectionReason;
import com.unciv.models.ruleset.RejectionReasonType;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueMap;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.pickerscreens.PromotionTree;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.AutoPlay;
import com.unciv.utils.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\"\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00052\b\b\u0002\u0010<\u001a\u00020&J\u000e\u00109\u001a\u00020:2\u0006\u0010=\u001a\u00020\rJ\u000e\u0010>\u001a\u00020:2\u0006\u0010?\u001a\u000201J\u0018\u0010@\u001a\u00020:2\u0006\u0010A\u001a\u00020B2\b\b\u0002\u0010C\u001a\u00020&J\u000e\u0010@\u001a\u00020:2\u0006\u0010D\u001a\u00020\rJ\u001a\u0010E\u001a\u00020:2\u0006\u0010;\u001a\u00020\u00052\b\b\u0002\u0010F\u001a\u00020&H\u0002J\u000e\u0010G\u001a\u00020&2\u0006\u0010A\u001a\u00020BJ\u0006\u0010H\u001a\u00020&J\u0010\u0010I\u001a\u0004\u0018\u00010\u00052\u0006\u0010J\u001a\u00020KJ\u0006\u0010L\u001a\u00020:J\u0006\u0010M\u001a\u00020\u0000J\u000e\u0010N\u001a\u00020&2\u0006\u0010A\u001a\u00020OJ\u0006\u0010P\u001a\u00020:J\u0010\u0010Q\u001a\u00020:2\u0006\u0010A\u001a\u00020BH\u0002J\u000e\u0010R\u001a\u00020&2\u0006\u0010S\u001a\u00020\rJ\u000e\u0010T\u001a\u00020:2\u0006\u0010U\u001a\u00020VJ\u0013\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00050XH\u0000\u00a2\u0006\u0002\bYJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050XJ\u0006\u0010Z\u001a\u00020\rJ\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0XJ\u0015\u0010]\u001a\u00020B2\u0006\u0010D\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b^J\u0006\u0010_\u001a\u00020BJ\u0006\u0010`\u001a\u000201J\u000e\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020dJ\u0018\u0010e\u001a\u0002012\u0006\u0010D\u001a\u00020\r2\b\b\u0002\u0010f\u001a\u00020&J\u000e\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020jJ\u0010\u0010k\u001a\u0004\u0018\u00010l2\u0006\u0010m\u001a\u00020\rJ\u001f\u0010n\u001a\u00020\r2\u0006\u0010A\u001a\u00020B2\b\b\u0002\u0010f\u001a\u00020&H\u0000\u00a2\u0006\u0002\boJ\u001f\u0010n\u001a\u00020\r2\u0006\u0010D\u001a\u00020\r2\b\b\u0002\u0010f\u001a\u00020&H\u0000\u00a2\u0006\u0002\boJ\u000e\u0010p\u001a\u0002012\u0006\u0010D\u001a\u00020\rJ\u000e\u0010q\u001a\u00020&2\u0006\u0010D\u001a\u00020\rJ\u000e\u0010r\u001a\u00020&2\u0006\u0010D\u001a\u00020\rJ\u0006\u0010s\u001a\u00020&J\u000e\u0010t\u001a\u00020&2\u0006\u0010=\u001a\u00020\rJ\u001e\u0010u\u001a\u00020&2\u0006\u0010A\u001a\u00020O2\u0006\u0010J\u001a\u00020K2\u0006\u0010v\u001a\u000201J\u000e\u0010w\u001a\u00020&2\u0006\u0010A\u001a\u00020OJ\u000e\u0010x\u001a\u00020&2\u0006\u0010D\u001a\u00020\rJ\u0016\u0010y\u001a\u00020&2\u0006\u0010z\u001a\u0002012\u0006\u0010{\u001a\u00020\rJ\b\u0010|\u001a\u00020&H\u0002J\u0006\u0010}\u001a\u00020&J\u0006\u0010~\u001a\u00020&J\u000e\u0010\u007f\u001a\u0002012\u0006\u0010z\u001a\u000201J\u000f\u0010\u0080\u0001\u001a\u00020:2\u0006\u0010z\u001a\u000201J\u000f\u0010\u0081\u0001\u001a\u00020:2\u0006\u0010z\u001a\u000201J\u000f\u0010\u0082\u0001\u001a\u0002012\u0006\u0010D\u001a\u00020\rJ8\u0010\u0083\u0001\u001a\u00020&2\u0006\u0010A\u001a\u00020O2\u0007\u0010\u0084\u0001\u001a\u0002012\u0007\u0010\u0085\u0001\u001a\u00020&2\b\b\u0002\u0010J\u001a\u00020K2\u000b\b\u0002\u0010\u0086\u0001\u001a\u0004\u0018\u00010lJ8\u0010\u0083\u0001\u001a\u00020&2\u0006\u0010D\u001a\u00020\r2\u0007\u0010\u0084\u0001\u001a\u0002012\u0007\u0010\u0085\u0001\u001a\u00020&2\b\b\u0002\u0010J\u001a\u00020K2\u000b\b\u0002\u0010\u0086\u0001\u001a\u0004\u0018\u00010lJ\u000f\u0010\u0087\u0001\u001a\u0002012\u0006\u0010z\u001a\u000201J\u000f\u0010\u0088\u0001\u001a\u00020:2\u0006\u0010D\u001a\u00020\rJ\u000f\u0010\u0089\u0001\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0005J\u000f\u0010\u0089\u0001\u001a\u00020:2\u0006\u0010=\u001a\u00020\rJ\u0017\u0010\u008a\u0001\u001a\u00020:2\u000e\u0010\u008b\u0001\u001a\t\u0012\u0004\u0012\u00020\u00050\u008c\u0001J\u0010\u0010\u008d\u0001\u001a\u00020:2\u0007\u0010\u008e\u0001\u001a\u00020\rJ\t\u0010\u008f\u0001\u001a\u00020:H\u0002J\u0018\u0010\u0090\u0001\u001a\u00020:2\u0006\u0010z\u001a\u0002012\u0007\u0010\u0085\u0001\u001a\u00020&J\u0007\u0010\u0091\u0001\u001a\u00020:J\u000f\u0010\u0092\u0001\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0005J\u0019\u0010\u0093\u0001\u001a\u0002012\u0006\u0010D\u001a\u00020\r2\b\b\u0002\u0010f\u001a\u00020&J\u0012\u0010\u0094\u0001\u001a\u00020:2\t\b\u0002\u0010\u0095\u0001\u001a\u00020&J\t\u0010\u0096\u0001\u001a\u00020:H\u0002J\u0007\u0010\u0097\u0001\u001a\u00020:J%\u0010\u0098\u0001\u001a\u00020:*\b\u0012\u0004\u0012\u00020\r0\u001a2\u0007\u0010\u0099\u0001\u001a\u0002012\u0007\u0010\u009a\u0001\u001a\u000201H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR*\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010 \u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*RC\u0010+\u001a4\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0,j\u001e\u0012\u0004\u0012\u00020\r\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e`-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R-\u00100\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002010,j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u000201`-\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010/R\u001a\u00103\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u00108\u001a\u000201X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u009b\u0001"}, d2={"Lcom/unciv/logic/city/CityConstructions;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "()V", "builtBuildingObjects", "Ljava/util/ArrayList;", "Lcom/unciv/models/ruleset/Building;", "Lkotlin/collections/ArrayList;", "builtBuildingUniqueMap", "Lcom/unciv/models/ruleset/unique/UniqueMap;", "getBuiltBuildingUniqueMap", "()Lcom/unciv/models/ruleset/unique/UniqueMap;", "builtBuildings", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getBuiltBuildings", "()Ljava/util/HashSet;", "setBuiltBuildings", "(Ljava/util/HashSet;)V", "city", "Lcom/unciv/logic/city/City;", "getCity", "()Lcom/unciv/logic/city/City;", "setCity", "(Lcom/unciv/logic/city/City;)V", "constructionQueue", "", "getConstructionQueue", "()Ljava/util/List;", "setConstructionQueue", "(Ljava/util/List;)V", "value", "currentConstructionFromQueue", "getCurrentConstructionFromQueue", "()Ljava/lang/String;", "setCurrentConstructionFromQueue", "(Ljava/lang/String;)V", "currentConstructionIsUserSet", "", "getCurrentConstructionIsUserSet", "()Z", "setCurrentConstructionIsUserSet", "(Z)V", "freeBuildingsProvidedFromThisCity", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getFreeBuildingsProvidedFromThisCity", "()Ljava/util/HashMap;", "inProgressConstructions", "", "getInProgressConstructions", "productionOverflow", "getProductionOverflow", "()I", "setProductionOverflow", "(I)V", "queueMaxSize", "addBuilding", "", "building", "tryAddFreeBuildings", "buildingName", "addProductionPoints", "productionToAdd", "addToQueue", "construction", "Lcom/unciv/models/ruleset/IConstruction;", "addToTop", "constructionName", "applyCreateOneImprovement", "removeOnly", "canAddToQueue", "canBeHurried", "cheapestStatBuilding", "stat", "Lcom/unciv/models/stats/Stat;", "chooseNextConstruction", "clone", "completeConstruction", "Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "constructIfEnough", "constructionBegun", "containsBuildingOrEquivalent", "buildingNameOrUnique", "endTurn", "cityStats", "Lcom/unciv/models/stats/Stats;", "getBuildableBuildings", "Lkotlin/sequences/Sequence;", "getBuildableBuildings$core", "getCityProductionTextForCityButton", "getConstructableUnits", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "getConstruction", "getConstruction$core", "getCurrentConstruction", "getMaintenanceCosts", "getProductionMarkup", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getRemainingWork", "useStoredProduction", "getStats", "Lcom/unciv/logic/city/StatTreeNode;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "getTileForImprovement", "Lcom/unciv/logic/map/tile/Tile;", "improvementName", "getTurnsToConstructionString", "getTurnsToConstructionString$core", "getWorkDone", "isBeingConstructed", "isBeingConstructedOrEnqueued", "isBuildingWonder", "isBuilt", "isConstructionPurchaseAllowed", "constructionBuyCost", "isConstructionPurchaseBlockedByUnit", "isEnqueuedForLater", "isFirstConstructionOfItsKind", "constructionQueueIndex", "name", "isLastConstructionPerpetual", "isQueueEmptyOrIdle", "isQueueFull", "lowerPriority", "moveEntryToEnd", "moveEntryToTop", "productionForConstruction", "purchaseConstruction", "queuePosition", "automatic", "tile", "raisePriority", "removeAllByName", "removeBuilding", "removeBuildings", "buildings", "", "removeCreateOneImprovementConstruction", "improvement", "removeCurrentConstruction", "removeFromQueue", "setTransients", "triggerNewBuildingUniques", "turnsToConstruction", "updateUniques", "onLoadGame", "validateConstructionQueue", "validateInProgressConstructions", "swap", "idx1", "idx2", "core"})
@SourceDebugExtension(value={"SMAP\nCityConstructions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityConstructions.kt\ncom/unciv/logic/city/CityConstructions\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,960:1\n1247#2,2:961\n1247#2,2:966\n1839#2,14:968\n1247#2,2:992\n1839#2,14:994\n1224#2,2:1008\n1247#2,2:1025\n179#2,2:1028\n766#3:963\n857#3,2:964\n1549#3:982\n1620#3,3:983\n766#3:989\n857#3,2:990\n766#3:1010\n857#3,2:1011\n1747#3,3:1013\n766#3:1016\n857#3,2:1017\n1855#3,2:1019\n1549#3:1021\n1620#3,3:1022\n187#4,3:986\n1#5:1027\n*S KotlinDebug\n*F\n+ 1 CityConstructions.kt\ncom/unciv/logic/city/CityConstructions\n*L\n155#1:961,2\n245#1:966,2\n301#1:968,14\n403#1:992,2\n421#1:994,14\n422#1:1008,2\n717#1:1025,2\n955#1:1028,2\n159#1:963\n159#1:964,2\n308#1:982\n308#1:983,3\n394#1:989\n394#1:990,2\n483#1:1010\n483#1:1011,2\n584#1:1013,3\n585#1:1016\n585#1:1017,2\n585#1:1019,2\n624#1:1021\n624#1:1022,3\n379#1:986,3\n*E\n"})
public final class CityConstructions
implements IsPartOfGameInfoSerialization {
    public transient City city;
    @NotNull
    private transient ArrayList<Building> builtBuildingObjects = new ArrayList();
    @NotNull
    private final transient UniqueMap builtBuildingUniqueMap = new UniqueMap();
    @NotNull
    private HashSet<String> builtBuildings = new HashSet();
    @NotNull
    private final HashMap<String, Integer> inProgressConstructions = new HashMap();
    private boolean currentConstructionIsUserSet;
    @NotNull
    private List<String> constructionQueue = new ArrayList();
    private int productionOverflow;
    private final int queueMaxSize;
    @NotNull
    private final HashMap<String, HashSet<String>> freeBuildingsProvidedFromThisCity = new HashMap();

    public CityConstructions() {
        this.queueMaxSize = 10;
    }

    @NotNull
    public final City getCity() {
        City city2 = this.city;
        if (city2 != null) {
            return city2;
        }
        Intrinsics.throwUninitializedPropertyAccessException("city");
        return null;
    }

    public final void setCity(@NotNull City city2) {
        Intrinsics.checkNotNullParameter(city2, "<set-?>");
        this.city = city2;
    }

    @NotNull
    public final UniqueMap getBuiltBuildingUniqueMap() {
        return this.builtBuildingUniqueMap;
    }

    @NotNull
    public final String getCurrentConstructionFromQueue() {
        return this.constructionQueue.isEmpty() ? "" : CollectionsKt.first(this.constructionQueue);
    }

    public final void setCurrentConstructionFromQueue(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (this.constructionQueue.isEmpty()) {
            this.constructionQueue.add(value);
        } else {
            this.constructionQueue.set(0, value);
        }
    }

    @NotNull
    public final HashSet<String> getBuiltBuildings() {
        return this.builtBuildings;
    }

    public final void setBuiltBuildings(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, "<set-?>");
        this.builtBuildings = hashSet;
    }

    @NotNull
    public final HashMap<String, Integer> getInProgressConstructions() {
        return this.inProgressConstructions;
    }

    public final boolean getCurrentConstructionIsUserSet() {
        return this.currentConstructionIsUserSet;
    }

    public final void setCurrentConstructionIsUserSet(boolean bl) {
        this.currentConstructionIsUserSet = bl;
    }

    @NotNull
    public final List<String> getConstructionQueue() {
        return this.constructionQueue;
    }

    public final void setConstructionQueue(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.constructionQueue = list2;
    }

    public final int getProductionOverflow() {
        return this.productionOverflow;
    }

    public final void setProductionOverflow(int n) {
        this.productionOverflow = n;
    }

    @NotNull
    public final HashMap<String, HashSet<String>> getFreeBuildingsProvidedFromThisCity() {
        return this.freeBuildingsProvidedFromThisCity;
    }

    @NotNull
    public final CityConstructions clone() {
        CityConstructions toReturn = new CityConstructions();
        toReturn.builtBuildings.addAll((Collection<String>)this.builtBuildings);
        toReturn.inProgressConstructions.putAll((Map<String, Integer>)this.inProgressConstructions);
        toReturn.currentConstructionIsUserSet = this.currentConstructionIsUserSet;
        toReturn.constructionQueue.addAll((Collection<String>)this.constructionQueue);
        toReturn.productionOverflow = this.productionOverflow;
        toReturn.freeBuildingsProvidedFromThisCity.putAll((Map<String, HashSet<String>>)this.freeBuildingsProvidedFromThisCity);
        return toReturn;
    }

    @NotNull
    public final Sequence<Building> getBuildableBuildings$core() {
        Collection<Building> collection = this.getCity().getRuleset().getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), (Function1)new Function1<Building, Boolean>(this){
            final /* synthetic */ CityConstructions this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Building it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isBuildable(this.this$0);
            }
        });
    }

    @NotNull
    public final Sequence<BaseUnit> getConstructableUnits() {
        Collection<BaseUnit> collection = this.getCity().getRuleset().getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), (Function1)new Function1<BaseUnit, Boolean>(this){
            final /* synthetic */ CityConstructions this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull BaseUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isBuildable(this.this$0);
            }
        });
    }

    @NotNull
    public final StatTreeNode getStats(@NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        StatTreeNode stats2 = new StatTreeNode();
        Iterator<Building> iterator2 = this.getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Building building = iterator2.next();
            String[] stringArray = new String[]{building.getName()};
            stats2.addStats(building.getStats(this.getCity(), localUniqueCache), stringArray);
        }
        return stats2;
    }

    public final int getMaintenanceCosts() {
        int maintenanceCost = 0;
        Set<String> freeBuildings = this.getCity().getCiv().getCivConstructions().getFreeBuildingNames(this.getCity());
        Iterator<Building> iterator2 = this.getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Building building = iterator2.next();
            if (freeBuildings.contains(building.getName())) continue;
            maintenanceCost += building.getMaintenance();
        }
        return maintenanceCost;
    }

    @NotNull
    public final String getCityProductionTextForCityButton() {
        String currentConstructionSnapshot = this.getCurrentConstructionFromQueue();
        String result2 = TranslationsKt.tr$default(currentConstructionSnapshot, true, false, 2, null);
        if (((CharSequence)currentConstructionSnapshot).length() > 0) {
            PerpetualConstruction construction2 = PerpetualConstruction.Companion.getPerpetualConstructionsMap().get(currentConstructionSnapshot);
            StringBuilder stringBuilder = new StringBuilder().append(result2);
            Object object = construction2;
            if (object == null || (object = PerpetualConstruction.getProductionTooltip$default((PerpetualConstruction)object, this.getCity(), false, 2, null)) == null) {
                object = CityConstructions.getTurnsToConstructionString$core$default(this, currentConstructionSnapshot, false, 2, null);
            }
            result2 = stringBuilder.append((String)object).toString();
        }
        return result2;
    }

    @NotNull
    public final String getTurnsToConstructionString$core(@NotNull String constructionName, boolean useStoredProduction) {
        Intrinsics.checkNotNullParameter(constructionName, "constructionName");
        return this.getTurnsToConstructionString$core(this.getConstruction$core(constructionName), useStoredProduction);
    }

    public static /* synthetic */ String getTurnsToConstructionString$core$default(CityConstructions cityConstructions, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return cityConstructions.getTurnsToConstructionString$core(string, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getTurnsToConstructionString$core(@NotNull IConstruction construction2, boolean useStoredProduction) {
        void $this$filterTo$iv$iv;
        boolean buildable;
        boolean bl;
        Object element$iv2;
        ArrayList lines2;
        int currentProgress;
        int turnsToConstruction;
        int cost;
        block5: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(construction2, "construction");
            if (!(construction2 instanceof INonPerpetualConstruction)) {
                return "";
            }
            cost = ((INonPerpetualConstruction)construction2).getProductionCost(this.getCity().getCiv(), this.getCity());
            turnsToConstruction = this.turnsToConstruction(construction2.getName(), useStoredProduction);
            currentProgress = useStoredProduction ? this.getWorkDone(construction2.getName()) : 0;
            lines2 = new ArrayList();
            Sequence sequence = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)((Object)construction2), UniqueType.Unbuildable, null, 2, null);
            boolean $i$f$any = false;
            for (Object element$iv2 : $this$any$iv) {
                Unique it = (Unique)element$iv2;
                boolean bl2 = false;
                if (!it.conditionalsApply(this.getCity().getState())) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        boolean bl3 = buildable = !bl;
        if (buildable) {
            ((Collection)lines2).add((currentProgress == 0 ? "" : "" + currentProgress + '/') + cost + "\u2699 " + turnsToConstruction + '\u23f3');
        }
        Iterable $this$filter$iv = Stat.getEntries();
        boolean $i$f$filter = false;
        element$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Stat it = (Stat)element$iv$iv;
            boolean bl4 = false;
            boolean bl5 = (it != Stat.Gold || !buildable) && ((INonPerpetualConstruction)construction2).canBePurchasedWithStat(this.getCity(), it);
            if (!bl5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String otherStats2 = CollectionsKt.joinToString$default((List)destination$iv$iv, " / ", null, null, 0, null, new Function1<Stat, CharSequence>(construction2, this){
            final /* synthetic */ IConstruction $construction;
            final /* synthetic */ CityConstructions this$0;
            {
                this.$construction = $construction;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Stat it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return "" + ((INonPerpetualConstruction)this.$construction).getStatBuyCost(this.this$0.getCity(), it) + it.getCharacter();
            }
        }, 30, null);
        if (((CharSequence)otherStats2).length() > 0) {
            ((Collection)lines2).add(otherStats2);
        }
        return CollectionsKt.joinToString$default(lines2, "\n", "\n", null, 0, null, null, 60, null);
    }

    public static /* synthetic */ String getTurnsToConstructionString$core$default(CityConstructions cityConstructions, IConstruction iConstruction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return cityConstructions.getTurnsToConstructionString$core(iConstruction, bl);
    }

    @NotNull
    public final FormattedLine getProductionMarkup(@NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        String currentConstructionSnapshot = this.getCurrentConstructionFromQueue();
        if (((CharSequence)currentConstructionSnapshot).length() == 0) {
            return new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null);
        }
        Building building = ruleset2.getBuildings().get(currentConstructionSnapshot);
        String category = (building != null ? building.isAnyWonder() : false) ? "Wonder" : (((Map)ruleset2.getBuildings()).containsKey(currentConstructionSnapshot) ? "Building" : (((Map)ruleset2.getUnits()).containsKey(currentConstructionSnapshot) ? "Unit" : ""));
        String label2 = '{' + currentConstructionSnapshot + '}';
        if (!PerpetualConstruction.Companion.getPerpetualConstructionsMap().containsKey(currentConstructionSnapshot)) {
            int turnsLeft = CityConstructions.turnsToConstruction$default(this, currentConstructionSnapshot, false, 2, null);
            label2 = label2 + " - " + turnsLeft + '\u23f3';
        }
        return ((CharSequence)category).length() == 0 ? new FormattedLine(label2, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null) : new FormattedLine(label2, category + '/' + currentConstructionSnapshot, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null);
    }

    @NotNull
    public final IConstruction getCurrentConstruction() {
        return this.getConstruction$core(this.getCurrentConstructionFromQueue());
    }

    public final boolean isBuilt(@NotNull String buildingName) {
        Intrinsics.checkNotNullParameter(buildingName, "buildingName");
        return this.builtBuildings.contains(buildingName);
    }

    public final boolean isBeingConstructed(@NotNull String constructionName) {
        Intrinsics.checkNotNullParameter(constructionName, "constructionName");
        return Intrinsics.areEqual(this.getCurrentConstructionFromQueue(), constructionName);
    }

    public final boolean isEnqueuedForLater(@NotNull String constructionName) {
        Intrinsics.checkNotNullParameter(constructionName, "constructionName");
        return this.constructionQueue.indexOf(constructionName) > 0;
    }

    public final boolean isBeingConstructedOrEnqueued(@NotNull String constructionName) {
        Intrinsics.checkNotNullParameter(constructionName, "constructionName");
        return this.constructionQueue.contains(constructionName);
    }

    public final boolean isQueueFull() {
        return this.constructionQueue.size() >= this.queueMaxSize;
    }

    public final boolean isBuildingWonder() {
        IConstruction currentConstruction = this.getCurrentConstruction();
        return currentConstruction instanceof Building && ((Building)currentConstruction).isWonder();
    }

    public final boolean canBeHurried() {
        IConstruction currentConstruction = this.getCurrentConstruction();
        return currentConstruction instanceof INonPerpetualConstruction && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)((Object)currentConstruction), UniqueType.CannotBeHurried, null, 2, null);
    }

    public final boolean isFirstConstructionOfItsKind(int constructionQueueIndex, @NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return constructionQueueIndex == this.constructionQueue.indexOf(name2);
    }

    @NotNull
    public final IConstruction getConstruction$core(@NotNull String constructionName) {
        Intrinsics.checkNotNullParameter(constructionName, "constructionName");
        Ruleset gameBasics = this.getCity().getRuleset();
        if (Intrinsics.areEqual(constructionName, "")) {
            return PerpetualConstruction.Companion.getIdle();
        }
        if (gameBasics.getBuildings().containsKey(constructionName)) {
            Building building = gameBasics.getBuildings().get(constructionName);
            Intrinsics.checkNotNull(building);
            return building;
        }
        if (gameBasics.getUnits().containsKey(constructionName)) {
            BaseUnit baseUnit = gameBasics.getUnits().get(constructionName);
            Intrinsics.checkNotNull(baseUnit);
            return baseUnit;
        }
        PerpetualConstruction special = PerpetualConstruction.Companion.getPerpetualConstructionsMap().get(constructionName);
        if (special != null) {
            return special;
        }
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"com/unciv/logic/city/CityConstructions$getConstruction$NotBuildingOrUnitException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "core"})
        public final class NotBuildingOrUnitException
        extends Exception {
            public NotBuildingOrUnitException(@NotNull String message2) {
                Intrinsics.checkNotNullParameter(message2, "message");
                super(message2);
            }
        }
        throw new NotBuildingOrUnitException(constructionName + " is not a building or a unit!");
    }

    @NotNull
    public final Sequence<Building> getBuiltBuildings() {
        return CollectionsKt.asSequence((Iterable)this.builtBuildingObjects);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsBuildingOrEquivalent(@NotNull String buildingNameOrUnique) {
        boolean bl;
        Intrinsics.checkNotNullParameter(buildingNameOrUnique, "buildingNameOrUnique");
        if (this.isBuilt(buildingNameOrUnique)) return true;
        Sequence<Building> $this$any$iv = this.getBuiltBuildings();
        boolean $i$f$any = false;
        Iterator<Building> iterator2 = $this$any$iv.iterator();
        do {
            Building element$iv;
            if (!iterator2.hasNext()) return false;
            Building it = element$iv = iterator2.next();
            boolean bl2 = false;
            if (Intrinsics.areEqual(it.getReplaces(), buildingNameOrUnique)) return true;
            if (it.hasUnique(buildingNameOrUnique, this.getCity().getState())) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public final int getWorkDone(@NotNull String constructionName) {
        int n;
        Intrinsics.checkNotNullParameter(constructionName, "constructionName");
        if (this.inProgressConstructions.containsKey(constructionName)) {
            Integer n2 = this.inProgressConstructions.get(constructionName);
            Intrinsics.checkNotNull(n2);
            n = ((Number)n2).intValue();
        } else {
            n = 0;
        }
        return n;
    }

    public final int getRemainingWork(@NotNull String constructionName, boolean useStoredProduction) {
        int n;
        Intrinsics.checkNotNullParameter(constructionName, "constructionName");
        IConstruction constr = this.getConstruction$core(constructionName);
        if (constr instanceof PerpetualConstruction) {
            n = 0;
        } else if (useStoredProduction) {
            Intrinsics.checkNotNull(constr, "null cannot be cast to non-null type com.unciv.models.ruleset.INonPerpetualConstruction");
            n = ((INonPerpetualConstruction)constr).getProductionCost(this.getCity().getCiv(), this.getCity()) - this.getWorkDone(constructionName);
        } else {
            Intrinsics.checkNotNull(constr, "null cannot be cast to non-null type com.unciv.models.ruleset.INonPerpetualConstruction");
            n = ((INonPerpetualConstruction)constr).getProductionCost(this.getCity().getCiv(), this.getCity());
        }
        return n;
    }

    public static /* synthetic */ int getRemainingWork$default(CityConstructions cityConstructions, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return cityConstructions.getRemainingWork(string, bl);
    }

    public final int turnsToConstruction(@NotNull String constructionName, boolean useStoredProduction) {
        Intrinsics.checkNotNullParameter(constructionName, "constructionName");
        int workLeft = this.getRemainingWork(constructionName, useStoredProduction);
        if (workLeft <= 0) {
            return 0;
        }
        if (workLeft <= this.productionOverflow) {
            return 1;
        }
        return (int)Math.ceil((double)(workLeft - this.productionOverflow) / (double)this.productionForConstruction(constructionName));
    }

    public static /* synthetic */ int turnsToConstruction$default(CityConstructions cityConstructions, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return cityConstructions.turnsToConstruction(string, bl);
    }

    public final int productionForConstruction(@NotNull String constructionName) {
        Intrinsics.checkNotNullParameter(constructionName, "constructionName");
        Stats cityStatsForConstruction = null;
        if (Intrinsics.areEqual(this.getCurrentConstructionFromQueue(), constructionName)) {
            cityStatsForConstruction = this.getCity().getCityStats().getCurrentCityStats();
        } else {
            CityStats cityStats = new CityStats(this.getCity());
            cityStats.setStatsFromTiles(this.getCity().getCityStats().getStatsFromTiles());
            IConstruction construction2 = this.getCity().getCityConstructions().getConstruction$core(constructionName);
            CityStats.update$default(cityStats, construction2, false, false, null, 8, null);
            cityStatsForConstruction = cityStats.getCurrentCityStats();
        }
        return MathKt.roundToInt(cityStatsForConstruction.getProduction());
    }

    @Nullable
    public final Building cheapestStatBuilding(@NotNull Stat stat) {
        Object v1;
        Intrinsics.checkNotNullParameter(stat, "stat");
        Collection<Building> collection = this.getCity().getRuleset().getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Sequence $this$minByOrNull$iv = SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), (Function1)new Function1<Building, Boolean>(stat, this){
            final /* synthetic */ Stat $stat;
            final /* synthetic */ CityConstructions this$0;
            {
                this.$stat = $stat;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Building it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !it.isAnyWonder() && it.isStatRelated(this.$stat, this.this$0.getCity()) && (it.isBuildable(this.this$0) || this.this$0.isBeingConstructedOrEnqueued(it.getName()));
            }
        });
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = minElem$iv;
            } else {
                Building it = (Building)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getCost();
                do {
                    Object e$iv = iterator$iv.next();
                    Building it2 = (Building)e$iv;
                    $i$a$-minByOrNull-CityConstructions$cheapestStatBuilding$2 = false;
                    int v$iv = it2.getCost();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = minElem$iv;
            }
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransients() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.builtBuildings;
        CityConstructions cityConstructions = this;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Building building = this.getCity().getRuleset().getBuildings().get(it);
            if (building == null) {
                throw new Exception("Building " + (String)it + " is not found!");
            }
            collection.add(building);
        }
        Collection collection = (List)destination$iv$iv;
        cityConstructions.builtBuildingObjects = new ArrayList(collection);
        this.updateUniques(true);
    }

    public final void addProductionPoints(int productionToAdd) {
        IConstruction construction2 = this.getConstruction$core(this.getCurrentConstructionFromQueue());
        if (construction2 instanceof PerpetualConstruction) {
            this.productionOverflow += productionToAdd;
            return;
        }
        if (!this.inProgressConstructions.containsKey(this.getCurrentConstructionFromQueue())) {
            ((Map)this.inProgressConstructions).put(this.getCurrentConstructionFromQueue(), 0);
        }
        Map map2 = this.inProgressConstructions;
        String string = this.getCurrentConstructionFromQueue();
        Integer n = this.inProgressConstructions.get(this.getCurrentConstructionFromQueue());
        Intrinsics.checkNotNull(n);
        map2.put(string, ((Number)n).intValue() + productionToAdd);
    }

    public final void constructIfEnough() {
        this.validateConstructionQueue();
        this.validateInProgressConstructions();
        IConstruction construction2 = this.getConstruction$core(this.getCurrentConstructionFromQueue());
        if (construction2 instanceof PerpetualConstruction) {
            this.chooseNextConstruction();
        } else {
            Intrinsics.checkNotNull(construction2, "null cannot be cast to non-null type com.unciv.models.ruleset.INonPerpetualConstruction");
            int productionCost = ((INonPerpetualConstruction)construction2).getProductionCost(this.getCity().getCiv(), this.getCity());
            if (this.inProgressConstructions.containsKey(this.getCurrentConstructionFromQueue())) {
                Integer n = this.inProgressConstructions.get(this.getCurrentConstructionFromQueue());
                Intrinsics.checkNotNull(n);
                if (((Number)n).intValue() >= productionCost) {
                    Integer n2 = this.inProgressConstructions.get(this.getCurrentConstructionFromQueue());
                    Intrinsics.checkNotNull(n2);
                    int potentialOverflow = ((Number)n2).intValue() - productionCost;
                    if (this.completeConstruction((INonPerpetualConstruction)construction2)) {
                        int maxOverflow = Math.max(productionCost, MathKt.roundToInt(this.getCity().getCityStats().getCurrentCityStats().getProduction()));
                        this.productionOverflow = Math.min(maxOverflow, potentialOverflow);
                    } else {
                        String[] stringArray = new String[]{construction2.getName()};
                        this.getCity().getCiv().addNotification("No space available to place [" + construction2.getName() + "] near [" + this.getCity().getName() + ']', this.getCity().getLocation(), Notification.NotificationCategory.Production, stringArray);
                    }
                    Counter<String> counter = this.getCity().getCiv().getCivConstructions().getBuiltItemsWithIncreasingCost();
                    String string = construction2.getName();
                    ((Map)counter).put(string, ((Number)counter.get((Object)string)).intValue() + 1);
                }
            }
        }
    }

    public final void endTurn(@NotNull Stats cityStats) {
        Intrinsics.checkNotNullParameter(cityStats, "cityStats");
        this.validateConstructionQueue();
        this.validateInProgressConstructions();
        if (!(this.getConstruction$core(this.getCurrentConstructionFromQueue()) instanceof PerpetualConstruction)) {
            if (this.getWorkDone(this.getCurrentConstructionFromQueue()) == 0) {
                this.constructionBegun(this.getConstruction$core(this.getCurrentConstructionFromQueue()));
            }
            this.addProductionPoints(MathKt.roundToInt(cityStats.getProduction()) + this.productionOverflow);
            this.productionOverflow = 0;
        }
    }

    /*
     * Iterators could be improved
     * Unable to fully structure code
     */
    private final void validateConstructionQueue() {
        queueSnapshot = CollectionsKt.toMutableList((Collection)this.constructionQueue);
        this.constructionQueue.clear();
        for (String constructionName : queueSnapshot) {
            block5: {
                block4: {
                    block6: {
                        construction = this.getConstruction$core(constructionName);
                        if (!this.constructionQueue.isEmpty() || this.getWorkDone(constructionName) != 0) break block5;
                        stockpileCosts = construction.getStockpiledResourceRequirements(this.getCity().getState());
                        civResources = this.getCity().getCiv().getCivResourcesByName();
                        $this$any$iv = stockpileCosts;
                        $i$f$any = false;
                        if (!$this$any$iv.isEmpty()) break block6;
                        v0 = false;
                        break block4;
                    }
                    var9_9 = $this$any$iv.entrySet().iterator();
                    while (var9_9.hasNext()) {
                        var11_11 = element$iv = var9_9.next();
                        $i$a$-any-CityConstructions$validateConstructionQueue$1 = false;
                        resourceName = (String)var11_11.getKey();
                        amount = ((Number)var11_11.getValue()).intValue();
                        if (civResources.get(resourceName) == null) ** GOTO lbl-1000
                        v1 = civResources.get(resourceName);
                        Intrinsics.checkNotNull(v1);
                        if (amount > ((Number)v1).intValue()) lbl-1000:
                        // 2 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        if (!v2) continue;
                        v0 = true;
                        break block4;
                    }
                    v0 = false;
                }
                if (v0) continue;
            }
            if (!construction.isBuildable(this)) continue;
            this.constructionQueue.add(constructionName);
        }
        this.chooseNextConstruction();
    }

    /*
     * WARNING - void declaration
     */
    public final void validateInProgressConstructions() {
        void $this$filterTo$iv$iv;
        Set<String> set2 = this.inProgressConstructions.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Iterable $this$filter$iv = set2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual(it, this.getCurrentConstructionFromQueue()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inProgressSnapshot = (List)destination$iv$iv;
        for (String constructionName : inProgressSnapshot) {
            boolean bl;
            Sequence<RejectionReason> rejectionReasons;
            IConstruction construction2;
            Object element$iv$iv;
            block15: {
                Intrinsics.checkNotNull(constructionName);
                construction2 = this.getConstruction$core(constructionName);
                if (construction2 instanceof PerpetualConstruction) continue;
                Intrinsics.checkNotNull(construction2, "null cannot be cast to non-null type com.unciv.models.ruleset.INonPerpetualConstruction");
                Sequence<RejectionReason> $this$any$iv = rejectionReasons = ((INonPerpetualConstruction)construction2).getRejectionReasons(this);
                boolean $i$f$any = false;
                element$iv$iv = $this$any$iv.iterator();
                while (element$iv$iv.hasNext()) {
                    Object element$iv = element$iv$iv.next();
                    RejectionReason it = (RejectionReason)element$iv;
                    boolean bl2 = false;
                    if (!it.hasAReasonToBeRemovedFromQueue()) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
            if (!bl) continue;
            int workDone = this.getWorkDone(constructionName);
            if (construction2 instanceof Building) {
                if (((Building)construction2).isWonder() && workDone != 0) {
                    this.getCity().getCiv().addGold(workDone);
                    String[] $i$f$any = new String[]{"StatIcons/Gold", "BuildingIcons/" + constructionName};
                    this.getCity().getCiv().addNotification("Excess production for [" + constructionName + "] converted to [" + workDone + "] gold", this.getCity().getLocation(), Notification.NotificationCategory.Production, $i$f$any);
                }
            } else if (construction2 instanceof BaseUnit) {
                boolean bl3;
                Object object;
                BaseUnit cheapestUpgradeUnit2;
                block16: {
                    Object v2;
                    void $this$minByOrNull$iv;
                    element$iv$iv = SequencesKt.filter(SequencesKt.map(((BaseUnit)construction2).getRulesetUpgradeUnits(this.getCity().getState()), (Function1)new Function1<BaseUnit, BaseUnit>(this){
                        final /* synthetic */ CityConstructions this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final BaseUnit invoke(@NotNull BaseUnit it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return this.this$0.getCity().getCiv().getEquivalentUnit(it);
                        }
                    }), (Function1)new Function1<BaseUnit, Boolean>(this){
                        final /* synthetic */ CityConstructions this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull BaseUnit it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return it.isBuildable(this.this$0);
                        }
                    });
                    boolean $i$f$minByOrNull = false;
                    Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v2 = null;
                    } else {
                        Object minElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v2 = minElem$iv;
                        } else {
                            BaseUnit it = (BaseUnit)minElem$iv;
                            boolean bl4 = false;
                            int minValue$iv = it.getCost();
                            do {
                                Object e$iv = iterator$iv.next();
                                BaseUnit it2 = (BaseUnit)e$iv;
                                $i$a$-minByOrNull-CityConstructions$validateInProgressConstructions$cheapestUpgradeUnit$3 = false;
                                int v$iv = it2.getCost();
                                if (minValue$iv <= v$iv) continue;
                                minElem$iv = e$iv;
                                minValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v2 = minElem$iv;
                        }
                    }
                    cheapestUpgradeUnit2 = v2;
                    Sequence<RejectionReason> $this$all$iv = rejectionReasons;
                    boolean $i$f$all = false;
                    object = $this$all$iv.iterator();
                    while (object.hasNext()) {
                        RejectionReason element$iv;
                        RejectionReason it = element$iv = object.next();
                        boolean bl5 = false;
                        if (it.getType() == RejectionReasonType.Obsoleted) continue;
                        bl3 = false;
                        break block16;
                    }
                    bl3 = true;
                }
                if (bl3 && cheapestUpgradeUnit2 != null) {
                    Map map2 = this.inProgressConstructions;
                    String string = cheapestUpgradeUnit2.getName();
                    Integer n = this.inProgressConstructions.get(cheapestUpgradeUnit2.getName());
                    if (n == null) {
                        n = 0;
                    }
                    object = n + workDone;
                    map2.put(string, object);
                }
            }
            this.inProgressConstructions.remove(constructionName);
        }
    }

    private final void constructionBegun(IConstruction construction2) {
        for (Map.Entry object : ((Map)construction2.getStockpiledResourceRequirements(this.getCity().getState())).entrySet()) {
            TileResource resource2;
            String resourceName = (String)object.getKey();
            int amount = ((Number)object.getValue()).intValue();
            if (this.getCity().getCiv().getGameInfo().getRuleset().getTileResources().get(resourceName) == null) continue;
            this.getCity().gainStockpiledResource(resource2, -amount);
        }
        if (!(construction2 instanceof INonPerpetualConstruction)) {
            return;
        }
        if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)((Object)construction2), UniqueType.TriggersAlertOnStart, null, 2, null)) {
            return;
        }
        String icon = construction2 instanceof Building ? "BuildingIcons/" + construction2.getName() : "UnitIcons/" + construction2.getName();
        for (Civilization otherCiv : this.getCity().getCiv().getGameInfo().getCivilizations()) {
            String[] stringArray;
            if (Intrinsics.areEqual(otherCiv, this.getCity().getCiv())) continue;
            if (otherCiv.hasExplored(this.getCity().getCenterTile())) {
                stringArray = new String[]{"StatIcons/Production", icon};
                otherCiv.addNotification("The city of [" + this.getCity().getName() + "] has started constructing [" + construction2.getName() + "]!", this.getCity().getLocation(), Notification.NotificationCategory.General, stringArray);
                continue;
            }
            if (otherCiv.knows(this.getCity().getCiv())) {
                stringArray = new String[]{"StatIcons/Production", icon};
                otherCiv.addNotification('[' + this.getCity().getCiv().getCivName() + "] has started constructing [" + construction2.getName() + "]!", Notification.NotificationCategory.General, stringArray);
                continue;
            }
            stringArray = new String[]{"StatIcons/Production", icon};
            otherCiv.addNotification("An unknown civilization has started constructing [" + construction2.getName() + "]!", Notification.NotificationCategory.General, stringArray);
        }
    }

    public final boolean completeConstruction(@NotNull INonPerpetualConstruction construction2) {
        NotificationAction notificationAction;
        String[] $this$filterTo$iv$iv;
        Object $this$filter$iv;
        Intrinsics.checkNotNullParameter(construction2, "construction");
        MapUnit unit = null;
        if (construction2 instanceof Building) {
            ((Building)construction2).construct(this);
        } else if (construction2 instanceof BaseUnit) {
            MapUnit mapUnit = ((BaseUnit)construction2).construct(this, null);
            if (mapUnit == null) {
                return false;
            }
            unit = mapUnit;
            HashSet<String> possiblePromotions = new HashSet<String>();
            Set prmotionTreeOrder = new LinkedHashSet();
            for (Promotion promotion2 : new PromotionTree(unit).getPossiblePromotions()) {
                possiblePromotions.add(promotion2.getName());
            }
            Iterator<Object> iterator2 = new PromotionTree(unit).allNodes().iterator();
            while (iterator2.hasNext()) {
                PromotionTree.PromotionNode roots = (PromotionTree.PromotionNode)iterator2.next();
                prmotionTreeOrder.add(roots.getPromotion().getName());
            }
            UnitPromotions savedPromotion = this.getCity().getUnitToPromotions().get(unit.getBaseUnit().getName());
            if (Intrinsics.areEqual(this.getCity().getUnitShouldUseSavedPromotion().get(unit.getBaseUnit().getName()), true) && savedPromotion != null && unit.getPromotions().getXP() >= savedPromotion.getXP()) {
                $this$filter$iv = savedPromotion.getPromotions();
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object t : $this$filterTo$iv$iv) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!possiblePromotions.contains(it)) continue;
                    destination$iv$iv.add(t);
                }
                List possiblePromotionFilted = (List)destination$iv$iv;
                for (String promotions : prmotionTreeOrder) {
                    if (unit.getPromotions().getXP() - unit.getPromotions().xpForNextPromotion() < 0) break;
                    if (!possiblePromotionFilted.contains(promotions)) continue;
                    UnitPromotions.addPromotion$default(unit.getPromotions(), promotions, false, 2, null);
                }
            }
        }
        if (((Map)this.inProgressConstructions).containsKey(construction2.getName())) {
            this.inProgressConstructions.remove(construction2.getName());
        }
        if (Intrinsics.areEqual(construction2.getName(), this.getCurrentConstructionFromQueue())) {
            this.removeCurrentConstruction();
        }
        this.validateConstructionQueue();
        IRulesetObject cfr_ignored_0 = (IRulesetObject)((Object)construction2);
        String buildingIcon = "BuildingIcons/" + construction2.getName();
        CivilopediaAction pediaAction = new CivilopediaAction(((IRulesetObject)((Object)construction2)).makeLink());
        if (construction2 instanceof BaseUnit) {
            MapUnit mapUnit = unit;
            Intrinsics.checkNotNull(mapUnit);
            notificationAction = new MapUnitAction(mapUnit);
        } else {
            notificationAction = new LocationAction(this.getCity().getLocation());
        }
        NotificationAction locationAction2 = notificationAction;
        $this$filter$iv = new NotificationAction[]{locationAction2, pediaAction};
        List<NotificationAction> locationAndPediaActions = CollectionsKt.listOf($this$filter$iv);
        if (construction2 instanceof Building && ((Building)construction2).isWonder()) {
            this.getCity().getCiv().getPopupAlerts().add(new PopupAlert(AlertType.WonderBuilt, construction2.getName()));
            for (Civilization civ : this.getCity().getCiv().getGameInfo().getCivilizations()) {
                if (civ.hasExplored(this.getCity().getCenterTile())) {
                    $this$filterTo$iv$iv = new String[]{buildingIcon};
                    civ.addNotification('[' + construction2.getName() + "] has been built in [" + this.getCity().getName() + ']', (Iterable<? extends NotificationAction>)locationAndPediaActions, Intrinsics.areEqual(civ, this.getCity().getCiv()) ? Notification.NotificationCategory.Production : Notification.NotificationCategory.General, $this$filterTo$iv$iv);
                    continue;
                }
                $this$filterTo$iv$iv = new String[]{buildingIcon};
                civ.addNotification('[' + construction2.getName() + "] has been built in a faraway land", pediaAction, Notification.NotificationCategory.General, $this$filterTo$iv$iv);
            }
        } else {
            String icon = construction2 instanceof Building ? buildingIcon : construction2.getName();
            String[] civ = new String[]{"StatIcons/Production", icon};
            this.getCity().getCiv().addNotification('[' + construction2.getName() + "] has been built in [" + this.getCity().getName() + ']', (Iterable<? extends NotificationAction>)locationAndPediaActions, Notification.NotificationCategory.Production, civ);
        }
        if (construction2.hasUnique(UniqueType.TriggersAlertOnCompletion, this.getCity().getState())) {
            for (Civilization otherCiv : this.getCity().getCiv().getGameInfo().getCivilizations()) {
                if (Intrinsics.areEqual(otherCiv, this.getCity().getCiv())) continue;
                String completingCivDescription = otherCiv.knows(this.getCity().getCiv()) ? '[' + this.getCity().getCiv().getCivName() + ']' : "An unknown civilization";
                String[] stringArray = new String[]{"StatIcons/Production", buildingIcon};
                otherCiv.addNotification(completingCivDescription + " has completed [" + construction2.getName() + "]!", pediaAction, Notification.NotificationCategory.General, stringArray);
            }
        }
        return true;
    }

    public final void addBuilding(@NotNull String buildingName) {
        Intrinsics.checkNotNullParameter(buildingName, "buildingName");
        Building building = this.getCity().getRuleset().getBuildings().get(buildingName);
        Intrinsics.checkNotNull(building);
        Building building2 = building;
        CityConstructions.addBuilding$default(this, building2, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void addBuilding(@NotNull Building building, boolean tryAddFreeBuildings) {
        Intrinsics.checkNotNullParameter(building, "building");
        String buildingName = building.getName();
        Civilization civ = this.getCity().getCiv();
        if (building.getCityHealth() > 0) {
            City city2 = this.getCity();
            city2.setHealth(city2.getHealth() + (int)((float)building.getCityHealth() * (float)this.getCity().getHealth() / (float)this.getCity().getMaxHealth$core()));
        }
        this.builtBuildingObjects = CollectionExtensionsKt.withItem(this.builtBuildingObjects, building);
        this.builtBuildings.add(buildingName);
        CityConstructions.updateUniques$default(this, false, 1, null);
        CityConstructions.applyCreateOneImprovement$default(this, building, false, 2, null);
        this.triggerNewBuildingUniques(building);
        if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)building, UniqueType.EnemyUnitsSpendExtraMovement, null, 2, null)) {
            civ.getCache().updateHasActiveEnemyMovementPenalty();
        }
        if (building.isStatRelated(Stat.Science, this.getCity()) && Civilization.hasUnique$default(civ, UniqueType.TechBoostWhenScientificBuildingsBuiltInCapital, null, 2, null) && this.getCity().isCapital()) {
            civ.getTech().addScience(ArraysKt.sum(civ.getTech().getScienceOfLast8Turns()) / 8);
        }
        int previousHappiness = civ.getHappiness();
        this.getCity().reassignPopulationDeferred();
        int newHappiness = civ.getHappiness();
        if (previousHappiness != newHappiness) {
            boolean bl;
            block11: {
                void $this$any$iv;
                Iterable iterable = this.getCity().getCiv().getGameInfo().getRuleset().getAllHappinessLevelsThatAffectUniques();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        int it = ((Number)element$iv).intValue();
                        boolean bl2 = false;
                        if (!(newHappiness < it != previousHappiness < it)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.getCity().getCiv().getCities();
                boolean $i$f$filter = false;
                Iterator iterator2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    City it = (City)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual(it, this.getCity()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    City it = (City)element$iv;
                    boolean bl4 = false;
                    it.reassignPopulationDeferred();
                }
            }
        }
        if (tryAddFreeBuildings) {
            this.getCity().getCiv().getCivConstructions().tryAddFreeBuildings();
        }
    }

    public static /* synthetic */ void addBuilding$default(CityConstructions cityConstructions, Building building, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        cityConstructions.addBuilding(building, bl);
    }

    public final void triggerNewBuildingUniques(@NotNull Building building) {
        Intrinsics.checkNotNullParameter(building, "building");
        StateForConditionals stateForConditionals = this.getCity().getState();
        String triggerNotificationText = "due to constructing [" + building.getName() + ']';
        for (Unique unique : building.getUniqueObjects()) {
            if (unique.hasTriggerConditional() || !unique.conditionalsApply(stateForConditionals)) continue;
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCity(), null, triggerNotificationText, 4, null);
        }
        for (Unique unique : this.getCity().getCiv().getTriggeredUniques(UniqueType.TriggerUponConstructingBuilding, stateForConditionals, (Function1<? super Unique, Boolean>)new Function1<Unique, Boolean>(building, stateForConditionals){
            final /* synthetic */ Building $building;
            final /* synthetic */ StateForConditionals $stateForConditionals;
            {
                this.$building = $building;
                this.$stateForConditionals = $stateForConditionals;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Unique it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$building.matchesFilter(it.getParams().get(0), this.$stateForConditionals);
            }
        })) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCity(), null, triggerNotificationText, 4, null);
        }
        for (Unique unique : this.getCity().getCiv().getTriggeredUniques(UniqueType.TriggerUponConstructingBuildingCityFilter, stateForConditionals, (Function1<? super Unique, Boolean>)new Function1<Unique, Boolean>(building, stateForConditionals, this){
            final /* synthetic */ Building $building;
            final /* synthetic */ StateForConditionals $stateForConditionals;
            final /* synthetic */ CityConstructions this$0;
            {
                this.$building = $building;
                this.$stateForConditionals = $stateForConditionals;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Unique it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$building.matchesFilter(it.getParams().get(0), this.$stateForConditionals) && City.matchesFilter$default(this.this$0.getCity(), it.getParams().get(1), null, false, 6, null);
            }
        })) {
            UniqueTriggerActivation.triggerUnique$default(UniqueTriggerActivation.INSTANCE, unique, this.getCity(), null, triggerNotificationText, 4, null);
        }
    }

    public final void removeBuilding(@NotNull String buildingName) {
        Intrinsics.checkNotNullParameter(buildingName, "buildingName");
        Building buildingObject = this.getCity().getRuleset().getBuildings().get(buildingName);
        if (buildingObject != null) {
            this.builtBuildingObjects = CollectionExtensionsKt.withoutItem(this.builtBuildingObjects, buildingObject);
        } else {
            CollectionsKt.removeAll((List)this.builtBuildingObjects, (Function1)new Function1<Building, Boolean>(buildingName){
                final /* synthetic */ String $buildingName;
                {
                    this.$buildingName = $buildingName;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Building it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it.getName(), this.$buildingName);
                }
            });
        }
        this.builtBuildings.remove(buildingName);
        CityConstructions.updateUniques$default(this, false, 1, null);
    }

    public final void removeBuilding(@NotNull Building building) {
        Intrinsics.checkNotNullParameter(building, "building");
        this.builtBuildingObjects = CollectionExtensionsKt.withoutItem(this.builtBuildingObjects, building);
        this.builtBuildings.remove(building.getName());
        CityConstructions.updateUniques$default(this, false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeBuildings(@NotNull Set<Building> buildings2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(buildings2, "buildings");
        Iterable $this$map$iv = buildings2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Building building = (Building)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Set<String> buildingsToRemove2 = CollectionsKt.toSet((List)destination$iv$iv);
        CollectionsKt.removeAll((Iterable)this.builtBuildings, (Function1)new Function1<String, Boolean>(buildingsToRemove2){
            final /* synthetic */ Set<String> $buildingsToRemove;
            {
                this.$buildingsToRemove = $buildingsToRemove;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$buildingsToRemove.contains(it);
            }
        });
        this.setTransients();
    }

    public final void updateUniques(boolean onLoadGame2) {
        this.builtBuildingUniqueMap.clear();
        Iterator<Building> iterator2 = this.getBuiltBuildings().iterator();
        while (iterator2.hasNext()) {
            Building building = iterator2.next();
            this.builtBuildingUniqueMap.addUniques((Iterable<Unique>)building.getUniqueObjects());
        }
        if (!onLoadGame2) {
            this.getCity().getCiv().getCache().updateCitiesConnectedToCapital(false);
            CityStats.update$default(this.getCity().getCityStats(), null, false, false, null, 15, null);
            this.getCity().getCiv().getCache().updateCivResources();
        }
    }

    public static /* synthetic */ void updateUniques$default(CityConstructions cityConstructions, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        cityConstructions.updateUniques(bl);
    }

    public final boolean purchaseConstruction(@NotNull String constructionName, int queuePosition, boolean automatic, @NotNull Stat stat, @Nullable Tile tile) {
        Intrinsics.checkNotNullParameter(constructionName, "constructionName");
        Intrinsics.checkNotNullParameter(stat, "stat");
        IConstruction iConstruction = this.getConstruction$core(constructionName);
        INonPerpetualConstruction iNonPerpetualConstruction = iConstruction instanceof INonPerpetualConstruction ? (INonPerpetualConstruction)iConstruction : null;
        if (iNonPerpetualConstruction == null) {
            return false;
        }
        INonPerpetualConstruction construction2 = iNonPerpetualConstruction;
        return this.purchaseConstruction(construction2, queuePosition, automatic, stat, tile);
    }

    public static /* synthetic */ boolean purchaseConstruction$default(CityConstructions cityConstructions, String string, int n, boolean bl, Stat stat, Tile tile, int n2, Object object) {
        if ((n2 & 8) != 0) {
            stat = Stat.Gold;
        }
        if ((n2 & 0x10) != 0) {
            tile = null;
        }
        return cityConstructions.purchaseConstruction(string, n, bl, stat, tile);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean purchaseConstruction(@NotNull INonPerpetualConstruction construction2, int queuePosition, boolean automatic, @NotNull Stat stat, @Nullable Tile tile) {
        TileImprovement improvementToPlace;
        Intrinsics.checkNotNullParameter(construction2, "construction");
        Intrinsics.checkNotNullParameter(stat, "stat");
        Building building = construction2 instanceof Building ? (Building)construction2 : null;
        TileImprovement tileImprovement = improvementToPlace = building != null ? building.getImprovementToCreate(this.getCity().getRuleset(), this.getCity().getCiv()) : null;
        if (improvementToPlace != null) {
            Tile tile2 = tile;
            if (tile2 == null && (tile2 = Automation.INSTANCE.getTileForConstructionImprovement(this.getCity(), improvementToPlace)) == null) {
                return false;
            }
            Tile finalTile = tile2;
            finalTile.getImprovementFunctions().markForCreatesOneImprovement(improvementToPlace.getName());
        }
        if (construction2 instanceof Building) {
            ((Building)construction2).construct(this);
        } else if (construction2 instanceof BaseUnit && ((BaseUnit)construction2).construct(this, stat) == null) {
            return false;
        }
        if (!this.getCity().getCiv().getGameInfo().getGameParameters().getGodMode()) {
            boolean bl;
            StateForConditionals conditionalState;
            block12: {
                void $this$any$iv;
                Integer n = construction2.getStatBuyCost(this.getCity(), stat);
                if (n == null) {
                    return false;
                }
                int constructionCost = n;
                this.getCity().addStat(stat, -1 * constructionCost);
                conditionalState = this.getCity().getState();
                Sequence<Unique> sequence = SequencesKt.plus(this.getCity().getCiv().getMatchingUniques(UniqueType.BuyUnitsIncreasingCost, conditionalState), this.getCity().getCiv().getMatchingUniques(UniqueType.BuyBuildingsIncreasingCost, conditionalState));
                boolean bl2 = false;
                for (Object element$iv : $this$any$iv) {
                    Unique it = (Unique)element$iv;
                    boolean bl22 = false;
                    boolean bl3 = (construction2 instanceof BaseUnit && BaseUnit.matchesFilter$default((BaseUnit)construction2, it.getParams().get(0), conditionalState, false, 4, null) || construction2 instanceof Building && ((Building)construction2).matchesFilter(it.getParams().get(0), conditionalState)) && City.matchesFilter$default(this.getCity(), it.getParams().get(3), null, false, 6, null) && Intrinsics.areEqual(it.getParams().get(2), stat.name());
                    if (!bl3) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
            if (bl) {
                this.getCity().getCiv().getCivConstructions().getBoughtItemsWithIncreasingPrice().add(construction2.getName(), 1);
            }
            if (this.getWorkDone(construction2.getName()) == 0) {
                for (Map.Entry entry : ((Map)construction2.getStockpiledResourceRequirements(conditionalState)).entrySet()) {
                    TileResource resource2;
                    String resourceName = (String)entry.getKey();
                    int amount = ((Number)entry.getValue()).intValue();
                    if (this.getCity().getCiv().getGameInfo().getRuleset().getTileResources().get(resourceName) == null) continue;
                    this.getCity().gainStockpiledResource(resource2, -amount);
                }
            }
        }
        boolean bl = 0 <= queuePosition ? queuePosition < this.constructionQueue.size() : false;
        if (bl) {
            this.removeFromQueue(queuePosition, automatic);
        }
        this.validateConstructionQueue();
        return true;
    }

    public static /* synthetic */ boolean purchaseConstruction$default(CityConstructions cityConstructions, INonPerpetualConstruction iNonPerpetualConstruction, int n, boolean bl, Stat stat, Tile tile, int n2, Object object) {
        if ((n2 & 8) != 0) {
            stat = Stat.Gold;
        }
        if ((n2 & 0x10) != 0) {
            tile = null;
        }
        return cityConstructions.purchaseConstruction(iNonPerpetualConstruction, n, bl, stat, tile);
    }

    public final boolean isConstructionPurchaseAllowed(@NotNull INonPerpetualConstruction construction2, @NotNull Stat stat, int constructionBuyCost) {
        Intrinsics.checkNotNullParameter(construction2, "construction");
        Intrinsics.checkNotNullParameter(stat, "stat");
        return this.getCity().isPuppet() && !SequencesKt.any(City.getMatchingUniques$default(this.getCity(), UniqueType.MayBuyConstructionsInPuppets, null, false, 6, null)) ? false : (this.getCity().isInResistance() ? false : (!construction2.isPurchasable(this.getCity().getCityConstructions()) ? false : (construction2 instanceof BaseUnit && !this.getCity().canPlaceNewUnit((BaseUnit)construction2) ? false : (!construction2.canBePurchasedWithStat(this.getCity(), stat) ? false : (this.getCity().getCiv().getGameInfo().getGameParameters().getGodMode() ? true : (constructionBuyCost == 0 ? true : this.getCity().getStatReserve(stat) >= constructionBuyCost))))));
    }

    public final boolean isConstructionPurchaseBlockedByUnit(@NotNull INonPerpetualConstruction construction2) {
        Intrinsics.checkNotNullParameter(construction2, "construction");
        return !this.getCity().isPuppet() && !SequencesKt.any(City.getMatchingUniques$default(this.getCity(), UniqueType.MayBuyConstructionsInPuppets, null, false, 6, null)) && !this.getCity().isInResistance() && construction2.isPurchasable(this.getCity().getCityConstructions()) && construction2 instanceof BaseUnit && !this.getCity().canPlaceNewUnit((BaseUnit)construction2);
    }

    private final void removeCurrentConstruction() {
        this.removeFromQueue(0, true);
    }

    public final void chooseNextConstruction() {
        IConstruction iConstruction;
        block10: {
            block9: {
                block8: {
                    boolean isCurrentPlayersTurn;
                    if (!(this.isQueueEmptyOrIdle() || this.getConstruction$core(this.getCurrentConstructionFromQueue()) instanceof PerpetualConstruction && !this.currentConstructionIsUserSet)) {
                        return;
                    }
                    boolean bl = isCurrentPlayersTurn = MultiplayerKt.isUsersTurn(this.getCity().getCiv().getGameInfo()) || !this.getCity().getCiv().getGameInfo().getGameParameters().isOnlineMultiplayer();
                    if (!isCurrentPlayersTurn) break block8;
                    if (UncivGame.Companion.getCurrent().getSettings().getAutoAssignCityProduction()) break block9;
                    Object object = UncivGame.Companion.getCurrent().getWorldScreen();
                    if (object != null && (object = ((WorldScreen)object).getAutoPlay()) != null ? ((AutoPlay)object).isAutoPlayingAndFullAutoPlayAI() : false) break block9;
                }
                if (!this.getCity().getCiv().isAI() && !this.getCity().isPuppet()) break block10;
            }
            new ConstructionAutomation(this).chooseNextConstruction();
        }
        Building building = (iConstruction = this.getCurrentConstruction()) instanceof Building ? (Building)iConstruction : null;
        if (building == null) {
            return;
        }
        Building building2 = building;
        TileImprovement tileImprovement = building2.getImprovementToCreate(this.getCity().getRuleset(), this.getCity().getCiv());
        if (tileImprovement == null) {
            return;
        }
        TileImprovement improvement2 = tileImprovement;
        if (this.getTileForImprovement(improvement2.getName()) != null) {
            return;
        }
        Tile tile = Automation.INSTANCE.getTileForConstructionImprovement(this.getCity(), improvement2);
        if (tile == null) {
            return;
        }
        Tile newTile = tile;
        newTile.getImprovementFunctions().markForCreatesOneImprovement(improvement2.getName());
    }

    public final boolean canAddToQueue(@NotNull IConstruction construction2) {
        Intrinsics.checkNotNullParameter(construction2, "construction");
        return !this.isQueueFull() && construction2.isBuildable(this) && (!(construction2 instanceof Building) || !this.isBeingConstructedOrEnqueued(construction2.getName()));
    }

    private final boolean isLastConstructionPerpetual() {
        return !((Collection)this.constructionQueue).isEmpty() && PerpetualConstruction.Companion.isNamePerpetual(CollectionsKt.last(this.constructionQueue));
    }

    public final boolean isQueueEmptyOrIdle() {
        return ((CharSequence)this.getCurrentConstructionFromQueue()).length() == 0 || Intrinsics.areEqual(this.getCurrentConstructionFromQueue(), PerpetualConstruction.Companion.getIdle().getName());
    }

    public final void addToQueue(@NotNull IConstruction construction2, boolean addToTop) {
        Intrinsics.checkNotNullParameter(construction2, "construction");
        if (!this.canAddToQueue(construction2)) {
            return;
        }
        String constructionName = construction2.getName();
        if (this.isQueueEmptyOrIdle()) {
            this.setCurrentConstructionFromQueue(constructionName);
        } else if (addToTop && construction2 instanceof PerpetualConstruction && PerpetualConstruction.Companion.isNamePerpetual(this.getCurrentConstructionFromQueue())) {
            this.setCurrentConstructionFromQueue(constructionName);
        } else if (addToTop) {
            this.constructionQueue.add(0, constructionName);
        } else if (this.isLastConstructionPerpetual()) {
            if (construction2 instanceof PerpetualConstruction) {
                CollectionsKt.removeLast(this.constructionQueue);
                this.constructionQueue.add(constructionName);
            } else {
                this.constructionQueue.add(this.constructionQueue.size() - 1, constructionName);
            }
        } else {
            this.constructionQueue.add(constructionName);
        }
        this.currentConstructionIsUserSet = true;
    }

    public static /* synthetic */ void addToQueue$default(CityConstructions cityConstructions, IConstruction iConstruction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        cityConstructions.addToQueue(iConstruction, bl);
    }

    public final void addToQueue(@NotNull String constructionName) {
        Intrinsics.checkNotNullParameter(constructionName, "constructionName");
        CityConstructions.addToQueue$default(this, this.getConstruction$core(constructionName), false, 2, null);
    }

    public final void removeFromQueue(int constructionQueueIndex, boolean automatic) {
        boolean bl;
        TileImprovement improvement2;
        String constructionName = this.constructionQueue.remove(constructionQueueIndex);
        IConstruction construction2 = this.getConstruction$core(constructionName);
        if (construction2 instanceof Building && (improvement2 = ((Building)construction2).getImprovementToCreate(this.getCity().getRuleset(), this.getCity().getCiv())) != null) {
            Tile tile = this.getTileForImprovement(improvement2.getName());
            if (tile != null) {
                tile.stopWorkingOnImprovement();
            }
        }
        if (this.constructionQueue.isEmpty()) {
            if (automatic) {
                this.chooseNextConstruction();
            } else {
                this.constructionQueue.add(PerpetualConstruction.Companion.getIdle().getName());
            }
            bl = false;
        } else {
            bl = true;
        }
        this.currentConstructionIsUserSet = bl;
    }

    public final void removeAllByName(@NotNull String constructionName) {
        Intrinsics.checkNotNullParameter(constructionName, "constructionName");
        while (!this.isQueueEmptyOrIdle()) {
            int index = this.constructionQueue.indexOf(constructionName);
            if (index < 0) {
                return;
            }
            this.removeFromQueue(index, false);
        }
    }

    public final void moveEntryToTop(int constructionQueueIndex) {
        if (constructionQueueIndex == 0 || constructionQueueIndex >= this.constructionQueue.size()) {
            return;
        }
        String constructionName = this.constructionQueue.remove(constructionQueueIndex);
        this.constructionQueue.add(0, constructionName);
    }

    public final void moveEntryToEnd(int constructionQueueIndex) {
        if (constructionQueueIndex >= this.constructionQueue.size()) {
            return;
        }
        String constructionName = this.constructionQueue.remove(constructionQueueIndex);
        if (this.isLastConstructionPerpetual()) {
            this.addToQueue(constructionName);
            return;
        }
        this.constructionQueue.add(constructionName);
    }

    public final int raisePriority(int constructionQueueIndex) {
        if (constructionQueueIndex == 0) {
            return constructionQueueIndex;
        }
        this.swap(this.constructionQueue, constructionQueueIndex - 1, constructionQueueIndex);
        return constructionQueueIndex - 1;
    }

    public final int lowerPriority(int constructionQueueIndex) {
        if (constructionQueueIndex >= this.constructionQueue.size() - 1) {
            return constructionQueueIndex;
        }
        this.raisePriority(constructionQueueIndex + 1);
        return constructionQueueIndex + 1;
    }

    private final void swap(List<String> $this$swap, int idx1, int idx2) {
        String tmp = $this$swap.get(idx1);
        $this$swap.set(idx1, $this$swap.get(idx2));
        $this$swap.set(idx2, tmp);
    }

    private final void applyCreateOneImprovement(Building building, boolean removeOnly) {
        TileImprovement tileImprovement = building.getImprovementToCreate(this.getCity().getRuleset(), this.getCity().getCiv());
        if (tileImprovement == null) {
            return;
        }
        TileImprovement improvement2 = tileImprovement;
        Tile tile = this.getTileForImprovement(improvement2.getName());
        if (tile == null) {
            return;
        }
        Tile tileForImprovement = tile;
        tileForImprovement.stopWorkingOnImprovement();
        if (removeOnly) {
            return;
        }
        Tile.setImprovement$default(tileForImprovement, improvement2.getName(), this.getCity().getCiv(), null, 4, null);
        GUI.INSTANCE.setUpdateWorldOnNextRender();
    }

    static /* synthetic */ void applyCreateOneImprovement$default(CityConstructions cityConstructions, Building building, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        cityConstructions.applyCreateOneImprovement(building, bl);
    }

    public final void removeCreateOneImprovementConstruction(@NotNull String improvement2) {
        boolean bl;
        Integer n;
        block4: {
            Intrinsics.checkNotNullParameter(improvement2, "improvement");
            Ruleset ruleset2 = this.getCity().getRuleset();
            for (IndexedValue it : CollectionsKt.withIndex((Iterable)this.constructionQueue)) {
                boolean bl2 = false;
                IConstruction construction2 = this.getConstruction$core((String)it.getValue());
                RulesetStatsObject rulesetStatsObject = construction2 instanceof Building ? (Building)construction2 : null;
                String buildingImprovement = rulesetStatsObject != null && (rulesetStatsObject = ((Building)rulesetStatsObject).getImprovementToCreate(ruleset2, this.getCity().getCiv())) != null ? rulesetStatsObject.getName() : null;
                Integer n2 = it.getIndex();
                int it2 = ((Number)n2).intValue();
                boolean bl3 = false;
                Integer n3 = Intrinsics.areEqual(buildingImprovement, improvement2) ? n2 : null;
                if (n3 == null) continue;
                n = n3;
                break block4;
            }
            n = null;
        }
        if (n == null) {
            return;
        }
        int indexToRemove = n;
        this.constructionQueue.remove(indexToRemove);
        if (this.constructionQueue.isEmpty()) {
            this.constructionQueue.add(PerpetualConstruction.Companion.getIdle().getName());
            bl = false;
        } else {
            bl = true;
        }
        this.currentConstructionIsUserSet = bl;
    }

    @Nullable
    public final Tile getTileForImprovement(@NotNull String improvementName) {
        Tile tile;
        block1: {
            Intrinsics.checkNotNullParameter(improvementName, "improvementName");
            Sequence<Tile> $this$firstOrNull$iv = this.getCity().getTiles();
            boolean $i$f$firstOrNull = false;
            Iterator<Tile> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile it = element$iv = iterator2.next();
                boolean bl = false;
                if (!it.isMarkedForCreatesOneImprovement(improvementName)) continue;
                tile = element$iv;
                break block1;
            }
            tile = null;
        }
        return tile;
    }
}

