/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.city.managers;

import com.unciv.logic.city.City;
import com.unciv.logic.city.CityFlags;
import com.unciv.logic.city.CityFocus;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.city.managers.SpyFleeReason;
import com.unciv.logic.civilization.CityAction;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.OverviewAction;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stats;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewCategories;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\bJ\b\u0010\n\u001a\u00020\bH\u0002J\u0006\u0010\u000b\u001a\u00020\bJ\b\u0010\f\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/unciv/logic/city/managers/CityTurnManager;", "", "city", "Lcom/unciv/logic/city/City;", "(Lcom/unciv/logic/city/City;)V", "getCity", "()Lcom/unciv/logic/city/City;", "demandNewResource", "", "endTurn", "nextTurnFlags", "startTurn", "tryWeLoveTheKing", "core"})
@SourceDebugExtension(value={"SMAP\nCityTurnManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CityTurnManager.kt\ncom/unciv/logic/city/managers/CityTurnManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n766#2:156\n857#2:157\n858#2:160\n766#2:161\n857#2,2:162\n2159#3,2:158\n1#4:164\n*S KotlinDebug\n*F\n+ 1 CityTurnManager.kt\ncom/unciv/logic/city/managers/CityTurnManager\n*L\n92#1:156\n92#1:157\n92#1:160\n99#1:161\n99#1:162,2\n97#1:158,2\n*E\n"})
public final class CityTurnManager {
    @NotNull
    private final City city;

    public CityTurnManager(@NotNull City city2) {
        Intrinsics.checkNotNullParameter(city2, "city");
        this.city = city2;
    }

    @NotNull
    public final City getCity() {
        return this.city;
    }

    public final void startTurn() {
        this.city.getCityConstructions().constructIfEnough();
        this.city.tryUpdateRoadStatus$core();
        this.city.setAttackedThisTurn(false);
        if (!this.city.hasFlag(CityFlags.WeLoveTheKing)) {
            this.tryWeLoveTheKing();
        }
        this.nextTurnFlags();
        if (this.city.isPuppet()) {
            this.city.setCityFocus(CityFocus.GoldFocus);
            this.city.reassignAllPopulation();
        } else if (this.city.getShouldReassignPopulation()) {
            City.reassignPopulation$default(this.city, false, 1, null);
        } else {
            CityStats.update$default(this.city.getCityStats(), null, false, false, null, 15, null);
        }
        if (Intrinsics.areEqual(this.city.getDemandedResource(), "") && !this.city.hasFlag(CityFlags.ResourceDemand)) {
            this.city.setFlag(CityFlags.ResourceDemand, (this.city.isCapital() ? 25 : 15) + Random.Default.nextInt(10));
        }
    }

    private final void tryWeLoveTheKing() {
        if (Intrinsics.areEqual(this.city.getDemandedResource(), "")) {
            return;
        }
        if (this.city.getAvailableResourceAmount(this.city.getDemandedResource()) > 0) {
            this.city.setFlag(CityFlags.WeLoveTheKing, 21);
            String[] stringArray = new String[]{"ImprovementIcons/City center", "StatIcons/Happiness"};
            this.city.getCiv().addNotification("Because they have [" + this.city.getDemandedResource() + "], the citizens of [" + this.city.getName() + "] are celebrating We Love The King Day!", (Iterable<? extends NotificationAction>)CityAction.Companion.withLocation(this.city), Notification.NotificationCategory.General, stringArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void nextTurnFlags() {
        Set<String> set2 = this.city.getFlagsCountdown$core().keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Iterator<String> iterator2 = CollectionsKt.toList((Iterable)set2).iterator();
        while (true) {
            block10: {
                String[] stringArray;
                block9: {
                    if (!iterator2.hasNext()) {
                        return;
                    }
                    String flag = iterator2.next();
                    Integer n = this.city.getFlagsCountdown$core().get(flag);
                    Intrinsics.checkNotNull(n);
                    if (((Number)n).intValue() > 0) {
                        Map map2 = this.city.getFlagsCountdown$core();
                        Intrinsics.checkNotNull(flag);
                        Integer n2 = this.city.getFlagsCountdown$core().get(flag);
                        Intrinsics.checkNotNull(n2);
                        map2.put(flag, ((Number)n2).intValue() - 1);
                    }
                    Integer n3 = this.city.getFlagsCountdown$core().get(flag);
                    if (n3 == null || n3 != 0) continue;
                    this.city.getFlagsCountdown$core().remove(flag);
                    String string = flag;
                    switch (string.hashCode()) {
                        case -437701543: {
                            if (string.equals("Resistance")) break block9;
                            break block10;
                        }
                        case -1653417976: {
                            if (string.equals("WeLoveTheKing")) break;
                            break block10;
                        }
                        case -1485659111: {
                            if (string.equals("ResourceDemand")) {
                                this.demandNewResource();
                            }
                            break block10;
                        }
                    }
                    stringArray = new String[]{"ImprovementIcons/City center"};
                    this.city.getCiv().addNotification("We Love The King Day in [" + this.city.getName() + "] has ended.", (Iterable<? extends NotificationAction>)CityAction.Companion.withLocation(this.city), Notification.NotificationCategory.General, stringArray);
                    this.demandNewResource();
                    continue;
                }
                this.city.setShouldReassignPopulation(true);
                stringArray = new String[]{"StatIcons/Resistance"};
                this.city.getCiv().addNotification("The resistance in [" + this.city.getName() + "] has ended!", (Iterable<? extends NotificationAction>)CityAction.Companion.withLocation(this.city), Notification.NotificationCategory.General, stringArray);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void demandNewResource() {
        v0 = this.city.getRuleset().getTileResources().values();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block10: {
                it = (TileResource)element$iv$iv;
                $i$a$-filter-CityTurnManager$demandNewResource$candidates$1 = false;
                if (it.getResourceType() != ResourceType.Luxury) ** GOTO lbl-1000
                Intrinsics.checkNotNull(it);
                if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.CityStateOnlyResource, null, 2, null) || Intrinsics.areEqual(it.getName(), this.city.getDemandedResource()) || !this.city.getTileMap().getResources().contains(it.getName())) ** GOTO lbl-1000
                $this$none$iv = this.city.getCenterTile().getTilesInDistance(this.city.getWorkRange());
                $i$f$none = false;
                var13_19 = $this$none$iv.iterator();
                while (var13_19.hasNext()) {
                    nearTile = element$iv = var13_19.next();
                    $i$a$-none-CityTurnManager$demandNewResource$candidates$1$1 = false;
                    if (!Intrinsics.areEqual(nearTile.getResource(), it.getName())) continue;
                    v1 = false;
                    break block10;
                }
                v1 = true;
            }
            if (v1) {
                v2 = true;
            } else lbl-1000:
            // 3 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        candidates = (List)destination$iv$iv;
        $this$filter$iv = candidates;
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (TileResource)element$iv$iv;
            $i$a$-filter-CityTurnManager$demandNewResource$missingResources$1 = false;
            if (!(this.city.getCiv().hasResource(it.getName()) == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        missingResources = (List)destination$iv$iv;
        if (missingResources.isEmpty()) {
            v3 = (TileResource)CollectionsKt.randomOrNull(candidates, Random.Default);
            if (v3 == null || (v3 = v3.getName()) == null) {
                v3 = "";
            }
            this.city.setDemandedResource((String)v3);
            return;
        }
        chosenResource = (TileResource)CollectionsKt.randomOrNull(missingResources, Random.Default);
        v4 = chosenResource;
        if (v4 == null || (v4 = v4.getName()) == null) {
            v4 = "";
        }
        this.city.setDemandedResource((String)v4);
        if (Intrinsics.areEqual(this.city.getDemandedResource(), "")) {
            this.city.setFlag(CityFlags.ResourceDemand, 15 + Random.Default.nextInt(10));
        } else {
            var4_6 = new NotificationAction[]{new LocationAction(this.city.getLocation()), new OverviewAction(EmpireOverviewCategories.Resources, null, 2, null)};
            v5 = CollectionsKt.listOf(var4_6);
            var4_6 = new String[]{"ImprovementIcons/City center", "ResourceIcons/" + this.city.getDemandedResource()};
            this.city.getCiv().addNotification('[' + this.city.getName() + "] demands [" + this.city.getDemandedResource() + "]!", v5, Notification.NotificationCategory.General, (String[])var4_6);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void endTurn() {
        Stats stats2 = this.city.getCityStats().getCurrentCityStats();
        this.city.getCityConstructions().endTurn(stats2);
        this.city.getExpansion().nextTurn(stats2.getCulture());
        if (this.city.isBeingRazed()) {
            int n;
            String[] stringArray = Civilization.getMatchingUniques$default(this.city.getCiv(), UniqueType.CitiesAreRazedXTimesFaster, null, 2, null);
            int n2 = 1;
            int n3 = 0;
            for (Object t : stringArray) {
                void it;
                Unique unique = (Unique)t;
                n = n3;
                boolean bl = false;
                int n4 = Integer.parseInt(it.getParams().get(0)) - 1;
                n3 = n + n4;
            }
            n = n3;
            int removedPopulation = n2 + n;
            if (this.city.getPopulation().getPopulation() <= removedPopulation) {
                this.city.getEspionage().removeAllPresentSpies(SpyFleeReason.Other);
                stringArray = new String[]{"OtherIcons/Fire"};
                this.city.getCiv().addNotification('[' + this.city.getName() + "] has been razed to the ground!", this.city.getLocation(), Notification.NotificationCategory.General, stringArray);
                City.destroyCity$default(this.city, false, 1, null);
            } else {
                this.city.getPopulation().addPopulation(-removedPopulation);
                if (this.city.getPopulation().getFoodStored() >= this.city.getPopulation().getFoodToNextPopulation()) {
                    this.city.getPopulation().setFoodStored(this.city.getPopulation().getFoodToNextPopulation() - 1);
                }
            }
        } else {
            this.city.getPopulation().nextTurn(this.city.foodForNextTurn());
        }
        if (this.city.getCiv().getGameInfo().isReligionEnabled()) {
            this.city.getReligion().endTurn();
        }
        if (this.city.getCiv().getCities().contains(this.city)) {
            this.city.setHealth(Math.min(this.city.getHealth() + 20, this.city.getMaxHealth$core()));
            this.city.getPopulation().unassignExtraPopulation();
        }
    }
}

