/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.DiplomacyAction;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.Proximity;
import com.unciv.logic.civilization.diplomacy.CityStatePersonality;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.managers.AssignedQuest;
import com.unciv.logic.civilization.managers.QuestManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Quest;
import com.unciv.models.ruleset.QuestName;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.utils.CollectionExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b*\u0018\u0000 p2\u00020\u0001:\u0002pqB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J\u0016\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bJ\u0016\u0010%\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bJ\u0006\u0010'\u001a\u00020\u0000J\b\u0010(\u001a\u00020\u0016H\u0002J\u0006\u0010)\u001a\u00020\u0016J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\bH\u0002J\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050,2\u0006\u0010-\u001a\u00020\rJ\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050,2\u0006\u0010/\u001a\u000200H\u0002J\n\u00101\u001a\u0004\u0018\u000102H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\bH\u0002J\u0012\u00104\u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\bH\u0002J\u0012\u00105\u001a\u0004\u0018\u0001062\u0006\u0010!\u001a\u00020\bH\u0002J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\rJ\n\u0010:\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010;\u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010<\u001a\u0002082\u0006\u0010/\u001a\u00020\rH\u0002J\"\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00180>2\u0012\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020 0@H\u0002J\u0012\u0010A\u001a\u0004\u0018\u00010B2\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020\u0005H\u0002J\u000e\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\u0005J\u0012\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010I\u001a\u00020\u00162\u0006\u0010D\u001a\u00020\u0005H\u0002J\u0010\u0010J\u001a\u00020\u00162\u0006\u0010/\u001a\u000200H\u0002J\b\u0010K\u001a\u00020\u0016H\u0002J\u0010\u0010L\u001a\u00020 2\u0006\u0010D\u001a\u00020\u0005H\u0002J\u0006\u0010M\u001a\u00020\u0016J\u000e\u0010N\u001a\u00020 2\u0006\u0010!\u001a\u00020\bJ\u0010\u0010O\u001a\u00020 2\u0006\u0010D\u001a\u00020\u0005H\u0002J\u001a\u0010P\u001a\u00020 2\u0006\u0010!\u001a\u00020\b2\b\u0010Q\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010R\u001a\u00020 2\u0006\u0010D\u001a\u00020\u0005H\u0002J\u0018\u0010S\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\bH\u0002J\u0010\u0010T\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J\u000e\u0010U\u001a\u00020\u00162\u0006\u0010V\u001a\u00020\bJ\u0016\u0010W\u001a\u00020\u00162\u0006\u0010X\u001a\u00020\b2\u0006\u0010Y\u001a\u00020\bJ*\u0010Z\u001a\u00020\u00162\u0006\u0010[\u001a\u00020\b2\u0006\u0010\\\u001a\u00020\r2\u0006\u0010]\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J \u0010^\u001a\u00020\u00162\u0006\u0010D\u001a\u00020\u00052\u000e\b\u0002\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00050>H\u0002J\u000e\u0010`\u001a\u00020\u00162\u0006\u0010a\u001a\u00020\bJ\b\u0010b\u001a\u00020\u0016H\u0002J\u0010\u0010c\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\bH\u0002J\b\u0010d\u001a\u00020\u0016H\u0002J\u000e\u0010e\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010f\u001a\u00020\u0016H\u0002J\b\u0010g\u001a\u00020\u0016H\u0002J\b\u0010h\u001a\u00020\u0016H\u0002J\b\u0010i\u001a\u00020\u0016H\u0002J\u0016\u0010j\u001a\u00020\n2\u0006\u0010k\u001a\u00020\b2\u0006\u0010l\u001a\u00020\bJ\u000e\u0010]\u001a\u00020\n2\u0006\u0010k\u001a\u00020\bJ\u000e\u0010m\u001a\u00020 2\u0006\u0010k\u001a\u00020\rJ\u000e\u0010n\u001a\u00020 2\u0006\u0010k\u001a\u00020\bJ\u000e\u0010o\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\bR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012RR\u0010\u0013\u001aF\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\f0\fj*\u0012\u0004\u0012\u00020\r\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n`\u000e`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lcom/unciv/logic/civilization/managers/QuestManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "()V", "assignedQuests", "Ljava/util/ArrayList;", "Lcom/unciv/logic/civilization/managers/AssignedQuest;", "Lkotlin/collections/ArrayList;", "civ", "Lcom/unciv/logic/civilization/Civilization;", "globalQuestCountdown", "", "individualQuestCountdown", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "unitsKilledFromCiv", "unitsToKillForCiv", "assignNewQuest", "", "quest", "Lcom/unciv/models/ruleset/Quest;", "assignees", "", "barbarianCampCleared", "civInfo", "location", "Lcom/badlogic/gdx/math/Vector2;", "canAssignAQuestTo", "", "challenger", "cityStateBullied", "cityState", "bully", "cityStateConquered", "attacker", "clone", "decrementQuestCountdowns", "endTurn", "endWarWithMajorQuest", "getAssignedQuestsFor", "Lkotlin/sequences/Sequence;", "civName", "getAssignedQuestsOfName", "questName", "Lcom/unciv/models/ruleset/QuestName;", "getBarbarianEncampmentForQuest", "Lcom/unciv/logic/map/tile/Tile;", "getCityStateTarget", "getCivilizationToFindForQuest", "getGreatPersonForQuest", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "getInvestmentMultiplier", "", "donor", "getMostRecentBully", "getNaturalWonderToFindForQuest", "getQuestWeight", "getQuests", "", "predicate", "Lkotlin/Function1;", "getResourceForQuest", "Lcom/unciv/models/ruleset/tile/TileResource;", "getScoreForQuest", "assignedQuest", "getScoreStringForGlobalQuest", "inquiringAssignedQuest", "getWonderToBuildForQuest", "Lcom/unciv/models/ruleset/Building;", "giveReward", "handleGlobalQuest", "handleGlobalQuests", "handleIndividualQuest", "handleIndividualQuests", "haveQuestsFor", "isComplete", "isDenounceCivQuestValid", "mostRecentBully", "isObsolete", "isQuestValid", "isRouteQuestValid", "justMet", "otherCiv", "militaryUnitKilledBy", "killer", "killed", "notifyAskForAssistance", "assignee", "attackerName", "unitsToKill", "notifyExpired", "winners", "receivedGoldGift", "donorCiv", "seedGlobalQuestCountdown", "seedIndividualQuestsCountdown", "seedIndividualQuestsCountdowns", "setTransients", "tryBarbarianInvasion", "tryEndWarWithMajorQuests", "tryStartNewGlobalQuest", "tryStartNewIndividualQuests", "unitsKilledSoFar", "target", "viewingCiv", "wantsDead", "warWithMajorActive", "wasAttackedBy", "Companion", "WinnersAndLosers", "core"})
@SourceDebugExtension(value={"SMAP\nQuestManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestManager.kt\ncom/unciv/logic/civilization/managers/QuestManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,921:1\n1247#2,2:922\n179#2,2:924\n1268#2,3:936\n1247#2,2:952\n1247#2,2:966\n1247#2,2:968\n1268#2,3:970\n2159#2,2:994\n1268#2,3:1051\n766#3:926\n857#3,2:927\n1774#3,4:929\n766#3:933\n857#3,2:934\n766#3:939\n857#3,2:940\n1549#3:942\n1620#3,3:943\n1855#3,2:946\n1855#3,2:948\n223#3,2:950\n288#3,2:954\n1747#3,3:956\n1549#3:959\n1620#3,3:960\n1747#3,3:963\n1549#3:980\n1620#3,3:981\n1549#3:984\n1620#3,3:985\n1549#3:988\n1620#3,3:989\n766#3:992\n857#3:993\n858#3:996\n1549#3:997\n1620#3,3:998\n819#3:1001\n847#3,2:1002\n1603#3,9:1004\n1855#3:1013\n1856#3:1015\n1612#3:1016\n766#3:1017\n857#3,2:1018\n2333#3,14:1020\n766#3:1034\n857#3,2:1035\n1963#3,14:1037\n372#4,7:973\n1#5:1014\n*S KotlinDebug\n*F\n+ 1 QuestManager.kt\ncom/unciv/logic/civilization/managers/QuestManager\n*L\n95#1:922,2\n99#1:924,2\n226#1:936,3\n379#1:952,2\n433#1:966,2\n448#1:968,2\n633#1:970,3\n797#1:994,2\n205#1:1051,3\n196#1:926\n196#1:927,2\n201#1:929,4\n212#1:933\n212#1:934,2\n265#1:939\n265#1:940,2\n265#1:942\n265#1:943,3\n272#1:946,2\n273#1:948,2\n338#1:950,2\n396#1:954,2\n411#1:956,3\n431#1:959\n431#1:960,3\n432#1:963,3\n688#1:980\n688#1:981,3\n768#1:984\n768#1:985,3\n769#1:988\n769#1:989,3\n788#1:992\n788#1:993\n788#1:996\n824#1:997\n824#1:998,3\n828#1:1001\n828#1:1002,2\n851#1:1004,9\n851#1:1013\n851#1:1015\n851#1:1016\n851#1:1017\n851#1:1018,2\n851#1:1020,14\n865#1:1034\n865#1:1035,2\n866#1:1037,14\n663#1:973,7\n851#1:1014\n*E\n"})
public final class QuestManager
implements IsPartOfGameInfoSerialization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private transient Civilization civ;
    @NotNull
    private ArrayList<AssignedQuest> assignedQuests = new ArrayList();
    private int globalQuestCountdown = -1;
    @NotNull
    private HashMap<String, Integer> individualQuestCountdown = new HashMap();
    @NotNull
    private HashMap<String, Integer> unitsToKillForCiv = new HashMap();
    @NotNull
    private HashMap<String, HashMap<String, Integer>> unitsKilledFromCiv = new HashMap();
    public static final int UNSET = -1;
    public static final int GLOBAL_QUEST_FIRST_POSSIBLE_TURN = 30;
    public static final int INDIVIDUAL_QUEST_FIRST_POSSIBLE_TURN = 30;
    public static final int GLOBAL_QUEST_FIRST_POSSIBLE_TURN_RAND = 20;
    public static final int INDIVIDUAL_QUEST_FIRST_POSSIBLE_TURN_RAND = 20;
    public static final int GLOBAL_QUEST_MIN_TURNS_BETWEEN = 40;
    public static final int INDIVIDUAL_QUEST_MIN_TURNS_BETWEEN = 20;
    public static final int GLOBAL_QUEST_RAND_TURNS_BETWEEN = 25;
    public static final int INDIVIDUAL_QUEST_RAND_TURNS_BETWEEN = 25;
    public static final int GLOBAL_QUEST_MAX_ACTIVE = 1;
    public static final int INDIVIDUAL_QUEST_MAX_ACTIVE = 2;

    private final Ruleset getRuleset() {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        return civilization.getGameInfo().getRuleset();
    }

    public final boolean haveQuestsFor(@NotNull Civilization challenger) {
        Intrinsics.checkNotNullParameter(challenger, "challenger");
        return SequencesKt.any(this.getAssignedQuestsFor(challenger.getCivName()));
    }

    @NotNull
    public final Sequence<AssignedQuest> getAssignedQuestsFor(@NotNull String civName) {
        Intrinsics.checkNotNullParameter(civName, "civName");
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.assignedQuests), (Function1)new Function1<AssignedQuest, Boolean>(civName){
            final /* synthetic */ String $civName;
            {
                this.$civName = $civName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull AssignedQuest it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getAssignee(), this.$civName);
            }
        });
    }

    private final Sequence<AssignedQuest> getAssignedQuestsOfName(QuestName questName) {
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.assignedQuests), (Function1)new Function1<AssignedQuest, Boolean>(questName){
            final /* synthetic */ QuestName $questName;
            {
                this.$questName = $questName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull AssignedQuest it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getQuestNameInstance() == this.$questName;
            }
        });
    }

    public final boolean wantsDead(@NotNull String target) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(target, "target");
            Sequence<AssignedQuest> $this$any$iv = this.getAssignedQuestsOfName(QuestName.ConquerCityState);
            boolean $i$f$any = false;
            Iterator<AssignedQuest> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                AssignedQuest element$iv;
                AssignedQuest it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getData1(), target)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final float getInvestmentMultiplier(@NotNull String donor) {
        AssignedQuest assignedQuest;
        block2: {
            Intrinsics.checkNotNullParameter(donor, "donor");
            Sequence<AssignedQuest> $this$firstOrNull$iv = this.getAssignedQuestsOfName(QuestName.Invest);
            boolean $i$f$firstOrNull = false;
            Iterator<AssignedQuest> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                AssignedQuest element$iv;
                AssignedQuest it = element$iv = iterator2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getAssignee(), donor)) continue;
                assignedQuest = element$iv;
                break block2;
            }
            assignedQuest = null;
        }
        AssignedQuest assignedQuest2 = assignedQuest;
        if (assignedQuest2 == null) {
            return 1.0f;
        }
        AssignedQuest investmentQuest = assignedQuest2;
        return FormattingExtensionsKt.toPercent(investmentQuest.getData1());
    }

    @NotNull
    public final QuestManager clone() {
        QuestManager toReturn = new QuestManager();
        toReturn.globalQuestCountdown = this.globalQuestCountdown;
        toReturn.individualQuestCountdown.putAll((Map<String, Integer>)this.individualQuestCountdown);
        toReturn.assignedQuests.addAll((Collection<AssignedQuest>)this.assignedQuests);
        toReturn.unitsToKillForCiv.putAll((Map<String, Integer>)this.unitsToKillForCiv);
        for (Map.Entry entry : ((Map)this.unitsKilledFromCiv).entrySet()) {
            String attacker = (String)entry.getKey();
            HashMap unitsKilled = (HashMap)entry.getValue();
            ((Map)toReturn.unitsKilledFromCiv).put(attacker, new HashMap(unitsKilled));
        }
        return toReturn;
    }

    public final void setTransients(@NotNull Civilization civ) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        this.civ = civ;
        for (AssignedQuest quest2 : this.assignedQuests) {
            Intrinsics.checkNotNull(quest2);
            AssignedQuest.setTransients$core$default(quest2, civ.getGameInfo(), null, 2, null);
        }
    }

    public final void endTurn() {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (civilization.isDefeated()) {
            this.assignedQuests.clear();
            this.individualQuestCountdown.clear();
            this.globalQuestCountdown = -1;
            return;
        }
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        if (civilization2.getCities().isEmpty()) {
            return;
        }
        this.seedGlobalQuestCountdown();
        this.seedIndividualQuestsCountdowns();
        this.decrementQuestCountdowns();
        this.handleGlobalQuests();
        this.handleIndividualQuests();
        this.tryStartNewGlobalQuest();
        this.tryStartNewIndividualQuests();
        this.tryBarbarianInvasion();
        this.tryEndWarWithMajorQuests();
    }

    private final void decrementQuestCountdowns() {
        if (this.globalQuestCountdown > 0) {
            --this.globalQuestCountdown;
        }
        for (Map.Entry entry : ((Map)this.individualQuestCountdown).entrySet()) {
            if (((Number)entry.getValue()).intValue() <= 0) continue;
            entry.setValue(((Number)entry.getValue()).intValue() - 1);
        }
    }

    private final void seedGlobalQuestCountdown() {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (civilization.getGameInfo().getTurns() < 30) {
            return;
        }
        if (this.globalQuestCountdown != -1) {
            return;
        }
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        int countdown = civilization2.getGameInfo().getTurns() == 30 ? Random.Default.nextInt(20) : 40 + Random.Default.nextInt(25);
        float f = countdown;
        Civilization civilization3 = this.civ;
        if (civilization3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization3 = null;
        }
        this.globalQuestCountdown = (int)(f * civilization3.getGameInfo().getSpeed().getModifier());
    }

    private final void seedIndividualQuestsCountdowns() {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (civilization.getGameInfo().getTurns() < 30) {
            return;
        }
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        List<Civilization> majorCivs2 = civilization2.getGameInfo().getAliveMajorCivs();
        for (Civilization majorCiv : majorCivs2) {
            if (this.individualQuestCountdown.containsKey(majorCiv.getCivName())) {
                Integer n = this.individualQuestCountdown.get(majorCiv.getCivName());
                int n2 = -1;
                if (n == null || n != n2) continue;
            }
            this.seedIndividualQuestsCountdown(majorCiv);
        }
    }

    private final void seedIndividualQuestsCountdown(Civilization challenger) {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        int countdown = civilization.getGameInfo().getTurns() == 30 ? Random.Default.nextInt(20) : 20 + Random.Default.nextInt(25);
        Map map2 = this.individualQuestCountdown;
        String string = challenger.getCivName();
        float f = countdown;
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        Integer n = (int)(f * civilization2.getGameInfo().getSpeed().getModifier());
        map2.put(string, n);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Quest> getQuests(Function1<? super Quest, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        Collection<Quest> collection = this.getRuleset().getQuests().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!predicate.invoke((Quest)element$iv$iv).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void tryStartNewGlobalQuest() {
        Sequence<Civilization> majorCivs2;
        List<Quest> assignableQuests2;
        int n;
        if (this.globalQuestCountdown != 0) {
            return;
        }
        Iterable $this$count$iv = this.assignedQuests;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                AssignedQuest it = (AssignedQuest)element$iv;
                boolean bl = false;
                if (!it.isGlobal() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n >= 1) {
            return;
        }
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (!((Collection)(assignableQuests2 = this.getQuests((Function1<? super Quest, Boolean>)new Function1<Quest, Boolean>(majorCivs2 = SequencesKt.filter(civilization.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(this){
            final /* synthetic */ QuestManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.isMajorCiv()) {
                    Civilization civilization = QuestManager.access$getCiv$p(this.this$0);
                    if (civilization == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        civilization = null;
                    }
                    if (!it.isAtWarWith(civilization)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }), this){
            final /* synthetic */ Sequence<Civilization> $majorCivs;
            final /* synthetic */ QuestManager this$0;
            {
                this.$majorCivs = $majorCivs;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Quest it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isGlobal() && QuestManager.access$tryStartNewGlobalQuest$isAssignable(it, this.$majorCivs, this.this$0);
            }
        }))).isEmpty()) {
            void $this$filterTo$iv$iv;
            Quest quest2 = (Quest)CollectionExtensionsKt.randomWeighted$default(assignableQuests2, null, new Function1<Quest, Float>(this){
                final /* synthetic */ QuestManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Float invoke(@NotNull Quest it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Float.valueOf(QuestManager.access$getQuestWeight(this.this$0, it.getName()));
                }
            }, 1, null);
            Civilization civilization2 = this.civ;
            if (civilization2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization2 = null;
            }
            Iterable $this$filter$iv = civilization2.getGameInfo().getAliveMajorCivs();
            boolean $i$f$filter = false;
            Iterable bl = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Civilization it = (Civilization)element$iv$iv;
                boolean bl2 = false;
                Civilization civilization3 = this.civ;
                if (civilization3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization3 = null;
                }
                if (!(!it.isAtWarWith(civilization3) && this.isQuestValid(quest2, it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List assignees = (List)destination$iv$iv;
            this.assignNewQuest(quest2, assignees);
            this.globalQuestCountdown = -1;
        }
    }

    private final void tryStartNewIndividualQuests() {
        for (Map.Entry entry : ((Map)this.individualQuestCountdown).entrySet()) {
            List<Quest> assignableQuests2;
            String challengerName = (String)entry.getKey();
            int countdown = ((Number)entry.getValue()).intValue();
            Civilization civilization = this.civ;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            Civilization challenger = civilization.getGameInfo().getCivilization(challengerName);
            if (countdown != 0) continue;
            Sequence<AssignedQuest> $this$count$iv = this.getAssignedQuestsFor(challenger.getCivName());
            boolean $i$f$count = false;
            int count$iv = 0;
            Civilization[] civilizationArray = $this$count$iv.iterator();
            while (civilizationArray.hasNext()) {
                AssignedQuest element$iv;
                AssignedQuest it = element$iv = civilizationArray.next();
                boolean bl = false;
                if (!it.isIndividual() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            if (count$iv >= 2 || !(!((Collection)(assignableQuests2 = this.getQuests((Function1<? super Quest, Boolean>)new Function1<Quest, Boolean>(this, challenger){
                final /* synthetic */ QuestManager this$0;
                final /* synthetic */ Civilization $challenger;
                {
                    this.this$0 = $receiver;
                    this.$challenger = $challenger;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Quest it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.isIndividual() && QuestManager.access$isQuestValid(this.this$0, it, this.$challenger);
                }
            }))).isEmpty())) continue;
            Quest quest2 = (Quest)CollectionExtensionsKt.randomWeighted$default(assignableQuests2, null, new Function1<Quest, Float>(this){
                final /* synthetic */ QuestManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Float invoke(@NotNull Quest it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Float.valueOf(QuestManager.access$getQuestWeight(this.this$0, it.getName()));
                }
            }, 1, null);
            civilizationArray = new Civilization[]{challenger};
            ArrayList<Civilization> assignees = CollectionsKt.arrayListOf(civilizationArray);
            this.assignNewQuest(quest2, (Iterable<Civilization>)assignees);
        }
    }

    private final void tryBarbarianInvasion() {
        block14: {
            Civilization civilization;
            block13: {
                Civilization civilization2 = this.civ;
                if (civilization2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization2 = null;
                }
                if (civilization2.getTurnsTillCallForBarbHelp() == null) break block13;
                Civilization civilization3 = this.civ;
                if (civilization3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization3 = null;
                }
                Integer n = civilization3.getTurnsTillCallForBarbHelp();
                if (n == null || n != 0) break block14;
            }
            if ((civilization = this.civ) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            if (civilization.getCityStateFunctions().getNumThreateningBarbarians() >= 2) {
                Civilization civilization4 = this.civ;
                if (civilization4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization4 = null;
                }
                Iterator<Civilization> iterator2 = SequencesKt.filter(civilization4.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(this){
                    final /* synthetic */ QuestManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull Civilization it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (it.isMajorCiv() && it.isAlive()) {
                            Civilization civilization = QuestManager.access$getCiv$p(this.this$0);
                            if (civilization == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("civ");
                                civilization = null;
                            }
                            if (!it.isAtWarWith(civilization)) {
                                Civilization civilization2 = QuestManager.access$getCiv$p(this.this$0);
                                if (civilization2 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                                    civilization2 = null;
                                }
                                if (it.getProximity(civilization2).compareTo((Enum)Proximity.Far) <= 0) {
                                    bl = true;
                                    return bl;
                                }
                            }
                        }
                        bl = false;
                        return bl;
                    }
                }).iterator();
                while (iterator2.hasNext()) {
                    Civilization otherCiv = iterator2.next();
                    StringBuilder stringBuilder = new StringBuilder().append('[');
                    Civilization civilization5 = this.civ;
                    if (civilization5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        civilization5 = null;
                    }
                    String string = stringBuilder.append(civilization5.getCivName()).append("] is being invaded by Barbarians! Destroy Barbarians near their territory to earn Influence.").toString();
                    Civilization civilization6 = this.civ;
                    if (civilization6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        civilization6 = null;
                    }
                    City city2 = Civilization.getCapital$default(civilization6, false, 1, null);
                    Intrinsics.checkNotNull(city2);
                    Vector2 vector2 = city2.getLocation();
                    String[] stringArray = new String[2];
                    Civilization civilization7 = this.civ;
                    if (civilization7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        civilization7 = null;
                    }
                    stringArray[0] = civilization7.getCivName();
                    stringArray[1] = "OtherIcons/Pillage";
                    otherCiv.addNotification(string, vector2, Notification.NotificationCategory.Diplomacy, stringArray);
                }
                Civilization civilization8 = this.civ;
                if (civilization8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization8 = null;
                }
                civilization8.addFlag("TurnsTillCallForBarbHelp", 30);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleGlobalQuests() {
        void $this$mapTo$iv$iv;
        boolean bl;
        AssignedQuest it;
        Iterable $this$filterTo$iv$iv;
        CollectionsKt.removeAll((List)this.assignedQuests, (Function1)new Function1<AssignedQuest, Boolean>(this){
            final /* synthetic */ QuestManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull AssignedQuest it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.isGlobal()) {
                    Civilization civilization = QuestManager.access$getCiv$p(this.this$0);
                    if (civilization == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        civilization = null;
                    }
                    if (!QuestManager.access$canAssignAQuestTo(this.this$0, civilization.getGameInfo().getCivilization(it.getAssignee()))) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        });
        Iterable $this$filter$iv = this.assignedQuests;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AssignedQuest)element$iv$iv;
            bl = false;
            if (!(it.isGlobal() && it.isExpired())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AssignedQuest)item$iv$iv;
            Collection collection = destination$iv$iv;
            bl = false;
            collection.add(it.getQuestNameInstance());
        }
        List<QuestName> globalQuestsExpired = CollectionsKt.distinct((List)destination$iv$iv);
        for (QuestName globalQuestName : globalQuestsExpired) {
            this.handleGlobalQuest(globalQuestName);
        }
    }

    private final void handleGlobalQuest(QuestName questName) {
        AssignedQuest it;
        WinnersAndLosers winnersAndLosers = new WinnersAndLosers(questName);
        Iterable $this$forEach$iv = winnersAndLosers.getWinners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AssignedQuest)element$iv;
            boolean bl = false;
            this.giveReward(it);
        }
        $this$forEach$iv = winnersAndLosers.getLosers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AssignedQuest)element$iv;
            boolean bl = false;
            this.notifyExpired(it, winnersAndLosers.getWinners());
        }
        CollectionsKt.removeAll((List)this.assignedQuests, (Function1)new Function1<AssignedQuest, Boolean>(questName){
            final /* synthetic */ QuestName $questName;
            {
                this.$questName = $questName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull AssignedQuest it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getQuestNameInstance() == this.$questName;
            }
        });
    }

    public final void handleIndividualQuests() {
        CollectionsKt.removeAll((List)this.assignedQuests, (Function1)new Function1<AssignedQuest, Boolean>(this){
            final /* synthetic */ QuestManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull AssignedQuest it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isIndividual() && QuestManager.access$handleIndividualQuest(this.this$0, it);
            }
        });
    }

    private final boolean handleIndividualQuest(AssignedQuest assignedQuest) {
        Civilization assignee;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (!this.canAssignAQuestTo(assignee = civilization.getGameInfo().getCivilization(assignedQuest.getAssignee()))) {
            return true;
        }
        if (this.isComplete(assignedQuest)) {
            this.giveReward(assignedQuest);
            return true;
        }
        if (this.isObsolete(assignedQuest)) {
            QuestManager.notifyExpired$default(this, assignedQuest, null, 2, null);
            return true;
        }
        if (assignedQuest.isExpired()) {
            QuestManager.notifyExpired$default(this, assignedQuest, null, 2, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void assignNewQuest(Quest quest2, Iterable<Civilization> assignees) {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        int turn = civilization.getGameInfo().getTurns();
        Iterator<Civilization> iterator2 = assignees.iterator();
        while (iterator2.hasNext()) {
            void var8_8;
            Civilization assignee = iterator2.next();
            String data1 = "";
            String data2 = "";
            Civilization civilization2 = this.civ;
            if (civilization2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization2 = null;
            }
            List<DiplomacyAction> list2 = CollectionsKt.listOf(new DiplomacyAction(civilization2.getCivName(), false, 2, null));
            switch (WhenMappings.$EnumSwitchMapping$0[quest2.getQuestNameInstance().ordinal()]) {
                case 1: {
                    Tile camp;
                    Intrinsics.checkNotNull(this.getBarbarianEncampmentForQuest());
                    data1 = String.valueOf((int)camp.getPosition().x);
                    data2 = String.valueOf((int)camp.getPosition().y);
                    NotificationAction[] notificationActionArray = new NotificationAction[]{new LocationAction(camp.getPosition()), CollectionsKt.first(list2)};
                    List<NotificationAction> list3 = CollectionsKt.listOf(notificationActionArray);
                    break;
                }
                case 2: {
                    TileResource tileResource = this.getResourceForQuest(assignee);
                    Intrinsics.checkNotNull(tileResource);
                    data1 = tileResource.getName();
                    break;
                }
                case 3: {
                    Building building = this.getWonderToBuildForQuest(assignee);
                    Intrinsics.checkNotNull(building);
                    data1 = building.getName();
                    break;
                }
                case 4: {
                    BaseUnit baseUnit = this.getGreatPersonForQuest(assignee);
                    Intrinsics.checkNotNull(baseUnit);
                    data1 = baseUnit.getName();
                    break;
                }
                case 5: {
                    Civilization civilization3 = this.getCivilizationToFindForQuest(assignee);
                    Intrinsics.checkNotNull(civilization3);
                    data1 = civilization3.getCivName();
                    break;
                }
                case 6: {
                    String string = this.getNaturalWonderToFindForQuest(assignee);
                    Intrinsics.checkNotNull(string);
                    data1 = string;
                    break;
                }
                case 7: {
                    Civilization civilization4 = this.getCityStateTarget(assignee);
                    Intrinsics.checkNotNull(civilization4);
                    data1 = civilization4.getCivName();
                    break;
                }
                case 8: {
                    Civilization civilization5 = this.getCityStateTarget(assignee);
                    Intrinsics.checkNotNull(civilization5);
                    data1 = civilization5.getCivName();
                    break;
                }
                case 9: {
                    String string = this.getMostRecentBully();
                    Intrinsics.checkNotNull(string);
                    data1 = string;
                    break;
                }
                case 10: {
                    String string = this.getMostRecentBully();
                    Intrinsics.checkNotNull(string);
                    data1 = string;
                    break;
                }
                case 11: {
                    String string = this.getMostRecentBully();
                    Intrinsics.checkNotNull(string);
                    data1 = string;
                    break;
                }
                case 12: {
                    Object element$iv;
                    Religion it;
                    void $this$first$iv;
                    Civilization civilization6 = this.civ;
                    if (civilization6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        civilization6 = null;
                    }
                    Collection<Religion> collection = civilization6.getGameInfo().getReligions().values();
                    Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                    Iterable iterable = collection;
                    boolean $i$f$first = false;
                    Iterator iterator3 = $this$first$iv.iterator();
                    do {
                        if (!iterator3.hasNext()) {
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        element$iv = iterator3.next();
                        it = (Religion)element$iv;
                        boolean bl = false;
                    } while (!(Intrinsics.areEqual(it.getFoundingCivName(), assignee.getCivName()) && it.isMajorReligion()));
                    Object t = element$iv;
                    Intrinsics.checkNotNullExpressionValue(t, "first(...)");
                    Religion playerReligion = (Religion)t;
                    data1 = playerReligion.getReligionDisplayName();
                    data2 = playerReligion.getName();
                    break;
                }
                case 13: {
                    data1 = String.valueOf(assignee.getTotalCultureForContests());
                    break;
                }
                case 14: {
                    data1 = String.valueOf(assignee.getTotalFaithForContests());
                    break;
                }
                case 15: {
                    data1 = String.valueOf(assignee.getTech().getNumberOfTechsResearched());
                    break;
                }
                case 16: {
                    data1 = CollectionsKt.first(TranslationsKt.getPlaceholderParameters(quest2.getDescription()));
                    break;
                }
            }
            String string = quest2.getName();
            Civilization civilization7 = this.civ;
            if (civilization7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization7 = null;
            }
            AssignedQuest newQuest = new AssignedQuest(string, civilization7.getCivName(), assignee.getCivName(), turn, data1, data2);
            Civilization civilization8 = this.civ;
            if (civilization8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization8 = null;
            }
            newQuest.setTransients$core(civilization8.getGameInfo(), quest2);
            this.assignedQuests.add(newQuest);
            if (quest2.isIndividual()) {
                ((Map)this.individualQuestCountdown).put(assignee.getCivName(), -1);
            }
            StringBuilder stringBuilder = new StringBuilder().append('[');
            Civilization civilization9 = this.civ;
            if (civilization9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization9 = null;
            }
            String string2 = stringBuilder.append(civilization9.getCivName()).append("] assigned you a new quest: [").append(quest2.getName()).append("].").toString();
            Iterable iterable = (Iterable)var8_8;
            String[] stringArray = new String[2];
            Civilization civilization10 = this.civ;
            if (civilization10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization10 = null;
            }
            stringArray[0] = civilization10.getCivName();
            stringArray[1] = "OtherIcons/Quest";
            assignee.addNotification(string2, iterable, Notification.NotificationCategory.Diplomacy, stringArray);
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canAssignAQuestTo(Civilization challenger) {
        if (challenger.isDefeated()) return false;
        if (!challenger.isMajorCiv()) return false;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (!civilization.knows(challenger)) return false;
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        if (civilization2.isAtWarWith(challenger)) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isQuestValid(Quest quest, Civilization challenger) {
        block42: {
            if (!this.canAssignAQuestTo(challenger)) {
                return false;
            }
            $this$any$iv = this.getAssignedQuestsOfName(quest.getQuestNameInstance());
            $i$f$any = false;
            var5_5 = $this$any$iv.iterator();
            while (var5_5.hasNext()) {
                it = element$iv = var5_5.next();
                $i$a$-any-QuestManager$isQuestValid$1 = false;
                if (!Intrinsics.areEqual(it.getAssignee(), challenger.getCivName())) continue;
                v0 = true;
                break block42;
            }
            v0 = false;
        }
        if (v0) {
            return false;
        }
        if (quest.isIndividual()) {
            v1 = this.civ;
            if (v1 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                v1 = null;
            }
            v2 = v1.getDiplomacyManager(challenger);
            Intrinsics.checkNotNull(v2);
            if (v2.hasFlag(DiplomacyFlags.Bullied)) {
                return false;
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[quest.getQuestNameInstance().ordinal()]) {
            case 1: {
                if (this.getBarbarianEncampmentForQuest() != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 17: {
                v3 = this.isRouteQuestValid(challenger);
                break;
            }
            case 2: {
                if (this.getResourceForQuest(challenger) != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 3: {
                if (this.getWonderToBuildForQuest(challenger) != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 4: {
                if (this.getGreatPersonForQuest(challenger) != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 5: {
                if (this.getCivilizationToFindForQuest(challenger) != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 6: {
                if (this.getNaturalWonderToFindForQuest(challenger) != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 9: {
                if (this.getMostRecentBully() != null) {
                    v4 = this.civ;
                    if (v4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        v4 = null;
                    }
                    if (!v4.getCityStateFunctions().getProtectorCivs().contains(challenger)) {
                        v3 = true;
                        break;
                    }
                }
                v3 = false;
                break;
            }
            case 10: {
                if (this.getMostRecentBully() != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 11: {
                v3 = this.isDenounceCivQuestValid(challenger, this.getMostRecentBully());
                break;
            }
            case 12: {
                v5 = this.civ;
                if (v5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    v5 = null;
                }
                v6 = v5.getGameInfo().getReligions().values();
                Intrinsics.checkNotNullExpressionValue(v6, "<get-values>(...)");
                $this$firstOrNull$iv = v6;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Religion)element$iv;
                    $i$a$-firstOrNull-QuestManager$isQuestValid$playerReligion$1 = false;
                    if (!(Intrinsics.areEqual(it.getFoundingCivName(), challenger.getCivName()) != false && it.isMajorReligion() != false)) continue;
                    v7 = element$iv;
                    ** GOTO lbl101
                }
                v7 = null;
lbl101:
                // 2 sources

                v8 = v7;
                v9 = playerReligion = v8 != null ? v8.getName() : null;
                if (playerReligion != null) {
                    v10 = this.civ;
                    if (v10 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        v10 = null;
                    }
                    v11 = Civilization.getCapital$default(v10, false, 1, null);
                    Intrinsics.checkNotNull(v11);
                    v12 = v11.getReligion().getMajorityReligion();
                    if (!Intrinsics.areEqual(v12 != null ? v12.getName() : null, playerReligion)) {
                        v3 = true;
                        break;
                    }
                }
                v3 = false;
                break;
            }
            case 7: {
                if (this.getCityStateTarget(challenger) != null) {
                    v13 = this.civ;
                    if (v13 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        v13 = null;
                    }
                    if (v13.getCityStatePersonality() != CityStatePersonality.Friendly) {
                        v3 = true;
                        break;
                    }
                }
                v3 = false;
                break;
            }
            case 8: {
                if (this.getCityStateTarget(challenger) != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 14: {
                v14 = this.civ;
                if (v14 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    v14 = null;
                }
                v3 = v14.getGameInfo().isReligionEnabled();
                break;
            }
            default: {
                v3 = true;
            }
        }
        return v3;
    }

    private final boolean isRouteQuestValid(Civilization challenger) {
        boolean bl;
        block8: {
            if (challenger.getCities().isEmpty()) {
                return false;
            }
            Civilization civilization = this.civ;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            City city2 = Civilization.getCapital$default(civilization, false, 1, null);
            Intrinsics.checkNotNull(city2);
            if (challenger.isCapitalConnectedToCity(city2)) {
                return false;
            }
            Civilization civilization2 = this.civ;
            if (civilization2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization2 = null;
            }
            City city3 = Civilization.getCapital$default(civilization2, false, 1, null);
            if (city3 == null) {
                return false;
            }
            City capital = city3;
            Tile capitalTile = capital.getCenterTile();
            Iterable $this$any$iv = challenger.getCities();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    City it = (City)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = it.getCenterTile().getContinent() == capitalTile.getContinent() && it.getCenterTile().aerialDistanceTo(capitalTile) <= 7;
                    if (!bl3) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDenounceCivQuestValid(Civilization challenger, String mostRecentBully) {
        if (mostRecentBully == null) return false;
        if (!challenger.knows(mostRecentBully)) return false;
        DiplomacyManager diplomacyManager = challenger.getDiplomacyManager(mostRecentBully);
        Intrinsics.checkNotNull(diplomacyManager);
        if (diplomacyManager.hasFlag(DiplomacyFlags.Denunciation)) return false;
        DiplomacyManager diplomacyManager2 = challenger.getDiplomacyManager(mostRecentBully);
        Intrinsics.checkNotNull(diplomacyManager2);
        if (diplomacyManager2.getDiplomaticStatus() == DiplomaticStatus.War) return false;
        if (challenger.getPlayerType() != PlayerType.Human) return true;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (civilization.getGameInfo().getCivilization(mostRecentBully).getPlayerType() == PlayerType.Human) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isComplete(AssignedQuest assignedQuest) {
        boolean bl;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Civilization assignee = civilization.getGameInfo().getCivilization(assignedQuest.getAssignee());
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[assignedQuest.getQuestNameInstance().ordinal()]) {
            case 17: {
                Civilization civilization2 = this.civ;
                if (civilization2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization2 = null;
                }
                City city2 = Civilization.getCapital$default(civilization2, false, 1, null);
                Intrinsics.checkNotNull(city2);
                bl = assignee.isCapitalConnectedToCity(city2);
                break;
            }
            case 2: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = assignee.getDetailedCivResources();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ResourceSupplyList.ResourceSupply resourceSupply = (ResourceSupplyList.ResourceSupply)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getResource());
                }
                bl = CollectionsKt.contains((List)destination$iv$iv, this.getRuleset().getTileResources().get(assignedQuest.getData1()));
                break;
            }
            case 3: {
                Iterable $this$any$iv = assignee.getCities();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                for (Object element$iv : $this$any$iv) {
                    City it = (City)element$iv;
                    boolean bl3 = false;
                    if (!it.getCityConstructions().isBuilt(assignedQuest.getData1())) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 4: {
                Sequence<MapUnit> $this$any$iv = assignee.getUnits().getCivGreatPeople();
                boolean $i$f$any = false;
                Iterator<MapUnit> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    MapUnit element$iv;
                    MapUnit it = element$iv = iterator2.next();
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual(it.getBaseUnit().getReplacedUnit(this.getRuleset()).getName(), assignedQuest.getData1())) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 5: {
                Civilization civilization3 = this.civ;
                if (civilization3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization3 = null;
                }
                bl = assignee.hasMetCivTerritory(civilization3.getGameInfo().getCivilization(assignedQuest.getData1()));
                break;
            }
            case 6: {
                bl = assignee.getNaturalWonders().contains(assignedQuest.getData1());
                break;
            }
            case 9: {
                Civilization civilization4 = this.civ;
                if (civilization4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization4 = null;
                }
                bl = civilization4.getCityStateFunctions().getProtectorCivs().contains(assignee);
                break;
            }
            case 11: {
                DiplomacyManager diplomacyManager = assignee.getDiplomacyManager(assignedQuest.getData1());
                Intrinsics.checkNotNull(diplomacyManager);
                bl = diplomacyManager.hasFlag(DiplomacyFlags.Denunciation);
                break;
            }
            case 12: {
                Civilization civilization5 = this.civ;
                if (civilization5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization5 = null;
                }
                City city3 = Civilization.getCapital$default(civilization5, false, 1, null);
                Intrinsics.checkNotNull(city3);
                Religion religion = city3.getReligion().getMajorityReligion();
                Civilization civilization6 = this.civ;
                if (civilization6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization6 = null;
                }
                bl = Intrinsics.areEqual(religion, civilization6.getGameInfo().getReligions().get(assignedQuest.getData2()));
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isObsolete(AssignedQuest assignedQuest) {
        boolean bl;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Civilization assignee = civilization.getGameInfo().getCivilization(assignedQuest.getAssignee());
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[assignedQuest.getQuestNameInstance().ordinal()]) {
            case 1: {
                Civilization civilization2 = this.civ;
                if (civilization2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization2 = null;
                }
                if (!Intrinsics.areEqual(civilization2.getGameInfo().getTileMap().get(Integer.parseInt(assignedQuest.getData1()), Integer.parseInt(assignedQuest.getData2())).getImprovement(), "Barbarian encampment")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                Civilization civilization3 = this.civ;
                if (civilization3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization3 = null;
                }
                Sequence<City> $this$any$iv = civilization3.getGameInfo().getCities();
                boolean $i$f$any = false;
                Iterator<City> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    City element$iv;
                    City it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual(it.getCiv(), assignee) && it.getCityConstructions().isBuilt(assignedQuest.getData1()))) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 5: {
                Civilization civilization4 = this.civ;
                if (civilization4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization4 = null;
                }
                bl = civilization4.getGameInfo().getCivilization(assignedQuest.getData1()).isDefeated();
                break;
            }
            case 7: {
                Civilization civilization5 = this.civ;
                if (civilization5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization5 = null;
                }
                bl = civilization5.getGameInfo().getCivilization(assignedQuest.getData1()).isDefeated();
                break;
            }
            case 8: {
                Civilization civilization6 = this.civ;
                if (civilization6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization6 = null;
                }
                bl = civilization6.getGameInfo().getCivilization(assignedQuest.getData1()).isDefeated();
                break;
            }
            case 11: {
                Civilization civilization7 = this.civ;
                if (civilization7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization7 = null;
                }
                bl = civilization7.getGameInfo().getCivilization(assignedQuest.getData1()).isDefeated();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final void giveReward(AssignedQuest assignedQuest) {
        Civilization civilization;
        float rewardInfluence = assignedQuest.getInfluence();
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        Civilization assignee = civilization2.getGameInfo().getCivilization(assignedQuest.getAssignee());
        Civilization civilization3 = this.civ;
        if (civilization3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization3 = null;
        }
        DiplomacyManager diplomacyManager = civilization3.getDiplomacyManager(assignedQuest.getAssignee());
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.addInfluence(rewardInfluence);
        if (rewardInfluence > 0.0f) {
            StringBuilder stringBuilder = new StringBuilder().append('[');
            Civilization civilization4 = this.civ;
            if (civilization4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization4 = null;
            }
            String string = stringBuilder.append(civilization4.getCivName()).append("] rewarded you with [").append((int)rewardInfluence).append("] influence for completing the [").append(assignedQuest.getQuestName()).append("] quest.").toString();
            Civilization civilization5 = this.civ;
            if (civilization5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization5 = null;
            }
            City city2 = Civilization.getCapital$default(civilization5, false, 1, null);
            Intrinsics.checkNotNull(city2);
            Vector2 vector2 = city2.getLocation();
            String[] stringArray = new String[2];
            Civilization civilization6 = this.civ;
            if (civilization6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization6 = null;
            }
            stringArray[0] = civilization6.getCivName();
            stringArray[1] = "OtherIcons/Quest";
            assignee.addNotification(string, vector2, Notification.NotificationCategory.Diplomacy, stringArray);
        }
        if ((civilization = this.civ) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        for (City city3 : civilization.getCities()) {
            CityStats.update$default(city3.getCityStats(), null, false, false, null, 15, null);
        }
    }

    private final void notifyExpired(AssignedQuest assignedQuest, List<AssignedQuest> winners) {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Civilization assignee = civilization.getGameInfo().getCivilization(assignedQuest.getAssignee());
        if (winners.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append('[');
            Civilization civilization2 = this.civ;
            if (civilization2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization2 = null;
            }
            String string = stringBuilder.append(civilization2.getCivName()).append("] no longer needs your help with the [").append(assignedQuest.getQuestName()).append("] quest.").toString();
            Civilization civilization3 = this.civ;
            if (civilization3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization3 = null;
            }
            City city2 = Civilization.getCapital$default(civilization3, false, 1, null);
            Intrinsics.checkNotNull(city2);
            Vector2 vector2 = city2.getLocation();
            String[] stringArray = new String[2];
            Civilization civilization4 = this.civ;
            if (civilization4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization4 = null;
            }
            stringArray[0] = civilization4.getCivName();
            stringArray[1] = "OtherIcons/Quest";
            assignee.addNotification(string, vector2, Notification.NotificationCategory.Diplomacy, stringArray);
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("The [").append(assignedQuest.getQuestName()).append("] quest for [");
            Civilization civilization5 = this.civ;
            if (civilization5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization5 = null;
            }
            String string = stringBuilder.append(civilization5.getCivName()).append("] has ended. It was won by [").append(CollectionsKt.joinToString$default(winners, null, null, null, 0, null, notifyExpired.1.INSTANCE, 31, null)).append("].").toString();
            Civilization civilization6 = this.civ;
            if (civilization6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization6 = null;
            }
            City city3 = Civilization.getCapital$default(civilization6, false, 1, null);
            Intrinsics.checkNotNull(city3);
            Vector2 vector2 = city3.getLocation();
            String[] stringArray = new String[2];
            Civilization civilization7 = this.civ;
            if (civilization7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization7 = null;
            }
            stringArray[0] = civilization7.getCivName();
            stringArray[1] = "OtherIcons/Quest";
            assignee.addNotification(string, vector2, Notification.NotificationCategory.Diplomacy, stringArray);
        }
    }

    static /* synthetic */ void notifyExpired$default(QuestManager questManager, AssignedQuest assignedQuest, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        questManager.notifyExpired(assignedQuest, list2);
    }

    private final int getScoreForQuest(AssignedQuest assignedQuest) {
        int n;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Civilization assignee = civilization.getGameInfo().getCivilization(assignedQuest.getAssignee());
        switch (WhenMappings.$EnumSwitchMapping$0[assignedQuest.getQuestNameInstance().ordinal()]) {
            case 13: {
                n = assignee.getTotalCultureForContests() - Integer.parseInt(assignedQuest.getData1());
                break;
            }
            case 14: {
                n = assignee.getTotalFaithForContests() - Integer.parseInt(assignedQuest.getData1());
                break;
            }
            case 15: {
                n = assignee.getTech().getNumberOfTechsResearched() - Integer.parseInt(assignedQuest.getData1());
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @NotNull
    public final String getScoreStringForGlobalQuest(@NotNull AssignedQuest inquiringAssignedQuest) {
        String string;
        Intrinsics.checkNotNullParameter(inquiringAssignedQuest, "inquiringAssignedQuest");
        String string2 = inquiringAssignedQuest.getAssigner();
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (!Intrinsics.areEqual(string2, civilization.getCivName())) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        if (!inquiringAssignedQuest.isGlobal()) {
            String string4 = "Failed requirement.";
            throw new IllegalArgumentException(string4.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[inquiringAssignedQuest.getQuestNameInstance().ordinal()]) {
            case 13: {
                string = "Culture";
                break;
            }
            case 14: {
                string = "Faith";
                break;
            }
            case 15: {
                string = "Technologies";
                break;
            }
            default: {
                return "";
            }
        }
        String scoreDescriptor = string;
        WinnersAndLosers evaluation = new WinnersAndLosers(inquiringAssignedQuest.getQuestNameInstance());
        if (evaluation.getWinners().isEmpty()) {
            return "";
        }
        String listOfLeadersAsTranslatedString2 = CollectionsKt.joinToString$default(evaluation.getWinners(), ", ", null, null, 0, null, getScoreStringForGlobalQuest.listOfLeadersAsTranslatedString.1.INSTANCE, 30, null);
        String leadersString = QuestManager.getScoreStringForGlobalQuest$getScoreString(scoreDescriptor, listOfLeadersAsTranslatedString2, evaluation.getMaxScore());
        if (evaluation.getWinners().contains(inquiringAssignedQuest)) {
            return "Current leader(s): [" + leadersString + ']';
        }
        String yourScoreString = QuestManager.getScoreStringForGlobalQuest$getScoreString(scoreDescriptor, inquiringAssignedQuest.getAssignee(), this.getScoreForQuest(inquiringAssignedQuest));
        return "Current leader(s): [" + leadersString + "], you: [" + yourScoreString + ']';
    }

    public final void barbarianCampCleared(@NotNull Civilization civInfo, @NotNull Vector2 location) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(location, "location");
        Sequence<AssignedQuest> matchingQuests2 = SequencesKt.filter(this.getAssignedQuestsOfName(QuestName.ClearBarbarianCamp), (Function1)new Function1<AssignedQuest, Boolean>(location){
            final /* synthetic */ Vector2 $location;
            {
                this.$location = $location;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull AssignedQuest it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Integer.parseInt(it.getData1()) == (int)this.$location.x && Integer.parseInt(it.getData2()) == (int)this.$location.y;
            }
        });
        AssignedQuest winningQuest2 = SequencesKt.firstOrNull(SequencesKt.filter(matchingQuests2, (Function1)new Function1<AssignedQuest, Boolean>(civInfo){
            final /* synthetic */ Civilization $civInfo;
            {
                this.$civInfo = $civInfo;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull AssignedQuest it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getAssignee(), this.$civInfo.getCivName());
            }
        }));
        if (winningQuest2 != null) {
            this.giveReward(winningQuest2);
        }
        CollectionsKt.removeAll((Collection)this.assignedQuests, matchingQuests2);
    }

    public final void cityStateConquered(@NotNull Civilization cityState, @NotNull Civilization attacker) {
        Intrinsics.checkNotNullParameter(cityState, "cityState");
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Sequence<AssignedQuest> matchingQuests2 = SequencesKt.filter(this.getAssignedQuestsOfName(QuestName.ConquerCityState), (Function1)new Function1<AssignedQuest, Boolean>(cityState, attacker){
            final /* synthetic */ Civilization $cityState;
            final /* synthetic */ Civilization $attacker;
            {
                this.$cityState = $cityState;
                this.$attacker = $attacker;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull AssignedQuest it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getData1(), this.$cityState.getCivName()) && Intrinsics.areEqual(it.getAssignee(), this.$attacker.getCivName());
            }
        });
        Iterator<AssignedQuest> iterator2 = matchingQuests2.iterator();
        while (iterator2.hasNext()) {
            AssignedQuest quest2 = iterator2.next();
            this.giveReward(quest2);
        }
        CollectionsKt.removeAll((Collection)this.assignedQuests, matchingQuests2);
    }

    public final void cityStateBullied(@NotNull Civilization cityState, @NotNull Civilization bully) {
        Intrinsics.checkNotNullParameter(cityState, "cityState");
        Intrinsics.checkNotNullParameter(bully, "bully");
        Sequence<AssignedQuest> matchingQuests2 = SequencesKt.filter(this.getAssignedQuestsOfName(QuestName.BullyCityState), (Function1)new Function1<AssignedQuest, Boolean>(cityState, bully){
            final /* synthetic */ Civilization $cityState;
            final /* synthetic */ Civilization $bully;
            {
                this.$cityState = $cityState;
                this.$bully = $bully;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull AssignedQuest it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getData1(), this.$cityState.getCivName()) && Intrinsics.areEqual(it.getAssignee(), this.$bully.getCivName());
            }
        });
        Iterator<AssignedQuest> iterator2 = matchingQuests2.iterator();
        while (iterator2.hasNext()) {
            AssignedQuest quest2 = iterator2.next();
            this.giveReward(quest2);
        }
        CollectionsKt.removeAll((Collection)this.assignedQuests, matchingQuests2);
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (!Intrinsics.areEqual(civilization, cityState)) {
            return;
        }
        List<AssignedQuest> revokedQuests2 = SequencesKt.toList(SequencesKt.filter(this.getAssignedQuestsFor(bully.getCivName()), cityStateBullied.revokedQuests.1.INSTANCE));
        this.assignedQuests.removeAll((Collection)revokedQuests2);
        if (revokedQuests2.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append('[');
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        String string = stringBuilder.append(civilization2.getCivName()).append("] cancelled the quests they had given you because you demanded tribute from them.").toString();
        Civilization civilization3 = this.civ;
        if (civilization3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization3 = null;
        }
        NotificationAction notificationAction = new DiplomacyAction(civilization3.getCivName(), false, 2, null);
        String[] stringArray = new String[2];
        Civilization civilization4 = this.civ;
        if (civilization4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization4 = null;
        }
        stringArray[0] = civilization4.getCivName();
        stringArray[1] = "OtherIcons/Quest";
        bully.addNotification(string, notificationAction, Notification.NotificationCategory.Diplomacy, stringArray);
    }

    public final void wasAttackedBy(@NotNull Civilization attacker) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Sequence<MapUnit> $this$count$iv = attacker.getUnits().getCivUnits();
        boolean $i$f$count = false;
        int count$iv = 0;
        Object object = $this$count$iv.iterator();
        while (object.hasNext()) {
            MapUnit element$iv;
            MapUnit it = element$iv = object.next();
            boolean bl = false;
            if (!(!it.isCivilian()) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int totalMilitaryUnits = count$iv;
        int unitsToKill = RangesKt.coerceAtMost(totalMilitaryUnits / 4, 3);
        object = unitsToKill;
        ((Map)this.unitsToKillForCiv).put(attacker.getCivName(), object);
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        City city2 = civilization.getCapital(true);
        Vector2 location = city2 != null ? city2.getLocation() : null;
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        Iterator<Civilization> iterator2 = civilization2.getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            Civilization thirdCiv = iterator2.next();
            if (!thirdCiv.isMajorCiv() || thirdCiv.isDefeated()) continue;
            Civilization civilization3 = this.civ;
            if (civilization3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization3 = null;
            }
            if (thirdCiv.isAtWarWith(civilization3)) continue;
            this.notifyAskForAssistance(thirdCiv, attacker.getCivName(), unitsToKill, location);
        }
    }

    private final void notifyAskForAssistance(Civilization assignee, String attackerName, int unitsToKill, Vector2 location) {
        if (Intrinsics.areEqual(attackerName, assignee.getCivName())) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append('[');
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        String message2 = stringBuilder.append(civilization.getCivName()).append("] is being attacked by [").append(attackerName).append("]! Kill [").append(unitsToKill).append("] of the attacker's military units and they will be immensely grateful.").toString();
        Object[] objectArray = new Vector2[]{location};
        Sequence<LocationAction> sequence = LocationAction.Companion.invoke((Vector2[])objectArray);
        objectArray = new String[2];
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        objectArray[0] = civilization2.getCivName();
        objectArray[1] = "OtherIcons/Quest";
        assignee.addNotification(message2, sequence, Notification.NotificationCategory.Diplomacy, (String[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void militaryUnitKilledBy(@NotNull Civilization killer2, @NotNull Civilization killed) {
        HashMap unitsKilledFromCivEntry;
        Integer n;
        Object object;
        void $this$getOrPut$iv;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter(killer2, "killer");
                Intrinsics.checkNotNullParameter(killed, "killed");
                if (!this.warWithMajorActive(killed)) {
                    return;
                }
                Civilization civilization = this.civ;
                if (civilization == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization = null;
                }
                if (!civilization.knows(killer2)) break block14;
                Civilization civilization2 = this.civ;
                if (civilization2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization2 = null;
                }
                if (!civilization2.isAtWarWith(killer2)) break block15;
            }
            return;
        }
        Map map2 = this.unitsKilledFromCiv;
        String key$iv = killed.getCivName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((n = (Integer)(unitsKilledFromCivEntry = (HashMap)object).get(killer2.getCivName())) == null) {
            n = 0;
        }
        int updatedKillCount = 1 + ((Number)n).intValue();
        Integer n2 = updatedKillCount;
        ((Map)unitsKilledFromCivEntry).put(killer2.getCivName(), n2);
        Integer n3 = this.unitsToKillForCiv.get(killed.getCivName());
        Intrinsics.checkNotNull(n3);
        if (updatedKillCount >= ((Number)n3).intValue()) {
            StringBuilder stringBuilder = new StringBuilder().append('[');
            Civilization civilization = this.civ;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            String string = stringBuilder.append(civilization.getCivName()).append("] is deeply grateful for your assistance in the war against [").append(killed.getCivName()).append("]!").toString();
            Civilization civilization3 = this.civ;
            if (civilization3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization3 = null;
            }
            NotificationAction notificationAction = new DiplomacyAction(civilization3.getCivName(), false, 2, null);
            String[] stringArray = new String[2];
            Civilization civilization4 = this.civ;
            if (civilization4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization4 = null;
            }
            stringArray[0] = civilization4.getCivName();
            stringArray[1] = "OtherIcons/Quest";
            killer2.addNotification(string, notificationAction, Notification.NotificationCategory.Diplomacy, stringArray);
            Civilization civilization5 = this.civ;
            if (civilization5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization5 = null;
            }
            DiplomacyManager diplomacyManager = civilization5.getDiplomacyManager(killer2);
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.addInfluence(100.0f);
            this.endWarWithMajorQuest(killed);
        }
    }

    public final void justMet(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (this.unitsToKillForCiv.isEmpty()) {
            return;
        }
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        City city2 = civilization.getCapital(true);
        Vector2 location = city2 != null ? city2.getLocation() : null;
        for (Map.Entry entry : ((Map)this.unitsToKillForCiv).entrySet()) {
            String attackerName = (String)entry.getKey();
            int unitsToKill = ((Number)entry.getValue()).intValue();
            this.notifyAskForAssistance(otherCiv, attackerName, unitsToKill, location);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void tryEndWarWithMajorQuests() {
        void $this$mapTo$iv$iv;
        Set<String> set2 = this.unitsToKillForCiv.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        Iterable $this$map$iv = set2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Civilization civilization = this.civ;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            GameInfo gameInfo = civilization.getGameInfo();
            Intrinsics.checkNotNull(it);
            collection.add(gameInfo.getCivilization((String)it));
        }
        for (Civilization attacker : (List)destination$iv$iv) {
            Civilization civilization = this.civ;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            if (!civilization.isDefeated() && !attacker.isDefeated()) {
                Civilization civilization2 = this.civ;
                if (civilization2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization2 = null;
                }
                if (civilization2.isAtWarWith(attacker)) continue;
            }
            this.endWarWithMajorQuest(attacker);
        }
    }

    private final void endWarWithMajorQuest(Civilization attacker) {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Iterator<Civilization> iterator2 = SequencesKt.filterNot(civilization.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(attacker, this){
            final /* synthetic */ Civilization $attacker;
            final /* synthetic */ QuestManager this$0;
            {
                this.$attacker = $attacker;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, "it");
                if (!it.isDefeated() && !Intrinsics.areEqual(it, this.$attacker)) {
                    Civilization civilization = QuestManager.access$getCiv$p(this.this$0);
                    if (civilization == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        civilization = null;
                    }
                    if (!it.isAtWarWith(civilization)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        }).iterator();
        while (iterator2.hasNext()) {
            Civilization thirdCiv = iterator2.next();
            if (this.unitsKilledSoFar(attacker, thirdCiv) >= this.unitsToKill(attacker)) continue;
            StringBuilder stringBuilder = new StringBuilder().append('[');
            Civilization civilization2 = this.civ;
            if (civilization2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization2 = null;
            }
            String string = stringBuilder.append(civilization2.getCivName()).append("] no longer needs your assistance against [").append(attacker.getCivName()).append("].").toString();
            Civilization civilization3 = this.civ;
            if (civilization3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization3 = null;
            }
            NotificationAction notificationAction = new DiplomacyAction(civilization3.getCivName(), false, 2, null);
            String[] stringArray = new String[2];
            Civilization civilization4 = this.civ;
            if (civilization4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization4 = null;
            }
            stringArray[0] = civilization4.getCivName();
            stringArray[1] = "OtherIcons/Quest";
            thirdCiv.addNotification(string, notificationAction, Notification.NotificationCategory.Diplomacy, stringArray);
        }
        this.unitsToKillForCiv.remove(attacker.getCivName());
        this.unitsKilledFromCiv.remove(attacker.getCivName());
    }

    public final boolean warWithMajorActive(@NotNull Civilization target) {
        Intrinsics.checkNotNullParameter(target, "target");
        return this.unitsToKillForCiv.containsKey(target.getCivName());
    }

    public final int unitsToKill(@NotNull Civilization target) {
        Intrinsics.checkNotNullParameter(target, "target");
        Integer n = this.unitsToKillForCiv.get(target.getCivName());
        return n == null ? 0 : n;
    }

    public final int unitsKilledSoFar(@NotNull Civilization target, @NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        HashMap<String, Integer> hashMap = this.unitsKilledFromCiv.get(target.getCivName());
        if (hashMap == null) {
            return 0;
        }
        HashMap<String, Integer> killMap = hashMap;
        Integer n = killMap.get(viewingCiv.getCivName());
        return n == null ? 0 : n;
    }

    public final void receivedGoldGift(@NotNull Civilization donorCiv) {
        Intrinsics.checkNotNullParameter(donorCiv, "donorCiv");
        Sequence<AssignedQuest> matchingQuests2 = SequencesKt.filter(this.getAssignedQuestsOfName(QuestName.GiveGold), (Function1)new Function1<AssignedQuest, Boolean>(donorCiv){
            final /* synthetic */ Civilization $donorCiv;
            {
                this.$donorCiv = $donorCiv;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull AssignedQuest it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getAssignee(), this.$donorCiv.getCivName());
            }
        });
        Iterator<AssignedQuest> iterator2 = matchingQuests2.iterator();
        while (iterator2.hasNext()) {
            AssignedQuest quest2 = iterator2.next();
            this.giveReward(quest2);
        }
        CollectionsKt.removeAll((Collection)this.assignedQuests, matchingQuests2);
    }

    private final float getQuestWeight(String questName) {
        Float traitWeight;
        Float personalityWeight;
        float weight = 1.0f;
        Quest quest2 = this.getRuleset().getQuests().get(questName);
        if (quest2 == null) {
            return 0.0f;
        }
        Quest quest3 = quest2;
        HashMap<String, Float> hashMap = quest3.getWeightForCityStateType();
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if ((personalityWeight = hashMap.get(civilization.getCityStatePersonality().name())) != null) {
            weight *= personalityWeight.floatValue();
        }
        HashMap<String, Float> hashMap2 = quest3.getWeightForCityStateType();
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        if ((traitWeight = hashMap2.get(civilization2.getCityStateType().getName())) != null) {
            weight *= traitWeight.floatValue();
        }
        return weight;
    }

    private final Tile getBarbarianEncampmentForQuest() {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        City city2 = Civilization.getCapital$default(civilization, false, 1, null);
        Intrinsics.checkNotNull(city2);
        List<Tile> encampments2 = SequencesKt.toList(SequencesKt.filter(city2.getCenterTile().getTilesInDistance(8), getBarbarianEncampmentForQuest.encampments.1.INSTANCE));
        return (Tile)CollectionsKt.randomOrNull((Collection)encampments2, Random.Default);
    }

    /*
     * WARNING - void declaration
     */
    private final TileResource getResourceForQuest(Civilization challenger) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Iterable $this$map$iv = civilization.getDetailedCivResources();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ResourceSupplyList.ResourceSupply resourceSupply = (ResourceSupplyList.ResourceSupply)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getResource());
        }
        List ownedByCityStateResources = (List)destination$iv$iv;
        Iterable $this$map$iv2 = challenger.getDetailedCivResources();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceSupplyList.ResourceSupply bl = (ResourceSupplyList.ResourceSupply)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getResource());
        }
        List ownedByMajorResources = (List)destination$iv$iv2;
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        Sequence resourcesOnMap2 = SequencesKt.distinct(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)civilization2.getGameInfo().getTileMap().getValues()), getResourceForQuest.resourcesOnMap.1.INSTANCE));
        Sequence viewableResourcesForChallenger2 = SequencesKt.filter(SequencesKt.map(resourcesOnMap2, (Function1)new Function1<String, TileResource>(this){
            final /* synthetic */ QuestManager this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final TileResource invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                TileResource tileResource = QuestManager.access$getRuleset(this.this$0).getTileResources().get(it);
                Intrinsics.checkNotNull(tileResource);
                return tileResource;
            }
        }), (Function1)new Function1<TileResource, Boolean>(challenger){
            final /* synthetic */ Civilization $challenger;
            {
                this.$challenger = $challenger;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TileResource it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$challenger.getTech().isRevealed(it);
            }
        });
        List notOwnedResources2 = SequencesKt.toList(SequencesKt.filter(viewableResourcesForChallenger2, (Function1)new Function1<TileResource, Boolean>((List<TileResource>)ownedByCityStateResources, (List<TileResource>)ownedByMajorResources){
            final /* synthetic */ List<TileResource> $ownedByCityStateResources;
            final /* synthetic */ List<TileResource> $ownedByMajorResources;
            {
                this.$ownedByCityStateResources = $ownedByCityStateResources;
                this.$ownedByMajorResources = $ownedByMajorResources;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TileResource it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getResourceType() != ResourceType.Bonus && !this.$ownedByCityStateResources.contains(it) && !this.$ownedByMajorResources.contains(it);
            }
        }));
        return (TileResource)CollectionsKt.randomOrNull(notOwnedResources2, Random.Default);
    }

    /*
     * Unable to fully structure code
     */
    private final Building getWonderToBuildForQuest(Civilization challenger) {
        v0 = this.getRuleset().getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var5_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block6: {
                building = (Building)element$iv$iv;
                $i$a$-filter-QuestManager$getWonderToBuildForQuest$wonders$1 = false;
                if (!building.isWonder()) ** GOTO lbl-1000
                v1 = challenger.getTech();
                Intrinsics.checkNotNull(building);
                if (!v1.isResearched(building)) ** GOTO lbl-1000
                v2 = this.civ;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    v2 = null;
                }
                if (building.isUnavailableBySettings(v2.getGameInfo()) || building.getUniqueTo() != null) ** GOTO lbl-1000
                v3 = this.civ;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    v3 = null;
                }
                $this$none$iv = v3.getGameInfo().getCities();
                $i$f$none = false;
                var14_13 = $this$none$iv.iterator();
                while (var14_13.hasNext()) {
                    it = element$iv = var14_13.next();
                    $i$a$-none-QuestManager$getWonderToBuildForQuest$wonders$1$1 = false;
                    if (!(it.getCityConstructions().isBuilt(building.getName()) != false || QuestManager.getWonderToBuildForQuest$isMoreThanAQuarterDone(it, building.getName()) != false)) continue;
                    v4 = false;
                    break block6;
                }
                v4 = true;
            }
            if (v4) {
                v5 = true;
            } else lbl-1000:
            // 4 sources

            {
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        wonders = (List)destination$iv$iv;
        return (Building)CollectionsKt.randomOrNull(wonders, Random.Default);
    }

    private final String getNaturalWonderToFindForQuest(Civilization challenger) {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Set naturalWondersToFind = CollectionsKt.subtract((Iterable)civilization.getGameInfo().getTileMap().getNaturalWonders(), (Iterable)challenger.getNaturalWonders());
        return (String)CollectionsKt.randomOrNull(naturalWondersToFind, Random.Default);
    }

    /*
     * Unable to fully structure code
     */
    private final BaseUnit getGreatPersonForQuest(Civilization challenger) {
        ruleset = this.getRuleset();
        v0 = challenger.getUnits().getCivGreatPeople();
        v1 = this.civ;
        if (v1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            v1 = null;
        }
        existingGreatPeople = SequencesKt.toSet(SequencesKt.map(SequencesKt.plus(v0, v1.getUnits().getCivGreatPeople()), (Function1)new Function1<MapUnit, BaseUnit>(ruleset){
            final /* synthetic */ Ruleset $ruleset;
            {
                this.$ruleset = $ruleset;
                super(1);
            }

            @NotNull
            public final BaseUnit invoke(@NotNull MapUnit it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getBaseUnit().getReplacedUnit(this.$ruleset);
            }
        }));
        var5_4 = challenger.getGreatPeople().getGreatPeople();
        $i$f$map = false;
        var7_6 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var12_11 = (BaseUnit)item$iv$iv;
            var14_13 = destination$iv$iv;
            $i$a$-map-QuestManager$getGreatPersonForQuest$greatPeople$1 = false;
            var14_13.add(it.getReplacedUnit(ruleset));
        }
        $this$map$iv = CollectionsKt.distinct((List)destination$iv$iv);
        $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (BaseUnit)element$iv$iv;
            $i$a$-filterNot-QuestManager$getGreatPersonForQuest$greatPeople$2 = false;
            if (existingGreatPeople.contains(it)) ** GOTO lbl-1000
            v2 = this.civ;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                v2 = null;
            }
            if (it.isUnavailableBySettings(v2.getGameInfo())) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            if (v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        greatPeople = CollectionsKt.toList((List)destination$iv$iv);
        return (BaseUnit)CollectionsKt.randomOrNull((Collection)greatPeople, Random.Default);
    }

    private final Civilization getCivilizationToFindForQuest(Civilization challenger) {
        List<Civilization> civilizationsToFind2 = SequencesKt.toList(SequencesKt.filter(challenger.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(challenger){
            final /* synthetic */ Civilization $challenger;
            {
                this.$challenger = $challenger;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isAlive() && it.isMajorCiv() && !this.$challenger.hasMetCivTerritory(it);
            }
        }));
        return (Civilization)CollectionsKt.randomOrNull((Collection)civilizationsToFind2, Random.Default);
    }

    /*
     * WARNING - void declaration
     */
    private final Civilization getCityStateTarget(Civilization challenger) {
        Object v2;
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Iterable $this$mapNotNull$iv = civilization.getGameInfo().getAliveCityStates();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Proximity it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Civilization it = (Civilization)element$iv$iv;
            boolean bl2 = false;
            Civilization civilization2 = this.civ;
            if (civilization2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization2 = null;
            }
            if (civilization2.getProximity().get(it.getCivName()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Proximity it = (Proximity)element$iv$iv;
            boolean bl = false;
            if (!(it != Proximity.None)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = minElem$iv;
            } else {
                Proximity it = (Proximity)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.ordinal();
                do {
                    Object e$iv = iterator$iv.next();
                    Proximity it2 = (Proximity)e$iv;
                    $i$a$-minByOrNull-QuestManager$getCityStateTarget$closestProximity$3 = false;
                    int v$iv = it2.ordinal();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = minElem$iv;
            }
        }
        Proximity closestProximity = v2;
        if (closestProximity == null || closestProximity == Proximity.Distant) {
            return null;
        }
        Civilization civilization3 = this.civ;
        if (civilization3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization3 = null;
        }
        Sequence<Civilization> validTargets2 = SequencesKt.filter(civilization3.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(challenger, this, closestProximity){
            final /* synthetic */ Civilization $challenger;
            final /* synthetic */ QuestManager this$0;
            final /* synthetic */ Proximity $closestProximity;
            {
                this.$challenger = $challenger;
                this.this$0 = $receiver;
                this.$closestProximity = $closestProximity;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, "it");
                if (it.isCityState() && this.$challenger.knows(it)) {
                    Civilization civilization = QuestManager.access$getCiv$p(this.this$0);
                    if (civilization == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        civilization = null;
                    }
                    if (civilization.getProximity().get(it.getCivName()) == this.$closestProximity) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        });
        return (Civilization)CollectionsKt.randomOrNull((Collection)SequencesKt.toList(validTargets2), Random.Default);
    }

    /*
     * WARNING - void declaration
     */
    private final String getMostRecentBully() {
        Object v2;
        void $this$filterTo$iv$iv;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Collection<DiplomacyManager> collection = civilization.getDiplomacy().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DiplomacyManager it = (DiplomacyManager)element$iv$iv;
            boolean bl = false;
            if (!it.hasFlag(DiplomacyFlags.Bullied)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List bullies = (List)destination$iv$iv;
        Iterable $this$maxByOrNull$iv = bullies;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                DiplomacyManager it = (DiplomacyManager)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getFlag(DiplomacyFlags.Bullied);
                do {
                    Object e$iv = iterator$iv.next();
                    DiplomacyManager it2 = (DiplomacyManager)e$iv;
                    $i$a$-maxByOrNull-QuestManager$getMostRecentBully$1 = false;
                    int v$iv = it2.getFlag(DiplomacyFlags.Bullied);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        DiplomacyManager diplomacyManager = v2;
        return diplomacyManager != null ? diplomacyManager.getOtherCivName() : null;
    }

    private static final boolean tryStartNewGlobalQuest$isAssignable(Quest $this$tryStartNewGlobalQuest_u24isAssignable, Sequence<Civilization> majorCivs2, QuestManager this$0) {
        Sequence<Civilization> $this$count$iv = majorCivs2;
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<Civilization> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            Civilization element$iv;
            Civilization civ = element$iv = iterator2.next();
            boolean bl = false;
            if (!this$0.isQuestValid($this$tryStartNewGlobalQuest_u24isAssignable, civ) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return count$iv >= $this$tryStartNewGlobalQuest_u24isAssignable.getMinimumCivs();
    }

    private static final String getScoreStringForGlobalQuest$getScoreString(String scoreDescriptor, String name2, int score) {
        return TranslationsKt.tr$default('[' + name2 + "] with [" + score + "] [" + scoreDescriptor + ']', false, false, 3, null);
    }

    private static final boolean getWonderToBuildForQuest$isMoreThanAQuarterDone(City city2, String buildingName) {
        return city2.getCityConstructions().getWorkDone(buildingName) * 3 > CityConstructions.getRemainingWork$default(city2.getCityConstructions(), buildingName, false, 2, null);
    }

    public static final /* synthetic */ Civilization access$getCiv$p(QuestManager $this) {
        return $this.civ;
    }

    public static final /* synthetic */ boolean access$tryStartNewGlobalQuest$isAssignable(Quest $receiver, Sequence majorCivs2, QuestManager this$0) {
        return QuestManager.tryStartNewGlobalQuest$isAssignable($receiver, majorCivs2, this$0);
    }

    public static final /* synthetic */ float access$getQuestWeight(QuestManager $this, String questName) {
        return $this.getQuestWeight(questName);
    }

    public static final /* synthetic */ boolean access$isQuestValid(QuestManager $this, Quest quest2, Civilization challenger) {
        return $this.isQuestValid(quest2, challenger);
    }

    public static final /* synthetic */ boolean access$canAssignAQuestTo(QuestManager $this, Civilization challenger) {
        return $this.canAssignAQuestTo(challenger);
    }

    public static final /* synthetic */ boolean access$handleIndividualQuest(QuestManager $this, AssignedQuest assignedQuest) {
        return $this.handleIndividualQuest(assignedQuest);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/unciv/logic/civilization/managers/QuestManager$Companion;", "", "()V", "GLOBAL_QUEST_FIRST_POSSIBLE_TURN", "", "GLOBAL_QUEST_FIRST_POSSIBLE_TURN_RAND", "GLOBAL_QUEST_MAX_ACTIVE", "GLOBAL_QUEST_MIN_TURNS_BETWEEN", "GLOBAL_QUEST_RAND_TURNS_BETWEEN", "INDIVIDUAL_QUEST_FIRST_POSSIBLE_TURN", "INDIVIDUAL_QUEST_FIRST_POSSIBLE_TURN_RAND", "INDIVIDUAL_QUEST_MAX_ACTIVE", "INDIVIDUAL_QUEST_MIN_TURNS_BETWEEN", "INDIVIDUAL_QUEST_RAND_TURNS_BETWEEN", "UNSET", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QuestName.values().length];
            try {
                nArray[QuestName.ClearBarbarianCamp.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.ConnectResource.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.ConstructWonder.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.GreatPerson.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.FindPlayer.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.FindNaturalWonder.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.ConquerCityState.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.BullyCityState.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.PledgeToProtect.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.GiveGold.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.DenounceCiv.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.SpreadReligion.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.ContestCulture.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.ContestFaith.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.ContestTech.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.Invest.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.Route.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/unciv/logic/civilization/managers/QuestManager$WinnersAndLosers;", "", "questName", "Lcom/unciv/models/ruleset/QuestName;", "(Lcom/unciv/logic/civilization/managers/QuestManager;Lcom/unciv/models/ruleset/QuestName;)V", "losers", "", "Lcom/unciv/logic/civilization/managers/AssignedQuest;", "getLosers", "()Ljava/util/List;", "<set-?>", "", "maxScore", "getMaxScore", "()I", "winners", "getWinners", "core"})
    public final class WinnersAndLosers {
        @NotNull
        private final List<AssignedQuest> winners;
        @NotNull
        private final List<AssignedQuest> losers;
        private int maxScore;

        public WinnersAndLosers(QuestName questName) {
            Intrinsics.checkNotNullParameter((Object)questName, "questName");
            this.winners = new ArrayList();
            this.losers = new ArrayList();
            this.maxScore = -1;
            Quest quest2 = QuestManager.this.getRuleset().getQuests().get(questName.getValue());
            Intrinsics.checkNotNull(quest2);
            if (!quest2.isGlobal()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Iterator iterator2 = QuestManager.this.getAssignedQuestsOfName(questName).iterator();
            while (iterator2.hasNext()) {
                AssignedQuest quest3 = (AssignedQuest)iterator2.next();
                int qScore = QuestManager.this.getScoreForQuest(quest3);
                if (qScore <= 0) continue;
                if (qScore < this.maxScore) {
                    this.losers.add(quest3);
                    continue;
                }
                if (qScore == this.maxScore) {
                    this.winners.add(quest3);
                    continue;
                }
                this.losers.addAll((Collection<AssignedQuest>)this.winners);
                this.winners.clear();
                this.winners.add(quest3);
                this.maxScore = qScore;
            }
        }

        @NotNull
        public final List<AssignedQuest> getWinners() {
            return this.winners;
        }

        @NotNull
        public final List<AssignedQuest> getLosers() {
            return this.losers;
        }

        public final int getMaxScore() {
            return this.maxScore;
        }
    }
}

