/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.files;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.files.IMediaFinder;
import com.unciv.models.UncivSound;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.ui.popups.options.SettingsSelect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.full.KClasses;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\bf\u0018\u0000 \u00192\u00020\u0001:\u0006\u0019\u001a\u001b\u001c\u001d\u001eJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u000bH\u0002R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001f"}, d2={"Lcom/unciv/logic/files/IMediaFinder;", "", "mediaSubFolderName", "", "getMediaSubFolderName", "()Ljava/lang/String;", "supportedMediaExtensions", "", "getSupportedMediaExtensions", "()Ljava/util/Set;", "findMedia", "Lcom/badlogic/gdx/files/FileHandle;", "name", "getInternalMediaNames", "Lkotlin/sequences/Sequence;", "folder", "getModMediaFolder", "modName", "getRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "listMediaFiles", "listMediaFolders", "listModFolders", "directoryExists", "", "Companion", "Images", "LabeledSounds", "Music", "Sounds", "Voices", "core"})
public interface IMediaFinder {
    @NotNull
    public static final Companion Companion = com.unciv.logic.files.IMediaFinder$Companion.$$INSTANCE;

    @NotNull
    public Set<String> getSupportedMediaExtensions();

    @NotNull
    public String getMediaSubFolderName();

    @Nullable
    public Ruleset getRuleset();

    @NotNull
    public Sequence<String> getInternalMediaNames(@NotNull FileHandle var1);

    @Nullable
    public FileHandle findMedia(@NotNull String var1);

    @NotNull
    public Sequence<FileHandle> listMediaFolders();

    @NotNull
    public Sequence<FileHandle> listMediaFiles();

    @NotNull
    public FileHandle getModMediaFolder(@NotNull String var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/unciv/logic/files/IMediaFinder$Companion;", "", "()V", "isRunFromJar", "", "supportedAudioExtensions", "", "", "supportedImageExtensions", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        private final Set<String> supportedAudioExtensions() {
            String[] stringArray = new String[]{".mp3", ".ogg", ".wav"};
            return SetsKt.setOf(stringArray);
        }

        private final Set<String> supportedImageExtensions() {
            String[] stringArray = new String[]{".png", ".jpg", ".jpeg"};
            return SetsKt.setOf(stringArray);
        }

        private final boolean isRunFromJar() {
            return Gdx.app.getType() == Application.ApplicationType.Desktop && this.getClass().getPackage().getSpecificationVersion() != null;
        }

        public static final /* synthetic */ Set access$supportedAudioExtensions(Companion $this) {
            return $this.supportedAudioExtensions();
        }

        public static final /* synthetic */ Set access$supportedImageExtensions(Companion $this) {
            return $this.supportedImageExtensions();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nIMediaFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IMediaFinder.kt\ncom/unciv/logic/files/IMediaFinder$DefaultImpls\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,265:1\n179#2,2:266\n*S KotlinDebug\n*F\n+ 1 IMediaFinder.kt\ncom/unciv/logic/files/IMediaFinder$DefaultImpls\n*L\n91#1:266,2\n*E\n"})
    public static final class DefaultImpls {
        @Nullable
        public static Ruleset getRuleset(@NotNull IMediaFinder $this) {
            GameInfo gameInfo = UncivGame.Companion.getGameInfoOrNull();
            return gameInfo != null ? gameInfo.getRuleset() : null;
        }

        @NotNull
        public static Sequence<String> getInternalMediaNames(@NotNull IMediaFinder $this, @NotNull FileHandle folder) {
            Intrinsics.checkNotNullParameter(folder, "folder");
            throw new UnsupportedOperationException("Using IMediaFinder.listMediaFiles from a jar requires overriding getInternalMediaNames");
        }

        @Nullable
        public static FileHandle findMedia(@NotNull IMediaFinder $this, @NotNull String name2) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter(name2, "name");
                Sequence $this$firstOrNull$iv = SequencesKt.flatMapIterable($this.listMediaFolders(), (Function1)new Function1<FileHandle, List<? extends FileHandle>>($this, name2){
                    final /* synthetic */ IMediaFinder this$0;
                    final /* synthetic */ String $name;
                    {
                        this.this$0 = $receiver;
                        this.$name = $name;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<FileHandle> invoke(@NotNull FileHandle folder) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Intrinsics.checkNotNullParameter(folder, "folder");
                        Iterable iterable = this.this$0.getSupportedMediaExtensions();
                        String string = this.$name;
                        boolean $i$f$map = false;
                        void var5_5 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string2 = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(folder.child(string + (String)it));
                        }
                        return (List)destination$iv$iv;
                    }
                });
                boolean $i$f$firstOrNull = false;
                Iterator iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    FileHandle it = (FileHandle)element$iv;
                    boolean bl = false;
                    if (!it.exists()) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public static Sequence<FileHandle> listMediaFolders(@NotNull IMediaFinder $this) {
            return SequencesKt.filter(SequencesKt.plus(DefaultImpls.listModFolders($this), Gdx.files.internal($this.getMediaSubFolderName())), (Function1)new Function1<FileHandle, Boolean>($this){
                final /* synthetic */ IMediaFinder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(FileHandle it) {
                    Intrinsics.checkNotNull(it);
                    return DefaultImpls.access$directoryExists(this.this$0, it);
                }
            });
        }

        @NotNull
        public static Sequence<FileHandle> listMediaFiles(@NotNull IMediaFinder $this) {
            return SequencesKt.flatMap($this.listMediaFolders(), (Function1)new Function1<FileHandle, Sequence<? extends FileHandle>>($this){
                final /* synthetic */ IMediaFinder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Sequence<FileHandle> invoke(@NotNull FileHandle folder) {
                    Sequence<Object> sequence;
                    Intrinsics.checkNotNullParameter(folder, "folder");
                    if (folder.type() == Files.FileType.Internal && com.unciv.logic.files.IMediaFinder$Companion.access$isRunFromJar(IMediaFinder.Companion)) {
                        sequence = SequencesKt.filter(SequencesKt.flatMapIterable(this.this$0.getInternalMediaNames(folder), (Function1)new Function1<String, List<? extends FileHandle>>(this.this$0, folder){
                            final /* synthetic */ IMediaFinder this$0;
                            final /* synthetic */ FileHandle $folder;
                            {
                                this.this$0 = $receiver;
                                this.$folder = $folder;
                                super(1);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @NotNull
                            public final List<FileHandle> invoke(@NotNull String name2) {
                                void $this$mapTo$iv$iv;
                                void $this$map$iv;
                                Intrinsics.checkNotNullParameter(name2, "name");
                                Iterable iterable = this.this$0.getSupportedMediaExtensions();
                                FileHandle fileHandle = this.$folder;
                                boolean $i$f$map = false;
                                void var5_5 = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void ext;
                                    String string = (String)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(fileHandle.child(name2 + (String)ext));
                                }
                                return (List)destination$iv$iv;
                            }
                        }), listMediaFiles.2.INSTANCE);
                    } else {
                        FileHandle[] fileHandleArray = folder.list();
                        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
                        sequence = ArraysKt.asSequence((Object[])fileHandleArray);
                    }
                    return sequence;
                }
            });
        }

        @NotNull
        public static FileHandle getModMediaFolder(@NotNull IMediaFinder $this, @NotNull String modName) {
            Intrinsics.checkNotNullParameter(modName, "modName");
            FileHandle fileHandle = UncivGame.Companion.getCurrent().getFiles().getModFolder(modName).child($this.getMediaSubFolderName());
            Intrinsics.checkNotNullExpressionValue(fileHandle, "child(...)");
            return fileHandle;
        }

        private static boolean directoryExists(IMediaFinder $this, FileHandle $receiver) {
            return $receiver.type() != Files.FileType.Internal ? $receiver.exists() && $receiver.isDirectory() : (Gdx.app.getType() == Application.ApplicationType.Android ? $receiver.isDirectory() : (Companion.isRunFromJar() ? $receiver.exists() : $receiver.exists() && $receiver.isDirectory()));
        }

        private static Sequence<FileHandle> listModFolders(IMediaFinder $this) {
            return SequencesKt.map(SequencesKt.sequence((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>($this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ IMediaFinder this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    void $result;
                    SequenceScope $this$sequence;
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            $this$sequence = (SequenceScope)this.L$0;
                            Ruleset ruleset2 = this.this$0.getRuleset();
                            if (ruleset2 == null) break;
                            Ruleset $this$invokeSuspend_u24lambda_u240 = ruleset2;
                            boolean bl = false;
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            Object object3 = $this$sequence.yieldAll((Iterable)$this$invokeSuspend_u24lambda_u240.getMods(), (Continuation<Unit>)this);
                            if (object3 == object2) {
                                return object2;
                            }
                            break;
                        }
                        case 1: {
                            boolean bl = false;
                            $this$sequence = (SequenceScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            break;
                        }
                    }
                    if (!UncivGame.Companion.isCurrentInitialized()) return Unit.INSTANCE;
                    this.L$0 = null;
                    this.label = 2;
                    Object object4 = $this$sequence.yieldAll((Iterable)UncivGame.Companion.getCurrent().getSettings().getVisualMods(), (Continuation<Unit>)this);
                    if (object4 != object2) return Unit.INSTANCE;
                    return object2;
                    {
                        case 2: {
                            ResultKt.throwOnFailure($result);
                            object4 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                @Nullable
                public final Object invoke(@NotNull SequenceScope<? super String> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (Function1)new Function1<String, FileHandle>($this){
                final /* synthetic */ IMediaFinder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final FileHandle invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.this$0.getModMediaFolder(it);
                }
            });
        }

        public static final /* synthetic */ boolean access$directoryExists(IMediaFinder $this, FileHandle $receiver) {
            return DefaultImpls.directoryExists($this, $receiver);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/files/IMediaFinder$Images;", "Lcom/unciv/logic/files/IMediaFinder;", "()V", "mediaSubFolderName", "", "getMediaSubFolderName", "()Ljava/lang/String;", "supportedMediaExtensions", "", "getSupportedMediaExtensions", "()Ljava/util/Set;", "core"})
    public static class Images
    implements IMediaFinder {
        @NotNull
        private final String mediaSubFolderName;
        @NotNull
        private final Set<String> supportedMediaExtensions = com.unciv.logic.files.IMediaFinder$Companion.access$supportedImageExtensions(Companion);

        public Images() {
            this.mediaSubFolderName = "ExtraImages";
        }

        @Override
        @NotNull
        public String getMediaSubFolderName() {
            return this.mediaSubFolderName;
        }

        @Override
        @NotNull
        public Set<String> getSupportedMediaExtensions() {
            return this.supportedMediaExtensions;
        }

        @Override
        @Nullable
        public Ruleset getRuleset() {
            return DefaultImpls.getRuleset(this);
        }

        @Override
        @NotNull
        public Sequence<String> getInternalMediaNames(@NotNull FileHandle folder) {
            return DefaultImpls.getInternalMediaNames(this, folder);
        }

        @Override
        @Nullable
        public FileHandle findMedia(@NotNull String name2) {
            return DefaultImpls.findMedia(this, name2);
        }

        @Override
        @NotNull
        public Sequence<FileHandle> listMediaFolders() {
            return DefaultImpls.listMediaFolders(this);
        }

        @Override
        @NotNull
        public Sequence<FileHandle> listMediaFiles() {
            return DefaultImpls.listMediaFiles(this);
        }

        @Override
        @NotNull
        public FileHandle getModMediaFolder(@NotNull String modName) {
            return DefaultImpls.getModMediaFolder(this, modName);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\u0007H\u0002J\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/unciv/logic/files/IMediaFinder$LabeledSounds;", "Lcom/unciv/logic/files/IMediaFinder$Sounds;", "()V", "cache", "", "", "cacheBuiltins", "", "cacheMods", "fillCache", "getLabeledSounds", "", "Lcom/unciv/ui/popups/options/SettingsSelect$SelectItem;", "Lcom/unciv/models/UncivSound;", "listMediaFolders", "Lkotlin/sequences/Sequence;", "Lcom/badlogic/gdx/files/FileHandle;", "Companion", "core"})
    @SourceDebugExtension(value={"SMAP\nIMediaFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IMediaFinder.kt\ncom/unciv/logic/files/IMediaFinder$LabeledSounds\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,265:1\n1#2:266\n*E\n"})
    public static class LabeledSounds
    extends Sounds {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final Map<String, String> cache = new LinkedHashMap();
        @NotNull
        private static final Map<String, String> prettifyUncivSoundNames;
        @NotNull
        private static final Set<String> exclusions;

        @NotNull
        public final Iterable<SettingsSelect.SelectItem<UncivSound>> getLabeledSounds() {
            this.fillCache();
            return SequencesKt.asIterable(SequencesKt.map(MapsKt.asSequence(this.cache), getLabeledSounds.1.INSTANCE));
        }

        @Override
        @NotNull
        public Sequence<FileHandle> listMediaFolders() {
            throw new UnsupportedOperationException("LabeledSounds does not support the normal IMediaFinder API");
        }

        private final void fillCache() {
            if (!this.cache.isEmpty()) {
                return;
            }
            this.cacheBuiltins();
            this.cacheMods();
            for (String sound : exclusions) {
                this.cache.remove(sound);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void cacheBuiltins() {
            this.cache.putAll(prettifyUncivSoundNames);
            Iterator<Object> iterator2 = Sounds.Companion.uncivSoundNames().iterator();
            while (iterator2.hasNext()) {
                String string;
                String sound = iterator2.next();
                if (this.cache.containsKey(sound)) continue;
                Map<String, String> map2 = this.cache;
                String string2 = sound;
                if (((CharSequence)string2).length() > 0) {
                    void p0;
                    char c = string2.charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.titlecase((char)p0));
                    String string3 = string2;
                    int n = 1;
                    String string4 = string3.substring(n);
                    Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                    string = stringBuilder2.append(string4).toString();
                } else {
                    string = string2;
                }
                string2 = string;
                map2.put(sound, string2);
            }
            iterator2 = Sounds.Companion.unitAttackSounds().iterator();
            while (iterator2.hasNext()) {
                Pair pair = (Pair)iterator2.next();
                BaseUnit unit = (BaseUnit)pair.component1();
                String sound = (String)pair.component2();
                this.cache.put(sound, '[' + unit.getName() + "] Attack Sound");
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void cacheMods() {
            if (!UncivGame.Companion.isCurrentInitialized()) {
                return;
            }
            Iterator<FileHandle> iterator2 = super.listMediaFolders().iterator();
            while (iterator2.hasNext()) {
                FileHandle[] fileHandleArray;
                FileHandle folder = iterator2.next();
                if (folder.type() == Files.FileType.Internal) continue;
                String mod = folder.parent().name();
                Ruleset ruleset2 = (Ruleset)RulesetCache.INSTANCE.get((Object)mod);
                if (ruleset2 != null) {
                    fileHandleArray = ruleset2.getUnits().values().iterator();
                    while (fileHandleArray.hasNext()) {
                        String sound;
                        BaseUnit unit = (BaseUnit)fileHandleArray.next();
                        if (unit.getAttackSound() == null || this.cache.containsKey(sound)) continue;
                        StringBuilder stringBuilder = new StringBuilder();
                        Intrinsics.checkNotNull(mod);
                        this.cache.put(sound, stringBuilder.append(StringsKt.take(mod, 32)).append(": {[").append(unit.getName()).append("] Attack Sound}").toString());
                    }
                }
                Intrinsics.checkNotNullExpressionValue(folder.list(), "list(...)");
                for (FileHandle file : fileHandleArray) {
                    String string;
                    String sound = file.nameWithoutExtension();
                    if (this.cache.containsKey(sound)) continue;
                    Map<String, String> map2 = this.cache;
                    Intrinsics.checkNotNull(sound);
                    String string2 = sound;
                    StringBuilder stringBuilder = new StringBuilder();
                    Intrinsics.checkNotNull(mod);
                    StringBuilder stringBuilder2 = stringBuilder.append(StringsKt.take(mod, 32)).append(": ");
                    String string3 = sound;
                    if (((CharSequence)string3).length() > 0) {
                        void p0;
                        char c = string3.charAt(0);
                        StringBuilder stringBuilder3 = new StringBuilder();
                        StringBuilder stringBuilder4 = stringBuilder2;
                        boolean bl = false;
                        String string4 = CharsKt.titlecase((char)p0);
                        stringBuilder2 = stringBuilder4;
                        StringBuilder stringBuilder5 = stringBuilder3.append((Object)string4);
                        String string5 = string3;
                        int n = 1;
                        String string6 = string5.substring(n);
                        Intrinsics.checkNotNullExpressionValue(string6, "substring(...)");
                        string = stringBuilder5.append(string6).toString();
                    } else {
                        string = string3;
                    }
                    string3 = stringBuilder2.append(string).append(" {}").toString();
                    map2.put(string2, string3);
                }
            }
        }

        static {
            Object[] objectArray = new Pair[]{TuplesKt.to("", "None"), TuplesKt.to("notification1", "Notification [1]"), TuplesKt.to("notification2", "Notification [2]"), TuplesKt.to("coin", "Buy"), TuplesKt.to("construction", "Create"), TuplesKt.to("paper", "Pick a tech"), TuplesKt.to("policy", "Adopt policy"), TuplesKt.to("setup", "Set up"), TuplesKt.to("swap", "Swap units")};
            prettifyUncivSoundNames = MapsKt.mapOf(objectArray);
            objectArray = new String[]{"nuke", "fire", "slider"};
            exclusions = SetsKt.setOf(objectArray);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/unciv/logic/files/IMediaFinder$LabeledSounds$Companion;", "", "()V", "exclusions", "", "", "getExclusions", "()Ljava/util/Set;", "prettifyUncivSoundNames", "", "getPrettifyUncivSoundNames", "()Ljava/util/Map;", "core"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Map<String, String> getPrettifyUncivSoundNames() {
                return prettifyUncivSoundNames;
            }

            @NotNull
            public final Set<String> getExclusions() {
                return exclusions;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/unciv/logic/files/IMediaFinder$Music;", "Lcom/unciv/logic/files/IMediaFinder;", "()V", "mediaSubFolderName", "", "getMediaSubFolderName", "()Ljava/lang/String;", "names", "Lkotlin/sequences/Sequence;", "getNames", "()Lkotlin/sequences/Sequence;", "supportedMediaExtensions", "", "getSupportedMediaExtensions", "()Ljava/util/Set;", "getInternalMediaNames", "folder", "Lcom/badlogic/gdx/files/FileHandle;", "core"})
    public static class Music
    implements IMediaFinder {
        @NotNull
        private final String mediaSubFolderName;
        @NotNull
        private final Set<String> supportedMediaExtensions = com.unciv.logic.files.IMediaFinder$Companion.access$supportedAudioExtensions(Companion);
        @NotNull
        private final Sequence<String> names;

        public Music() {
            this.mediaSubFolderName = "music";
            String[] stringArray = new String[]{"Thatched Villagers - Ambient"};
            this.names = SequencesKt.sequenceOf(stringArray);
        }

        @Override
        @NotNull
        public String getMediaSubFolderName() {
            return this.mediaSubFolderName;
        }

        @Override
        @NotNull
        public Set<String> getSupportedMediaExtensions() {
            return this.supportedMediaExtensions;
        }

        @NotNull
        public final Sequence<String> getNames() {
            return this.names;
        }

        @Override
        @NotNull
        public Sequence<String> getInternalMediaNames(@NotNull FileHandle folder) {
            Intrinsics.checkNotNullParameter(folder, "folder");
            return this.names;
        }

        @Override
        @Nullable
        public Ruleset getRuleset() {
            return DefaultImpls.getRuleset(this);
        }

        @Override
        @Nullable
        public FileHandle findMedia(@NotNull String name2) {
            return DefaultImpls.findMedia(this, name2);
        }

        @Override
        @NotNull
        public Sequence<FileHandle> listMediaFolders() {
            return DefaultImpls.listMediaFolders(this);
        }

        @Override
        @NotNull
        public Sequence<FileHandle> listMediaFiles() {
            return DefaultImpls.listMediaFiles(this);
        }

        @Override
        @NotNull
        public FileHandle getModMediaFolder(@NotNull String modName) {
            return DefaultImpls.getModMediaFolder(this, modName);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/unciv/logic/files/IMediaFinder$Sounds;", "Lcom/unciv/logic/files/IMediaFinder;", "()V", "mediaSubFolderName", "", "getMediaSubFolderName", "()Ljava/lang/String;", "supportedMediaExtensions", "", "getSupportedMediaExtensions", "()Ljava/util/Set;", "uncivSoundNames", "", "getUncivSoundNames", "()Ljava/util/List;", "uncivSoundNames$delegate", "Lkotlin/Lazy;", "unitAttackSounds", "getUnitAttackSounds", "unitAttackSounds$delegate", "getInternalMediaNames", "Lkotlin/sequences/Sequence;", "folder", "Lcom/badlogic/gdx/files/FileHandle;", "Companion", "core"})
    public static class Sounds
    implements IMediaFinder {
        @NotNull
        protected static final Companion Companion = new Companion(null);
        @NotNull
        private final String mediaSubFolderName;
        @NotNull
        private final Set<String> supportedMediaExtensions = com.unciv.logic.files.IMediaFinder$Companion.access$supportedAudioExtensions(Companion);
        @NotNull
        private final Lazy uncivSoundNames$delegate = LazyKt.lazy(uncivSoundNames.2.INSTANCE);
        @NotNull
        private final Lazy unitAttackSounds$delegate = LazyKt.lazy(unitAttackSounds.2.INSTANCE);

        public Sounds() {
            this.mediaSubFolderName = "sounds";
        }

        @Override
        @NotNull
        public String getMediaSubFolderName() {
            return this.mediaSubFolderName;
        }

        @Override
        @NotNull
        public Set<String> getSupportedMediaExtensions() {
            return this.supportedMediaExtensions;
        }

        private final List<String> getUncivSoundNames() {
            Lazy lazy = this.uncivSoundNames$delegate;
            return (List)lazy.getValue();
        }

        private final List<String> getUnitAttackSounds() {
            Lazy lazy = this.unitAttackSounds$delegate;
            return (List)lazy.getValue();
        }

        @Override
        @NotNull
        public Sequence<String> getInternalMediaNames(@NotNull FileHandle folder) {
            Intrinsics.checkNotNullParameter(folder, "folder");
            return SequencesKt.plus(CollectionsKt.asSequence((Iterable)this.getUncivSoundNames()), (Iterable)this.getUnitAttackSounds());
        }

        @Override
        @Nullable
        public Ruleset getRuleset() {
            return DefaultImpls.getRuleset(this);
        }

        @Override
        @Nullable
        public FileHandle findMedia(@NotNull String name2) {
            return DefaultImpls.findMedia(this, name2);
        }

        @Override
        @NotNull
        public Sequence<FileHandle> listMediaFolders() {
            return DefaultImpls.listMediaFolders(this);
        }

        @Override
        @NotNull
        public Sequence<FileHandle> listMediaFiles() {
            return DefaultImpls.listMediaFiles(this);
        }

        @Override
        @NotNull
        public FileHandle getModMediaFolder(@NotNull String modName) {
            return DefaultImpls.getModMediaFolder(this, modName);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0084\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u00070\u0004\u00a8\u0006\t"}, d2={"Lcom/unciv/logic/files/IMediaFinder$Sounds$Companion;", "", "()V", "uncivSoundNames", "Lkotlin/sequences/Sequence;", "", "unitAttackSounds", "Lkotlin/Pair;", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "core"})
        protected static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Sequence<String> uncivSoundNames() {
                return SequencesKt.map(CollectionsKt.asSequence(KClasses.getDeclaredMemberProperties(Reflection.getOrCreateKotlinClass(UncivSound.Companion.class))), uncivSoundNames.1.INSTANCE);
            }

            @NotNull
            public final Sequence<Pair<BaseUnit, String>> unitAttackSounds() {
                Ruleset ruleset2 = (Ruleset)RulesetCache.INSTANCE.get((Object)BaseRuleset.Civ_V_GnK.getFullName());
                if (ruleset2 == null) {
                    return SequencesKt.emptySequence();
                }
                Ruleset ruleset3 = ruleset2;
                Collection<BaseUnit> collection = ruleset3.getUnits().values();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                return SequencesKt.map(SequencesKt.distinctBy(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), unitAttackSounds.1.INSTANCE), unitAttackSounds.2.INSTANCE), unitAttackSounds.3.INSTANCE);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/files/IMediaFinder$Voices;", "Lcom/unciv/logic/files/IMediaFinder;", "()V", "mediaSubFolderName", "", "getMediaSubFolderName", "()Ljava/lang/String;", "supportedMediaExtensions", "", "getSupportedMediaExtensions", "()Ljava/util/Set;", "core"})
    public static class Voices
    implements IMediaFinder {
        @NotNull
        private final String mediaSubFolderName;
        @NotNull
        private final Set<String> supportedMediaExtensions = com.unciv.logic.files.IMediaFinder$Companion.access$supportedAudioExtensions(Companion);

        public Voices() {
            this.mediaSubFolderName = "voices";
        }

        @Override
        @NotNull
        public String getMediaSubFolderName() {
            return this.mediaSubFolderName;
        }

        @Override
        @NotNull
        public Set<String> getSupportedMediaExtensions() {
            return this.supportedMediaExtensions;
        }

        @Override
        @Nullable
        public Ruleset getRuleset() {
            return DefaultImpls.getRuleset(this);
        }

        @Override
        @NotNull
        public Sequence<String> getInternalMediaNames(@NotNull FileHandle folder) {
            return DefaultImpls.getInternalMediaNames(this, folder);
        }

        @Override
        @Nullable
        public FileHandle findMedia(@NotNull String name2) {
            return DefaultImpls.findMedia(this, name2);
        }

        @Override
        @NotNull
        public Sequence<FileHandle> listMediaFolders() {
            return DefaultImpls.listMediaFolders(this);
        }

        @Override
        @NotNull
        public Sequence<FileHandle> listMediaFiles() {
            return DefaultImpls.listMediaFiles(this);
        }

        @Override
        @NotNull
        public FileHandle getModMediaFolder(@NotNull String modName) {
            return DefaultImpls.getModMediaFolder(this, modName);
        }
    }
}

