/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.github;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Json;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.BackwardCompatibility;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.github.Github;
import com.unciv.logic.github.GithubAPI;
import com.unciv.logic.github.RateLimit;
import com.unciv.logic.github.Zip;
import com.unciv.models.ruleset.ModOptions;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.io.ByteStreamsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003>?@B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J&\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016J0\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\u0016\b\u0002\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0016J\u000e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001aH\u0002J\u001a\u0010#\u001a\u00020\u00042\b\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0004H\u0002J$\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00040*2\u0006\u0010\"\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0016\u0010+\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u001aJ\"\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000e2\b\b\u0002\u00101\u001a\u00020\u0004J\b\u00102\u001a\u0004\u0018\u000103J\"\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u00042\b\u00108\u001a\u0004\u0018\u00010\u0004J\n\u00109\u001a\u00020\u0004*\u00020\u0004J\u0014\u0010:\u001a\u00020\u0018*\u00020\u001a2\u0006\u0010;\u001a\u00020\u001aH\u0002J\u0014\u0010<\u001a\u00020\u0004*\u00020\u00042\b\b\u0002\u0010=\u001a\u00020!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/unciv/logic/github/Github;", "", "()V", "contentDispositionHeader", "", "goodFiles", "", "Lkotlin/text/Regex;", "goodFolders", "outerBlankReplacement", "", "parseAttachmentDispositionRegex", "redirectingResponseCodes", "", "", "choosePrettierName", "folderName", "defaultModName", "download", "Ljava/io/InputStream;", "url", "preDownloadAction", "Lkotlin/Function1;", "Ljava/net/HttpURLConnection;", "", "downloadAndExtract", "Lcom/badlogic/gdx/files/FileHandle;", "repo", "Lcom/unciv/logic/github/GithubAPI$Repo;", "modsFolder", "updateProgressPercent", "getRepoSize", "isValidModFolder", "", "dir", "parseNameFromDisposition", "disposition", "default", "processRequestHandlingRedirects", "Lcom/unciv/logic/github/Github$RequestHandlingRedirectsResult;", "zipUrl", "resolveZipStructure", "Lkotlin/Pair;", "rewriteModOptions", "modFolder", "tryGetGithubReposWithTopic", "Lcom/unciv/logic/github/GithubAPI$RepoSearch;", "amountPerPage", "page", "searchRequest", "tryGetGithubTopics", "Lcom/unciv/logic/github/GithubAPI$TopicSearchResponse;", "tryGetPreviewImage", "Lcom/badlogic/gdx/graphics/Pixmap;", "modUrl", "defaultBranch", "avatarUrl", "folderNameToRepoName", "renameOrMove", "dest", "repoNameToFolderName", "onlyOuterBlanks", "CountingInputStream", "RedirectionException", "RequestHandlingRedirectsResult", "core"})
@SourceDebugExtension(value={"SMAP\nGithub.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Github.kt\ncom/unciv/logic/github/Github\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,501:1\n6442#2:502\n1747#3,3:503\n1549#3:507\n1620#3,3:508\n1549#3:511\n1620#3,3:512\n1#4:506\n*S KotlinDebug\n*F\n+ 1 Github.kt\ncom/unciv/logic/github/Github\n*L\n157#1:502\n294#1:503,3\n44#1:507\n44#1:508,3\n46#1:511\n46#1:512,3\n*E\n"})
public final class Github {
    @NotNull
    public static final Github INSTANCE;
    @NotNull
    private static final String contentDispositionHeader = "Content-Disposition";
    @NotNull
    private static final Regex parseAttachmentDispositionRegex;
    @NotNull
    private static final Set<Integer> redirectingResponseCodes;
    @NotNull
    private static final List<Regex> goodFolders;
    @NotNull
    private static final List<Regex> goodFiles;
    private static final char outerBlankReplacement = '=';

    private Github() {
    }

    @Nullable
    public final InputStream download(@NotNull String url2, @NotNull Function1<? super HttpURLConnection, Unit> preDownloadAction) {
        Intrinsics.checkNotNullParameter(url2, "url");
        Intrinsics.checkNotNullParameter(preDownloadAction, "preDownloadAction");
        try {
            URLConnection uRLConnection = new URI(url2).toURL().openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection $this$download_u24lambda_u242 = (HttpURLConnection)uRLConnection;
            boolean bl = false;
            preDownloadAction.invoke($this$download_u24lambda_u242);
            try {
                return $this$download_u24lambda_u242.getInputStream();
            }
            catch (Exception ex) {
                BufferedReader reader = new BufferedReader(new InputStreamReader($this$download_u24lambda_u242.getErrorStream(), Charsets.UTF_8));
                Object[] objectArray = new Object[]{TextStreamsKt.readText(reader)};
                Log.INSTANCE.error("Message from GitHub: %s", objectArray);
                throw ex;
            }
        }
        catch (UncivShowableException ex) {
            throw ex;
        }
        catch (RedirectionException _) {
            return null;
        }
        catch (Exception ex) {
            Log.INSTANCE.error("Exception during GitHub download", ex);
            return null;
        }
    }

    public static /* synthetic */ InputStream download$default(Github github, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = download.1.INSTANCE;
        }
        return github.download(string, function1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FileHandle downloadAndExtract(@NotNull GithubAPI.Repo repo, @NotNull FileHandle modsFolder, @Nullable Function1<? super Integer, Unit> updateProgressPercent) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(repo, "repo");
        Intrinsics.checkNotNullParameter(modsFolder, "modsFolder");
        String modNameFromFileName = repo.getName();
        String defaultBranch = repo.getDefault_branch();
        String zipUrl = null;
        String tempName = null;
        if (((CharSequence)repo.getDirect_zip_url()).length() == 0) {
            String gitRepoUrl = repo.getHtml_url();
            zipUrl = GithubAPI.INSTANCE.getUrlForBranchZip$core(gitRepoUrl, defaultBranch);
            StringBuilder stringBuilder = new StringBuilder().append("temp-");
            String string = Integer.toString(gitRepoUrl.hashCode(), CharsKt.checkRadix(16));
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            tempName = stringBuilder.append(string).toString();
        } else {
            zipUrl = repo.getDirect_zip_url();
            StringBuilder stringBuilder = new StringBuilder().append("temp-");
            String string = Integer.toString(repo.toString().hashCode(), CharsKt.checkRadix(16));
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            tempName = stringBuilder.append(string).toString();
        }
        RequestHandlingRedirectsResult requestHandlingRedirectsResult = this.processRequestHandlingRedirects(zipUrl);
        InputStream inputStream2 = requestHandlingRedirectsResult.component1();
        Integer contentLength = requestHandlingRedirectsResult.component2();
        String disposition = requestHandlingRedirectsResult.component3();
        if (inputStream2 == null) {
            return null;
        }
        modNameFromFileName = this.parseNameFromDisposition(disposition, modNameFromFileName);
        Integer n = contentLength;
        int progressEndsAtSize = n != null ? n : repo.getSize() * 1024 * 4 / 5;
        InputStream countingStream = CountingInputStream.Companion.create(inputStream2, progressEndsAtSize, updateProgressPercent);
        FileHandle tempZipFileHandle = modsFolder.child(tempName + ".zip");
        tempZipFileHandle.write(countingStream, false);
        FileHandle unzipDestination = tempZipFileHandle.sibling(tempName);
        if (unzipDestination.exists()) {
            if (unzipDestination.isDirectory()) {
                unzipDestination.deleteDirectory();
            } else {
                unzipDestination.delete();
            }
        }
        try {
            Intrinsics.checkNotNull(tempZipFileHandle);
            Intrinsics.checkNotNull(unzipDestination);
            Zip.INSTANCE.extractFolder(tempZipFileHandle, unzipDestination);
        }
        catch (ZipException ex) {
            throw new UncivShowableException("That is not a valid ZIP file", ex);
        }
        Pair<FileHandle, String> pair = this.resolveZipStructure(unzipDestination, modNameFromFileName);
        FileHandle innerFolder = pair.component1();
        String modName = pair.component2();
        String finalDestinationName = Github.repoNameToFolderName$default(this, StringsKt.replace$default(modName, '-' + defaultBranch, "", false, 4, null), false, 1, null);
        FileHandle finalDestination = modsFolder.child(finalDestinationName);
        FileHandle tempBackup = null;
        if (finalDestination.exists()) {
            tempBackup = finalDestination.sibling(finalDestinationName + ".updating");
            Intrinsics.checkNotNull(finalDestination);
            this.renameOrMove(finalDestination, tempBackup);
        }
        finalDestination.mkdirs();
        FileHandle[] fileHandleArray = innerFolder.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        Object[] objectArray = fileHandleArray;
        boolean $i$f$sortedBy = false;
        for (FileHandle innerFileOrFolder : ArraysKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                FileHandle file = (FileHandle)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(Intrinsics.areEqual(file.extension(), "atlas"));
                file = (FileHandle)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, Intrinsics.areEqual(file.extension(), "atlas"));
            }
        })) {
            Intrinsics.checkNotNull(innerFileOrFolder);
            Intrinsics.checkNotNull(finalDestination);
            this.renameOrMove(innerFileOrFolder, finalDestination);
        }
        tempZipFileHandle.delete();
        unzipDestination.deleteDirectory();
        if (tempBackup != null) {
            if (tempBackup.isDirectory()) {
                tempBackup.deleteDirectory();
            } else {
                tempBackup.delete();
            }
        }
        return finalDestination;
    }

    public static /* synthetic */ FileHandle downloadAndExtract$default(Github github, GithubAPI.Repo repo, FileHandle fileHandle, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        return github.downloadAndExtract(repo, fileHandle, function1);
    }

    private final RequestHandlingRedirectsResult processRequestHandlingRedirects(String zipUrl) {
        Ref.IntRef redirectCount = new Ref.IntRef();
        Ref.ObjectRef<String> currentUrl = new Ref.ObjectRef<String>();
        currentUrl.element = zipUrl;
        InputStream inputStream2 = null;
        Ref.ObjectRef<Integer> contentLength = new Ref.ObjectRef<Integer>();
        Ref.ObjectRef<String> disposition = new Ref.ObjectRef<String>();
        while (redirectCount.element < 2 && (inputStream2 = this.download((String)currentUrl.element, (Function1<? super HttpURLConnection, Unit>)new Function1<HttpURLConnection, Unit>(currentUrl, redirectCount, disposition, contentLength){
            final /* synthetic */ Ref.ObjectRef<String> $currentUrl;
            final /* synthetic */ Ref.IntRef $redirectCount;
            final /* synthetic */ Ref.ObjectRef<String> $disposition;
            final /* synthetic */ Ref.ObjectRef<Integer> $contentLength;
            {
                this.$currentUrl = $currentUrl;
                this.$redirectCount = $redirectCount;
                this.$disposition = $disposition;
                this.$contentLength = $contentLength;
                super(1);
            }

            public final void invoke(@NotNull HttpURLConnection it) {
                CharSequence charSequence;
                Intrinsics.checkNotNullParameter(it, "it");
                int responseCode = it.getResponseCode();
                String location = it.getHeaderField("Location");
                if (Github.access$getRedirectingResponseCodes$p().contains(responseCode) && !((charSequence = (CharSequence)location) == null || charSequence.length() == 0)) {
                    Intrinsics.checkNotNull(location);
                    this.$currentUrl.element = location;
                    int n = this.$redirectCount.element;
                    this.$redirectCount.element = n + 1;
                    throw new RedirectionException();
                }
                if (responseCode == 403 && it.getHeaderField("CF-RAY") != null) {
                    String string = it.getHeaderField("cf-mitigated");
                    if (string == null) {
                        string = "";
                    }
                    if (Intrinsics.areEqual(string, "challenge")) {
                        throw new UncivShowableException("Blocked by Cloudflare", null, 2, null);
                    }
                }
                boolean bl = 401 <= responseCode ? responseCode < 404 : false;
                if (bl || responseCode == 407) {
                    throw new UncivShowableException("Servers requiring authentication are not supported", null, 2, null);
                }
                boolean bl2 = 300 <= responseCode ? responseCode < 500 : false;
                if (bl2) {
                    throw new UncivShowableException("Unexpected response: [" + it.getResponseMessage() + ']', null, 2, null);
                }
                boolean bl3 = 500 <= responseCode ? responseCode < 600 : false;
                if (bl3) {
                    throw new UncivShowableException("Server failure: [" + it.getResponseMessage() + ']', null, 2, null);
                }
                this.$disposition.element = it.getHeaderField("Content-Disposition");
                String string = it.getHeaderField("Content-Length");
                this.$contentLength.element = string != null ? StringsKt.toIntOrNull(string) : null;
            }
        })) == null) {
        }
        return new RequestHandlingRedirectsResult(inputStream2, (Integer)contentLength.element, (String)disposition.element);
    }

    private final String parseNameFromDisposition(String disposition, String string) {
        if (disposition == null) {
            return Github.parseNameFromDisposition$removeZipExtension(string);
        }
        MatchResult matchResult = parseAttachmentDispositionRegex.matchAt(disposition, 0);
        if (matchResult == null) {
            return Github.parseNameFromDisposition$removeZipExtension(string);
        }
        MatchResult match = matchResult;
        MatchGroup matchGroup = match.getGroups().get(2);
        Intrinsics.checkNotNull(matchGroup);
        return Github.parseNameFromDisposition$removeZipExtension(matchGroup.getValue());
    }

    private final boolean isValidModFolder(FileHandle dir) {
        int good = 0;
        int bad = 0;
        FileHandle[] fileHandleArray = dir.list();
        Intrinsics.checkNotNullExpressionValue(fileHandleArray, "list(...)");
        for (FileHandle file : fileHandleArray) {
            boolean bl;
            block5: {
                List<Regex> goodList = file.isDirectory() ? goodFolders : goodFiles;
                Iterable $this$any$iv = goodList;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Regex it = (Regex)element$iv;
                        boolean bl2 = false;
                        String string = file.name();
                        Intrinsics.checkNotNullExpressionValue(string, "name(...)");
                        if (!it.matches(string)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                ++good;
                continue;
            }
            ++bad;
        }
        return good > 0 && good > bad;
    }

    private final Pair<FileHandle, String> resolveZipStructure(FileHandle dir, String defaultModName) {
        FileHandle[] subdirs;
        block5: {
            block4: {
                if (this.isValidModFolder(dir)) {
                    return TuplesKt.to(dir, defaultModName);
                }
                subdirs = dir.list(Github::resolveZipStructure$lambda$5);
                if (subdirs.length != 1) break block4;
                FileHandle fileHandle = subdirs[0];
                Intrinsics.checkNotNullExpressionValue(fileHandle, "get(...)");
                if (this.isValidModFolder(fileHandle)) break block5;
            }
            throw new UncivShowableException("Invalid Mod archive structure", null, 2, null);
        }
        FileHandle fileHandle = subdirs[0];
        String string = subdirs[0].name();
        Intrinsics.checkNotNullExpressionValue(string, "name(...)");
        return TuplesKt.to(fileHandle, this.choosePrettierName(string, defaultModName));
    }

    private final String choosePrettierName(String folderName, String defaultModName) {
        if (StringsKt.startsWith(defaultModName, folderName, true) && Github.choosePrettierName$isMixedCase(defaultModName) && !Github.choosePrettierName$isMixedCase(folderName)) {
            return StringsKt.removeSuffix(StringsKt.removeSuffix(defaultModName, (CharSequence)"-main"), (CharSequence)"-master");
        }
        return folderName;
    }

    private final void renameOrMove(FileHandle $this$renameOrMove, FileHandle dest) {
        if ($this$renameOrMove.type() == Files.FileType.Local && $this$renameOrMove.isDirectory()) {
            if ($this$renameOrMove.file().renameTo(dest.child($this$renameOrMove.name()).file())) {
                return;
            }
            if ($this$renameOrMove.file().renameTo(dest.file())) {
                return;
            }
        }
        $this$renameOrMove.moveTo(dest);
    }

    @Nullable
    public final GithubAPI.RepoSearch tryGetGithubReposWithTopic(int amountPerPage, int page, @NotNull String searchRequest) {
        Intrinsics.checkNotNullParameter(searchRequest, "searchRequest");
        String link = GithubAPI.INSTANCE.getUrlForModListing$core(searchRequest, amountPerPage, page);
        Ref.IntRef retries = new Ref.IntRef();
        retries.element = 2;
        while (retries.element > 0) {
            InputStream inputStream2;
            int n = retries.element;
            retries.element = n + -1;
            if (RateLimit.INSTANCE.waitForLimit()) {
                return null;
            }
            InputStream inputStream3 = this.download(link, (Function1<? super HttpURLConnection, Unit>)new Function1<HttpURLConnection, Unit>(page, retries){
                final /* synthetic */ int $page;
                final /* synthetic */ Ref.IntRef $retries;
                {
                    this.$page = $page;
                    this.$retries = $retries;
                    super(1);
                }

                public final void invoke(@NotNull HttpURLConnection it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (it.getResponseCode() == 403 || it.getResponseCode() == 200 && this.$page == 1 && this.$retries.element == 1) {
                        RateLimit.INSTANCE.notifyHttpResponse(it);
                        int n = this.$retries.element;
                        this.$retries.element = n + 1;
                    }
                }
            });
            if (inputStream3 == null) continue;
            InputStream inputStream4 = inputStream2 = inputStream3;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream4, charset);
            int n2 = 8192;
            String text2 = TextStreamsKt.readText(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2));
            try {
                return UncivJsonKt.json().fromJson(GithubAPI.RepoSearch.class, text2);
            }
            catch (Throwable _) {
                throw new Exception("Failed to parse Github response as json - " + text2);
            }
        }
        return null;
    }

    public static /* synthetic */ GithubAPI.RepoSearch tryGetGithubReposWithTopic$default(Github github, int n, int n2, String string, int n3, Object object) {
        if ((n3 & 4) != 0) {
            string = "";
        }
        return github.tryGetGithubReposWithTopic(n, n2, string);
    }

    @Nullable
    public final Pixmap tryGetPreviewImage(@NotNull String modUrl, @NotNull String defaultBranch, @Nullable String avatarUrl) {
        Intrinsics.checkNotNullParameter(modUrl, "modUrl");
        Intrinsics.checkNotNullParameter(defaultBranch, "defaultBranch");
        String fileLocation = GithubAPI.INSTANCE.getUrlForPreview$core(modUrl, defaultBranch);
        try {
            InputStream inputStream2 = Github.download$default(this, fileLocation + ".jpg", null, 2, null);
            if (inputStream2 == null && (inputStream2 = Github.download$default(this, fileLocation + ".png", null, 2, null)) == null) {
                InputStream inputStream3;
                String string = avatarUrl;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    inputStream3 = Github.download$default(INSTANCE, it, null, 2, null);
                } else {
                    inputStream3 = inputStream2 = null;
                }
                if (inputStream3 == null) {
                    return null;
                }
            }
            InputStream file = inputStream2;
            byte[] byteArray = ByteStreamsKt.readBytes(file);
            ByteBuffer buffer = ByteBuffer.allocateDirect(byteArray.length).put(byteArray).position(0);
            return new Pixmap(buffer);
        }
        catch (Throwable _) {
            return null;
        }
    }

    public final int getRepoSize(@NotNull GithubAPI.Repo repo) {
        Intrinsics.checkNotNullParameter(repo, "repo");
        String link = GithubAPI.INSTANCE.getUrlForTreeQuery$core(repo);
        Ref.IntRef retries = new Ref.IntRef();
        retries.element = 2;
        while (retries.element > 0) {
            int n = retries.element;
            retries.element = n + -1;
            if (RateLimit.INSTANCE.waitForLimit()) {
                return -1;
            }
            InputStream inputStream2 = this.download(link, (Function1<? super HttpURLConnection, Unit>)new Function1<HttpURLConnection, Unit>(retries){
                final /* synthetic */ Ref.IntRef $retries;
                {
                    this.$retries = $retries;
                    super(1);
                }

                public final void invoke(@NotNull HttpURLConnection it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (it.getResponseCode() == 403 || it.getResponseCode() == 200 && this.$retries.element == 1) {
                        RateLimit.INSTANCE.notifyHttpResponse(it);
                        int n = this.$retries.element;
                        this.$retries.element = n + 1;
                    }
                }
            });
            if (inputStream2 == null) continue;
            InputStream inputStream3 = inputStream2;
            InputStream inputStream4 = inputStream3;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream4, charset);
            int n2 = 8192;
            GithubAPI.Tree tree = UncivJsonKt.json().fromJson(GithubAPI.Tree.class, TextStreamsKt.readText(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2)));
            if (tree.getTruncated()) {
                return -1;
            }
            long totalSizeBytes = 0L;
            for (GithubAPI.Tree.TreeFile file : tree.getTree()) {
                totalSizeBytes += file.getSize();
            }
            return (int)((totalSizeBytes + (long)512) / (long)1024);
        }
        return -1;
    }

    @Nullable
    public final GithubAPI.TopicSearchResponse tryGetGithubTopics() {
        String link = "https://api.github.com/search/topics?q=unciv-mod+repositories:%3E1&sort=name&order=asc";
        Ref.IntRef retries = new Ref.IntRef();
        retries.element = 2;
        while (retries.element > 0) {
            int n = retries.element;
            retries.element = n + -1;
            if (RateLimit.INSTANCE.waitForLimit()) {
                return null;
            }
            InputStream inputStream2 = this.download(link, (Function1<? super HttpURLConnection, Unit>)new Function1<HttpURLConnection, Unit>(retries){
                final /* synthetic */ Ref.IntRef $retries;
                {
                    this.$retries = $retries;
                    super(1);
                }

                public final void invoke(@NotNull HttpURLConnection it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (it.getResponseCode() == 403 || it.getResponseCode() == 200 && this.$retries.element == 1) {
                        RateLimit.INSTANCE.notifyHttpResponse(it);
                        int n = this.$retries.element;
                        this.$retries.element = n + 1;
                    }
                }
            });
            if (inputStream2 == null) continue;
            InputStream inputStream3 = inputStream2;
            InputStream inputStream4 = inputStream3;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream4, charset);
            int n2 = 8192;
            return UncivJsonKt.json().fromJson(GithubAPI.TopicSearchResponse.class, TextStreamsKt.readText(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2)));
        }
        return null;
    }

    public final void rewriteModOptions(@NotNull GithubAPI.Repo repo, @NotNull FileHandle modFolder) {
        boolean overwriteAlways;
        ModOptions modOptions;
        Intrinsics.checkNotNullParameter(repo, "repo");
        Intrinsics.checkNotNullParameter(modFolder, "modFolder");
        FileHandle modOptionsFile = modFolder.child("jsons/ModOptions.json");
        if (modOptionsFile.exists()) {
            Json json = UncivJsonKt.json();
            Intrinsics.checkNotNull(modOptionsFile);
            modOptions = UncivJsonKt.fromJsonFile(json, ModOptions.class, modOptionsFile);
        } else {
            modOptions = new ModOptions();
        }
        ModOptions modOptions2 = modOptions;
        boolean bl = overwriteAlways = ((CharSequence)repo.getDirect_zip_url()).length() == 0;
        if (overwriteAlways || ((CharSequence)modOptions2.getModUrl()).length() == 0) {
            modOptions2.setModUrl(repo.getHtml_url());
        }
        if (overwriteAlways || Intrinsics.areEqual(modOptions2.getDefaultBranch(), "master") && ((CharSequence)repo.getDefault_branch()).length() > 0) {
            modOptions2.setDefaultBranch(repo.getDefault_branch());
        }
        if (overwriteAlways || ((CharSequence)modOptions2.getLastUpdated()).length() == 0) {
            modOptions2.setLastUpdated(repo.getPushed_at());
        }
        if (overwriteAlways || ((CharSequence)modOptions2.getAuthor()).length() == 0) {
            modOptions2.setAuthor(repo.getOwner().getLogin());
        }
        if (overwriteAlways || modOptions2.getModSize() == 0) {
            modOptions2.setModSize(repo.getSize());
        }
        if (overwriteAlways || modOptions2.getTopics().isEmpty()) {
            modOptions2.setTopics(repo.getTopics());
        }
        BackwardCompatibility.INSTANCE.updateDeprecations(modOptions2);
        UncivJsonKt.json().toJson((Object)modOptions2, modOptionsFile);
    }

    @NotNull
    public final String repoNameToFolderName(@NotNull String $this$repoNameToFolderName, boolean onlyOuterBlanks) {
        String result2;
        Intrinsics.checkNotNullParameter($this$repoNameToFolderName, "<this>");
        String string = result2 = onlyOuterBlanks ? $this$repoNameToFolderName : StringsKt.replace$default($this$repoNameToFolderName, '-', ' ', false, 4, null);
        if (StringsKt.endsWith$default((CharSequence)result2, ' ', false, 2, null)) {
            result2 = ((Object)StringsKt.trimEnd((CharSequence)result2)).toString() + '=';
        }
        if (StringsKt.startsWith$default((CharSequence)result2, ' ', false, 2, null)) {
            char c = '=';
            String string2 = ((Object)StringsKt.trimStart((CharSequence)result2)).toString();
            result2 = c + string2;
        }
        return result2;
    }

    public static /* synthetic */ String repoNameToFolderName$default(Github github, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return github.repoNameToFolderName(string, bl);
    }

    @NotNull
    public final String folderNameToRepoName(@NotNull String $this$folderNameToRepoName) {
        Intrinsics.checkNotNullParameter($this$folderNameToRepoName, "<this>");
        String result2 = StringsKt.replace$default($this$folderNameToRepoName, ' ', '-', false, 4, null);
        if (StringsKt.endsWith$default((CharSequence)result2, '=', false, 2, null)) {
            char[] cArray = new char[]{'='};
            result2 = StringsKt.trimEnd(result2, cArray) + '-';
        }
        if (StringsKt.startsWith$default((CharSequence)result2, '=', false, 2, null)) {
            char c = '-';
            Object object = new char[]{'='};
            object = StringsKt.trimStart(result2, object);
            result2 = c + (String)object;
        }
        return result2;
    }

    private static final String parseNameFromDisposition$removeZipExtension(String $this$parseNameFromDisposition_u24removeZipExtension) {
        return StringsKt.replace$default(StringsKt.removeSuffix($this$parseNameFromDisposition_u24removeZipExtension, (CharSequence)".zip"), '.', ' ', false, 4, null);
    }

    private static final boolean resolveZipStructure$lambda$5(File it) {
        return it.isDirectory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean choosePrettierName$isMixedCase(String $this$choosePrettierName_u24isMixedCase) {
        String string = $this$choosePrettierName_u24isMixedCase.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        if (Intrinsics.areEqual($this$choosePrettierName_u24isMixedCase, string)) return false;
        String string2 = $this$choosePrettierName_u24isMixedCase.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
        if (Intrinsics.areEqual($this$choosePrettierName_u24isMixedCase, string2)) return false;
        return true;
    }

    public static final /* synthetic */ Set access$getRedirectingResponseCodes$p() {
        return redirectingResponseCodes;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        String it;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        INSTANCE = new Github();
        parseAttachmentDispositionRegex = new Regex("attachment;\\s*filename\\s*=\\s*([\"'])?(.*?)\\1(;|$)");
        Object[] objectArray = new Integer[]{301, 302, 303, 307, 308};
        redirectingResponseCodes = SetsKt.setOf(objectArray);
        objectArray = new String[]{"Images", "jsons", "maps", "music", "sounds", "Images\\..*", "scenarios", ".github"};
        Object $this$map$iv = (String[])CollectionsKt.listOf(objectArray);
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Regex(it, RegexOption.IGNORE_CASE));
        }
        goodFolders = (List)destination$iv$iv;
        $this$map$iv = new String[]{".*\\.atlas", ".*\\.png", "preview.jpg", ".*\\.md", "Atlases.json", ".nomedia", "license", "contribute.md", "readme.md", "credits.md"};
        $this$map$iv = CollectionsKt.listOf($this$map$iv);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Regex(it, RegexOption.IGNORE_CASE));
        }
        goodFiles = (List)var3_3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\f\u001a\u00020\u0004J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/unciv/logic/github/Github$CountingInputStream;", "Ljava/io/InputStream;", "wrapped", "contentLength", "", "updateProgressPercent", "Lkotlin/Function1;", "", "(Ljava/io/InputStream;ILkotlin/jvm/functions/Function1;)V", "count", "trackerThread", "Lkotlinx/coroutines/Job;", "bytesRead", "close", "read", "startTracking", "stopTracking", "Companion", "core"})
    private static final class CountingInputStream
    extends InputStream {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final InputStream wrapped;
        private final int contentLength;
        @NotNull
        private final Function1<Integer, Unit> updateProgressPercent;
        private int count;
        @Nullable
        private Job trackerThread;

        private CountingInputStream(InputStream wrapped, int contentLength, Function1<? super Integer, Unit> updateProgressPercent) {
            this.wrapped = wrapped;
            this.contentLength = contentLength;
            this.updateProgressPercent = updateProgressPercent;
        }

        @Override
        public int read() {
            int n = this.count;
            this.count = n + 1;
            return this.wrapped.read();
        }

        @Override
        public void close() {
            this.stopTracking();
            super.close();
        }

        public final int bytesRead() {
            return this.count;
        }

        private final void startTracking() {
            this.trackerThread = Concurrency.run$default(Concurrency.INSTANCE, "Downloading mod progress", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ CountingInputStream this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(var1_1);
                            $this$run = (CoroutineScope)this.L$0;
lbl6:
                            // 3 sources

                            while (CoroutineScopeKt.isActive($this$run)) {
                                percentage = this.this$0.bytesRead() * 100 / CountingInputStream.access$getContentLength$p(this.this$0);
                                CountingInputStream.access$getUpdateProgressPercent$p(this.this$0).invoke(Boxing.boxInt(percentage));
                                if (percentage >= 100) {
                                    CountingInputStream.access$stopTracking(this.this$0);
                                    break block0;
                                }
                                this.L$0 = $this$run;
                                this.label = 1;
                                v0 = DelayKt.delay(100L, this);
                                if (v0 != var4_2) continue;
                                return var4_2;
                            }
                            break;
                        }
                        case 1: {
                            $this$run = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
                            ** GOTO lbl6
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 2, null);
        }

        private final void stopTracking() {
            Job job2 = this.trackerThread;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default(job2, null, 1, null);
            }
            this.trackerThread = null;
        }

        public /* synthetic */ CountingInputStream(InputStream wrapped, int contentLength, Function1 updateProgressPercent, DefaultConstructorMarker $constructor_marker) {
            this(wrapped, contentLength, updateProgressPercent);
        }

        public static final /* synthetic */ int access$getContentLength$p(CountingInputStream $this) {
            return $this.contentLength;
        }

        public static final /* synthetic */ Function1 access$getUpdateProgressPercent$p(CountingInputStream $this) {
            return $this.updateProgressPercent;
        }

        public static final /* synthetic */ void access$stopTracking(CountingInputStream $this) {
            $this.stopTracking();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a8\u0006\u000b"}, d2={"Lcom/unciv/logic/github/Github$CountingInputStream$Companion;", "", "()V", "create", "Ljava/io/InputStream;", "originalStream", "contentLength", "", "updateProgressPercent", "Lkotlin/Function1;", "", "core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final InputStream create(@NotNull InputStream originalStream, int contentLength, @Nullable Function1<? super Integer, Unit> updateProgressPercent) {
                Intrinsics.checkNotNullParameter(originalStream, "originalStream");
                if (updateProgressPercent == null || contentLength <= 0) {
                    return originalStream;
                }
                CountingInputStream newStream = new CountingInputStream(originalStream, contentLength, updateProgressPercent, null);
                newStream.startTracking();
                return newStream;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/unciv/logic/github/Github$RedirectionException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "()V", "core"})
    private static final class RedirectionException
    extends Exception {
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J2\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/unciv/logic/github/Github$RequestHandlingRedirectsResult;", "", "stream", "Ljava/io/InputStream;", "length", "", "disposition", "", "(Ljava/io/InputStream;Ljava/lang/Integer;Ljava/lang/String;)V", "getDisposition", "()Ljava/lang/String;", "getLength", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getStream", "()Ljava/io/InputStream;", "component1", "component2", "component3", "copy", "(Ljava/io/InputStream;Ljava/lang/Integer;Ljava/lang/String;)Lcom/unciv/logic/github/Github$RequestHandlingRedirectsResult;", "equals", "", "other", "hashCode", "toString", "core"})
    private static final class RequestHandlingRedirectsResult {
        @Nullable
        private final InputStream stream;
        @Nullable
        private final Integer length;
        @Nullable
        private final String disposition;

        public RequestHandlingRedirectsResult(@Nullable InputStream stream, @Nullable Integer length, @Nullable String disposition) {
            this.stream = stream;
            this.length = length;
            this.disposition = disposition;
        }

        @Nullable
        public final InputStream getStream() {
            return this.stream;
        }

        @Nullable
        public final Integer getLength() {
            return this.length;
        }

        @Nullable
        public final String getDisposition() {
            return this.disposition;
        }

        @Nullable
        public final InputStream component1() {
            return this.stream;
        }

        @Nullable
        public final Integer component2() {
            return this.length;
        }

        @Nullable
        public final String component3() {
            return this.disposition;
        }

        @NotNull
        public final RequestHandlingRedirectsResult copy(@Nullable InputStream stream, @Nullable Integer length, @Nullable String disposition) {
            return new RequestHandlingRedirectsResult(stream, length, disposition);
        }

        public static /* synthetic */ RequestHandlingRedirectsResult copy$default(RequestHandlingRedirectsResult requestHandlingRedirectsResult, InputStream inputStream2, Integer n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                inputStream2 = requestHandlingRedirectsResult.stream;
            }
            if ((n2 & 2) != 0) {
                n = requestHandlingRedirectsResult.length;
            }
            if ((n2 & 4) != 0) {
                string = requestHandlingRedirectsResult.disposition;
            }
            return requestHandlingRedirectsResult.copy(inputStream2, n, string);
        }

        @NotNull
        public String toString() {
            return "RequestHandlingRedirectsResult(stream=" + this.stream + ", length=" + this.length + ", disposition=" + this.disposition + ')';
        }

        public int hashCode() {
            int result2 = this.stream == null ? 0 : this.stream.hashCode();
            result2 = result2 * 31 + (this.length == null ? 0 : ((Object)this.length).hashCode());
            result2 = result2 * 31 + (this.disposition == null ? 0 : this.disposition.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RequestHandlingRedirectsResult)) {
                return false;
            }
            RequestHandlingRedirectsResult requestHandlingRedirectsResult = (RequestHandlingRedirectsResult)other;
            if (!Intrinsics.areEqual(this.stream, requestHandlingRedirectsResult.stream)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.length, requestHandlingRedirectsResult.length)) {
                return false;
            }
            return Intrinsics.areEqual(this.disposition, requestHandlingRedirectsResult.disposition);
        }
    }
}

