/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator.mapregions;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapgenerator.mapregions.MapGenTileData;
import com.unciv.logic.map.mapgenerator.mapregions.MapRegionsKt;
import com.unciv.logic.map.mapgenerator.mapregions.MinorCivPlacer;
import com.unciv.logic.map.mapgenerator.mapregions.Region;
import com.unciv.logic.map.mapgenerator.mapregions.RegionStartFinder;
import com.unciv.logic.map.mapgenerator.mapregions.StartNormalizer;
import com.unciv.logic.map.mapgenerator.mapregions.TileDataMap;
import com.unciv.logic.map.mapgenerator.resourceplacement.LuxuryResourcePlacementLogic;
import com.unciv.logic.map.mapgenerator.resourceplacement.StrategicBonusResourcePlacementLogic;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.utils.Log;
import com.unciv.utils.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 02\u00020\u0001:\u0003/01B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J$\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001cJ\u001e\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017H\u0002J,\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010)\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017J$\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070,2\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u001cH\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/MapRegions;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "(Lcom/unciv/models/ruleset/Ruleset;)V", "regions", "Ljava/util/ArrayList;", "Lcom/unciv/logic/map/mapgenerator/mapregions/Region;", "Lkotlin/collections/ArrayList;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "tileData", "Lcom/unciv/logic/map/mapgenerator/mapregions/TileDataMap;", "assignCivToRegion", "", "civ", "Lcom/unciv/logic/civilization/Civilization;", "region", "assignRegionTypes", "assignRegions", "tileMap", "Lcom/unciv/logic/map/TileMap;", "civilizations", "", "gameParameters", "Lcom/unciv/models/metadata/GameParameters;", "divideRegion", "numDivisions", "", "generateRegions", "numRegions", "getFallbackRegion", "type", "", "candidates", "logAssignRegion", "success", "", "startBiasType", "Lcom/unciv/logic/map/mapgenerator/mapregions/MapRegions$BiasTypes;", "placeNaturalWonderImpacts", "placeResourcesAndMinorCivs", "minorCivs", "splitRegion", "Lkotlin/Pair;", "regionToSplit", "firstPercent", "BiasTypes", "Companion", "ImpactType", "core"})
@SourceDebugExtension(value={"SMAP\nMapRegions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapRegions.kt\ncom/unciv/logic/map/mapgenerator/mapregions/MapRegions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,521:1\n1963#2,14:522\n766#2:536\n857#2,2:537\n288#2,2:540\n1045#2:542\n1271#2,2:543\n1285#2,4:545\n1490#2:549\n1520#2,2:550\n1747#2,3:552\n1522#2:555\n1523#2,3:563\n1045#2:566\n1054#2:567\n766#2:568\n857#2,2:569\n1963#2,14:571\n766#2:585\n857#2:586\n858#2:589\n1963#2,14:590\n766#2:604\n857#2,2:605\n1963#2,14:607\n766#2:621\n857#2:622\n858#2:625\n1963#2,14:626\n766#2:640\n857#2,2:641\n1963#2,5:643\n1969#2,8:655\n3190#2,10:663\n1549#2:673\n1620#2,3:674\n819#2:677\n847#2,2:678\n2333#2,5:680\n2339#2,2:699\n2341#2,6:715\n766#2:721\n857#2,2:722\n1045#2:724\n1963#2,14:731\n766#2:745\n857#2,2:746\n1#3:539\n372#4,7:556\n478#4,7:648\n478#4,7:685\n478#4,7:692\n478#4,7:701\n478#4,7:708\n1247#5,2:587\n1247#5,2:623\n1247#5,2:725\n1247#5,2:727\n1247#5,2:729\n*S KotlinDebug\n*F\n+ 1 MapRegions.kt\ncom/unciv/logic/map/mapgenerator/mapregions/MapRegions\n*L\n135#1:522,14\n144#1:536\n144#1:537,2\n238#1:540,2\n243#1:542\n249#1:543,2\n249#1:545,4\n251#1:549\n251#1:550,2\n256#1:552,3\n251#1:555\n251#1:563,3\n268#1:566\n271#1:567\n282#1:568\n282#1:569,2\n283#1:571,14\n291#1:585\n291#1:586\n291#1:589\n292#1:590,14\n300#1:604\n300#1:605,2\n301#1:607,14\n309#1:621\n309#1:622\n309#1:625\n310#1:626,14\n326#1:640\n326#1:641,2\n327#1:643,5\n327#1:655,8\n352#1:663,10\n353#1:673\n353#1:674,3\n356#1:677\n356#1:678,2\n357#1:680,5\n357#1:699,2\n357#1:715,6\n384#1:721\n384#1:722,2\n385#1:724\n436#1:731,14\n452#1:745\n452#1:746,2\n251#1:556,7\n327#1:648,7\n358#1:685,7\n359#1:692,7\n358#1:701,7\n359#1:708,7\n291#1:587,2\n309#1:623,2\n392#1:725,2\n398#1:727,2\n401#1:729,2\n*E\n"})
public final class MapRegions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final ArrayList<Region> regions;
    @NotNull
    private final TileDataMap tileData;
    @NotNull
    private static final Map<Integer, Integer> minimumFoodForRing;
    @NotNull
    private static final Map<Integer, Integer> minimumProdForRing;
    @NotNull
    private static final Map<Integer, Integer> minimumGoodForRing;
    public static final int maximumJunk = 9;
    @NotNull
    private static final List<Integer> firstRingFoodScores;
    @NotNull
    private static final List<Integer> firstRingProdScores;
    @NotNull
    private static final List<Integer> secondRingFoodScores;
    @NotNull
    private static final List<Integer> secondRingProdScores;
    @NotNull
    private static final Map<Integer, Integer> closeStartPenaltyForRing;
    @NotNull
    private static final Map<Integer, List<Float>> randomLuxuryRatios;
    public static final int baseMinorDepositFrequency = 30;

    public MapRegions(@NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        this.ruleset = ruleset2;
        this.regions = new ArrayList();
        this.tileData = new TileDataMap();
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    /*
     * WARNING - void declaration
     */
    public final void generateRegions(@NotNull TileMap tileMap, int numRegions) {
        Object $i$f$maxByOrNull22;
        Iterator iterator2;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        if (numRegions <= 0) {
            return;
        }
        if (tileMap.getContinentSizes().isEmpty()) {
            throw new Exception("No Continents on this map!");
        }
        float radius = Intrinsics.areEqual(tileMap.getMapParameters().getShape(), "Hexagonal") || Intrinsics.areEqual(tileMap.getMapParameters().getShape(), "Flat Earth Hexagonal") ? (float)tileMap.getMapParameters().getMapSize().getRadius() : (float)Math.max(tileMap.getMapParameters().getMapSize().getWidth() / 2, tileMap.getMapParameters().getMapSize().getHeight() / 2);
        Rectangle mapRect = new Rectangle(-radius, -radius, radius * (float)2 + 1.0f, radius * (float)2 + 1.0f);
        if (tileMap.usingArchipelagoRegions()) {
            Region hugeRect = new Region(tileMap, mapRect, -1);
            hugeRect.setAffectedByWorldWrap(false);
            Region.updateTiles$default(hugeRect, false, 1, null);
            this.divideRegion(hugeRect, numRegions);
            return;
        }
        Set<Integer> set2 = tileMap.getContinentSizes().keySet();
        Intrinsics.checkNotNullExpressionValue(set2, "<get-keys>(...)");
        List continents = CollectionsKt.toMutableList((Collection)set2);
        HashMap civsAddedToContinent = new HashMap();
        HashMap continentFertility = new HashMap();
        HashMap continentToColumnsItsIn = new HashMap();
        for (Tile tile : tileMap.getValues()) {
            int continent = tile.getContinent();
            if (continent == -1) continue;
            object2 = continentFertility;
            object = continent;
            int n = MapRegionsKt.getTileFertility(tile, true);
            Integer n2 = (Integer)continentFertility.get(continent);
            if (n2 == null) {
                n2 = 0;
            }
            iterator2 = n + ((Number)n2).intValue();
            object2.put(object, iterator2);
            if (continentToColumnsItsIn.get(continent) == null) {
                object = continent;
                ((Map)continentToColumnsItsIn).put(object, new HashSet());
            }
            Object v = continentToColumnsItsIn.get(continent);
            Intrinsics.checkNotNull(v);
            ((HashSet)v).add(tile.getColumn());
        }
        for (int i = 0; i < numRegions; ++i) {
            Object v4;
            Map $this$maxByOrNull$iv;
            int it = i;
            boolean bl = false;
            object2 = continents;
            boolean $i$f$maxByOrNull22 = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v4 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v4 = maxElem$iv;
                } else {
                    Integer it2 = (Integer)maxElem$iv;
                    boolean bl2 = false;
                    Object v = continentFertility.get(it2);
                    Intrinsics.checkNotNull(v);
                    int n = ((Number)v).intValue();
                    Integer n3 = (Integer)civsAddedToContinent.get(it2);
                    if (n3 == null) {
                        n3 = 0;
                    }
                    Integer n4 = n3;
                    Intrinsics.checkNotNull(n4);
                    Comparable maxValue$iv = Integer.valueOf(n / (1 + ((Number)n4).intValue()));
                    do {
                        Object e$iv = iterator$iv.next();
                        Integer it3 = (Integer)e$iv;
                        $i$a$-maxByOrNull-MapRegions$generateRegions$1$bestContinent$1 = false;
                        Object v2 = continentFertility.get(it3);
                        Intrinsics.checkNotNull(v2);
                        int n5 = ((Number)v2).intValue();
                        Integer n6 = (Integer)civsAddedToContinent.get(it3);
                        if (n6 == null) {
                            n6 = 0;
                        }
                        Integer n7 = n6;
                        Intrinsics.checkNotNull(n7);
                        Comparable v$iv = Integer.valueOf(n5 / (1 + ((Number)n7).intValue()));
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v4 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v4);
            int bestContinent = ((Number)v4).intValue();
            $this$maxByOrNull$iv = civsAddedToContinent;
            $i$f$maxByOrNull22 = bestContinent;
            Integer n = (Integer)civsAddedToContinent.get(bestContinent);
            if (n == null) {
                n = 0;
            }
            iterator$iv = n + 1;
            $this$maxByOrNull$iv.put($i$f$maxByOrNull22, iterator$iv);
        }
        for (Integer continent : civsAddedToContinent.keySet()) {
            int it;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Rectangle rectangle = new Rectangle(mapRect);
            Intrinsics.checkNotNull(continent);
            Region continentRegion = new Region(tileMap, rectangle, continent);
            Object v = continentToColumnsItsIn.get(continent);
            Intrinsics.checkNotNull(v);
            HashSet cols = (HashSet)v;
            $i$f$maxByOrNull22 = cols;
            Rectangle rectangle2 = continentRegion.getRect();
            boolean $i$f$filter = false;
            void maxElem$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it4 = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!(!cols.contains(it4 - 1))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            object = (List)destination$iv$iv;
            iterator2 = object.iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            int it5 = ((Number)iterator2.next()).intValue();
            boolean bl = false;
            while (iterator2.hasNext()) {
                it = ((Number)iterator2.next()).intValue();
                $i$a$-maxOf-MapRegions$generateRegions$3 = false;
                if (it5 >= it) continue;
                it5 = it;
            }
            int n = it5;
            rectangle2.x = n;
            continentRegion.getRect().width = cols.size();
            if (tileMap.getMapParameters().getWorldWrap()) {
                iterator2 = ((Iterable)cols).iterator();
                if (!iterator2.hasNext()) {
                    throw new NoSuchElementException();
                }
                it5 = ((Number)iterator2.next()).intValue();
                boolean bl3 = false;
                int n8 = it5;
                while (iterator2.hasNext()) {
                    it = ((Number)iterator2.next()).intValue();
                    $i$a$-minOf-MapRegions$generateRegions$4 = false;
                    int n9 = it;
                    if (n8 <= n9) continue;
                    n8 = n9;
                }
                if ((float)n8 < continentRegion.getRect().x) {
                    continentRegion.setAffectedByWorldWrap(true);
                }
            }
            Region.updateTiles$default(continentRegion, false, 1, null);
            Object v3 = civsAddedToContinent.get(continent);
            Intrinsics.checkNotNull(v3);
            this.divideRegion(continentRegion, ((Number)v3).intValue());
        }
    }

    private final void divideRegion(Region region, int numDivisions) {
        if (numDivisions <= 1) {
            this.regions.add(region);
            return;
        }
        int firstDivisions = numDivisions / 2;
        Pair<Region, Region> splitRegions = this.splitRegion(region, 100 * firstDivisions / numDivisions);
        this.divideRegion(splitRegions.getFirst(), firstDivisions);
        this.divideRegion(splitRegions.getSecond(), numDivisions - firstDivisions);
    }

    private final Pair<Region, Region> splitRegion(Region regionToSplit, int firstPercent) {
        int n;
        int targetFertility = regionToSplit.getTotalFertility() * firstPercent / 100;
        Region splitOffRegion = new Region(regionToSplit.getTileMap(), new Rectangle(regionToSplit.getRect()), regionToSplit.getContinentID());
        boolean widerThanTall = regionToSplit.getRect().width > regionToSplit.getRect().height;
        int bestSplitPoint = 1;
        int closestFertility = 0;
        int cumulativeFertility = 0;
        int highestPointToTry = widerThanTall ? (int)regionToSplit.getRect().width : (int)regionToSplit.getRect().height;
        IntRange pointsToTry = new IntRange(1, highestPointToTry);
        int halfwayPoint = highestPointToTry / 2;
        int splitPoint = pointsToTry.getFirst();
        if (splitPoint <= (n = pointsToTry.getLast())) {
            while (true) {
                int n2;
                int n3;
                int n4;
                Tile it;
                int n5;
                Tile tile;
                Iterator<Tile> iterator2;
                int n6;
                int n7;
                Sequence<Tile> sequence;
                Sequence<Tile> nextRect;
                Sequence<Tile> sequence2 = nextRect = widerThanTall ? splitOffRegion.getTileMap().getTilesInRectangle(new Rectangle(splitOffRegion.getRect().x + (float)splitPoint - 1.0f, splitOffRegion.getRect().y, 1.0f, splitOffRegion.getRect().height)) : splitOffRegion.getTileMap().getTilesInRectangle(new Rectangle(splitOffRegion.getRect().x, splitOffRegion.getRect().y + (float)splitPoint - 1.0f, splitOffRegion.getRect().width, 1.0f));
                if (splitOffRegion.getContinentID() == -1) {
                    sequence = nextRect;
                    n7 = cumulativeFertility;
                    n6 = 0;
                    iterator2 = sequence.iterator();
                    while (iterator2.hasNext()) {
                        Tile tile2 = tile = iterator2.next();
                        n5 = n6;
                        boolean bl = false;
                        n4 = MapRegionsKt.getTileFertility(it, false);
                        n6 = n5 + n4;
                    }
                    n5 = n6;
                    n3 = n7;
                    n2 = n5;
                } else {
                    sequence = nextRect;
                    n6 = 0;
                    iterator2 = sequence.iterator();
                    while (iterator2.hasNext()) {
                        it = tile = iterator2.next();
                        n5 = n6;
                        boolean bl = false;
                        n4 = it.getContinent() == splitOffRegion.getContinentID() ? MapRegionsKt.getTileFertility(it, true) : 0;
                        n6 = n5 + n4;
                    }
                    n5 = n6;
                    n3 = n7;
                    n2 = n5;
                }
                cumulativeFertility = n3 + n2;
                int bestSplitPointFertilityDeltaFromTarget = Math.abs(closestFertility - targetFertility);
                int currentSplitPointFertilityDeltaFromTarget = Math.abs(cumulativeFertility - targetFertility);
                if (currentSplitPointFertilityDeltaFromTarget < bestSplitPointFertilityDeltaFromTarget || currentSplitPointFertilityDeltaFromTarget == bestSplitPointFertilityDeltaFromTarget && Math.abs(halfwayPoint - splitPoint) < Math.abs(halfwayPoint - bestSplitPoint)) {
                    bestSplitPoint = splitPoint;
                    closestFertility = cumulativeFertility;
                }
                if (splitPoint == n) break;
                ++splitPoint;
            }
        }
        if (widerThanTall) {
            splitOffRegion.getRect().width = bestSplitPoint;
            regionToSplit.getRect().x = splitOffRegion.getRect().x + splitOffRegion.getRect().width;
            regionToSplit.getRect().width -= (float)bestSplitPoint;
        } else {
            splitOffRegion.getRect().height = bestSplitPoint;
            regionToSplit.getRect().y = splitOffRegion.getRect().y + splitOffRegion.getRect().height;
            regionToSplit.getRect().height -= (float)bestSplitPoint;
        }
        Region.updateTiles$default(splitOffRegion, false, 1, null);
        Region.updateTiles$default(regionToSplit, false, 1, null);
        return new Pair<Region, Region>(splitOffRegion, regionToSplit);
    }

    /*
     * Could not resolve type clashes
     * Iterators could be improved
     * Unable to fully structure code
     */
    public final void assignRegions(@NotNull TileMap tileMap, @NotNull List<Civilization> civilizations, @NotNull GameParameters gameParameters) {
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(civilizations, "civilizations");
        Intrinsics.checkNotNullParameter(gameParameters, "gameParameters");
        if (civilizations.isEmpty()) {
            return;
        }
        this.assignRegionTypes();
        for (Tile tile : tileMap.getValues()) {
            block86: {
                var7_12 = this.regions;
                var39_11 = tile;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Region)element$iv;
                    $i$a$-firstOrNull-MapRegions$assignRegions$newData$1 = false;
                    if (!it.getTiles().contains(tile)) continue;
                    v0 = element$iv;
                    break block86;
                }
                v0 = null;
            }
            var40_15 = this.ruleset;
            var41_20 = v0;
            var42_22 = var39_11;
            newData = new MapGenTileData(var42_22, var41_20, var40_15);
            ((Map)this.tileData).put(tile.getPosition(), newData);
        }
        $this$sortedBy$iv = this.regions;
        $i$f$sortedBy = false;
        sortedRegions = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Region it = (Region)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getTotalFertility());
                it = (Region)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getTotalFertility());
            }
        });
        for (Region region : sortedRegions) {
            RegionStartFinder.INSTANCE.findStart$core(region, this.tileData);
        }
        for (Region region : this.regions) {
            v1 = region.getStartPosition();
            Intrinsics.checkNotNull(v1);
            StartNormalizer.INSTANCE.normalizeStart(tileMap.get(v1), tileMap, this.tileData, this.ruleset, false);
        }
        $this$associateWith$iv = civilizations;
        $i$f$associateWith = false;
        result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        $this$associateWithTo$iv$iv = $this$associateWith$iv;
        $i$f$associateWithTo = false;
        for (E element$iv$iv : $this$associateWithTo$iv$iv) {
            var13_40 = (Civilization)element$iv$iv;
            var38_39 = element$iv$iv;
            var37_38 = result$iv;
            $i$a$-associateWith-MapRegions$assignRegions$civBiases$1 = false;
            v2 = this.ruleset.getNations().get(it.getCivName());
            Intrinsics.checkNotNull(v2);
            var39_11 = v2.getStartBias();
            var37_38.put(var38_39, var39_11);
        }
        civBiases = result$iv;
        $this$groupBy$iv = civBiases.entrySet();
        $i$f$groupBy = false;
        $this$associateWithTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        for (T element$iv$iv : $this$groupByTo$iv$iv) {
            $i$a$-associateWith-MapRegions$assignRegions$civBiases$1 = (Map.Entry)element$iv$iv;
            $i$a$-groupBy-MapRegions$assignRegions$civsByBiasType$1 = false;
            startBias = (ArrayList)$i$a$-associateWith-MapRegions$assignRegions$civBiases$1.getValue();
            if (gameParameters.getNoStartBias()) {
                v3 = BiasTypes.Random;
            } else {
                block87: {
                    $this$any$iv = startBias;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v4 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            bias = (String)element$iv;
                            $i$a$-any-MapRegions$assignRegions$civsByBiasType$1$1 = false;
                            if (!TranslationsKt.equalsPlaceholderText(bias, "Avoid []")) continue;
                            v4 = true;
                            break block87;
                        }
                        v4 = false;
                    }
                }
                v3 = v4 ? BiasTypes.Negative : (startBias.contains("Coast") ? BiasTypes.Coastal : (((Collection)startBias).isEmpty() == false ? BiasTypes.Positive : BiasTypes.Random));
            }
            key$iv$iv = v3;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$2$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                v5 /* !! */  = answer$iv$iv$iv;
            } else {
                v5 /* !! */  = value$iv$iv$iv;
            }
            list$iv$iv = (List)v5 /* !! */ ;
            $i$a$-associateWith-MapRegions$assignRegions$civBiases$1 = (Map.Entry)element$iv$iv;
            var37_38 = list$iv$iv;
            $i$a$-groupBy-MapRegions$assignRegions$civsByBiasType$2 = false;
            civ = (Civilization)$i$a$-associateWith-MapRegions$assignRegions$civBiases$1.getKey();
            var37_38.add(civ);
        }
        civsByBiasType = destination$iv$iv;
        v6 = (List<T>)civsByBiasType.get((Object)BiasTypes.Coastal);
        if (v6 == null) {
            v6 = coastBiasCivs = CollectionsKt.emptyList();
        }
        if (($this$groupByTo$iv$iv = (List)civsByBiasType.get((Object)BiasTypes.Positive)) == null) ** GOTO lbl-1000
        $i$f$groupByTo = $this$groupByTo$iv$iv;
        $i$f$sortedBy = false;
        destination$iv$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(civBiases){
            final /* synthetic */ Map $civBiases$inlined;
            {
                this.$civBiases$inlined = map2;
            }

            public final int compare(T a, T b) {
                Civilization it = (Civilization)a;
                boolean bl = false;
                ArrayList arrayList = (ArrayList)this.$civBiases$inlined.get(it);
                it = (Civilization)b;
                Comparable comparable = arrayList != null ? Integer.valueOf(arrayList.size()) : null;
                bl = false;
                ArrayList arrayList2 = (ArrayList)this.$civBiases$inlined.get(it);
                return ComparisonsKt.compareValues(comparable, (Comparable)(arrayList2 != null ? Integer.valueOf(arrayList2.size()) : null));
            }
        });
        if (destination$iv$iv != null) {
            v7 = destination$iv$iv;
        } else lbl-1000:
        // 2 sources

        {
            v7 = CollectionsKt.emptyList();
        }
        positiveBiasCivs = v7;
        destination$iv$iv = (List)civsByBiasType.get((Object)BiasTypes.Negative);
        if (destination$iv$iv == null) ** GOTO lbl-1000
        $i$f$sortedBy = destination$iv$iv;
        $i$f$sortedByDescending = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(civBiases){
            final /* synthetic */ Map $civBiases$inlined;
            {
                this.$civBiases$inlined = map2;
            }

            public final int compare(T a, T b) {
                Civilization it = (Civilization)b;
                boolean bl = false;
                ArrayList arrayList = (ArrayList)this.$civBiases$inlined.get(it);
                it = (Civilization)a;
                Comparable comparable = arrayList != null ? Integer.valueOf(arrayList.size()) : null;
                bl = false;
                ArrayList arrayList2 = (ArrayList)this.$civBiases$inlined.get(it);
                return ComparisonsKt.compareValues(comparable, (Comparable)(arrayList2 != null ? Integer.valueOf(arrayList2.size()) : null));
            }
        });
        if ($this$sortedBy$iv != null) {
            v8 = $this$sortedBy$iv;
        } else lbl-1000:
        // 2 sources

        {
            v8 = CollectionsKt.emptyList();
        }
        negativeBiasCivs = v8;
        $this$sortedBy$iv = (List)civsByBiasType.get((Object)BiasTypes.Random);
        randomCivs = $this$sortedBy$iv != null && ($this$sortedByDescending$iv = CollectionsKt.toMutableList($this$sortedBy$iv)) != null ? $this$sortedByDescending$iv : (List<T>)new ArrayList<E>();
        positiveBiasFallbackCivs = new ArrayList<E>();
        unpickedRegions = CollectionsKt.toMutableList((Collection)this.regions);
        for (Civilization civ : coastBiasCivs) {
            $this$filter$iv = unpickedRegions;
            $i$f$filter = false;
            $i$f$any = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (E element$iv$iv : $this$filterTo$iv$iv) {
                it = (Region)element$iv$iv /* !! */ ;
                $i$a$-filter-MapRegions$assignRegions$startRegion$1 = false;
                v9 = it.getStartPosition();
                Intrinsics.checkNotNull(v9);
                if (!tileMap.get(v9).isCoastalTile()) continue;
                destination$iv$iv.add(element$iv$iv /* !! */ );
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v10 = null;
            } else {
                maxElem$iv /* !! */  = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v10 = maxElem$iv /* !! */ ;
                } else {
                    it = (Region)maxElem$iv /* !! */ ;
                    $i$a$-maxByOrNull-MapRegions$assignRegions$startRegion$2 = false;
                    v11 = it.getTerrainCounts().get("Coastal");
                    if (v11 == null) {
                        v11 = 0;
                    }
                    element$iv$iv /* !! */  = v11;
                    Intrinsics.checkNotNull(element$iv$iv /* !! */ );
                    maxValue$iv = Integer.valueOf(((Number)element$iv$iv /* !! */ ).intValue());
                    do {
                        e$iv /* !! */  = iterator$iv.next();
                        it = (Region)e$iv /* !! */ ;
                        $i$a$-maxByOrNull-MapRegions$assignRegions$startRegion$2 = false;
                        v12 = it.getTerrainCounts().get("Coastal");
                        if (v12 == null) {
                            v12 = 0;
                        }
                        $i$a$-filter-MapRegions$assignRegions$startRegion$1 = v12;
                        Intrinsics.checkNotNull($i$a$-filter-MapRegions$assignRegions$startRegion$1);
                        v$iv = Integer.valueOf(((Number)$i$a$-filter-MapRegions$assignRegions$startRegion$1).intValue());
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv /* !! */  = e$iv /* !! */ ;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v10 = maxElem$iv /* !! */ ;
                }
            }
            startRegion = (Region)v10;
            if (startRegion != null) {
                this.logAssignRegion(true, BiasTypes.Coastal, civ, startRegion);
                this.assignCivToRegion(civ, startRegion);
                unpickedRegions.remove(startRegion);
                continue;
            }
            $this$filter$iv = unpickedRegions;
            $i$f$filter = false;
            iterator$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (E element$iv$iv : $this$filterTo$iv$iv) {
                block88: {
                    it = (Region)element$iv$iv /* !! */ ;
                    $i$a$-filter-MapRegions$assignRegions$1 = false;
                    v13 = it.getStartPosition();
                    Intrinsics.checkNotNull(v13);
                    $this$any$iv = tileMap.get(v13).getNeighbors();
                    $i$f$any = false;
                    answer$iv$iv$iv = $this$any$iv.iterator();
                    while (answer$iv$iv$iv.hasNext()) {
                        element$iv /* !! */  = answer$iv$iv$iv.next();
                        neighbor = (Tile)element$iv /* !! */ ;
                        $i$a$-any-MapRegions$assignRegions$1$1 = false;
                        if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)neighbor.getBaseTerrain(), UniqueType.FreshWater, null, 2, null)) continue;
                        v14 = true;
                        break block88;
                    }
                    v14 = false;
                }
                if (!v14) continue;
                destination$iv$iv.add(element$iv$iv /* !! */ );
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v15 = null;
            } else {
                maxElem$iv /* !! */  = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v15 = maxElem$iv /* !! */ ;
                } else {
                    it = (Region)maxElem$iv /* !! */ ;
                    $i$a$-maxByOrNull-MapRegions$assignRegions$2 = false;
                    v16 = it.getTerrainCounts().get("Coastal");
                    if (v16 == null) {
                        v16 = 0;
                    }
                    element$iv$iv /* !! */  = v16;
                    Intrinsics.checkNotNull(element$iv$iv /* !! */ );
                    maxValue$iv = Integer.valueOf(((Number)element$iv$iv /* !! */ ).intValue());
                    do {
                        e$iv /* !! */  = iterator$iv.next();
                        it = (Region)e$iv /* !! */ ;
                        $i$a$-maxByOrNull-MapRegions$assignRegions$2 = false;
                        v17 = it.getTerrainCounts().get("Coastal");
                        if (v17 == null) {
                            v17 = 0;
                        }
                        $i$a$-filter-MapRegions$assignRegions$1 = v17;
                        Intrinsics.checkNotNull($i$a$-filter-MapRegions$assignRegions$1);
                        v$iv = Integer.valueOf(((Number)$i$a$-filter-MapRegions$assignRegions$1).intValue());
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv /* !! */  = e$iv /* !! */ ;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v15 = maxElem$iv /* !! */ ;
                }
            }
            startRegion = (Region)v15;
            if (startRegion != null) {
                this.logAssignRegion(true, BiasTypes.Coastal, civ, startRegion);
                this.assignCivToRegion(civ, startRegion);
                unpickedRegions.remove(startRegion);
                continue;
            }
            $this$filter$iv = unpickedRegions;
            $i$f$filter = false;
            iterator$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (E element$iv$iv : $this$filterTo$iv$iv) {
                it = (Region)element$iv$iv /* !! */ ;
                $i$a$-filter-MapRegions$assignRegions$3 = false;
                v18 = it.getStartPosition();
                Intrinsics.checkNotNull(v18);
                if (!tileMap.get(v18).isAdjacentToRiver()) continue;
                destination$iv$iv.add(element$iv$iv /* !! */ );
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v19 /* !! */  = null;
            } else {
                maxElem$iv /* !! */  = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v19 /* !! */  = maxElem$iv /* !! */ ;
                } else {
                    it = (Region)maxElem$iv /* !! */ ;
                    $i$a$-maxByOrNull-MapRegions$assignRegions$4 = false;
                    v20 = it.getTerrainCounts().get("Coastal");
                    if (v20 == null) {
                        v20 = 0;
                    }
                    element$iv$iv /* !! */  = v20;
                    Intrinsics.checkNotNull(element$iv$iv /* !! */ );
                    maxValue$iv = Integer.valueOf(((Number)element$iv$iv /* !! */ ).intValue());
                    do {
                        e$iv /* !! */  = iterator$iv.next();
                        it = (Region)e$iv /* !! */ ;
                        $i$a$-maxByOrNull-MapRegions$assignRegions$4 = false;
                        v21 = it.getTerrainCounts().get("Coastal");
                        if (v21 == null) {
                            v21 = 0;
                        }
                        $i$a$-filter-MapRegions$assignRegions$3 = v21;
                        Intrinsics.checkNotNull($i$a$-filter-MapRegions$assignRegions$3);
                        v$iv = Integer.valueOf(((Number)$i$a$-filter-MapRegions$assignRegions$3).intValue());
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv /* !! */  = e$iv /* !! */ ;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v19 /* !! */  = maxElem$iv /* !! */ ;
                }
            }
            startRegion = (Region)v19 /* !! */ ;
            if (startRegion != null) {
                this.logAssignRegion(true, BiasTypes.Coastal, civ, startRegion);
                this.assignCivToRegion(civ, startRegion);
                unpickedRegions.remove(startRegion);
                continue;
            }
            $this$filter$iv = unpickedRegions;
            $i$f$filter = false;
            iterator$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (E element$iv$iv : $this$filterTo$iv$iv) {
                block89: {
                    it = (Region)element$iv$iv /* !! */ ;
                    $i$a$-filter-MapRegions$assignRegions$5 = false;
                    v22 = it.getStartPosition();
                    Intrinsics.checkNotNull(v22);
                    $this$any$iv = tileMap.get(v22).getNeighbors();
                    $i$f$any = false;
                    answer$iv$iv$iv = $this$any$iv.iterator();
                    while (answer$iv$iv$iv.hasNext()) {
                        element$iv /* !! */  = answer$iv$iv$iv.next();
                        neighbor = (Tile)element$iv /* !! */ ;
                        $i$a$-any-MapRegions$assignRegions$5$1 = false;
                        if (!neighbor.isAdjacentToRiver()) continue;
                        v23 = true;
                        break block89;
                    }
                    v23 = false;
                }
                if (!v23) continue;
                destination$iv$iv.add(element$iv$iv /* !! */ );
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v24 /* !! */  = null;
            } else {
                maxElem$iv /* !! */  = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v24 /* !! */  = maxElem$iv /* !! */ ;
                } else {
                    it = (Region)maxElem$iv /* !! */ ;
                    $i$a$-maxByOrNull-MapRegions$assignRegions$6 = false;
                    v25 = it.getTerrainCounts().get("Coastal");
                    if (v25 == null) {
                        v25 = 0;
                    }
                    element$iv$iv /* !! */  = v25;
                    Intrinsics.checkNotNull(element$iv$iv /* !! */ );
                    maxValue$iv = Integer.valueOf(((Number)element$iv$iv /* !! */ ).intValue());
                    do {
                        e$iv /* !! */  = iterator$iv.next();
                        it = (Region)e$iv /* !! */ ;
                        $i$a$-maxByOrNull-MapRegions$assignRegions$6 = false;
                        v26 = it.getTerrainCounts().get("Coastal");
                        if (v26 == null) {
                            v26 = 0;
                        }
                        $i$a$-filter-MapRegions$assignRegions$5 = v26;
                        Intrinsics.checkNotNull($i$a$-filter-MapRegions$assignRegions$5);
                        v$iv = Integer.valueOf(((Number)$i$a$-filter-MapRegions$assignRegions$5).intValue());
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv /* !! */  = e$iv /* !! */ ;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v24 /* !! */  = maxElem$iv /* !! */ ;
                }
            }
            startRegion = (Region)v24 /* !! */ ;
            if (startRegion != null) {
                this.logAssignRegion(true, BiasTypes.Coastal, civ, startRegion);
                this.assignCivToRegion(civ, startRegion);
                unpickedRegions.remove(startRegion);
                continue;
            }
            MapRegions.logAssignRegion$default(this, false, BiasTypes.Coastal, civ, null, 8, null);
            randomCivs.add(civ);
        }
        for (Civilization civ : positiveBiasCivs) {
            v27 = civBiases.get(civ);
            Intrinsics.checkNotNull(v27);
            preferred = (ArrayList)v27;
            $this$filter$iv = unpickedRegions;
            $i$f$filter = false;
            maxElem$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Region)element$iv$iv;
                $i$a$-filter-MapRegions$assignRegions$startRegion$3 = false;
                if (!preferred.contains(it.getType())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v28 = null;
            } else {
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v28 = maxElem$iv;
                } else {
                    it = (Region)maxElem$iv;
                    $i$a$-maxByOrNull-MapRegions$assignRegions$startRegion$4 = false;
                    $this$filterKeys$iv = it.getTerrainCounts();
                    $i$f$filterKeys = false;
                    result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        terrain = (String)entry$iv.getKey();
                        $i$a$-filterKeys-MapRegions$assignRegions$startRegion$4$1 = false;
                        if (!preferred.contains(terrain)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    maxValue$iv = CollectionsKt.sumOfInt((Iterable<Integer>)((Map)result$iv).values());
                    do {
                        e$iv = iterator$iv.next();
                        it = (Region)e$iv;
                        $i$a$-maxByOrNull-MapRegions$assignRegions$startRegion$4 = false;
                        $this$filterKeys$iv = it.getTerrainCounts();
                        $i$f$filterKeys = false;
                        result$iv = new LinkedHashMap<K, V>();
                        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                            terrain = (String)entry$iv.getKey();
                            $i$a$-filterKeys-MapRegions$assignRegions$startRegion$4$1 = false;
                            if (!preferred.contains(terrain)) continue;
                            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        v$iv = CollectionsKt.sumOfInt((Iterable<Integer>)((Map)result$iv).values());
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v28 = maxElem$iv;
                }
            }
            startRegion = v28;
            if (startRegion != null) {
                this.logAssignRegion(true, BiasTypes.Positive, civ, (Region)startRegion);
                this.assignCivToRegion(civ, (Region)startRegion);
                unpickedRegions.remove(startRegion);
                continue;
            }
            if (preferred.size() == 1) {
                positiveBiasFallbackCivs.add(civ);
                continue;
            }
            MapRegions.logAssignRegion$default(this, false, BiasTypes.Positive, civ, null, 8, null);
            randomCivs.add(civ);
        }
        for (Civilization civ : positiveBiasFallbackCivs) {
            v29 = civBiases.get(civ);
            Intrinsics.checkNotNull(v29);
            startRegion = this.getFallbackRegion((String)CollectionsKt.first((List)v29), unpickedRegions);
            this.logAssignRegion(true, BiasTypes.PositiveFallback, civ, startRegion);
            this.assignCivToRegion(civ, startRegion);
            unpickedRegions.remove(startRegion);
        }
        for (Civilization civ : negativeBiasCivs) {
            v30 = civBiases.get(civ);
            Intrinsics.checkNotNull(v30);
            startRegion = (Iterable)v30;
            $i$f$partition = false;
            first$iv = new ArrayList<T>();
            second$iv = new ArrayList<T>();
            for (T element$iv : $this$partition$iv) {
                bias = (String)element$iv;
                $i$a$-partition-MapRegions$assignRegions$7 = false;
                if (TranslationsKt.equalsPlaceholderText(bias, "Avoid []")) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            startRegion = new Pair<ArrayList<E>, ArrayList<E>>(first$iv, second$iv);
            avoidBias = startRegion.component1();
            preferred = startRegion.component2();
            $this$map$iv = avoidBias;
            $i$f$map = false;
            element$iv = $this$map$iv;
            destination$iv$iv /* !! */  = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                $i$f$filterKeys = (String)item$iv$iv;
                var37_38 = destination$iv$iv /* !! */ ;
                $i$a$-map-MapRegions$assignRegions$avoided$1 = false;
                var37_38.add(TranslationsKt.getPlaceholderParameters((String)it).get(0));
            }
            avoided = (List)destination$iv$iv /* !! */ ;
            $this$filterNot$iv = unpickedRegions;
            $i$f$filterNot = false;
            destination$iv$iv /* !! */  = $this$filterNot$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterNotTo = false;
            item$iv$iv = $this$filterNotTo$iv$iv.iterator();
            while (item$iv$iv.hasNext()) {
                element$iv$iv = item$iv$iv.next();
                it = (Region)element$iv$iv;
                $i$a$-filterNot-MapRegions$assignRegions$startRegion$5 = false;
                if (avoided.contains(it.getType())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v31 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v31 = minElem$iv;
                } else {
                    it = (Region)minElem$iv;
                    $i$a$-minByOrNull-MapRegions$assignRegions$startRegion$6 = false;
                    element$iv$iv = it.getTerrainCounts();
                    it = 2;
                    $i$f$filterKeys = false;
                    result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        terrain = (String)entry$iv.getKey();
                        $i$a$-filterKeys-MapRegions$assignRegions$startRegion$6$1 = false;
                        if (!avoided.contains(terrain)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    var34_168 = result$iv;
                    it * CollectionsKt.sumOfInt((Iterable<Integer>)var34_168.values());
                    $this$filterKeys$iv = it.getTerrainCounts();
                    $i$f$filterKeys = false;
                    result$iv = new LinkedHashMap<K, V>();
                    for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                        terrain = (String)entry$iv.getKey();
                        $i$a$-filterKeys-MapRegions$assignRegions$startRegion$6$2 = false;
                        if (!preferred.contains(terrain)) continue;
                        result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                    }
                    minValue$iv = -CollectionsKt.sumOfInt((Iterable<Integer>)((Map)result$iv).values());
                    do {
                        e$iv = iterator$iv.next();
                        it = (Region)e$iv;
                        $i$a$-minByOrNull-MapRegions$assignRegions$startRegion$6 = false;
                        $i$f$filterKeys = it.getTerrainCounts();
                        var29_155 = 2;
                        $i$f$filterKeys = false;
                        result$iv = new LinkedHashMap<K, V>();
                        for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                            terrain = (String)entry$iv.getKey();
                            $i$a$-filterKeys-MapRegions$assignRegions$startRegion$6$1 = false;
                            if (!avoided.contains(terrain)) continue;
                            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        var36_170 = result$iv;
                        var29_155 * CollectionsKt.sumOfInt((Iterable<Integer>)var36_170.values());
                        $this$filterKeys$iv = it.getTerrainCounts();
                        $i$f$filterKeys = false;
                        result$iv = new LinkedHashMap<K, V>();
                        for (Map.Entry<K, V> entry$iv : $this$filterKeys$iv.entrySet()) {
                            terrain = (String)entry$iv.getKey();
                            $i$a$-filterKeys-MapRegions$assignRegions$startRegion$6$2 = false;
                            if (!preferred.contains(terrain)) continue;
                            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                        }
                        v$iv = -CollectionsKt.sumOfInt((Iterable<Integer>)((Map)result$iv).values());
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v31 = minElem$iv;
                }
            }
            startRegion = v31;
            if (startRegion != null) {
                this.logAssignRegion(true, BiasTypes.Negative, civ, startRegion);
                this.assignCivToRegion(civ, startRegion);
                unpickedRegions.remove(startRegion);
                continue;
            }
            MapRegions.logAssignRegion$default(this, false, BiasTypes.Negative, civ, null, 8, null);
            randomCivs.add(civ);
        }
        for (Civilization civ : randomCivs) {
            startRegion = (Region)CollectionsKt.random((Collection)unpickedRegions, Random.Default);
            this.logAssignRegion(true, BiasTypes.Random, civ, startRegion);
            this.assignCivToRegion(civ, startRegion);
            unpickedRegions.remove(startRegion);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assignRegionTypes() {
        void $this$filterTo$iv$iv;
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Terrain it = (Terrain)element$iv$iv;
            boolean bl = false;
            if (!(MapRegionsKt.getRegionPriority(it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List<Terrain> regionTypes = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Terrain it = (Terrain)a;
                boolean bl = false;
                Comparable comparable = MapRegionsKt.getRegionPriority(it);
                it = (Terrain)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)MapRegionsKt.getRegionPriority(it));
            }
        });
        block1: for (Region region : this.regions) {
            region.countTerrains();
            for (Terrain type2 : regionTypes) {
                boolean bl;
                Unique it;
                Object element$iv;
                Iterator iterator2;
                boolean $i$f$any;
                Sequence $this$any$iv;
                block8: {
                    boolean bl2;
                    block7: {
                        Intrinsics.checkNotNull(type2);
                        $this$any$iv = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)type2, UniqueType.RegionRequireFirstLessThanSecond, null, 2, null);
                        $i$f$any = false;
                        iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            element$iv = iterator2.next();
                            it = (Unique)element$iv;
                            boolean bl3 = false;
                            if (!(region.getTerrainAmount(it.getParams().get(0)) >= region.getTerrainAmount(it.getParams().get(1)))) continue;
                            bl2 = true;
                            break block7;
                        }
                        bl2 = false;
                    }
                    if (bl2) continue;
                    $this$any$iv = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)type2, UniqueType.RegionRequirePercentSingleType, null, 2, null);
                    $i$f$any = false;
                    iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        it = (Unique)element$iv;
                        boolean bl4 = false;
                        if (!(region.getTerrainAmount(it.getParams().get(1)) >= Integer.parseInt(it.getParams().get(0)) * region.getTiles().size() / 100)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
                if (!bl) {
                    boolean bl3;
                    block9: {
                        $this$any$iv = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)type2, UniqueType.RegionRequirePercentTwoTypes, null, 2, null);
                        $i$f$any = false;
                        iterator2 = $this$any$iv.iterator();
                        while (iterator2.hasNext()) {
                            element$iv = iterator2.next();
                            it = (Unique)element$iv;
                            boolean bl6 = false;
                            if (!(region.getTerrainAmount(it.getParams().get(1)) + region.getTerrainAmount(it.getParams().get(2)) >= Integer.parseInt(it.getParams().get(0)) * region.getTiles().size() / 100)) continue;
                            bl3 = true;
                            break block9;
                        }
                        bl3 = false;
                    }
                    if (!bl3) continue;
                }
                region.setType(type2.getName());
                continue block1;
            }
        }
    }

    private final void logAssignRegion(boolean success, BiasTypes startBiasType, Civilization civ, Region region) {
        if (Log.INSTANCE.getBackend().isRelease()) {
            return;
        }
        Function0 logCiv2 = new Function0<String>(civ, this){
            final /* synthetic */ Civilization $civ;
            final /* synthetic */ MapRegions this$0;
            {
                this.$civ = $civ;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                StringBuilder stringBuilder = new StringBuilder().append(this.$civ.getCivName()).append(' ');
                Nation nation2 = this.this$0.getRuleset().getNations().get(this.$civ.getCivName());
                Intrinsics.checkNotNull(nation2);
                return stringBuilder.append(CollectionsKt.joinToString$default(nation2.getStartBias(), ",", "(", ")", 0, null, null, 56, null)).toString();
            }
        };
        String msg = success ? "(%s): %s to %s" : "no region (%s) found for %s";
        Object[] objectArray = new Object[]{startBiasType, logCiv2, region};
        Log.INSTANCE.debug(new Tag("assignRegions"), msg, objectArray);
    }

    static /* synthetic */ void logAssignRegion$default(MapRegions mapRegions, boolean bl, BiasTypes biasTypes, Civilization civilization, Region region, int n, Object object) {
        if ((n & 8) != 0) {
            region = null;
        }
        mapRegions.logAssignRegion(bl, biasTypes, civilization, region);
    }

    private final void assignCivToRegion(Civilization civ, Region region) {
        TileMap tileMap = region.getTileMap();
        Vector2 vector2 = region.getStartPosition();
        Intrinsics.checkNotNull(vector2);
        Tile tile = tileMap.get(vector2);
        TileMap.addStartingLocation$default(region.getTileMap(), civ.getCivName(), tile, null, 4, null);
        this.tileData.placeImpact(ImpactType.MinorCiv, tile, 6);
        this.tileData.placeImpact(ImpactType.Luxury, tile, 3);
        this.tileData.placeImpact(ImpactType.Strategic, tile, 0);
        this.tileData.placeImpact(ImpactType.Bonus, tile, 3);
    }

    private final Region getFallbackRegion(String type2, List<Region> candidates2) {
        Object v0;
        Iterable $this$maxByOrNull$iv = candidates2;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Region it = (Region)maxElem$iv;
                boolean bl = false;
                Integer n = it.getTerrainCounts().get(type2);
                if (n == null) {
                    n = 0;
                }
                Integer n2 = n;
                Intrinsics.checkNotNull(n2);
                Comparable maxValue$iv = Integer.valueOf(((Number)n2).intValue());
                do {
                    Object e$iv = iterator$iv.next();
                    Region it2 = (Region)e$iv;
                    $i$a$-maxByOrNull-MapRegions$getFallbackRegion$1 = false;
                    Integer n3 = it2.getTerrainCounts().get(type2);
                    if (n3 == null) {
                        n3 = 0;
                    }
                    Integer n4 = n3;
                    Intrinsics.checkNotNull(n4);
                    Comparable v$iv = Integer.valueOf(((Number)n4).intValue());
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    public final void placeResourcesAndMinorCivs(@NotNull TileMap tileMap, @NotNull List<Civilization> minorCivs) {
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        Intrinsics.checkNotNullParameter(minorCivs, "minorCivs");
        this.placeNaturalWonderImpacts(tileMap);
        Pair<List<String>, List<String>> pair = LuxuryResourcePlacementLogic.INSTANCE.assignLuxuries(this.regions, this.tileData, this.ruleset);
        List<String> cityStateLuxuries = pair.component1();
        List<String> randomLuxuries = pair.component2();
        MinorCivPlacer.INSTANCE.placeMinorCivs((List<Region>)this.regions, tileMap, minorCivs, this.tileData, this.ruleset);
        LuxuryResourcePlacementLogic.INSTANCE.placeLuxuries(this.regions, tileMap, this.tileData, this.ruleset, cityStateLuxuries, randomLuxuries);
        StrategicBonusResourcePlacementLogic.INSTANCE.placeStrategicAndBonuses$core(tileMap, this.regions, this.tileData);
    }

    /*
     * WARNING - void declaration
     */
    private final void placeNaturalWonderImpacts(TileMap tileMap) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = tileMap.getValues();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl = false;
            if (!it.isNaturalWonder()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (Tile tile : (List)destination$iv$iv) {
            this.tileData.placeImpact(ImpactType.Bonus, tile, 1);
            this.tileData.placeImpact(ImpactType.Strategic, tile, 1);
            this.tileData.placeImpact(ImpactType.Luxury, tile, 1);
            this.tileData.placeImpact(ImpactType.MinorCiv, tile, 1);
        }
    }

    static {
        Serializable[] serializableArray = new Pair[]{TuplesKt.to(1, 1), TuplesKt.to(2, 4), TuplesKt.to(3, 4)};
        minimumFoodForRing = MapsKt.mapOf(serializableArray);
        serializableArray = new Pair[]{TuplesKt.to(1, 0), TuplesKt.to(2, 0), TuplesKt.to(3, 2)};
        minimumProdForRing = MapsKt.mapOf(serializableArray);
        serializableArray = new Pair[]{TuplesKt.to(1, 3), TuplesKt.to(2, 6), TuplesKt.to(3, 8)};
        minimumGoodForRing = MapsKt.mapOf(serializableArray);
        serializableArray = new Integer[]{0, 8, 14, 19, 22, 24, 25};
        firstRingFoodScores = CollectionsKt.listOf(serializableArray);
        serializableArray = new Integer[]{0, 10, 16, 20, 20, 12, 0};
        firstRingProdScores = CollectionsKt.listOf(serializableArray);
        serializableArray = new Integer[]{0, 2, 5, 10, 20, 25, 28, 30, 32, 34, 35};
        secondRingFoodScores = CollectionsKt.listOf(serializableArray);
        serializableArray = new Integer[]{0, 10, 20, 25, 30, 35};
        secondRingProdScores = CollectionsKt.listOf(serializableArray);
        serializableArray = new Pair[]{TuplesKt.to(0, 99), TuplesKt.to(1, 97), TuplesKt.to(2, 95), TuplesKt.to(3, 92), TuplesKt.to(4, 89), TuplesKt.to(5, 69), TuplesKt.to(6, 57), TuplesKt.to(7, 24), TuplesKt.to(8, 20), TuplesKt.to(9, 16), TuplesKt.to(10, 12), TuplesKt.to(11, 8), TuplesKt.to(12, 6), TuplesKt.to(13, 4)};
        closeStartPenaltyForRing = MapsKt.mapOf(serializableArray);
        serializableArray = new Pair[8];
        serializableArray[0] = TuplesKt.to(1, CollectionsKt.listOf(Float.valueOf(1.0f)));
        Float[] floatArray = new Float[]{Float.valueOf(0.55f), Float.valueOf(0.45f)};
        serializableArray[1] = TuplesKt.to(2, CollectionsKt.listOf(floatArray));
        floatArray = new Float[]{Float.valueOf(0.4f), Float.valueOf(0.33f), Float.valueOf(0.27f)};
        serializableArray[2] = TuplesKt.to(3, CollectionsKt.listOf(floatArray));
        floatArray = new Float[]{Float.valueOf(0.35f), Float.valueOf(0.25f), Float.valueOf(0.25f), Float.valueOf(0.15f)};
        serializableArray[3] = TuplesKt.to(4, CollectionsKt.listOf(floatArray));
        floatArray = new Float[]{Float.valueOf(0.25f), Float.valueOf(0.25f), Float.valueOf(0.2f), Float.valueOf(0.15f), Float.valueOf(0.15f)};
        serializableArray[4] = TuplesKt.to(5, CollectionsKt.listOf(floatArray));
        floatArray = new Float[]{Float.valueOf(0.2f), Float.valueOf(0.2f), Float.valueOf(0.2f), Float.valueOf(0.15f), Float.valueOf(0.15f), Float.valueOf(0.1f)};
        serializableArray[5] = TuplesKt.to(6, CollectionsKt.listOf(floatArray));
        floatArray = new Float[]{Float.valueOf(0.2f), Float.valueOf(0.2f), Float.valueOf(0.15f), Float.valueOf(0.15f), Float.valueOf(0.1f), Float.valueOf(0.1f), Float.valueOf(0.1f)};
        serializableArray[6] = TuplesKt.to(7, CollectionsKt.listOf(floatArray));
        floatArray = new Float[]{Float.valueOf(0.2f), Float.valueOf(0.15f), Float.valueOf(0.15f), Float.valueOf(0.1f), Float.valueOf(0.1f), Float.valueOf(0.1f), Float.valueOf(0.1f), Float.valueOf(0.1f)};
        serializableArray[7] = TuplesKt.to(8, CollectionsKt.listOf(floatArray));
        randomLuxuryRatios = MapsKt.mapOf(serializableArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/MapRegions$BiasTypes;", "", "(Ljava/lang/String;I)V", "Coastal", "Positive", "Negative", "Random", "PositiveFallback", "core"})
    private static final class BiasTypes
    extends Enum<BiasTypes> {
        public static final /* enum */ BiasTypes Coastal = new BiasTypes();
        public static final /* enum */ BiasTypes Positive = new BiasTypes();
        public static final /* enum */ BiasTypes Negative = new BiasTypes();
        public static final /* enum */ BiasTypes Random = new BiasTypes();
        public static final /* enum */ BiasTypes PositiveFallback = new BiasTypes();
        private static final /* synthetic */ BiasTypes[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BiasTypes[] values() {
            return (BiasTypes[])$VALUES.clone();
        }

        public static BiasTypes valueOf(String value) {
            return Enum.valueOf(BiasTypes.class, value);
        }

        @NotNull
        public static EnumEntries<BiasTypes> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = biasTypesArray = new BiasTypes[]{BiasTypes.Coastal, BiasTypes.Positive, BiasTypes.Negative, BiasTypes.Random, BiasTypes.PositiveFallback};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\bR\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\bR\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR#\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\n0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bR\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/MapRegions$Companion;", "", "()V", "baseMinorDepositFrequency", "", "closeStartPenaltyForRing", "", "getCloseStartPenaltyForRing", "()Ljava/util/Map;", "firstRingFoodScores", "", "getFirstRingFoodScores", "()Ljava/util/List;", "firstRingProdScores", "getFirstRingProdScores", "maximumJunk", "minimumFoodForRing", "getMinimumFoodForRing", "minimumGoodForRing", "getMinimumGoodForRing", "minimumProdForRing", "getMinimumProdForRing", "randomLuxuryRatios", "", "getRandomLuxuryRatios", "secondRingFoodScores", "getSecondRingFoodScores", "secondRingProdScores", "getSecondRingProdScores", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Integer, Integer> getMinimumFoodForRing() {
            return minimumFoodForRing;
        }

        @NotNull
        public final Map<Integer, Integer> getMinimumProdForRing() {
            return minimumProdForRing;
        }

        @NotNull
        public final Map<Integer, Integer> getMinimumGoodForRing() {
            return minimumGoodForRing;
        }

        @NotNull
        public final List<Integer> getFirstRingFoodScores() {
            return firstRingFoodScores;
        }

        @NotNull
        public final List<Integer> getFirstRingProdScores() {
            return firstRingProdScores;
        }

        @NotNull
        public final List<Integer> getSecondRingFoodScores() {
            return secondRingFoodScores;
        }

        @NotNull
        public final List<Integer> getSecondRingProdScores() {
            return secondRingProdScores;
        }

        @NotNull
        public final Map<Integer, Integer> getCloseStartPenaltyForRing() {
            return closeStartPenaltyForRing;
        }

        @NotNull
        public final Map<Integer, List<Float>> getRandomLuxuryRatios() {
            return randomLuxuryRatios;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/unciv/logic/map/mapgenerator/mapregions/MapRegions$ImpactType;", "", "(Ljava/lang/String;I)V", "Strategic", "Luxury", "Bonus", "MinorCiv", "core"})
    public static final class ImpactType
    extends Enum<ImpactType> {
        public static final /* enum */ ImpactType Strategic = new ImpactType();
        public static final /* enum */ ImpactType Luxury = new ImpactType();
        public static final /* enum */ ImpactType Bonus = new ImpactType();
        public static final /* enum */ ImpactType MinorCiv = new ImpactType();
        private static final /* synthetic */ ImpactType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ImpactType[] values() {
            return (ImpactType[])$VALUES.clone();
        }

        public static ImpactType valueOf(String value) {
            return Enum.valueOf(ImpactType.class, value);
        }

        @NotNull
        public static EnumEntries<ImpactType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = impactTypeArray = new ImpactType[]{ImpactType.Strategic, ImpactType.Luxury, ImpactType.Bonus, ImpactType.MinorCiv};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

