/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.map.mapgenerator.mapregions;

import com.unciv.logic.map.mapgenerator.mapregions.MapRegionsKt;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TerrainType;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u0017\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u001a\u0018\u0010\b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0012\u0010\u000f\u001a\u00020\u0004*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f\u00a8\u0006\u0012"}, d2={"anonymizeUnique", "Lcom/unciv/models/ruleset/unique/Unique;", "unique", "getRegionPriority", "", "terrain", "Lcom/unciv/models/ruleset/tile/Terrain;", "(Lcom/unciv/models/ruleset/tile/Terrain;)Ljava/lang/Integer;", "getTerrainRule", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "isWaterOnlyResource", "", "resource", "Lcom/unciv/models/ruleset/tile/TileResource;", "getTileFertility", "Lcom/unciv/logic/map/tile/Tile;", "checkCoasts", "core"})
@SourceDebugExtension(value={"SMAP\nMapRegions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapRegions.kt\ncom/unciv/logic/map/mapgenerator/mapregions/MapRegionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,521:1\n1#2:522\n1045#3:523\n1726#3,3:524\n766#3:527\n857#3,2:528\n*S KotlinDebug\n*F\n+ 1 MapRegions.kt\ncom/unciv/logic/map/mapgenerator/mapregions/MapRegionsKt\n*L\n503#1:523\n506#1:524,3\n516#1:527\n516#1:528,2\n*E\n"})
public final class MapRegionsKt {
    /*
     * WARNING - void declaration
     */
    public static final int getTileFertility(@NotNull Tile $this$getTileFertility, boolean checkCoasts) {
        Intrinsics.checkNotNullParameter($this$getTileFertility, "<this>");
        int fertility = 0;
        Iterator<Terrain> iterator2 = $this$getTileFertility.getAllTerrains().iterator();
        while (iterator2.hasNext()) {
            int n;
            Terrain terrain2 = iterator2.next();
            if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)terrain2, UniqueType.OverrideFertility, null, 2, null)) {
                return Integer.parseInt(((Unique)SequencesKt.first(IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)terrain2, UniqueType.OverrideFertility, null, 2, null))).getParams().get(0));
            }
            Sequence sequence = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)terrain2, UniqueType.AddFertility, null, 2, null);
            int n2 = fertility;
            int n3 = 0;
            Iterator iterator3 = sequence.iterator();
            while (iterator3.hasNext()) {
                void it;
                Object t = iterator3.next();
                Unique unique = (Unique)t;
                n = n3;
                boolean bl = false;
                int n4 = Integer.parseInt(it.getParams().get(0));
                n3 = n + n4;
            }
            n = n3;
            fertility = n2 + n;
        }
        if ($this$getTileFertility.isAdjacentToRiver()) {
            ++fertility;
        }
        if (Tile.isAdjacentTo$default($this$getTileFertility, "Fresh water", null, 2, null)) {
            ++fertility;
        }
        if (checkCoasts && $this$getTileFertility.isCoastalTile()) {
            fertility += 2;
        }
        return fertility;
    }

    @Nullable
    public static final Integer getRegionPriority(@Nullable Terrain terrain2) {
        if (terrain2 == null) {
            return 99999;
        }
        return !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)terrain2, UniqueType.RegionRequirePercentSingleType, null, 2, null) && !IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)terrain2, UniqueType.RegionRequirePercentTwoTypes, null, 2, null) ? null : (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)terrain2, UniqueType.RegionRequirePercentSingleType, null, 2, null) ? Integer.valueOf(Integer.parseInt(((Unique)SequencesKt.first(IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)terrain2, UniqueType.RegionRequirePercentSingleType, null, 2, null))).getParams().get(2))) : Integer.valueOf(Integer.parseInt(((Unique)SequencesKt.first(IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)terrain2, UniqueType.RegionRequirePercentTwoTypes, null, 2, null))).getParams().get(3))));
    }

    @NotNull
    public static final Unique anonymizeUnique(@NotNull Unique unique) {
        Intrinsics.checkNotNullParameter(unique, "unique");
        Iterable $this$sortedBy$iv = unique.getModifiers();
        boolean $i$f$sortedBy = false;
        return new Unique("RULE" + CollectionsKt.joinToString$default(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Unique it = (Unique)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getText());
                it = (Unique)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getText()));
            }
        }), " ", " ", null, 0, null, anonymizeUnique.2.INSTANCE, 28, null), null, null, 6, null);
    }

    public static final boolean isWaterOnlyResource(@NotNull TileResource resource2, @NotNull Ruleset ruleset2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(resource2, "resource");
            Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
            Iterable $this$all$iv = resource2.getTerrainsCanBeFoundOn();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String terrainName = (String)element$iv;
                    boolean bl2 = false;
                    Terrain terrain2 = ruleset2.getTerrains().get(terrainName);
                    Intrinsics.checkNotNull(terrain2);
                    if (terrain2.getType() == TerrainType.Water) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final Unique getTerrainRule(@NotNull Terrain terrain, @NotNull Ruleset ruleset) {
        block5: {
            block3: {
                block4: {
                    Intrinsics.checkNotNullParameter(terrain, "terrain");
                    Intrinsics.checkNotNullParameter(ruleset, "ruleset");
                    if (terrain.getType() != TerrainType.TerrainFeature) break block3;
                    if (!IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)terrain, UniqueType.VisibilityElevation, null, 2, null)) break block4;
                    v0 = new Unique("RULE <in [" + terrain.getName() + "] tiles>", null, null, 6, null);
                    break block5;
                }
                v1 = new StringBuilder().append("RULE <in [").append(terrain.getName()).append("] tiles> ");
                v2 = ruleset.getTerrains().values();
                Intrinsics.checkNotNullExpressionValue(v2, "<get-values>(...)");
                var2_2 = v2;
                var11_3 = v1;
                $i$f$filter = false;
                var4_5 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Terrain)element$iv$iv;
                    $i$a$-filter-MapRegionsKt$getTerrainRule$1 = false;
                    if (it.getType() != TerrainType.TerrainFeature) ** GOTO lbl-1000
                    Intrinsics.checkNotNull(it);
                    if (IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.VisibilityElevation, null, 2, null)) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = false;
                    }
                    if (!v3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var12_12 = null;
                var13_13 = 6;
                var14_14 = null;
                var15_15 = null;
                var16_16 = var11_3.append(CollectionsKt.joinToString$default((List)destination$iv$iv, " ", null, null, 0, null, getTerrainRule.2.INSTANCE, 30, null)).toString();
                v0 = new Unique(var16_16, var15_15, var14_14, var13_13, var12_12);
                break block5;
            }
            v0 = new Unique("RULE <in [Featureless] [" + terrain.getName() + "] tiles>", null, null, 6, null);
        }
        return v0;
    }
}

