/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.multiplayer.storage;

import com.unciv.UncivGame;
import com.unciv.json.UncivJsonKt;
import com.unciv.logic.GameInfo;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.files.UncivFiles;
import com.unciv.logic.multiplayer.ServerFeatureSet;
import com.unciv.logic.multiplayer.storage.DropBox;
import com.unciv.logic.multiplayer.storage.FileStorage;
import com.unciv.logic.multiplayer.storage.MultiplayerServer;
import com.unciv.logic.multiplayer.storage.SimpleHttp;
import com.unciv.logic.multiplayer.storage.UncivServerFileStorage;
import com.unciv.models.metadata.GameSettings;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003J\u0006\u0010\u0012\u001a\u00020\u0010J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u0016\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0086@\u00a2\u0006\u0002\u0010!J\u001e\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010$R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/unciv/logic/multiplayer/storage/MultiplayerServer;", "", "fileStorageIdentifier", "", "authenticationHeader", "", "(Ljava/lang/String;Ljava/util/Map;)V", "featureSet", "Lcom/unciv/logic/multiplayer/ServerFeatureSet;", "getFeatureSet$core", "()Lcom/unciv/logic/multiplayer/ServerFeatureSet;", "setFeatureSet$core", "(Lcom/unciv/logic/multiplayer/ServerFeatureSet;)V", "getFileStorageIdentifier", "()Ljava/lang/String;", "authenticate", "", "password", "checkServerStatus", "downloadGame", "Lcom/unciv/logic/GameInfo;", "gameId", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fileStorage", "Lcom/unciv/logic/multiplayer/storage/FileStorage;", "getServerUrl", "setPassword", "tryDownloadGame", "tryDownloadGamePreview", "Lcom/unciv/logic/GameInfoPreview;", "tryUploadGamePreview", "", "gameInfo", "(Lcom/unciv/logic/GameInfoPreview;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "uploadGame", "withPreview", "(Lcom/unciv/logic/GameInfo;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "core"})
public final class MultiplayerServer {
    @Nullable
    private final String fileStorageIdentifier;
    @Nullable
    private Map<String, String> authenticationHeader;
    @NotNull
    private ServerFeatureSet featureSet;

    public MultiplayerServer(@Nullable String fileStorageIdentifier, @Nullable Map<String, String> authenticationHeader) {
        this.fileStorageIdentifier = fileStorageIdentifier;
        this.authenticationHeader = authenticationHeader;
        this.featureSet = new ServerFeatureSet(0, 1, null);
    }

    public /* synthetic */ MultiplayerServer(String string, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            map2 = null;
        }
        this(string, map2);
    }

    @Nullable
    public final String getFileStorageIdentifier() {
        return this.fileStorageIdentifier;
    }

    @NotNull
    public final ServerFeatureSet getFeatureSet$core() {
        return this.featureSet;
    }

    public final void setFeatureSet$core(@NotNull ServerFeatureSet serverFeatureSet) {
        Intrinsics.checkNotNullParameter(serverFeatureSet, "<set-?>");
        this.featureSet = serverFeatureSet;
    }

    @NotNull
    public final String getServerUrl() {
        String string = this.fileStorageIdentifier;
        if (string == null) {
            string = UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getServer();
        }
        return string;
    }

    @NotNull
    public final FileStorage fileStorage() {
        FileStorage fileStorage;
        Map<String, String> authHeader;
        Map<String, String> map2;
        if (this.authenticationHeader == null) {
            GameSettings.GameSettingsMultiplayer settings = UncivGame.Companion.getCurrent().getSettings().getMultiplayer();
            map2 = MapsKt.mapOf(TuplesKt.to("Authorization", settings.getAuthHeader()));
        } else {
            map2 = authHeader = this.authenticationHeader;
        }
        if (Intrinsics.areEqual(this.getServerUrl(), "Dropbox")) {
            fileStorage = DropBox.INSTANCE;
        } else {
            UncivServerFileStorage uncivServerFileStorage;
            UncivServerFileStorage $this$fileStorage_u24lambda_u240 = uncivServerFileStorage = UncivServerFileStorage.INSTANCE;
            boolean bl = false;
            $this$fileStorage_u24lambda_u240.setServerUrl(this.getServerUrl());
            $this$fileStorage_u24lambda_u240.setAuthHeader(authHeader);
            fileStorage = uncivServerFileStorage;
        }
        return fileStorage;
    }

    public final boolean checkServerStatus() {
        Ref.BooleanRef statusOk = new Ref.BooleanRef();
        SimpleHttp.sendGetRequest$default(SimpleHttp.INSTANCE, this.getServerUrl() + "/isalive", 0, null, new Function3<Boolean, String, Integer, Unit>(statusOk, this){
            final /* synthetic */ Ref.BooleanRef $statusOk;
            final /* synthetic */ MultiplayerServer this$0;
            {
                this.$statusOk = $statusOk;
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(boolean success, @NotNull String result2, @Nullable Integer n) {
                Intrinsics.checkNotNullParameter(result2, "result");
                this.$statusOk.element = success;
                if (((CharSequence)result2).length() > 0) {
                    ServerFeatureSet serverFeatureSet;
                    MultiplayerServer multiplayerServer;
                    MultiplayerServer multiplayerServer2 = this.this$0;
                    try {
                        multiplayerServer = multiplayerServer2;
                        serverFeatureSet = UncivJsonKt.json().fromJson(ServerFeatureSet.class, result2);
                        Intrinsics.checkNotNull(serverFeatureSet);
                    }
                    catch (Exception exception2) {
                        multiplayerServer = multiplayerServer2;
                        serverFeatureSet = new ServerFeatureSet(0, 1, null);
                    }
                    multiplayerServer.setFeatureSet$core(serverFeatureSet);
                }
            }
        }, 6, null);
        return statusOk.element;
    }

    public final boolean authenticate(@Nullable String password) {
        if (this.featureSet.getAuthVersion() == 0) {
            return true;
        }
        GameSettings.GameSettingsMultiplayer settings = UncivGame.Companion.getCurrent().getSettings().getMultiplayer();
        FileStorage fileStorage = this.fileStorage();
        String string = settings.getUserId();
        String string2 = password;
        if (string2 == null && (string2 = settings.getPasswords().get(settings.getServer())) == null) {
            string2 = "";
        }
        boolean success = fileStorage.authenticate(string, string2);
        if (password != null && success) {
            settings.getPasswords().put(settings.getServer(), password);
        }
        return success;
    }

    public final boolean setPassword(@NotNull String password) {
        Intrinsics.checkNotNullParameter(password, "password");
        if (this.featureSet.getAuthVersion() > 0 && this.fileStorage().setPassword(password)) {
            GameSettings.GameSettingsMultiplayer settings = UncivGame.Companion.getCurrent().getSettings().getMultiplayer();
            settings.getPasswords().put(settings.getServer(), password);
            return true;
        }
        return false;
    }

    @Nullable
    public final Object uploadGame(@NotNull GameInfo gameInfo, boolean withPreview, @NotNull Continuation<? super Unit> $completion) {
        String zippedGameInfo = UncivFiles.Companion.gameInfoToString(gameInfo, Boxing.boxBoolean(true), true);
        this.fileStorage().saveFileData(gameInfo.getGameId(), zippedGameInfo);
        if (withPreview) {
            Object object = this.tryUploadGamePreview(gameInfo.asPreview(), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object tryUploadGamePreview(@NotNull GameInfoPreview gameInfo, @NotNull Continuation<? super Unit> $completion) {
        String zippedGameInfo = UncivFiles.Companion.gameInfoToString(gameInfo);
        this.fileStorage().saveFileData(gameInfo.getGameId() + "_Preview", zippedGameInfo);
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object tryDownloadGame(@NotNull String gameId, @NotNull Continuation<? super GameInfo> $completion) {
        String zippedGameInfo = this.fileStorage().loadFileData(gameId);
        GameInfo gameInfo = UncivFiles.Companion.gameInfoFromString(zippedGameInfo);
        gameInfo.getGameParameters().setMultiplayerServerUrl(UncivGame.Companion.getCurrent().getSettings().getMultiplayer().getServer());
        return gameInfo;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadGame(@NotNull String var1_1, @NotNull Continuation<? super GameInfo> var2_2) {
        if (!(var2_2 instanceof downloadGame.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ MultiplayerServer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadGame(null, this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.label = 1;
                v0 = this.tryDownloadGame((String)gameId, $continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl20:
                // 2 sources

                latestGame = (GameInfo)v0;
                latestGame.setUpToDate(true);
                return latestGame;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object tryDownloadGamePreview(@NotNull String gameId, @NotNull Continuation<? super GameInfoPreview> $completion) {
        String zippedGameInfo = this.fileStorage().loadFileData(gameId + "_Preview");
        return UncivFiles.Companion.gameInfoPreviewFromString(zippedGameInfo);
    }

    public MultiplayerServer() {
        this(null, null, 3, null);
    }
}

