/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.trade;

import com.unciv.logic.automation.civilization.DeclareWarPlanEvaluator;
import com.unciv.logic.automation.civilization.DiplomacyAutomation;
import com.unciv.logic.automation.civilization.MotivationToAttackAutomation;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeEvaluation;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.ui.screens.victoryscreen.RankingType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006J(\u0010\u0013\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u0014\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u001a\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0002J \u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u001e\u0010$\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u001e\u0010%\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006J\u0018\u0010&\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006'"}, d2={"Lcom/unciv/logic/trade/TradeEvaluation;", "", "()V", "distanceCityTradeModifier", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "city", "Lcom/unciv/logic/city/City;", "evaluateBuyCost", "offer", "Lcom/unciv/logic/trade/TradeOffer;", "tradePartner", "trade", "Lcom/unciv/logic/trade/Trade;", "evaluateBuyCostWithInflation", "evaluatePeaceCostForThem", "ourCiv", "otherCiv", "evaluateSellCost", "evaluateSellCostWithInflation", "getGoldInflation", "", "getNeighbouringCivs", "", "", "getTradeAcceptability", "evaluator", "includeDiplomaticGifts", "", "introductionValue", "ruleSet", "Lcom/unciv/models/ruleset/Ruleset;", "isOfferValid", "tradeOffer", "offerer", "isTradeAcceptable", "isTradeValid", "surroundedByOurCities", "core"})
@SourceDebugExtension(value={"SMAP\nTradeEvaluation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradeEvaluation.kt\ncom/unciv/logic/trade/TradeEvaluation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,447:1\n1774#2,4:448\n1774#2,4:452\n1747#2,3:456\n1774#2,4:459\n2624#2,3:464\n288#2,2:467\n1774#2,4:469\n1747#2,2:473\n1749#2:477\n1747#2,2:478\n1749#2:482\n1747#2,3:483\n1747#2,3:486\n288#2,2:489\n1747#2,3:491\n1747#2,3:494\n1747#2,3:497\n288#2,2:500\n1#3:463\n1247#4,2:475\n1247#4,2:480\n*S KotlinDebug\n*F\n+ 1 TradeEvaluation.kt\ncom/unciv/logic/trade/TradeEvaluation\n*L\n30#1:448,4\n31#1:452,4\n75#1:456,3\n84#1:459,4\n99#1:464,3\n103#1:467,2\n150#1:469,4\n175#1:473,2\n175#1:477\n178#1:478,2\n178#1:482\n198#1:483,3\n199#1:486,3\n211#1:489,2\n302#1:491,3\n335#1:494,3\n336#1:497,3\n350#1:500,2\n175#1:475,2\n178#1:480,2\n*E\n"})
public final class TradeEvaluation {
    public final boolean isTradeValid(@NotNull Trade trade, @NotNull Civilization offerer, @NotNull Civilization tradePartner) {
        block13: {
            block12: {
                int n;
                TradeOffer it;
                int count$iv;
                boolean $i$f$count;
                Iterable $this$count$iv;
                block11: {
                    int n2;
                    Intrinsics.checkNotNullParameter(trade, "trade");
                    Intrinsics.checkNotNullParameter(offerer, "offerer");
                    Intrinsics.checkNotNullParameter(tradePartner, "tradePartner");
                    if (!offerer.getHasEverOwnedOriginalCapital()) break block11;
                    $this$count$iv = trade.getOurOffers();
                    $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n2 = 0;
                    } else {
                        count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            it = (TradeOffer)element$iv;
                            boolean bl = false;
                            if (!(it.getType() == TradeOfferType.City) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n2 = count$iv;
                    }
                    if (n2 == offerer.getCities().size()) break block12;
                }
                if (!tradePartner.getHasEverOwnedOriginalCapital()) break block13;
                $this$count$iv = trade.getTheirOffers();
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it = (TradeOffer)element$iv;
                        boolean bl = false;
                        if (!(it.getType() == TradeOfferType.City) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                if (n != tradePartner.getCities().size()) break block13;
            }
            return false;
        }
        for (TradeOffer offer : trade.getOurOffers()) {
            Intrinsics.checkNotNull(offer);
            if (this.isOfferValid(offer, offerer, tradePartner)) continue;
            return false;
        }
        for (TradeOffer offer : trade.getTheirOffers()) {
            Intrinsics.checkNotNull(offer);
            if (this.isOfferValid(offer, tradePartner, offerer)) continue;
            return false;
        }
        return true;
    }

    private final boolean isOfferValid(TradeOffer tradeOffer, Civilization offerer, Civilization tradePartner) {
        boolean bl;
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[tradeOffer.getType().ordinal()]) {
            case 1: {
                if ((float)tradeOffer.getAmount() * 0.9f < (float)offerer.getGold()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if ((float)tradeOffer.getAmount() * 0.9f < offerer.getStats().getStatsForNextTurn().getGold()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                switch (tradeOffer.getName()) {
                    case "Peace Treaty": {
                        bl = offerer.isAtWarWith(tradePartner);
                        break block0;
                    }
                    case "Research Agreement": {
                        DiplomacyManager diplomacyManager = offerer.getDiplomacyManager(tradePartner);
                        Intrinsics.checkNotNull(diplomacyManager);
                        if (!diplomacyManager.hasFlag(DiplomacyFlags.ResearchAgreement)) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                    case "Defensive Pact": {
                        DiplomacyManager diplomacyManager = offerer.getDiplomacyManager(tradePartner);
                        Intrinsics.checkNotNull(diplomacyManager);
                        if (!diplomacyManager.hasFlag(DiplomacyFlags.DefensivePact)) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                }
                bl = true;
                break;
            }
            case 4: {
                bl = true;
                break;
            }
            case 5: {
                bl = TradeEvaluation.isOfferValid$hasResource(offerer, tradeOffer);
                break;
            }
            case 6: {
                bl = TradeEvaluation.isOfferValid$hasResource(offerer, tradeOffer);
                break;
            }
            case 7: {
                bl = TradeEvaluation.isOfferValid$hasResource(offerer, tradeOffer);
                break;
            }
            case 8: {
                bl = true;
                break;
            }
            case 9: {
                if (!tradePartner.knows(tradeOffer.getName())) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 10: {
                DiplomacyManager diplomacyManager = offerer.getDiplomacyManager(tradeOffer.getName());
                Intrinsics.checkNotNull(diplomacyManager);
                bl = diplomacyManager.canDeclareWar();
                break;
            }
            case 11: {
                Iterable $this$any$iv = offerer.getCities();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                for (Object element$iv : $this$any$iv) {
                    City it = (City)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getId(), tradeOffer.getName())) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public final boolean isTradeAcceptable(@NotNull Trade trade, @NotNull Civilization evaluator, @NotNull Civilization tradePartner) {
        Intrinsics.checkNotNullParameter(trade, "trade");
        Intrinsics.checkNotNullParameter(evaluator, "evaluator");
        Intrinsics.checkNotNullParameter(tradePartner, "tradePartner");
        return this.getTradeAcceptability(trade, evaluator, tradePartner, true) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int getTradeAcceptability(@NotNull Trade trade, @NotNull Civilization evaluator, @NotNull Civilization tradePartner, boolean includeDiplomaticGifts) {
        int n;
        Object v3;
        RelationshipLevel relationshipLevel;
        int sumOfOurOffers;
        int sumOfTheirOffers2;
        block17: {
            boolean bl;
            block16: {
                Object it;
                int n2;
                Intrinsics.checkNotNullParameter(trade, "trade");
                Intrinsics.checkNotNullParameter(evaluator, "evaluator");
                Intrinsics.checkNotNullParameter(tradePartner, "tradePartner");
                Iterable $this$count$iv = trade.getOurOffers();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        it = (TradeOffer)element$iv;
                        boolean bl2 = false;
                        if (!(((TradeOffer)it).getType() == TradeOfferType.City) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                int citiesAskedToSurrender = n2;
                int maxCitiesToSurrender = (int)Math.ceil((float)evaluator.getCities().size() / (float)5);
                if (citiesAskedToSurrender > maxCitiesToSurrender) {
                    return Integer.MIN_VALUE;
                }
                sumOfTheirOffers2 = SequencesKt.sumOfInt(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence(trade.getTheirOffers()), getTradeAcceptability.sumOfTheirOffers.1.INSTANCE), (Function1)new Function1<TradeOffer, Integer>(this, evaluator, tradePartner, trade){
                    final /* synthetic */ TradeEvaluation this$0;
                    final /* synthetic */ Civilization $evaluator;
                    final /* synthetic */ Civilization $tradePartner;
                    final /* synthetic */ Trade $trade;
                    {
                        this.this$0 = $receiver;
                        this.$evaluator = $evaluator;
                        this.$tradePartner = $tradePartner;
                        this.$trade = $trade;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(@NotNull TradeOffer it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.this$0.evaluateBuyCostWithInflation(it, this.$evaluator, this.$tradePartner, this.$trade);
                    }
                }));
                Iterable iterable = trade.getOurOffers();
                int element$iv = 0;
                it = iterable.iterator();
                while (it.hasNext()) {
                    void it2;
                    Object e = it.next();
                    TradeOffer tradeOffer = (TradeOffer)e;
                    int n3 = element$iv;
                    boolean bl3 = false;
                    int n4 = this.evaluateSellCostWithInflation((TradeOffer)it2, evaluator, tradePartner, trade);
                    element$iv = n3 + n4;
                }
                sumOfOurOffers = element$iv;
                DiplomacyManager diplomacyManager = evaluator.getDiplomacyManager(tradePartner);
                Intrinsics.checkNotNull(diplomacyManager);
                relationshipLevel = diplomacyManager.relationshipIgnoreAfraid();
                Iterable $this$none$iv = trade.getOurOffers();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        TradeOffer it3 = (TradeOffer)element$iv2;
                        boolean bl4 = false;
                        if (!(Intrinsics.areEqual(it3.getName(), "Peace Treaty") || Intrinsics.areEqual(it3.getName(), "Research Agreement"))) continue;
                        bl = false;
                        break block16;
                    }
                    bl = true;
                }
            }
            if (bl) {
                if (relationshipLevel == RelationshipLevel.Enemy) {
                    sumOfOurOffers = (int)((double)sumOfOurOffers * 1.5);
                } else if (relationshipLevel == RelationshipLevel.Unforgivable) {
                    sumOfOurOffers *= 2;
                }
            }
            Iterable $this$firstOrNull$iv = trade.getOurOffers();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                TradeOffer it = (TradeOffer)element$iv2;
                boolean bl5 = false;
                if (!Intrinsics.areEqual(it.getName(), "Defensive Pact")) continue;
                v3 = element$iv2;
                break block17;
            }
            v3 = null;
        }
        if (v3 != null && relationshipLevel != RelationshipLevel.Ally) {
            return Integer.MIN_VALUE;
        }
        if (includeDiplomaticGifts) {
            DiplomacyManager diplomacyManager = evaluator.getDiplomacyManager(tradePartner);
            Intrinsics.checkNotNull(diplomacyManager);
            n = diplomacyManager.getGoldGifts();
        } else {
            n = 0;
        }
        int diplomaticGifts = n;
        return sumOfTheirOffers2 - sumOfOurOffers + diplomaticGifts;
    }

    public static /* synthetic */ int getTradeAcceptability$default(TradeEvaluation tradeEvaluation, Trade trade, Civilization civilization, Civilization civilization2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return tradeEvaluation.getTradeAcceptability(trade, civilization, civilization2, bl);
    }

    public final int evaluateBuyCostWithInflation(@NotNull TradeOffer offer, @NotNull Civilization civInfo, @NotNull Civilization tradePartner, @NotNull Trade trade) {
        Intrinsics.checkNotNullParameter(offer, "offer");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(tradePartner, "tradePartner");
        Intrinsics.checkNotNullParameter(trade, "trade");
        if (offer.getType() != TradeOfferType.Gold && offer.getType() != TradeOfferType.Gold_Per_Turn) {
            return (int)((double)this.evaluateBuyCost(offer, civInfo, tradePartner, trade) / this.getGoldInflation(civInfo));
        }
        return this.evaluateBuyCost(offer, civInfo, tradePartner, trade);
    }

    /*
     * Unable to fully structure code
     */
    private final int evaluateBuyCost(TradeOffer offer, Civilization civInfo, Civilization tradePartner, Trade trade) {
        switch (WhenMappings.$EnumSwitchMapping$0[offer.getType().ordinal()]) {
            case 1: {
                return offer.getAmount();
            }
            case 2: {
                var5_5 = new IntRange(1, offer.getDuration());
                var6_12 = 0.0;
                var8_18 = var5_5.iterator();
                while (var8_18.hasNext()) {
                    var10_34 = var9_25 = ((IntIterator)var8_18).nextInt();
                    var22_53 = var6_12;
                    $i$a$-sumOfDouble-TradeEvaluation$evaluateBuyCost$1 = false;
                    var24_54 = (double)offer.getAmount() * Math.pow(0.98, (double)it);
                    var6_12 = var22_53 + var24_54;
                }
                return (int)var6_12;
            }
            case 3: {
                var5_6 = offer.getName();
                tmp = -1;
                switch (var5_6.hashCode()) {
                    case 980683217: {
                        if (var5_6.equals("Peace Treaty")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 631699055: {
                        if (var5_6.equals("Defensive Pact")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 245239237: {
                        if (var5_6.equals("Research Agreement")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v0 = this.evaluatePeaceCostForThem(civInfo, tradePartner);
                        break;
                    }
                    case 2: {
                        v0 = 0;
                        break;
                    }
                    case 3: {
                        v0 = -offer.getAmount();
                        break;
                    }
                    default: {
                        v0 = 1000;
                    }
                }
                return v0;
            }
            case 5: {
                v1 = civInfo.getDiplomacyManager(tradePartner);
                Intrinsics.checkNotNull(v1);
                if (v1.hasFlag(DiplomacyFlags.ResourceTradesCutShort)) {
                    return 0;
                }
                v2 = civInfo.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                Intrinsics.checkNotNull(v2);
                var7_55 = v2.getMatchingUniques(UniqueType.AiWillBuyAt, new StateForConditionals(civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null)).iterator();
                if (!var7_55.hasNext()) {
                    v3 = null;
                } else {
                    it = var7_55.next();
                    $i$a$-minOfOrNull-TradeEvaluation$evaluateBuyCost$lowestExplicitBuyCost$1 = false;
                    it = Integer.parseInt(it.getParams().get(0));
                    while (var7_55.hasNext()) {
                        it = var7_55.next();
                        $i$a$-minOfOrNull-TradeEvaluation$evaluateBuyCost$lowestExplicitBuyCost$1 = false;
                        if (it.compareTo(it = (Comparable)Integer.valueOf(Integer.parseInt(it.getParams().get(0)))) <= 0) continue;
                        it = it;
                    }
                    v3 = it;
                }
                v4 = lowestExplicitBuyCost = (Integer)v3;
                if (v4 != null) {
                    return v4;
                }
                $this$count$iv = civInfo.getCities();
                $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    v5 = 0;
                } else {
                    count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        it = (City)element$iv;
                        $i$a$-count-TradeEvaluation$evaluateBuyCost$weLoveTheKingPotential$1 = false;
                        if (!Intrinsics.areEqual(it.getDemandedResource(), offer.getName()) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    v5 = count$iv;
                }
                weLoveTheKingPotential = v5 * 50;
                return civInfo.hasResource(offer.getName()) == false ? weLoveTheKingPotential + (civInfo.getHappiness() < 0 ? 450 : (civInfo.getHappiness() < 10 ? 350 : 300)) : 0;
            }
            case 6: {
                v6 = civInfo.getDiplomacyManager(tradePartner);
                Intrinsics.checkNotNull(v6);
                if (v6.hasFlag(DiplomacyFlags.ResourceTradesCutShort)) {
                    return 0;
                }
                amountWillingToBuy = 2 - civInfo.getResourceAmount(offer.getName());
                if (amountWillingToBuy <= 0) {
                    return 0;
                }
                amountToBuyInOffer = Math.min(amountWillingToBuy, offer.getAmount());
                v7 = civInfo.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                Intrinsics.checkNotNull(v7);
                count$iv = v7.getMatchingUniques(UniqueType.AiWillBuyAt, new StateForConditionals(civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null)).iterator();
                if (!count$iv.hasNext()) {
                    v8 = null;
                } else {
                    it = count$iv.next();
                    $i$a$-minOfOrNull-TradeEvaluation$evaluateBuyCost$lowestExplicitBuyCost$2 = false;
                    it = Integer.parseInt(it.getParams().get(0));
                    while (count$iv.hasNext()) {
                        it = (Unique)count$iv.next();
                        $i$a$-minOfOrNull-TradeEvaluation$evaluateBuyCost$lowestExplicitBuyCost$2 = false;
                        if (it.compareTo(it = (Comparable)Integer.valueOf(Integer.parseInt(it.getParams().get(0)))) <= 0) continue;
                        it = it;
                    }
                    v8 = it;
                }
                v9 = lowestExplicitBuyCost = (Integer)v8;
                if (v9 != null) {
                    return v9;
                }
                count$iv = civInfo.getCities();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl126
                v10 = false;
                ** GOTO lbl144
lbl126:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    city = (City)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateBuyCost$canUseForBuildings$1 = false;
                    $this$any$iv = city.getCityConstructions().getBuildableBuildings$core();
                    $i$f$any = false;
                    var17_73 = $this$any$iv.iterator();
                    while (var17_73.hasNext()) {
                        it = element$iv = var17_73.next();
                        $i$a$-any-TradeEvaluation$evaluateBuyCost$canUseForBuildings$1$1 = false;
                        if (!it.getResourceRequirementsPerTurn(city.getState()).containsKey(offer.getName())) continue;
                        v11 = true;
                        ** GOTO lbl140
                    }
                    v11 = false;
lbl140:
                    // 2 sources

                    if (!v11) continue;
                    v10 = true;
                    ** GOTO lbl144
                }
                v10 = false;
lbl144:
                // 3 sources

                canUseForBuildings = v10;
                $i$f$any = civInfo.getCities();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl151
                v12 = false;
                ** GOTO lbl169
lbl151:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    city = (City)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateBuyCost$canUseForUnits$1 = false;
                    $this$any$iv = city.getCityConstructions().getConstructableUnits();
                    $i$f$any = false;
                    var18_75 = $this$any$iv.iterator();
                    while (var18_75.hasNext()) {
                        it = element$iv = var18_75.next();
                        $i$a$-any-TradeEvaluation$evaluateBuyCost$canUseForUnits$1$1 = false;
                        if (!it.getResourceRequirementsPerTurn(civInfo.getState()).containsKey(offer.getName())) continue;
                        v13 = true;
                        ** GOTO lbl165
                    }
                    v13 = false;
lbl165:
                    // 2 sources

                    if (!v13) continue;
                    v12 = true;
                    ** GOTO lbl169
                }
                v12 = canUseForUnits = false;
lbl169:
                // 3 sources

                if (!canUseForBuildings && !canUseForUnits) {
                    return 0;
                }
                return 50 * amountToBuyInOffer;
            }
            case 7: {
                v14 = civInfo.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                if (v14 == null) {
                    return 0;
                }
                resource = v14;
                canUseForBuildings = resource.getMatchingUniques(UniqueType.AiWillBuyAt, new StateForConditionals(civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null)).iterator();
                if (!canUseForBuildings.hasNext()) {
                    v15 = null;
                } else {
                    it = canUseForBuildings.next();
                    $i$a$-minOfOrNull-TradeEvaluation$evaluateBuyCost$lowestBuyCost$1 = false;
                    it = Integer.parseInt(it.getParams().get(0));
                    while (canUseForBuildings.hasNext()) {
                        it = canUseForBuildings.next();
                        $i$a$-minOfOrNull-TradeEvaluation$evaluateBuyCost$lowestBuyCost$1 = false;
                        if (it.compareTo(it = (Comparable)Integer.valueOf(Integer.parseInt(it.getParams().get(0)))) <= 0) continue;
                        it = it;
                    }
                    v15 = it;
                }
                v16 = lowestBuyCost = (Integer)v15;
                return v16 != null ? v16 : 0;
            }
            case 8: {
                v17 = civInfo.getGameInfo().getRuleset().getTechnologies().get(offer.getName());
                Intrinsics.checkNotNull(v17);
                return (int)(Math.sqrt(v17.getCost()) * (double)civInfo.getGameInfo().getSpeed().getScienceCostModifier()) * 20;
            }
            case 9: {
                return this.introductionValue(civInfo.getGameInfo().getRuleset());
            }
            case 10: {
                civToDeclareWarOn = civInfo.getGameInfo().getCivilization(offer.getName());
                $this$any$iv = trade.getTheirOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl208
                v18 = false;
                ** GOTO lbl215
lbl208:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateBuyCost$2 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), offer.getName()) != false)) continue;
                    v18 = true;
                    ** GOTO lbl215
                }
                v18 = false;
lbl215:
                // 3 sources

                if (!v18) ** GOTO lbl230
                $this$any$iv = trade.getOurOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl221
                v19 = false;
                ** GOTO lbl228
lbl221:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateBuyCost$3 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), offer.getName()) != false)) continue;
                    v19 = true;
                    ** GOTO lbl228
                }
                v19 = false;
lbl228:
                // 3 sources

                if (v19) {
                    return 0;
                }
lbl230:
                // 3 sources

                if (civInfo.isAtWarWith(civToDeclareWarOn)) {
                    return RangesKt.coerceAtLeast((int)((float)20 * DeclareWarPlanEvaluator.INSTANCE.evaluateJoinOurWarPlan(civInfo, civToDeclareWarOn, tradePartner, null)), 0);
                }
                return 0;
            }
            case 11: {
                $this$firstOrNull$iv = tradePartner.getCities();
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (City)element$iv;
                    $i$a$-firstOrNull-TradeEvaluation$evaluateBuyCost$city$1 = false;
                    if (!Intrinsics.areEqual(it.getId(), offer.getName())) continue;
                    v20 = element$iv;
                    ** GOTO lbl243
                }
                v20 = null;
lbl243:
                // 2 sources

                v21 = v20;
                if (v21 == null) {
                    throw new Exception("Got an offer for city id " + offer.getName() + " which does't seem to exist for this civ!");
                }
                city = v21;
                surrounded = this.surroundedByOurCities(city, civInfo);
                v22 = civInfo.getHappiness();
                v23 = city.getCityStats().getHappinessList().values();
                Intrinsics.checkNotNullExpressionValue(v23, "<get-values>(...)");
                if (v22 + CollectionsKt.sumOfFloat((Iterable<Float>)v23) < 0.0f) {
                    return 0;
                }
                sumOfPop = city.getPopulation().getPopulation();
                sumOfBuildings = SequencesKt.count(city.getCityConstructions().getBuiltBuildings());
                return (sumOfPop * 4 + sumOfBuildings + 4 + surrounded) * 100;
            }
            case 4: {
                if (Intrinsics.areEqual(offer.getName(), "Open Borders")) {
                    return 100;
                }
                throw new Exception("Invalid agreement type!");
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final int surroundedByOurCities(City city2, Civilization civInfo) {
        Set<String> borderingCivs = this.getNeighbouringCivs(city2);
        if (borderingCivs.contains(civInfo.getCivName())) {
            return 3;
        }
        return 0;
    }

    private final Set<String> getNeighbouringCivs(City city2) {
        HashSet<Tile> tilesList = SequencesKt.toHashSet(city2.getTiles());
        ArrayList<Tile> cityPositionList = new ArrayList<Tile>();
        for (Tile tiles2 : tilesList) {
            Iterator<Tile> iterator2 = tiles2.getNeighbors().iterator();
            while (iterator2.hasNext()) {
                Tile tile = iterator2.next();
                if (tilesList.contains(tile)) continue;
                cityPositionList.add(tile);
            }
        }
        return SequencesKt.toSet(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)cityPositionList), getNeighbouringCivs.1.INSTANCE));
    }

    public final int evaluateSellCostWithInflation(@NotNull TradeOffer offer, @NotNull Civilization civInfo, @NotNull Civilization tradePartner, @NotNull Trade trade) {
        Intrinsics.checkNotNullParameter(offer, "offer");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(tradePartner, "tradePartner");
        Intrinsics.checkNotNullParameter(trade, "trade");
        if (offer.getType() != TradeOfferType.Gold && offer.getType() != TradeOfferType.Gold_Per_Turn) {
            return (int)((double)this.evaluateSellCost(offer, civInfo, tradePartner, trade) / this.getGoldInflation(civInfo));
        }
        return this.evaluateSellCost(offer, civInfo, tradePartner, trade);
    }

    /*
     * Unable to fully structure code
     */
    private final int evaluateSellCost(TradeOffer offer, Civilization civInfo, Civilization tradePartner, Trade trade) {
        switch (WhenMappings.$EnumSwitchMapping$0[offer.getType().ordinal()]) {
            case 1: {
                return offer.getAmount();
            }
            case 2: {
                return offer.getAmount() * offer.getDuration();
            }
            case 3: {
                var5_5 = offer.getName();
                tmp = -1;
                switch (var5_5.hashCode()) {
                    case 980683217: {
                        if (var5_5.equals("Peace Treaty")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 631699055: {
                        if (var5_5.equals("Defensive Pact")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 245239237: {
                        if (var5_5.equals("Research Agreement")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v0 = this.evaluatePeaceCostForThem(civInfo, tradePartner);
                        break;
                    }
                    case 2: {
                        if (DiplomacyAutomation.INSTANCE.wantsToSignDefensivePact(civInfo, tradePartner)) {
                            v0 = 0;
                            break;
                        }
                        v0 = 100000;
                        break;
                    }
                    case 3: {
                        v0 = -offer.getAmount();
                        break;
                    }
                    default: {
                        v0 = 1000;
                    }
                }
                return v0;
            }
            case 5: {
                v1 = civInfo.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                Intrinsics.checkNotNull(v1);
                var7_11 = v1.getMatchingUniques(UniqueType.AiWillSellAt, new StateForConditionals(civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null)).iterator();
                if (!var7_11.hasNext()) {
                    v2 = null;
                } else {
                    it = var7_11.next();
                    $i$a$-minOfOrNull-TradeEvaluation$evaluateSellCost$lowestExplicitSellCost$1 = false;
                    it = Integer.parseInt(it.getParams().get(0));
                    while (var7_11.hasNext()) {
                        it = var7_11.next();
                        $i$a$-minOfOrNull-TradeEvaluation$evaluateSellCost$lowestExplicitSellCost$1 = false;
                        if (it.compareTo(it = (Comparable)Integer.valueOf(Integer.parseInt(it.getParams().get(0)))) <= 0) continue;
                        it = it;
                    }
                    v2 = it;
                }
                v3 = lowestExplicitSellCost = (Integer)v2;
                if (v3 != null) {
                    return v3;
                }
                return civInfo.getResourceAmount(offer.getName()) > 1 ? 250 : (Civilization.hasUnique$default(civInfo, UniqueType.RetainHappinessFromLuxury, null, 2, null) != false ? 600 - (int)(Float.parseFloat(((Unique)SequencesKt.first(Civilization.getMatchingUniques$default(civInfo, UniqueType.RetainHappinessFromLuxury, null, 2, null))).getParams().get(0)) * 3.5f) : 600);
            }
            case 6: {
                if (civInfo.getGameInfo().getSpaceResources().contains(offer.getName()) && (Civilization.hasUnique$default(civInfo, UniqueType.EnablesConstructionOfSpaceshipParts, null, 2, null) || Civilization.hasUnique$default(tradePartner, UniqueType.EnablesConstructionOfSpaceshipParts, null, 2, null))) {
                    return 0x7FFFFFFF;
                }
                v4 = civInfo.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                Intrinsics.checkNotNull(v4);
                var7_12 = v4.getMatchingUniques(UniqueType.AiWillSellAt, new StateForConditionals(civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null)).iterator();
                if (!var7_12.hasNext()) {
                    v5 = null;
                } else {
                    it = var7_12.next();
                    $i$a$-minOfOrNull-TradeEvaluation$evaluateSellCost$lowestExplicitSellCost$2 = false;
                    it = Integer.parseInt(it.getParams().get(0));
                    while (var7_12.hasNext()) {
                        it = var7_12.next();
                        $i$a$-minOfOrNull-TradeEvaluation$evaluateSellCost$lowestExplicitSellCost$2 = false;
                        if (it.compareTo(it = (Comparable)Integer.valueOf(Integer.parseInt(it.getParams().get(0)))) <= 0) continue;
                        it = it;
                    }
                    v5 = it;
                }
                v6 = lowestExplicitSellCost = (Integer)v5;
                if (v6 != null) {
                    return v6;
                }
                if (!civInfo.isAtWar()) {
                    return 50 * offer.getAmount();
                }
                v7 = civInfo.getGameInfo().getRuleset().getUnits().values();
                Intrinsics.checkNotNullExpressionValue(v7, "<get-values>(...)");
                var7_12 = v7;
                $i$f$any = false;
                if (!((Collection)$this$any$iv).isEmpty()) ** GOTO lbl99
                v8 = false;
                ** GOTO lbl107
lbl99:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (BaseUnit)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateSellCost$canUseForUnits$1 = false;
                    v9 = it.getResourceRequirementsPerTurn(civInfo.getState()).containsKey(offer.getName()) && it.isBuildable(civInfo);
                    if (!v9) continue;
                    v8 = true;
                    ** GOTO lbl107
                }
                v8 = canUseForUnits = false;
lbl107:
                // 3 sources

                if (!canUseForUnits) {
                    return 50 * offer.getAmount();
                }
                amountLeft = civInfo.getResourceAmount(offer.getName());
                totalCost = 0;
                numberOfResource = amountLeft - offer.getAmount() + 1;
                if (numberOfResource <= amountLeft) {
                    while (true) {
                        totalCost += numberOfResource > 5 ? 100 : (6 - numberOfResource) * 100;
                        if (numberOfResource == amountLeft) break;
                        ++numberOfResource;
                    }
                }
                return totalCost;
            }
            case 7: {
                v10 = civInfo.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                if (v10 == null) {
                    return 0;
                }
                resource = v10;
                totalCost = resource.getMatchingUniques(UniqueType.AiWillSellAt, new StateForConditionals(civInfo, null, null, null, null, null, null, null, null, null, false, 2046, null)).iterator();
                if (!totalCost.hasNext()) {
                    v11 = null;
                } else {
                    it = totalCost.next();
                    $i$a$-minOfOrNull-TradeEvaluation$evaluateSellCost$lowestSellCost$1 = false;
                    it = Integer.parseInt(it.getParams().get(0));
                    while (totalCost.hasNext()) {
                        it = totalCost.next();
                        $i$a$-minOfOrNull-TradeEvaluation$evaluateSellCost$lowestSellCost$1 = false;
                        if (it.compareTo(it = (Comparable)Integer.valueOf(Integer.parseInt(it.getParams().get(0)))) <= 0) continue;
                        it = it;
                    }
                    v11 = it;
                }
                v12 = lowestSellCost = (Integer)v11;
                return v12 != null ? v12 : 0x7FFFFFFF;
            }
            case 8: {
                v13 = civInfo.getGameInfo().getRuleset().getTechnologies().get(offer.getName());
                Intrinsics.checkNotNull(v13);
                return (int)Math.sqrt(v13.getCost()) * 20;
            }
            case 9: {
                return this.introductionValue(civInfo.getGameInfo().getRuleset());
            }
            case 10: {
                civToDeclareWarOn = civInfo.getGameInfo().getCivilization(offer.getName());
                $this$any$iv = trade.getTheirOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl155
                v14 = false;
                ** GOTO lbl162
lbl155:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateSellCost$1 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), offer.getName()) != false)) continue;
                    v14 = true;
                    ** GOTO lbl162
                }
                v14 = false;
lbl162:
                // 3 sources

                if (!v14) ** GOTO lbl177
                $this$any$iv = trade.getOurOffers();
                $i$f$any = false;
                if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) ** GOTO lbl168
                v15 = false;
                ** GOTO lbl175
lbl168:
                // 2 sources

                for (T element$iv : $this$any$iv) {
                    it = (TradeOffer)element$iv;
                    $i$a$-any-TradeEvaluation$evaluateSellCost$2 = false;
                    if (!(it.getType() == TradeOfferType.WarDeclaration && Intrinsics.areEqual(it.getName(), offer.getName()) != false)) continue;
                    v15 = true;
                    ** GOTO lbl175
                }
                v15 = false;
lbl175:
                // 3 sources

                if (v15) {
                    return RangesKt.coerceAtLeast((int)((float)-20 * DeclareWarPlanEvaluator.INSTANCE.evaluateTeamWarPlan(civInfo, civToDeclareWarOn, tradePartner, null)), 0);
                }
lbl177:
                // 3 sources

                if (tradePartner.isAtWarWith(civToDeclareWarOn)) {
                    return RangesKt.coerceAtLeast((int)((float)-20 * DeclareWarPlanEvaluator.INSTANCE.evaluateJoinWarPlan(civInfo, civToDeclareWarOn, tradePartner, null)), 0);
                }
                return RangesKt.coerceAtLeast((int)((float)-25 * DeclareWarPlanEvaluator.INSTANCE.evaluateDeclareWarPlan(civInfo, civToDeclareWarOn, null)), 0);
            }
            case 11: {
                $this$firstOrNull$iv = civInfo.getCities();
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (City)element$iv;
                    $i$a$-firstOrNull-TradeEvaluation$evaluateSellCost$city$1 = false;
                    if (!Intrinsics.areEqual(it.getId(), offer.getName())) continue;
                    v16 = element$iv;
                    ** GOTO lbl190
                }
                v16 = null;
lbl190:
                // 2 sources

                v17 = v16;
                if (v17 == null) {
                    throw new Exception("Got an offer to sell city id " + offer.getName() + " which does't seem to exist for this civ!");
                }
                city = v17;
                distanceBonus = this.distanceCityTradeModifier(civInfo, city);
                sumOfPop = city.getPopulation().getPopulation();
                sumOfBuildings = SequencesKt.count(city.getCityConstructions().getBuiltBuildings());
                return RangesKt.coerceAtLeast((sumOfPop * 4 + sumOfBuildings * 1 + 4 + distanceBonus) * 100, 1000);
            }
            case 4: {
                if (Intrinsics.areEqual(offer.getName(), "Open Borders")) {
                    v18 = civInfo.getDiplomacyManager(tradePartner);
                    Intrinsics.checkNotNull(v18);
                    switch (WhenMappings.$EnumSwitchMapping$1[v18.relationshipIgnoreAfraid().ordinal()]) {
                        case 1: {
                            v19 = 10000;
                            break;
                        }
                        case 2: {
                            v19 = 2000;
                            break;
                        }
                        case 3: {
                            v19 = 500;
                            break;
                        }
                        case 4: 
                        case 5: {
                            v19 = 200;
                            break;
                        }
                        case 6: 
                        case 7: 
                        case 8: {
                            v19 = 100;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return v19;
                }
                throw new Exception("Invalid agreement type!");
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public final double getGoldInflation(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        double modifier = 1000.0;
        double goldPerTurn = civInfo.getStats().getStatsForNextTurn().getGold();
        return modifier / (Math.pow(RangesKt.coerceAtLeast(goldPerTurn, 1.0), 1.2) + 1.66 * modifier) + 0.4;
    }

    private final int distanceCityTradeModifier(Civilization civInfo, City city2) {
        City city3 = Civilization.getCapital$default(civInfo, false, 1, null);
        Intrinsics.checkNotNull(city3);
        int distanceToCapital = city3.getCenterTile().aerialDistanceTo(city2.getCenterTile());
        if (distanceToCapital < 500) {
            return 0;
        }
        return (distanceToCapital - 500) * civInfo.getEraNumber();
    }

    public final int evaluatePeaceCostForThem(@NotNull Civilization ourCiv, @NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(ourCiv, "ourCiv");
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        int ourCombatStrength = ourCiv.getStatForRanking(RankingType.Force);
        int theirCombatStrength = otherCiv.getStatForRanking(RankingType.Force);
        if ((float)ourCombatStrength * 1.5f >= (float)theirCombatStrength && (float)theirCombatStrength * 1.5f >= (float)ourCombatStrength) {
            return 0;
        }
        if (ourCombatStrength > theirCombatStrength) {
            if (MotivationToAttackAutomation.INSTANCE.hasAtLeastMotivationToAttack(ourCiv, otherCiv, 0.0f) <= 0.0f) {
                return 0;
            }
            int absoluteAdvantage = ourCombatStrength - theirCombatStrength;
            float percentageAdvantage = (float)absoluteAdvantage / (float)theirCombatStrength;
            int totalAdvantage = (int)((float)absoluteAdvantage * percentageAdvantage);
            if (totalAdvantage < 0) {
                return 10000;
            }
            return (int)((double)totalAdvantage / (this.getGoldInflation(otherCiv) * (double)2));
        }
        int absoluteAdvantage = theirCombatStrength - ourCombatStrength;
        float percentageAdvantage = (float)absoluteAdvantage / (float)ourCombatStrength;
        return -((int)RangesKt.coerceAtMost((double)((float)absoluteAdvantage * percentageAdvantage) / (this.getGoldInflation(ourCiv) * (double)2), 10000.0));
    }

    private final int introductionValue(Ruleset ruleSet) {
        Unique unique = (Unique)SequencesKt.firstOrNull(IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)ruleSet.getModOptions(), UniqueType.TradeCivIntroductions, null, 2, null));
        if (unique == null) {
            return 0;
        }
        Unique unique2 = unique;
        return Integer.parseInt(unique2.getParams().get(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isOfferValid$hasResource(Civilization $offerer, TradeOffer tradeOffer) {
        HashMap<String, Integer> resourcesByName = $offerer.getCivResourcesByName();
        if (!resourcesByName.containsKey(tradeOffer.getName())) return false;
        Integer n = resourcesByName.get(tradeOffer.getName());
        Intrinsics.checkNotNull(n);
        if (((Number)n).intValue() < tradeOffer.getAmount()) return false;
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TradeOfferType.values().length];
            try {
                nArray[TradeOfferType.Gold.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Gold_Per_Turn.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Treaty.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Agreement.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Luxury_Resource.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Strategic_Resource.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Stockpiled_Resource.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Technology.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Introduction.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.WarDeclaration.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.City.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RelationshipLevel.values().length];
            try {
                nArray[RelationshipLevel.Unforgivable.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Enemy.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Competitor.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Neutral.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Afraid.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Favorable.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Friend.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Ally.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

