/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset;

import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.PerpetualStatConversion;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0007\"\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/unciv/models/ruleset/PerpetualConstruction;", "Lcom/unciv/models/ruleset/IConstruction;", "name", "", "description", "(Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getName", "setName", "(Ljava/lang/String;)V", "getProductionTooltip", "city", "Lcom/unciv/logic/city/City;", "withIcon", "", "getResourceRequirementsPerTurn", "Lcom/unciv/models/Counter;", "state", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "getStockpiledResourceRequirements", "isBuildable", "cityConstructions", "Lcom/unciv/logic/city/CityConstructions;", "requiredResources", "", "shouldBeDisplayed", "Companion", "core"})
public class PerpetualConstruction
implements IConstruction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    @NotNull
    private final String description;
    @NotNull
    private static final PerpetualStatConversion science = new PerpetualStatConversion(Stat.Science);
    @NotNull
    private static final PerpetualStatConversion gold = new PerpetualStatConversion(Stat.Gold);
    @NotNull
    private static final PerpetualStatConversion culture = new PerpetualStatConversion(Stat.Culture);
    @NotNull
    private static final PerpetualStatConversion faith = new PerpetualStatConversion(Stat.Faith);
    @NotNull
    private static final PerpetualConstruction idle = new PerpetualConstruction(){

        public boolean isBuildable(@NotNull CityConstructions cityConstructions) {
            Intrinsics.checkNotNullParameter(cityConstructions, "cityConstructions");
            return true;
        }
    };
    @NotNull
    private static final Map<String, PerpetualConstruction> perpetualConstructionsMap;

    public PerpetualConstruction(@NotNull String name2, @NotNull String description2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(description2, "description");
        this.name = name2;
        this.description = description2;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.name = string;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @Override
    public boolean shouldBeDisplayed(@NotNull CityConstructions cityConstructions) {
        Intrinsics.checkNotNullParameter(cityConstructions, "cityConstructions");
        return this.isBuildable(cityConstructions);
    }

    @NotNull
    public String getProductionTooltip(@NotNull City city2, boolean withIcon) {
        Intrinsics.checkNotNullParameter(city2, "city");
        return "";
    }

    public static /* synthetic */ String getProductionTooltip$default(PerpetualConstruction perpetualConstruction, City city2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getProductionTooltip");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return perpetualConstruction.getProductionTooltip(city2, bl);
    }

    @Override
    @NotNull
    public Counter<String> getStockpiledResourceRequirements(@NotNull StateForConditionals state) {
        Intrinsics.checkNotNullParameter(state, "state");
        return Counter.Companion.getZERO();
    }

    @Override
    public boolean isBuildable(@NotNull CityConstructions cityConstructions) {
        Intrinsics.checkNotNullParameter(cityConstructions, "cityConstructions");
        throw new Exception("Impossible!");
    }

    @Override
    @NotNull
    public Counter<String> getResourceRequirementsPerTurn(@Nullable StateForConditionals state) {
        return Counter.Companion.getZERO();
    }

    @Override
    @NotNull
    public Set<String> requiredResources(@NotNull StateForConditionals state) {
        Intrinsics.checkNotNullParameter(state, "state");
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Sequence<Unique> getMatchingUniquesNotConflicting(@NotNull UniqueType uniqueType, @NotNull StateForConditionals stateForConditionals) {
        return IConstruction.DefaultImpls.getMatchingUniquesNotConflicting(this, uniqueType, stateForConditionals);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(science.getName(), science), TuplesKt.to(gold.getName(), gold), TuplesKt.to(culture.getName(), culture), TuplesKt.to(faith.getName(), faith), TuplesKt.to(idle.getName(), idle)};
        perpetualConstructionsMap = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/unciv/models/ruleset/PerpetualConstruction$Companion;", "", "()V", "culture", "Lcom/unciv/models/ruleset/PerpetualStatConversion;", "getCulture", "()Lcom/unciv/models/ruleset/PerpetualStatConversion;", "faith", "getFaith", "gold", "getGold", "idle", "Lcom/unciv/models/ruleset/PerpetualConstruction;", "getIdle", "()Lcom/unciv/models/ruleset/PerpetualConstruction;", "perpetualConstructionsMap", "", "", "getPerpetualConstructionsMap", "()Ljava/util/Map;", "science", "getScience", "isNamePerpetual", "", "name", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PerpetualStatConversion getScience() {
            return science;
        }

        @NotNull
        public final PerpetualStatConversion getGold() {
            return gold;
        }

        @NotNull
        public final PerpetualStatConversion getCulture() {
            return culture;
        }

        @NotNull
        public final PerpetualStatConversion getFaith() {
            return faith;
        }

        @NotNull
        public final PerpetualConstruction getIdle() {
            return idle;
        }

        @NotNull
        public final Map<String, PerpetualConstruction> getPerpetualConstructionsMap() {
            return perpetualConstructionsMap;
        }

        public final boolean isNamePerpetual(@NotNull String name2) {
            Intrinsics.checkNotNullParameter(name2, "name");
            return ((CharSequence)name2).length() == 0 || this.getPerpetualConstructionsMap().containsKey(name2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

