/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.unique;

import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.battle.CombatAction;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.PolicyManager;
import com.unciv.logic.civilization.managers.ReligionManager;
import com.unciv.logic.civilization.managers.TechManager;
import com.unciv.logic.map.mapgenerator.mapregions.Region;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.tech.Technology;
import com.unciv.models.ruleset.unique.Conditionals;
import com.unciv.models.ruleset.unique.Countables;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.validation.ModCompatibility;
import com.unciv.models.stats.Stat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\f"}, d2={"Lcom/unciv/models/ruleset/unique/Conditionals;", "", "()V", "conditionalApplies", "", "unique", "Lcom/unciv/models/ruleset/unique/Unique;", "conditional", "state", "Lcom/unciv/models/ruleset/unique/StateForConditionals;", "getStateBasedRandom", "", "core"})
@SourceDebugExtension(value={"SMAP\nConditionals.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Conditionals.kt\ncom/unciv/models/ruleset/unique/Conditionals\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,348:1\n1747#2,3:349\n1247#3,2:352\n1247#3:354\n1247#3,2:355\n1248#3:357\n1268#3,3:358\n*S KotlinDebug\n*F\n+ 1 Conditionals.kt\ncom/unciv/models/ruleset/unique/Conditionals\n*L\n28#1:349,3\n257#1:352,2\n275#1:354\n276#1:355,2\n275#1:357\n285#1:358,3\n*E\n"})
public final class Conditionals {
    @NotNull
    public static final Conditionals INSTANCE = new Conditionals();

    private Conditionals() {
    }

    private final float getStateBasedRandom(StateForConditionals state, Unique unique) {
        GameInfo gameInfo = state.getGameInfo();
        int seed = gameInfo != null ? ((Object)gameInfo.getTurns()).hashCode() : 0;
        Unique unique2 = unique;
        seed = seed * 31 + (unique2 != null ? unique2.hashCode() : 0);
        seed = seed * 31 + state.hashCode();
        return RandomKt.Random(seed).nextFloat();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean conditionalApplies(@Nullable Unique unique, @NotNull Unique conditional, @NotNull StateForConditionals state) {
        boolean bl;
        Object it;
        Iterator<Object> iterator2;
        boolean $i$f$any;
        Sequence<Tile> $this$any$iv;
        Intrinsics.checkNotNullParameter(conditional, "conditional");
        Intrinsics.checkNotNullParameter(state, "state");
        Object object = conditional.getType();
        if (object != null && (object = object.getTargetTypes()) != null) {
            boolean bl2;
            $this$any$iv = (Iterable)object;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)((Object)$this$any$iv)).isEmpty()) {
                bl2 = false;
            } else {
                iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Object t = iterator2.next();
                    it = (UniqueTarget)((Object)t);
                    boolean bl3 = false;
                    if (((UniqueTarget)((Object)it)).getModifierType() == UniqueTarget.ModifierType.Other) {
                        return true;
                    }
                    boolean bl4 = false;
                    if (!bl4) continue;
                    return true;
                }
                bl2 = false;
            }
            if (bl2) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) {
            return true;
        }
        UniqueType uniqueType = conditional.getType();
        switch (uniqueType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[uniqueType.ordinal()]) {
            case 1: {
                if (!(this.getStateBasedRandom(state, unique) < Float.parseFloat(conditional.getParams().get(0)) / 100.0f)) return false;
                return true;
            }
            case 2: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, (Function1<? super GameInfo, Boolean>)new Function1<GameInfo, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GameInfo $this$checkOnGameInfo) {
                        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
                        return $this$checkOnGameInfo.getTurns() % Integer.parseInt(this.$conditional.getParams().get(0)) == 0;
                    }
                });
                return bl5;
            }
            case 3: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, (Function1<? super GameInfo, Boolean>)new Function1<GameInfo, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GameInfo $this$checkOnGameInfo) {
                        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
                        return $this$checkOnGameInfo.getTurns() < Integer.parseInt(this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 4: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, (Function1<? super GameInfo, Boolean>)new Function1<GameInfo, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GameInfo $this$checkOnGameInfo) {
                        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
                        return $this$checkOnGameInfo.getTurns() >= Integer.parseInt(this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 5: {
                boolean bl5 = UncivGame.Companion.getCurrent().getSettings().getShowTutorials();
                return bl5;
            }
            case 6: {
                boolean bl5 = UncivGame.Companion.getCurrent().getSettings().getTutorialTasksCompleted().contains(conditional.getParams().get(0));
                return bl5;
            }
            case 7: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(conditional, state){
                    final /* synthetic */ Unique $conditional;
                    final /* synthetic */ StateForConditionals $state;
                    {
                        this.$conditional = $conditional;
                        this.$state = $state;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                        return Civilization.matchesFilter$default($this$checkOnCiv, this.$conditional.getParams().get(0), this.$state, false, 4, null);
                    }
                });
                return bl5;
            }
            case 8: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, conditionalApplies.6.INSTANCE);
                return bl5;
            }
            case 9: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, conditionalApplies.7.INSTANCE);
                return bl5;
            }
            case 10: {
                if (state.getResourceAmount(conditional.getParams().get(0)) <= 0) return false;
                return true;
            }
            case 11: {
                if (state.getResourceAmount(conditional.getParams().get(0)) > 0) return false;
                return true;
            }
            case 12: {
                Unique unique2 = unique;
                boolean bl5 = Conditionals.conditionalApplies$checkResourceOrStatAmount(state, conditional.getParams().get(1), Float.parseFloat(conditional.getParams().get(0)), Float.MAX_VALUE, unique2 != null ? unique2.isModifiedByGameSpeed() : false, conditionalApplies.8.INSTANCE);
                return bl5;
            }
            case 13: {
                Unique unique3 = unique;
                boolean bl5 = Conditionals.conditionalApplies$checkResourceOrStatAmount(state, conditional.getParams().get(1), Float.MIN_VALUE, Float.parseFloat(conditional.getParams().get(0)), unique3 != null ? unique3.isModifiedByGameSpeed() : false, conditionalApplies.9.INSTANCE);
                return bl5;
            }
            case 14: {
                Unique unique4 = unique;
                boolean bl5 = Conditionals.conditionalApplies$checkResourceOrStatAmount(state, conditional.getParams().get(2), Float.parseFloat(conditional.getParams().get(0)), Float.parseFloat(conditional.getParams().get(1)), unique4 != null ? unique4.isModifiedByGameSpeed() : false, conditionalApplies.10.INSTANCE);
                return bl5;
            }
            case 15: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, conditionalApplies.11.INSTANCE);
                return bl5;
            }
            case 16: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                        int n = Integer.parseInt(this.$conditional.getParams().get(0));
                        int n2 = Integer.parseInt(this.$conditional.getParams().get(1));
                        int n3 = $this$checkOnCiv.getStats().getHappiness();
                        return n <= n3 ? n3 <= n2 : false;
                    }
                });
                return bl5;
            }
            case 17: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                        return $this$checkOnCiv.getStats().getHappiness() > Integer.parseInt(this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 18: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                        return $this$checkOnCiv.getStats().getHappiness() < Integer.parseInt(this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 19: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, conditionalApplies.15.INSTANCE);
                return bl5;
            }
            case 20: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, conditionalApplies.16.INSTANCE);
                return bl5;
            }
            case 21: {
                boolean bl5 = Conditionals.conditionalApplies$compareEra(state, conditional.getParams().get(0), conditionalApplies.17.INSTANCE);
                return bl5;
            }
            case 22: {
                boolean bl5 = Conditionals.conditionalApplies$compareEra(state, conditional.getParams().get(0), conditionalApplies.18.INSTANCE);
                return bl5;
            }
            case 23: {
                boolean bl5 = Conditionals.conditionalApplies$compareEra(state, conditional.getParams().get(0), conditionalApplies.19.INSTANCE);
                return bl5;
            }
            case 24: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, (Function1<? super GameInfo, Boolean>)new Function1<GameInfo, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GameInfo $this$checkOnGameInfo) {
                        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
                        return Intrinsics.areEqual($this$checkOnGameInfo.getGameParameters().getStartingEra(), this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 25: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, (Function1<? super GameInfo, Boolean>)new Function1<GameInfo, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GameInfo $this$checkOnGameInfo) {
                        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
                        return Intrinsics.areEqual($this$checkOnGameInfo.getGameParameters().getSpeed(), this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 26: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, (Function1<? super GameInfo, Boolean>)new Function1<GameInfo, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GameInfo $this$checkOnGameInfo) {
                        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
                        return Intrinsics.areEqual($this$checkOnGameInfo.getGameParameters().getDifficulty(), this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 27: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, (Function1<? super GameInfo, Boolean>)new Function1<GameInfo, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GameInfo $this$checkOnGameInfo) {
                        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
                        return $this$checkOnGameInfo.getGameParameters().getVictoryTypes().contains(this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 28: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, (Function1<? super GameInfo, Boolean>)new Function1<GameInfo, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GameInfo $this$checkOnGameInfo) {
                        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
                        return !$this$checkOnGameInfo.getGameParameters().getVictoryTypes().contains(this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 29: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, conditionalApplies.25.INSTANCE);
                return bl5;
            }
            case 30: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, conditionalApplies.26.INSTANCE);
                return bl5;
            }
            case 31: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, conditionalApplies.27.INSTANCE);
                return bl5;
            }
            case 32: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, conditionalApplies.28.INSTANCE);
                return bl5;
            }
            case 33: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, conditionalApplies.29.INSTANCE);
                return bl5;
            }
            case 34: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        boolean bl;
                        block5: {
                            Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                            String filter2 = this.$conditional.getParams().get(0);
                            if (((Map)$this$checkOnCiv.getGameInfo().getRuleset().getTechnologies()).containsKey(filter2)) {
                                bl = $this$checkOnCiv.getTech().isResearched(this.$conditional.getParams().get(0));
                            } else {
                                Iterable $this$any$iv = $this$checkOnCiv.getTech().getResearchedTechnologies();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        Technology it = (Technology)element$iv;
                                        boolean bl2 = false;
                                        if (!Technology.matchesFilter$default(it, filter2, null, false, 6, null)) continue;
                                        bl = true;
                                        break block5;
                                    }
                                    bl = false;
                                }
                            }
                        }
                        return bl;
                    }
                });
                return bl5;
            }
            case 35: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        boolean bl;
                        block5: {
                            Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                            String filter2 = this.$conditional.getParams().get(0);
                            if (((Map)$this$checkOnCiv.getGameInfo().getRuleset().getTechnologies()).containsKey(filter2)) {
                                bl = !$this$checkOnCiv.getTech().isResearched(this.$conditional.getParams().get(0));
                            } else {
                                Iterable $this$none$iv = $this$checkOnCiv.getTech().getResearchedTechnologies();
                                boolean $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    bl = true;
                                } else {
                                    for (T element$iv : $this$none$iv) {
                                        Technology it = (Technology)element$iv;
                                        boolean bl2 = false;
                                        if (!Technology.matchesFilter$default(it, filter2, null, false, 6, null)) continue;
                                        bl = false;
                                        break block5;
                                    }
                                    bl = true;
                                }
                            }
                        }
                        return bl;
                    }
                });
                return bl5;
            }
            case 36: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                        Technology technology2 = $this$checkOnCiv.getTech().currentTechnology();
                        return technology2 != null ? Technology.matchesFilter$default(technology2, this.$conditional.getParams().get(0), null, false, 6, null) : false;
                    }
                });
                return bl5;
            }
            case 37: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                        if (!$this$checkOnCiv.getPolicies().isAdopted(this.$conditional.getParams().get(0))) {
                            Religion religion = $this$checkOnCiv.getReligionManager().getReligion();
                            if (!(religion != null ? religion.hasBelief(this.$conditional.getParams().get(0)) : false)) {
                                bl = false;
                                return bl;
                            }
                        }
                        bl = true;
                        return bl;
                    }
                });
                return bl5;
            }
            case 38: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                        if (!$this$checkOnCiv.getPolicies().isAdopted(this.$conditional.getParams().get(0))) {
                            Religion religion = $this$checkOnCiv.getReligionManager().getReligion();
                            if (!(religion != null ? religion.hasBelief(this.$conditional.getParams().get(0)) : false)) {
                                bl = true;
                                return bl;
                            }
                        }
                        bl = false;
                        return bl;
                    }
                });
                return bl5;
            }
            case 39: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, conditionalApplies.35.INSTANCE);
                return bl5;
            }
            case 40: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, conditionalApplies.36.INSTANCE);
                return bl5;
            }
            case 41: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, conditionalApplies.37.INSTANCE);
                return bl5;
            }
            case 42: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, conditionalApplies.38.INSTANCE);
                return bl5;
            }
            case 43: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, conditionalApplies.39.INSTANCE);
                return bl5;
            }
            case 44: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, conditionalApplies.40.INSTANCE);
                return bl5;
            }
            case 45: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, conditionalApplies.41.INSTANCE);
                return bl5;
            }
            case 46: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        boolean bl;
                        block3: {
                            void $this$any$iv;
                            Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                            Iterable iterable = $this$checkOnCiv.getCities();
                            Unique unique = this.$conditional;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    City it = (City)element$iv;
                                    boolean bl2 = false;
                                    if (!it.getCityConstructions().containsBuildingOrEquivalent(unique.getParams().get(0))) continue;
                                    bl = true;
                                    break block3;
                                }
                                bl = false;
                            }
                        }
                        return bl;
                    }
                });
                return bl5;
            }
            case 47: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        boolean bl;
                        block3: {
                            void $this$none$iv;
                            Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                            Iterable iterable = $this$checkOnCiv.getCities();
                            Unique unique = this.$conditional;
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (T element$iv : $this$none$iv) {
                                    City it = (City)element$iv;
                                    boolean bl2 = false;
                                    if (!it.getCityConstructions().containsBuildingOrEquivalent(unique.getParams().get(0))) continue;
                                    bl = false;
                                    break block3;
                                }
                                bl = true;
                            }
                        }
                        return bl;
                    }
                });
                return bl5;
            }
            case 48: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        boolean bl;
                        block4: {
                            void $this$all$iv;
                            void $this$filterTo$iv$iv;
                            Iterable $this$filter$iv;
                            Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                            Iterable iterable = $this$checkOnCiv.getCities();
                            Unique unique = this.$conditional;
                            boolean $i$f$filter = false;
                            Iterator<T> iterator2 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                City it = (City)element$iv$iv;
                                boolean bl2 = false;
                                if (!City.matchesFilter$default(it, unique.getParams().get(1), null, false, 6, null)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            unique = this.$conditional;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (T element$iv : $this$all$iv) {
                                    City it = (City)element$iv;
                                    boolean bl3 = false;
                                    if (it.getCityConstructions().containsBuildingOrEquivalent(unique.getParams().get(0))) continue;
                                    bl = false;
                                    break block4;
                                }
                                bl = true;
                            }
                        }
                        return bl;
                    }
                });
                return bl5;
            }
            case 49: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        int n;
                        void $this$count$iv;
                        Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                        Iterable iterable = $this$checkOnCiv.getCities();
                        Unique unique = this.$conditional;
                        boolean $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n = 0;
                        } else {
                            int count$iv = 0;
                            for (T element$iv : $this$count$iv) {
                                City it = (City)element$iv;
                                boolean bl = false;
                                boolean bl2 = it.getCityConstructions().containsBuildingOrEquivalent(unique.getParams().get(0)) && City.matchesFilter$default(it, unique.getParams().get(2), null, false, 6, null);
                                if (!bl2 || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n = count$iv;
                        }
                        return n >= Integer.parseInt(this.$conditional.getParams().get(1));
                    }
                });
                return bl5;
            }
            case 50: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, (Function1<? super GameInfo, Boolean>)new Function1<GameInfo, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull GameInfo $this$checkOnGameInfo) {
                        boolean bl;
                        block1: {
                            void $this$any$iv;
                            Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
                            Sequence<City> sequence = $this$checkOnGameInfo.getCities();
                            Unique unique = this.$conditional;
                            boolean $i$f$any = false;
                            for (T element$iv : $this$any$iv) {
                                City it = (City)element$iv;
                                boolean bl2 = false;
                                if (!it.getCityConstructions().containsBuildingOrEquivalent(unique.getParams().get(0))) continue;
                                bl = true;
                                break block1;
                            }
                            bl = false;
                        }
                        return bl;
                    }
                });
                return bl5;
            }
            case 51: {
                if (state.getRelevantCity() == null) return false;
                return true;
            }
            case 52: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, (Function1<? super City, Boolean>)new Function1<City, Boolean>(conditional, state){
                    final /* synthetic */ Unique $conditional;
                    final /* synthetic */ StateForConditionals $state;
                    {
                        this.$conditional = $conditional;
                        this.$state = $state;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull City $this$checkOnCity) {
                        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
                        return City.matchesFilter$default($this$checkOnCity, this.$conditional.getParams().get(0), this.$state.getRelevantCiv(), false, 4, null);
                    }
                });
                return bl5;
            }
            case 53: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, conditionalApplies.48.INSTANCE);
                return bl5;
            }
            case 54: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, (Function1<? super City, Boolean>)new Function1<City, Boolean>(conditional, state){
                    final /* synthetic */ Unique $conditional;
                    final /* synthetic */ StateForConditionals $state;
                    {
                        this.$conditional = $conditional;
                        this.$state = $state;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull City $this$checkOnCity) {
                        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
                        Religion religion = $this$checkOnCity.getReligion().getMajorityReligion();
                        return religion != null ? religion.matchesFilter(this.$conditional.getParams().get(0), this.$state, this.$state.getRelevantCiv()) : false;
                    }
                });
                return bl5;
            }
            case 55: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, (Function1<? super City, Boolean>)new Function1<City, Boolean>(conditional, state){
                    final /* synthetic */ Unique $conditional;
                    final /* synthetic */ StateForConditionals $state;
                    {
                        this.$conditional = $conditional;
                        this.$state = $state;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull City $this$checkOnCity) {
                        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
                        Religion religion = $this$checkOnCity.getReligion().getMajorityReligion();
                        return !(religion != null ? religion.matchesFilter(this.$conditional.getParams().get(0), this.$state, this.$state.getRelevantCiv()) : false);
                    }
                });
                return bl5;
            }
            case 56: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, conditionalApplies.51.INSTANCE);
                return bl5;
            }
            case 57: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, conditionalApplies.52.INSTANCE);
                return bl5;
            }
            case 58: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, (Function1<? super City, Boolean>)new Function1<City, Boolean>(state){
                    final /* synthetic */ StateForConditionals $state;
                    {
                        this.$state = $state;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull City $this$checkOnCity) {
                        IsPartOfGameInfoSerialization isPartOfGameInfoSerialization;
                        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
                        return Intrinsics.areEqual($this$checkOnCity.getReligion().getMajorityReligion(), (isPartOfGameInfoSerialization = this.$state.getRelevantCiv()) != null && (isPartOfGameInfoSerialization = ((Civilization)isPartOfGameInfoSerialization).getReligionManager()) != null ? ((ReligionManager)isPartOfGameInfoSerialization).getReligion() : null);
                    }
                });
                return bl5;
            }
            case 59: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, conditionalApplies.54.INSTANCE);
                return bl5;
            }
            case 60: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, (Function1<? super City, Boolean>)new Function1<City, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull City $this$checkOnCity) {
                        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
                        return $this$checkOnCity.getCityConstructions().containsBuildingOrEquivalent(this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 61: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, (Function1<? super City, Boolean>)new Function1<City, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull City $this$checkOnCity) {
                        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
                        return !$this$checkOnCity.getCityConstructions().containsBuildingOrEquivalent(this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 62: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, (Function1<? super City, Boolean>)new Function1<City, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull City $this$checkOnCity) {
                        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
                        return $this$checkOnCity.getPopulation().getPopulationFilterAmount(this.$conditional.getParams().get(1)) >= Integer.parseInt(this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 63: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, (Function1<? super City, Boolean>)new Function1<City, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull City $this$checkOnCity) {
                        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
                        return $this$checkOnCity.getPopulation().getPopulationFilterAmount(this.$conditional.getParams().get(1)) == Integer.parseInt(this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 64: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, (Function1<? super City, Boolean>)new Function1<City, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull City $this$checkOnCity) {
                        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
                        int n = Integer.parseInt(this.$conditional.getParams().get(0));
                        int n2 = Integer.parseInt(this.$conditional.getParams().get(1));
                        int n3 = $this$checkOnCity.getPopulation().getPopulationFilterAmount(this.$conditional.getParams().get(2));
                        return n <= n3 ? n3 <= n2 : false;
                    }
                });
                return bl5;
            }
            case 65: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, (Function1<? super City, Boolean>)new Function1<City, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull City $this$checkOnCity) {
                        Intrinsics.checkNotNullParameter($this$checkOnCity, "$this$checkOnCity");
                        return $this$checkOnCity.getPopulation().getPopulationFilterAmount(this.$conditional.getParams().get(1)) < Integer.parseInt(this.$conditional.getParams().get(0));
                    }
                });
                return bl5;
            }
            case 66: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCity(state, conditionalApplies.61.INSTANCE);
                return bl5;
            }
            case 67: {
                ICombatant iCombatant = state.getTheirCombatant();
                if (iCombatant == null) return false;
                if (!iCombatant.matchesFilter("City", false)) return false;
                return true;
            }
            case 68: 
            case 69: {
                ICombatant iCombatant = state.getTheirCombatant();
                if (iCombatant == null) return false;
                if (!ICombatant.DefaultImpls.matchesFilter$default(iCombatant, conditional.getParams().get(0), false, 2, null)) return false;
                return true;
            }
            case 70: 
            case 71: {
                MapUnit mapUnit = state.getRelevantUnit();
                if (mapUnit == null) return false;
                if (!MapUnit.matchesFilter$default(mapUnit, conditional.getParams().get(0), false, 2, null)) return false;
                return true;
            }
            case 72: {
                if (state.getRelevantUnit() == null) return false;
                MapUnit mapUnit = state.getRelevantUnit();
                Intrinsics.checkNotNull(mapUnit);
                if (mapUnit.getPromotions().getPromotions().contains(conditional.getParams().get(0))) return true;
                MapUnit mapUnit2 = state.getRelevantUnit();
                Intrinsics.checkNotNull(mapUnit2);
                if (!mapUnit2.hasStatus(conditional.getParams().get(0))) return false;
                return true;
            }
            case 73: {
                if (state.getRelevantUnit() == null) return false;
                MapUnit mapUnit = state.getRelevantUnit();
                Intrinsics.checkNotNull(mapUnit);
                if (mapUnit.getPromotions().getPromotions().contains(conditional.getParams().get(0))) return false;
                MapUnit mapUnit3 = state.getRelevantUnit();
                Intrinsics.checkNotNull(mapUnit3);
                if (mapUnit3.hasStatus(conditional.getParams().get(0))) return false;
                return true;
            }
            case 74: {
                if (state.getCombatAction() != CombatAction.Attack) return false;
                return true;
            }
            case 75: {
                if (state.getCombatAction() != CombatAction.Defend) return false;
                return true;
            }
            case 76: {
                if (state.getRelevantUnit() != null) {
                    MapUnit mapUnit = state.getRelevantUnit();
                    Intrinsics.checkNotNull(mapUnit);
                    if (mapUnit.getHealth() > Integer.parseInt(conditional.getParams().get(0))) return true;
                }
                if (state.getOurCombatant() == null) return false;
                if (state.getOurCombatant().getHealth() <= Integer.parseInt(conditional.getParams().get(0))) return false;
                return true;
            }
            case 77: {
                if (state.getRelevantUnit() != null) {
                    MapUnit mapUnit = state.getRelevantUnit();
                    Intrinsics.checkNotNull(mapUnit);
                    if (mapUnit.getHealth() < Integer.parseInt(conditional.getParams().get(0))) return true;
                }
                if (state.getOurCombatant() == null) return false;
                if (state.getOurCombatant().getHealth() >= Integer.parseInt(conditional.getParams().get(0))) return false;
                return true;
            }
            case 78: {
                if (state.getUnit() == null) return true;
                if (!state.getUnit().getAbilityToTimesUsed().isEmpty()) return false;
                return true;
            }
            case 79: {
                Tile tile = state.getRelevantTile();
                if (tile == null) return false;
                if (!tile.matchesFilter(conditional.getParams().get(0), state.getRelevantCiv())) return false;
                return true;
            }
            case 80: {
                Tile tile = state.getRelevantTile();
                if (tile == null) return false;
                if (tile.matchesFilter(conditional.getParams().get(0), state.getRelevantCiv())) return false;
                return true;
            }
            case 81: {
                Tile tile = state.getRelevantTile();
                if (tile == null) return false;
                if (!tile.isAdjacentTo(conditional.getParams().get(0), state.getRelevantCiv())) return false;
                return true;
            }
            case 82: {
                Tile tile = state.getRelevantTile();
                if (tile == null) return false;
                if (tile.isAdjacentTo(conditional.getParams().get(0), state.getRelevantCiv())) return false;
                return true;
            }
            case 83: {
                Tile tile = state.getAttackedTile();
                if (tile == null) return false;
                if (!tile.matchesFilter(conditional.getParams().get(0), state.getRelevantCiv())) return false;
                return true;
            }
            case 84: {
                if (state.getRelevantTile() == null) return false;
                Tile tile = state.getRelevantTile();
                Intrinsics.checkNotNull(tile);
                $this$any$iv = tile.getTilesInDistance(Integer.parseInt(conditional.getParams().get(0)));
                $i$f$any = false;
                iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    Object object2 = iterator2.next();
                    it = (Tile)object2;
                    boolean bl6 = false;
                } while (!Tile.matchesFilter$default((Tile)it, conditional.getParams().get(1), null, 2, null));
                return true;
            }
            case 85: {
                Object object3 = state.getRelevantCiv();
                int yourCities = object3 != null && (object3 = ((Civilization)object3).getCities()) != null ? object3.size() : 1;
                Object object4 = state.getTheirCombatant();
                int theirCities = object4 != null && (object4 = object4.getCivInfo()) != null && (object4 = ((Civilization)object4).getCities()) != null ? object4.size() : 0;
                if (yourCities >= theirCities) return false;
                return true;
            }
            case 86: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnCiv(state, (Function1<? super Civilization, Boolean>)new Function1<Civilization, Boolean>(state){
                    final /* synthetic */ StateForConditionals $state;
                    {
                        this.$state = $state;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull Civilization $this$checkOnCiv) {
                        boolean bl;
                        block2: {
                            block3: {
                                Intrinsics.checkNotNullParameter($this$checkOnCiv, "$this$checkOnCiv");
                                if (this.$state.getRelevantTile() == null) break block2;
                                if ($this$checkOnCiv.getCities().isEmpty() || Civilization.getCapital$default($this$checkOnCiv, false, 1, null) == null) break block3;
                                City city2 = Civilization.getCapital$default($this$checkOnCiv, false, 1, null);
                                Intrinsics.checkNotNull(city2);
                                int n = city2.getCenterTile().getContinent();
                                Tile tile = this.$state.getRelevantTile();
                                Intrinsics.checkNotNull(tile);
                                if (n == tile.getContinent()) break block2;
                            }
                            bl = true;
                            return bl;
                        }
                        bl = false;
                        return bl;
                    }
                });
                return bl5;
            }
            case 87: {
                boolean bl7;
                if (state.getRelevantCiv() == null) return false;
                if (state.getRelevantUnit() == null) return false;
                Tile tile = state.getRelevantTile();
                Intrinsics.checkNotNull(tile);
                $this$any$iv = tile.getNeighbors();
                $i$f$any = false;
                iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    Object object5 = iterator2.next();
                    it = (Tile)object5;
                    boolean bl8 = false;
                    Sequence<MapUnit> $this$any$iv2 = ((Tile)it).getUnits();
                    boolean $i$f$any2 = false;
                    Iterator<MapUnit> iterator3 = $this$any$iv2.iterator();
                    while (iterator3.hasNext()) {
                        MapUnit element$iv;
                        MapUnit it2 = element$iv = iterator3.next();
                        boolean bl9 = false;
                        if (!Intrinsics.areEqual(it2, state.getRelevantUnit()) && Intrinsics.areEqual(it2.getCiv(), state.getRelevantCiv()) && MapUnit.matchesFilter$default(it2, conditional.getParams().get(0), false, 2, null)) {
                            return true;
                        }
                        boolean bl10 = false;
                        if (!bl10) continue;
                        return true;
                    }
                    bl7 = false;
                } while (!bl7);
                return true;
            }
            case 88: {
                if (state.getRelevantTile() == null) return false;
                int n = Integer.parseInt(conditional.getParams().get(0));
                int n2 = Integer.parseInt(conditional.getParams().get(1));
                Tile tile = state.getRelevantTile();
                Intrinsics.checkNotNull(tile);
                Sequence<Tile> sequence = tile.getNeighbors();
                boolean $i$f$count = false;
                int count$iv = 0;
                Iterator<Tile> iterator4 = sequence.iterator();
                while (iterator4.hasNext()) {
                    Tile element$iv;
                    Tile it3 = element$iv = iterator4.next();
                    boolean bl11 = false;
                    if (!it3.matchesFilter(conditional.getParams().get(2), state.getRelevantCiv()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int n3 = count$iv;
                if (n > n3) return false;
                if (n3 > n2) return false;
                return true;
            }
            case 89: {
                Region region = state.getRegion();
                if (region == null) return false;
                if (region.getContinentID() != -1) return false;
                return true;
            }
            case 90: {
                Region region = state.getRegion();
                boolean bl5 = Intrinsics.areEqual(region != null ? region.getType() : null, conditional.getParams().get(0));
                return bl5;
            }
            case 91: {
                Region region = state.getRegion();
                if (Intrinsics.areEqual(region != null ? region.getType() : null, conditional.getParams().get(0))) return false;
                return true;
            }
            case 92: {
                if (unique == null) return false;
                if (unique.getSourceObjectType() != UniqueTarget.Tech) return false;
                if (!Conditionals.conditionalApplies$checkOnGameInfo(state, (Function1<? super GameInfo, Boolean>)new Function1<GameInfo, Boolean>(state, unique){
                    final /* synthetic */ StateForConditionals $state;
                    final /* synthetic */ Unique $unique;
                    {
                        this.$state = $state;
                        this.$unique = $unique;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull GameInfo $this$checkOnGameInfo) {
                        boolean bl;
                        boolean bl2;
                        void $this$none$iv;
                        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
                        Iterable iterable = $this$checkOnGameInfo.getCivilizations();
                        StateForConditionals stateForConditionals = this.$state;
                        Unique unique = this.$unique;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl2 = true;
                            return bl2;
                        }
                        Iterator<T> iterator2 = $this$none$iv.iterator();
                        do {
                            if (!iterator2.hasNext()) {
                                bl2 = true;
                                return bl2;
                            }
                            T element$iv = iterator2.next();
                            Civilization it = (Civilization)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(it, stateForConditionals.getRelevantCiv()) && it.isMajorCiv()) {
                                TechManager techManager = it.getTech();
                                String string = unique.getSourceObjectName();
                                Intrinsics.checkNotNull(string);
                                if (techManager.isResearched(string)) {
                                    bl = true;
                                    continue;
                                }
                            }
                            bl = false;
                        } while (!bl);
                        bl2 = false;
                        return bl2;
                    }
                })) return false;
                return true;
            }
            case 93: {
                if (unique == null) return false;
                if (unique.getSourceObjectType() != UniqueTarget.Policy) return false;
                if (!Conditionals.conditionalApplies$checkOnGameInfo(state, (Function1<? super GameInfo, Boolean>)new Function1<GameInfo, Boolean>(state, unique){
                    final /* synthetic */ StateForConditionals $state;
                    final /* synthetic */ Unique $unique;
                    {
                        this.$state = $state;
                        this.$unique = $unique;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull GameInfo $this$checkOnGameInfo) {
                        boolean bl;
                        boolean bl2;
                        void $this$none$iv;
                        Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
                        Iterable iterable = $this$checkOnGameInfo.getCivilizations();
                        StateForConditionals stateForConditionals = this.$state;
                        Unique unique = this.$unique;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl2 = true;
                            return bl2;
                        }
                        Iterator<T> iterator2 = $this$none$iv.iterator();
                        do {
                            if (!iterator2.hasNext()) {
                                bl2 = true;
                                return bl2;
                            }
                            T element$iv = iterator2.next();
                            Civilization it = (Civilization)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(it, stateForConditionals.getRelevantCiv()) && it.isMajorCiv()) {
                                PolicyManager policyManager = it.getPolicies();
                                String string = unique.getSourceObjectName();
                                Intrinsics.checkNotNull(string);
                                if (policyManager.isAdopted(string)) {
                                    bl = true;
                                    continue;
                                }
                            }
                            bl = false;
                        } while (!bl);
                        bl2 = false;
                        return bl2;
                    }
                })) return false;
                return true;
            }
            case 94: {
                boolean bl5 = Conditionals.conditionalApplies$compareCountables(state, conditional.getParams().get(0), conditional.getParams().get(1), conditionalApplies.68.INSTANCE);
                return bl5;
            }
            case 95: {
                boolean bl5 = Conditionals.conditionalApplies$compareCountables(state, conditional.getParams().get(0), conditional.getParams().get(1), conditionalApplies.69.INSTANCE);
                return bl5;
            }
            case 96: {
                boolean bl5 = Conditionals.conditionalApplies$compareCountables(state, conditional.getParams().get(0), conditional.getParams().get(1), conditionalApplies.70.INSTANCE);
                return bl5;
            }
            case 97: {
                boolean bl5 = Conditionals.conditionalApplies$compareCountables(state, conditional.getParams().get(0), conditional.getParams().get(1), conditionalApplies.71.INSTANCE);
                return bl5;
            }
            case 98: {
                boolean bl5 = Conditionals.conditionalApplies$compareCountables$1(state, conditional.getParams().get(0), conditional.getParams().get(1), conditional.getParams().get(2), conditionalApplies.72.INSTANCE);
                return bl5;
            }
            case 99: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, (Function1<? super GameInfo, Boolean>)new Function1<GameInfo, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GameInfo $this$checkOnGameInfo) {
                        boolean bl;
                        block1: {
                            Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
                            String filter2 = this.$conditional.getParams().get(0);
                            Sequence<String> $this$any$iv = SequencesKt.plus(CollectionsKt.asSequence((Iterable)$this$checkOnGameInfo.getGameParameters().getMods()), $this$checkOnGameInfo.getGameParameters().getBaseRuleset());
                            boolean $i$f$any = false;
                            Iterator<String> iterator2 = $this$any$iv.iterator();
                            while (iterator2.hasNext()) {
                                String element$iv;
                                String it = element$iv = iterator2.next();
                                boolean bl2 = false;
                                if (!ModCompatibility.INSTANCE.modNameFilter(it, filter2)) continue;
                                bl = true;
                                break block1;
                            }
                            bl = false;
                        }
                        return bl;
                    }
                });
                return bl5;
            }
            case 100: {
                boolean bl5 = Conditionals.conditionalApplies$checkOnGameInfo(state, (Function1<? super GameInfo, Boolean>)new Function1<GameInfo, Boolean>(conditional){
                    final /* synthetic */ Unique $conditional;
                    {
                        this.$conditional = $conditional;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull GameInfo $this$checkOnGameInfo) {
                        boolean bl;
                        block1: {
                            Intrinsics.checkNotNullParameter($this$checkOnGameInfo, "$this$checkOnGameInfo");
                            String filter2 = this.$conditional.getParams().get(0);
                            Sequence<String> $this$none$iv = SequencesKt.plus(CollectionsKt.asSequence((Iterable)$this$checkOnGameInfo.getGameParameters().getMods()), $this$checkOnGameInfo.getGameParameters().getBaseRuleset());
                            boolean $i$f$none = false;
                            Iterator<String> iterator2 = $this$none$iv.iterator();
                            while (iterator2.hasNext()) {
                                String element$iv;
                                String it = element$iv = iterator2.next();
                                boolean bl2 = false;
                                if (!ModCompatibility.INSTANCE.modNameFilter(it, filter2)) continue;
                                bl = false;
                                break block1;
                            }
                            bl = true;
                        }
                        return bl;
                    }
                });
                return bl5;
            }
            default: {
                return false;
            }
        }
    }

    private static final boolean conditionalApplies$checkOnGameInfo(StateForConditionals $state, Function1<? super GameInfo, Boolean> predicate) {
        if ($state.getGameInfo() == null) {
            return false;
        }
        return predicate.invoke($state.getGameInfo());
    }

    private static final boolean conditionalApplies$checkOnCiv(StateForConditionals $state, Function1<? super Civilization, Boolean> predicate) {
        if ($state.getRelevantCiv() == null) {
            return false;
        }
        Civilization civilization = $state.getRelevantCiv();
        Intrinsics.checkNotNull(civilization);
        return predicate.invoke(civilization);
    }

    private static final boolean conditionalApplies$checkOnCity(StateForConditionals $state, Function1<? super City, Boolean> predicate) {
        if ($state.getRelevantCity() == null) {
            return false;
        }
        City city2 = $state.getRelevantCity();
        Intrinsics.checkNotNull(city2);
        return predicate.invoke(city2);
    }

    private static final boolean conditionalApplies$compareEra(StateForConditionals $state, String eraParam, Function2<? super Integer, ? super Integer, Boolean> compare) {
        if ($state.getGameInfo() == null) {
            return false;
        }
        Era era2 = $state.getGameInfo().getRuleset().getEras().get(eraParam);
        if (era2 == null) {
            return false;
        }
        Era era3 = era2;
        Civilization civilization = $state.getRelevantCiv();
        Intrinsics.checkNotNull(civilization);
        return compare.invoke((Integer)civilization.getEraNumber(), (Integer)era3.getEraNumber());
    }

    private static final boolean conditionalApplies$checkResourceOrStatAmount(StateForConditionals $state, String resourceOrStatName, float lowerLimit, float upperLimit, boolean modifyByGameSpeed, Function3<? super Integer, ? super Float, ? super Float, Boolean> compare) {
        float f;
        float gameSpeedModifier;
        if ($state.getGameInfo() == null) {
            return false;
        }
        float f2 = gameSpeedModifier = modifyByGameSpeed ? $state.getGameInfo().getSpeed().getModifier() : 1.0f;
        if ($state.getGameInfo().getRuleset().getTileResources().containsKey(resourceOrStatName)) {
            return compare.invoke((Integer)$state.getResourceAmount(resourceOrStatName), Float.valueOf(lowerLimit * gameSpeedModifier), Float.valueOf(upperLimit * gameSpeedModifier));
        }
        Stat stat = Stat.Companion.safeValueOf(resourceOrStatName);
        if (stat == null) {
            return false;
        }
        Stat stat2 = stat;
        int statReserve = $state.getStatAmount(stat2);
        if (modifyByGameSpeed) {
            Float f3 = $state.getGameInfo().getSpeed().getStatCostModifiers().get(stat2);
            Intrinsics.checkNotNull(f3);
            f = ((Number)f3).floatValue();
        } else {
            f = 1.0f;
        }
        gameSpeedModifier = f;
        return compare.invoke((Integer)statReserve, Float.valueOf(lowerLimit * gameSpeedModifier), Float.valueOf(upperLimit * gameSpeedModifier));
    }

    static /* synthetic */ boolean conditionalApplies$checkResourceOrStatAmount$default(StateForConditionals stateForConditionals, String string, float f, float f2, boolean bl, Function3 function3, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return Conditionals.conditionalApplies$checkResourceOrStatAmount(stateForConditionals, string, f, f2, bl, function3);
    }

    private static final boolean conditionalApplies$compareCountables(StateForConditionals $state, String first2, String second2, Function2<? super Integer, ? super Integer, Boolean> compare) {
        Integer firstNumber = Countables.Companion.getCountableAmount(first2, $state);
        Integer secondNumber = Countables.Companion.getCountableAmount(second2, $state);
        return firstNumber != null && secondNumber != null ? compare.invoke(firstNumber, secondNumber) : false;
    }

    private static final boolean conditionalApplies$compareCountables$1(StateForConditionals $state, String first2, String second2, String third, Function3<? super Integer, ? super Integer, ? super Integer, Boolean> compare) {
        Integer firstNumber = Countables.Companion.getCountableAmount(first2, $state);
        Integer secondNumber = Countables.Companion.getCountableAmount(second2, $state);
        Integer thirdNumber = Countables.Companion.getCountableAmount(third, $state);
        return firstNumber != null && secondNumber != null && thirdNumber != null ? compare.invoke(firstNumber, secondNumber, thirdNumber) : false;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UniqueType.values().length];
            try {
                nArray[UniqueType.ConditionalChance.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalEveryTurns.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBeforeTurns.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAfterTurns.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalTutorialsEnabled.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalTutorialCompleted.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCivFilter.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWar.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNotWar.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWithResource.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWithoutResource.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWhenAboveAmountStatResource.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWhenBelowAmountStatResource.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWhenBetweenStatResource.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalHappy.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBetweenHappiness.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAboveHappiness.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBelowHappiness.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalGoldenAge.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNotGoldenAge.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBeforeEra.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalStartingFromEra.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalDuringEra.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalIfStartingInEra.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalSpeed.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalDifficulty.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalVictoryEnabled.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalVictoryDisabled.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalReligionEnabled.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalReligionDisabled.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalEspionageEnabled.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalEspionageDisabled.ordinal()] = 32;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNuclearWeaponsEnabled.ordinal()] = 33;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalTech.ordinal()] = 34;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNoTech.ordinal()] = 35;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWhileResearching.ordinal()] = 36;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAfterPolicyOrBelief.ordinal()] = 37;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBeforePolicyOrBelief.ordinal()] = 38;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBeforePantheon.ordinal()] = 39;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAfterPantheon.ordinal()] = 40;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBeforeReligion.ordinal()] = 41;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAfterReligion.ordinal()] = 42;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBeforeEnhancingReligion.ordinal()] = 43;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAfterEnhancingReligion.ordinal()] = 44;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAfterGeneratingGreatProphet.ordinal()] = 45;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBuildingBuilt.ordinal()] = 46;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBuildingNotBuilt.ordinal()] = 47;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBuildingBuiltAll.ordinal()] = 48;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBuildingBuiltAmount.ordinal()] = 49;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBuildingBuiltByAnybody.ordinal()] = 50;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalInThisCity.ordinal()] = 51;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityFilter.ordinal()] = 52;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityConnected.ordinal()] = 53;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityReligion.ordinal()] = 54;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityNotReligion.ordinal()] = 55;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityMajorReligion.ordinal()] = 56;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityEnhancedReligion.ordinal()] = 57;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityThisReligion.ordinal()] = 58;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWLTKD.ordinal()] = 59;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityWithBuilding.ordinal()] = 60;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCityWithoutBuilding.ordinal()] = 61;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalPopulationFilter.ordinal()] = 62;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalExactPopulationFilter.ordinal()] = 63;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBetweenPopulationFilter.ordinal()] = 64;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBelowPopulationFilter.ordinal()] = 65;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalWhenGarrisoned.ordinal()] = 66;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalVsCity.ordinal()] = 67;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalVsUnits.ordinal()] = 68;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalVsCombatant.ordinal()] = 69;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalOurUnit.ordinal()] = 70;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalOurUnitOnUnit.ordinal()] = 71;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalUnitWithPromotion.ordinal()] = 72;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalUnitWithoutPromotion.ordinal()] = 73;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAttacking.ordinal()] = 74;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalDefending.ordinal()] = 75;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAboveHP.ordinal()] = 76;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalBelowHP.ordinal()] = 77;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalHasNotUsedOtherActions.ordinal()] = 78;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalInTiles.ordinal()] = 79;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalInTilesNot.ordinal()] = 80;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAdjacentTo.ordinal()] = 81;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNotAdjacentTo.ordinal()] = 82;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalFightingInTiles.ordinal()] = 83;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNearTiles.ordinal()] = 84;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalVsLargerCiv.ordinal()] = 85;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalForeignContinent.ordinal()] = 86;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalAdjacentUnit.ordinal()] = 87;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalNeighborTiles.ordinal()] = 88;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalOnWaterMaps.ordinal()] = 89;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalInRegionOfType.ordinal()] = 90;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalInRegionExceptOfType.ordinal()] = 91;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalFirstCivToResearch.ordinal()] = 92;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalFirstCivToAdopt.ordinal()] = 93;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCountableEqualTo.ordinal()] = 94;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCountableDifferentThan.ordinal()] = 95;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCountableMoreThan.ordinal()] = 96;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCountableLessThan.ordinal()] = 97;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalCountableBetween.ordinal()] = 98;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalModEnabled.ordinal()] = 99;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UniqueType.ConditionalModNotEnabled.ordinal()] = 100;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

