/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.unciv.models.ruleset.ModOptions;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.validation.RulesetError;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.models.ruleset.validation.Suppression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 !2\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001!B\u0011\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0017J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J0\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\t2\b\b\u0002\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0016\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u001a\u0010\u0018\u001a\u00020\t2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\u001aJ\u0010\u0010\u0018\u001a\u00020\t2\b\b\u0002\u0010\u001b\u001a\u00020\u000bJ\u0006\u0010\u001c\u001a\u00020\u0013J\u0006\u0010\u001d\u001a\u00020\u000bJ\u0006\u0010\u001e\u001a\u00020\u000bJ\u0006\u0010\u001f\u001a\u00020\u000bJ\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "Ljava/util/ArrayList;", "Lcom/unciv/models/ruleset/validation/RulesetError;", "Lkotlin/collections/ArrayList;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "(Lcom/unciv/models/ruleset/Ruleset;)V", "globalSuppressionFilters", "", "", "add", "", "element", "sourceObject", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "sourceUnique", "Lcom/unciv/models/ruleset/unique/Unique;", "text", "errorSeverityToReport", "Lcom/unciv/models/ruleset/validation/RulesetErrorSeverity;", "addAll", "elements", "", "addWithDuplicateCheck", "getErrorText", "filter", "Lkotlin/Function1;", "unfiltered", "getFinalSeverity", "isError", "isNotOK", "isWarnUser", "removeLowerSeverityDuplicate", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nRulesetErrorList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RulesetErrorList.kt\ncom/unciv/models/ruleset/validation/RulesetErrorList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n288#2,2:129\n766#2:132\n857#2,2:133\n1054#2:135\n1#3:131\n*S KotlinDebug\n*F\n+ 1 RulesetErrorList.kt\ncom/unciv/models/ruleset/validation/RulesetErrorList\n*L\n81#1:129,2\n103#1:132\n103#1:133,2\n104#1:135\n*E\n"})
public final class RulesetErrorList
extends ArrayList<RulesetError> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> globalSuppressionFilters;

    public RulesetErrorList(@Nullable Ruleset ruleset2) {
        Set set2;
        Sequence sequence;
        Sequence<Unique> sequence2;
        ModOptions modOptions;
        this.globalSuppressionFilters = ruleset2 != null && (modOptions = ruleset2.getModOptions()) != null && (sequence2 = modOptions.getMatchingUniques(UniqueType.SuppressWarnings, StateForConditionals.Companion.getIgnoreConditionals())) != null && (sequence = SequencesKt.map(sequence2, globalSuppressionFilters.1.INSTANCE)) != null && (set2 = SequencesKt.toSet(sequence)) != null ? set2 : SetsKt.emptySet();
    }

    public /* synthetic */ RulesetErrorList(Ruleset ruleset2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ruleset2 = null;
        }
        this(ruleset2);
    }

    public final boolean add(@NotNull RulesetError element, @Nullable IHasUniques sourceObject, @Nullable Unique sourceUnique) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (!this.removeLowerSeverityDuplicate(element)) {
            return false;
        }
        if (Suppression.INSTANCE.isErrorSuppressed$core((Collection<String>)this.globalSuppressionFilters, sourceObject, sourceUnique, element)) {
            return false;
        }
        return super.add(element);
    }

    public static /* synthetic */ boolean add$default(RulesetErrorList rulesetErrorList, RulesetError rulesetError, IHasUniques iHasUniques, Unique unique, int n, Object object) {
        if ((n & 4) != 0) {
            unique = null;
        }
        return rulesetErrorList.add(rulesetError, iHasUniques, unique);
    }

    public final boolean add(@NotNull String text2, @NotNull RulesetErrorSeverity errorSeverityToReport, @Nullable IHasUniques sourceObject, @Nullable Unique sourceUnique) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter((Object)errorSeverityToReport, "errorSeverityToReport");
        return this.add(new RulesetError(text2, errorSeverityToReport), sourceObject, sourceUnique);
    }

    public static /* synthetic */ boolean add$default(RulesetErrorList rulesetErrorList, String string, RulesetErrorSeverity rulesetErrorSeverity, IHasUniques iHasUniques, Unique unique, int n, Object object) {
        if ((n & 2) != 0) {
            rulesetErrorSeverity = RulesetErrorSeverity.Error;
        }
        if ((n & 4) != 0) {
            iHasUniques = null;
        }
        if ((n & 8) != 0) {
            unique = null;
        }
        return rulesetErrorList.add(string, rulesetErrorSeverity, iHasUniques, unique);
    }

    @Override
    @Deprecated(message="No adding without explicit source object", replaceWith=@ReplaceWith(expression="add(element, sourceObject, sourceUnique)", imports={}))
    public boolean add(@NotNull RulesetError element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return super.add(element);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends RulesetError> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        boolean result2 = false;
        for (RulesetError rulesetError : elements) {
            if (!this.addWithDuplicateCheck(rulesetError)) continue;
            result2 = true;
        }
        return result2;
    }

    private final boolean addWithDuplicateCheck(RulesetError element) {
        return this.removeLowerSeverityDuplicate(element) && super.add(element);
    }

    private final boolean removeLowerSeverityDuplicate(RulesetError element) {
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RulesetError it = (RulesetError)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getText(), element.getText())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        RulesetError rulesetError = v0;
        if (rulesetError == null) {
            return true;
        }
        RulesetError existing = rulesetError;
        if (existing.getErrorSeverityToReport().compareTo((Enum)element.getErrorSeverityToReport()) >= 0) {
            return false;
        }
        this.remove((Object)existing);
        return true;
    }

    @NotNull
    public final RulesetErrorSeverity getFinalSeverity() {
        if (this.isEmpty()) {
            return RulesetErrorSeverity.OK;
        }
        Iterator iterator2 = ((Iterable)this).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        RulesetError it = (RulesetError)iterator2.next();
        boolean bl = false;
        Comparable comparable = (Comparable)((Object)it.getErrorSeverityToReport());
        while (iterator2.hasNext()) {
            RulesetError it2 = (RulesetError)iterator2.next();
            $i$a$-maxOf-RulesetErrorList$getFinalSeverity$1 = false;
            Comparable comparable2 = (Comparable)((Object)it2.getErrorSeverityToReport());
            if (comparable.compareTo(comparable2) >= 0) continue;
            comparable = comparable2;
        }
        return (RulesetErrorSeverity)((Object)comparable);
    }

    public final boolean isError() {
        return this.getFinalSeverity() == RulesetErrorSeverity.Error;
    }

    public final boolean isNotOK() {
        return this.getFinalSeverity() != RulesetErrorSeverity.OK;
    }

    public final boolean isWarnUser() {
        return this.getFinalSeverity().compareTo((Enum)RulesetErrorSeverity.Warning) >= 0;
    }

    @NotNull
    public final String getErrorText(boolean unfiltered) {
        return this.getErrorText((Function1<? super RulesetError, Boolean>)new Function1<RulesetError, Boolean>(unfiltered){
            final /* synthetic */ boolean $unfiltered;
            {
                this.$unfiltered = $unfiltered;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull RulesetError it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$unfiltered || it.getErrorSeverityToReport().compareTo((Enum)RulesetErrorSeverity.WarningOptionsOnly) > 0;
            }
        });
    }

    public static /* synthetic */ String getErrorText$default(RulesetErrorList rulesetErrorList, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return rulesetErrorList.getErrorText(bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getErrorText(@NotNull Function1<? super RulesetError, Boolean> filter2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Iterable $this$filter$iv = this;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!filter2.invoke((RulesetError)element$iv$iv).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.joinToString$default(CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                RulesetError it = (RulesetError)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getErrorSeverityToReport());
                it = (RulesetError)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getErrorSeverityToReport()));
            }
        }), "\n", null, null, 0, null, getErrorText.3.INSTANCE, 30, null);
    }

    public RulesetErrorList() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/unciv/models/ruleset/validation/RulesetErrorList$Companion;", "", "()V", "of", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "text", "", "severity", "Lcom/unciv/models/ruleset/validation/RulesetErrorSeverity;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "sourceObject", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "sourceUnique", "Lcom/unciv/models/ruleset/unique/Unique;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RulesetErrorList of(@NotNull String text2, @NotNull RulesetErrorSeverity severity, @Nullable Ruleset ruleset2, @Nullable IHasUniques sourceObject, @Nullable Unique sourceUnique) {
            Intrinsics.checkNotNullParameter(text2, "text");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            RulesetErrorList result2 = new RulesetErrorList(ruleset2);
            result2.add(text2, severity, sourceObject, sourceUnique);
            return result2;
        }

        public static /* synthetic */ RulesetErrorList of$default(Companion companion, String string, RulesetErrorSeverity rulesetErrorSeverity, Ruleset ruleset2, IHasUniques iHasUniques, Unique unique, int n, Object object) {
            if ((n & 2) != 0) {
                rulesetErrorSeverity = RulesetErrorSeverity.Error;
            }
            if ((n & 4) != 0) {
                ruleset2 = null;
            }
            if ((n & 8) != 0) {
                iHasUniques = null;
            }
            if ((n & 0x10) != 0) {
                unique = null;
            }
            return companion.of(string, rulesetErrorSeverity, ruleset2, iHasUniques, unique);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

