/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.validation;

import com.unciv.Constants;
import com.unciv.logic.map.mapunit.MapUnitCache;
import com.unciv.models.ruleset.IRulesetObject;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.Countables;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueComplianceError;
import com.unciv.models.ruleset.unique.UniqueFlag;
import com.unciv.models.ruleset.unique.UniqueParameterType;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unique.expressions.Expressions;
import com.unciv.models.ruleset.unique.expressions.Parser;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.models.ruleset.validation.TextSimilarityKt;
import com.unciv.models.ruleset.validation.UniqueValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\b\u0018\u0000 52\u00020\u0001:\u00015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J*\u0010\"\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J*\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u001fH\u0002J(\u0010(\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010)\u001a\u00020!2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!J&\u0010*\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020!J*\u0010,\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010)\u001a\u00020!2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020%0.2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\u001a\u0010/\u001a\u0004\u0018\u00010\r2\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\u0007H\u0002J\u0010\u00102\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002J\u0006\u00103\u001a\u00020\u0017J\"\u00104\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rj\u0010\n\u001a^\u0012\u0004\u0012\u00020\f\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bj\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\r`\u000e0\u000bj.\u0012\u0004\u0012\u00020\f\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bj\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\r`\u000e`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00066\u00b2\u0006\n\u0010\u001c\u001a\u00020\u0007X\u008a\u0084\u0002"}, d2={"Lcom/unciv/models/ruleset/validation/UniqueValidator;", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "(Lcom/unciv/models/ruleset/Ruleset;)V", "allNonTypedUniques", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "allUniqueParameters", "paramTypeErrorSeverityCache", "Ljava/util/HashMap;", "Lcom/unciv/models/ruleset/unique/UniqueParameterType;", "Lcom/unciv/models/ruleset/unique/UniqueType$UniqueParameterErrorSeverity;", "Lkotlin/collections/HashMap;", "performanceHeavyConditionals", "", "Lcom/unciv/models/ruleset/unique/UniqueType;", "resourceConditionals", "resourceUniques", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "addConditionalErrors", "", "conditional", "Lcom/unciv/models/ruleset/unique/Unique;", "rulesetErrors", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "prefix", "unique", "uniqueContainer", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "reportRulesetSpecificErrors", "", "addDeprecationAnnotationErrors", "addExpressionParseErrors", "complianceError", "Lcom/unciv/models/ruleset/unique/UniqueComplianceError;", "addToHashsets", "uniqueHolder", "checkUnique", "tryFixUnknownUniques", "checkUniques", "lines", "checkUntypedUnique", "getComplianceErrors", "", "getParamTypeErrorSeverityCached", "uniqueParameterType", "param", "isFilteringUniqueAllowed", "populateFilteringUniqueHashsets", "tryFixUnknownUnique", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nUniqueValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniqueValidator.kt\ncom/unciv/models/ruleset/validation/UniqueValidator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,413:1\n1313#2,2:414\n766#3:416\n857#3,2:417\n533#3,6:419\n288#3,2:425\n1747#3,3:427\n766#3:430\n857#3,2:431\n2624#3,3:433\n2624#3,3:436\n766#3:439\n857#3,2:440\n1549#3:442\n1620#3,3:443\n1603#3,9:446\n1855#3:455\n1856#3:457\n1612#3:458\n1549#3:459\n1620#3,3:460\n1747#3,3:463\n2333#3,14:466\n766#3:483\n857#3,2:484\n766#3:486\n857#3,2:487\n1#4:456\n1099#5,3:480\n*S KotlinDebug\n*F\n+ 1 UniqueValidator.kt\ncom/unciv/models/ruleset/validation/UniqueValidator\n*L\n36#1:414,2\n97#1:416\n97#1:417,2\n99#1:419,6\n100#1:425,2\n111#1:427,3\n190#1:430\n190#1:431,2\n205#1:433,3\n213#1:436,3\n286#1:439\n286#1:440,2\n287#1:442\n287#1:443,3\n288#1:446,9\n288#1:455\n288#1:457\n288#1:458\n316#1:459\n316#1:460,3\n317#1:463,3\n322#1:466,14\n371#1:483\n371#1:484,2\n378#1:486\n378#1:487,2\n288#1:456\n343#1:480,3\n*E\n"})
public final class UniqueValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ruleset ruleset;
    @NotNull
    private final HashSet<String> allNonTypedUniques;
    @NotNull
    private final HashSet<String> allUniqueParameters;
    @NotNull
    private final Set<UniqueType> performanceHeavyConditionals;
    @NotNull
    private final Set<UniqueType> resourceUniques;
    @NotNull
    private final Set<UniqueType> resourceConditionals;
    @NotNull
    private final HashMap<UniqueParameterType, HashMap<String, UniqueType.UniqueParameterErrorSeverity>> paramTypeErrorSeverityCache;
    @NotNull
    public static final String whichDoesNotFitParameterType = "which does not fit parameter type";

    public UniqueValidator(@NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        this.ruleset = ruleset2;
        this.allNonTypedUniques = new HashSet();
        this.allUniqueParameters = new HashSet();
        UniqueType[] uniqueTypeArray = new UniqueType[]{UniqueType.ConditionalNeighborTiles, UniqueType.ConditionalAdjacentTo, UniqueType.ConditionalNotAdjacentTo};
        this.performanceHeavyConditionals = SetsKt.setOf(uniqueTypeArray);
        uniqueTypeArray = new UniqueType[]{UniqueType.ProvidesResources, UniqueType.ConsumesResources, UniqueType.DoubleResourceProduced, UniqueType.StrategicResourcesIncrease};
        this.resourceUniques = SetsKt.setOf(uniqueTypeArray);
        uniqueTypeArray = new UniqueType[]{UniqueType.ConditionalWithResource, UniqueType.ConditionalWithoutResource, UniqueType.ConditionalWhenBetweenStatResource, UniqueType.ConditionalWhenAboveAmountStatResource, UniqueType.ConditionalWhenBelowAmountStatResource};
        this.resourceConditionals = SetsKt.setOf(uniqueTypeArray);
        this.paramTypeErrorSeverityCache = new HashMap();
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    private final void addToHashsets(IHasUniques uniqueHolder) {
        for (Unique unique : uniqueHolder.getUniqueObjects()) {
            if (unique.getType() == null) {
                this.allNonTypedUniques.add(unique.getText());
                continue;
            }
            CollectionsKt.addAll((Collection)this.allUniqueParameters, SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)unique.getAllParams()), addToHashsets.1.INSTANCE));
        }
    }

    public final void populateFilteringUniqueHashsets() {
        Sequence<IRulesetObject> $this$forEach$iv = this.ruleset.allRulesetObjects();
        boolean $i$f$forEach = false;
        Iterator<IRulesetObject> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IRulesetObject element$iv;
            IRulesetObject it = element$iv = iterator2.next();
            boolean bl = false;
            this.addToHashsets(it);
        }
    }

    public final void checkUniques(@NotNull IHasUniques uniqueContainer, @NotNull RulesetErrorList lines2, boolean reportRulesetSpecificErrors, boolean tryFixUnknownUniques) {
        Intrinsics.checkNotNullParameter(uniqueContainer, "uniqueContainer");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        for (Unique unique : uniqueContainer.getUniqueObjects()) {
            RulesetErrorList errors = this.checkUnique(unique, tryFixUnknownUniques, uniqueContainer, reportRulesetSpecificErrors);
            lines2.addAll(errors);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RulesetErrorList checkUnique(@NotNull Unique unique, boolean tryFixUnknownUniques, @Nullable IHasUniques uniqueContainer, boolean reportRulesetSpecificErrors) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(unique, "unique");
        Lazy<String> prefix$delegate = LazyKt.lazy((Function0)new Function0<String>(uniqueContainer, unique){
            final /* synthetic */ IHasUniques $uniqueContainer;
            final /* synthetic */ Unique $unique;
            {
                this.$uniqueContainer = $uniqueContainer;
                this.$unique = $unique;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return UniqueValidator.Companion.getUniqueContainerPrefix$core(this.$uniqueContainer) + '\"' + this.$unique.getText() + '\"';
            }
        });
        if (unique.getType() == null) {
            return this.checkUntypedUnique(unique, tryFixUnknownUniques, uniqueContainer, UniqueValidator.checkUnique$lambda$1(prefix$delegate));
        }
        RulesetErrorList rulesetErrors = new RulesetErrorList(this.ruleset);
        if (!(uniqueContainer == null || unique.getType().canAcceptUniqueTarget(uniqueContainer.getUniqueTarget()) || unique.hasModifier(UniqueType.ConditionalTimedUnique) && uniqueContainer.getUniqueTarget().canAcceptUniqueTarget(UniqueTarget.Triggerable))) {
            rulesetErrors.add(UniqueValidator.checkUnique$lambda$1(prefix$delegate) + " is not allowed on its target type", RulesetErrorSeverity.Warning, uniqueContainer, unique);
        }
        List<UniqueComplianceError> typeComplianceErrors = this.getComplianceErrors(unique);
        for (UniqueComplianceError complianceError : typeComplianceErrors) {
            if (!reportRulesetSpecificErrors && complianceError.getErrorSeverity() == UniqueType.UniqueParameterErrorSeverity.RulesetSpecific) continue;
            rulesetErrors.add(UniqueValidator.checkUnique$lambda$1(prefix$delegate) + " contains parameter \"" + complianceError.getParameterName() + "\", which does not fit parameter type " + CollectionsKt.joinToString$default(complianceError.getAcceptableParameterTypes(), " or ", null, null, 0, null, checkUnique.1.INSTANCE, 30, null) + " !", complianceError.getErrorSeverity().getRulesetErrorSeverity(), uniqueContainer, unique);
            this.addExpressionParseErrors(complianceError, rulesetErrors, uniqueContainer, unique);
        }
        for (Unique conditional : unique.getModifiers()) {
            this.addConditionalErrors(conditional, rulesetErrors, UniqueValidator.checkUnique$lambda$1(prefix$delegate), unique, uniqueContainer, reportRulesetSpecificErrors);
        }
        Iterable $this$filter$iv = unique.getModifiers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Unique it = (Unique)element$iv$iv;
            boolean bl = false;
            UniqueType uniqueType = it.getType();
            boolean bl2 = uniqueType != null ? uniqueType.canAcceptUniqueTarget(UniqueTarget.Conditional) : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List conditionals = (List)destination$iv$iv;
        if (conditionals.size() > 1) {
            Object v3;
            Unique lastCheapConditional;
            block16: {
                Object v2;
                block15: {
                    List $this$lastOrNull$iv = conditionals;
                    boolean $i$f$lastOrNull = false;
                    ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        Object element$iv = iterator$iv.previous();
                        Unique it = (Unique)element$iv;
                        boolean bl = false;
                        if (!(!CollectionsKt.contains((Iterable)this.performanceHeavyConditionals, it.getType()))) continue;
                        v2 = element$iv;
                        break block15;
                    }
                    v2 = null;
                }
                lastCheapConditional = v2;
                Iterable $this$firstOrNull$iv = conditionals;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Unique it = (Unique)element$iv;
                    boolean bl = false;
                    if (!CollectionsKt.contains((Iterable)this.performanceHeavyConditionals, it.getType())) continue;
                    v3 = element$iv;
                    break block16;
                }
                v3 = null;
            }
            Unique firstExpensiveConditional = v3;
            if (lastCheapConditional != null && firstExpensiveConditional != null && conditionals.indexOf(lastCheapConditional) > conditionals.indexOf(firstExpensiveConditional)) {
                rulesetErrors.add(UniqueValidator.checkUnique$lambda$1(prefix$delegate) + " contains multiple conditionals, of which \"" + firstExpensiveConditional.getText() + "\" is more expensive to calculate than \"" + lastCheapConditional.getText() + "\". For performance, consider switching their locations.", RulesetErrorSeverity.WarningOptionsOnly, uniqueContainer, unique);
            }
        }
        if (MapUnitCache.Companion.getUnitMovementUniques().contains((Object)unique.getType())) {
            boolean bl;
            block17: {
                Iterable $this$any$iv = unique.getModifiers();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Unique it = (Unique)element$iv;
                        boolean bl3 = false;
                        if (!(it.getType() != UniqueType.ConditionalOurUnit || !Constants.INSTANCE.getAll().contains(it.getParams().get(0)))) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                rulesetErrors.add(UniqueValidator.checkUnique$lambda$1(prefix$delegate) + " contains a conditional on a unit movement unique. Due to performance considerations, this unique is cached on the unit, and the conditional may not always limit the unique correctly.", RulesetErrorSeverity.OK, uniqueContainer, unique);
            }
        }
        if (reportRulesetSpecificErrors) {
            this.addDeprecationAnnotationErrors(unique, UniqueValidator.checkUnique$lambda$1(prefix$delegate), rulesetErrors, uniqueContainer);
        }
        return rulesetErrors;
    }

    private final void addExpressionParseErrors(UniqueComplianceError complianceError, RulesetErrorList rulesetErrors, IHasUniques uniqueContainer, Unique unique) {
        if (!complianceError.getAcceptableParameterTypes().contains((Object)UniqueParameterType.Countable)) {
            return;
        }
        Parser.ParsingError parseError = Expressions.Companion.getParsingError(complianceError.getParameterName());
        if (parseError != null) {
            String marker = "HERE\u27a1";
            int errorLocation = parseError.getPosition();
            StringBuilder stringBuilder = new StringBuilder();
            String string = complianceError.getParameterName().substring(0, errorLocation);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string).append(marker);
            String string2 = complianceError.getParameterName().substring(errorLocation);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            String parameterWithErrorLocationMarked = stringBuilder2.append(string2).toString();
            String text2 = '\"' + complianceError.getParameterName() + "\" could not be parsed as an expression due to: " + parseError.getMessage() + ". \n" + parameterWithErrorLocationMarked;
            rulesetErrors.add(text2, RulesetErrorSeverity.WarningOptionsOnly, uniqueContainer, unique);
            return;
        }
        List<String> countableErrors = Expressions.Companion.getCountableErrors(complianceError.getParameterName(), this.ruleset);
        if (!((Collection)countableErrors).isEmpty()) {
            String text3 = '\"' + complianceError.getParameterName() + "\" was parsed as an expression, but has the following errors with this ruleset: " + CollectionsKt.joinToString$default(countableErrors, ", ", null, null, 0, null, null, 62, null);
            rulesetErrors.add(text3, RulesetErrorSeverity.WarningOptionsOnly, uniqueContainer, unique);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addConditionalErrors(Unique conditional, RulesetErrorList rulesetErrors, String prefix2, Unique unique, IHasUniques uniqueContainer, boolean reportRulesetSpecificErrors) {
        UniqueTarget it;
        Object element$iv;
        Iterator $this$filter$iv2;
        boolean bl;
        boolean $i$f$none;
        Object $this$none$iv;
        block18: {
            if (unique.hasFlag(UniqueFlag.NoConditionals)) {
                rulesetErrors.add(prefix2 + " contains the conditional \"" + conditional.getText() + "\", but the unique does not accept conditionals!", RulesetErrorSeverity.Error, uniqueContainer, unique);
                return;
            }
            if (conditional.getType() == null) {
                void $this$filterTo$iv$iv;
                String text2 = prefix2 + " contains the conditional \"" + conditional.getText() + "\", which is of an unknown type!";
                Iterable $this$filter$iv2 = UniqueType.getEntries();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    UniqueType it2 = (UniqueType)((Object)element$iv$iv);
                    boolean bl2 = false;
                    boolean bl3 = TextSimilarityKt.getRelativeTextDistance(it2.getPlaceholderText(), conditional.getPlaceholderText()) <= RulesetCache.INSTANCE.getUniqueMisspellingThreshold();
                    if (!bl3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List similarConditionals = (List)destination$iv$iv;
                if (!((Collection)similarConditionals).isEmpty()) {
                    text2 = text2 + " May be a misspelling of \"" + CollectionsKt.joinToString$default(similarConditionals, "\", or \"", null, null, 0, null, addConditionalErrors.1.INSTANCE, 30, null) + '\"';
                }
                rulesetErrors.add(text2, RulesetErrorSeverity.Warning, uniqueContainer, unique);
                return;
            }
            $this$none$iv = conditional.getType().getTargetTypes();
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                $this$filter$iv2 = $this$none$iv.iterator();
                while ($this$filter$iv2.hasNext()) {
                    element$iv = $this$filter$iv2.next();
                    it = (UniqueTarget)((Object)element$iv);
                    boolean bl4 = false;
                    if (!(it.getModifierType() != UniqueTarget.ModifierType.None)) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        if (bl) {
            rulesetErrors.add(prefix2 + " contains the conditional \"" + conditional.getText() + "\", which is a Unique type not allowed as conditional or trigger.", RulesetErrorSeverity.Warning, uniqueContainer, unique);
        }
        if (conditional.getType().getTargetTypes().contains((Object)UniqueTarget.UnitActionModifier)) {
            boolean bl5;
            block19: {
                UniqueType uniqueType = unique.getType();
                Intrinsics.checkNotNull((Object)uniqueType);
                $this$none$iv = uniqueType.getTargetTypes();
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl5 = true;
                } else {
                    $this$filter$iv2 = $this$none$iv.iterator();
                    while ($this$filter$iv2.hasNext()) {
                        element$iv = $this$filter$iv2.next();
                        it = (UniqueTarget)((Object)element$iv);
                        boolean bl6 = false;
                        if (!UniqueTarget.UnitAction.canAcceptUniqueTarget(it)) continue;
                        bl5 = false;
                        break block19;
                    }
                    bl5 = true;
                }
            }
            if (bl5) {
                rulesetErrors.add(prefix2 + " contains the conditional \"" + conditional.getText() + "\", which as a UnitActionModifier is only allowed on UnitAction uniques.", RulesetErrorSeverity.Warning, uniqueContainer, unique);
            }
        }
        if (CollectionsKt.contains((Iterable)this.resourceUniques, unique.getType()) && this.resourceConditionals.contains((Object)conditional.getType())) {
            TileResource tileResource = this.ruleset.getTileResources().get(CollectionsKt.last(conditional.getParams()));
            boolean bl7 = tileResource != null ? tileResource.isCityWide() : false;
            if (bl7) {
                rulesetErrors.add(prefix2 + " contains the conditional \"" + conditional.getText() + "\", which references a citywide resource. This is not a valid conditional for a resource uniques, as it causes a recursive evaluation loop.", RulesetErrorSeverity.Error, uniqueContainer, unique);
            }
        }
        if (CollectionsKt.contains((Iterable)this.resourceUniques, unique.getType())) {
            $this$none$iv = conditional.getParams().iterator();
            int n = 0;
            while ($this$none$iv.hasNext()) {
                int index = n++;
                String param = (String)$this$none$iv.next();
                TileResource tileResource = this.ruleset.getTileResources().get(param);
                boolean bl8 = tileResource != null ? tileResource.isCityWide() : false;
                if (!bl8) continue;
                UniqueType uniqueType = unique.getType();
                Intrinsics.checkNotNull((Object)uniqueType);
                List list2 = (List)CollectionsKt.getOrNull((List)uniqueType.getParameterTypeMap(), index);
                boolean bl9 = list2 != null ? list2.contains((Object)UniqueParameterType.Countable) : false;
                if (!bl9) continue;
                rulesetErrors.add(prefix2 + " contains the modifier \"" + conditional.getText() + "\", which references a citywide resource as a countable. This is not a valid conditional for a resource uniques, as it causes a recursive evaluation loop.", RulesetErrorSeverity.Error, uniqueContainer, unique);
            }
        }
        List<UniqueComplianceError> conditionalComplianceErrors = this.getComplianceErrors(conditional);
        for (UniqueComplianceError complianceError : conditionalComplianceErrors) {
            if (!reportRulesetSpecificErrors && complianceError.getErrorSeverity() == UniqueType.UniqueParameterErrorSeverity.RulesetSpecific) continue;
            rulesetErrors.add(prefix2 + " contains modifier \"" + conditional.getText() + "\". This contains the parameter \"" + complianceError.getParameterName() + "\" which does not fit parameter type " + CollectionsKt.joinToString$default(complianceError.getAcceptableParameterTypes(), " or ", null, null, 0, null, addConditionalErrors.4.INSTANCE, 30, null) + " !", complianceError.getErrorSeverity().getRulesetErrorSeverity(), uniqueContainer, unique);
            this.addExpressionParseErrors(complianceError, rulesetErrors, uniqueContainer, unique);
        }
        this.addDeprecationAnnotationErrors(conditional, prefix2 + " contains modifier \"" + conditional.getText() + "\" which", rulesetErrors, uniqueContainer);
    }

    /*
     * WARNING - void declaration
     */
    private final void addDeprecationAnnotationErrors(Unique unique, String prefix2, RulesetErrorList rulesetErrors, IHasUniques uniqueContainer) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        IndexedValue it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object deprecationText;
        Deprecated deprecationAnnotation = unique.getDeprecationAnnotation();
        if (deprecationAnnotation != null) {
            String replacementUniqueText = unique.getReplacementText(this.ruleset);
            deprecationText = prefix2 + " is deprecated " + deprecationAnnotation.message() + (!Intrinsics.areEqual(deprecationAnnotation.replaceWith().expression(), "") ? ", replace with \"" + replacementUniqueText + '\"' : "");
            RulesetErrorSeverity severity = deprecationAnnotation.level() == DeprecationLevel.WARNING ? RulesetErrorSeverity.WarningOptionsOnly : RulesetErrorSeverity.ErrorOptionsOnly;
            rulesetErrors.add((String)deprecationText, severity, uniqueContainer, unique);
        }
        if (unique.getType() == null) {
            return;
        }
        deprecationText = CollectionsKt.withIndex((Iterable)unique.getType().getParameterTypeMap());
        boolean $i$f$filter = false;
        void var9_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            if (!((List)it.getValue()).contains((Object)UniqueParameterType.Countable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IndexedValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(unique.getParams().get(it.getIndex()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Countables it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            if (Countables.Companion.getMatching(it2, this.ruleset) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List countables = (List)destination$iv$iv;
        for (Countables countable : countables) {
            Deprecated deprecation;
            if (countable.getDeprecationAnnotation() == null) continue;
            String replaceExpression = deprecation.replaceWith().expression();
            String text2 = "Countable `" + countable.name() + "` is deprecated " + deprecation.message() + (((CharSequence)replaceExpression).length() == 0 ? "" : ", replace with \"" + replaceExpression + '\"');
            RulesetErrorSeverity severity = deprecation.level() == DeprecationLevel.WARNING ? RulesetErrorSeverity.WarningOptionsOnly : RulesetErrorSeverity.ErrorOptionsOnly;
            rulesetErrors.add(text2, severity, uniqueContainer, unique);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<UniqueComplianceError> getComplianceErrors(Unique unique) {
        if (unique.getType() == null) {
            return CollectionsKt.emptyList();
        }
        ArrayList errorList = new ArrayList();
        Iterator<String> iterator2 = unique.getParams().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            Object v1;
            boolean bl;
            List errorTypesForAcceptableParameters;
            List<UniqueParameterType> acceptableParamTypes;
            String param;
            block12: {
                Iterator $this$mapTo$iv$iv;
                int index = n++;
                param = iterator2.next();
                if (unique.getType().getParameterTypeMap().size() != unique.getParams().size()) {
                    throw new Exception("Unique " + unique.getText() + " has " + unique.getParams().size() + " parameters, but its type " + (Object)((Object)unique.getType()) + " only " + unique.getType().getParameterTypeMap().size() + " parameters?!");
                }
                Intrinsics.checkNotNullExpressionValue(unique.getType().getParameterTypeMap().get(index), "get(...)");
                Iterable $this$map$iv = acceptableParamTypes;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator3 = $this$mapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    void it;
                    Object item$iv$iv = iterator3.next();
                    UniqueParameterType uniqueParameterType = (UniqueParameterType)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(this.getParamTypeErrorSeverityCached((UniqueParameterType)it, param));
                }
                errorTypesForAcceptableParameters = (List)destination$iv$iv;
                Iterable $this$any$iv = errorTypesForAcceptableParameters;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    $this$mapTo$iv$iv = $this$any$iv.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        Object element$iv = $this$mapTo$iv$iv.next();
                        UniqueType.UniqueParameterErrorSeverity it = (UniqueType.UniqueParameterErrorSeverity)((Object)element$iv);
                        boolean bl3 = false;
                        if (!(it == null)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl || errorTypesForAcceptableParameters.contains((Object)UniqueType.UniqueParameterErrorSeverity.PossibleFilteringUnique) && this.allNonTypedUniques.contains(param)) continue;
            Iterable $this$minByOrNull$iv = errorTypesForAcceptableParameters;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = minElem$iv;
                } else {
                    UniqueType.UniqueParameterErrorSeverity it = (UniqueType.UniqueParameterErrorSeverity)((Object)minElem$iv);
                    boolean bl4 = false;
                    UniqueType.UniqueParameterErrorSeverity uniqueParameterErrorSeverity = it;
                    Intrinsics.checkNotNull((Object)uniqueParameterErrorSeverity);
                    int minValue$iv = uniqueParameterErrorSeverity.ordinal();
                    do {
                        Object e$iv = iterator$iv.next();
                        UniqueType.UniqueParameterErrorSeverity it2 = (UniqueType.UniqueParameterErrorSeverity)((Object)e$iv);
                        $i$a$-minByOrNull-UniqueValidator$getComplianceErrors$leastSevereWarning$1 = false;
                        UniqueType.UniqueParameterErrorSeverity uniqueParameterErrorSeverity2 = it2;
                        Intrinsics.checkNotNull((Object)uniqueParameterErrorSeverity2);
                        int v$iv = uniqueParameterErrorSeverity2.ordinal();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = minElem$iv;
                }
            }
            Intrinsics.checkNotNull(v1);
            UniqueType.UniqueParameterErrorSeverity leastSevereWarning = v1;
            ((Collection)errorList).add(new UniqueComplianceError(param, acceptableParamTypes, leastSevereWarning));
        }
        return errorList;
    }

    private final UniqueType.UniqueParameterErrorSeverity getParamTypeErrorSeverityCached(UniqueParameterType uniqueParameterType, String param) {
        if (!this.paramTypeErrorSeverityCache.containsKey((Object)uniqueParameterType)) {
            ((Map)this.paramTypeErrorSeverityCache).put(uniqueParameterType, new HashMap());
        }
        HashMap<String, UniqueType.UniqueParameterErrorSeverity> hashMap = this.paramTypeErrorSeverityCache.get((Object)uniqueParameterType);
        Intrinsics.checkNotNull(hashMap);
        HashMap<String, UniqueType.UniqueParameterErrorSeverity> uniqueParamCache = hashMap;
        if (uniqueParamCache.containsKey(param)) {
            return uniqueParamCache.get(param);
        }
        UniqueType.UniqueParameterErrorSeverity severity = uniqueParameterType.getErrorSeverity(param, this.ruleset);
        ((Map)uniqueParamCache).put(param, severity);
        return severity;
    }

    private final RulesetErrorList checkUntypedUnique(Unique unique, boolean tryFixUnknownUniques, IHasUniques uniqueContainer, String prefix2) {
        RulesetErrorList fixes;
        char it;
        char element$iv;
        int n;
        CharSequence $this$count$iv = unique.getText();
        boolean $i$f$count = false;
        int count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!(it == '<')) continue;
            ++count$iv;
        }
        $this$count$iv = unique.getText();
        int n2 = count$iv;
        $i$f$count = false;
        count$iv = 0;
        for (n = 0; n < $this$count$iv.length(); ++n) {
            it = element$iv = $this$count$iv.charAt(n);
            boolean bl = false;
            if (!(it == '>')) continue;
            ++count$iv;
        }
        int n3 = count$iv;
        if (n2 != n3) {
            return RulesetErrorList.Companion.of(prefix2 + " contains mismatched conditional braces!", RulesetErrorSeverity.Warning, this.ruleset, uniqueContainer, unique);
        }
        if (this.isFilteringUniqueAllowed(unique)) {
            return new RulesetErrorList(null, 1, null);
        }
        if (tryFixUnknownUniques && !((Collection)(fixes = this.tryFixUnknownUnique(unique, uniqueContainer, prefix2))).isEmpty()) {
            return fixes;
        }
        return RulesetErrorList.Companion.of(prefix2 + " not found in Unciv's unique types, and is not used as a filtering unique.", unique.getParams().isEmpty() ? RulesetErrorSeverity.OK : RulesetErrorSeverity.Warning, this.ruleset, uniqueContainer, unique);
    }

    private final boolean isFilteringUniqueAllowed(Unique unique) {
        if (!((Collection)unique.getModifiers()).isEmpty() || !((Collection)unique.getParams()).isEmpty()) {
            return false;
        }
        return this.allUniqueParameters.contains(unique.getText());
    }

    /*
     * WARNING - void declaration
     */
    private final RulesetErrorList tryFixUnknownUnique(Unique unique, IHasUniques uniqueContainer, String prefix2) {
        RulesetErrorList rulesetErrorList;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = UniqueType.getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            UniqueType it = (UniqueType)((Object)element$iv$iv);
            boolean bl = false;
            boolean bl2 = TextSimilarityKt.getRelativeTextDistance(it.getPlaceholderText(), unique.getPlaceholderText()) <= RulesetCache.INSTANCE.getUniqueMisspellingThreshold();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List similarUniques = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = similarUniques;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UniqueType it = (UniqueType)((Object)element$iv$iv);
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getPlaceholderText(), unique.getPlaceholderText())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List equalUniques = (List)destination$iv$iv2;
        if (!((Collection)equalUniques).isEmpty()) {
            rulesetErrorList = RulesetErrorList.Companion.of(prefix2 + " looks like it should be fine, but for some reason isn't recognized.", RulesetErrorSeverity.OK, this.ruleset, uniqueContainer, unique);
        } else if (!((Collection)similarUniques).isEmpty()) {
            String text2 = prefix2 + " looks like it may be a misspelling of:\n" + StringsKt.prependIndent(CollectionsKt.joinToString$default(similarUniques, "\n", null, null, 0, null, new Function1<UniqueType, CharSequence>(unique){
                final /* synthetic */ Unique $unique;
                {
                    this.$unique = $unique;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull UniqueType uniqueType) {
                    Intrinsics.checkNotNullParameter((Object)((Object)uniqueType), "uniqueType");
                    String text2 = '\"' + uniqueType.getText();
                    if (!((Collection)this.$unique.getModifiers()).isEmpty()) {
                        text2 = text2 + ' ' + CollectionsKt.joinToString$default(this.$unique.getModifiers(), " ", null, null, 0, null, tryFixUnknownUnique.text.1.INSTANCE, 30, null);
                    }
                    text2 = text2 + '\"';
                    if (uniqueType.getDeprecationAnnotation() != null) {
                        text2 = text2 + " (Deprecated)";
                    }
                    return text2;
                }
            }, 30, null), "\t");
            rulesetErrorList = RulesetErrorList.Companion.of(text2, RulesetErrorSeverity.OK, this.ruleset, uniqueContainer, unique);
        } else {
            rulesetErrorList = new RulesetErrorList(null, 1, null);
        }
        return rulesetErrorList;
    }

    private static final String checkUnique$lambda$1(Lazy<String> $prefix$delegate) {
        Lazy<String> lazy = $prefix$delegate;
        return lazy.getValue();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/unciv/models/ruleset/validation/UniqueValidator$Companion;", "", "()V", "whichDoesNotFitParameterType", "", "getUniqueContainerPrefix", "uniqueContainer", "Lcom/unciv/models/ruleset/unique/IHasUniques;", "getUniqueContainerPrefix$core", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getUniqueContainerPrefix$core(@Nullable IHasUniques uniqueContainer) {
            return (uniqueContainer instanceof IRulesetObject ? ((IRulesetObject)uniqueContainer).getOriginRuleset() + ": " : "") + (uniqueContainer == null ? "The" : '(' + uniqueContainer.getUniqueTarget().name() + ") " + uniqueContainer.getName() + "'s") + " unique ";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

