/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.skins;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.unciv.UncivGame;
import com.unciv.models.skins.SkinCache;
import com.unciv.models.skins.SkinConfig;
import com.unciv.ui.images.ImageGetter;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00032\n\b\u0002\u0010&\u001a\u0004\u0018\u00010$J\u0010\u0010'\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0003J\u0010\u0010(\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0003J&\u0010)\u001a\u00020*2\u0006\u0010%\u001a\u00020\u00032\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010+\u001a\u0004\u0018\u00010$R\u0014\u0010\u0005\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007R\u0014\u0010\u0011\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u0014\u0010\u0013\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007R\u0014\u0010\u0015\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0007R\u0014\u0010\u0017\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007R\u0014\u0010\u0019\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0007R\u0014\u0010\u001b\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0007R\u0014\u0010\u001d\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0007R\u0011\u0010\u001f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/unciv/models/skins/SkinStrings;", "", "skin", "", "(Ljava/lang/String;)V", "checkboxPressedShape", "getCheckboxPressedShape", "()Ljava/lang/String;", "checkboxShape", "getCheckboxShape", "fallbackSkinConfig", "Lcom/unciv/models/skins/SkinConfig;", "fallbackSkinLocation", "rectangleWithOutlineShape", "getRectangleWithOutlineShape", "roundedEdgeRectangleMidBorderShape", "getRoundedEdgeRectangleMidBorderShape", "roundedEdgeRectangleMidShape", "getRoundedEdgeRectangleMidShape", "roundedEdgeRectangleShape", "getRoundedEdgeRectangleShape", "roundedEdgeRectangleSmallShape", "getRoundedEdgeRectangleSmallShape", "roundedTopEdgeRectangleSmallBorderShape", "getRoundedTopEdgeRectangleSmallBorderShape", "roundedTopEdgeRectangleSmallShape", "getRoundedTopEdgeRectangleSmallShape", "selectBoxPressedShape", "getSelectBoxPressedShape", "selectBoxShape", "getSelectBoxShape", "skinConfig", "getSkinConfig", "()Lcom/unciv/models/skins/SkinConfig;", "skinLocation", "getUIColor", "Lcom/badlogic/gdx/graphics/Color;", "path", "default", "getUIFontColor", "getUIIconColor", "getUiBackground", "Lcom/badlogic/gdx/scenes/scene2d/utils/NinePatchDrawable;", "tintColor", "core"})
@SourceDebugExtension(value={"SMAP\nSkinStrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinStrings.kt\ncom/unciv/models/skins/SkinStrings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class SkinStrings {
    @NotNull
    private final String skinLocation;
    @NotNull
    private final SkinConfig skinConfig;
    @Nullable
    private final String fallbackSkinLocation;
    @Nullable
    private final SkinConfig fallbackSkinConfig;
    @NotNull
    private final String roundedEdgeRectangleSmallShape;
    @NotNull
    private final String roundedTopEdgeRectangleSmallShape;
    @NotNull
    private final String roundedTopEdgeRectangleSmallBorderShape;
    @NotNull
    private final String roundedEdgeRectangleMidShape;
    @NotNull
    private final String roundedEdgeRectangleMidBorderShape;
    @NotNull
    private final String roundedEdgeRectangleShape;
    @NotNull
    private final String rectangleWithOutlineShape;
    @NotNull
    private final String selectBoxShape;
    @NotNull
    private final String selectBoxPressedShape;
    @NotNull
    private final String checkboxShape;
    @NotNull
    private final String checkboxPressedShape;

    public SkinStrings(@NotNull String skin) {
        Intrinsics.checkNotNullParameter(skin, "skin");
        this.skinLocation = "Skins/" + skin + '/';
        SkinConfig skinConfig = (SkinConfig)SkinCache.INSTANCE.get((Object)skin);
        if (skinConfig == null) {
            skinConfig = new SkinConfig();
        }
        this.skinConfig = skinConfig;
        this.fallbackSkinLocation = this.skinConfig.getFallbackSkin() != null ? "Skins/" + this.skinConfig.getFallbackSkin() + '/' : null;
        this.fallbackSkinConfig = (SkinConfig)((Map)SkinCache.INSTANCE).get(this.skinConfig.getFallbackSkin());
        this.roundedEdgeRectangleSmallShape = "roundedEdgeRectangle-small";
        this.roundedTopEdgeRectangleSmallShape = "roundedTopEdgeRectangle-small";
        this.roundedTopEdgeRectangleSmallBorderShape = "roundedTopEdgeRectangle-small-border";
        this.roundedEdgeRectangleMidShape = "roundedEdgeRectangle-mid";
        this.roundedEdgeRectangleMidBorderShape = "roundedEdgeRectangle-mid-border";
        this.roundedEdgeRectangleShape = "roundedEdgeRectangle";
        this.rectangleWithOutlineShape = "rectangleWithOutline";
        this.selectBoxShape = "select-box";
        this.selectBoxPressedShape = "select-box-pressed";
        this.checkboxShape = "checkbox";
        this.checkboxPressedShape = "checkbox-pressed";
    }

    public /* synthetic */ SkinStrings(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = UncivGame.Companion.getCurrent().getSettings().getSkin();
        }
        this(string);
    }

    @NotNull
    public final SkinConfig getSkinConfig() {
        return this.skinConfig;
    }

    @NotNull
    public final String getRoundedEdgeRectangleSmallShape() {
        return this.roundedEdgeRectangleSmallShape;
    }

    @NotNull
    public final String getRoundedTopEdgeRectangleSmallShape() {
        return this.roundedTopEdgeRectangleSmallShape;
    }

    @NotNull
    public final String getRoundedTopEdgeRectangleSmallBorderShape() {
        return this.roundedTopEdgeRectangleSmallBorderShape;
    }

    @NotNull
    public final String getRoundedEdgeRectangleMidShape() {
        return this.roundedEdgeRectangleMidShape;
    }

    @NotNull
    public final String getRoundedEdgeRectangleMidBorderShape() {
        return this.roundedEdgeRectangleMidBorderShape;
    }

    @NotNull
    public final String getRoundedEdgeRectangleShape() {
        return this.roundedEdgeRectangleShape;
    }

    @NotNull
    public final String getRectangleWithOutlineShape() {
        return this.rectangleWithOutlineShape;
    }

    @NotNull
    public final String getSelectBoxShape() {
        return this.selectBoxShape;
    }

    @NotNull
    public final String getSelectBoxPressedShape() {
        return this.selectBoxPressedShape;
    }

    @NotNull
    public final String getCheckboxShape() {
        return this.checkboxShape;
    }

    @NotNull
    public final String getCheckboxPressedShape() {
        return this.checkboxPressedShape;
    }

    @NotNull
    public final NinePatchDrawable getUiBackground(@NotNull String path, @Nullable String string, @Nullable Color tintColor) {
        Object object;
        SkinConfig.SkinElement fallbackSkinVariant;
        String location;
        Object object2;
        SkinConfig.SkinElement skinVariant;
        Intrinsics.checkNotNullParameter(path, "path");
        String locationForDefault = this.skinLocation + string;
        String locationByName = this.skinLocation + path;
        SkinConfig.SkinElement skinElement = skinVariant = this.skinConfig.getSkinVariants().get(path);
        String locationByConfigVariant = (skinElement != null ? skinElement.getImage() : null) != null ? this.skinLocation + skinVariant.getImage() : null;
        Object object3 = skinVariant;
        if ((object3 == null || (object3 = ((SkinConfig.SkinElement)object3).getTint()) == null) && (object3 = this.skinConfig.getDefaultVariantTint()) == null) {
            object3 = tintColor;
        }
        if (object3 != null) {
            Object $this$getUiBackground_u24lambda_u241 = object3;
            boolean bl = false;
            SkinConfig.SkinElement skinElement2 = skinVariant;
            if ((skinElement2 != null ? skinElement2.getAlpha() : null) == null) {
                object2 = $this$getUiBackground_u24lambda_u241;
            } else {
                Color color;
                Color $this$getUiBackground_u24lambda_u241_u24lambda_u240 = color = ((Color)$this$getUiBackground_u24lambda_u241).cpy();
                boolean bl2 = false;
                $this$getUiBackground_u24lambda_u241_u24lambda_u240.a = skinVariant.getAlpha().floatValue();
                object2 = color;
            }
        } else {
            object2 = null;
        }
        Object tint = object2;
        String string2 = locationByConfigVariant != null && ImageGetter.INSTANCE.ninePatchImageExists(locationByConfigVariant) ? locationByConfigVariant : (ImageGetter.INSTANCE.ninePatchImageExists(locationByName) ? locationByName : (location = string != null && ImageGetter.INSTANCE.ninePatchImageExists(locationForDefault) ? locationForDefault : null));
        if (location != null) {
            return ImageGetter.INSTANCE.getNinePatch(location, (Color)tint);
        }
        String fallbackLocationForDefault = this.fallbackSkinLocation + string;
        String fallbackLocationByName = this.fallbackSkinLocation + path;
        Object object4 = this.fallbackSkinConfig;
        SkinConfig.SkinElement skinElement3 = fallbackSkinVariant = object4 != null && (object4 = ((SkinConfig)object4).getSkinVariants()) != null ? (SkinConfig.SkinElement)((HashMap)object4).get(path) : null;
        String fallbackLocationByConfigVariant = (skinElement3 != null ? skinElement3.getImage() : null) != null ? this.fallbackSkinLocation + fallbackSkinVariant.getImage() : null;
        Object object5 = fallbackSkinVariant;
        if (object5 == null || (object5 = ((SkinConfig.SkinElement)object5).getTint()) == null) {
            object5 = tintColor;
        }
        if (object5 != null) {
            Object $this$getUiBackground_u24lambda_u243 = object5;
            boolean bl = false;
            SkinConfig.SkinElement skinElement4 = fallbackSkinVariant;
            if ((skinElement4 != null ? skinElement4.getAlpha() : null) == null) {
                object = $this$getUiBackground_u24lambda_u243;
            } else {
                Color color;
                Color $this$getUiBackground_u24lambda_u243_u24lambda_u242 = color = ((Color)$this$getUiBackground_u24lambda_u243).cpy();
                boolean bl3 = false;
                $this$getUiBackground_u24lambda_u243_u24lambda_u242.a = fallbackSkinVariant.getAlpha().floatValue();
                object = color;
            }
        } else {
            object = null;
        }
        Object fallbackTint = object;
        String fallbackLocation = fallbackLocationByConfigVariant != null && ImageGetter.INSTANCE.ninePatchImageExists(fallbackLocationByConfigVariant) ? fallbackLocationByConfigVariant : (ImageGetter.INSTANCE.ninePatchImageExists(fallbackLocationByName) ? fallbackLocationByName : (string != null && ImageGetter.INSTANCE.ninePatchImageExists(fallbackLocationForDefault) ? fallbackLocationForDefault : null));
        return ImageGetter.INSTANCE.getNinePatch(fallbackLocation, (Color)fallbackTint);
    }

    public static /* synthetic */ NinePatchDrawable getUiBackground$default(SkinStrings skinStrings, String string, String string2, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            color = null;
        }
        return skinStrings.getUiBackground(string, string2, color);
    }

    @NotNull
    public final Color getUIColor(@NotNull String path, @Nullable Color color) {
        Intrinsics.checkNotNullParameter(path, "path");
        Object object = this.skinConfig.getSkinVariants().get(path);
        if ((object == null || (object = ((SkinConfig.SkinElement)object).getTint()) == null) && (object = color) == null) {
            object = this.skinConfig.getClearColor();
        }
        return object;
    }

    public static /* synthetic */ Color getUIColor$default(SkinStrings skinStrings, String string, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            color = null;
        }
        return skinStrings.getUIColor(string, color);
    }

    @Nullable
    public final Color getUIFontColor(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        SkinConfig.SkinElement skinElement = this.skinConfig.getSkinVariants().get(path);
        return skinElement != null ? skinElement.getForegroundColor() : null;
    }

    @Nullable
    public final Color getUIIconColor(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Object object = this.skinConfig.getSkinVariants().get(path);
        if (object == null || (object = ((SkinConfig.SkinElement)object).getIconColor()) == null) {
            SkinConfig.SkinElement skinElement = this.skinConfig.getSkinVariants().get(path);
            object = skinElement != null ? skinElement.getForegroundColor() : null;
        }
        return object;
    }

    public SkinStrings() {
        this(null, 1, null);
    }
}

