/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.audio;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.models.UncivSound;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.utils.Concurrency;
import com.unciv.utils.LogKt;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004'()*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000e\u001a\u00020\rJ\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\rJ\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0002J\"\u0010#\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010$\u001a\u00020\u00042\b\b\u0002\u0010%\u001a\u00020&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/unciv/ui/audio/SoundPlayer;", "", "()V", "modListHash", "", "preloader", "Lcom/unciv/ui/audio/SoundPlayer$Preloader;", "separator", "", "kotlin.jvm.PlatformType", "soundMap", "Lcom/unciv/ui/audio/SoundPlayer$Cache;", "checkCache", "", "clearCache", "createAndCacheResult", "Lcom/unciv/ui/audio/SoundPlayer$GetSoundResult;", "sound", "Lcom/unciv/models/UncivSound;", "file", "Lcom/badlogic/gdx/files/FileHandle;", "get", "getFile", "getFolders", "Lkotlin/sequences/Sequence;", "initializeForMainMenu", "play", "playAndroid", "resource", "Lcom/badlogic/gdx/audio/Sound;", "isFresh", "", "volume", "", "playDesktop", "playRepeated", "count", "delay", "", "Cache", "GetSoundResult", "Preloader", "SupportedExtensions", "core"})
public final class SoundPlayer {
    @NotNull
    public static final SoundPlayer INSTANCE = new SoundPlayer();
    @NotNull
    private static final Cache soundMap = new Cache();
    private static final String separator = File.separator;
    private static int modListHash = Integer.MIN_VALUE;
    @Nullable
    private static Preloader preloader;

    private SoundPlayer() {
    }

    public final void initializeForMainMenu() {
        this.checkCache();
    }

    private final void checkCache() {
        GameInfo gameInfo;
        if (!UncivGame.Companion.isCurrentInitialized()) {
            return;
        }
        UncivGame game = UncivGame.Companion.getCurrent();
        GameInfo gameInfo2 = gameInfo = game.getGameInfo();
        int hash1 = gameInfo2 != null ? gameInfo2.getRuleset().getMods().hashCode() : 0;
        int newHash = hash1 ^ game.getSettings().getVisualMods().hashCode();
        if (modListHash != Integer.MIN_VALUE && modListHash == newHash) {
            return;
        }
        this.clearCache();
        modListHash = newHash;
        LogKt.debug("Sound cache cleared", new Object[0]);
        Preloader.Companion.restart();
    }

    public final void clearCache() {
        Preloader.Companion.abort();
        soundMap.clear();
        modListHash = Integer.MIN_VALUE;
    }

    private final Sequence<String> getFolders() {
        if (!UncivGame.Companion.isCurrentInitialized()) {
            String[] stringArray = new String[]{""};
            return SequencesKt.sequenceOf(stringArray);
        }
        UncivGame game = UncivGame.Companion.getCurrent();
        Set modList = new LinkedHashSet();
        GameInfo gameInfo = game.getGameInfo();
        if (gameInfo != null) {
            modList.addAll((Collection)gameInfo.getRuleset().getMods());
        }
        modList.addAll((Collection)game.getSettings().getVisualMods());
        String[] stringArray = new String[]{""};
        return SequencesKt.plus(SequencesKt.map(CollectionsKt.asSequence(modList), getFolders.1.INSTANCE), SequencesKt.sequenceOf(stringArray));
    }

    private final GetSoundResult get(UncivSound sound) {
        this.checkCache();
        if (soundMap.contains(sound)) {
            GetSoundResult getSoundResult;
            if (soundMap.get(sound) == null) {
                getSoundResult = null;
            } else {
                Sound sound2 = soundMap.get(sound);
                Intrinsics.checkNotNull(sound2);
                getSoundResult = new GetSoundResult(sound2, false);
            }
            return getSoundResult;
        }
        return this.createAndCacheResult(sound, this.getFile(sound));
    }

    private final FileHandle getFile(UncivSound sound) {
        String fileName = sound.getFileName();
        Iterator<String> iterator2 = this.getFolders().iterator();
        while (iterator2.hasNext()) {
            String modFolder = iterator2.next();
            for (SupportedExtensions extension : SupportedExtensions.getEntries()) {
                String path = modFolder + "sounds" + separator + fileName + '.' + extension.name();
                FileHandle localFile = UncivGame.Companion.getCurrent().getFiles().getLocalFile(path);
                if (localFile.exists()) {
                    return localFile;
                }
                FileHandle internalFile = Gdx.files.internal(path);
                if (!internalFile.exists()) continue;
                return internalFile;
            }
        }
        return null;
    }

    private final GetSoundResult createAndCacheResult(UncivSound sound, FileHandle file) {
        if (file == null || !file.exists()) {
            Object[] objectArray = new Object[]{sound.getFileName()};
            LogKt.debug("Sound %s not found!", objectArray);
            soundMap.set(sound, null);
            return null;
        }
        Object[] objectArray = new Object[]{sound.getFileName(), file.path()};
        LogKt.debug("Sound %s loaded from %s", objectArray);
        Sound newSound = Gdx.audio.newSound(file);
        soundMap.set(sound, newSound);
        Intrinsics.checkNotNull(newSound);
        return new GetSoundResult(newSound, true);
    }

    public final void play(@NotNull UncivSound sound) {
        Intrinsics.checkNotNullParameter(sound, "sound");
        float volume = UncivGame.Companion.getCurrent().getSettings().getSoundEffectsVolume();
        if (Intrinsics.areEqual(sound, UncivSound.Companion.getSilent()) || (double)volume < 0.01) {
            return;
        }
        GetSoundResult getSoundResult = this.get(sound);
        if (getSoundResult == null) {
            return;
        }
        GetSoundResult getSoundResult2 = getSoundResult;
        Sound resource2 = getSoundResult2.component1();
        boolean isFresh = getSoundResult2.component2();
        if (Gdx.app.getType() == Application.ApplicationType.Android) {
            this.playAndroid(resource2, isFresh, volume);
        } else {
            this.playDesktop(resource2, volume);
        }
    }

    private final void playAndroid(Sound resource2, boolean isFresh, float volume) {
        if (!isFresh && resource2.play(volume) != -1L) {
            return;
        }
        Concurrency.run$default(Concurrency.INSTANCE, "DelayedSound", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(resource2, volume, null){
            int I$0;
            int label;
            final /* synthetic */ Sound $resource;
            final /* synthetic */ float $volume;
            {
                this.$resource = $resource;
                this.$volume = $volume;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay(40L, this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        repeatCount = 0;
lbl14:
                        // 3 sources

                        while (this.$resource.play(this.$volume) == -1L && ++repeatCount < 12) {
                            this.I$0 = repeatCount;
                            this.label = 2;
                            v1 = DelayKt.delay(20L, this);
                            if (v1 != var3_2) continue;
                            return var3_2;
                        }
                        break;
                    }
                    case 2: {
                        repeatCount = this.I$0;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
                        ** GOTO lbl14
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void playDesktop(Sound resource2, float volume) {
        if (resource2.play(volume) != -1L) {
            return;
        }
        Concurrency.INSTANCE.runOnGLThread("SoundRetry", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(resource2, volume, null){
            int label;
            final /* synthetic */ Sound $resource;
            final /* synthetic */ float $volume;
            {
                this.$resource = $resource;
                this.$volume = $volume;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay(20L, this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.$resource.play(this.$volume);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public final void playRepeated(@NotNull UncivSound sound, int count2, long delay2) {
        Intrinsics.checkNotNullParameter(sound, "sound");
        Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sound, count2, delay2, null){
            int label;
            final /* synthetic */ UncivSound $sound;
            final /* synthetic */ int $count;
            final /* synthetic */ long $delay;
            {
                this.$sound = $sound;
                this.$count = $count;
                this.$delay = $delay;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        SoundPlayer.INSTANCE.play(this.$sound);
                        if (this.$count > 1) {
                            Concurrency.run$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$count, this.$delay, this.$sound, null){
                                int I$0;
                                int I$1;
                                long J$0;
                                Object L$0;
                                int label;
                                final /* synthetic */ int $count;
                                final /* synthetic */ long $delay;
                                final /* synthetic */ UncivSound $sound;
                                {
                                    this.$count = $count;
                                    this.$delay = $delay;
                                    this.$sound = $sound;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(var1_1);
                                            var2_3 = this.$count - 1;
                                            var3_4 = this.$delay;
                                            var5_5 = this.$sound;
                                            var6_6 = 0;
lbl9:
                                            // 2 sources

                                            while (var6_6 < var2_3) {
                                                $i$a$-repeat-SoundPlayer$playRepeated$1$1$1 = false;
                                                this.L$0 = var5_5;
                                                this.I$0 = var2_3;
                                                this.J$0 = var3_4;
                                                this.I$1 = var6_6;
                                                this.label = 1;
                                                v0 = DelayKt.delay(var3_4, this);
                                                if (v0 == var8_2) {
                                                    return var8_2;
                                                }
                                                ** GOTO lbl29
                                            }
                                            break;
                                        }
                                        case 1: {
                                            $i$a$-repeat-SoundPlayer$playRepeated$1$1$1 = false;
                                            var6_6 = this.I$1;
                                            var3_4 = this.J$0;
                                            var2_3 = this.I$0;
                                            var5_5 = (UncivSound)this.L$0;
                                            ResultKt.throwOnFailure($result);
                                            v0 = $result;
lbl29:
                                            // 2 sources

                                            Concurrency.runOnGLThread$default(Concurrency.INSTANCE, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(var5_5, null){
                                                int label;
                                                final /* synthetic */ UncivSound $sound;
                                                {
                                                    this.$sound = $sound;
                                                    super(2, $completion);
                                                }

                                                @Nullable
                                                public final Object invokeSuspend(@NotNull Object object) {
                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure(object);
                                                            SoundPlayer.INSTANCE.play(this.$sound);
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                @NotNull
                                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                                }

                                                @Nullable
                                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }, 1, null);
                                            ++var6_6;
                                            ** GOTO lbl9
                                        }
                                    }
                                    return Unit.INSTANCE;
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 3, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 1, null);
    }

    public static /* synthetic */ void playRepeated$default(SoundPlayer soundPlayer, UncivSound uncivSound, int n, long l, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            l = 200L;
        }
        soundPlayer.playRepeated(uncivSound, n, l);
    }

    public static final /* synthetic */ String access$getSeparator$p() {
        return separator;
    }

    public static final /* synthetic */ Cache access$getSoundMap$p() {
        return soundMap;
    }

    public static final /* synthetic */ GetSoundResult access$createAndCacheResult(SoundPlayer $this, UncivSound sound, FileHandle file) {
        return $this.createAndCacheResult(sound, file);
    }

    public static final /* synthetic */ FileHandle access$getFile(SoundPlayer $this, UncivSound sound) {
        return $this.getFile(sound);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0086\u0002J\u0013\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u0005H\u0086\u0002J\u001b\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0086\u0002R.\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004j\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/audio/SoundPlayer$Cache;", "", "()V", "cache", "Ljava/util/HashMap;", "Lcom/unciv/models/UncivSound;", "Lcom/badlogic/gdx/audio/Sound;", "Lkotlin/collections/HashMap;", "clear", "", "contains", "", "key", "get", "set", "value", "core"})
    private static final class Cache {
        @NotNull
        private final HashMap<UncivSound, Sound> cache = new HashMap(20);

        public final boolean contains(@NotNull UncivSound key) {
            Intrinsics.checkNotNullParameter(key, "key");
            return this.cache.containsKey(key);
        }

        @Nullable
        public final Sound get(@NotNull UncivSound key) {
            Intrinsics.checkNotNullParameter(key, "key");
            return this.cache.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void set(@NotNull UncivSound key, @Nullable Sound value) {
            Intrinsics.checkNotNullParameter(key, "key");
            HashMap<UncivSound, Sound> hashMap = this.cache;
            synchronized (hashMap) {
                boolean bl = false;
                ((Map)this.cache).put(key, value);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clear() {
            List oldSounds = null;
            HashMap<UncivSound, Sound> hashMap = this.cache;
            synchronized (hashMap) {
                boolean bl = false;
                Collection<Sound> collection = this.cache.values();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                oldSounds = CollectionsKt.toList((Iterable)collection);
                this.cache.clear();
                Unit unit = Unit.INSTANCE;
            }
            Iterator iterator2 = oldSounds.iterator();
            while (iterator2.hasNext()) {
                Sound sound;
                Sound sound2 = sound = (Sound)iterator2.next();
                if (sound2 == null) continue;
                sound2.dispose();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/unciv/ui/audio/SoundPlayer$GetSoundResult;", "", "resource", "Lcom/badlogic/gdx/audio/Sound;", "isFresh", "", "(Lcom/badlogic/gdx/audio/Sound;Z)V", "()Z", "getResource", "()Lcom/badlogic/gdx/audio/Sound;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "core"})
    private static final class GetSoundResult {
        @NotNull
        private final Sound resource;
        private final boolean isFresh;

        public GetSoundResult(@NotNull Sound resource2, boolean isFresh) {
            Intrinsics.checkNotNullParameter(resource2, "resource");
            this.resource = resource2;
            this.isFresh = isFresh;
        }

        @NotNull
        public final Sound getResource() {
            return this.resource;
        }

        public final boolean isFresh() {
            return this.isFresh;
        }

        @NotNull
        public final Sound component1() {
            return this.resource;
        }

        public final boolean component2() {
            return this.isFresh;
        }

        @NotNull
        public final GetSoundResult copy(@NotNull Sound resource2, boolean isFresh) {
            Intrinsics.checkNotNullParameter(resource2, "resource");
            return new GetSoundResult(resource2, isFresh);
        }

        public static /* synthetic */ GetSoundResult copy$default(GetSoundResult getSoundResult, Sound sound, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                sound = getSoundResult.resource;
            }
            if ((n & 2) != 0) {
                bl = getSoundResult.isFresh;
            }
            return getSoundResult.copy(sound, bl);
        }

        @NotNull
        public String toString() {
            return "GetSoundResult(resource=" + this.resource + ", isFresh=" + this.isFresh + ')';
        }

        public int hashCode() {
            int result2 = this.resource.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isFresh);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GetSoundResult)) {
                return false;
            }
            GetSoundResult getSoundResult = (GetSoundResult)other;
            if (!Intrinsics.areEqual(this.resource, getSoundResult.resource)) {
                return false;
            }
            return this.isFresh == getSoundResult.isFresh;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\bH\u0002J\u0012\u0010\t\u001a\u00020\n*\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/audio/SoundPlayer$Preloader;", "", "()V", "job", "Lkotlinx/coroutines/Job;", "getPreloadList", "", "Lcom/unciv/models/UncivSound;", "Lcom/unciv/models/UncivSound$Companion;", "preload", "", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "core"})
    private static final class Preloader {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Job job;

        /*
         * WARNING - void declaration
         */
        public Preloader() {
            void $this$job_u24lambda_u240;
            Job job2;
            Job job3 = job2 = Concurrency.run$default(Concurrency.INSTANCE, "SoundPreloader", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Preloader this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            CoroutineScope $this$run = (CoroutineScope)this.L$0;
                            this.label = 1;
                            Object object3 = Preloader.access$preload(this.this$0, $this$run, this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)((Object)function2);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 2, null);
            Preloader preloader = this;
            boolean bl = false;
            $this$job_u24lambda_u240.invokeOnCompletion(job.2.1.INSTANCE);
            preloader.job = job2;
        }

        private final List<UncivSound> getPreloadList(UncivSound.Companion $this$getPreloadList) {
            UncivSound[] uncivSoundArray = new UncivSound[]{$this$getPreloadList.getClick(), $this$getPreloadList.getWhoosh(), $this$getPreloadList.getConstruction(), $this$getPreloadList.getPromote(), $this$getPreloadList.getUpgrade(), $this$getPreloadList.getCoin(), $this$getPreloadList.getChimes(), $this$getPreloadList.getChoir()};
            return CollectionsKt.listOf(uncivSoundArray);
        }

        /*
         * Unable to fully structure code
         */
        private final Object preload(CoroutineScope var1_1, Continuation<? super Unit> var2_2) {
            if (!(var2_2 instanceof preload.1)) ** GOTO lbl-1000
            var6_3 = var2_2;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ Preloader this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return Preloader.access$preload(this.this$0, null, this);
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure($result);
                    var3_6 = this.getPreloadList(UncivSound.Companion).iterator();
lbl13:
                    // 3 sources

                    while (var3_6.hasNext()) {
                        sound = (UncivSound)var3_6.next();
                        $continuation.L$0 = $this$preload;
                        $continuation.L$1 = var3_6;
                        $continuation.L$2 = sound;
                        $continuation.label = 1;
                        v0 = DelayKt.delay(10L, $continuation);
                        if (v0 == var7_5) {
                            return var7_5;
                        }
                        ** GOTO lbl30
                    }
                    ** GOTO lbl36
                }
                case 1: {
                    sound = (UncivSound)$continuation.L$2;
                    var3_6 = (Iterator)$continuation.L$1;
                    $this$preload = (CoroutineScope)$continuation.L$0;
                    ResultKt.throwOnFailure($result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    if (!CoroutineScopeKt.isActive($this$preload)) ** GOTO lbl36
                    if (SoundPlayer.access$getSoundMap$p().contains(sound)) ** GOTO lbl13
                    LogKt.debug("Preload " + sound, new Object[0]);
                    SoundPlayer.access$createAndCacheResult(SoundPlayer.INSTANCE, sound, SoundPlayer.access$getFile(SoundPlayer.INSTANCE, sound));
                    if (CoroutineScopeKt.isActive($this$preload)) ** GOTO lbl13
lbl36:
                    // 3 sources

                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        public static final /* synthetic */ Object access$preload(Preloader $this, CoroutineScope $receiver, Continuation $completion) {
            return $this.preload($receiver, $completion);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/audio/SoundPlayer$Preloader$Companion;", "", "()V", "abort", "", "restart", "core"})
        public static final class Companion {
            private Companion() {
            }

            public final void abort() {
                Object object = preloader;
                if (object != null && (object = ((Preloader)object).job) != null) {
                    Job.DefaultImpls.cancel$default((Job)object, null, 1, null);
                }
                SoundPlayer.preloader = null;
            }

            public final void restart() {
                Object object = preloader;
                if (object != null && (object = ((Preloader)object).job) != null) {
                    Job.DefaultImpls.cancel$default((Job)object, null, 1, null);
                }
                SoundPlayer.preloader = new Preloader();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/audio/SoundPlayer$SupportedExtensions;", "", "(Ljava/lang/String;I)V", "mp3", "ogg", "wav", "core"})
    private static final class SupportedExtensions
    extends Enum<SupportedExtensions> {
        public static final /* enum */ SupportedExtensions mp3 = new SupportedExtensions();
        public static final /* enum */ SupportedExtensions ogg = new SupportedExtensions();
        public static final /* enum */ SupportedExtensions wav = new SupportedExtensions();
        private static final /* synthetic */ SupportedExtensions[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SupportedExtensions[] values() {
            return (SupportedExtensions[])$VALUES.clone();
        }

        public static SupportedExtensions valueOf(String value) {
            return Enum.valueOf(SupportedExtensions.class, value);
        }

        @NotNull
        public static EnumEntries<SupportedExtensions> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = supportedExtensionsArray = new SupportedExtensions[]{SupportedExtensions.mp3, SupportedExtensions.ogg, SupportedExtensions.wav};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

