/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.MapArrowType;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.components.tilegroups.layers.MapArrow;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.components.tilegroups.layers.TileLayerMisc;
import com.unciv.ui.images.ImageGetter;
import com.unciv.utils.DebugUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\u0016\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u000bJ\b\u0010\"\u001a\u00020\u0017H\u0002J\b\u0010#\u001a\u00020\u0017H\u0014J\u000e\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&J\u001a\u0010'\u001a\u00020\u00172\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0014J\u001a\u0010,\u001a\u00020\u00172\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u0005H\u0016J\u0006\u00100\u001a\u00020\u0017J\"\u00101\u001a\u0004\u0018\u00010\u000b2\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020&H\u0016J\u000e\u00105\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u00105\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u0005J\u0010\u00107\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u00108\u001a\u00020\u0017J\u0006\u00109\u001a\u00020\u0017J\u0006\u0010:\u001a\u00020\u0017J\u0006\u0010;\u001a\u00020\u0017J\b\u0010<\u001a\u00020\u0017H\u0002J\u0010\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020&H\u0002RJ\u0010\u0007\u001a>\u0012\u0004\u0012\u00020\t\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f0\bj\u001e\u0012\u0004\u0012\u00020\t\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\nj\b\u0012\u0004\u0012\u00020\u000f`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerMisc;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "arrows", "Ljava/util/HashMap;", "Lcom/unciv/logic/map/tile/Tile;", "Ljava/util/ArrayList;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lkotlin/collections/ArrayList;", "Lkotlin/collections/HashMap;", "arrowsToDraw", "Lcom/unciv/ui/components/tilegroups/layers/MapArrow;", "hexOutlineIcon", "startingLocationIcons", "", "terrainOverlay", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "workedIcon", "act", "", "delta", "addArrow", "targetTile", "type", "Lcom/unciv/ui/components/MapArrowType;", "addHexOutline", "color", "Lcom/badlogic/gdx/graphics/Color;", "addWorkedIcon", "icon", "clearArrows", "determineVisibility", "dimPopulation", "dim", "", "doUpdate", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "hideTerrainOverlay", "hit", "x", "y", "touchable", "overlayTerrain", "alpha", "overlayTerrainInner", "removeHexOutline", "removeWorkedIcon", "reset", "resetArrows", "updateArrows", "updateStartingLocationIcon", "show", "core"})
@SourceDebugExtension(value={"SMAP\nTileLayerMisc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileLayerMisc.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerMisc\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,452:1\n1855#2,2:453\n1#3:455\n*S KotlinDebug\n*F\n+ 1 TileLayerMisc.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerMisc\n*L\n297#1:453,2\n*E\n"})
public final class TileLayerMisc
extends TileLayer {
    @Nullable
    private Image terrainOverlay;
    @NotNull
    private final ArrayList<MapArrow> arrowsToDraw;
    @NotNull
    private final HashMap<Tile, ArrayList<Actor>> arrows;
    @Nullable
    private Actor hexOutlineIcon;
    @Nullable
    private Actor workedIcon;
    @NotNull
    private final List<Actor> startingLocationIcons;

    public TileLayerMisc(@NotNull TileGroup tileGroup, float size2) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size2);
        this.terrainOverlay = TileLayer.setHexagonSize$default(this, ImageGetter.getImage$default(ImageGetter.INSTANCE, this.getStrings().getHexagon(), null, 2, null), null, 1, null);
        this.arrowsToDraw = new ArrayList();
        this.arrows = new HashMap();
        this.startingLocationIcons = new ArrayList();
    }

    @Override
    public void act(float delta) {
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        Actor actor;
        if (this.workedIcon == null) {
            actor = null;
        } else {
            Vector2 coords = new Vector2(x, y);
            Actor actor2 = this.workedIcon;
            Intrinsics.checkNotNull(actor2);
            actor2.parentToLocalCoordinates(coords);
            Actor actor3 = this.workedIcon;
            Intrinsics.checkNotNull(actor3);
            actor = actor3.hit(coords.x, coords.y, touchable);
        }
        return actor;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    private final void clearArrows() {
        for (ArrayList<Actor> actorList : this.arrows.values()) {
            for (Actor actor : actorList) {
                actor.remove();
            }
        }
        this.arrows.clear();
    }

    private final void updateArrows() {
        this.clearArrows();
        float tileScale = 40.0f;
        for (MapArrow arrowToAdd : this.arrowsToDraw) {
            Tile targetTile = arrowToAdd.getTargetTile();
            Vector2 targetPos = new Vector2(targetTile.getPosition());
            if (this.getTile().getTileMap().getMapParameters().getWorldWrap()) {
                targetPos = HexMath.INSTANCE.getUnwrappedNearestTo(targetPos, this.getTile().getPosition(), Float.valueOf(this.getTile().getTileMap().getMaxLongitude()));
            }
            Vector2 targetRelative = HexMath.INSTANCE.hex2WorldCoords(targetPos).sub(HexMath.INSTANCE.hex2WorldCoords(this.getTile().getPosition()));
            float targetDistance = (float)Math.sqrt((float)Math.pow(targetRelative.x, 2) + (float)Math.pow(targetRelative.y, 2));
            float targetAngle = (float)Math.atan2(targetRelative.y, targetRelative.x);
            if (!((Map)this.arrows).containsKey(targetTile)) {
                ((Map)this.arrows).put(targetTile, new ArrayList());
            }
            Image arrowImage = arrowToAdd.getImage();
            arrowImage.moveBy(25.0f, -5.0f);
            arrowImage.setSize(tileScale * targetDistance, 60.0f);
            arrowImage.setOrigin(0.0f, 30.0f);
            arrowImage.setRotation(targetAngle / (float)Math.PI * (float)180);
            ArrayList<Actor> arrayList = this.arrows.get(targetTile);
            Intrinsics.checkNotNull(arrayList);
            arrayList.add(arrowImage);
            this.addActor(arrowImage);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateStartingLocationIcon(boolean show) {
        Object newNationIcon;
        Object nation2;
        TileMap tilemap;
        Function1[] $this$updateStartingLocationIcon_u24lambda_u243;
        Unit unit;
        List<Actor> list2;
        String string;
        Iterable $this$forEach$iv = this.startingLocationIcons;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Actor it = (Actor)element$iv;
            boolean bl = false;
            it.remove();
        }
        this.startingLocationIcons.clear();
        if (!show || this.getTileGroup().isForMapEditorIcon()) {
            return;
        }
        if (DebugUtils.INSTANCE.getSHOW_TILE_COORDS()) {
            Label $this$updateStartingLocationIcon_u24lambda_u242;
            Object element$iv;
            String label2 = FormattingExtensionsKt.toPrettyString(this.getTile().getPosition());
            Object object = ImageGetter.INSTANCE.getCHARCOAL().cpy();
            element$iv = object;
            string = label2;
            list2 = this.startingLocationIcons;
            boolean bl = false;
            $this$updateStartingLocationIcon_u24lambda_u241.a = 0.7f;
            unit = Unit.INSTANCE;
            Object object2 = object;
            Intrinsics.checkNotNullExpressionValue(object2, "apply(...)");
            Label $i$f$forEach2 = Scene2dExtensionsKt.toLabel$default(string, (Color)object2, 14, 0, false, 12, null);
            object = $i$f$forEach2;
            boolean bl2 = false;
            this.getTileGroup().getLayerMisc().addActor($this$updateStartingLocationIcon_u24lambda_u242);
            $this$updateStartingLocationIcon_u24lambda_u242.setOrigin(1);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u242, this.getTileGroup());
            $this$updateStartingLocationIcon_u24lambda_u242.moveBy(15.4f, -0.6f);
            list2.add($i$f$forEach2);
            Color color = Color.FIREBRICK;
            Intrinsics.checkNotNullExpressionValue(color, "FIREBRICK");
            $this$updateStartingLocationIcon_u24lambda_u242 = $i$f$forEach2 = Scene2dExtensionsKt.toLabel$default(label2, color, 14, 0, false, 12, null);
            list2 = this.startingLocationIcons;
            boolean bl3 = false;
            this.getTileGroup().getLayerMisc().addActor((Actor)$this$updateStartingLocationIcon_u24lambda_u243);
            $this$updateStartingLocationIcon_u24lambda_u243.setOrigin(1);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u243, this.getTileGroup());
            $this$updateStartingLocationIcon_u24lambda_u243.moveBy(15.0f, 0.0f);
            list2.add($i$f$forEach2);
        }
        if ((tilemap = this.getTile().getTileMap()).getStartingLocationsByNation().isEmpty()) {
            return;
        }
        $this$updateStartingLocationIcon_u24lambda_u243 = new Function1[]{updateStartingLocationIcon.nations.4.INSTANCE, updateStartingLocationIcon.nations.5.INSTANCE};
        List nations2 = SequencesKt.toList(SequencesKt.sortedWith(SequencesKt.map(SequencesKt.filter(SequencesKt.filter(MapsKt.asSequence((Map)tilemap.getStartingLocationsByNation()), (Function1)new Function1<Map.Entry<? extends String, ? extends HashSet<Tile>>, Boolean>(this){
            final /* synthetic */ TileLayerMisc this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<String, ? extends HashSet<Tile>> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getValue().contains(this.this$0.getTile());
            }
        }), (Function1)new Function1<Map.Entry<? extends String, ? extends HashSet<Tile>>, Boolean>(tilemap){
            final /* synthetic */ TileMap $tilemap;
            {
                this.$tilemap = $tilemap;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<String, ? extends HashSet<Tile>> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Ruleset ruleset2 = this.$tilemap.getRuleset();
                Intrinsics.checkNotNull(ruleset2);
                return ((Map)ruleset2.getNations()).containsKey(it.getKey());
            }
        }), (Function1)new Function1<Map.Entry<? extends String, ? extends HashSet<Tile>>, Pair<? extends String, ? extends Nation>>(tilemap){
            final /* synthetic */ TileMap $tilemap;
            {
                this.$tilemap = $tilemap;
                super(1);
            }

            @NotNull
            public final Pair<String, Nation> invoke(@NotNull Map.Entry<String, ? extends HashSet<Tile>> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                String string = it.getKey();
                Ruleset ruleset2 = this.$tilemap.getRuleset();
                Intrinsics.checkNotNull(ruleset2);
                Nation nation2 = ruleset2.getNations().get(it.getKey());
                Intrinsics.checkNotNull(nation2);
                return TuplesKt.to(string, nation2);
            }
        }), ComparisonsKt.compareBy($this$updateStartingLocationIcon_u24lambda_u243)));
        if (nations2.isEmpty()) {
            return;
        }
        int displayCount = Math.min(nations2.size(), 3);
        float offsetX = 0.0f;
        offsetX = (float)(displayCount - 1) * 4.0f;
        float offsetY = 0.0f;
        offsetY = (float)(displayCount - 1) * 2.0f;
        Object object = CollectionsKt.asReversed(CollectionsKt.take(nations2, 3)).iterator();
        while (object.hasNext()) {
            Color color;
            nation2 = (Pair)object.next();
            Object b = ((Pair)nation2).getSecond();
            Intrinsics.checkNotNullExpressionValue(b, "<get-second>(...)");
            newNationIcon = ImageGetter.INSTANCE.getNationPortrait((Nation)b, 20.0f);
            this.getTileGroup().getLayerMisc().addActor((Actor)newNationIcon);
            Object $this$updateStartingLocationIcon_u24lambda_u245 = newNationIcon;
            boolean bl = false;
            ((Actor)$this$updateStartingLocationIcon_u24lambda_u245).setSize(20.0f, 20.0f);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u245, this.getTileGroup());
            ((Actor)$this$updateStartingLocationIcon_u24lambda_u245).moveBy(offsetX, offsetY);
            Color color2 = color = Color.WHITE.cpy();
            Object object3 = $this$updateStartingLocationIcon_u24lambda_u245;
            boolean bl4 = false;
            $this$updateStartingLocationIcon_u24lambda_u245_u24lambda_u244.a = 0.6f;
            ((Actor)object3).setColor(color);
            this.startingLocationIcons.add((Actor)newNationIcon);
            offsetX -= 8.0f;
            offsetY -= 4.0f;
        }
        if (nations2.size() > 3) {
            void $this$updateStartingLocationIcon_u24lambda_u248;
            Object $this$updateStartingLocationIcon_u24lambda_u247;
            newNationIcon = nation2 = ImageGetter.INSTANCE.getCHARCOAL().cpy();
            string = TranslationsKt.tr(nations2.size());
            list2 = this.startingLocationIcons;
            boolean bl = false;
            $this$updateStartingLocationIcon_u24lambda_u246.a = 0.7f;
            unit = Unit.INSTANCE;
            Object object4 = nation2;
            Intrinsics.checkNotNullExpressionValue(object4, "apply(...)");
            nation2 = object = Scene2dExtensionsKt.toLabel$default(string, (Color)object4, 14, 0, false, 12, null);
            boolean bl5 = false;
            this.getTileGroup().getLayerMisc().addActor((Actor)$this$updateStartingLocationIcon_u24lambda_u247);
            ((Actor)$this$updateStartingLocationIcon_u24lambda_u247).setOrigin(1);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u247, this.getTileGroup());
            ((Actor)$this$updateStartingLocationIcon_u24lambda_u247).moveBy(14.4f, -9.0f);
            list2.add((Actor)object);
            String string2 = TranslationsKt.tr(nations2.size());
            Color color = Color.FIREBRICK;
            Intrinsics.checkNotNullExpressionValue(color, "FIREBRICK");
            $this$updateStartingLocationIcon_u24lambda_u247 = object = Scene2dExtensionsKt.toLabel$default(string2, color, 14, 0, false, 12, null);
            list2 = this.startingLocationIcons;
            boolean bl6 = false;
            this.getTileGroup().getLayerMisc().addActor((Actor)$this$updateStartingLocationIcon_u24lambda_u248);
            $this$updateStartingLocationIcon_u24lambda_u248.setOrigin(1);
            Scene2dExtensionsKt.center((Actor)$this$updateStartingLocationIcon_u24lambda_u248, this.getTileGroup());
            $this$updateStartingLocationIcon_u24lambda_u248.moveBy(14.0f, -8.4f);
            list2.add((Actor)object);
        }
    }

    public final void removeWorkedIcon() {
        Actor actor = this.workedIcon;
        if (actor != null) {
            actor.remove();
        }
        this.workedIcon = null;
        this.determineVisibility();
    }

    public final void addWorkedIcon(@NotNull Actor icon) {
        Intrinsics.checkNotNullParameter(icon, "icon");
        this.workedIcon = icon;
        this.addActor(this.workedIcon);
        this.determineVisibility();
    }

    public final void addHexOutline(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        Actor actor = this.hexOutlineIcon;
        if (actor != null) {
            actor.remove();
        }
        Actor actor2 = this.hexOutlineIcon = (Actor)this.setHexagonSize(ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/HexagonOutline", null, 2, null), Float.valueOf(1.0f));
        Intrinsics.checkNotNull(actor2);
        actor2.setColor(color);
        this.addActor(this.hexOutlineIcon);
        Actor actor3 = this.hexOutlineIcon;
        Intrinsics.checkNotNull(actor3);
        actor3.toBack();
        this.determineVisibility();
    }

    public final void removeHexOutline() {
        Actor actor = this.hexOutlineIcon;
        if (actor != null) {
            actor.remove();
        }
        this.hexOutlineIcon = null;
        this.determineVisibility();
    }

    public final void overlayTerrain(@NotNull Color color) {
        Color color2;
        Intrinsics.checkNotNullParameter(color, "color");
        Color color3 = color2 = Scene2dExtensionsKt.brighten(color, 0.3f);
        TileLayerMisc tileLayerMisc = this;
        boolean bl = false;
        $this$overlayTerrain_u24lambda_u249.a = 0.4f;
        tileLayerMisc.overlayTerrainInner(color2);
    }

    public final void overlayTerrain(@NotNull Color color, float alpha) {
        Color color2;
        Intrinsics.checkNotNullParameter(color, "color");
        Color color3 = color2 = color.cpy();
        TileLayerMisc tileLayerMisc = this;
        boolean bl = false;
        $this$overlayTerrain_u24lambda_u2410.a = alpha;
        Color color4 = color2;
        Intrinsics.checkNotNullExpressionValue(color4, "apply(...)");
        tileLayerMisc.overlayTerrainInner(color4);
    }

    private final void overlayTerrainInner(Color color) {
        if (this.terrainOverlay == null) {
            this.terrainOverlay = TileLayer.setHexagonSize$default(this, ImageGetter.getImage$default(ImageGetter.INSTANCE, this.getStrings().getHexagon(), null, 2, null), null, 1, null);
            this.addActor(this.terrainOverlay);
        }
        Image image2 = this.terrainOverlay;
        if (image2 != null) {
            image2.setColor(color);
        }
        this.determineVisibility();
    }

    public final void hideTerrainOverlay() {
        Image image2 = this.terrainOverlay;
        if (image2 != null) {
            image2.remove();
        }
        this.terrainOverlay = null;
        this.determineVisibility();
    }

    public final void addArrow(@NotNull Tile targetTile, @NotNull MapArrowType type2) {
        Intrinsics.checkNotNullParameter(targetTile, "targetTile");
        Intrinsics.checkNotNullParameter(type2, "type");
        if (!Intrinsics.areEqual(targetTile.getPosition(), this.getTile().getPosition())) {
            this.arrowsToDraw.add(new MapArrow(targetTile, type2, this.getStrings()));
        }
    }

    public final void resetArrows() {
        this.arrowsToDraw.clear();
    }

    public final void dimPopulation(boolean dim) {
        Actor actor = this.workedIcon;
        if ((actor != null ? actor.getColor() : null) != null) {
            (actor != null ? actor.getColor() : null).a = dim ? 0.4f : 1.0f;
        }
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        if (!(this.getTileGroup() instanceof WorldTileGroup) || DebugUtils.INSTANCE.getSHOW_TILE_COORDS()) {
            this.updateStartingLocationIcon(true);
        }
        this.updateArrows();
    }

    @Override
    protected void determineVisibility() {
        this.setVisible(this.workedIcon != null || this.hexOutlineIcon != null || !((Map)this.arrows).isEmpty() || !((Collection)this.startingLocationIcons).isEmpty() || this.terrainOverlay != null);
    }

    public final void reset() {
        this.updateStartingLocationIcon(false);
        this.clearArrows();
    }
}

