/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Disposable;
import com.unciv.GUI;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002:\u0004#$%&B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0002J\u0018\u0010\u001b\u001a\u00020\u00152\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00152\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001dH\u0002J\u0018\u0010\u001f\u001a\u00020\u00152\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001dH\u0002J\u0006\u0010 \u001a\u00020\tJ\b\u0010!\u001a\u00020\u0015H\u0002J\u0006\u0010\"\u001a\u00020\u0015R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/unciv/ui/components/widgets/LoadingImage;", "Lcom/badlogic/gdx/scenes/scene2d/ui/WidgetGroup;", "Lcom/badlogic/gdx/utils/Disposable;", "size", "", "style", "Lcom/unciv/ui/components/widgets/LoadingImage$Style;", "(FLcom/unciv/ui/components/widgets/LoadingImage$Style;)V", "animated", "", "getAnimated", "()Z", "setAnimated", "(Z)V", "circle", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "idleIcon", "loadingIcon", "loadingStarted", "Lkotlin/time/TimeMark;", "dispose", "", "getMaxHeight", "getMaxWidth", "getPrefHeight", "getPrefWidth", "getWaitDuration", "hide", "onComplete", "Lkotlin/Function0;", "hideAnimated", "hideDelayed", "isShowing", "setHidden", "show", "FadeoverAction", "SpinAction", "Style", "Testing", "core"})
public final class LoadingImage
extends WidgetGroup
implements Disposable {
    private final float size;
    @NotNull
    private final Style style;
    @Nullable
    private final Image circle;
    @Nullable
    private final Image idleIcon;
    @NotNull
    private final Image loadingIcon;
    private boolean animated;
    @Nullable
    private TimeMark loadingStarted;

    /*
     * WARNING - void declaration
     */
    public LoadingImage(float size2, @NotNull Style style) {
        void $this$_init__u24lambda_u240;
        Image image2;
        Intrinsics.checkNotNullParameter(style, "style");
        this.size = size2;
        this.style = style;
        this.animated = GUI.INSTANCE.getSettings().getContinuousRendering();
        this.setTransform(false);
        this.setSize(this.size, this.size);
        float innerSize = this.size * (!Float.isNaN(this.style.getInnerSizeFactor()) ? this.style.getInnerSizeFactor() : (Intrinsics.areEqual(this.style.getCircleColor(), Color.CLEAR) ? 1.0f : 0.785f));
        if (Intrinsics.areEqual(this.style.getCircleColor(), Color.CLEAR)) {
            this.circle = null;
        } else {
            this.circle = ImageGetter.getImage$default(ImageGetter.INSTANCE, this.style.getCircleImageName(), null, 2, null);
            this.circle.setColor(this.style.getCircleColor());
            Scene2dExtensionsKt.setSize(this.circle, this.size);
            this.addActor(this.circle);
        }
        if (Intrinsics.areEqual(this.style.getIdleIconColor(), Color.CLEAR)) {
            this.idleIcon = null;
        } else {
            this.idleIcon = ImageGetter.getImage$default(ImageGetter.INSTANCE, this.style.getIdleImageName(), null, 2, null);
            this.idleIcon.setColor(this.style.getIdleIconColor());
            Scene2dExtensionsKt.setSize(this.idleIcon, innerSize);
            Scene2dExtensionsKt.center((Actor)this.idleIcon, this);
            this.addActor(this.idleIcon);
        }
        Image image3 = image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, this.style.getLoadingImageName(), null, 2, null);
        LoadingImage loadingImage = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setColor(this.style.getLoadingColor());
        $this$_init__u24lambda_u240.getColor().a = 0.0f;
        Scene2dExtensionsKt.setSize((Image)$this$_init__u24lambda_u240, innerSize);
        $this$_init__u24lambda_u240.setOrigin(1);
        $this$_init__u24lambda_u240.setVisible(false);
        loadingImage.loadingIcon = image2;
        Scene2dExtensionsKt.center((Actor)this.loadingIcon, this);
        this.addActor(this.loadingIcon);
    }

    public /* synthetic */ LoadingImage(float f, Style style, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 40.0f;
        }
        if ((n & 2) != 0) {
            style = new Style(null, null, null, 0, null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, 2047, null);
        }
        this(f, style);
    }

    public final boolean getAnimated() {
        return this.animated;
    }

    public final void setAnimated(boolean bl) {
        this.animated = bl;
    }

    public final void show() {
        this.loadingStarted = TimeSource.Monotonic.ValueTimeMark.box-impl(TimeSource.Monotonic.INSTANCE.markNow-z9LOYto());
        this.loadingIcon.setVisible(true);
        this.getActions().clear();
        if (this.animated) {
            this.getActions().add(new FadeoverAction(this, 1.0f, 0.0f, null, 4, null), new SpinAction());
        } else {
            this.loadingIcon.getColor().a = 1.0f;
            Image image2 = this.idleIcon;
            if ((image2 != null ? image2.getColor() : null) != null) {
                (image2 != null ? image2.getColor() : null).a = this.style.getIdleIconHiddenAlpha();
            }
        }
    }

    public final void hide(@Nullable Function0<Unit> onComplete) {
        if (this.animated) {
            this.hideAnimated(onComplete);
        } else {
            this.hideDelayed(onComplete);
        }
    }

    public static /* synthetic */ void hide$default(LoadingImage loadingImage, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = null;
        }
        loadingImage.hide(function0);
    }

    public final boolean isShowing() {
        return this.loadingIcon.isVisible() && this.getActions().isEmpty();
    }

    private final void hideAnimated(Function0<Unit> onComplete) {
        this.getActions().clear();
        this.getActions().add(new FadeoverAction(this, 0.0f, this.getWaitDuration() - (float)2 * this.style.getFadeDuration(), onComplete));
    }

    private final void hideDelayed(Function0<Unit> onComplete) {
        float waitDuration = this.getWaitDuration();
        if (waitDuration == 0.0f) {
            this.setHidden();
            return;
        }
        this.getActions().clear();
        this.getActions().add(Actions.delay(waitDuration, Actions.run(() -> LoadingImage.hideDelayed$lambda$1(this, onComplete))));
    }

    private final void setHidden() {
        this.getActions().clear();
        this.loadingIcon.setVisible(false);
        this.loadingIcon.getColor().a = 0.0f;
        Image image2 = this.idleIcon;
        if ((image2 != null ? image2.getColor() : null) != null) {
            (image2 != null ? image2.getColor() : null).a = 1.0f;
        }
    }

    private final float getWaitDuration() {
        long elapsed;
        TimeMark timeMark = this.loadingStarted;
        long l = elapsed = timeMark != null ? Duration.getInWholeMilliseconds-impl(timeMark.elapsedNow-UwyO8pc()) : 0L;
        if (elapsed >= (long)this.style.getMinShowTime()) {
            return 0.0f;
        }
        return (float)((long)this.style.getMinShowTime() - elapsed) * 0.001f;
    }

    @Override
    public float getPrefWidth() {
        return this.size;
    }

    @Override
    public float getPrefHeight() {
        return this.size;
    }

    @Override
    public float getMaxWidth() {
        return this.size;
    }

    @Override
    public float getMaxHeight() {
        return this.size;
    }

    @Override
    public void dispose() {
        this.clearActions();
    }

    private static final void hideDelayed$lambda$1(LoadingImage this$0, Function0 $onComplete) {
        block0: {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            this$0.setHidden();
            Function0 function0 = $onComplete;
            if (function0 == null) break block0;
            function0.invoke();
        }
    }

    public LoadingImage() {
        this(0.0f, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\u0007H\u0014J\b\u0010\f\u001a\u00020\u0007H\u0014J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0003H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/unciv/ui/components/widgets/LoadingImage$FadeoverAction;", "Lcom/badlogic/gdx/scenes/scene2d/actions/TemporalAction;", "endAlpha", "", "delay", "onComplete", "Lkotlin/Function0;", "", "(Lcom/unciv/ui/components/widgets/LoadingImage;FFLkotlin/jvm/functions/Function0;)V", "startAlpha", "totalChange", "begin", "end", "update", "percent", "core"})
    private final class FadeoverAction
    extends TemporalAction {
        private final float endAlpha;
        @Nullable
        private final Function0<Unit> onComplete;
        private float startAlpha;
        private float totalChange;
        final /* synthetic */ LoadingImage this$0;

        public FadeoverAction(LoadingImage this$0, float endAlpha, @Nullable float delay2, Function0<Unit> onComplete) {
            this.this$0 = this$0;
            super(this$0.style.getFadeDuration());
            this.endAlpha = endAlpha;
            this.onComplete = onComplete;
            this.totalChange = 1.0f;
            if (delay2 > 0.0f) {
                this.setTime(-delay2);
            }
        }

        public /* synthetic */ FadeoverAction(LoadingImage loadingImage, float f, float f2, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                function0 = null;
            }
            this(loadingImage, f, f2, function0);
        }

        @Override
        protected void update(float percent) {
            float alpha;
            if (percent < 0.0f) {
                return;
            }
            ((LoadingImage)this.this$0).loadingIcon.getColor().a = alpha = this.startAlpha + percent * this.totalChange;
            if (this.this$0.idleIcon == null) {
                return;
            }
            ((LoadingImage)this.this$0).idleIcon.getColor().a = (1.0f - alpha) * (1.0f - this.this$0.style.getIdleIconHiddenAlpha()) + this.this$0.style.getIdleIconHiddenAlpha();
        }

        @Override
        protected void begin() {
            this.startAlpha = ((LoadingImage)this.this$0).loadingIcon.getColor().a;
            this.totalChange = this.endAlpha - this.startAlpha;
            this.setDuration(this.this$0.style.getFadeDuration() * Math.abs(this.totalChange));
        }

        @Override
        protected void end() {
            block1: {
                if (this.endAlpha == 0.0f) {
                    this.this$0.setHidden();
                }
                Function0<Unit> function0 = this.onComplete;
                if (function0 == null) break block1;
                function0.invoke();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/components/widgets/LoadingImage$SpinAction;", "Lcom/badlogic/gdx/scenes/scene2d/actions/TemporalAction;", "(Lcom/unciv/ui/components/widgets/LoadingImage;)V", "end", "", "update", "percent", "", "core"})
    private final class SpinAction
    extends TemporalAction {
        public SpinAction() {
            super(LoadingImage.this.style.getRotationDuration());
        }

        @Override
        protected void update(float percent) {
            LoadingImage.this.loadingIcon.setRotation(360.0f * (1.0f - percent));
        }

        @Override
        protected void end() {
            this.restart();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b \n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001Bs\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u0012\b\b\u0002\u0010\u0010\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\rH\u00c6\u0003J\t\u0010#\u001a\u00020\rH\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0007H\u00c6\u0003J\t\u0010'\u001a\u00020\tH\u00c6\u0003J\t\u0010(\u001a\u00020\tH\u00c6\u0003J\t\u0010)\u001a\u00020\tH\u00c6\u0003J\t\u0010*\u001a\u00020\rH\u00c6\u0003J\t\u0010+\u001a\u00020\rH\u00c6\u0003Jw\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\rH\u00c6\u0001J\u0013\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00100\u001a\u00020\u0007H\u00d6\u0001J\t\u00101\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0017\u00a8\u00062"}, d2={"Lcom/unciv/ui/components/widgets/LoadingImage$Style;", "", "circleColor", "Lcom/badlogic/gdx/graphics/Color;", "loadingColor", "idleIconColor", "minShowTime", "", "circleImageName", "", "idleImageName", "loadingImageName", "innerSizeFactor", "", "fadeDuration", "rotationDuration", "idleIconHiddenAlpha", "(Lcom/badlogic/gdx/graphics/Color;Lcom/badlogic/gdx/graphics/Color;Lcom/badlogic/gdx/graphics/Color;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;FFFF)V", "getCircleColor", "()Lcom/badlogic/gdx/graphics/Color;", "getCircleImageName", "()Ljava/lang/String;", "getFadeDuration", "()F", "getIdleIconColor", "getIdleIconHiddenAlpha", "getIdleImageName", "getInnerSizeFactor", "getLoadingColor", "getLoadingImageName", "getMinShowTime", "()I", "getRotationDuration", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "core"})
    public static final class Style {
        @NotNull
        private final Color circleColor;
        @NotNull
        private final Color loadingColor;
        @NotNull
        private final Color idleIconColor;
        private final int minShowTime;
        @NotNull
        private final String circleImageName;
        @NotNull
        private final String idleImageName;
        @NotNull
        private final String loadingImageName;
        private final float innerSizeFactor;
        private final float fadeDuration;
        private final float rotationDuration;
        private final float idleIconHiddenAlpha;

        public Style(@NotNull Color circleColor, @NotNull Color loadingColor, @NotNull Color idleIconColor, int minShowTime, @NotNull String circleImageName, @NotNull String idleImageName, @NotNull String loadingImageName, float innerSizeFactor, float fadeDuration, float rotationDuration, float idleIconHiddenAlpha) {
            Intrinsics.checkNotNullParameter(circleColor, "circleColor");
            Intrinsics.checkNotNullParameter(loadingColor, "loadingColor");
            Intrinsics.checkNotNullParameter(idleIconColor, "idleIconColor");
            Intrinsics.checkNotNullParameter(circleImageName, "circleImageName");
            Intrinsics.checkNotNullParameter(idleImageName, "idleImageName");
            Intrinsics.checkNotNullParameter(loadingImageName, "loadingImageName");
            this.circleColor = circleColor;
            this.loadingColor = loadingColor;
            this.idleIconColor = idleIconColor;
            this.minShowTime = minShowTime;
            this.circleImageName = circleImageName;
            this.idleImageName = idleImageName;
            this.loadingImageName = loadingImageName;
            this.innerSizeFactor = innerSizeFactor;
            this.fadeDuration = fadeDuration;
            this.rotationDuration = rotationDuration;
            this.idleIconHiddenAlpha = idleIconHiddenAlpha;
        }

        public /* synthetic */ Style(Color color, Color color2, Color color3, int n, String string, String string2, String string3, float f, float f2, float f3, float f4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                Color color4 = Color.CLEAR;
                Intrinsics.checkNotNullExpressionValue(color4, "CLEAR");
                color = color4;
            }
            if ((n2 & 2) != 0) {
                Color color5 = Color.WHITE;
                Intrinsics.checkNotNullExpressionValue(color5, "WHITE");
                color2 = color5;
            }
            if ((n2 & 4) != 0) {
                Color color6 = Color.CLEAR;
                Intrinsics.checkNotNullExpressionValue(color6, "CLEAR");
                color3 = color6;
            }
            if ((n2 & 8) != 0) {
                n = 0;
            }
            if ((n2 & 0x10) != 0) {
                string = "OtherIcons/Circle";
            }
            if ((n2 & 0x20) != 0) {
                string2 = "OtherIcons/whiteDot";
            }
            if ((n2 & 0x40) != 0) {
                string3 = "OtherIcons/Loading";
            }
            if ((n2 & 0x80) != 0) {
                f = Float.NaN;
            }
            if ((n2 & 0x100) != 0) {
                f2 = 0.2f;
            }
            if ((n2 & 0x200) != 0) {
                f3 = 4.0f;
            }
            if ((n2 & 0x400) != 0) {
                f4 = 0.4f;
            }
            this(color, color2, color3, n, string, string2, string3, f, f2, f3, f4);
        }

        @NotNull
        public final Color getCircleColor() {
            return this.circleColor;
        }

        @NotNull
        public final Color getLoadingColor() {
            return this.loadingColor;
        }

        @NotNull
        public final Color getIdleIconColor() {
            return this.idleIconColor;
        }

        public final int getMinShowTime() {
            return this.minShowTime;
        }

        @NotNull
        public final String getCircleImageName() {
            return this.circleImageName;
        }

        @NotNull
        public final String getIdleImageName() {
            return this.idleImageName;
        }

        @NotNull
        public final String getLoadingImageName() {
            return this.loadingImageName;
        }

        public final float getInnerSizeFactor() {
            return this.innerSizeFactor;
        }

        public final float getFadeDuration() {
            return this.fadeDuration;
        }

        public final float getRotationDuration() {
            return this.rotationDuration;
        }

        public final float getIdleIconHiddenAlpha() {
            return this.idleIconHiddenAlpha;
        }

        @NotNull
        public final Color component1() {
            return this.circleColor;
        }

        @NotNull
        public final Color component2() {
            return this.loadingColor;
        }

        @NotNull
        public final Color component3() {
            return this.idleIconColor;
        }

        public final int component4() {
            return this.minShowTime;
        }

        @NotNull
        public final String component5() {
            return this.circleImageName;
        }

        @NotNull
        public final String component6() {
            return this.idleImageName;
        }

        @NotNull
        public final String component7() {
            return this.loadingImageName;
        }

        public final float component8() {
            return this.innerSizeFactor;
        }

        public final float component9() {
            return this.fadeDuration;
        }

        public final float component10() {
            return this.rotationDuration;
        }

        public final float component11() {
            return this.idleIconHiddenAlpha;
        }

        @NotNull
        public final Style copy(@NotNull Color circleColor, @NotNull Color loadingColor, @NotNull Color idleIconColor, int minShowTime, @NotNull String circleImageName, @NotNull String idleImageName, @NotNull String loadingImageName, float innerSizeFactor, float fadeDuration, float rotationDuration, float idleIconHiddenAlpha) {
            Intrinsics.checkNotNullParameter(circleColor, "circleColor");
            Intrinsics.checkNotNullParameter(loadingColor, "loadingColor");
            Intrinsics.checkNotNullParameter(idleIconColor, "idleIconColor");
            Intrinsics.checkNotNullParameter(circleImageName, "circleImageName");
            Intrinsics.checkNotNullParameter(idleImageName, "idleImageName");
            Intrinsics.checkNotNullParameter(loadingImageName, "loadingImageName");
            return new Style(circleColor, loadingColor, idleIconColor, minShowTime, circleImageName, idleImageName, loadingImageName, innerSizeFactor, fadeDuration, rotationDuration, idleIconHiddenAlpha);
        }

        public static /* synthetic */ Style copy$default(Style style, Color color, Color color2, Color color3, int n, String string, String string2, String string3, float f, float f2, float f3, float f4, int n2, Object object) {
            if ((n2 & 1) != 0) {
                color = style.circleColor;
            }
            if ((n2 & 2) != 0) {
                color2 = style.loadingColor;
            }
            if ((n2 & 4) != 0) {
                color3 = style.idleIconColor;
            }
            if ((n2 & 8) != 0) {
                n = style.minShowTime;
            }
            if ((n2 & 0x10) != 0) {
                string = style.circleImageName;
            }
            if ((n2 & 0x20) != 0) {
                string2 = style.idleImageName;
            }
            if ((n2 & 0x40) != 0) {
                string3 = style.loadingImageName;
            }
            if ((n2 & 0x80) != 0) {
                f = style.innerSizeFactor;
            }
            if ((n2 & 0x100) != 0) {
                f2 = style.fadeDuration;
            }
            if ((n2 & 0x200) != 0) {
                f3 = style.rotationDuration;
            }
            if ((n2 & 0x400) != 0) {
                f4 = style.idleIconHiddenAlpha;
            }
            return style.copy(color, color2, color3, n, string, string2, string3, f, f2, f3, f4);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Style(circleColor=").append(this.circleColor).append(", loadingColor=").append(this.loadingColor).append(", idleIconColor=").append(this.idleIconColor).append(", minShowTime=").append(this.minShowTime).append(", circleImageName=").append(this.circleImageName).append(", idleImageName=").append(this.idleImageName).append(", loadingImageName=").append(this.loadingImageName).append(", innerSizeFactor=").append(this.innerSizeFactor).append(", fadeDuration=").append(this.fadeDuration).append(", rotationDuration=").append(this.rotationDuration).append(", idleIconHiddenAlpha=").append(this.idleIconHiddenAlpha).append(')');
            return stringBuilder.toString();
        }

        public int hashCode() {
            int result2 = this.circleColor.hashCode();
            result2 = result2 * 31 + this.loadingColor.hashCode();
            result2 = result2 * 31 + this.idleIconColor.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.minShowTime);
            result2 = result2 * 31 + this.circleImageName.hashCode();
            result2 = result2 * 31 + this.idleImageName.hashCode();
            result2 = result2 * 31 + this.loadingImageName.hashCode();
            result2 = result2 * 31 + Float.hashCode(this.innerSizeFactor);
            result2 = result2 * 31 + Float.hashCode(this.fadeDuration);
            result2 = result2 * 31 + Float.hashCode(this.rotationDuration);
            result2 = result2 * 31 + Float.hashCode(this.idleIconHiddenAlpha);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Style)) {
                return false;
            }
            Style style = (Style)other;
            if (!Intrinsics.areEqual(this.circleColor, style.circleColor)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.loadingColor, style.loadingColor)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.idleIconColor, style.idleIconColor)) {
                return false;
            }
            if (this.minShowTime != style.minShowTime) {
                return false;
            }
            if (!Intrinsics.areEqual(this.circleImageName, style.circleImageName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.idleImageName, style.idleImageName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.loadingImageName, style.loadingImageName)) {
                return false;
            }
            if (Float.compare(this.innerSizeFactor, style.innerSizeFactor) != 0) {
                return false;
            }
            if (Float.compare(this.fadeDuration, style.fadeDuration) != 0) {
                return false;
            }
            if (Float.compare(this.rotationDuration, style.rotationDuration) != 0) {
                return false;
            }
            return Float.compare(this.idleIconHiddenAlpha, style.idleIconHiddenAlpha) == 0;
        }

        public Style() {
            this(null, null, null, 0, null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, 2047, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/unciv/ui/components/widgets/LoadingImage$Testing;", "", "()V", "getFasterUIDevelopmentTester", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "core"})
    public static final class Testing {
        @NotNull
        public static final Testing INSTANCE = new Testing();

        private Testing() {
        }

        @NotNull
        public final Table getFasterUIDevelopmentTester() {
            Table table2;
            Table $this$getFasterUIDevelopmentTester_u24lambda_u240 = table2 = new Table();
            boolean bl = false;
            Color color = Color.NAVY;
            Color color2 = Color.SCARLET;
            Color color3 = Color.CYAN;
            Intrinsics.checkNotNull(color);
            Intrinsics.checkNotNull(color2);
            Intrinsics.checkNotNull(color3);
            LoadingImage testee = new LoadingImage(52.0f, new Style(color, color2, color3, 1500, null, "OtherIcons/Multiplayer", null, 0.0f, 0.0f, 0.0f, 0.0f, 2000, null));
            $this$getFasterUIDevelopmentTester_u24lambda_u240.defaults().pad(10.0f).center();
            $this$getFasterUIDevelopmentTester_u24lambda_u240.add((Actor)testee);
            $this$getFasterUIDevelopmentTester_u24lambda_u240.add(ActivationExtensionsKt.onClick(new TextButton("Start", BaseScreen.Companion.getSkin()), new Function0<Unit>(testee){
                final /* synthetic */ LoadingImage $testee;
                {
                    this.$testee = $testee;
                    super(0);
                }

                public final void invoke() {
                    this.$testee.show();
                }
            }));
            $this$getFasterUIDevelopmentTester_u24lambda_u240.add(ActivationExtensionsKt.onClick(new TextButton("Stop", BaseScreen.Companion.getSkin()), new Function0<Unit>(testee){
                final /* synthetic */ LoadingImage $testee;
                {
                    this.$testee = $testee;
                    super(0);
                }

                public final void invoke() {
                    LoadingImage.hide$default(this.$testee, null, 1, null);
                }
            }));
            $this$getFasterUIDevelopmentTester_u24lambda_u240.row();
            CheckBox check2 = new CheckBox(" animated ", BaseScreen.Companion.getSkin());
            check2.setChecked(testee.getAnimated());
            ActivationExtensionsKt.onChange(check2, (Function1<? super ChangeListener.ChangeEvent, Unit>)new Function1<ChangeListener.ChangeEvent, Unit>(testee, check2){
                final /* synthetic */ LoadingImage $testee;
                final /* synthetic */ CheckBox $check;
                {
                    this.$testee = $testee;
                    this.$check = $check;
                    super(1);
                }

                public final void invoke(@Nullable ChangeListener.ChangeEvent it) {
                    this.$testee.setAnimated(this.$check.isChecked());
                }
            });
            $this$getFasterUIDevelopmentTester_u24lambda_u240.add((Actor)check2).colspan(3);
            $this$getFasterUIDevelopmentTester_u24lambda_u240.pack();
            return table2;
        }
    }
}

