/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.ui.components.NonTransformGroup;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.FlagBackground;
import com.unciv.ui.images.ImageGetter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0002J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Lcom/unciv/ui/components/widgets/UnitIconGroup;", "Lcom/unciv/ui/components/NonTransformGroup;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "size", "", "(Lcom/unciv/logic/map/mapunit/MapUnit;F)V", "actionGroup", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "getActionGroup", "()Lcom/badlogic/gdx/scenes/scene2d/Group;", "setActionGroup", "(Lcom/badlogic/gdx/scenes/scene2d/Group;)V", "flagBg", "Lcom/unciv/ui/components/widgets/FlagBackground;", "flagIcon", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "flagMask", "flagSelection", "getSize", "()F", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "getActionImage", "getBackgroundDrawableForUnit", "Lcom/badlogic/gdx/scenes/scene2d/utils/TextureRegionDrawable;", "getBackgroundInnerDrawableForUnit", "getBackgroundMaskForUnit", "getBackgroundSelectionForUnit", "highlightRed", "", "selectUnit", "core"})
public final class UnitIconGroup
extends NonTransformGroup {
    @NotNull
    private final MapUnit unit;
    private final float size;
    @Nullable
    private Group actionGroup;
    @NotNull
    private final Image flagIcon;
    @NotNull
    private FlagBackground flagBg;
    @NotNull
    private Image flagSelection;
    @Nullable
    private Image flagMask;

    public UnitIconGroup(@NotNull MapUnit unit, float size2) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.unit = unit;
        this.size = size2;
        this.flagIcon = ImageGetter.INSTANCE.getUnitIcon(this.unit.getBaseUnit(), this.unit.getCiv().getNation().getInnerColor());
        this.flagBg = new FlagBackground(this.getBackgroundDrawableForUnit(), this.size);
        this.flagSelection = this.getBackgroundSelectionForUnit();
        this.flagMask = this.getBackgroundMaskForUnit();
        Color color = this.getColor();
        color.a *= UncivGame.Companion.getCurrent().getSettings().getUnitIconOpacity();
        float sizeSelectionX = this.size * 1.6f;
        float sizeSelectionY = sizeSelectionX * this.flagSelection.getHeight() / this.flagSelection.getWidth();
        this.setSize(this.flagBg.getWidth(), this.flagBg.getHeight());
        this.flagSelection.getColor().set(1.0f, 1.0f, 0.9f, 0.0f);
        this.flagSelection.setAlign(1);
        this.flagSelection.setSize(sizeSelectionX, sizeSelectionY);
        this.flagBg.setInnerColor(this.unit.getCiv().getNation().getOuterColor());
        this.flagBg.setOuterColor(this.unit.getCiv().getNation().getInnerColor());
        this.flagBg.setOutlineColor(this.flagBg.getInnerColor());
        this.flagBg.setDrawableInner(this.getBackgroundInnerDrawableForUnit());
        if (this.flagMask != null) {
            Image image2 = this.flagMask;
            Intrinsics.checkNotNull(image2);
            Image image3 = this.flagMask;
            Intrinsics.checkNotNull(image3);
            float f = this.size * 0.88f * image3.getHeight();
            Image image4 = this.flagMask;
            Intrinsics.checkNotNull(image4);
            image2.setSize(this.size * 0.88f, f / image4.getWidth());
        }
        float flagIconSizeMultiplier = this.unit.isCivilian() ? 0.5f : 0.65f;
        Scene2dExtensionsKt.setSize(this.flagIcon, this.size * flagIconSizeMultiplier);
        Scene2dExtensionsKt.addToCenter(this, this.flagSelection);
        Scene2dExtensionsKt.addToCenter(this, this.flagBg);
        if (this.flagMask != null) {
            Group group = this;
            Image image5 = this.flagMask;
            Intrinsics.checkNotNull(image5);
            Scene2dExtensionsKt.addToCenter(group, image5);
        }
        Scene2dExtensionsKt.addToCenter(this, this.flagIcon);
        Image actionImage = this.getActionImage();
        if (actionImage != null) {
            Group group = this.actionGroup = (Group)Scene2dExtensionsKt.surroundWithThinCircle$default(Scene2dExtensionsKt.surroundWithCircle$default(actionImage, this.size / (float)2 * 0.9f, false, null, null, 14, null), null, 1, null);
            Intrinsics.checkNotNull(group);
            group.setPosition(this.size / (float)2, 0.0f);
            this.addActor(this.actionGroup);
        }
        if (this.unit.getHealth() < 100) {
            Table hp = ImageGetter.getHealthBar$default(ImageGetter.INSTANCE, this.unit.getHealth(), 100.0f, this.size * 0.78f, 0.0f, 8, null);
            this.addActor(hp);
            Scene2dExtensionsKt.centerX((Actor)hp, this);
        }
    }

    @NotNull
    public final MapUnit getUnit() {
        return this.unit;
    }

    public final float getSize() {
        return this.size;
    }

    @Nullable
    public final Group getActionGroup() {
        return this.actionGroup;
    }

    public final void setActionGroup(@Nullable Group group) {
        this.actionGroup = group;
    }

    private final TextureRegionDrawable getBackgroundDrawableForUnit() {
        return this.unit.isEmbarked() ? ImageGetter.INSTANCE.getDrawable("UnitFlagIcons/UnitFlagEmbark") : (this.unit.isFortified() ? ImageGetter.INSTANCE.getDrawable("UnitFlagIcons/UnitFlagFortify") : (this.unit.isGuarding() ? ImageGetter.INSTANCE.getDrawable("UnitFlagIcons/UnitFlagFortify") : (this.unit.isCivilian() ? ImageGetter.INSTANCE.getDrawable("UnitFlagIcons/UnitFlagCivilian") : ImageGetter.INSTANCE.getDrawable("UnitFlagIcons/UnitFlag"))));
    }

    private final TextureRegionDrawable getBackgroundInnerDrawableForUnit() {
        return this.unit.isEmbarked() ? ImageGetter.INSTANCE.getDrawableOrNull("UnitFlagIcons/UnitFlagEmbarkInner") : (this.unit.isFortified() ? ImageGetter.INSTANCE.getDrawableOrNull("UnitFlagIcons/UnitFlagFortifyInner") : (this.unit.isGuarding() ? ImageGetter.INSTANCE.getDrawableOrNull("UnitFlagIcons/UnitFlagFortifyInner") : (this.unit.isCivilian() ? ImageGetter.INSTANCE.getDrawableOrNull("UnitFlagIcons/UnitFlagCivilianInner") : ImageGetter.INSTANCE.getDrawableOrNull("UnitFlagIcons/UnitFlagInner"))));
    }

    private final Image getBackgroundMaskForUnit() {
        String filename;
        String string = this.unit.isEmbarked() ? "UnitFlagIcons/UnitFlagMaskEmbark" : (this.unit.isFortified() ? "UnitFlagIcons/UnitFlagMaskFortify" : (this.unit.isGuarding() ? "UnitFlagIcons/UnitFlagMaskFortify" : (filename = this.unit.isCivilian() ? "UnitFlagIcons/UnitFlagMaskCivilian" : "UnitFlagIcons/UnitFlagMask")));
        if (ImageGetter.INSTANCE.imageExists(filename)) {
            return ImageGetter.getImage$default(ImageGetter.INSTANCE, filename, null, 2, null);
        }
        return null;
    }

    private final Image getBackgroundSelectionForUnit() {
        return this.unit.isEmbarked() ? ImageGetter.getImage$default(ImageGetter.INSTANCE, "UnitFlagIcons/UnitFlagSelectionEmbark", null, 2, null) : (this.unit.isFortified() ? ImageGetter.getImage$default(ImageGetter.INSTANCE, "UnitFlagIcons/UnitFlagSelectionFortify", null, 2, null) : (this.unit.isGuarding() ? ImageGetter.getImage$default(ImageGetter.INSTANCE, "UnitFlagIcons/UnitFlagSelectionFortify", null, 2, null) : (this.unit.isCivilian() ? ImageGetter.getImage$default(ImageGetter.INSTANCE, "UnitFlagIcons/UnitFlagSelectionCivilian", null, 2, null) : ImageGetter.getImage$default(ImageGetter.INSTANCE, "UnitFlagIcons/UnitFlagSelection", null, 2, null))));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Image getActionImage() {
        Image image2;
        if (this.unit.isSleeping()) {
            image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "UnitActionIcons/Sleep", null, 2, null);
            return image2;
        }
        if (this.unit.getTile().getImprovementInProgress() != null) {
            TileImprovement tileImprovement = this.unit.getTile().getTileImprovementInProgress();
            Intrinsics.checkNotNull(tileImprovement);
            if (MapUnit.canBuildImprovement$default(this.unit, tileImprovement, null, 2, null)) {
                image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "ImprovementIcons/" + this.unit.getTile().getImprovementInProgress(), null, 2, null);
                return image2;
            }
        }
        if (this.unit.isEscorting()) {
            image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "UnitActionIcons/Escort", null, 2, null);
            return image2;
        }
        if (this.unit.isMoving()) {
            image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "UnitActionIcons/MoveTo", null, 2, null);
            return image2;
        }
        if (this.unit.isExploring()) {
            image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "UnitActionIcons/Explore", null, 2, null);
            return image2;
        }
        if (this.unit.isAutomated()) {
            image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "UnitActionIcons/Automate", null, 2, null);
            return image2;
        }
        if (!this.unit.isSetUpForSiege()) return null;
        image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "UnitActionIcons/SetUp", null, 2, null);
        return image2;
    }

    public final void highlightRed() {
        this.flagSelection.setColor(Scene2dExtensionsKt.colorFromRGB(230, 0, 0));
        this.flagBg.setDrawOutline(true);
    }

    public final void selectUnit() {
        float alpha;
        float opacity;
        this.getColor().a = opacity = 1.0f;
        if (MapUnit.isIdle$default(this.unit, false, 1, null)) {
            Group group = this.actionGroup;
            if ((group != null ? group.getColor() : null) != null) {
                (group != null ? group.getColor() : null).a = opacity * 0.5f;
            }
        } else {
            Group group = this.actionGroup;
            if ((group != null ? group.getColor() : null) != null) {
                (group != null ? group.getColor() : null).a = opacity;
            }
        }
        boolean shouldBeFaded = Intrinsics.areEqual(this.unit.getOwner(), GUI.INSTANCE.getSelectedPlayer().getCivName()) && !this.unit.hasMovement() && GUI.INSTANCE.getSettings().getUnitIconOpacity() == 1.0f;
        this.flagIcon.getColor().a = alpha = shouldBeFaded ? opacity * 0.5f : opacity;
        this.flagBg.getColor().a = alpha;
        this.flagSelection.getColor().a = opacity;
        if (GUI.INSTANCE.getSettings().getContinuousRendering()) {
            this.flagSelection.getColor().a = opacity;
            this.flagSelection.addAction(Actions.repeat(-1, Actions.sequence((Action)Actions.alpha(0.0f, 1.0f), (Action)Actions.alpha(opacity, 1.0f))));
        } else {
            this.flagSelection.getColor().a = opacity * 0.8f;
        }
    }
}

