/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.images;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;
import com.unciv.json.UncivJsonKt;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.ruleset.validation.RulesetErrorSeverity;
import com.unciv.utils.Log;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0096\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0014\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012*\u00020\u0004H\u0002J\u0014\u0010\u0014\u001a\u00020\u0002*\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/images/AtlasPreview;", "", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "errorList", "Lcom/unciv/models/ruleset/validation/RulesetErrorList;", "(Lcom/unciv/models/ruleset/Ruleset;Lcom/unciv/models/ruleset/validation/RulesetErrorList;)V", "regionNames", "", "imageExists", "", "name", "iterator", "", "logMissingAtlas", "", "folder", "Lcom/badlogic/gdx/files/FileHandle;", "kotlin.jvm.PlatformType", "relativePath", "Ljava/io/File;", "core"})
@SourceDebugExtension(value={"SMAP\nAtlasPreview.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AtlasPreview.kt\ncom/unciv/ui/images/AtlasPreview\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n26#2:93\n1620#3,3:94\n*S KotlinDebug\n*F\n+ 1 AtlasPreview.kt\ncom/unciv/ui/images/AtlasPreview\n*L\n35#1:93\n51#1:94,3\n*E\n"})
public final class AtlasPreview
implements Iterable<String>,
KMappedMarker {
    @NotNull
    private final Set<String> regionNames;

    /*
     * WARNING - void declaration
     */
    public AtlasPreview(@NotNull Ruleset ruleset2, @NotNull RulesetErrorList errorList) {
        boolean backwardsCompatibility;
        String[] stringArray;
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        Intrinsics.checkNotNullParameter(errorList, "errorList");
        this.regionNames = new LinkedHashSet();
        FileHandle folder = this.folder(ruleset2);
        FileHandle controlFile = folder.child("Atlases.json");
        boolean controlFileExists = controlFile.exists();
        if (controlFileExists) {
            stringArray = UncivJsonKt.json().fromJson(String[].class, controlFile);
        } else {
            boolean $i$f$emptyArray = false;
            stringArray = new String[]{};
        }
        String[] stringArray2 = stringArray;
        Intrinsics.checkNotNull(stringArray2);
        Set<Object> fileNames = ArraysKt.toMutableSet((Object[])stringArray2);
        boolean bl = backwardsCompatibility = ((CharSequence)ruleset2.getName()).length() > 0 && !fileNames.contains("game");
        if (backwardsCompatibility) {
            ((Collection)fileNames).add("game");
        }
        for (String string : fileNames) {
            void $this$mapTo$iv;
            FileHandle file = folder.child(string + ".atlas");
            if (!file.exists()) {
                if (!controlFileExists || Intrinsics.areEqual(string, "game") && backwardsCompatibility) continue;
                this.logMissingAtlas(string, ruleset2, errorList);
                continue;
            }
            TextureAtlas.TextureAtlasData data2 = new TextureAtlas.TextureAtlasData(file, file.parent(), false);
            if (data2.getRegions().isEmpty()) {
                RulesetErrorList.add$default(errorList, file.name() + " contains no textures", null, null, null, 14, null);
            }
            Array<TextureAtlas.TextureAtlasData.Region> array = data2.getRegions();
            Intrinsics.checkNotNullExpressionValue(array, "getRegions(...)");
            Iterable iterable = array;
            Collection destination$iv = this.regionNames;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                TextureAtlas.TextureAtlasData.Region region = (TextureAtlas.TextureAtlasData.Region)item$iv;
                Collection collection = destination$iv;
                boolean bl2 = false;
                collection.add(it.name);
            }
        }
        Log.INSTANCE.debug("Atlas preview for " + ruleset2 + ": " + this.regionNames.size() + " entries.", new Object[0]);
    }

    public final boolean imageExists(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return this.regionNames.contains(name2);
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.regionNames.iterator();
    }

    private final void logMissingAtlas(String name2, Ruleset ruleset2, RulesetErrorList errorList) {
        RulesetErrorList.add$default(errorList, "Atlases.json contains \"" + name2 + "\" but there is no corresponding atlas file.", null, null, null, 14, null);
        FileHandle imagesFolder = this.folder(ruleset2).child(Intrinsics.areEqual(name2, "game") ? "Images" : "Images." + name2);
        if (!imagesFolder.exists() || !imagesFolder.isDirectory()) {
            return;
        }
        File file = imagesFolder.file();
        Intrinsics.checkNotNullExpressionValue(file, "file(...)");
        Iterator<File> iterator2 = FilesKt.walk$default(file, null, 1, null).iterator();
        while (iterator2.hasNext()) {
            File file2 = iterator2.next();
            if (file2.isDirectory() || file2.isHidden()) continue;
            if (!Intrinsics.areEqual(FilesKt.getExtension(file2), "png")) {
                RulesetErrorList.add$default(errorList, imagesFolder.name() + " contains " + this.relativePath(file2, ruleset2) + " which does not have the png extension", RulesetErrorSeverity.WarningOptionsOnly, null, null, 12, null);
                continue;
            }
            try {
                byte[] bytes = FilesKt.readBytes(file2);
                Pixmap pixmap = new Pixmap(bytes, 0, bytes.length);
                pixmap.dispose();
            }
            catch (Throwable ex) {
                Throwable innerException = ex;
                while (innerException.getCause() != null && innerException.getCause() != innerException) {
                    Intrinsics.checkNotNull(innerException.getCause());
                }
                RulesetErrorList.add$default(errorList, "Cannot load " + this.relativePath(file2, ruleset2) + ": " + innerException.getMessage(), null, null, null, 14, null);
            }
        }
    }

    private final FileHandle folder(Ruleset $this$folder) {
        FileHandle fileHandle = $this$folder.getFolderLocation();
        if (fileHandle == null) {
            fileHandle = Gdx.files.internal("");
        }
        return fileHandle;
    }

    private final String relativePath(File $this$relativePath, Ruleset ruleset2) {
        String string = $this$relativePath.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        String string2 = this.folder(ruleset2).file().getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
        return StringsKt.removePrefix(StringsKt.removePrefix(string, (CharSequence)string2), (CharSequence)"/");
    }
}

