/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens;

import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.LanguageTable;
import com.unciv.ui.screens.mainmenuscreen.MainMenuScreen;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\b\u0010\f\u001a\u00020\nH\u0002J\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/LanguagePickerScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "()V", "chosenLanguage", "", "languageTables", "Ljava/util/ArrayList;", "Lcom/unciv/ui/components/widgets/LanguageTable;", "Lkotlin/collections/ArrayList;", "onChoice", "", "choice", "pickLanguage", "update", "core"})
@SourceDebugExtension(value={"SMAP\nLanguagePickerScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguagePickerScreen.kt\ncom/unciv/ui/screens/LanguagePickerScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1855#2,2:69\n*S KotlinDebug\n*F\n+ 1 LanguagePickerScreen.kt\ncom/unciv/ui/screens/LanguagePickerScreen\n*L\n25#1:69,2\n*E\n"})
public final class LanguagePickerScreen
extends PickerScreen {
    @NotNull
    private String chosenLanguage = "English";
    @NotNull
    private final ArrayList<LanguageTable> languageTables;

    public LanguagePickerScreen() {
        super(false, 1, null);
        this.getCloseButton().setVisible(false);
        this.languageTables = LanguageTable.Companion.addLanguageTables(this.getTopTable(), this.getStage().getWidth() - 60.0f);
        for (final LanguageTable languageTable : this.languageTables) {
            Intrinsics.checkNotNull(languageTable);
            ActivationExtensionsKt.onClick(languageTable, new Function0<Unit>(){

                @Override
                public final void invoke() {
                    this.onChoice(languageTable.getLanguage());
                }
            });
        }
        LanguageTable.Companion.addLanguageKeyShortcuts(this.getTopTable(), this.languageTables, new Function0<String>(){

            @Override
            @NotNull
            public final String invoke() {
                return chosenLanguage;
            }
        }, (Function1<? super String, Unit>)new Function1<String, Unit>(){

            @Override
            public final void invoke(@NotNull String language) {
                Object v0;
                block2: {
                    Intrinsics.checkNotNullParameter(language, "language");
                    this.onChoice(language);
                    Iterable $this$firstOrNull$iv = languageTables;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        LanguageTable it = (LanguageTable)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getLanguage(), language)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                LanguageTable languageTable = v0;
                if (languageTable == null) {
                    return;
                }
                LanguageTable selectedTable = languageTable;
                Scene2dExtensionsKt.scrollTo(this.getScrollPane(), selectedTable, true);
            }
        });
        this.getRightSideButton().setText(TranslationsKt.tr$default("Pick language", false, false, 3, null));
        ActivationExtensionsKt.onClick(this.getRightSideButton(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.pickLanguage();
            }
        });
    }

    public final void update() {
        Iterable $this$forEach$iv = this.languageTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LanguageTable it = (LanguageTable)element$iv;
            boolean bl = false;
            it.update(this.chosenLanguage);
        }
    }

    private final void onChoice(String choice2) {
        this.chosenLanguage = choice2;
        Scene2dExtensionsKt.enable(this.getRightSideButton());
        this.update();
    }

    private final void pickLanguage() {
        this.getGame().getSettings().setLanguage(this.chosenLanguage);
        this.getGame().getSettings().updateLocaleFromLanguage();
        this.getGame().getSettings().setFreshlyCreated(false);
        this.getGame().getSettings().save();
        this.getGame().getTranslations().tryReadTranslationForCurrentLanguage();
        this.getGame().replaceCurrentScreen(new MainMenuScreen());
    }
}

