/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.diplomacyscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SplitPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.diplomacy.DiplomacyFunctions;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.trade.Trade;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.audio.MusicMood;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.tilegroups.InfluenceTable;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.RecreateOnResize;
import com.unciv.ui.screens.diplomacyscreen.CityStateDiplomacyTable;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.diplomacyscreen.LeaderIntroTable;
import com.unciv.ui.screens.diplomacyscreen.MajorCivDiplomacyTable;
import com.unciv.ui.screens.diplomacyscreen.TradeTable;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 D2\u00020\u00012\u00020\u0002:\u0003DEFB/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u001d\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0015\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020 H\u0000\u00a2\u0006\u0002\b*J\r\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0012H\u0002J\r\u00101\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b2J\b\u00103\u001a\u00020/H\u0002J\b\u00104\u001a\u00020\u0001H\u0016J\u0018\u00105\u001a\u00020/2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000207H\u0016J%\u00109\u001a\u00020/2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020$H\u0000\u00a2\u0006\u0002\b<J\u0015\u0010=\u001a\u00020>2\u0006\u0010!\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b?J\u0017\u0010@\u001a\u00020/2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\bAJ\u0015\u0010B\u001a\u00020/2\u0006\u0010!\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bCR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006G"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "Lcom/unciv/ui/screens/basescreen/RecreateOnResize;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "selectCiv", "selectTrade", "Lcom/unciv/logic/trade/Trade;", "showTrade", "", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/trade/Trade;Z)V", "closeButton", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "highlightBackground", "Lcom/badlogic/gdx/scenes/scene2d/utils/NinePatchDrawable;", "highlightColor", "Lcom/badlogic/gdx/graphics/Color;", "highlightedCivButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "leftSideScroll", "Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen$ScrollPaneWithMinSize;", "leftSideTable", "rightSideTable", "getRightSideTable$core", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "getViewingCiv$core", "()Lcom/unciv/logic/civilization/Civilization;", "getCivilopediaRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "getDeclareWarButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "diplomacyManager", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager;", "otherCiv", "getDeclareWarButton$core", "getDeclareWarButtonText", "", "getGoToOnMapButton", "civilization", "getGoToOnMapButton$core", "getRelationshipTable", "otherCivDiplomacyManager", "getRelationshipTable$core", "getTradeColumnsWidth", "", "getTradeColumnsWidth$core", "highlightCiv", "", "civButton", "isNotPlayersTurn", "isNotPlayersTurn$core", "positionCloseButton", "recreate", "resize", "width", "", "height", "setRightSideFlavorText", "flavorText", "response", "setRightSideFlavorText$core", "setTrade", "Lcom/unciv/ui/screens/diplomacyscreen/TradeTable;", "setTrade$core", "updateLeftSideTable", "updateLeftSideTable$core", "updateRightSide", "updateRightSide$core", "Companion", "ScrollPaneWithMinSize", "SplitPaneCenteringLeftSide", "core"})
@SourceDebugExtension(value={"SMAP\nDiplomacyScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiplomacyScreen.kt\ncom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,353:1\n766#2:354\n857#2,2:355\n1549#2:357\n1620#2,3:358\n*S KotlinDebug\n*F\n+ 1 DiplomacyScreen.kt\ncom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen\n*L\n280#1:354\n280#1:355,2\n284#1:357\n284#1:358,3\n*E\n"})
public final class DiplomacyScreen
extends BaseScreen
implements RecreateOnResize {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Civilization viewingCiv;
    @Nullable
    private final Civilization selectCiv;
    @Nullable
    private final Trade selectTrade;
    private final boolean showTrade;
    @NotNull
    private final Color highlightColor;
    @NotNull
    private final Table leftSideTable;
    @NotNull
    private final ScrollPaneWithMinSize leftSideScroll;
    @Nullable
    private Table highlightedCivButton;
    @NotNull
    private final NinePatchDrawable highlightBackground;
    @NotNull
    private final Table rightSideTable;
    @NotNull
    private final Group closeButton;
    private static final float nationIconSize = 100.0f;
    private static final float nationIconPad = 10.0f;
    private static final float closeButtonSize = 50.0f;
    private static final float closeButtonPad = 10.0f;

    /*
     * WARNING - void declaration
     */
    public DiplomacyScreen(@NotNull Civilization viewingCiv, @Nullable Civilization selectCiv, @Nullable Trade selectTrade, boolean showTrade) {
        void $this$rightSideTable_u24lambda_u241;
        Table $this$leftSideTable_u24lambda_u240;
        Table table2;
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        this.viewingCiv = viewingCiv;
        this.selectCiv = selectCiv;
        this.selectTrade = selectTrade;
        this.showTrade = showTrade;
        Color color = BaseScreen.Companion.getClearColor().cpy().lerp(BaseScreen.Companion.getSkin().getColor("color"), 0.333f);
        Intrinsics.checkNotNullExpressionValue(color, "lerp(...)");
        this.highlightColor = color;
        Table table3 = table2 = new Table();
        DiplomacyScreen diplomacyScreen = this;
        boolean bl = false;
        $this$leftSideTable_u24lambda_u240.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "DiplomacyScreen/LeftSide", null, BaseScreen.Companion.getClearColor(), 2, null));
        diplomacyScreen.leftSideTable = table2;
        this.leftSideScroll = new ScrollPaneWithMinSize();
        this.highlightBackground = SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "DiplomacyScreen/SelectedCiv", null, this.highlightColor, 2, null);
        $this$leftSideTable_u24lambda_u240 = table2 = new Table();
        diplomacyScreen = this;
        boolean bl2 = false;
        $this$rightSideTable_u24lambda_u241.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "DiplomacyScreen/RightSide", null, this.highlightColor, 2, null));
        diplomacyScreen.rightSideTable = table2;
        this.closeButton = Scene2dExtensionsKt.getCloseButton$default(50.0f, 0.0f, null, null, new Function0<Unit>(this){
            final /* synthetic */ DiplomacyScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getGame().popScreen();
            }
        }, 14, null);
        SplitPaneCenteringLeftSide splitPane = new SplitPaneCenteringLeftSide();
        splitPane.setSplitAmount(RangesKt.coerceAtLeast(0.2f, this.leftSideScroll.getPrefWidth() / this.getStage().getWidth()));
        this.updateLeftSideTable$core(this.selectCiv);
        splitPane.setFillParent(true);
        this.getStage().addActor(splitPane);
        this.positionCloseButton();
        this.getStage().addActor(this.closeButton);
        if (this.selectCiv != null) {
            if (this.showTrade) {
                TradeTable tradeTable = this.setTrade$core(this.selectCiv);
                if (this.selectTrade != null) {
                    tradeTable.getTradeLogic$core().getCurrentTrade().set(this.selectTrade);
                }
                tradeTable.getOfferColumnsTable$core().update();
            } else {
                this.updateRightSide$core(this.selectCiv);
            }
        }
    }

    public /* synthetic */ DiplomacyScreen(Civilization civilization, Civilization civilization2, Trade trade, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            civilization2 = null;
        }
        if ((n & 4) != 0) {
            trade = null;
        }
        if ((n & 8) != 0) {
            bl = trade != null;
        }
        this(civilization, civilization2, trade, bl);
    }

    @NotNull
    public final Civilization getViewingCiv$core() {
        return this.viewingCiv;
    }

    @NotNull
    public final Table getRightSideTable$core() {
        return this.rightSideTable;
    }

    public final boolean isNotPlayersTurn$core() {
        return !GUI.INSTANCE.isAllowedChangeState();
    }

    @Override
    @NotNull
    public Ruleset getCivilopediaRuleset() {
        return this.viewingCiv.getGameInfo().getRuleset();
    }

    private final void positionCloseButton() {
        this.closeButton.setPosition(this.getStage().getWidth() - 10.0f, this.getStage().getHeight() - 10.0f, 18);
    }

    public final void updateLeftSideTable$core(@Nullable Civilization selectCiv) {
        this.leftSideTable.clear();
        this.leftSideTable.add().padBottom(10.0f).row();
        float selectCivY = 0.0f;
        Iterator iterator2 = DiplomacyFunctions.getKnownCivsSorted$default(this.viewingCiv.getDiplomacyFunctions(), false, false, 3, null).iterator();
        while (iterator2.hasNext()) {
            Table table2;
            Actor actor;
            Object object;
            Civilization civ = (Civilization)iterator2.next();
            if (Intrinsics.areEqual(civ, selectCiv)) {
                selectCivY = this.leftSideTable.getPrefHeight();
            }
            Portrait civIndicator = ImageGetter.INSTANCE.getNationPortrait(civ.getNation(), 100.0f);
            DiplomacyManager diplomacyManager = civ.getDiplomacyManager(this.viewingCiv);
            Intrinsics.checkNotNull(diplomacyManager);
            RelationshipLevel relationLevel = diplomacyManager.relationshipLevel();
            if (civ.isCityState() && relationLevel == RelationshipLevel.Ally) {
                Object $this$updateLeftSideTable_u24lambda_u242 = object = Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Star", null, 2, null), 30.0f, false, relationLevel.getColor(), null, 10, null);
                boolean bl = false;
                ((IconCircleGroup)$this$updateLeftSideTable_u24lambda_u242).getActor().setColor(Color.GOLD);
                actor = (Actor)object;
            } else {
                object = this.viewingCiv.isAtWarWith(civ) ? Color.RED : relationLevel.getColor();
                Intrinsics.checkNotNull(object);
                actor = ImageGetter.INSTANCE.getCircle((Color)object, Float.valueOf(30.0f));
            }
            Actor relationshipIcon = actor;
            civIndicator.addActor(relationshipIcon);
            if (civ.isCityState()) {
                IconCircleGroup iconCircleGroup;
                Nation nation2 = civ.getGameInfo().getRuleset().getNations().get(civ.getCivName());
                Intrinsics.checkNotNull(nation2);
                Color innerColor = nation2.getInnerColor();
                IconCircleGroup $this$updateLeftSideTable_u24lambda_u243 = iconCircleGroup = Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.getImage$default(ImageGetter.INSTANCE, "CityStateIcons/" + civ.getCityStateType().getName(), null, 2, null), 35.0f, false, innerColor, null, 10, null);
                boolean bl = false;
                $this$updateLeftSideTable_u24lambda_u243.getActor().setColor(ImageGetter.INSTANCE.getCHARCOAL());
                IconCircleGroup typeIcon = iconCircleGroup;
                civIndicator.addActor(typeIcon);
                typeIcon.setY((float)Math.floor(civIndicator.getHeight() - typeIcon.getHeight()));
                typeIcon.setX((float)Math.floor(civIndicator.getWidth() - typeIcon.getWidth()));
            }
            if (civ.isCityState() && civ.getQuestManager().haveQuestsFor(this.viewingCiv)) {
                Actor actor2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Quest", null, 2, null);
                Color color = Color.GOLDENROD;
                Intrinsics.checkNotNullExpressionValue(color, "GOLDENROD");
                IconCircleGroup questIcon = Scene2dExtensionsKt.surroundWithCircle$default(actor2, 30.0f, false, color, null, 10, null);
                civIndicator.addActor(questIcon);
                questIcon.setX((float)Math.floor(civIndicator.getWidth() - questIcon.getWidth()));
            }
            Label civNameLabel = Scene2dExtensionsKt.toLabel$default(civ.getCivName(), null, 0, 0, true, 7, null);
            Table $this$updateLeftSideTable_u24lambda_u244 = table2 = new Table();
            boolean bl = false;
            $this$updateLeftSideTable_u24lambda_u244.defaults().pad(10.0f);
            $this$updateLeftSideTable_u24lambda_u244.add((Actor)civIndicator).row();
            $this$updateLeftSideTable_u24lambda_u244.add((Actor)civNameLabel).row();
            ActivationExtensionsKt.onClick($this$updateLeftSideTable_u24lambda_u244, new Function0<Unit>(this, civ, $this$updateLeftSideTable_u24lambda_u244){
                final /* synthetic */ DiplomacyScreen this$0;
                final /* synthetic */ Civilization $civ;
                final /* synthetic */ Table $this_apply;
                {
                    this.this$0 = $receiver;
                    this.$civ = $civ;
                    this.$this_apply = $receiver2;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.updateRightSide$core(this.$civ);
                    DiplomacyScreen.access$highlightCiv(this.this$0, this.$this_apply);
                }
            });
            if (Intrinsics.areEqual(civ, selectCiv)) {
                this.highlightCiv($this$updateLeftSideTable_u24lambda_u244);
            }
            Table civButton2 = table2;
            this.leftSideTable.add((Actor)civButton2).padBottom(10.0f).growX().row();
        }
        if (!(selectCivY == 0.0f)) {
            this.leftSideScroll.layout();
            this.leftSideScroll.setScrollY(selectCivY + (120.0f - this.getStage().getHeight()) / (float)2);
            this.leftSideScroll.updateVisualScroll();
        }
    }

    private final void highlightCiv(Table civButton2) {
        Table table2 = this.highlightedCivButton;
        if (table2 != null) {
            table2.setBackground((Drawable)null);
        }
        civButton2.setBackground(this.highlightBackground);
        this.highlightedCivButton = civButton2;
    }

    public final void updateRightSide$core(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        this.rightSideTable.clear();
        UncivGame.Companion.getCurrent().getMusicController().chooseTrack(otherCiv.getCivName(), MusicMood.INSTANCE.peaceOrWar(this.viewingCiv.isAtWarWith(otherCiv)), MusicTrackChooserFlags.Companion.getSetSelectNation());
        this.rightSideTable.add((Actor)new AutoScrollPane((Actor)(otherCiv.isCityState() ? new CityStateDiplomacyTable(this).getCityStateDiplomacyTable(otherCiv) : new MajorCivDiplomacyTable(this).getMajorCivDiplomacyTable(otherCiv)), null, 2, null)).height(this.getStage().getHeight());
    }

    @NotNull
    public final TradeTable setTrade$core(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        this.rightSideTable.clear();
        TradeTable tradeTable = new TradeTable(this.viewingCiv, otherCiv, this);
        this.rightSideTable.add((Actor)tradeTable);
        return tradeTable;
    }

    @NotNull
    public final Table getRelationshipTable$core(@NotNull DiplomacyManager otherCivDiplomacyManager) {
        Color color;
        Intrinsics.checkNotNullParameter(otherCivDiplomacyManager, "otherCivDiplomacyManager");
        Table relationshipTable = new Table();
        int opinionOfUs = otherCivDiplomacyManager.getCivInfo().isCityState() ? (int)otherCivDiplomacyManager.getInfluence() : (int)otherCivDiplomacyManager.opinionOfOtherCiv();
        relationshipTable.add((Actor)Scene2dExtensionsKt.toLabel("{Our relationship}: "));
        RelationshipLevel relationshipLevel = otherCivDiplomacyManager.relationshipLevel();
        String relationshipText = TranslationsKt.tr$default(relationshipLevel.name(), false, false, 3, null) + " (" + opinionOfUs + ')';
        switch (WhenMappings.$EnumSwitchMapping$0[relationshipLevel.ordinal()]) {
            case 1: {
                color = Color.WHITE;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                color = Color.GREEN;
                break;
            }
            case 5: {
                color = Color.YELLOW;
                break;
            }
            default: {
                color = Color.RED;
            }
        }
        Color relationshipColor = color;
        Intrinsics.checkNotNull(relationshipColor);
        relationshipTable.add((Actor)Scene2dExtensionsKt.toLabel$default(relationshipText, relationshipColor, 0, 0, false, 14, null)).row();
        if (otherCivDiplomacyManager.getCivInfo().isCityState()) {
            relationshipTable.add((Actor)new InfluenceTable(otherCivDiplomacyManager.getInfluence(), relationshipLevel, 200.0f, 10.0f)).colspan(2).pad(5.0f);
        }
        return relationshipTable;
    }

    @NotNull
    public final TextButton getDeclareWarButton$core(@NotNull DiplomacyManager diplomacyManager, @NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(diplomacyManager, "diplomacyManager");
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        TextButton declareWarButton = Scene2dExtensionsKt.toTextButton$default("Declare war", BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class), false, 2, null);
        int turnsToPeaceTreaty = diplomacyManager.turnsToPeaceTreaty();
        if (turnsToPeaceTreaty > 0) {
            Scene2dExtensionsKt.disable(declareWarButton);
            declareWarButton.setText(declareWarButton.getText() + " (" + TranslationsKt.tr(turnsToPeaceTreaty) + "\u23f3)");
        }
        ActivationExtensionsKt.onClick(declareWarButton, new Function0<Unit>(this, otherCiv, diplomacyManager){
            final /* synthetic */ DiplomacyScreen this$0;
            final /* synthetic */ Civilization $otherCiv;
            final /* synthetic */ DiplomacyManager $diplomacyManager;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                this.$diplomacyManager = $diplomacyManager;
                super(0);
            }

            public final void invoke() {
                Popup.open$default(new ConfirmPopup(this.this$0, DiplomacyScreen.access$getDeclareWarButtonText(this.this$0, this.$otherCiv), "Declare war", false, null, (Function0)new Function0<Unit>(this.$diplomacyManager, this.this$0, this.$otherCiv){
                    final /* synthetic */ DiplomacyManager $diplomacyManager;
                    final /* synthetic */ DiplomacyScreen this$0;
                    final /* synthetic */ Civilization $otherCiv;
                    {
                        this.$diplomacyManager = $diplomacyManager;
                        this.this$0 = $receiver;
                        this.$otherCiv = $otherCiv;
                        super(0);
                    }

                    public final void invoke() {
                        DiplomacyManager.declareWar$default(this.$diplomacyManager, null, 1, null);
                        this.this$0.setRightSideFlavorText$core(this.$otherCiv, this.$otherCiv.getNation().getAttacked(), "Very well.");
                        this.this$0.updateLeftSideTable$core(this.$otherCiv);
                        MusicController music = UncivGame.Companion.getCurrent().getMusicController();
                        music.chooseTrack(this.$otherCiv.getCivName(), "War", MusicTrackChooserFlags.Companion.getSetSpecific());
                        music.playVoice(this.$otherCiv.getCivName() + ".attacked");
                    }
                }, 24, null), false, 1, null);
            }
        });
        if (this.isNotPlayersTurn$core()) {
            Scene2dExtensionsKt.disable(declareWarButton);
        }
        return declareWarButton;
    }

    /*
     * WARNING - void declaration
     */
    private final String getDeclareWarButtonText(Civilization otherCiv) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DiplomacyManager otherCivDiploManager;
        void $this$filterTo$iv$iv;
        ArrayList messageLines = new ArrayList();
        ((Collection)messageLines).add("Declare war on [" + otherCiv.getCivName() + "]?");
        Collection<DiplomacyManager> collection = otherCiv.getDiplomacy().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            otherCivDiploManager = (DiplomacyManager)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !Intrinsics.areEqual(otherCivDiploManager.otherCiv(), this.viewingCiv) && otherCivDiploManager.getDiplomaticStatus() == DiplomaticStatus.DefensivePact && !otherCivDiploManager.otherCiv().isAtWarWith(this.viewingCiv);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            otherCivDiploManager = (DiplomacyManager)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.otherCiv());
        }
        List otherCivDefensivePactList = (List)destination$iv$iv;
        for (Civilization civ : otherCivDefensivePactList) {
            ((Collection)messageLines).add(this.viewingCiv.knows(civ) ? '[' + civ.getCivName() + "] will also join them in the war" : "An unknown civilization will also join them in the war");
        }
        for (DiplomacyManager civDiploManager : this.viewingCiv.getDiplomacy().values()) {
            if (Intrinsics.areEqual(civDiploManager.otherCiv(), otherCiv) || civDiploManager.getDiplomaticStatus() != DiplomaticStatus.DefensivePact || otherCivDefensivePactList.contains(civDiploManager.otherCiv())) continue;
            ((Collection)messageLines).add("This will cancel your defensive pact with [" + civDiploManager.getOtherCivName() + ']');
        }
        return CollectionsKt.joinToString$default(messageLines, "\n", null, null, 0, null, getDeclareWarButtonText.1.INSTANCE, 30, null);
    }

    public final void setRightSideFlavorText$core(@NotNull Civilization otherCiv, @NotNull String flavorText, @NotNull String response2) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        Intrinsics.checkNotNullParameter(flavorText, "flavorText");
        Intrinsics.checkNotNullParameter(response2, "response");
        Table diplomacyTable = new Table();
        diplomacyTable.defaults().pad(10.0f);
        diplomacyTable.add((Actor)new LeaderIntroTable(otherCiv, null, 2, null));
        Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
        diplomacyTable.add((Actor)Scene2dExtensionsKt.toLabel(flavorText)).row();
        TextButton responseButton = Scene2dExtensionsKt.toTextButton$default(response2, null, false, 3, null);
        ActivationExtensionsKt.onActivation(responseButton, new Function0<Unit>(this, otherCiv){
            final /* synthetic */ DiplomacyScreen this$0;
            final /* synthetic */ Civilization $otherCiv;
            {
                this.this$0 = $receiver;
                this.$otherCiv = $otherCiv;
                super(0);
            }

            public final void invoke() {
                this.this$0.updateRightSide$core(this.$otherCiv);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(responseButton).add(KeyCharAndCode.Companion.getSPACE());
        diplomacyTable.add((Actor)responseButton);
        this.rightSideTable.clear();
        this.rightSideTable.add((Actor)diplomacyTable);
    }

    @NotNull
    public final TextButton getGoToOnMapButton$core(@NotNull Civilization civilization) {
        Intrinsics.checkNotNullParameter(civilization, "civilization");
        TextButton goToOnMapButton = Scene2dExtensionsKt.toTextButton$default("Go to on map", null, false, 3, null);
        ActivationExtensionsKt.onClick(goToOnMapButton, new Function0<Unit>(civilization){
            final /* synthetic */ Civilization $civilization;
            {
                this.$civilization = $civilization;
                super(0);
            }

            public final void invoke() {
                WorldScreen worldScreen = UncivGame.Companion.getCurrent().resetToWorldScreen();
                WorldMapHolder worldMapHolder = worldScreen.getMapHolder();
                City city2 = Civilization.getCapital$default(this.$civilization, false, 1, null);
                Intrinsics.checkNotNull(city2);
                WorldMapHolder.setCenterPosition$default(worldMapHolder, city2.getLocation(), false, false, null, 10, null);
            }
        });
        return goToOnMapButton;
    }

    public final float getTradeColumnsWidth$core() {
        return (this.getStage().getWidth() * 0.8f - 3.0f) / (float)2;
    }

    @Override
    public void resize(int width, int height) {
        super.resize(width, height);
        this.positionCloseButton();
    }

    @Override
    @NotNull
    public BaseScreen recreate() {
        return new DiplomacyScreen(this.viewingCiv, this.selectCiv, this.selectTrade, this.showTrade);
    }

    public static final /* synthetic */ String access$getDeclareWarButtonText(DiplomacyScreen $this, Civilization otherCiv) {
        return $this.getDeclareWarButtonText(otherCiv);
    }

    public static final /* synthetic */ void access$highlightCiv(DiplomacyScreen $this, Table civButton2) {
        $this.highlightCiv(civButton2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen$Companion;", "", "()V", "closeButtonPad", "", "closeButtonSize", "nationIconPad", "nationIconSize", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen$ScrollPaneWithMinSize;", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "(Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;)V", "getMinWidth", "", "getPrefWidth", "core"})
    private final class ScrollPaneWithMinSize
    extends AutoScrollPane {
        public ScrollPaneWithMinSize() {
            super((Actor)DiplomacyScreen.this.leftSideTable, null, 2, null);
        }

        @Override
        public float getMinWidth() {
            return 110.0f;
        }

        @Override
        public float getPrefWidth() {
            return this.getMinWidth() + 20.0f;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen$SplitPaneCenteringLeftSide;", "Lcom/badlogic/gdx/scenes/scene2d/ui/SplitPane;", "(Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;)V", "lastSplitAmount", "", "getLastSplitAmount", "()F", "setLastSplitAmount", "(F)V", "validate", "", "core"})
    private final class SplitPaneCenteringLeftSide
    extends SplitPane {
        private float lastSplitAmount;

        public SplitPaneCenteringLeftSide() {
            super((Actor)DiplomacyScreen.this.leftSideScroll, (Actor)DiplomacyScreen.this.getRightSideTable$core(), false, BaseScreen.Companion.getSkin());
            this.lastSplitAmount = this.getSplitAmount();
        }

        public final float getLastSplitAmount() {
            return this.lastSplitAmount;
        }

        public final void setLastSplitAmount(float f) {
            this.lastSplitAmount = f;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.getSplitAmount() == this.lastSplitAmount) {
                return;
            }
            this.lastSplitAmount = this.getSplitAmount();
            DiplomacyScreen.this.leftSideScroll.setScrollPercentX(0.5f);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RelationshipLevel.values().length];
            try {
                nArray[RelationshipLevel.Neutral.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Favorable.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Friend.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Ally.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RelationshipLevel.Afraid.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

