/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.diplomacyscreen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.trade.Trade;
import com.unciv.logic.trade.TradeLogic;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.logic.trade.TradeOffersList;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.AskNumberPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.diplomacyscreen.OffersListScroll;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J0\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J \u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0002J\u0006\u0010\"\u001a\u00020\u000bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/OfferColumnsTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "tradeLogic", "Lcom/unciv/logic/trade/TradeLogic;", "screen", "Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;", "ourCiv", "Lcom/unciv/logic/civilization/Civilization;", "theirCiv", "onChange", "Lkotlin/Function0;", "", "(Lcom/unciv/logic/trade/TradeLogic;Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/civilization/Civilization;Lkotlin/jvm/functions/Function0;)V", "ourAvailableOffersTable", "Lcom/unciv/ui/screens/diplomacyscreen/OffersListScroll;", "ourOffersTable", "theirAvailableOffersTable", "theirOffersTable", "addOffer", "offer", "Lcom/unciv/logic/trade/TradeOffer;", "offerList", "Lcom/unciv/logic/trade/TradeOffersList;", "correspondingOfferList", "offerClickImplementation", "invert", "", "list", "counterList", "civ", "openGoldSelectionPopup", "ourOffers", "maxGold", "", "update", "core"})
@SourceDebugExtension(value={"SMAP\nOfferColumnsTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OfferColumnsTable.kt\ncom/unciv/ui/screens/diplomacyscreen/OfferColumnsTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n288#2,2:140\n*S KotlinDebug\n*F\n+ 1 OfferColumnsTable.kt\ncom/unciv/ui/screens/diplomacyscreen/OfferColumnsTable\n*L\n116#1:140,2\n*E\n"})
public final class OfferColumnsTable
extends Table {
    @NotNull
    private final TradeLogic tradeLogic;
    @NotNull
    private final DiplomacyScreen screen;
    @NotNull
    private final Civilization ourCiv;
    @NotNull
    private final Civilization theirCiv;
    @NotNull
    private final Function0<Unit> onChange;
    @NotNull
    private final OffersListScroll ourAvailableOffersTable;
    @NotNull
    private final OffersListScroll ourOffersTable;
    @NotNull
    private final OffersListScroll theirOffersTable;
    @NotNull
    private final OffersListScroll theirAvailableOffersTable;

    public OfferColumnsTable(@NotNull TradeLogic tradeLogic, @NotNull DiplomacyScreen screen, @NotNull Civilization ourCiv, @NotNull Civilization theirCiv, @NotNull Function0<Unit> onChange) {
        Intrinsics.checkNotNullParameter(tradeLogic, "tradeLogic");
        Intrinsics.checkNotNullParameter(screen, "screen");
        Intrinsics.checkNotNullParameter(ourCiv, "ourCiv");
        Intrinsics.checkNotNullParameter(theirCiv, "theirCiv");
        Intrinsics.checkNotNullParameter(onChange, "onChange");
        super(BaseScreen.Companion.getSkin());
        this.tradeLogic = tradeLogic;
        this.screen = screen;
        this.ourCiv = ourCiv;
        this.theirCiv = theirCiv;
        this.onChange = onChange;
        this.ourAvailableOffersTable = new OffersListScroll("OurAvail", (Function1<? super TradeOffer, Unit>)new Function1<TradeOffer, Unit>(this){
            final /* synthetic */ OfferColumnsTable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull TradeOffer it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Trade trade = OfferColumnsTable.access$getTradeLogic$p(this.this$0).getCurrentTrade();
                OfferColumnsTable offerColumnsTable2 = this.this$0;
                Trade $this$invoke_u24lambda_u240 = trade;
                boolean bl = false;
                OfferColumnsTable.access$offerClickImplementation(offerColumnsTable2, it, false, $this$invoke_u24lambda_u240.getOurOffers(), $this$invoke_u24lambda_u240.getTheirOffers(), OfferColumnsTable.access$getTradeLogic$p(offerColumnsTable2).getOurCivilization());
            }
        });
        this.ourOffersTable = new OffersListScroll("OurTrade", (Function1<? super TradeOffer, Unit>)new Function1<TradeOffer, Unit>(this){
            final /* synthetic */ OfferColumnsTable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull TradeOffer it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Trade trade = OfferColumnsTable.access$getTradeLogic$p(this.this$0).getCurrentTrade();
                OfferColumnsTable offerColumnsTable2 = this.this$0;
                Trade $this$invoke_u24lambda_u240 = trade;
                boolean bl = false;
                OfferColumnsTable.access$offerClickImplementation(offerColumnsTable2, it, true, $this$invoke_u24lambda_u240.getOurOffers(), $this$invoke_u24lambda_u240.getTheirOffers(), OfferColumnsTable.access$getTradeLogic$p(offerColumnsTable2).getOurCivilization());
            }
        });
        this.theirOffersTable = new OffersListScroll("TheirTrade", (Function1<? super TradeOffer, Unit>)new Function1<TradeOffer, Unit>(this){
            final /* synthetic */ OfferColumnsTable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull TradeOffer it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Trade trade = OfferColumnsTable.access$getTradeLogic$p(this.this$0).getCurrentTrade();
                OfferColumnsTable offerColumnsTable2 = this.this$0;
                Trade $this$invoke_u24lambda_u240 = trade;
                boolean bl = false;
                OfferColumnsTable.access$offerClickImplementation(offerColumnsTable2, it, true, $this$invoke_u24lambda_u240.getTheirOffers(), $this$invoke_u24lambda_u240.getOurOffers(), OfferColumnsTable.access$getTradeLogic$p(offerColumnsTable2).getOtherCivilization());
            }
        });
        this.theirAvailableOffersTable = new OffersListScroll("TheirAvail", (Function1<? super TradeOffer, Unit>)new Function1<TradeOffer, Unit>(this){
            final /* synthetic */ OfferColumnsTable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull TradeOffer it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Trade trade = OfferColumnsTable.access$getTradeLogic$p(this.this$0).getCurrentTrade();
                OfferColumnsTable offerColumnsTable2 = this.this$0;
                Trade $this$invoke_u24lambda_u240 = trade;
                boolean bl = false;
                OfferColumnsTable.access$offerClickImplementation(offerColumnsTable2, it, false, $this$invoke_u24lambda_u240.getTheirOffers(), $this$invoke_u24lambda_u240.getOurOffers(), OfferColumnsTable.access$getTradeLogic$p(offerColumnsTable2).getOtherCivilization());
            }
        });
        this.defaults().pad(5.0f);
        boolean isPortraitMode = this.screen.isNarrowerThan4to3();
        float columnWidth = this.screen.getTradeColumnsWidth$core() - 20.0f;
        if (!isPortraitMode) {
            this.add(TranslationsKt.tr$default("Our items", false, false, 3, null));
            this.add(TranslationsKt.tr$default('[' + this.tradeLogic.getOtherCivilization().getCivName() + "]'s items", false, false, 3, null)).row();
            this.add((Actor)this.ourAvailableOffersTable).prefSize(columnWidth, this.screen.getStage().getHeight() / (float)2);
            this.add((Actor)this.theirAvailableOffersTable).prefSize(columnWidth, this.screen.getStage().getHeight() / (float)2).row();
            Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null).height(2.0f);
            this.add(TranslationsKt.tr$default("Our trade offer", false, false, 3, null));
            this.add(TranslationsKt.tr$default('[' + this.tradeLogic.getOtherCivilization().getCivName() + "]'s trade offer", false, false, 3, null)).row();
            this.add((Actor)this.ourOffersTable).size(columnWidth, this.screen.getStage().getHeight() / (float)3);
            this.add((Actor)this.theirOffersTable).size(columnWidth, this.screen.getStage().getHeight() / (float)3);
        } else {
            this.add(TranslationsKt.tr$default("Our items", false, false, 3, null)).colspan(2).row();
            this.add((Actor)this.ourAvailableOffersTable).height(this.screen.getStage().getHeight() / 4.0f).colspan(2).row();
            Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null).height(2.0f);
            this.add(TranslationsKt.tr$default('[' + this.tradeLogic.getOtherCivilization().getCivName() + "]'s items", false, false, 3, null)).colspan(2).row();
            this.add((Actor)this.theirAvailableOffersTable).height(this.screen.getStage().getHeight() / 4.0f).colspan(2).row();
            Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null).height(5.0f);
            this.add(TranslationsKt.tr$default("Our trade offer", false, false, 3, null));
            this.add(TranslationsKt.tr$default('[' + this.tradeLogic.getOtherCivilization().getCivName() + "]'s trade offer", false, false, 3, null)).row();
            this.add((Actor)this.ourOffersTable).height(this.screen.getStage().getHeight() / 4.0f).width(columnWidth);
            this.add((Actor)this.theirOffersTable).height(this.screen.getStage().getHeight() / 4.0f).width(columnWidth);
        }
        this.pack();
        this.update();
    }

    public final void addOffer(@NotNull TradeOffer offer, @NotNull TradeOffersList offerList, @NotNull TradeOffersList correspondingOfferList) {
        Intrinsics.checkNotNullParameter(offer, "offer");
        Intrinsics.checkNotNullParameter(offerList, "offerList");
        Intrinsics.checkNotNullParameter(correspondingOfferList, "correspondingOfferList");
        offerList.add(TradeOffer.copy$default(offer, null, null, 0, 0, 15, null));
        if (offer.getType() == TradeOfferType.Treaty) {
            correspondingOfferList.add(TradeOffer.copy$default(offer, null, null, 0, 0, 15, null));
        }
        this.onChange.invoke();
    }

    private final void offerClickImplementation(TradeOffer offer, boolean invert, TradeOffersList list2, TradeOffersList counterList, Civilization civ) {
        switch (WhenMappings.$EnumSwitchMapping$0[offer.getType().ordinal()]) {
            case 1: {
                this.openGoldSelectionPopup(offer, list2, civ.getGold());
                break;
            }
            case 2: {
                this.openGoldSelectionPopup(offer, list2, (int)civ.getStats().getStatsForNextTurn().getGold());
                break;
            }
            default: {
                this.addOffer(invert ? TradeOffer.copy$default(offer, null, null, -offer.getAmount(), 0, 11, null) : offer, list2, counterList);
            }
        }
    }

    public final void update() {
        TradeOffersList ourFilteredOffers = this.tradeLogic.getOurAvailableOffers().without(this.tradeLogic.getCurrentTrade().getOurOffers());
        TradeOffersList theirFilteredOffers = this.tradeLogic.getTheirAvailableOffers().without(this.tradeLogic.getCurrentTrade().getTheirOffers());
        ResourceSupplyList ourUntradables = this.tradeLogic.getOurCivilization().getPerTurnResourcesWithOriginsForTrade().removeAll("Tradable");
        ResourceSupplyList theirUntradables = this.tradeLogic.getOtherCivilization().getPerTurnResourcesWithOriginsForTrade().removeAll("Tradable");
        this.ourAvailableOffersTable.update(ourFilteredOffers, this.tradeLogic.getTheirAvailableOffers(), ourUntradables, this.ourCiv, this.theirCiv);
        OffersListScroll.update$default(this.ourOffersTable, this.tradeLogic.getCurrentTrade().getOurOffers(), this.tradeLogic.getTheirAvailableOffers(), null, this.ourCiv, this.theirCiv, 4, null);
        OffersListScroll.update$default(this.theirOffersTable, this.tradeLogic.getCurrentTrade().getTheirOffers(), this.tradeLogic.getOurAvailableOffers(), null, this.ourCiv, this.theirCiv, 4, null);
        this.theirAvailableOffersTable.update(theirFilteredOffers, this.tradeLogic.getOurAvailableOffers(), theirUntradables, this.ourCiv, this.theirCiv);
    }

    private final void openGoldSelectionPopup(TradeOffer offer, TradeOffersList ourOffers, int maxGold) {
        List<Integer> list2;
        Integer[] integerArray;
        Object v0;
        block4: {
            Iterable $this$firstOrNull$iv = ourOffers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TradeOffer it = (TradeOffer)element$iv;
                boolean bl = false;
                if (!(it.getType() == offer.getType())) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        TradeOffer existingGoldOffer = v0;
        if (existingGoldOffer != null) {
            offer.setAmount(existingGoldOffer.getAmount());
        }
        BaseScreen baseScreen = this.screen;
        IconCircleGroup iconCircleGroup = Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.INSTANCE.getStatIcon("Gold"), 80.0f, false, null, null, 14, null);
        String string = TranslationsKt.tr(offer.getAmount());
        if (offer.getType() == TradeOfferType.Gold) {
            integerArray = new Integer[]{50, 500};
            list2 = CollectionsKt.listOf(integerArray);
        } else {
            integerArray = new Integer[]{5, 15};
            list2 = CollectionsKt.listOf(integerArray);
        }
        Popup.open$default(new AskNumberPopup(baseScreen, "Enter the amount of gold", iconCircleGroup, string, list2, new IntRange(0, maxGold), null, null, new Function1<Integer, Unit>(offer, existingGoldOffer, ourOffers, this){
            final /* synthetic */ TradeOffer $offer;
            final /* synthetic */ TradeOffer $existingGoldOffer;
            final /* synthetic */ TradeOffersList $ourOffers;
            final /* synthetic */ OfferColumnsTable this$0;
            {
                this.$offer = $offer;
                this.$existingGoldOffer = $existingGoldOffer;
                this.$ourOffers = $ourOffers;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(int userInput) {
                this.$offer.setAmount(userInput);
                if (this.$existingGoldOffer == null) {
                    this.$ourOffers.add(this.$offer);
                } else {
                    this.$existingGoldOffer.setAmount(this.$offer.getAmount());
                }
                if (this.$offer.getAmount() == 0) {
                    this.$ourOffers.remove((Object)this.$offer);
                }
                OfferColumnsTable.access$getOnChange$p(this.this$0).invoke();
            }
        }, 192, null), false, 1, null);
    }

    public static final /* synthetic */ Function0 access$getOnChange$p(OfferColumnsTable $this) {
        return $this.onChange;
    }

    public static final /* synthetic */ TradeLogic access$getTradeLogic$p(OfferColumnsTable $this) {
        return $this.tradeLogic;
    }

    public static final /* synthetic */ void access$offerClickImplementation(OfferColumnsTable $this, TradeOffer offer, boolean invert, TradeOffersList list2, TradeOffersList counterList, Civilization civ) {
        $this.offerClickImplementation(offer, invert, list2, counterList, civ);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TradeOfferType.values().length];
            try {
                nArray[TradeOfferType.Gold.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Gold_Per_Turn.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

