/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.diplomacyscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.logic.trade.TradeOffersList;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.IconTextButton;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.diplomacyscreen.OffersListScroll;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ0\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/OffersListScroll;", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "persistenceID", "", "onOfferClicked", "Lkotlin/Function1;", "Lcom/unciv/logic/trade/TradeOffer;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "expanderTabs", "Ljava/util/HashMap;", "Lcom/unciv/logic/trade/TradeOfferType;", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "Lkotlin/collections/HashMap;", "table", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "getTable", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "update", "offersToDisplay", "Lcom/unciv/logic/trade/TradeOffersList;", "otherSideOffers", "untradableOffers", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "ourCiv", "Lcom/unciv/logic/civilization/Civilization;", "theirCiv", "core"})
@SourceDebugExtension(value={"SMAP\nOffersListScroll.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OffersListScroll.kt\ncom/unciv/ui/screens/diplomacyscreen/OffersListScroll\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1#2:139\n766#3:140\n857#3,2:141\n766#3:143\n857#3,2:144\n1726#3,3:146\n*S KotlinDebug\n*F\n+ 1 OffersListScroll.kt\ncom/unciv/ui/screens/diplomacyscreen/OffersListScroll\n*L\n68#1:140\n68#1:141,2\n77#1:143\n77#1:144,2\n118#1:146,3\n*E\n"})
public final class OffersListScroll
extends AutoScrollPane {
    @NotNull
    private final String persistenceID;
    @NotNull
    private final Function1<TradeOffer, Unit> onOfferClicked;
    @NotNull
    private final Table table;
    @NotNull
    private final HashMap<TradeOfferType, ExpanderTab> expanderTabs;

    /*
     * WARNING - void declaration
     */
    public OffersListScroll(@NotNull String persistenceID, @NotNull Function1<? super TradeOffer, Unit> onOfferClicked) {
        void $this$table_u24lambda_u240;
        Table table2;
        Intrinsics.checkNotNullParameter(persistenceID, "persistenceID");
        Intrinsics.checkNotNullParameter(onOfferClicked, "onOfferClicked");
        super(null, null, 2, null);
        this.persistenceID = persistenceID;
        this.onOfferClicked = onOfferClicked;
        Table table3 = table2 = new Table(BaseScreen.Companion.getSkin());
        OffersListScroll offersListScroll = this;
        boolean bl = false;
        $this$table_u24lambda_u240.defaults().pad(5.0f);
        offersListScroll.table = table2;
        this.expanderTabs = new HashMap();
        this.setFadeScrollBars(false);
        this.setScrollbarsVisible(true);
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    /*
     * WARNING - void declaration
     */
    public final void update(@NotNull TradeOffersList offersToDisplay, @NotNull TradeOffersList otherSideOffers, @NotNull ResourceSupplyList untradableOffers, @NotNull Civilization ourCiv, @NotNull Civilization theirCiv) {
        Intrinsics.checkNotNullParameter(offersToDisplay, "offersToDisplay");
        Intrinsics.checkNotNullParameter(otherSideOffers, "otherSideOffers");
        Intrinsics.checkNotNullParameter(untradableOffers, "untradableOffers");
        Intrinsics.checkNotNullParameter(ourCiv, "ourCiv");
        Intrinsics.checkNotNullParameter(theirCiv, "theirCiv");
        this.table.clear();
        this.expanderTabs.clear();
        for (TradeOfferType offerType : TradeOfferType.getEntries()) {
            void $this$filterTo$iv$iv;
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[offerType.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "";
                    break;
                }
                case 6: {
                    string = "Luxury resources";
                    break;
                }
                case 7: {
                    string = "Strategic resources";
                    break;
                }
                case 8: {
                    string = "Stockpiled resources";
                    break;
                }
                case 9: {
                    string = "Technologies";
                    break;
                }
                case 10: {
                    string = "Declarations of war";
                    break;
                }
                case 11: {
                    string = "Cities";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String labelName = string;
            Iterable $this$filter$iv = offersToDisplay;
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TradeOffer it = (TradeOffer)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == offerType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List offersOfType2 = (List)destination$iv$iv;
            if (!(((CharSequence)labelName).length() > 0) || !CollectionsKt.any(offersOfType2)) continue;
            ((Map)this.expanderTabs).put(offerType, new ExpanderTab(labelName, 0, null, false, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "Trade." + this.persistenceID + '.' + (Object)((Object)offerType), null, null, update.1.INSTANCE, 3582, null));
        }
        for (TradeOfferType offerType : TradeOfferType.getEntries()) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = offersToDisplay;
            boolean $i$f$filter = false;
            Iterable $i$f$filter2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TradeOffer it = (TradeOffer)element$iv$iv;
                boolean bl = false;
                if (!(it.getType() == offerType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Function1[] function1Array = new Function1[]{update.offersOfType.3.INSTANCE, update.offersOfType.4.INSTANCE};
            List<TradeOffer> offersOfType3 = CollectionsKt.sortedWith((List)destination$iv$iv, ComparisonsKt.compareBy(function1Array));
            if (this.expanderTabs.containsKey((Object)offerType)) {
                ExpanderTab expanderTab2 = this.expanderTabs.get((Object)offerType);
                Intrinsics.checkNotNull(expanderTab2);
                expanderTab2.getInnerTable().clear();
                ExpanderTab expanderTab3 = this.expanderTabs.get((Object)offerType);
                Intrinsics.checkNotNull(expanderTab3);
                this.table.add((Actor)expanderTab3).row();
            }
            for (TradeOffer offer : offersOfType3) {
                int amountPerClick;
                TradeOfferType[] $i$f$filterTo2;
                Group group;
                String tradeLabel = offer.getOfferText(untradableOffers.sumBy(offer.getName()));
                switch (WhenMappings.$EnumSwitchMapping$0[offer.getType().ordinal()]) {
                    case 6: 
                    case 7: {
                        group = ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, offer.getName(), 30.0f, 0, 4, null);
                        break;
                    }
                    case 10: {
                        Nation nation2 = ourCiv.getGameInfo().getRuleset().getNations().get(offer.getName());
                        Intrinsics.checkNotNull(nation2);
                        group = ImageGetter.INSTANCE.getNationPortrait(nation2, 30.0f);
                        break;
                    }
                    default: {
                        group = null;
                    }
                }
                Group tradeIcon = group;
                TradeOfferType[] $this$update_u24lambda_u243 = $i$f$filterTo2 = new IconTextButton(tradeLabel, (Actor)tradeIcon, 0, null, 12, null);
                boolean bl = false;
                if (tradeIcon != null) {
                    $this$update_u24lambda_u243.getIconCell().size(30.0f);
                }
                $this$update_u24lambda_u243.getLabel().setAlignment(1);
                $this$update_u24lambda_u243.getLabelCell().pad(5.0f).grow();
                TradeOfferType[] tradeButton = $i$f$filterTo2;
                switch (WhenMappings.$EnumSwitchMapping$0[offer.getType().ordinal()]) {
                    case 1: {
                        int n = 50;
                        break;
                    }
                    case 3: {
                        int n = Integer.MAX_VALUE;
                        break;
                    }
                    default: {
                        int n = amountPerClick = 1;
                    }
                }
                if (!(!offer.isTradable() || Intrinsics.areEqual(offer.getName(), "Peace Treaty") || Intrinsics.areEqual(offer.getName(), "Research Agreement") && ourCiv.getGold() + theirCiv.getGold() <= ourCiv.getDiplomacyFunctions().getResearchAgreementCost(theirCiv) * 2)) {
                    $this$update_u24lambda_u243 = new TradeOfferType[]{TradeOfferType.Luxury_Resource, TradeOfferType.Strategic_Resource};
                    if (CollectionsKt.listOf($this$update_u24lambda_u243).contains((Object)offerType)) {
                        boolean bl2;
                        block32: {
                            Iterable $this$all$iv = otherSideOffers;
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    TradeOffer it = (TradeOffer)element$iv;
                                    boolean bl3 = false;
                                    if (it.getType() != offer.getType() || !Intrinsics.areEqual(it.getName(), offer.getName()) || it.getAmount() < 0) continue;
                                    bl2 = false;
                                    break block32;
                                }
                                bl2 = true;
                            }
                        }
                        if (bl2) {
                            tradeButton.setColor(Color.GREEN);
                        }
                    }
                    ActivationExtensionsKt.onClick((Actor)tradeButton, new Function0<Unit>(amountPerClick, offer, this){
                        final /* synthetic */ int $amountPerClick;
                        final /* synthetic */ TradeOffer $offer;
                        final /* synthetic */ OffersListScroll this$0;
                        {
                            this.$amountPerClick = $amountPerClick;
                            this.$offer = $offer;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            int amountTransferred = Math.min(this.$amountPerClick, this.$offer.getAmount());
                            OffersListScroll.access$getOnOfferClicked$p(this.this$0).invoke(TradeOffer.copy$default(this.$offer, null, null, amountTransferred, 0, 11, null));
                        }
                    });
                } else {
                    Scene2dExtensionsKt.disable((Button)tradeButton);
                }
                if (this.expanderTabs.containsKey((Object)offerType)) {
                    ExpanderTab expanderTab4 = this.expanderTabs.get((Object)offerType);
                    Intrinsics.checkNotNull(expanderTab4);
                    expanderTab4.getInnerTable().add((Actor)tradeButton).row();
                    continue;
                }
                this.table.add((Actor)tradeButton).row();
            }
        }
        this.setActor(this.table);
    }

    public static /* synthetic */ void update$default(OffersListScroll offersListScroll, TradeOffersList tradeOffersList, TradeOffersList tradeOffersList2, ResourceSupplyList resourceSupplyList, Civilization civilization, Civilization civilization2, int n, Object object) {
        if ((n & 4) != 0) {
            resourceSupplyList = ResourceSupplyList.Companion.getEmptyList();
        }
        offersListScroll.update(tradeOffersList, tradeOffersList2, resourceSupplyList, civilization, civilization2);
    }

    public static final /* synthetic */ Function1 access$getOnOfferClicked$p(OffersListScroll $this) {
        return $this.onOfferClicked;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TradeOfferType.values().length];
            try {
                nArray[TradeOfferType.Gold.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Gold_Per_Turn.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Treaty.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Agreement.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Introduction.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Luxury_Resource.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Strategic_Resource.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Stockpiled_Resource.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.Technology.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.WarDeclaration.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TradeOfferType.City.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

