/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.FloatAction;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.mapeditorscreen.EditorMapHolder;
import com.unciv.ui.screens.mapeditorscreen.MapEditorMainTabs;
import com.unciv.ui.screens.mapeditorscreen.MapEditorToolsDrawer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000;\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006*\u0001\u0015\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0000H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/MapEditorToolsDrawer;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "tabs", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorMainTabs;", "initStage", "Lcom/badlogic/gdx/scenes/scene2d/Stage;", "mapHolder", "Lcom/unciv/ui/screens/mapeditorscreen/EditorMapHolder;", "(Lcom/unciv/ui/screens/mapeditorscreen/MapEditorMainTabs;Lcom/badlogic/gdx/scenes/scene2d/Stage;Lcom/unciv/ui/screens/mapeditorscreen/EditorMapHolder;)V", "arrowIcon", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "arrowSize", "", "handleWidth", "value", "splitAmount", "getSplitAmount", "()F", "setSplitAmount", "(F)V", "getListener", "com/unciv/ui/screens/mapeditorscreen/MapEditorToolsDrawer$getListener$1", "drawer", "(Lcom/unciv/ui/screens/mapeditorscreen/MapEditorToolsDrawer;)Lcom/unciv/ui/screens/mapeditorscreen/MapEditorToolsDrawer$getListener$1;", "reposition", "", "splitAmountToX", "xToSplitAmount", "x", "Companion", "SplitAmountAction", "core"})
public final class MapEditorToolsDrawer
extends Table {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorMapHolder mapHolder;
    private final float handleWidth;
    private final float arrowSize;
    private float splitAmount;
    @NotNull
    private final Image arrowIcon;
    @Deprecated
    @NotNull
    public static final String arrowImage = "OtherIcons/BackArrow";
    @Deprecated
    public static final float animationDuration = 0.333f;
    @Deprecated
    public static final float clickEpsilon = 0.001f;

    public MapEditorToolsDrawer(@NotNull MapEditorMainTabs tabs, @NotNull Stage initStage, @NotNull EditorMapHolder mapHolder2) {
        Cell<Actor> cell2;
        Intrinsics.checkNotNullParameter(tabs, "tabs");
        Intrinsics.checkNotNullParameter(initStage, "initStage");
        Intrinsics.checkNotNullParameter(mapHolder2, "mapHolder");
        super(BaseScreen.Companion.getSkin());
        this.mapHolder = mapHolder2;
        this.handleWidth = Gdx.app.getType() == Application.ApplicationType.Desktop ? 10.0f : 25.0f;
        this.arrowSize = Gdx.app.getType() == Application.ApplicationType.Desktop ? 10.0f : 20.0f;
        this.splitAmount = 1.0f;
        this.arrowIcon = ImageGetter.getImage$default(ImageGetter.INSTANCE, arrowImage, null, 2, null);
        this.setTouchable(Touchable.childrenOnly);
        this.arrowIcon.setSize(this.arrowSize, this.arrowSize);
        this.arrowIcon.setOrigin(1);
        this.arrowIcon.setRotation(180.0f);
        Container<Actor> arrowWrapper = new Container<Actor>((Actor)this.arrowIcon);
        arrowWrapper.align(1);
        arrowWrapper.setSize(this.arrowSize, this.arrowSize);
        arrowWrapper.setOrigin(1);
        Cell<Actor> $this$_init__u24lambda_u240 = cell2 = this.add((Actor)arrowWrapper).align(1).width(this.handleWidth).fillY();
        boolean bl = false;
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "MapEditor/MapEditorToolsDrawer/Handle", null, BaseScreen.Companion.getSkin().getColor("color"), 2, null));
        this.add((Actor)tabs).height(initStage.getHeight()).fill().top();
        this.pack();
        this.setPosition(initStage.getWidth(), 0.0f, 20);
        initStage.addActor(this);
        initStage.addCaptureListener(this.getListener(this));
    }

    public final float getSplitAmount() {
        return this.splitAmount;
    }

    public final void setSplitAmount(float value) {
        this.splitAmount = value;
        this.reposition();
    }

    private final getListener.1 getListener(MapEditorToolsDrawer drawer) {
        return new InputListener(drawer, this){
            private int draggingPointer;
            private float oldSplitAmount;
            private float lastX;
            private float handleX;
            final /* synthetic */ MapEditorToolsDrawer $drawer;
            final /* synthetic */ MapEditorToolsDrawer this$0;
            {
                this.$drawer = $drawer;
                this.this$0 = $receiver;
                this.draggingPointer = -1;
                this.oldSplitAmount = -1.0f;
            }

            public boolean touchDown(@NotNull InputEvent event, float x, float y, int pointer, int button) {
                Intrinsics.checkNotNullParameter(event, "event");
                if (this.draggingPointer != -1) {
                    return false;
                }
                if (pointer == 0 && button != 0) {
                    return false;
                }
                float f = this.$drawer.getX();
                if (!(x <= this.$drawer.getX() + MapEditorToolsDrawer.access$getHandleWidth$p(this.this$0) ? f <= x : false)) {
                    return false;
                }
                MapEditorToolsDrawer.access$getMapHolder$p(this.this$0).killListeners$core();
                this.draggingPointer = pointer;
                this.lastX = x;
                this.handleX = this.$drawer.getX();
                this.oldSplitAmount = this.this$0.getSplitAmount();
                return true;
            }

            public void touchUp(@NotNull InputEvent event, float x, float y, int pointer, int button) {
                Intrinsics.checkNotNullParameter(event, "event");
                if (pointer != this.draggingPointer) {
                    return;
                }
                MapEditorToolsDrawer.access$getMapHolder$p(this.this$0).resurrectListeners$core();
                this.draggingPointer = -1;
                if (this.oldSplitAmount < 0.0f) {
                    return;
                }
                this.this$0.addAction(new SplitAmountAction(this.$drawer, this.this$0.getSplitAmount() > 0.5f ? 0.0f : 1.0f));
            }

            public void touchDragged(@NotNull InputEvent event, float x, float y, int pointer) {
                Intrinsics.checkNotNullParameter(event, "event");
                if (pointer != this.draggingPointer) {
                    return;
                }
                float delta = x - this.lastX;
                this.lastX = x;
                this.handleX += delta;
                this.this$0.setSplitAmount(MapEditorToolsDrawer.access$xToSplitAmount(this.$drawer, this.handleX));
                if (this.oldSplitAmount >= 0.0f && Math.abs(this.oldSplitAmount - this.this$0.getSplitAmount()) >= 0.001f) {
                    this.oldSplitAmount = -1.0f;
                }
            }
        };
    }

    private final float splitAmountToX() {
        return this.getStage().getWidth() - this.getWidth() + (1.0f - this.splitAmount) * (this.getWidth() - this.handleWidth);
    }

    private final float xToSplitAmount(float x) {
        return RangesKt.coerceIn(1.0f - (x + this.getWidth() - this.getStage().getWidth()) / (this.getWidth() - this.handleWidth), 0.0f, 1.0f);
    }

    public final void reposition() {
        if (this.getStage() == null) {
            return;
        }
        float f = this.splitAmount;
        if (f == 0.0f) {
            this.arrowIcon.setRotation(0.0f);
            this.arrowIcon.setVisible(true);
        } else if (f == 1.0f) {
            this.arrowIcon.setRotation(180.0f);
            this.arrowIcon.setVisible(true);
        } else {
            this.arrowIcon.setVisible(false);
        }
        this.setPosition(this.splitAmountToX(), 0.0f, 12);
    }

    public static final /* synthetic */ float access$getHandleWidth$p(MapEditorToolsDrawer $this) {
        return $this.handleWidth;
    }

    public static final /* synthetic */ EditorMapHolder access$getMapHolder$p(MapEditorToolsDrawer $this) {
        return $this.mapHolder;
    }

    public static final /* synthetic */ float access$xToSplitAmount(MapEditorToolsDrawer $this, float x) {
        return $this.xToSplitAmount(x);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/MapEditorToolsDrawer$Companion;", "", "()V", "animationDuration", "", "arrowImage", "", "clickEpsilon", "core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/MapEditorToolsDrawer$SplitAmountAction;", "Lcom/badlogic/gdx/scenes/scene2d/actions/FloatAction;", "drawer", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorToolsDrawer;", "endAmount", "", "(Lcom/unciv/ui/screens/mapeditorscreen/MapEditorToolsDrawer;F)V", "act", "", "delta", "core"})
    private static final class SplitAmountAction
    extends FloatAction {
        @NotNull
        private final MapEditorToolsDrawer drawer;

        public SplitAmountAction(@NotNull MapEditorToolsDrawer drawer, float endAmount) {
            Intrinsics.checkNotNullParameter(drawer, "drawer");
            super(drawer.getSplitAmount(), endAmount, 0.333f);
            this.drawer = drawer;
        }

        @Override
        public boolean act(float delta) {
            boolean result2 = super.act(delta);
            this.drawer.setSplitAmount(this.getValue());
            return result2;
        }
    }
}

