/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen.tabs;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import com.unciv.ui.screens.mapeditorscreen.tabs.IMapEditorEditSubTabs;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditTab;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorEditTerrainTab;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTerrainTab;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/IMapEditorEditSubTabs;", "editTab", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "(Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorEditTab;Lcom/unciv/models/ruleset/Ruleset;)V", "allTerrains", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/tile/Terrain;", "getTerrains", "", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "isDisabled", "", "core"})
public final class MapEditorEditTerrainTab
extends Table
implements IMapEditorEditSubTabs {
    @NotNull
    private final MapEditorEditTab editTab;
    @NotNull
    private final Ruleset ruleset;

    public MapEditorEditTerrainTab(@NotNull MapEditorEditTab editTab, @NotNull Ruleset ruleset2) {
        Intrinsics.checkNotNullParameter(editTab, "editTab");
        Intrinsics.checkNotNullParameter(ruleset2, "ruleset");
        super(BaseScreen.Companion.getSkin());
        this.editTab = editTab;
        this.ruleset = ruleset2;
        this.top();
        this.defaults().pad(10.0f).fillX().left();
        this.add((Actor)MarkupRenderer.render$default(MarkupRenderer.INSTANCE, this.getTerrains(), 0.0f, 0.0f, FormattedLine.IconDisplay.NoLink, new Function1<String, Unit>(){

            @Override
            public final void invoke(final @NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                MapEditorEditTab.setBrush$default(editTab, it, "Terrain/" + it, null, null, false, new Function1<Tile, Unit>(){

                    @Override
                    public final void invoke(@NotNull Tile tile) {
                        Intrinsics.checkNotNullParameter(tile, "tile");
                        tile.setBaseTerrain(it);
                        tile.setNaturalWonder(null);
                    }
                }, 28, null);
            }
        }, 6, null)).row();
    }

    private final Sequence<Terrain> allTerrains() {
        Collection<Terrain> collection = this.ruleset.getTerrains().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return SequencesKt.filterNot(SequencesKt.filter(CollectionsKt.asSequence((Iterable)collection), allTerrains.1.INSTANCE), allTerrains.2.INSTANCE);
    }

    private final Iterable<FormattedLine> getTerrains() {
        return SequencesKt.asIterable(SequencesKt.map(this.allTerrains(), getTerrains.1.INSTANCE));
    }

    @Override
    public boolean isDisabled() {
        return false;
    }
}

