/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.transients.CivInfoStatsForNextTurn;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.NonTransformGroup;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.overviewscreen.UnitOverviewTab;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/unciv/ui/screens/overviewscreen/UnitSupplyTable;", "", "()V", "create", "Lcom/unciv/ui/components/widgets/ExpanderTab;", "overviewScreen", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "unitOverviewTab", "Lcom/unciv/ui/screens/overviewscreen/UnitOverviewTab;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "supplyTableWidth", "", "addLabeledValue", "", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "label", "", "value", "", "core"})
public final class UnitSupplyTable {
    @NotNull
    public static final UnitSupplyTable INSTANCE = new UnitSupplyTable();

    private UnitSupplyTable() {
    }

    @NotNull
    public final ExpanderTab create(@NotNull EmpireOverviewScreen overviewScreen, @NotNull UnitOverviewTab unitOverviewTab, @NotNull Civilization viewingPlayer, float supplyTableWidth) {
        NonTransformGroup nonTransformGroup;
        Intrinsics.checkNotNullParameter(overviewScreen, "overviewScreen");
        Intrinsics.checkNotNullParameter(unitOverviewTab, "unitOverviewTab");
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        CivInfoStatsForNextTurn stats2 = viewingPlayer.getStats();
        int deficit = stats2.getUnitSupplyDeficit();
        if (deficit <= 0) {
            nonTransformGroup = null;
        } else {
            NonTransformGroup nonTransformGroup2;
            NonTransformGroup $this$create_u24lambda_u240 = nonTransformGroup2 = new NonTransformGroup();
            boolean bl = false;
            $this$create_u24lambda_u240.setSize(36.0f, 36.0f);
            Image image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/ExclamationMark", null, 2, null);
            image2.setColor(Color.FIREBRICK);
            image2.setSize(36.0f, 36.0f);
            Scene2dExtensionsKt.center((Actor)image2, $this$create_u24lambda_u240);
            image2.setOrigin(1);
            $this$create_u24lambda_u240.addActor(image2);
            nonTransformGroup = nonTransformGroup2;
        }
        NonTransformGroup icon = nonTransformGroup;
        return new ExpanderTab("Unit Supply", 18, (Actor)icon, deficit > 0, 0.0f, 0.0f, 0.0f, supplyTableWidth, 0.0f, null, null, new Function0<Unit>(overviewScreen, unitOverviewTab){
            final /* synthetic */ EmpireOverviewScreen $overviewScreen;
            final /* synthetic */ UnitOverviewTab $unitOverviewTab;
            {
                this.$overviewScreen = $overviewScreen;
                this.$unitOverviewTab = $unitOverviewTab;
                super(0);
            }

            public final void invoke() {
                this.$overviewScreen.resizePage(this.$unitOverviewTab);
            }
        }, new Function1<Table, Unit>(stats2, viewingPlayer, deficit, supplyTableWidth){
            final /* synthetic */ CivInfoStatsForNextTurn $stats;
            final /* synthetic */ Civilization $viewingPlayer;
            final /* synthetic */ int $deficit;
            final /* synthetic */ float $supplyTableWidth;
            {
                this.$stats = $stats;
                this.$viewingPlayer = $viewingPlayer;
                this.$deficit = $deficit;
                this.$supplyTableWidth = $supplyTableWidth;
                super(1);
            }

            public final void invoke(@NotNull Table it) {
                Intrinsics.checkNotNullParameter(it, "it");
                it.defaults().pad(5.0f).fill(false);
                it.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "OverviewScreen/UnitOverviewTab/UnitSupplyTable", null, Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.6f), 2, null));
                UnitSupplyTable.access$addLabeledValue(UnitSupplyTable.INSTANCE, it, "Base Supply", this.$stats.getBaseUnitSupply());
                UnitSupplyTable.access$addLabeledValue(UnitSupplyTable.INSTANCE, it, "Cities", this.$stats.getUnitSupplyFromCities());
                UnitSupplyTable.access$addLabeledValue(UnitSupplyTable.INSTANCE, it, "Population", this.$stats.getUnitSupplyFromPop());
                Scene2dExtensionsKt.addSeparator$default(it, null, 0, 0.0f, 7, null);
                UnitSupplyTable.access$addLabeledValue(UnitSupplyTable.INSTANCE, it, "Total Supply", this.$stats.getUnitSupply());
                UnitSupplyTable.access$addLabeledValue(UnitSupplyTable.INSTANCE, it, "In Use", this.$viewingPlayer.getUnits().getCivUnitsSize());
                Scene2dExtensionsKt.addSeparator$default(it, null, 0, 0.0f, 7, null);
                UnitSupplyTable.access$addLabeledValue(UnitSupplyTable.INSTANCE, it, "Supply Deficit", this.$deficit);
                UnitSupplyTable.access$addLabeledValue(UnitSupplyTable.INSTANCE, it, "Production Penalty", "" + (int)this.$stats.getUnitSupplyProductionPenalty() + '%');
                if (this.$deficit > 0) {
                    Color color = Color.FIREBRICK;
                    Intrinsics.checkNotNullExpressionValue(color, "FIREBRICK");
                    Label penaltyLabel = Scene2dExtensionsKt.toLabel$default("Increase your supply or reduce the amount of units to remove the production penalty", color, 0, 0, false, 14, null);
                    penaltyLabel.setWrap(true);
                    it.add((Actor)penaltyLabel).colspan(2).left().width(this.$supplyTableWidth).row();
                }
            }
        }, 1888, null);
    }

    private final void addLabeledValue(Table $this$addLabeledValue, String label2, int value) {
        $this$addLabeledValue.add((Actor)Scene2dExtensionsKt.toLabel(label2)).left();
        $this$addLabeledValue.add((Actor)Scene2dExtensionsKt.toLabel(value)).right().row();
    }

    private final void addLabeledValue(Table $this$addLabeledValue, String label2, String value) {
        $this$addLabeledValue.add((Actor)Scene2dExtensionsKt.toLabel(label2)).left();
        $this$addLabeledValue.add((Actor)Scene2dExtensionsKt.toLabel(value)).right().row();
    }

    public static final /* synthetic */ void access$addLabeledValue(UnitSupplyTable $this, Table $receiver, String label2, int value) {
        $this.addLabeledValue($receiver, label2, value);
    }

    public static final /* synthetic */ void access$addLabeledValue(UnitSupplyTable $this, Table $receiver, String label2, String value) {
        $this.addLabeledValue($receiver, label2, value);
    }
}

