/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.PolicyManager;
import com.unciv.models.TutorialTrigger;
import com.unciv.models.UncivSound;
import com.unciv.models.ruleset.Policy;
import com.unciv.models.ruleset.PolicyBranch;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetObject;
import com.unciv.models.ruleset.tech.Era;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ActorKeyShortcutDispatcher;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.components.widgets.BorderedTable;
import com.unciv.ui.components.widgets.ColorMarkupLabel;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.RecreateOnResize;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.pickerscreens.PolicyButton;
import com.unciv.ui.screens.pickerscreens.PolicyColors;
import com.unciv.ui.screens.pickerscreens.PolicyPickerScreenKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002,-B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J0\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u000eH\u0002J\b\u0010*\u001a\u00020+H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006."}, d2={"Lcom/unciv/ui/screens/pickerscreens/PolicyPickerScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "Lcom/unciv/ui/screens/basescreen/RecreateOnResize;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "canChangeState", "", "select", "", "(Lcom/unciv/logic/civilization/Civilization;ZLjava/lang/String;)V", "getCanChangeState", "()Z", "policyNameToButton", "Ljava/util/HashMap;", "Lcom/unciv/ui/screens/pickerscreens/PolicyButton;", "Lkotlin/collections/HashMap;", "selectedPolicyButton", "getViewingCiv", "()Lcom/unciv/logic/civilization/Civilization;", "confirmAction", "", "drawLine", "group", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "policyX", "", "policyY", "prereqX", "prereqY", "drawLines", "branch", "Lcom/unciv/models/ruleset/PolicyBranch;", "getBranchHeader", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "getCivilopediaRuleset", "Lcom/unciv/models/ruleset/Ruleset;", "getPolicyButton", "policy", "Lcom/unciv/models/ruleset/Policy;", "getTopButton", "pickPolicy", "button", "recreate", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "BranchGroup", "Sizes", "core"})
@SourceDebugExtension(value={"SMAP\nPolicyPickerScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolicyPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/PolicyPickerScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,683:1\n1#2:684\n1774#3,4:685\n*S KotlinDebug\n*F\n+ 1 PolicyPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/PolicyPickerScreen\n*L\n579#1:685,4\n*E\n"})
public final class PolicyPickerScreen
extends PickerScreen
implements RecreateOnResize {
    @NotNull
    private final Civilization viewingCiv;
    private final boolean canChangeState;
    @NotNull
    private final HashMap<String, PolicyButton> policyNameToButton;
    @Nullable
    private PolicyButton selectedPolicyButton;

    public PolicyPickerScreen(@NotNull Civilization viewingCiv, boolean canChangeState, @Nullable String select2) {
        int n;
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        super(false, 1, null);
        this.viewingCiv = viewingCiv;
        this.canChangeState = canChangeState;
        this.policyNameToButton = new HashMap();
        HashMap branchToGroup = new HashMap();
        PolicyManager policies = this.viewingCiv.getPolicies();
        BaseScreen.displayTutorial$default(this, TutorialTrigger.CultureAndPolicies, null, 2, null);
        this.getRightSideButton().setText(TranslationsKt.tr$default(policies.allPoliciesAdopted(false) ? "All policies adopted" : (policies.getFreePolicies() > 0 ? "Adopt free policy" : "{Adopt policy}\n(" + policies.getStoredCulture() + '/' + policies.getCultureNeededForNextPolicy() + ')'), false, false, 3, null));
        this.setDefaultCloseAction();
        ActivationExtensionsKt.onClick(this.getRightSideButton(), UncivSound.Companion.getPolicy(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.confirmAction();
            }
        });
        if (!this.canChangeState) {
            Scene2dExtensionsKt.disable(this.getRightSideButton());
        }
        this.getTopTable().row();
        LinkedHashMap<String, PolicyBranch> branches = this.viewingCiv.getGameInfo().getRuleset().getPolicyBranches();
        int branchesPerRow = 0;
        float numBranchesY = this.getScrollPane().getHeight() / 305.0f;
        if (numBranchesY > 1.5f) {
            int numRows = numBranchesY < 2.9f ? 2 : (int)(numBranchesY + 0.1f);
            n = (branches.size() + numRows - 1) / numRows;
        } else {
            n = branches.size();
        }
        branchesPerRow = n;
        int numberOfRows = (int)Math.ceil((float)branches.size() / (float)branchesPerRow);
        HashMap positionToTable = new HashMap();
        Table allPoliciesTable = new Table();
        for (int rowNum = 0; rowNum < numberOfRows; ++rowNum) {
            Table row = new Table();
            for (int columnNum = 0; columnNum < branchesPerRow; ++columnNum) {
                Table branchTable = new Table();
                row.add((Actor)branchTable).grow();
                ((Map)positionToTable).put("" + rowNum + '-' + columnNum, branchTable);
            }
            Cell<Actor> cell2 = allPoliciesTable.add((Actor)row);
            Intrinsics.checkNotNullExpressionValue(cell2, "add(...)");
            Scene2dExtensionsKt.pad(cell2, 5.0f, 10.0f);
            if (rowNum == numberOfRows - 1) continue;
            Scene2dExtensionsKt.pad(Scene2dExtensionsKt.addSeparator$default(allPoliciesTable, null, 0, 0.0f, 7, null), 0.0f, 10.0f);
        }
        Iterator<PolicyBranch> rowNum = branches.values().iterator();
        int n2 = 0;
        while (rowNum.hasNext()) {
            int index = n2++;
            PolicyBranch branch = rowNum.next();
            Intrinsics.checkNotNull(branch);
            BranchGroup branchGroup = new BranchGroup(branch);
            ((Map)branchToGroup).put(branch.getName(), branchGroup);
            int rowNumber = index / branchesPerRow;
            boolean isRowLeftToRight = rowNumber % 2 == 0;
            int numberInRow = index % branchesPerRow;
            int rowPosition = isRowLeftToRight ? numberInRow : branchesPerRow - 1 - numberInRow;
            Object v = positionToTable.get("" + rowNumber + '-' + rowPosition);
            Intrinsics.checkNotNull(v);
            Table policyTable = (Table)v;
            policyTable.add((Actor)branchGroup).grow();
        }
        this.getTopTable().add((Actor)allPoliciesTable);
        this.getSplitPane().pack();
        if (this.getTopTable().getHeight() > this.getScrollPane().getHeight()) {
            float vScroll = Math.min(0.0f, this.getScrollPane().getMaxY() / (float)2);
            this.getScrollPane().setScrollY(vScroll);
        }
        if (this.getTopTable().getWidth() > this.getScrollPane().getWidth()) {
            float hScroll = Math.min(20.0f, this.getScrollPane().getMaxX() / (float)2);
            this.getScrollPane().setScrollX(hScroll);
        }
        this.getScrollPane().updateVisualScroll();
        String string = select2;
        if (((Map)branches).containsKey(string)) {
            BranchGroup branchGroup = (BranchGroup)((Map)branchToGroup).get(select2);
            if (branchGroup != null) {
                branchGroup.toggle();
            }
        } else if (((Map)this.policyNameToButton).containsKey(string)) {
            Object v = ((Map)this.policyNameToButton).get(select2);
            Intrinsics.checkNotNull(v);
            this.pickPolicy((PolicyButton)v);
        }
    }

    public /* synthetic */ PolicyPickerScreen(Civilization civilization, boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(civilization, bl, string);
    }

    @NotNull
    public final Civilization getViewingCiv() {
        return this.viewingCiv;
    }

    public final boolean getCanChangeState() {
        return this.canChangeState;
    }

    @Override
    @NotNull
    public Ruleset getCivilopediaRuleset() {
        return this.viewingCiv.getGameInfo().getRuleset();
    }

    private final void pickPolicy(PolicyButton button) {
        Policy policy2 = button.getPolicy();
        this.getRightSideButton().setVisible(!this.viewingCiv.getPolicies().isAdopted(policy2.getName()));
        if (!PolicyPickerScreenKt.access$isPickable(policy2, this.viewingCiv, this.canChangeState)) {
            Scene2dExtensionsKt.disable(this.getRightSideButton());
        } else {
            Scene2dExtensionsKt.enable(this.getRightSideButton());
        }
        PolicyButton policyButton = this.selectedPolicyButton;
        if (policyButton != null) {
            policyButton.setSelected(false);
        }
        PolicyButton policyButton2 = this.selectedPolicyButton = button;
        if (policyButton2 != null) {
            policyButton2.setSelected(true);
        }
        this.getDescriptionLabel().setText(policy2.getDescription());
        this.getDescriptionLabel().clearListeners();
        ActivationExtensionsKt.onActivation(this.getDescriptionLabel(), new Function0<Unit>(this, policy2){
            final /* synthetic */ PolicyPickerScreen this$0;
            final /* synthetic */ Policy $policy;
            {
                this.this$0 = $receiver;
                this.$policy = $policy;
                super(0);
            }

            public final void invoke() {
                this.this$0.openCivilopedia(this.$policy.makeLink());
            }
        });
        ActorKeyShortcutDispatcher.add$default(ActivationExtensionsKt.getKeyShortcuts(this.getDescriptionLabel()), KeyboardBinding.Civilopedia, 0, 2, null);
    }

    private final void drawLines(PolicyBranch branch) {
        for (Policy policy2 : branch.getPolicies()) {
            PolicyButton policyButton;
            if (policy2.getPolicyBranchType() == Policy.PolicyBranchType.BranchComplete || policy2.getRequires() == null) continue;
            PolicyButton policyButton2 = policyButton = this.policyNameToButton.get(policy2.getName());
            Intrinsics.checkNotNull(policyButton2);
            Group group = policyButton2.getParent();
            ArrayList<String> arrayList = policy2.getRequires();
            Intrinsics.checkNotNull(arrayList);
            for (String prereqName : arrayList) {
                PolicyButton prereqButton;
                if (Intrinsics.areEqual(prereqName, branch.getName()) || (prereqButton = this.policyNameToButton.get(prereqName)) == null) continue;
                Intrinsics.checkNotNull(group);
                this.drawLine(group, policyButton.getX() + policyButton.getWidth() / (float)2, policyButton.getY() + policyButton.getHeight(), prereqButton.getX() + prereqButton.getWidth() / (float)2, prereqButton.getY());
            }
        }
    }

    private final void drawLine(Group group, float policyX, float policyY, float prereqX, float prereqY) {
        Color lineColor = Color.WHITE.cpy();
        float lineSize = 2.0f;
        if (!(policyX == prereqX)) {
            Image image2;
            float r = 3.0f;
            float deltaX = policyX - prereqX;
            float deltaY = prereqY - policyY;
            float bendingY = 10.0f;
            Image $this$drawLine_u24lambda_u240 = image2 = ImageGetter.INSTANCE.getWhiteDot();
            boolean bl = false;
            $this$drawLine_u24lambda_u240.setWidth(lineSize);
            $this$drawLine_u24lambda_u240.setHeight(deltaY - bendingY - r);
            $this$drawLine_u24lambda_u240.setX(prereqX - $this$drawLine_u24lambda_u240.getWidth() / (float)2);
            $this$drawLine_u24lambda_u240.setY(prereqY - $this$drawLine_u24lambda_u240.getHeight());
            Image line = image2;
            Image $this$drawLine_u24lambda_u241 = $this$drawLine_u24lambda_u240 = ImageGetter.INSTANCE.getWhiteDot();
            boolean bl2 = false;
            $this$drawLine_u24lambda_u241.setWidth(lineSize);
            $this$drawLine_u24lambda_u241.setHeight(bendingY - r);
            $this$drawLine_u24lambda_u241.setX(policyX - $this$drawLine_u24lambda_u241.getWidth() / (float)2);
            $this$drawLine_u24lambda_u241.setY(policyY);
            Image line1 = $this$drawLine_u24lambda_u240;
            Image $this$drawLine_u24lambda_u242 = $this$drawLine_u24lambda_u241 = ImageGetter.INSTANCE.getWhiteDot();
            boolean bl3 = false;
            $this$drawLine_u24lambda_u242.setWidth(Math.abs(deltaX) - (float)2 * r);
            $this$drawLine_u24lambda_u242.setHeight(lineSize);
            $this$drawLine_u24lambda_u242.setX(policyX + (deltaX > 0.0f ? -$this$drawLine_u24lambda_u242.getWidth() - r : r));
            $this$drawLine_u24lambda_u242.setY(policyY + bendingY - lineSize / (float)2);
            Image line2 = $this$drawLine_u24lambda_u241;
            Image line3 = null;
            Image line4 = null;
            if (deltaX < 0.0f) {
                line3 = ImageGetter.INSTANCE.getLine(line2.getX() + line2.getWidth() - lineSize / (float)2, line2.getY() + lineSize / (float)2, line.getX() + lineSize / (float)2, line.getY() + lineSize / (float)2, lineSize);
                line4 = ImageGetter.INSTANCE.getLine(line2.getX(), line2.getY() + lineSize / (float)2, line1.getX() + lineSize / (float)2, line1.getY() + line1.getHeight(), lineSize);
            } else {
                line3 = ImageGetter.INSTANCE.getLine(line2.getX(), line2.getY() + line2.getHeight() / (float)2, line.getX() + lineSize / (float)2, line.getY(), lineSize);
                line4 = ImageGetter.INSTANCE.getLine(line2.getX() + line2.getWidth() - lineSize / (float)2, line2.getY() + lineSize / (float)2, line1.getX() + lineSize / (float)2, line1.getY() + line1.getHeight() - lineSize / (float)2, lineSize);
            }
            line.setColor(lineColor);
            line1.setColor(lineColor);
            line2.setColor(lineColor);
            line3.setColor(lineColor);
            line4.setColor(lineColor);
            group.addActor(line);
            group.addActor(line1);
            group.addActor(line2);
            group.addActor(line3);
            group.addActor(line4);
        } else {
            Image image3;
            Image $this$drawLine_u24lambda_u243 = image3 = ImageGetter.INSTANCE.getWhiteDot();
            boolean bl = false;
            $this$drawLine_u24lambda_u243.setWidth(lineSize);
            $this$drawLine_u24lambda_u243.setHeight(prereqY - policyY);
            $this$drawLine_u24lambda_u243.setX(policyX - $this$drawLine_u24lambda_u243.getWidth() / (float)2);
            $this$drawLine_u24lambda_u243.setY(policyY);
            Image line = image3;
            line.setColor(lineColor);
            group.addActor(line);
        }
    }

    private final Table getBranchHeader(PolicyBranch branch) {
        Image image2;
        Group group;
        BorderedTable header = new BorderedTable("PolicyScreen/PolicyBranchHeader", null, null, 6, null);
        header.setBgColor(PolicyColors.BranchHeaderBG.getColor());
        header.setBorderSize(5.0f);
        header.pad(10.0f);
        Table table2 = new Table();
        String iconPath = "PolicyBranchIcons/" + branch.getName();
        if (ImageGetter.INSTANCE.imageExists(iconPath)) {
            Image image3;
            Image $this$getBranchHeader_u24lambda_u244 = image3 = ImageGetter.getImage$default(ImageGetter.INSTANCE, iconPath, null, 2, null);
            boolean bl = false;
            $this$getBranchHeader_u24lambda_u244.setOrigin(1);
            $this$getBranchHeader_u24lambda_u244.setOrigin(25.0f, 25.0f);
            $this$getBranchHeader_u24lambda_u244.setAlign(1);
            group = Scene2dExtensionsKt.toGroup(image3, 15.0f);
        } else {
            group = null;
        }
        Group icon = group;
        Image $this$getBranchHeader_u24lambda_u245 = image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/BackArrow", null, 2, null);
        boolean bl = false;
        $this$getBranchHeader_u24lambda_u245.setRotation(90.0f);
        Group expandIcon = Scene2dExtensionsKt.toGroup(image2, 10.0f);
        table2.add((Actor)expandIcon).minWidth(15.0f).expandX().left();
        String string = TranslationsKt.tr$default(branch.getName(), true, false, 2, null).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        table2.add((Actor)Scene2dExtensionsKt.toLabel$default(string, null, 14, 1, false, 9, null)).center();
        table2.add((Actor)icon).expandX().left().padLeft(5.0f);
        header.setTouchable(Touchable.enabled);
        header.add((Actor)table2).minWidth(150.0f).growX();
        header.pack();
        return header;
    }

    private final Table getTopButton(PolicyBranch branch) {
        Image image2;
        String text2 = null;
        boolean isPickable = PolicyPickerScreenKt.access$isPickable(branch, this.viewingCiv, this.canChangeState);
        Ref.BooleanRef isAdoptedBranch = new Ref.BooleanRef();
        Ref.FloatRef percentage = new Ref.FloatRef();
        Image $this$getTopButton_u24lambda_u246 = image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/LockSmall", null, 2, null);
        boolean bl = false;
        $this$getTopButton_u24lambda_u246.setColor(Color.WHITE);
        Group lockIcon = Scene2dExtensionsKt.toGroup(image2, 15.0f);
        if (this.viewingCiv.getPolicies().isAdopted(branch.getName())) {
            int n;
            int amountToDo = ((Collection)branch.getPolicies()).size() - 1;
            if (this.viewingCiv.getPolicies().isAdopted(((Policy)CollectionsKt.last((List)branch.getPolicies())).getName())) {
                n = amountToDo;
            } else {
                Iterable $this$count$iv = branch.getPolicies();
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        Policy it = (Policy)element$iv;
                        boolean bl2 = false;
                        if (!this.viewingCiv.getPolicies().isAdopted(it.getName()) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
            }
            int amountDone = n;
            percentage.element = (float)amountDone / (float)amountToDo;
            text2 = "{Completed} (" + amountDone + '/' + amountToDo + ')';
            lockIcon.setVisible(false);
            isAdoptedBranch.element = true;
        } else {
            Era era2 = this.viewingCiv.getGameInfo().getRuleset().getEras().get(branch.getEra());
            Intrinsics.checkNotNull(era2);
            text2 = era2.getEraNumber() > this.viewingCiv.getEraNumber() ? branch.getEra() : "Adopt";
        }
        Label label2 = Scene2dExtensionsKt.toLabel$default(text2, null, 14, 0, false, 13, null);
        label2.setAlignment(1);
        label2.setColor((isAdoptedBranch.element ? PolicyColors.BranchLabelAdopted : (isPickable ? PolicyColors.BranchLabelPickable : PolicyColors.BranchLabelNotPickable)).getColor());
        lockIcon.setVisible(!isPickable && !isAdoptedBranch.element);
        String string = BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleSmallShape();
        String string2 = BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleSmallShape();
        BorderedTable table2 = new BorderedTable(isAdoptedBranch, percentage, string, string2){
            @Nullable
            private Image progress;
            final /* synthetic */ Ref.FloatRef $percentage;
            {
                this.$percentage = $percentage;
                super("PolicyScreen/PolicyBranchAdoptButton", $super_call_param$1, $super_call_param$2);
                if ($isAdoptedBranch.element && $percentage.element > 0.0f) {
                    Image image2 = this.progress = new Image(BaseScreen.Companion.getSkinStrings().getUiBackground("", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleSmallShape(), PolicyColors.BranchBGCompleted.getColor()));
                    Intrinsics.checkNotNull(image2);
                    image2.setSize(this.getWidth() * $percentage.element, this.getHeight());
                    this.addActor(this.progress);
                    Image image3 = this.progress;
                    Intrinsics.checkNotNull(image3);
                    image3.toBack();
                }
            }

            @Nullable
            public final Image getProgress() {
                return this.progress;
            }

            public final void setProgress(@Nullable Image image2) {
                this.progress = image2;
            }

            protected void sizeChanged() {
                block0: {
                    super.sizeChanged();
                    Image image2 = this.progress;
                    if (image2 == null) break block0;
                    image2.setSize(this.getWidth() * this.$percentage.element, this.getHeight());
                }
            }
        };
        table2.setBgColor((isPickable ? PolicyColors.ButtonBGPickable : PolicyColors.ButtonBGNotPickable).getColor());
        table2.setBorderSize(3.0f);
        table2.add((Actor)label2).minHeight(30.0f).minWidth(150.0f).growX();
        table2.addActor(lockIcon);
        table2.pack();
        lockIcon.setPosition(table2.getWidth(), table2.getHeight() / (float)2 - lockIcon.getHeight() / (float)2);
        ActivationExtensionsKt.onClick(table2, new Function0<Unit>(branch, this){
            final /* synthetic */ PolicyBranch $branch;
            final /* synthetic */ PolicyPickerScreen this$0;
            {
                this.$branch = $branch;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (PolicyPickerScreenKt.access$isPickable(this.$branch, this.this$0.getViewingCiv(), this.this$0.getCanChangeState())) {
                    new ConfirmPopup(this.this$0, "Are you sure you want to adopt [" + this.$branch.getName() + "]?", "Adopt", true, null, (Function0)new Function0<Unit>(this.this$0, this.$branch){
                        final /* synthetic */ PolicyPickerScreen this$0;
                        final /* synthetic */ PolicyBranch $branch;
                        {
                            this.this$0 = $receiver;
                            this.$branch = $branch;
                            super(0);
                        }

                        public final void invoke() {
                            this.this$0.getViewingCiv().getPolicies().adopt(this.$branch, false);
                            this.this$0.getGame().replaceCurrentScreen(this.this$0.recreate());
                        }
                    }, 16, null).open(true);
                }
            }
        });
        return table2;
    }

    private final PolicyButton getPolicyButton(Policy policy2) {
        PolicyButton button = new PolicyButton(this.viewingCiv, this.canChangeState, policy2, 50.0f);
        button.onClick(new Function0<Unit>(this, button){
            final /* synthetic */ PolicyPickerScreen this$0;
            final /* synthetic */ PolicyButton $button;
            {
                this.this$0 = $receiver;
                this.$button = $button;
                super(0);
            }

            public final void invoke() {
                PolicyPickerScreen.access$pickPolicy(this.this$0, this.$button);
            }
        });
        if (PolicyPickerScreenKt.access$isPickable(policy2, this.viewingCiv, this.canChangeState)) {
            ActivationExtensionsKt.onDoubleClick(button, UncivSound.Companion.getPolicy(), new Function0<Unit>(this){
                final /* synthetic */ PolicyPickerScreen this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    PolicyPickerScreen.access$confirmAction(this.this$0);
                }
            });
        }
        return button;
    }

    private final void confirmAction() {
        PolicyButton policyButton = this.selectedPolicyButton;
        Intrinsics.checkNotNull(policyButton);
        Policy policy2 = policyButton.getPolicy();
        if (!PolicyPickerScreenKt.access$isPickable(policy2, this.viewingCiv, this.canChangeState)) {
            return;
        }
        PolicyManager.adopt$default(this.viewingCiv.getPolicies(), policy2, false, 2, null);
        if (!(this.getGame().getScreen() instanceof PolicyPickerScreen)) {
            this.getGame().popScreen();
        } else {
            this.getGame().replaceCurrentScreen(this.recreate());
        }
    }

    @Override
    @NotNull
    public BaseScreen recreate() {
        Object object = this.selectedPolicyButton;
        PolicyPickerScreen newScreen = new PolicyPickerScreen(this.viewingCiv, this.canChangeState, object != null && (object = ((PolicyButton)object).getPolicy()) != null ? ((RulesetObject)object).getName() : null);
        newScreen.getScrollPane().setScrollPercentX(this.getScrollPane().getScrollPercentX());
        newScreen.getScrollPane().setScrollPercentY(this.getScrollPane().getScrollPercentY());
        newScreen.getScrollPane().updateVisualScroll();
        return newScreen;
    }

    public static final /* synthetic */ void access$pickPolicy(PolicyPickerScreen $this, PolicyButton button) {
        $this.pickPolicy(button);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unciv/ui/screens/pickerscreens/PolicyPickerScreen$BranchGroup;", "Lcom/unciv/ui/components/widgets/BorderedTable;", "branch", "Lcom/unciv/models/ruleset/PolicyBranch;", "(Lcom/unciv/ui/screens/pickerscreens/PolicyPickerScreen;Lcom/unciv/models/ruleset/PolicyBranch;)V", "group", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "groupCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "header", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "labelTable", "topBtn", "topBtnCell", "toggle", "", "core"})
    @SourceDebugExtension(value={"SMAP\nPolicyPickerScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolicyPickerScreen.kt\ncom/unciv/ui/screens/pickerscreens/PolicyPickerScreen$BranchGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,683:1\n1#2:684\n*E\n"})
    private final class BranchGroup
    extends BorderedTable {
        @NotNull
        private final Table header;
        @NotNull
        private final Group group;
        @NotNull
        private final Cell<Group> groupCell;
        @NotNull
        private final Table topBtn;
        @NotNull
        private final Cell<Table> topBtnCell;
        @NotNull
        private final Table labelTable;

        public BranchGroup(PolicyBranch branch) {
            int it32;
            Intrinsics.checkNotNullParameter(branch, "branch");
            super("PolicyScreen/PolicyBranchBackground", null, null, 6, null);
            this.header = PolicyPickerScreen.this.getBranchHeader(branch);
            this.group = new Group();
            this.topBtn = PolicyPickerScreen.this.getTopButton(branch);
            this.labelTable = new Table();
            int n = 5;
            Iterator iterator2 = ((Iterable)branch.getPolicies()).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            Policy it22 = (Policy)iterator2.next();
            boolean bl = false;
            int it22 = it22.getColumn();
            while (iterator2.hasNext()) {
                Policy it32 = (Policy)iterator2.next();
                $i$a$-maxOf-PolicyPickerScreen$BranchGroup$maxCol$1 = false;
                it32 = it32.getColumn();
                if (it22 >= it32) continue;
                it22 = it32;
            }
            int n2 = it22;
            int maxCol = Math.max(n, n2);
            iterator2 = ((Iterable)branch.getPolicies()).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            Policy it42 = (Policy)iterator2.next();
            boolean bl2 = false;
            int it42 = it42.getRow();
            while (iterator2.hasNext()) {
                Policy it = (Policy)iterator2.next();
                $i$a$-maxOf-PolicyPickerScreen$BranchGroup$maxRow$1 = false;
                it32 = it.getRow();
                if (it42 >= it32) continue;
                it42 = it32;
            }
            int maxRow = it42;
            float prefWidth = 40.0f + 50.0f * (float)maxCol - 40.0f * (float)(maxCol - 1) / (float)2;
            float prefHeight = 20.0f + 50.0f * (float)maxRow + 20.0f * (float)(maxRow - 1);
            this.setBgColor(PolicyPickerScreen.this.getViewingCiv().getPolicies().isAdopted(branch.getName()) ? PolicyColors.BranchBGAdopted.getColor() : PolicyColors.BranchBGNotAdopted.getColor());
            this.add((Actor)this.header).growX().row();
            String onAdoption = branch.getDescription();
            String onCompletion = ((Policy)CollectionsKt.last((List)branch.getPolicies())).getDescription();
            String text2 = "";
            Era era2 = PolicyPickerScreen.this.getViewingCiv().getGameInfo().getRuleset().getEras().get(branch.getEra());
            Intrinsics.checkNotNull(era2);
            if (era2.getEraNumber() > PolicyPickerScreen.this.getViewingCiv().getEraNumber()) {
                text2 = text2 + "{Unlocked at} {" + branch.getEra() + "}\n\n";
            }
            text2 = text2 + "{On adoption}:\n\n" + onAdoption + "\n\n{On completion}:\n\n" + onCompletion;
            Label label2 = Scene2dExtensionsKt.toLabel$default(text2, null, 13, 0, false, 13, null);
            label2.setFillParent(false);
            label2.setAlignment(10);
            label2.setWrap(true);
            this.labelTable.add((Actor)label2).pad(7.0f, 20.0f, 10.0f, 20.0f).grow().row();
            if (SequencesKt.any(branch.getUniqueMap().getUniques(UniqueType.OnlyAvailable))) {
                String warning = TranslationsKt.tr$default(UniqueType.OnlyAvailable.getText(), false, false, 3, null) + ":\n";
                Iterator<Unique> iterator3 = branch.getUniqueMap().getUniques(UniqueType.OnlyAvailable).iterator();
                while (iterator3.hasNext()) {
                    Unique unique = iterator3.next();
                    for (Unique conditional : unique.getModifiers()) {
                        warning = warning + "\u2022 " + TranslationsKt.tr$default(conditional.getText(), false, false, 3, null) + '\n';
                    }
                }
                Color color = Color.RED;
                Intrinsics.checkNotNullExpressionValue(color, "RED");
                ColorMarkupLabel warningLabel = new ColorMarkupLabel(warning, color, null, 13, 4, null);
                warningLabel.setAlignment(10);
                warningLabel.setWrap(true);
                this.labelTable.add((Actor)warningLabel).pad(0.0f, 20.0f, 17.0f, 20.0f).grow();
            }
            Cell<Actor> cell2 = this.add((Actor)this.topBtn).growX().pad(10.0f, 10.0f, 0.0f, 10.0f);
            Intrinsics.checkNotNullExpressionValue(cell2, "pad(...)");
            this.topBtnCell = cell2;
            this.row();
            this.group.setWidth(prefWidth);
            this.group.setHeight(prefHeight);
            float startX = 20.0f;
            float endX = prefWidth - 20.0f - 50.0f;
            float deltaX = (endX - startX) / (float)(maxCol - 1);
            float startY = prefHeight - 10.0f - 50.0f;
            float endY = 10.0f;
            float deltaY = (startY - endY) / (float)(maxRow - 1);
            int n3 = maxRow + 1;
            Pair[][] pairArrayArray = new Pair[n3][];
            for (int i = 0; i < n3; ++i) {
                int n4 = i;
                int n5 = 0;
                int n6 = maxCol + 1;
                Pair[] pairArray = new Pair[n6];
                int n7 = n4;
                Pair[][] pairArrayArray2 = pairArrayArray;
                while (n5 < n6) {
                    int n8 = n5++;
                    pairArray[n8] = new Pair<Float, Float>(Float.valueOf(0.0f), Float.valueOf(0.0f));
                }
                pairArrayArray2[n7] = pairArray;
            }
            Pair[][] coords = pairArrayArray;
            int row = 1;
            int col = 0;
            float posX = 0.0f;
            float posY = startY;
            while (row <= maxRow) {
                col = 1;
                posX = startX;
                while (col <= maxCol) {
                    coords[row][col] = new Pair<Float, Float>(Float.valueOf(posX), Float.valueOf(posY));
                    ++col;
                    posX += deltaX;
                }
                ++row;
                posY -= deltaY;
            }
            for (Policy policy2 : branch.getPolicies()) {
                if (policy2.getPolicyBranchType() == Policy.PolicyBranchType.BranchComplete) continue;
                Intrinsics.checkNotNull(policy2);
                PolicyButton button = PolicyPickerScreen.this.getPolicyButton(policy2);
                this.group.addActor(button);
                float policyX = ((Number)coords[policy2.getRow()][policy2.getColumn()].getFirst()).floatValue();
                float policyY = ((Number)coords[policy2.getRow()][policy2.getColumn()].getSecond()).floatValue();
                button.setX(policyX);
                button.setY(policyY);
                ((Map)PolicyPickerScreen.this.policyNameToButton).put(policy2.getName(), button);
            }
            PolicyPickerScreen.this.drawLines(branch);
            Cell<Actor> cell3 = this.add((Actor)this.group).minWidth(prefWidth).expandY().top();
            Intrinsics.checkNotNullExpressionValue(cell3, "top(...)");
            this.groupCell = cell3;
            this.row();
            ActivationExtensionsKt.onClick(this.header, new Function0<Unit>((Object)this){

                @Override
                public final void invoke() {
                    ((BranchGroup)this.receiver).toggle();
                }
            });
            this.pack();
        }

        /*
         * WARNING - void declaration
         */
        public final void toggle() {
            void $this$toggle_u24lambda_u242;
            Image image2;
            float rotate;
            Group newActor = Intrinsics.areEqual(this.groupCell.getActor(), this.group) ? (Group)this.labelTable : this.group;
            float f = rotate = Intrinsics.areEqual(this.groupCell.getActor(), this.group) ? -90.0f : 90.0f;
            if (Intrinsics.areEqual(this.groupCell.getActor(), this.group)) {
                this.topBtnCell.clearActor();
            } else {
                this.topBtnCell.setActor((Actor)this.topBtn);
            }
            this.groupCell.clearActor();
            this.groupCell.setActor((Actor)newActor);
            Object t = this.header.getCells().get(0).getActor();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.ui.Table");
            Cell cell2 = ((Table)t).getCells().get(0);
            Intrinsics.checkNotNull(cell2, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.ui.Cell<com.badlogic.gdx.scenes.scene2d.Actor>");
            Image image3 = image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/BackArrow", null, 2, null);
            Cell cell3 = cell2.clearActor();
            boolean bl = false;
            $this$toggle_u24lambda_u242.setRotation(rotate);
            cell3.setActor((Actor)Scene2dExtensionsKt.toGroup(image2, 10.0f));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/screens/pickerscreens/PolicyPickerScreen$Sizes;", "", "()V", "iconSize", "", "paddingBetweenHor", "paddingBetweenVer", "paddingHorizontal", "paddingVertical", "core"})
    public static final class Sizes {
        @NotNull
        public static final Sizes INSTANCE = new Sizes();
        public static final float paddingVertical = 10.0f;
        public static final float paddingHorizontal = 20.0f;
        public static final float paddingBetweenHor = 10.0f;
        public static final float paddingBetweenVer = 20.0f;
        public static final float iconSize = 50.0f;

        private Sizes() {
        }
    }
}

