/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.savescreens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.StringBuilder;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.MissingModsException;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.files.PlatformSaverLoader;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.popups.LoadingPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.savescreens.Gzip;
import com.unciv.ui.screens.savescreens.LoadOrSaveScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.Log;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0004H\u0002J\b\u0010\u000e\u001a\u00020\u0004H\u0002J\b\u0010\u000f\u001a\u00020\u0004H\u0002J\u001e\u0010\u0010\u001a\u00020\n2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\b\b\u0002\u0010\u0014\u001a\u00020\bH\u0002J\b\u0010\u0015\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\u0017\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\b\u0010\u0018\u001a\u00020\nH\u0016J\f\u0010\u0019\u001a\u00020\n*\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\n*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\f\u0010\u001e\u001a\u00020\n*\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/unciv/ui/screens/savescreens/LoadGameScreen;", "Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen;", "()V", "copySavedGameToClipboardButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "loadMissingModsButton", "missingModsToLoad", "", "", "doubleClickAction", "", "saveGameFile", "Lcom/badlogic/gdx/files/FileHandle;", "getCopyExistingSaveToClipboardButton", "getLoadFromClipboardButton", "getLoadMissingModsButton", "handleLoadGameException", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "primaryText", "loadMissingMods", "onExistingSaveSelected", "onLoadGame", "resetWindowState", "addLoadFromCustomLocationButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "copySaveToClipboard", "Lkotlinx/coroutines/CoroutineScope;", "file", "initRightSideTable", "Companion", "core"})
public final class LoadGameScreen
extends LoadOrSaveScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextButton copySavedGameToClipboardButton = this.getCopyExistingSaveToClipboardButton();
    @NotNull
    private final TextButton loadMissingModsButton = this.getLoadMissingModsButton();
    @NotNull
    private Iterable<String> missingModsToLoad = CollectionsKt.emptyList();
    @NotNull
    private static final String loadGame = "Load game";
    @NotNull
    private static final String loadFromCustomLocation = "Load from custom location";
    @NotNull
    private static final String loadFromClipboard = "Load copied data";
    @NotNull
    private static final String copyExistingSaveToClipboard = "Copy saved game to clipboard";
    @NotNull
    public static final String downloadMissingMods = "Download missing mods";

    public LoadGameScreen() {
        super(null, 1, null);
        this.getErrorLabel().setVisible(false);
        this.getErrorLabel().setWrap(true);
        this.setDefaultCloseAction();
        this.initRightSideTable(this.getRightSideTable());
        ActivationExtensionsKt.onActivation(this.getRightSideButton(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.onLoadGame(this.getSelectedSave());
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.getRightSideButton()).add(KeyCharAndCode.Companion.getRETURN());
        this.getRightSideButton().setVisible(false);
        this.getPickerPane().getBottomTable().setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "LoadGameScreen/BottomTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
        this.getPickerPane().getTopTable().setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "LoadGameScreen/TopTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
    }

    @Override
    public void resetWindowState() {
        super.resetWindowState();
        Scene2dExtensionsKt.disable(this.copySavedGameToClipboardButton);
        this.getRightSideButton().setText(TranslationsKt.tr$default(loadGame, false, false, 3, null));
        Scene2dExtensionsKt.disable(this.getRightSideButton());
    }

    @Override
    public void onExistingSaveSelected(@NotNull FileHandle saveGameFile) {
        Intrinsics.checkNotNullParameter(saveGameFile, "saveGameFile");
        Scene2dExtensionsKt.enable(this.copySavedGameToClipboardButton);
        this.getRightSideButton().setVisible(true);
        this.getRightSideButton().setText(TranslationsKt.tr$default("Load [" + saveGameFile.name() + ']', false, false, 3, null));
        Scene2dExtensionsKt.enable(this.getRightSideButton());
    }

    @Override
    public void doubleClickAction(@NotNull FileHandle saveGameFile) {
        Intrinsics.checkNotNullParameter(saveGameFile, "saveGameFile");
        this.onLoadGame(saveGameFile);
    }

    private final void initRightSideTable(Table $this$initRightSideTable) {
        $this$initRightSideTable.add((Actor)this.getLoadFromClipboardButton()).row();
        this.addLoadFromCustomLocationButton($this$initRightSideTable);
        $this$initRightSideTable.add((Actor)this.getErrorLabel()).width($this$initRightSideTable.getStage().getWidth() / (float)2).center().row();
        $this$initRightSideTable.add((Actor)this.loadMissingModsButton).row();
        $this$initRightSideTable.add((Actor)this.getDeleteSaveButton()).row();
        $this$initRightSideTable.add((Actor)this.copySavedGameToClipboardButton).row();
        $this$initRightSideTable.add((Actor)this.getShowAutosavesCheckbox()).row();
    }

    private final void onLoadGame(FileHandle saveGameFile) {
        if (saveGameFile == null) {
            return;
        }
        LoadingPopup loadingPopup = new LoadingPopup(this);
        Concurrency.run$default(Concurrency.INSTANCE, loadGame, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, saveGameFile, loadingPopup, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ LoadGameScreen this$0;
            final /* synthetic */ FileHandle $saveGameFile;
            final /* synthetic */ LoadingPopup $loadingPopup;
            {
                this.this$0 = $receiver;
                this.$saveGameFile = $saveGameFile;
                this.$loadingPopup = $loadingPopup;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        GameInfo loadedGame = this.this$0.getGame().getFiles().loadGameFromFile(this.$saveGameFile);
                        this.L$0 = $this$run;
                        this.label = 1;
                        Object object3 = UncivGame.loadGame$default(this.this$0.getGame(), loadedGame, null, true, this, 2, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        try {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (UncivShowableException notAPlayer) {
                            ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(notAPlayer, this.$loadingPopup, this.this$0, null){
                                int label;
                                final /* synthetic */ UncivShowableException $notAPlayer;
                                final /* synthetic */ LoadingPopup $loadingPopup;
                                final /* synthetic */ LoadGameScreen this$0;
                                {
                                    this.$notAPlayer = $notAPlayer;
                                    this.$loadingPopup = $loadingPopup;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            String message2 = (String)LoadOrSaveScreen.Helpers.DefaultImpls.getLoadExceptionMessage$default(LoadGameScreen.Companion, this.$notAPlayer, null, null, 6, null).component1();
                                            this.$loadingPopup.reuseWith(message2, true);
                                            LoadGameScreen.handleLoadGameException$default(this.this$0, this.$notAPlayer, null, 2, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                            return Unit.INSTANCE;
                        }
                        catch (Exception ex) {
                            ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$loadingPopup, this.this$0, ex, null){
                                int label;
                                final /* synthetic */ LoadingPopup $loadingPopup;
                                final /* synthetic */ LoadGameScreen this$0;
                                final /* synthetic */ Exception $ex;
                                {
                                    this.$loadingPopup = $loadingPopup;
                                    this.this$0 = $receiver;
                                    this.$ex = $ex;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.$loadingPopup.close();
                                            LoadGameScreen.handleLoadGameException$default(this.this$0, this.$ex, null, 2, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final TextButton getLoadFromClipboardButton() {
        TextButton pasteButton = Scene2dExtensionsKt.toTextButton$default(loadFromClipboard, null, false, 3, null);
        ActivationExtensionsKt.onActivation(pasteButton, new Function0<Unit>(pasteButton, this){
            final /* synthetic */ TextButton $pasteButton;
            final /* synthetic */ LoadGameScreen this$0;
            {
                this.$pasteButton = $pasteButton;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (!Gdx.app.getClipboard().hasContents()) {
                    return;
                }
                this.$pasteButton.setText(TranslationsKt.tr$default("Working...", false, false, 3, null));
                Scene2dExtensionsKt.disable(this.$pasteButton);
                Concurrency.run$default(Concurrency.INSTANCE, "Load copied data", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$pasteButton, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ LoadGameScreen this$0;
                    final /* synthetic */ TextButton $pasteButton;
                    {
                        this.this$0 = $receiver;
                        this.$pasteButton = $pasteButton;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(var1_1);
                                $this$run = (CoroutineScope)this.L$0;
                                v0 = Gdx.app.getClipboard().getContents();
                                Intrinsics.checkNotNullExpressionValue(v0, "getContents(...)");
                                clipboardContentsString = StringsKt.trim((CharSequence)v0).toString();
                                loadedGame = UncivFiles.Companion.gameInfoFromString(clipboardContentsString);
                                this.L$0 = $this$run;
                                this.label = 1;
                                v1 = UncivGame.loadGame$default(this.this$0.getGame(), loadedGame, null, true, this, 2, null);
                                ** if (v1 != var5_2) goto lbl17
lbl16:
                                // 1 sources

                                return var5_2;
lbl17:
                                // 1 sources

                                ** GOTO lbl24
                            }
                            case 1: {
                                $this$run = (CoroutineScope)this.L$0;
                                try {
                                    ResultKt.throwOnFailure($result);
                                    v1 = $result;
                                }
                                catch (Exception ex) {
                                    try {
                                        ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, ex, null){
                                            int label;
                                            final /* synthetic */ LoadGameScreen this$0;
                                            final /* synthetic */ Exception $ex;
                                            {
                                                this.this$0 = $receiver;
                                                this.$ex = $ex;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure(object);
                                                        LoadGameScreen.access$handleLoadGameException(this.this$0, this.$ex, "Could not load game from clipboard!");
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, 1, null);
                                    }
                                    catch (Throwable var3_6) {
                                        ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$pasteButton, null){
                                            int label;
                                            final /* synthetic */ TextButton $pasteButton;
                                            {
                                                this.$pasteButton = $pasteButton;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure(object);
                                                        this.$pasteButton.setText(TranslationsKt.tr$default("Load copied data", false, false, 3, null));
                                                        Scene2dExtensionsKt.enable(this.$pasteButton);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, 1, null);
                                        throw var3_6;
                                    }
                                    ConcurrencyKt.launchOnGLThread$default($this$run, null, new /* invalid duplicate definition of identical inner class */, 1, null);
                                }
lbl24:
                                // 2 sources

                                ConcurrencyKt.launchOnGLThread$default($this$run, null, new /* invalid duplicate definition of identical inner class */, 1, null);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)((Object)function2);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 2, null);
            }
        });
        KeyCharAndCode ctrlV = KeyCharAndCode.Companion.ctrl('v');
        ActivationExtensionsKt.getKeyShortcuts(pasteButton).add(ctrlV);
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)pasteButton, ctrlV, 0.0f, 2, null);
        return pasteButton;
    }

    private final void addLoadFromCustomLocationButton(Table $this$addLoadFromCustomLocationButton) {
        TextButton loadFromCustomLocationButton = Scene2dExtensionsKt.toTextButton$default(loadFromCustomLocation, null, false, 3, null);
        ActivationExtensionsKt.onClick(loadFromCustomLocationButton, new Function0<Unit>(this, loadFromCustomLocationButton){
            final /* synthetic */ LoadGameScreen this$0;
            final /* synthetic */ TextButton $loadFromCustomLocationButton;
            {
                this.this$0 = $receiver;
                this.$loadFromCustomLocationButton = $loadFromCustomLocationButton;
                super(0);
            }

            public final void invoke() {
                this.this$0.getErrorLabel().setVisible(false);
                this.$loadFromCustomLocationButton.setText(TranslationsKt.tr$default("Loading...", false, false, 3, null));
                Scene2dExtensionsKt.disable(this.$loadFromCustomLocationButton);
                Concurrency.run$default(Concurrency.INSTANCE, "Load from custom location", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$loadFromCustomLocationButton, null){
                    int label;
                    final /* synthetic */ LoadGameScreen this$0;
                    final /* synthetic */ TextButton $loadFromCustomLocationButton;
                    {
                        this.this$0 = $receiver;
                        this.$loadFromCustomLocationButton = $loadFromCustomLocationButton;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                this.this$0.getGame().getFiles().loadGameFromCustomLocation((Function1<? super GameInfo, Unit>)new Function1<GameInfo, Unit>(this.this$0){
                                    final /* synthetic */ LoadGameScreen this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull GameInfo it) {
                                        Intrinsics.checkNotNullParameter(it, "it");
                                        Concurrency.run$default(Concurrency.INSTANCE, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, it, null){
                                            int label;
                                            final /* synthetic */ LoadGameScreen this$0;
                                            final /* synthetic */ GameInfo $it;
                                            {
                                                this.this$0 = $receiver;
                                                this.$it = $it;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure(object);
                                                        this.label = 1;
                                                        Object object3 = UncivGame.loadGame$default(this.this$0.getGame(), this.$it, null, true, this, 2, null);
                                                        if (object3 != object2) return Unit.INSTANCE;
                                                        return object2;
                                                    }
                                                    case 1: {
                                                        void $result;
                                                        ResultKt.throwOnFailure($result);
                                                        Object object3 = $result;
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }, 3, null);
                                    }
                                }, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>(this.this$0, this.$loadFromCustomLocationButton){
                                    final /* synthetic */ LoadGameScreen this$0;
                                    final /* synthetic */ TextButton $loadFromCustomLocationButton;
                                    {
                                        this.this$0 = $receiver;
                                        this.$loadFromCustomLocationButton = $loadFromCustomLocationButton;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Exception it) {
                                        Intrinsics.checkNotNullParameter(it, "it");
                                        if (!(it instanceof PlatformSaverLoader.Cancelled)) {
                                            LoadGameScreen.access$handleLoadGameException(this.this$0, it, "Could not load game from custom location!");
                                        }
                                        this.$loadFromCustomLocationButton.setText(TranslationsKt.tr$default("Load from custom location", false, false, 3, null));
                                        Scene2dExtensionsKt.enable(this.$loadFromCustomLocationButton);
                                    }
                                });
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 2, null);
            }
        });
        $this$addLoadFromCustomLocationButton.add((Actor)loadFromCustomLocationButton).row();
    }

    private final TextButton getCopyExistingSaveToClipboardButton() {
        TextButton copyButton2 = Scene2dExtensionsKt.toTextButton$default(copyExistingSaveToClipboard, null, false, 3, null);
        ActivationExtensionsKt.onActivation(copyButton2, new Function0<Unit>(this){
            final /* synthetic */ LoadGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                FileHandle fileHandle = this.this$0.getSelectedSave();
                if (fileHandle == null) {
                    return;
                }
                FileHandle file = fileHandle;
                Concurrency.run$default(Concurrency.INSTANCE, "Copy saved game to clipboard", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, file, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ LoadGameScreen this$0;
                    final /* synthetic */ FileHandle $file;
                    {
                        this.this$0 = $receiver;
                        this.$file = $file;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                CoroutineScope $this$run = (CoroutineScope)this.L$0;
                                LoadGameScreen.access$copySaveToClipboard(this.this$0, $this$run, this.$file);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        function2.L$0 = value;
                        return (Continuation)((Object)function2);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, 2, null);
            }
        });
        Scene2dExtensionsKt.disable(copyButton2);
        KeyCharAndCode ctrlC = KeyCharAndCode.Companion.ctrl('c');
        ActivationExtensionsKt.getKeyShortcuts(copyButton2).add(ctrlC);
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)copyButton2, ctrlC, 0.0f, 2, null);
        return copyButton2;
    }

    private final void copySaveToClipboard(CoroutineScope $this$copySaveToClipboard, FileHandle file) {
        String string;
        try {
            string = file.readString();
        }
        catch (Throwable ex) {
            Pair pair = LoadOrSaveScreen.Helpers.DefaultImpls.getLoadExceptionMessage$default(Companion, ex, "Could not save game to clipboard!", null, 4, null);
            String errorText = (String)pair.component1();
            boolean isUserFixable = (Boolean)pair.component2();
            if (!isUserFixable) {
                Log.INSTANCE.error("Could not save game to clipboard!", ex);
            }
            ConcurrencyKt.launchOnGLThread$default($this$copySaveToClipboard, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(errorText, this, null){
                int label;
                final /* synthetic */ String $errorText;
                final /* synthetic */ LoadGameScreen this$0;
                {
                    this.$errorText = $errorText;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            new ToastPopup(this.$errorText, this.this$0, 0L, 4, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
            return;
        }
        String gameText2 = string;
        try {
            String string2;
            Clipboard clipboard = Gdx.app.getClipboard();
            if (gameText2.charAt(0) == '{') {
                Intrinsics.checkNotNull(gameText2);
                string2 = Gzip.INSTANCE.zip(gameText2);
            } else {
                string2 = gameText2;
            }
            clipboard.setContents(string2);
            ConcurrencyKt.launchOnGLThread$default($this$copySaveToClipboard, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file, this, null){
                int label;
                final /* synthetic */ FileHandle $file;
                final /* synthetic */ LoadGameScreen this$0;
                {
                    this.$file = $file;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            new ToastPopup("'[" + this.$file.name() + "]' copied to clipboard!", this.this$0, 0L, 4, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
        catch (Throwable ex) {
            Log.INSTANCE.error("Could not save game to clipboard!", ex);
            ConcurrencyKt.launchOnGLThread$default($this$copySaveToClipboard, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ LoadGameScreen this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            new ToastPopup("Could not save game to clipboard!", this.this$0, 0L, 4, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        }
    }

    private final TextButton getLoadMissingModsButton() {
        TextButton button = Scene2dExtensionsKt.toTextButton$default(downloadMissingMods, null, false, 3, null);
        ActivationExtensionsKt.onClick(button, new Function0<Unit>(this){
            final /* synthetic */ LoadGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                LoadGameScreen.access$loadMissingMods(this.this$0);
            }
        });
        button.setVisible(false);
        return button;
    }

    private final void handleLoadGameException(Exception ex, String primaryText) {
        boolean isUserFixable = LoadOrSaveScreen.handleException$default(this, ex, primaryText, null, 4, null);
        if (!isUserFixable) {
            Popup cantLoadGamePopup = new Popup(this, null, 0.0f, 6, null);
            Popup.addGoodSizedLabel$default(cantLoadGamePopup, "It looks like your saved game can't be loaded!", 0, false, 6, null).row();
            Popup.addGoodSizedLabel$default(cantLoadGamePopup, "If you could copy your game data (\"Copy saved game to clipboard\" - ", 0, false, 6, null).row();
            Popup.addGoodSizedLabel$default(cantLoadGamePopup, "  paste into an email to yairm210@hotmail.com)", 0, false, 6, null).row();
            Popup.addGoodSizedLabel$default(cantLoadGamePopup, "I could maybe help you figure out what went wrong, since this isn't supposed to happen!", 0, false, 6, null).row();
            Popup.addCloseButton$default(cantLoadGamePopup, null, null, null, null, 15, null);
            Popup.open$default(cantLoadGamePopup, false, 1, null);
        }
        if (ex instanceof MissingModsException) {
            this.loadMissingModsButton.setVisible(true);
            this.missingModsToLoad = ((MissingModsException)ex).getMissingMods();
        }
    }

    static /* synthetic */ void handleLoadGameException$default(LoadGameScreen loadGameScreen, Exception exception2, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "Could not load game!";
        }
        loadGameScreen.handleLoadGameException(exception2, string);
    }

    private final void loadMissingMods() {
        Scene2dExtensionsKt.setEnabled(this.loadMissingModsButton, false);
        this.getDescriptionLabel().setText(TranslationsKt.tr$default("Loading...", false, false, 3, null));
        Concurrency.INSTANCE.runOnNonDaemonThreadPool(downloadMissingMods, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ LoadGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$runOnNonDaemonThreadPool = (CoroutineScope)this.L$0;
                        try {
                            LoadGameScreen.Companion.loadMissingMods(LoadGameScreen.access$getMissingModsToLoad$p(this.this$0), (Function1<? super String, Unit>)new Function1<String, Unit>(this.this$0, $this$runOnNonDaemonThreadPool){
                                final /* synthetic */ LoadGameScreen this$0;
                                final /* synthetic */ CoroutineScope $$this$runOnNonDaemonThreadPool;
                                {
                                    this.this$0 = $receiver;
                                    this.$$this$runOnNonDaemonThreadPool = $$this$runOnNonDaemonThreadPool;
                                    super(1);
                                }

                                public final void invoke(@NotNull String it) {
                                    Intrinsics.checkNotNullParameter(it, "it");
                                    StringBuilder labelText = this.this$0.getDescriptionLabel().getText();
                                    Intrinsics.checkNotNull(labelText);
                                    Intrinsics.checkNotNullExpressionValue(((Appendable)labelText).append('\n'), "append(...)");
                                    labelText.append(TranslationsKt.tr$default('[' + it + "] Downloaded!", false, false, 3, null));
                                    ConcurrencyKt.launchOnGLThread$default(this.$$this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, labelText, null){
                                        int label;
                                        final /* synthetic */ LoadGameScreen this$0;
                                        final /* synthetic */ StringBuilder $labelText;
                                        {
                                            this.this$0 = $receiver;
                                            this.$labelText = $labelText;
                                            super(2, $completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure(object);
                                                    this.this$0.getDescriptionLabel().setText(this.$labelText);
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }, 1, null);
                                }
                            }, new Function0<Unit>($this$runOnNonDaemonThreadPool, this.this$0){
                                final /* synthetic */ CoroutineScope $$this$runOnNonDaemonThreadPool;
                                final /* synthetic */ LoadGameScreen this$0;
                                {
                                    this.$$this$runOnNonDaemonThreadPool = $$this$runOnNonDaemonThreadPool;
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    ConcurrencyKt.launchOnGLThread$default(this.$$this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                        int label;
                                        final /* synthetic */ LoadGameScreen this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(2, $completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object object) {
                                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure(object);
                                                    RulesetCache.loadRulesets$default(RulesetCache.INSTANCE, false, false, 3, null);
                                                    LoadGameScreen.access$setMissingModsToLoad$p(this.this$0, CollectionsKt.emptyList());
                                                    LoadGameScreen.access$getLoadMissingModsButton$p(this.this$0).setVisible(false);
                                                    this.this$0.getErrorLabel().setVisible(false);
                                                    this.this$0.getRightSideTable().pack();
                                                    new ToastPopup("Missing mods are downloaded successfully.", this.this$0, 0L, 4, null);
                                                    return Unit.INSTANCE;
                                                }
                                            }
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        @NotNull
                                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                        }

                                        @Nullable
                                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }, 1, null);
                                }
                            });
                        }
                        catch (Exception ex) {
                            try {
                                ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, ex, null){
                                    int label;
                                    final /* synthetic */ LoadGameScreen this$0;
                                    final /* synthetic */ Exception $ex;
                                    {
                                        this.this$0 = $receiver;
                                        this.$ex = $ex;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure(object);
                                                LoadGameScreen.access$handleLoadGameException(this.this$0, this.$ex, "Could not load the missing mods!");
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 1, null);
                            }
                            catch (Throwable throwable) {
                                ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                    int label;
                                    final /* synthetic */ LoadGameScreen this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure(object);
                                                Scene2dExtensionsKt.setEnabled(LoadGameScreen.access$getLoadMissingModsButton$p(this.this$0), true);
                                                this.this$0.getDescriptionLabel().setText("");
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 1, null);
                                throw throwable;
                            }
                            ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new /* invalid duplicate definition of identical inner class */, 1, null);
                        }
                        ConcurrencyKt.launchOnGLThread$default($this$runOnNonDaemonThreadPool, null, new /* invalid duplicate definition of identical inner class */, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public static final /* synthetic */ void access$handleLoadGameException(LoadGameScreen $this, Exception ex, String primaryText) {
        $this.handleLoadGameException(ex, primaryText);
    }

    public static final /* synthetic */ void access$copySaveToClipboard(LoadGameScreen $this, CoroutineScope $receiver, FileHandle file) {
        $this.copySaveToClipboard($receiver, file);
    }

    public static final /* synthetic */ void access$loadMissingMods(LoadGameScreen $this) {
        $this.loadMissingMods();
    }

    public static final /* synthetic */ Iterable access$getMissingModsToLoad$p(LoadGameScreen $this) {
        return $this.missingModsToLoad;
    }

    public static final /* synthetic */ void access$setMissingModsToLoad$p(LoadGameScreen $this, Iterable iterable) {
        $this.missingModsToLoad = iterable;
    }

    public static final /* synthetic */ TextButton access$getLoadMissingModsButton$p(LoadGameScreen $this) {
        return $this.loadMissingModsButton;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/screens/savescreens/LoadGameScreen$Companion;", "Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen$Helpers;", "()V", "copyExistingSaveToClipboard", "", "downloadMissingMods", "loadFromClipboard", "loadFromCustomLocation", "loadGame", "core"})
    public static final class Companion
    implements LoadOrSaveScreen.Helpers {
        private Companion() {
        }

        @Override
        @NotNull
        public Pair<String, Boolean> getLoadExceptionMessage(@NotNull Throwable ex, @NotNull String primaryText, @Nullable FileHandle file) {
            return LoadOrSaveScreen.Helpers.DefaultImpls.getLoadExceptionMessage(this, ex, primaryText, file);
        }

        @Override
        public void loadMissingMods(@NotNull Iterable<String> missingMods, @NotNull Function1<? super String, Unit> onModDownloaded, @NotNull Function0<Unit> onCompleted) {
            LoadOrSaveScreen.Helpers.DefaultImpls.loadMissingMods(this, missingMods, onModDownloaded, onCompleted);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

