/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.savescreens;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.SerializationException;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfoPreview;
import com.unciv.logic.UncivShowableException;
import com.unciv.logic.civilization.CivilizationInfoPreview;
import com.unciv.logic.files.UncivFiles;
import com.unciv.logic.github.Github;
import com.unciv.logic.github.GithubAPI;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.extensions.UncivDateFormat;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.ui.screens.savescreens.LoadOrSaveScreen;
import com.unciv.ui.screens.savescreens.VerticalFileListScrollPane;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.Log;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 -2\u00020\u0001:\u0002-.B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H&J(\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u00060\"j\u0002`#2\u0006\u0010$\u001a\u00020\u00032\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0014H\u0004J\b\u0010&\u001a\u00020\u001dH\u0002J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H&J\b\u0010(\u001a\u00020\u001dH\u0016J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020 H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006/"}, d2={"Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "fileListHeaderText", "", "(Ljava/lang/String;)V", "deleteSaveButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "getDeleteSaveButton", "()Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "errorLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "getErrorLabel", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "rightSideTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "getRightSideTable", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "savesScrollPane", "Lcom/unciv/ui/screens/savescreens/VerticalFileListScrollPane;", "<set-?>", "Lcom/badlogic/gdx/files/FileHandle;", "selectedSave", "getSelectedSave", "()Lcom/badlogic/gdx/files/FileHandle;", "showAutosavesCheckbox", "Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "getShowAutosavesCheckbox", "()Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "doubleClickAction", "", "saveGameFile", "handleException", "", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "primaryText", "file", "onDeleteClicked", "onExistingSaveSelected", "resetWindowState", "selectExistingSave", "showSaveInfo", "updateShownSaves", "showAutosaves", "Companion", "Helpers", "core"})
public abstract class LoadOrSaveScreen
extends PickerScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private FileHandle selectedSave;
    @NotNull
    private final VerticalFileListScrollPane savesScrollPane;
    @NotNull
    private final Table rightSideTable;
    @NotNull
    private final TextButton deleteSaveButton;
    @NotNull
    private final CheckBox showAutosavesCheckbox;
    @NotNull
    private final Label errorLabel;
    @NotNull
    public static final String saveToClipboardErrorMessage = "Could not save game to clipboard!";

    public LoadOrSaveScreen(@Nullable String fileListHeaderText) {
        super(true);
        this.savesScrollPane = new VerticalFileListScrollPane(null, 1, null);
        this.rightSideTable = new Table();
        this.deleteSaveButton = Scene2dExtensionsKt.toTextButton$default("Delete save", BaseScreen.Companion.getSkin().get("negative", TextButton.TextButtonStyle.class), false, 2, null);
        this.showAutosavesCheckbox = new CheckBox(TranslationsKt.tr$default("Show autosaves", false, false, 3, null), BaseScreen.Companion.getSkin());
        Color color = Color.RED;
        Intrinsics.checkNotNullExpressionValue(color, "RED");
        this.errorLabel = Scene2dExtensionsKt.toLabel$default("", color, 0, 1, false, 10, null);
        this.savesScrollPane.onChange((Function1<? super FileHandle, Unit>)new Function1<FileHandle, Unit>((Object)this){

            @Override
            public final void invoke(@NotNull FileHandle p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((LoadOrSaveScreen)this.receiver).selectExistingSave(p0);
            }
        });
        this.savesScrollPane.onDoubleClick((Function1<? super FileHandle, Unit>)new Function1<FileHandle, Unit>((Object)this){

            @Override
            public final void invoke(@NotNull FileHandle p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                ((LoadOrSaveScreen)this.receiver).doubleClickAction(p0);
            }
        });
        Cell cell2 = this.rightSideTable.defaults();
        Intrinsics.checkNotNullExpressionValue(cell2, "defaults(...)");
        Scene2dExtensionsKt.pad(cell2, 5.0f, 10.0f);
        this.showAutosavesCheckbox.setChecked(UncivGame.Companion.getCurrent().getSettings().getShowAutosaves());
        ActivationExtensionsKt.onChange(this.showAutosavesCheckbox, (Function1<? super ChangeListener.ChangeEvent, Unit>)new Function1<ChangeListener.ChangeEvent, Unit>(){

            @Override
            public final void invoke(@Nullable ChangeListener.ChangeEvent it) {
                this.updateShownSaves(this.getShowAutosavesCheckbox().isChecked());
                UncivGame.Companion.getCurrent().getSettings().setShowAutosaves(this.getShowAutosavesCheckbox().isChecked());
            }
        });
        KeyCharAndCode ctrlA = KeyCharAndCode.Companion.ctrl('a');
        ActivationExtensionsKt.getKeyShortcuts(this.showAutosavesCheckbox).add(ctrlA, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.getShowAutosavesCheckbox().toggle();
            }
        });
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)this.showAutosavesCheckbox, ctrlA, 0.0f, 2, null);
        Scene2dExtensionsKt.disable(this.deleteSaveButton);
        ActivationExtensionsKt.onActivation(this.deleteSaveButton, new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.onDeleteClicked();
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.deleteSaveButton).add(KeyCharAndCode.Companion.getDEL());
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)this.deleteSaveButton, KeyCharAndCode.Companion.getDEL(), 0.0f, 2, null);
        if (fileListHeaderText != null) {
            this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel(fileListHeaderText)).pad(10.0f).row();
        }
        this.updateShownSaves(this.showAutosavesCheckbox.isChecked());
        this.getTopTable().add((Actor)this.savesScrollPane);
        this.getTopTable().add((Actor)this.rightSideTable);
        this.getTopTable().pack();
    }

    public /* synthetic */ LoadOrSaveScreen(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    public abstract void onExistingSaveSelected(@NotNull FileHandle var1);

    public abstract void doubleClickAction(@NotNull FileHandle var1);

    @Nullable
    protected final FileHandle getSelectedSave() {
        return this.selectedSave;
    }

    @NotNull
    protected final Table getRightSideTable() {
        return this.rightSideTable;
    }

    @NotNull
    protected final TextButton getDeleteSaveButton() {
        return this.deleteSaveButton;
    }

    @NotNull
    protected final CheckBox getShowAutosavesCheckbox() {
        return this.showAutosavesCheckbox;
    }

    @NotNull
    protected final Label getErrorLabel() {
        return this.errorLabel;
    }

    public void resetWindowState() {
        this.updateShownSaves(this.showAutosavesCheckbox.isChecked());
        Scene2dExtensionsKt.disable(this.deleteSaveButton);
        this.getDescriptionLabel().setText("");
    }

    private final void onDeleteClicked() {
        if (this.selectedSave == null) {
            return;
        }
        FileHandle fileHandle = this.selectedSave;
        Intrinsics.checkNotNull(fileHandle);
        String name2 = fileHandle.name();
        Popup.open$default(new ConfirmPopup(this, "Are you sure you want to delete this save?", "Delete save", false, null, (Function0)new Function0<Unit>(this, name2){
            final /* synthetic */ LoadOrSaveScreen this$0;
            final /* synthetic */ String $name;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                super(0);
            }

            public final void invoke() {
                String string;
                try {
                    String string2;
                    UncivFiles uncivFiles = this.this$0.getGame().getFiles();
                    FileHandle fileHandle = this.this$0.getSelectedSave();
                    Intrinsics.checkNotNull(fileHandle);
                    if (uncivFiles.deleteSave(fileHandle)) {
                        this.this$0.resetWindowState();
                        string2 = '[' + this.$name + "] deleted successfully.";
                    } else {
                        string2 = "Failed to delete [" + this.$name + "].";
                    }
                    string = string2;
                }
                catch (SecurityException _) {
                    string = "Insufficient permissions to delete [" + this.$name + "].";
                }
                catch (Throwable _) {
                    string = "Failed to delete [" + this.$name + "].";
                }
                String result2 = string;
                this.this$0.getDescriptionLabel().setText(TranslationsKt.tr$default(result2, false, false, 3, null));
            }
        }, 24, null), false, 1, null);
    }

    private final void updateShownSaves(boolean showAutosaves) {
        this.savesScrollPane.updateSaveGames(this.getGame().getFiles(), showAutosaves);
    }

    private final void selectExistingSave(FileHandle saveGameFile) {
        this.errorLabel.setVisible(false);
        Scene2dExtensionsKt.enable(this.deleteSaveButton);
        this.selectedSave = saveGameFile;
        this.showSaveInfo(saveGameFile);
        this.getRightSideButton().setVisible(true);
        this.onExistingSaveSelected(saveGameFile);
    }

    private final void showSaveInfo(FileHandle saveGameFile) {
        this.getDescriptionLabel().setText(TranslationsKt.tr$default("Loading...", false, false, 3, null));
        Concurrency.run$default(Concurrency.INSTANCE, "LoadMetaData", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(saveGameFile, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FileHandle $saveGameFile;
            final /* synthetic */ LoadOrSaveScreen this$0;
            {
                this.$saveGameFile = $saveGameFile;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        String string;
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        try {
                            void $this$filterTo$iv$iv;
                            Date savedAt = new Date(this.$saveGameFile.lastModified());
                            GameInfoPreview game = this.this$0.getGame().getFiles().loadGamePreviewFromFile(this.$saveGameFile);
                            Iterable $this$filter$iv = game.getCivilizations();
                            boolean $i$f$filter = false;
                            Iterable iterable = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                CivilizationInfoPreview it = (CivilizationInfoPreview)element$iv$iv;
                                boolean bl = false;
                                if (!it.isPlayerCivilization()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            String playerCivNames2 = CollectionsKt.joinToString$default((List)destination$iv$iv, null, null, null, 0, null, showSaveInfo.textToSet.playerCivNames.2.INSTANCE, 31, null);
                            String mods = game.getGameParameters().getMods().isEmpty() ? "" : "\n{Mods:} " + CollectionsKt.joinToString$default(game.getGameParameters().getMods(), null, null, null, 0, null, null, 63, null);
                            string = this.$saveGameFile.name() + "\n{Saved at}: " + UncivDateFormat.INSTANCE.formatDate(savedAt) + '\n' + playerCivNames2 + ", " + TranslationsKt.tr$default(game.getDifficulty(), false, false, 3, null) + ", \u23f3" + game.getTurns() + "\n{Base ruleset:} " + game.getGameParameters().getBaseRuleset() + mods;
                        }
                        catch (Exception exception2) {
                            string = "\n{Could not load game}!";
                        }
                        String textToSet2 = string;
                        ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, textToSet2, null){
                            int label;
                            final /* synthetic */ LoadOrSaveScreen this$0;
                            final /* synthetic */ String $textToSet;
                            {
                                this.this$0 = $receiver;
                                this.$textToSet = $textToSet;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure(object);
                                        this.this$0.getDescriptionLabel().setText(TranslationsKt.tr$default(this.$textToSet, false, false, 3, null));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    protected final boolean handleException(@NotNull Exception ex, @NotNull String primaryText, @Nullable FileHandle file) {
        Intrinsics.checkNotNullParameter(ex, "ex");
        Intrinsics.checkNotNullParameter(primaryText, "primaryText");
        Pair<String, Boolean> pair = Companion.getLoadExceptionMessage(ex, primaryText, file);
        String errorText = pair.component1();
        boolean isUserFixable = pair.component2();
        if (!isUserFixable) {
            Log.INSTANCE.error(primaryText, ex);
        }
        this.errorLabel.setText(errorText);
        this.errorLabel.setVisible(true);
        return isUserFixable;
    }

    public static /* synthetic */ boolean handleException$default(LoadOrSaveScreen loadOrSaveScreen, Exception exception2, String string, FileHandle fileHandle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleException");
        }
        if ((n & 4) != 0) {
            fileHandle = null;
        }
        return loadOrSaveScreen.handleException(exception2, string, fileHandle);
    }

    public LoadOrSaveScreen() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen$Companion;", "Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen$Helpers;", "()V", "saveToClipboardErrorMessage", "", "core"})
    public static final class Companion
    implements Helpers {
        private Companion() {
        }

        @Override
        @NotNull
        public Pair<String, Boolean> getLoadExceptionMessage(@NotNull Throwable ex, @NotNull String primaryText, @Nullable FileHandle file) {
            return Helpers.DefaultImpls.getLoadExceptionMessage(this, ex, primaryText, file);
        }

        @Override
        public void loadMissingMods(@NotNull Iterable<String> missingMods, @NotNull Function1<? super String, Unit> onModDownloaded, @NotNull Function0<Unit> onCompleted) {
            Helpers.DefaultImpls.loadMissingMods(this, missingMods, onModDownloaded, onCompleted);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J2\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00042\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J8\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen$Helpers;", "", "getLoadExceptionMessage", "Lkotlin/Pair;", "", "", "ex", "", "primaryText", "file", "Lcom/badlogic/gdx/files/FileHandle;", "loadMissingMods", "", "missingMods", "", "onModDownloaded", "Lkotlin/Function1;", "onCompleted", "Lkotlin/Function0;", "core"})
    public static interface Helpers {
        @NotNull
        public Pair<String, Boolean> getLoadExceptionMessage(@NotNull Throwable var1, @NotNull String var2, @Nullable FileHandle var3);

        public void loadMissingMods(@NotNull Iterable<String> var1, @NotNull Function1<? super String, Unit> var2, @NotNull Function0<Unit> var3);

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        @SourceDebugExtension(value={"SMAP\nLoadOrSaveScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoadOrSaveScreen.kt\ncom/unciv/ui/screens/savescreens/LoadOrSaveScreen$Helpers$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n288#2,2:236\n*S KotlinDebug\n*F\n+ 1 LoadOrSaveScreen.kt\ncom/unciv/ui/screens/savescreens/LoadOrSaveScreen$Helpers$DefaultImpls\n*L\n221#1:236,2\n*E\n"})
        public static final class DefaultImpls {
            @NotNull
            public static Pair<String, Boolean> getLoadExceptionMessage(@NotNull Helpers $this, @NotNull Throwable ex, @NotNull String primaryText, @Nullable FileHandle file) {
                boolean bl;
                Intrinsics.checkNotNullParameter(ex, "ex");
                Intrinsics.checkNotNullParameter(primaryText, "primaryText");
                StringBuilder errorText = new StringBuilder(TranslationsKt.tr$default(primaryText, false, false, 3, null));
                Intrinsics.checkNotNullExpressionValue(errorText.append('\n'), "append(...)");
                Throwable cause = ex;
                while (cause.getCause() != null && cause instanceof GdxRuntimeException) {
                    Intrinsics.checkNotNull(cause.getCause());
                }
                Throwable throwable = cause;
                if (throwable instanceof UncivShowableException) {
                    errorText.append(ex.getLocalizedMessage());
                    bl = true;
                } else if (throwable instanceof SerializationException) {
                    errorText.append(TranslationsKt.tr$default("The file data seems to be corrupted.", false, false, 3, null));
                    bl = false;
                } else if (throwable instanceof FileNotFoundException) {
                    boolean isPermissionDenied;
                    boolean bl2;
                    String localizedMessage = UncivGame.Companion.getCurrent().getSystemErrorMessage(5);
                    String string = cause.getMessage();
                    if (string != null) {
                        String $this$getLoadExceptionMessage_u24lambda_u240 = string;
                        boolean bl3 = false;
                        bl2 = StringsKt.contains$default((CharSequence)$this$getLoadExceptionMessage_u24lambda_u240, "Permission denied", false, 2, null) || localizedMessage != null && StringsKt.contains$default((CharSequence)$this$getLoadExceptionMessage_u24lambda_u240, localizedMessage, false, 2, null);
                    } else {
                        bl2 = isPermissionDenied = false;
                    }
                    if (isPermissionDenied) {
                        if (file != null && DefaultImpls.getLoadExceptionMessage$isReadOnly(file)) {
                            errorText.append(TranslationsKt.tr$default("The file is marked read-only.", false, false, 3, null));
                        } else {
                            errorText.append(TranslationsKt.tr$default("You do not have sufficient permissions to access the file.", false, false, 3, null));
                        }
                    }
                    bl = isPermissionDenied;
                } else {
                    errorText.append(TranslationsKt.tr$default("Unhandled problem, [" + Reflection.getOrCreateKotlinClass(ex.getClass()).getSimpleName() + ' ' + ExceptionsKt.stackTraceToString(ex) + ']', false, false, 3, null));
                    bl = false;
                }
                boolean isUserFixable = bl;
                String string = errorText.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                return new Pair<String, Boolean>(string, isUserFixable);
            }

            public static /* synthetic */ Pair getLoadExceptionMessage$default(Helpers helpers, Throwable throwable, String string, FileHandle fileHandle, int n, Object object) {
                if (object != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLoadExceptionMessage");
                }
                if ((n & 2) != 0) {
                    string = "Could not load game!";
                }
                if ((n & 4) != 0) {
                    fileHandle = null;
                }
                return helpers.getLoadExceptionMessage(throwable, string, fileHandle);
            }

            public static void loadMissingMods(@NotNull Helpers $this, @NotNull Iterable<String> missingMods, @NotNull Function1<? super String, Unit> onModDownloaded, @NotNull Function0<Unit> onCompleted) {
                Intrinsics.checkNotNullParameter(missingMods, "missingMods");
                Intrinsics.checkNotNullParameter(onModDownloaded, "onModDownloaded");
                Intrinsics.checkNotNullParameter(onCompleted, "onCompleted");
                for (String rawName : missingMods) {
                    FileHandle modFolder;
                    GithubAPI.Repo repo;
                    Object v1;
                    String modName;
                    block5: {
                        GithubAPI.RepoSearch repos;
                        Intrinsics.checkNotNullExpressionValue(Github.INSTANCE.folderNameToRepoName(rawName).toLowerCase(Locale.ROOT), "toLowerCase(...)");
                        if (Github.INSTANCE.tryGetGithubReposWithTopic(10, 1, modName) == null) {
                            throw new UncivShowableException("Could not download mod list.", null, 2, null);
                        }
                        Iterable $this$firstOrNull$iv = repos.getItems();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            GithubAPI.Repo it = (GithubAPI.Repo)element$iv;
                            boolean bl = false;
                            String string = it.getName().toLowerCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                            if (!Intrinsics.areEqual(string, modName)) continue;
                            v1 = element$iv;
                            break block5;
                        }
                        v1 = null;
                    }
                    if ((GithubAPI.Repo)v1 == null) {
                        throw new UncivShowableException("Could not find a mod named \"[" + modName + "]\".", null, 2, null);
                    }
                    if (Github.downloadAndExtract$default(Github.INSTANCE, repo, UncivGame.Companion.getCurrent().getFiles().getModsFolder(), null, 4, null) == null) {
                        throw new Exception("Unexpected 404 error");
                    }
                    Github.INSTANCE.rewriteModOptions(repo, modFolder);
                    onModDownloaded.invoke(repo.getName());
                }
                onCompleted.invoke();
            }

            private static boolean getLoadExceptionMessage$isReadOnly(FileHandle $receiver) {
                try {
                    String string = $receiver.file().getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
                    Path path = Paths.get(string, new String[0]);
                    Intrinsics.checkNotNullExpressionValue(path, "get(...)");
                    Path path2 = path;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    DosFileAttributes dosFileAttributes = Files.readAttributes(path2, DosFileAttributes.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue(dosFileAttributes, "readAttributes(...)");
                    DosFileAttributes attr = dosFileAttributes;
                    return attr.isReadOnly();
                }
                catch (Throwable _) {
                    return false;
                }
            }
        }
    }
}

