/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.savescreens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.files.PlatformSaverLoader;
import com.unciv.logic.files.UncivFiles;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.savescreens.LoadOrSaveScreen;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.Log;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0011\u001a\u00020\b*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\b*\u00020\u0012H\u0002J\f\u0010\u0014\u001a\u00020\b*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/unciv/ui/screens/savescreens/SaveGameScreen;", "Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "(Lcom/unciv/logic/GameInfo;)V", "gameNameTextField", "Lcom/unciv/ui/components/widgets/UncivTextField;", "copyToClipboardHandler", "", "doubleClickAction", "saveGameFile", "Lcom/badlogic/gdx/files/FileHandle;", "enableSaveButton", "text", "", "onExistingSaveSelected", "saveGame", "addGameNameField", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "addSaveToCustomLocation", "initRightSideTable", "Companion", "core"})
public final class SaveGameScreen
extends LoadOrSaveScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GameInfo gameInfo;
    @NotNull
    private final UncivTextField gameNameTextField;
    @NotNull
    public static final String nameFieldLabelText = "Saved game name";
    @NotNull
    public static final String saveButtonText = "Save game";
    @NotNull
    public static final String savingText = "Saving...";
    @NotNull
    public static final String saveToCustomText = "Save to custom location";

    public SaveGameScreen(@NotNull GameInfo gameInfo) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        super("Current saves");
        this.gameInfo = gameInfo;
        this.gameNameTextField = new UncivTextField(nameFieldLabelText, null, null, 6, null);
        this.getErrorLabel().setVisible(false);
        this.getErrorLabel().setWrap(true);
        this.setDefaultCloseAction();
        this.initRightSideTable(this.getRightSideTable());
        this.getRightSideButton().setText(TranslationsKt.tr$default(saveButtonText, false, false, 3, null));
        ActivationExtensionsKt.onActivation(this.getRightSideButton(), new Function0<Unit>(){

            @Override
            public final void invoke() {
                UncivFiles uncivFiles = this.getGame().getFiles();
                String string = gameNameTextField.getText();
                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                FileHandle saveGameFile = uncivFiles.getSave(string);
                if (saveGameFile.exists()) {
                    this.doubleClickAction(saveGameFile);
                } else {
                    this.saveGame(saveGameFile);
                }
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.getRightSideButton()).add(KeyCharAndCode.Companion.getRETURN());
        Scene2dExtensionsKt.enable(this.getRightSideButton());
    }

    private final void initRightSideTable(Table $this$initRightSideTable) {
        this.addGameNameField($this$initRightSideTable);
        TextButton copyJsonButton = Scene2dExtensionsKt.toTextButton$default("Copy to clipboard", null, false, 3, null);
        ActivationExtensionsKt.onActivation(copyJsonButton, new Function0<Unit>((Object)this){

            public final void invoke() {
                SaveGameScreen.access$copyToClipboardHandler((SaveGameScreen)this.receiver);
            }
        });
        KeyCharAndCode ctrlC = KeyCharAndCode.Companion.ctrl('c');
        ActivationExtensionsKt.getKeyShortcuts(copyJsonButton).add(ctrlC);
        UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)copyJsonButton, ctrlC, 0.0f, 2, null);
        $this$initRightSideTable.add((Actor)copyJsonButton).row();
        this.addSaveToCustomLocation($this$initRightSideTable);
        $this$initRightSideTable.add((Actor)this.getErrorLabel()).width($this$initRightSideTable.getStage().getWidth() / (float)2).center().row();
        $this$initRightSideTable.row();
        $this$initRightSideTable.add((Actor)this.getDeleteSaveButton()).row();
        $this$initRightSideTable.add((Actor)this.getShowAutosavesCheckbox()).row();
    }

    private final void addGameNameField(Table $this$addGameNameField) {
        this.gameNameTextField.setTextFieldFilter(UncivFiles.Companion.fileNameTextFieldFilter());
        this.gameNameTextField.setTextFieldListener((arg_0, arg_1) -> SaveGameScreen.addGameNameField$lambda$0(this, arg_0, arg_1));
        String defaultSaveName = TranslationsKt.tr$default('[' + this.gameInfo.getCurrentPlayer() + "] - [" + this.gameInfo.getTurns() + "] turns", true, false, 2, null);
        this.gameNameTextField.setText(defaultSaveName);
        this.gameNameTextField.setSelection(0, defaultSaveName.length());
        $this$addGameNameField.add((Actor)Scene2dExtensionsKt.toLabel(nameFieldLabelText)).row();
        $this$addGameNameField.add((Actor)this.gameNameTextField).width(300.0f).row();
    }

    private final void enableSaveButton(String text2) {
        Scene2dExtensionsKt.setEnabled(this.getRightSideButton(), UncivFiles.Companion.isValidFileName(text2));
    }

    private final void copyToClipboardHandler() {
        Concurrency.run$default(Concurrency.INSTANCE, "Copy game to clipboard", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SaveGameScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$run = (CoroutineScope)this.L$0;
                        try {
                            Gdx.app.getClipboard().setContents(UncivFiles.Companion.gameInfoToString$default(UncivFiles.Companion, SaveGameScreen.access$getGameInfo$p(this.this$0), Boxing.boxBoolean(true), false, 4, null));
                            ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ SaveGameScreen this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            new ToastPopup("Current game copied to clipboard!", this.this$0, 0L, 4, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        catch (Throwable ex) {
                            Log.INSTANCE.error("Could not save game to clipboard!", ex);
                            ConcurrencyKt.launchOnGLThread$default($this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ SaveGameScreen this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            new ToastPopup("Could not save game to clipboard!", this.this$0, 0L, 4, null);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void addSaveToCustomLocation(Table $this$addSaveToCustomLocation) {
        TextButton saveToCustomLocation = Scene2dExtensionsKt.toTextButton$default(saveToCustomText, null, false, 3, null);
        ActivationExtensionsKt.onClick(saveToCustomLocation, new Function0<Unit>(saveToCustomLocation, this){
            final /* synthetic */ TextButton $saveToCustomLocation;
            final /* synthetic */ SaveGameScreen this$0;
            {
                this.$saveToCustomLocation = $saveToCustomLocation;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$saveToCustomLocation.setText(TranslationsKt.tr$default("Saving...", false, false, 3, null));
                Scene2dExtensionsKt.disable(this.$saveToCustomLocation);
                this.this$0.getErrorLabel().setVisible(false);
                Concurrency.INSTANCE.runOnNonDaemonThreadPool("Save to custom location", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$saveToCustomLocation, null){
                    int label;
                    final /* synthetic */ SaveGameScreen this$0;
                    final /* synthetic */ TextButton $saveToCustomLocation;
                    {
                        this.this$0 = $receiver;
                        this.$saveToCustomLocation = $saveToCustomLocation;
                        super(2, $completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                UncivFiles uncivFiles = this.this$0.getGame().getFiles();
                                GameInfo gameInfo = SaveGameScreen.access$getGameInfo$p(this.this$0);
                                String string = SaveGameScreen.access$getGameNameTextField$p(this.this$0).getText();
                                Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                                uncivFiles.saveGameToCustomLocation(gameInfo, string, new Function0<Unit>(this.this$0){
                                    final /* synthetic */ SaveGameScreen this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        this.this$0.getGame().popScreen();
                                    }
                                }, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>(this.this$0, this.$saveToCustomLocation){
                                    final /* synthetic */ SaveGameScreen this$0;
                                    final /* synthetic */ TextButton $saveToCustomLocation;
                                    {
                                        this.this$0 = $receiver;
                                        this.$saveToCustomLocation = $saveToCustomLocation;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Exception it) {
                                        Intrinsics.checkNotNullParameter(it, "it");
                                        if (!(it instanceof PlatformSaverLoader.Cancelled)) {
                                            LoadOrSaveScreen.handleException$default(this.this$0, it, "Could not save game to custom location!", null, 4, null);
                                        }
                                        this.$saveToCustomLocation.setText(TranslationsKt.tr$default("Save to custom location", false, false, 3, null));
                                        Scene2dExtensionsKt.enable(this.$saveToCustomLocation);
                                    }
                                });
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                });
            }
        });
        $this$addSaveToCustomLocation.add((Actor)saveToCustomLocation).row();
    }

    private final void saveGame(FileHandle saveGameFile) {
        this.getRightSideButton().setText(TranslationsKt.tr$default(savingText, false, false, 3, null));
        this.getErrorLabel().setVisible(false);
        Concurrency.INSTANCE.runOnNonDaemonThreadPool("SaveGame", (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, saveGameFile, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ SaveGameScreen this$0;
            final /* synthetic */ FileHandle $saveGameFile;
            {
                this.this$0 = $receiver;
                this.$saveGameFile = $saveGameFile;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$runOnNonDaemonThreadPool = (CoroutineScope)this.L$0;
                        this.this$0.getGame().getFiles().saveGame(SaveGameScreen.access$getGameInfo$p(this.this$0), this.$saveGameFile, (Function1<? super Exception, Unit>)new Function1<Exception, Unit>($this$runOnNonDaemonThreadPool, this.this$0){
                            final /* synthetic */ CoroutineScope $$this$runOnNonDaemonThreadPool;
                            final /* synthetic */ SaveGameScreen this$0;
                            {
                                this.$$this$runOnNonDaemonThreadPool = $$this$runOnNonDaemonThreadPool;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@Nullable Exception exception2) {
                                ConcurrencyKt.launchOnGLThread$default(this.$$this$runOnNonDaemonThreadPool, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(exception2, this.this$0, null){
                                    int label;
                                    final /* synthetic */ Exception $exception;
                                    final /* synthetic */ SaveGameScreen this$0;
                                    {
                                        this.$exception = $exception;
                                        this.this$0 = $receiver;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure(object);
                                                if (this.$exception != null) {
                                                    UncivFiles uncivFiles = this.this$0.getGame().getFiles();
                                                    String string = SaveGameScreen.access$getGameNameTextField$p(this.this$0).getText();
                                                    Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
                                                    this.this$0.handleException(this.$exception, "Could not save game!", uncivFiles.getSave(string));
                                                    this.this$0.getRightSideButton().setText(TranslationsKt.tr$default("Save game", false, false, 3, null));
                                                } else {
                                                    UncivGame.Companion.getCurrent().popScreen();
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, 1, null);
                            }
                        });
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    public void onExistingSaveSelected(@NotNull FileHandle saveGameFile) {
        Intrinsics.checkNotNullParameter(saveGameFile, "saveGameFile");
        this.gameNameTextField.setText(saveGameFile.name());
    }

    @Override
    public void doubleClickAction(@NotNull FileHandle saveGameFile) {
        Intrinsics.checkNotNullParameter(saveGameFile, "saveGameFile");
        Popup.open$default(new ConfirmPopup(this, "Overwrite existing file?", "Overwrite", false, null, (Function0)new Function0<Unit>(this, saveGameFile){
            final /* synthetic */ SaveGameScreen this$0;
            final /* synthetic */ FileHandle $saveGameFile;
            {
                this.this$0 = $receiver;
                this.$saveGameFile = $saveGameFile;
                super(0);
            }

            public final void invoke() {
                SaveGameScreen.access$saveGame(this.this$0, this.$saveGameFile);
            }
        }, 24, null), false, 1, null);
    }

    private static final void addGameNameField$lambda$0(SaveGameScreen this$0, TextField textField, char c) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        String string = textField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        this$0.enableSaveButton(string);
    }

    public static final /* synthetic */ void access$copyToClipboardHandler(SaveGameScreen $this) {
        $this.copyToClipboardHandler();
    }

    public static final /* synthetic */ GameInfo access$getGameInfo$p(SaveGameScreen $this) {
        return $this.gameInfo;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/savescreens/SaveGameScreen$Companion;", "Lcom/unciv/ui/screens/savescreens/LoadOrSaveScreen$Helpers;", "()V", "nameFieldLabelText", "", "saveButtonText", "saveToCustomText", "savingText", "core"})
    public static final class Companion
    implements LoadOrSaveScreen.Helpers {
        private Companion() {
        }

        @Override
        @NotNull
        public Pair<String, Boolean> getLoadExceptionMessage(@NotNull Throwable ex, @NotNull String primaryText, @Nullable FileHandle file) {
            return LoadOrSaveScreen.Helpers.DefaultImpls.getLoadExceptionMessage(this, ex, primaryText, file);
        }

        @Override
        public void loadMissingMods(@NotNull Iterable<String> missingMods, @NotNull Function1<? super String, Unit> onModDownloaded, @NotNull Function0<Unit> onCompleted) {
            LoadOrSaveScreen.Helpers.DefaultImpls.loadMissingMods(this, missingMods, onModDownloaded, onCompleted);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

