/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.minimap;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.HexMath;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileHistory;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.utils.DebugUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001*B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010 \u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"J\u0017\u0010#\u001a\u00020$2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0002\u0010%J\u0017\u0010&\u001a\u00020$2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0002\u0010%J\u001f\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u00112\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0002\u0010)R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u0014j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006+"}, d2={"Lcom/unciv/ui/screens/worldscreen/minimap/MinimapTile;", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "tileSize", "", "onClick", "Lkotlin/Function0;", "", "(Lcom/unciv/logic/map/tile/Tile;FLkotlin/jvm/functions/Function0;)V", "cityCircleImage", "Lcom/unciv/ui/images/IconCircleGroup;", "image", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "getImage", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "isUnrevealed", "", "()Z", "neighborToBorderImage", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getOnClick", "()Lkotlin/jvm/functions/Function0;", "owningCiv", "Lcom/unciv/logic/civilization/Civilization;", "getOwningCiv", "()Lcom/unciv/logic/civilization/Civilization;", "setOwningCiv", "(Lcom/unciv/logic/civilization/Civilization;)V", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "getOwningCivFromHistory", "turn", "", "updateBorders", "Lcom/unciv/ui/screens/worldscreen/minimap/MinimapTile$ActorChange;", "(Ljava/lang/Integer;)Lcom/unciv/ui/screens/worldscreen/minimap/MinimapTile$ActorChange;", "updateCityCircle", "updateColor", "isTileUnrevealed", "(ZLjava/lang/Integer;)V", "ActorChange", "core"})
public final class MinimapTile {
    @NotNull
    private final Tile tile;
    @NotNull
    private final Function0<Unit> onClick;
    @NotNull
    private final Image image;
    @Nullable
    private IconCircleGroup cityCircleImage;
    @Nullable
    private Civilization owningCiv;
    @NotNull
    private HashMap<Tile, Image> neighborToBorderImage;

    public MinimapTile(@NotNull Tile tile, float tileSize, @NotNull Function0<Unit> onClick2) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(onClick2, "onClick");
        this.tile = tile;
        this.onClick = onClick2;
        this.image = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Hexagon", null, 2, null);
        this.neighborToBorderImage = new HashMap();
        Vector2 positionalVector = HexMath.INSTANCE.hex2WorldCoords(this.tile.getPosition());
        this.image.setVisible(false);
        this.image.setSize(tileSize, tileSize);
        this.image.setPosition(positionalVector.x * 0.5f * tileSize, positionalVector.y * 0.5f * tileSize);
        ActivationExtensionsKt.onClick(this.image, this.onClick);
    }

    @NotNull
    public final Tile getTile() {
        return this.tile;
    }

    @NotNull
    public final Function0<Unit> getOnClick() {
        return this.onClick;
    }

    @NotNull
    public final Image getImage() {
        return this.image;
    }

    @Nullable
    public final Civilization getOwningCiv() {
        return this.owningCiv;
    }

    public final void setOwningCiv(@Nullable Civilization civilization) {
        this.owningCiv = civilization;
    }

    public final boolean isUnrevealed() {
        return !this.image.isVisible();
    }

    public final void updateColor(boolean isTileUnrevealed, @Nullable Integer turn) {
        Color color;
        Civilization owningCiv;
        this.image.setVisible(DebugUtils.INSTANCE.getVISIBLE_MAP() || !isTileUnrevealed);
        if (!this.image.isVisible()) {
            return;
        }
        boolean isCityCenter = turn == null ? this.tile.isCityCenter() : this.tile.getHistory().getState(turn).getCityCenterType() != TileHistory.TileHistoryState.CityCenterType.None;
        Civilization civilization = owningCiv = turn == null ? this.tile.getOwner() : this.getOwningCivFromHistory(this.tile, turn);
        if (isCityCenter && !this.tile.isWater()) {
            Civilization civilization2 = owningCiv;
            Intrinsics.checkNotNull(civilization2);
            color = civilization2.getNation().getInnerColor();
        } else {
            color = owningCiv != null && !this.tile.isWater() ? owningCiv.getNation().getOuterColor() : this.tile.getBaseTerrain().getColor().lerp(Color.GRAY, 0.5f);
        }
        this.image.setColor(color);
    }

    public static /* synthetic */ void updateColor$default(MinimapTile minimapTile2, boolean bl, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        minimapTile2.updateColor(bl, n);
    }

    @NotNull
    public final ActorChange updateBorders(@Nullable Integer turn) {
        Civilization owningCiv = turn == null ? this.tile.getOwner() : this.getOwningCivFromHistory(this.tile, turn);
        Collection<Image> collection = this.neighborToBorderImage.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Set imagesBefore = CollectionsKt.toSet((Iterable)collection);
        Iterator<Tile> iterator2 = this.tile.getNeighbors().iterator();
        while (iterator2.hasNext()) {
            boolean shouldHaveBorderDisplayed;
            Tile neighbor = iterator2.next();
            Civilization neighborOwningCiv = turn == null ? neighbor.getOwner() : this.getOwningCivFromHistory(neighbor, turn);
            boolean bl = shouldHaveBorderDisplayed = owningCiv != null && !Intrinsics.areEqual(neighborOwningCiv, owningCiv);
            if (!shouldHaveBorderDisplayed) {
                this.neighborToBorderImage.remove(neighbor);
                continue;
            }
            if (((Map)this.neighborToBorderImage).containsKey(neighbor)) {
                Image image2 = this.neighborToBorderImage.get(neighbor);
                Intrinsics.checkNotNull(image2);
                Civilization civilization = owningCiv;
                Intrinsics.checkNotNull(civilization);
                image2.setColor(civilization.getNation().getInnerColor());
                continue;
            }
            Image borderImage = ImageGetter.INSTANCE.getWhiteDot();
            float hexagonEdgeLength = this.image.getWidth() / (float)2;
            borderImage.setSize(hexagonEdgeLength, hexagonEdgeLength / (float)4);
            borderImage.setOrigin(1);
            float hexagonCenterX = this.image.getX() + this.image.getWidth() / (float)2;
            borderImage.setX(hexagonCenterX - borderImage.getWidth() / (float)2);
            float hexagonCenterY = this.image.getY() + this.image.getHeight() / (float)2;
            borderImage.setY(hexagonCenterY - borderImage.getHeight() / (float)2);
            Vector2 relativeWorldPosition = this.tile.getTileMap().getNeighborTilePositionAsWorldCoords(this.tile, neighbor);
            int sign = relativeWorldPosition.x < 0.0f ? -1 : 1;
            float angle = (float)sign * (float)((double)((float)Math.atan((float)sign * relativeWorldPosition.y / relativeWorldPosition.x) * (float)180) / Math.PI - 90.0);
            borderImage.moveBy(-relativeWorldPosition.x * hexagonEdgeLength / (float)2, -relativeWorldPosition.y * hexagonEdgeLength / (float)2);
            borderImage.rotateBy(angle);
            Civilization civilization = owningCiv;
            Intrinsics.checkNotNull(civilization);
            borderImage.setColor(civilization.getNation().getInnerColor());
            ((Map)this.neighborToBorderImage).put(neighbor, borderImage);
        }
        Collection<Image> collection2 = this.neighborToBorderImage.values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Set imagesAfter = CollectionsKt.toSet((Iterable)collection2);
        return new ActorChange(SetsKt.minus(imagesBefore, imagesAfter), SetsKt.minus(imagesAfter, imagesBefore));
    }

    public static /* synthetic */ ActorChange updateBorders$default(MinimapTile minimapTile2, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return minimapTile2.updateBorders(n);
    }

    @NotNull
    public final ActorChange updateCityCircle(@Nullable Integer turn) {
        boolean bl;
        boolean isCityCenter;
        Civilization owningCiv;
        IconCircleGroup prevCircle = this.cityCircleImage;
        Civilization civilization = owningCiv = turn == null ? this.tile.getOwner() : this.getOwningCivFromHistory(this.tile, turn);
        boolean bl2 = turn == null ? this.tile.isCityCenter() : (isCityCenter = this.tile.getHistory().getState(turn).getCityCenterType() != TileHistory.TileHistoryState.CityCenterType.None);
        if (owningCiv == null || !isCityCenter) {
            IconCircleGroup iconCircleGroup = prevCircle;
            return new ActorChange(iconCircleGroup != null ? SetsKt.setOf(iconCircleGroup) : SetsKt.emptySet(), SetsKt.emptySet());
        }
        Nation nation2 = owningCiv.getNation();
        if (turn == null) {
            City city2 = this.tile.getCity();
            Intrinsics.checkNotNull(city2);
            bl = city2.isCapital();
        } else {
            bl = this.tile.getHistory().getState(turn).getCityCenterType() == TileHistory.TileHistoryState.CityCenterType.Capital;
        }
        boolean isCapital = bl;
        float nationIconSize = (isCapital && owningCiv.isMajorCiv() ? 1.667f : 1.25f) * this.image.getWidth();
        IconCircleGroup cityCircle = Scene2dExtensionsKt.surroundWithCircle$default(ImageGetter.getCircle$default(ImageGetter.INSTANCE, nation2.getInnerColor(), null, 2, null), nationIconSize, false, nation2.getOuterColor(), null, 10, null);
        float hexCenterXPosition = this.image.getX() + this.image.getWidth() / (float)2;
        cityCircle.setX(hexCenterXPosition - nationIconSize / (float)2);
        float hexCenterYPosition = this.image.getY() + this.image.getHeight() / (float)2;
        cityCircle.setY(hexCenterYPosition - nationIconSize / (float)2);
        ActivationExtensionsKt.onClick(cityCircle, this.onClick);
        this.cityCircleImage = cityCircle;
        IconCircleGroup iconCircleGroup = prevCircle;
        return new ActorChange(iconCircleGroup != null ? SetsKt.setOf(iconCircleGroup) : SetsKt.emptySet(), SetsKt.setOf(cityCircle));
    }

    public static /* synthetic */ ActorChange updateCityCircle$default(MinimapTile minimapTile2, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return minimapTile2.updateCityCircle(n);
    }

    @Nullable
    public final Civilization getOwningCivFromHistory(@NotNull Tile tile, int turn) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        String owningCivName = tile.getHistory().getState(turn).getOwningCivName();
        return owningCivName == null ? null : tile.getTileMap().getGameInfo().getCivilization(owningCivName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/unciv/ui/screens/worldscreen/minimap/MinimapTile$ActorChange;", "", "removed", "", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "added", "(Ljava/util/Set;Ljava/util/Set;)V", "getAdded", "()Ljava/util/Set;", "getRemoved", "updateActorsIn", "", "group", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "core"})
    @SourceDebugExtension(value={"SMAP\nMinimapTile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinimapTile.kt\ncom/unciv/ui/screens/worldscreen/minimap/MinimapTile$ActorChange\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1855#2,2:151\n1855#2,2:153\n*S KotlinDebug\n*F\n+ 1 MinimapTile.kt\ncom/unciv/ui/screens/worldscreen/minimap/MinimapTile$ActorChange\n*L\n54#1:151,2\n55#1:153,2\n*E\n"})
    public static final class ActorChange {
        @NotNull
        private final Set<Actor> removed;
        @NotNull
        private final Set<Actor> added;

        public ActorChange(@NotNull Set<? extends Actor> removed, @NotNull Set<? extends Actor> added) {
            Intrinsics.checkNotNullParameter(removed, "removed");
            Intrinsics.checkNotNullParameter(added, "added");
            this.removed = removed;
            this.added = added;
        }

        @NotNull
        public final Set<Actor> getRemoved() {
            return this.removed;
        }

        @NotNull
        public final Set<Actor> getAdded() {
            return this.added;
        }

        public final void updateActorsIn(@NotNull Group group) {
            Actor it;
            Intrinsics.checkNotNullParameter(group, "group");
            Iterable $this$forEach$iv = this.removed;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Actor)element$iv;
                boolean bl = false;
                group.removeActor(it);
            }
            $this$forEach$iv = this.added;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Actor)element$iv;
                boolean bl = false;
                group.addActor(it);
            }
        }
    }
}

