/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.logic.city.City;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Spy;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.images.IconTextButtonKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.IdleUnitButton;
import com.unciv.ui.screens.worldscreen.unit.presenter.CityPresenter;
import com.unciv.ui.screens.worldscreen.unit.presenter.SpyPresenter;
import com.unciv.ui.screens.worldscreen.unit.presenter.SummaryPresenter;
import com.unciv.ui.screens.worldscreen.unit.presenter.UnitPresenter;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001ZB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010L\u001a\u00020*2\u0006\u0010M\u001a\u00020\u001fJ\b\u0010N\u001a\u00020OH\u0002J\u0010\u0010P\u001a\u00020O2\b\u0010Q\u001a\u0004\u0018\u00010#J\u001c\u0010R\u001a\u00020O2\n\b\u0002\u0010S\u001a\u0004\u0018\u00010'2\b\b\u0002\u0010T\u001a\u00020*J\u001a\u0010U\u001a\u00020O2\u0006\u0010V\u001a\u00020W2\n\b\u0002\u0010X\u001a\u0004\u0018\u00010'J\u0006\u0010Y\u001a\u00020OR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000fR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u0004\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R$\u0010+\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R$\u00100\u001a\u00020*2\u0006\u0010\u0010\u001a\u00020*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010-\"\u0004\b2\u0010/R\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020'048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\fR\u001a\u00109\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010-\"\u0004\b;\u0010/R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010@\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u000fR\u0014\u0010B\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u000fR\u0014\u0010D\u001a\u00020EX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010K\u00a8\u0006["}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/UnitTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;)V", "bg", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "cityPresenter", "Lcom/unciv/ui/screens/worldscreen/unit/presenter/CityPresenter;", "closeButton", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getCloseButton$core", "()Lcom/badlogic/gdx/scenes/scene2d/Actor;", "descriptionTable", "getDescriptionTable$core", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "value", "", "nameLabelText", "getNameLabelText", "()Ljava/lang/String;", "setNameLabelText", "(Ljava/lang/String;)V", "nextIdleUnitButton", "Lcom/unciv/ui/screens/worldscreen/unit/IdleUnitButton;", "presenter", "Lcom/unciv/ui/screens/worldscreen/unit/UnitTable$Presenter;", "prevIdleUnitButton", "promotionsTable", "getPromotionsTable$core", "selectedCity", "Lcom/unciv/logic/city/City;", "getSelectedCity", "()Lcom/unciv/logic/city/City;", "selectedSpy", "Lcom/unciv/models/Spy;", "getSelectedSpy", "()Lcom/unciv/models/Spy;", "selectedUnit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getSelectedUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "", "selectedUnitIsConnectingRoad", "getSelectedUnitIsConnectingRoad", "()Z", "setSelectedUnitIsConnectingRoad", "(Z)V", "selectedUnitIsSwapping", "getSelectedUnitIsSwapping", "setSelectedUnitIsSwapping", "selectedUnits", "", "getSelectedUnits", "()Ljava/util/List;", "separator", "getSeparator$core", "shouldUpdate", "getShouldUpdate", "setShouldUpdate", "spyPresenter", "Lcom/unciv/ui/screens/worldscreen/unit/presenter/SpyPresenter;", "summaryPresenter", "Lcom/unciv/ui/screens/worldscreen/unit/presenter/SummaryPresenter;", "unitIconHolder", "getUnitIconHolder$core", "unitIconNameGroup", "getUnitIconNameGroup$core", "unitNameLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "getUnitNameLabel$core", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "unitPresenter", "Lcom/unciv/ui/screens/worldscreen/unit/presenter/UnitPresenter;", "getWorldScreen", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "citySelected", "city", "resetUnitTable", "", "selectSpy", "spy", "selectUnit", "unit", "append", "tileSelected", "selectedTile", "Lcom/unciv/logic/map/tile/Tile;", "forceSelectUnit", "update", "Presenter", "core"})
@SourceDebugExtension(value={"SMAP\nUnitTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitTable.kt\ncom/unciv/ui/screens/worldscreen/unit/UnitTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,283:1\n1#2:284\n*E\n"})
public final class UnitTable
extends Table {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final IdleUnitButton prevIdleUnitButton;
    @NotNull
    private final IdleUnitButton nextIdleUnitButton;
    @NotNull
    private final Table unitIconHolder;
    @NotNull
    private final Label unitNameLabel;
    @NotNull
    private final Table unitIconNameGroup;
    @NotNull
    private final Table promotionsTable;
    @NotNull
    private final Table descriptionTable;
    @NotNull
    private final Actor closeButton;
    @NotNull
    private final Actor separator;
    @NotNull
    private Presenter presenter;
    @NotNull
    private final UnitPresenter unitPresenter;
    @NotNull
    private final CityPresenter cityPresenter;
    @NotNull
    private final SpyPresenter spyPresenter;
    @NotNull
    private final SummaryPresenter summaryPresenter;
    private boolean shouldUpdate;
    @NotNull
    private Image bg;

    /*
     * WARNING - void declaration
     */
    public UnitTable(@NotNull WorldScreen worldScreen) {
        void $this$_init__u24lambda_u246;
        Table table2;
        Actor $this$promotionsTable_u24lambda_u241;
        Actor $this$unitNameLabel_u24lambda_u240;
        Actor actor;
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        this.worldScreen = worldScreen;
        this.prevIdleUnitButton = new IdleUnitButton(this, this.worldScreen.getMapHolder(), true, KeyboardBinding.PrevIdleButton);
        this.nextIdleUnitButton = new IdleUnitButton(this, this.worldScreen.getMapHolder(), false, KeyboardBinding.NextIdleButton);
        this.unitIconHolder = new Table();
        Label label2 = actor = Scene2dExtensionsKt.toLabel$default("", null, 24, 0, false, 13, null);
        UnitTable unitTable = this;
        boolean bl = false;
        $this$unitNameLabel_u24lambda_u240.setAlignment(1);
        unitTable.unitNameLabel = actor;
        this.unitIconNameGroup = new Table();
        $this$unitNameLabel_u24lambda_u240 = actor = new Table();
        unitTable = this;
        boolean bl2 = false;
        ((Table)$this$promotionsTable_u24lambda_u241).defaults().padRight(5.0f);
        unitTable.promotionsTable = actor;
        this.descriptionTable = new Table(BaseScreen.Companion.getSkin());
        this.unitPresenter = new UnitPresenter(this, this.worldScreen);
        this.cityPresenter = new CityPresenter(this, this.unitPresenter);
        this.spyPresenter = new SpyPresenter(this);
        this.summaryPresenter = new SummaryPresenter(this);
        this.bg = new Image(BaseScreen.Companion.getSkinStrings().getUiBackground("WorldScreen/UnitTable", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidShape(), Scene2dExtensionsKt.darken(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 0.5f)));
        this.presenter = this.summaryPresenter;
        this.pad(5.0f);
        this.setTouchable(Touchable.enabled);
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "WorldScreen/UnitTable", BaseScreen.Companion.getSkinStrings().getRoundedEdgeRectangleMidShape(), null, 4, null));
        this.addActor(this.bg);
        this.promotionsTable.setTouchable(Touchable.enabled);
        this.closeButton = Scene2dExtensionsKt.addRoundCloseButton(this, new Function0<Unit>(){

            @Override
            public final void invoke() {
                UnitTable.selectUnit$default(this, null, false, 3, null);
                this.getWorldScreen().setShouldUpdate(true);
            }
        });
        ActivationExtensionsKt.getKeyShortcuts(this.closeButton).clear();
        $this$promotionsTable_u24lambda_u241 = actor = new Table();
        unitTable = this;
        boolean bl3 = false;
        Table $this$lambda_u246_u24lambda_u245 = table2 = new Table();
        boolean bl4 = false;
        $this$lambda_u246_u24lambda_u245.add((Actor)this.prevIdleUnitButton);
        this.unitIconNameGroup.add((Actor)this.unitIconHolder);
        Cell<Actor> cell2 = this.unitIconNameGroup.add((Actor)this.unitNameLabel);
        Intrinsics.checkNotNullExpressionValue(cell2, "add(...)");
        IconTextButtonKt.padTopDescent(cell2);
        this.unitIconHolder.setTouchable(Touchable.enabled);
        this.unitNameLabel.setTouchable(Touchable.enabled);
        $this$lambda_u246_u24lambda_u245.add((Actor)this.unitIconNameGroup);
        $this$lambda_u246_u24lambda_u245.add((Actor)this.nextIdleUnitButton);
        Table moveBetweenUnitsTable = table2;
        $this$_init__u24lambda_u246.add((Actor)moveBetweenUnitsTable).fill().row();
        Object t = Scene2dExtensionsKt.addSeparator$default((Table)$this$_init__u24lambda_u246, null, 0, 0.0f, 7, null).padBottom(5.0f).getActor();
        Intrinsics.checkNotNull(t);
        this.separator = t;
        $this$_init__u24lambda_u246.add((Actor)this.promotionsTable).row();
        $this$_init__u24lambda_u246.add((Actor)this.descriptionTable);
        $this$_init__u24lambda_u246.setTouchable(Touchable.enabled);
        ActivationExtensionsKt.onClick((Actor)$this$_init__u24lambda_u246, new Function0<Unit>(this){
            final /* synthetic */ UnitTable this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    Vector2 vector2 = UnitTable.access$getPresenter$p(this.this$0).getPosition();
                    if (vector2 == null) break block0;
                    Vector2 vector22 = vector2;
                    UnitTable unitTable = this.this$0;
                    Vector2 it = vector22;
                    boolean bl = false;
                    WorldMapHolder.setCenterPosition$default(unitTable.getWorldScreen().getMapHolder(), it, false, false, null, 8, null);
                }
            }
        });
        unitTable.add((Actor)actor).expand();
    }

    @NotNull
    public final WorldScreen getWorldScreen() {
        return this.worldScreen;
    }

    @NotNull
    public final Table getUnitIconHolder$core() {
        return this.unitIconHolder;
    }

    @NotNull
    public final Label getUnitNameLabel$core() {
        return this.unitNameLabel;
    }

    @NotNull
    public final Table getUnitIconNameGroup$core() {
        return this.unitIconNameGroup;
    }

    @NotNull
    public final Table getPromotionsTable$core() {
        return this.promotionsTable;
    }

    @NotNull
    public final Table getDescriptionTable$core() {
        return this.descriptionTable;
    }

    @NotNull
    public final Actor getCloseButton$core() {
        return this.closeButton;
    }

    @NotNull
    public final Actor getSeparator$core() {
        return this.separator;
    }

    public final boolean getShouldUpdate() {
        return this.shouldUpdate;
    }

    public final void setShouldUpdate(boolean bl) {
        this.shouldUpdate = bl;
    }

    @Nullable
    public final MapUnit getSelectedUnit() {
        Presenter it = this.presenter;
        boolean bl = false;
        return it instanceof UnitPresenter ? ((UnitPresenter)it).getSelectedUnit() : null;
    }

    @Nullable
    public final City getSelectedCity() {
        Presenter it = this.presenter;
        boolean bl = false;
        return it instanceof CityPresenter ? ((CityPresenter)it).getSelectedCity() : null;
    }

    @Nullable
    public final Spy getSelectedSpy() {
        Presenter it = this.presenter;
        boolean bl = false;
        return it instanceof SpyPresenter ? ((SpyPresenter)it).getSelectedSpy() : null;
    }

    @NotNull
    public final List<MapUnit> getSelectedUnits() {
        return this.unitPresenter.getSelectedUnits();
    }

    public final boolean getSelectedUnitIsSwapping() {
        return this.unitPresenter.getSelectedUnitIsSwapping();
    }

    public final void setSelectedUnitIsSwapping(boolean value) {
        this.unitPresenter.setSelectedUnitIsSwapping(value);
    }

    public final boolean getSelectedUnitIsConnectingRoad() {
        return this.unitPresenter.getSelectedUnitIsConnectingRoad();
    }

    public final void setSelectedUnitIsConnectingRoad(boolean value) {
        this.unitPresenter.setSelectedUnitIsConnectingRoad(value);
    }

    @NotNull
    public final String getNameLabelText() {
        String string = this.unitNameLabel.getText().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public final void setNameLabelText(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!Intrinsics.areEqual(this.getNameLabelText(), value)) {
            this.unitNameLabel.setText(value);
            this.shouldUpdate = true;
        }
    }

    public final void selectUnit(@Nullable MapUnit unit, boolean append2) {
        this.presenter = unit != null ? (Presenter)this.unitPresenter : (Presenter)this.summaryPresenter;
        this.unitPresenter.selectUnit(unit, append2);
        this.resetUnitTable();
    }

    public static /* synthetic */ void selectUnit$default(UnitTable unitTable, MapUnit mapUnit, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            mapUnit = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        unitTable.selectUnit(mapUnit, bl);
    }

    public final void selectSpy(@Nullable Spy spy) {
        this.presenter = this.spyPresenter;
        this.spyPresenter.selectSpy(spy);
        this.resetUnitTable();
    }

    public final boolean citySelected(@NotNull City city2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(city2, "city");
        this.presenter = this.cityPresenter;
        boolean it = bl = this.cityPresenter.selectCity(city2);
        boolean bl2 = false;
        this.resetUnitTable();
        this.worldScreen.setShouldUpdate(true);
        return bl;
    }

    public final void update() {
        this.closeButton.setVisible(true);
        if (!this.presenter.shouldBeShown()) {
        }
        this.presenter.update();
        if (SequencesKt.any(this.worldScreen.getViewingCiv().getUnits().getIdleUnits())) {
            this.prevIdleUnitButton.enable();
            this.nextIdleUnitButton.enable();
        } else {
            this.prevIdleUnitButton.disable();
            this.nextIdleUnitButton.disable();
        }
        if (!this.shouldUpdate) {
            return;
        }
        this.resetUnitTable();
        this.presenter.updateWhenNeeded();
        this.pack();
        this.closeButton.setPosition(this.getWidth() - this.closeButton.getWidth() * (float)3 / (float)4, this.getHeight() - this.closeButton.getHeight() * (float)3 / (float)4);
        this.closeButton.toFront();
        this.bg.setSize(this.getWidth() - 3.0f, this.getHeight() - 3.0f);
        Scene2dExtensionsKt.center((Actor)this.bg, this);
        this.shouldUpdate = false;
    }

    private final void resetUnitTable() {
        this.unitIconHolder.clear();
        this.promotionsTable.clear();
        this.descriptionTable.clearListeners();
        this.separator.setWidth(0.0f);
        this.shouldUpdate = true;
    }

    public final void tileSelected(@NotNull Tile selectedTile, @Nullable MapUnit forceSelectUnit) {
        Intrinsics.checkNotNullParameter(selectedTile, "selectedTile");
        MapUnit previouslySelectedUnit = this.getSelectedUnit();
        int previousNumberOfSelectedUnits = this.getSelectedUnits().size();
        if (this.getSelectedUnitIsSwapping() && this.getSelectedUnit() != null) {
            MapUnit mapUnit = this.getSelectedUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (mapUnit.getMovement().canUnitSwapTo(selectedTile)) {
                return;
            }
        }
        if (this.getSelectedUnit() != null) {
            MapUnit mapUnit = this.getSelectedUnit();
            Intrinsics.checkNotNull(mapUnit);
            if (mapUnit.isPreparingAirSweep()) {
                return;
            }
        }
        MapUnit civUnit = selectedTile.getCivilianUnit();
        MapUnit milUnit = selectedTile.getMilitaryUnit();
        MapUnit curUnit = this.getSelectedUnit();
        MapUnit nextUnit = null;
        MapUnit priorityUnit = milUnit != null && UnitTable.tileSelected$isEligible(milUnit, this) ? milUnit : (civUnit != null && UnitTable.tileSelected$isEligible(civUnit, this) ? civUnit : null);
        nextUnit = curUnit == null ? priorityUnit : (Intrinsics.areEqual(curUnit, civUnit) && milUnit != null && UnitTable.tileSelected$isEligible(milUnit, this) ? null : (Intrinsics.areEqual(curUnit, milUnit) && civUnit != null && UnitTable.tileSelected$isEligible(civUnit, this) ? civUnit : priorityUnit));
        boolean isCitySelected = selectedTile.isCityCenter() && (Intrinsics.areEqual(selectedTile.getOwner(), this.worldScreen.getViewingCiv()) || this.worldScreen.getViewingCiv().isSpectator()) && !this.getSelectedUnitIsConnectingRoad();
        MapUnit mapUnit = forceSelectUnit;
        if (mapUnit != null) {
            UnitTable.selectUnit$default(this, mapUnit, false, 2, null);
        } else if (isCitySelected) {
            City city2 = selectedTile.getCity();
            Intrinsics.checkNotNull(city2);
            this.citySelected(city2);
        } else {
            MapUnit mapUnit2 = nextUnit;
            if (mapUnit2 != null) {
                Input input2 = Gdx.input;
                Intrinsics.checkNotNullExpressionValue(input2, "input");
                this.selectUnit(mapUnit2, Scene2dExtensionsKt.isShiftKeyPressed(input2));
            } else {
                MapUnit mapUnit3 = previouslySelectedUnit;
                if (Intrinsics.areEqual(selectedTile, mapUnit3 != null ? mapUnit3.getCurrentTile() : null)) {
                    UnitTable.selectUnit$default(this, null, false, 3, null);
                    this.shouldUpdate = true;
                }
            }
        }
        if (!Intrinsics.areEqual(this.getSelectedUnit(), previouslySelectedUnit) || this.getSelectedUnits().size() != previousNumberOfSelectedUnits) {
            this.shouldUpdate = true;
        }
    }

    public static /* synthetic */ void tileSelected$default(UnitTable unitTable, Tile tile, MapUnit mapUnit, int n, Object object) {
        if ((n & 2) != 0) {
            mapUnit = null;
        }
        unitTable.tileSelected(tile, mapUnit);
    }

    private static final boolean tileSelected$isEligible(MapUnit $this$tileSelected_u24isEligible, UnitTable this$0) {
        return (Intrinsics.areEqual($this$tileSelected_u24isEligible.getCiv(), this$0.worldScreen.getViewingCiv()) || this$0.worldScreen.getViewingCiv().isSpectator()) && !this$0.getSelectedUnits().contains($this$tileSelected_u24isEligible);
    }

    public static final /* synthetic */ Presenter access$getPresenter$p(UnitTable $this) {
        return $this.presenter;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/UnitTable$Presenter;", "", "position", "Lcom/badlogic/gdx/math/Vector2;", "getPosition", "()Lcom/badlogic/gdx/math/Vector2;", "shouldBeShown", "", "update", "", "updateWhenNeeded", "core"})
    public static interface Presenter {
        @Nullable
        public Vector2 getPosition();

        public void update();

        public void updateWhenNeeded();

        public boolean shouldBeShown();

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            public static void update(@NotNull Presenter $this) {
            }

            public static void updateWhenNeeded(@NotNull Presenter $this) {
            }

            public static boolean shouldBeShown(@NotNull Presenter $this) {
                return true;
            }
        }
    }
}

