/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit.actions;

import com.unciv.Constants;
import com.unciv.GUI;
import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.transients.CivInfoTransientCache;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.ImprovementBuildingProblem;
import com.unciv.logic.map.tile.RoadStatus;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Counter;
import com.unciv.models.UncivSound;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueTriggerActivation;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stat;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.screens.pickerscreens.ImprovementPickerScreen;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionModifiers;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsFromUniques;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ#\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\fJ#\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000eJ#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0010J\u001f\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0012J#\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0014J#\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0016J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ#\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0019J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\tH\u0002J#\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J#\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b%J#\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b'J#\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b)J#\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b+J\u001a\u0010,\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006-"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsFromUniques;", "", "()V", "getAddInCapitalActions", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/UnitAction;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "getAddInCapitalActions$core", "getAirSweepActions", "getAirSweepActions$core", "getBuildingImprovementsActions", "getBuildingImprovementsActions$core", "getConnectRoadActions", "getConnectRoadActions$core", "getFoundCityAction", "getFoundCityAction$core", "getFoundCityActions", "getFoundCityActions$core", "getGuardActions", "getGuardActions$core", "getImprovementConstructionActionsFromGeneralUnique", "getImprovementCreationActions", "getImprovementCreationActions$core", "getLeadersWePromisedNotToSettleNear", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "getParadropActions", "getParadropActions$core", "getRepairAction", "getRepairActions", "getRepairActions$core", "getRepairTurns", "", "getRepairTurns$core", "getSetupActions", "getSetupActions$core", "getTransformActions", "getTransformActions$core", "getTriggerUniqueActions", "getTriggerUniqueActions$core", "getWaterImprovementAction", "core"})
@SourceDebugExtension(value={"SMAP\nUnitActionsFromUniques.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitActionsFromUniques.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsFromUniques\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,504:1\n1747#2,3:505\n766#2:509\n857#2,2:510\n766#2:512\n857#2,2:513\n1747#2,3:515\n1#3:508\n*S KotlinDebug\n*F\n+ 1 UnitActionsFromUniques.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsFromUniques\n*L\n55#1:505,3\n123#1:509\n123#1:510,2\n124#1:512\n124#1:513,2\n446#1:515,3\n*E\n"})
public final class UnitActionsFromUniques {
    @NotNull
    public static final UnitActionsFromUniques INSTANCE = new UnitActionsFromUniques();

    private UnitActionsFromUniques() {
    }

    @NotNull
    public final Sequence<UnitAction> getFoundCityActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        UnitAction[] unitActionArray = new UnitAction[]{this.getFoundCityAction$core(unit, tile)};
        return SequencesKt.filterNotNull(SequencesKt.sequenceOf(unitActionArray));
    }

    @Nullable
    public final UnitAction getFoundCityAction$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Object element$iv2;
        boolean bl;
        Unique unique;
        block8: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(tile, "tile");
            Unique unique2 = SequencesKt.firstOrNull(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(unit, UniqueType.FoundCity));
            if (unique2 == null && (unique2 = SequencesKt.firstOrNull(UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(unit, UniqueType.FoundPuppetCity))) == null) {
                return null;
            }
            unique = unique2;
            if (tile.isWater() || tile.isImpassible()) {
                return null;
            }
            if (unit.getCiv().isOneCityChallenger() && unit.getCiv().getHasEverOwnedOriginalCapital()) {
                return null;
            }
            if (!unit.hasMovement() || !tile.canBeSettled()) {
                return new UnitAction(UnitActionType.FoundCity, 80.0f, null, false, null, null, null, 60, null);
            }
            Iterable $this$any$iv = unique.getModifiers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    Unique it = (Unique)element$iv2;
                    boolean bl2 = false;
                    Object object = it.getType();
                    boolean bl3 = object != null && (object = object.getTargetTypes()) != null ? ((HashSet)object).contains((Object)UniqueTarget.UnitActionModifier) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        boolean hasActionModifiers = bl;
        Function0 foundAction2 = new Function0<Unit>(unit, unique, tile, hasActionModifiers){
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ Unique $unique;
            final /* synthetic */ Tile $tile;
            final /* synthetic */ boolean $hasActionModifiers;
            {
                this.$unit = $unit;
                this.$unique = $unique;
                this.$tile = $tile;
                this.$hasActionModifiers = $hasActionModifiers;
                super(0);
            }

            public final void invoke() {
                if (this.$unit.getCiv().getPlayerType() != PlayerType.AI) {
                    UncivGame.Companion.getCurrent().getSettings().addCompletedTutorialTask(this.$unique.getText());
                }
                City city2 = this.$unit.getCiv().addCity(this.$tile.getPosition(), this.$unit);
                if (this.$hasActionModifiers) {
                    UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, this.$unit, this.$unique, false, 4, null);
                } else {
                    MapUnit.destroy$default(this.$unit, false, 1, null);
                }
                GUI.INSTANCE.setUpdateWorldOnNextRender();
                if (this.$unique.getType() == UniqueType.FoundPuppetCity) {
                    city2.setPuppet(true);
                }
            }
        };
        if (unit.getCiv().getPlayerType() == PlayerType.AI) {
            return new UnitAction(UnitActionType.FoundCity, 80.0f, null, false, null, null, foundAction2, 60, null);
        }
        String title = hasActionModifiers ? UnitActionModifiers.INSTANCE.actionTextWithSideEffects(UnitActionType.FoundCity.getValue(), unique, unit) : UnitActionType.FoundCity.getValue();
        Function0<Unit> function0 = new Function0<Unit>(unit, tile, (Function0<Unit>)foundAction2){
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ Tile $tile;
            final /* synthetic */ Function0<Unit> $foundAction;
            {
                this.$unit = $unit;
                this.$tile = $tile;
                this.$foundAction = $foundAction;
                super(0);
            }

            public final void invoke() {
                String leadersPromisedNotToSettleNear = UnitActionsFromUniques.access$getLeadersWePromisedNotToSettleNear(UnitActionsFromUniques.INSTANCE, this.$unit.getCiv(), this.$tile);
                if (leadersPromisedNotToSettleNear == null) {
                    this.$foundAction.invoke();
                } else {
                    String text2 = "Do you want to break your promise to [" + leadersPromisedNotToSettleNear + "]?";
                    new ConfirmPopup(GUI.INSTANCE.getWorldScreen(), text2, "Break promise", false, null, this.$foundAction, 24, null).open(true);
                }
            }
        };
        element$iv2 = function0;
        Unique unique3 = unique;
        UncivSound uncivSound = UncivSound.Companion.getChimes();
        boolean bl4 = false;
        String string = title;
        float f = 80.0f;
        UnitActionType unitActionType = UnitActionType.FoundCity;
        boolean bl5 = false;
        boolean bl6 = UnitActionModifiers.INSTANCE.canActivateSideEffects(unit, unique);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        Function0 function02 = (Function0)(bl6 ? function0 : null);
        Unique unique4 = unique3;
        UncivSound uncivSound2 = uncivSound;
        boolean bl7 = bl4;
        String string2 = string;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        return new UnitAction(unitActionType2, f2, string2, bl7, uncivSound2, unique4, function02, n, defaultConstructorMarker);
    }

    private final String getLeadersWePromisedNotToSettleNear(Civilization civInfo, Tile tile) {
        HashSet leadersWePromisedNotToSettleNear = new HashSet();
        Iterator<Civilization> iterator2 = SequencesKt.filter(civInfo.getKnownCivs(), (Function1)new Function1<Civilization, Boolean>(civInfo){
            final /* synthetic */ Civilization $civInfo;
            {
                this.$civInfo = $civInfo;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Civilization it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.isMajorCiv() && !this.$civInfo.isAtWarWith(it);
            }
        }).iterator();
        while (iterator2.hasNext()) {
            City it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            DiplomacyManager diplomacyManager;
            Civilization otherCiv = iterator2.next();
            Intrinsics.checkNotNull(otherCiv.getDiplomacyManager(civInfo));
            if (!diplomacyManager.hasFlag(DiplomacyFlags.AgreedToNotSettleNearUs)) continue;
            Iterable iterable = otherCiv.getCities();
            boolean $i$f$filter = false;
            void var10_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (City)element$iv$iv;
                boolean bl = false;
                if (!(it.getCenterTile().aerialDistanceTo(tile) <= 6)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (City)element$iv$iv;
                boolean bl = false;
                if (!otherCiv.hasExplored(it.getCenterTile())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List citiesWithin6Tiles2 = (List)destination$iv$iv;
            if (!(!((Collection)citiesWithin6Tiles2).isEmpty())) continue;
            ((Collection)leadersWePromisedNotToSettleNear).add(otherCiv.getLeaderDisplayName());
        }
        return leadersWePromisedNotToSettleNear.isEmpty() ? null : CollectionsKt.joinToString$default(leadersWePromisedNotToSettleNear, ", ", null, null, 0, null, null, 62, null);
    }

    @NotNull
    public final Sequence<UnitAction> getSetupActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!MapUnit.hasUnique$default(unit, UniqueType.MustSetUp, null, false, 6, null) || unit.isEmbarked()) {
            return SequencesKt.emptySequence();
        }
        boolean isSetUp = unit.isSetUpForSiege();
        UnitAction[] unitActionArray = new UnitAction[1];
        UnitActionType unitActionType = UnitActionType.SetUp;
        Function0<Unit> function0 = new Function0<Unit>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(0);
            }

            public final void invoke() {
                this.$unit.setAction(UnitActionType.SetUp.getValue());
                this.$unit.useMovementPoints(1.0f);
            }
        };
        Function0 function02 = function0;
        int n = 0;
        UnitAction[] unitActionArray2 = unitActionArray;
        boolean bl = false;
        boolean bl2 = unit.hasMovement() && !isSetUp;
        Function0 function03 = bl2 ? function0 : null;
        unitActionArray2[n] = new UnitAction(unitActionType, 85.0f, null, isSetUp, null, null, function03, 52, null);
        return SequencesKt.sequenceOf(unitActionArray);
    }

    @NotNull
    public final Sequence<UnitAction> getParadropActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Comparable comparable;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        UnitAction[] paradropUniques = MapUnit.getMatchingUniques$default(unit, UniqueType.MayParadrop, null, false, 6, null);
        if (!SequencesKt.any(paradropUniques) || unit.isEmbarked()) {
            return SequencesKt.emptySequence();
        }
        UnitAction[] unitActionArray = paradropUniques;
        UnitAction[] unitActionArray2 = unit.getCache();
        Object object = unitActionArray.iterator();
        if (!object.hasNext()) {
            comparable = null;
        } else {
            Unique it = (Unique)object.next();
            boolean bl = false;
            Comparable comparable2 = (Comparable)((Object)it.getParams().get(0));
            while (object.hasNext()) {
                Unique it2 = (Unique)object.next();
                $i$a$-maxOfOrNull-UnitActionsFromUniques$getParadropActions$1 = false;
                Comparable comparable3 = (Comparable)((Object)it2.getParams().get(0));
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Intrinsics.checkNotNull(comparable);
        unitActionArray2.setParadropRange(Integer.parseInt((String)((Object)comparable)));
        unitActionArray = new UnitAction[1];
        object = UnitActionType.Paradrop;
        boolean bl = unit.isPreparingParadrop();
        Function0<Unit> function0 = new Function0<Unit>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(0);
            }

            public final void invoke() {
                if (this.$unit.isPreparingParadrop()) {
                    this.$unit.setAction(null);
                } else {
                    this.$unit.setAction(UnitActionType.Paradrop.getValue());
                }
            }
        };
        Function0 function02 = function0;
        int n = 0;
        unitActionArray2 = unitActionArray;
        boolean bl2 = false;
        boolean bl3 = !unit.hasUnitMovedThisTurn() && tile.isFriendlyTerritory(unit.getCiv()) && !tile.isWater();
        Function0 function03 = bl3 ? function0 : null;
        unitActionArray2[n] = new UnitAction((UnitActionType)((Object)object), 60.0f, null, bl, null, null, function03, 52, null);
        return SequencesKt.sequenceOf(unitActionArray);
    }

    @NotNull
    public final Sequence<UnitAction> getAirSweepActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        Sequence airsweepUniques = MapUnit.getMatchingUniques$default(unit, UniqueType.CanAirsweep, null, false, 6, null);
        if (!SequencesKt.any(airsweepUniques)) {
            return SequencesKt.emptySequence();
        }
        UnitAction[] unitActionArray = new UnitAction[1];
        UnitActionType unitActionType = UnitActionType.AirSweep;
        boolean bl = unit.isPreparingAirSweep();
        Function0<Unit> function0 = new Function0<Unit>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(0);
            }

            public final void invoke() {
                if (this.$unit.isPreparingAirSweep()) {
                    this.$unit.setAction(null);
                } else {
                    this.$unit.setAction(UnitActionType.AirSweep.getValue());
                }
            }
        };
        Function0 function02 = function0;
        int n = 0;
        UnitAction[] unitActionArray2 = unitActionArray;
        boolean bl2 = false;
        boolean bl3 = unit.canAttack();
        Function0 function03 = bl3 ? function0 : null;
        unitActionArray2[n] = new UnitAction(unitActionType, 90.0f, null, bl, null, null, function03, 52, null);
        return SequencesKt.sequenceOf(unitActionArray);
    }

    @NotNull
    public final Sequence<UnitAction> getGuardActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!MapUnit.hasUnique$default(unit, UniqueType.WithdrawsBeforeMeleeCombat, null, false, 6, null)) {
            return SequencesKt.emptySequence();
        }
        if (unit.isGuarding()) {
            String title = MapUnit.canFortify$default(unit, false, 1, null) ? TranslationsKt.tr$default("Guarding", false, false, 3, null) + ' ' + unit.getFortificationTurns() * 20 + '%' : TranslationsKt.tr$default("Guarding", false, false, 3, null);
            UnitAction[] unitActionArray = new UnitAction[1];
            UnitActionType unitActionType = UnitActionType.Guard;
            unitActionArray[0] = new UnitAction(unitActionType, 0.0f, title, true, null, null, null, 112, null);
            return SequencesKt.sequenceOf(unitActionArray);
        }
        if (!unit.hasMovement()) {
            return SequencesKt.emptySequence();
        }
        UnitAction[] unitActionArray = new UnitAction[1];
        Function0<Unit> function0 = new Function0<Unit>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(0);
            }

            public final void invoke() {
                this.$unit.setAction(UnitActionType.Guard.getValue());
            }
        };
        Function0 function02 = function0;
        Unique unique = null;
        UncivSound uncivSound = null;
        boolean bl = false;
        String string = null;
        float f = 0.0f;
        UnitActionType unitActionType = UnitActionType.Guard;
        int n = 0;
        UnitAction[] unitActionArray2 = unitActionArray;
        boolean bl2 = false;
        boolean bl3 = !unit.isGuarding();
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n2 = 60;
        Function0 function03 = bl3 ? function0 : null;
        Unique unique2 = unique;
        UncivSound uncivSound2 = uncivSound;
        boolean bl4 = bl;
        String string2 = string;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        unitActionArray2[n] = new UnitAction(unitActionType2, f2, string2, bl4, uncivSound2, unique2, function03, n2, defaultConstructorMarker);
        return SequencesKt.sequenceOf(unitActionArray);
    }

    @NotNull
    public final Sequence<UnitAction> getTriggerUniqueActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object>(unit, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                Iterator<Unique> iterator2;
                SequenceScope $this$sequence;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        $this$sequence = (SequenceScope)this.L$0;
                        iterator2 = this.$unit.getUniques().iterator();
                        break;
                    }
                    case 1: {
                        void $result;
                        iterator2 = (Iterator<Unique>)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        object2 = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (iterator2.hasNext()) {
                    void var8_19;
                    void unitAction2;
                    String string;
                    boolean bl;
                    Unique unique;
                    block20: {
                        unique = iterator2.next();
                        Iterable $this$none$iv = unique.getModifiers();
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T t : $this$none$iv) {
                                Unique it = (Unique)t;
                                boolean bl2 = false;
                                Object object4 = it.getType();
                                boolean bl3 = object4 != null && (object4 = object4.getTargetTypes()) != null ? ((HashSet)object4).contains((Object)((Object)UniqueTarget.UnitActionModifier)) : false;
                                if (!bl3) continue;
                                bl = false;
                                break block20;
                            }
                            bl = true;
                        }
                    }
                    if (bl || unique.hasModifier(UniqueType.UnitActionExtraLimitedTimes) || !unique.isTriggerable() || !unique.conditionalsApply(this.$unit.getCache().getState()) || !UnitActionModifiers.INSTANCE.canUse(this.$unit, unique)) continue;
                    UniqueType uniqueType = unique.getType();
                    switch (uniqueType == null ? -1 : getTriggerUniqueActions.WhenMappings.$EnumSwitchMapping$0[uniqueType.ordinal()]) {
                        case 1: {
                            String[] stringArray = new String[]{TranslationsKt.tr(Boxing.boxInt(this.$unit.getCiv().getGoldenAges().calculateGoldenAgeLength(Integer.parseInt(unique.getParams().get(0)))))};
                            string = TranslationsKt.fillPlaceholders(unique.getPlaceholderText(), stringArray);
                            break;
                        }
                        case 2: {
                            if (unique.hasModifier(UniqueType.ModifiedByGameSpeed)) {
                                String string2 = unique.getParams().get(1);
                                Float f = this.$unit.getCiv().getGameInfo().getSpeed().getStatCostModifiers().get(Stat.Companion.safeValueOf(string2));
                                if (f == null) {
                                    f = Boxing.boxFloat(this.$unit.getCiv().getGameInfo().getSpeed().getModifier());
                                }
                                float modifier = ((Number)f).floatValue();
                                String[] stringArray = new String[]{TranslationsKt.tr(Boxing.boxInt((int)((float)Integer.parseInt(unique.getParams().get(0)) * modifier))), string2};
                                string = TranslationsKt.fillPlaceholders(UniqueType.OneTimeGainStat.getPlaceholderText(), stringArray);
                                break;
                            }
                            string = TranslationsKt.removeConditionals(unique.getText());
                            break;
                        }
                        case 3: {
                            String string3 = unique.getParams().get(2);
                            Float f = this.$unit.getCiv().getGameInfo().getSpeed().getStatCostModifiers().get(Stat.Companion.safeValueOf(string3));
                            if (f == null) {
                                f = Boxing.boxFloat(this.$unit.getCiv().getGameInfo().getSpeed().getModifier());
                            }
                            float modifier = ((Number)f).floatValue();
                            String[] stringArray = new String[]{TranslationsKt.tr(Boxing.boxInt((int)((float)Integer.parseInt(unique.getParams().get(0)) * modifier))), TranslationsKt.tr(Boxing.boxInt((int)((float)Integer.parseInt(unique.getParams().get(1)) * modifier))), string3};
                            string = TranslationsKt.fillPlaceholders(unique.getPlaceholderText(), stringArray);
                            break;
                        }
                        default: {
                            string = TranslationsKt.removeConditionals(unique.getText());
                        }
                    }
                    String baseTitle = string;
                    String title = UnitActionModifiers.INSTANCE.actionTextWithSideEffects(baseTitle, unique, this.$unit);
                    if (!this.$unit.hasMovement()) {
                        Object var8_16 = null;
                    } else if (UniqueTriggerActivation.getTriggerFunction$default(UniqueTriggerActivation.INSTANCE, unique, this.$unit.getCiv(), null, this.$unit, this.$unit.getCurrentTile(), null, null, 100, null) == null) {
                        Object var8_17 = null;
                    } else {
                        Function0 triggerFunction;
                        Function0 function0 = new Function0<Unit>((Function0<Boolean>)triggerFunction, this.$unit, unique){
                            final /* synthetic */ Function0<Boolean> $triggerFunction;
                            final /* synthetic */ MapUnit $unit;
                            final /* synthetic */ Unique $unique;
                            {
                                this.$triggerFunction = $triggerFunction;
                                this.$unit = $unit;
                                this.$unique = $unique;
                                super(0);
                            }

                            public final void invoke() {
                                this.$triggerFunction.invoke();
                                UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, this.$unit, this.$unique, false, 4, null);
                            }
                        };
                    }
                    void var8_20 = unitAction2 = var8_19;
                    MapUnit mapUnit = this.$unit;
                    Unique unique2 = unique;
                    UncivSound uncivSound = null;
                    boolean bl4 = false;
                    String string4 = title;
                    float f = 80.0f;
                    UnitActionType unitActionType = UnitActionType.TriggerUnique;
                    SequenceScope sequenceScope = $this$sequence;
                    boolean bl5 = false;
                    boolean bl6 = UnitActionModifiers.INSTANCE.canActivateSideEffects(mapUnit, unique);
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 24;
                    Function0 function0 = bl6 ? var8_20 : null;
                    Unique unique3 = unique2;
                    UncivSound uncivSound2 = uncivSound;
                    String string5 = string4;
                    float f2 = f;
                    UnitActionType unitActionType2 = unitActionType;
                    this.L$0 = $this$sequence;
                    this.L$1 = iterator2;
                    this.label = 1;
                    object2 = sequenceScope.yield(new UnitAction(unitActionType2, f2, string5, false, uncivSound2, unique3, function0, n, defaultConstructorMarker), this);
                    if (object2 != object3) continue;
                    return object3;
                }
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super UnitAction> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Sequence<UnitAction> getAddInCapitalActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!MapUnit.hasUnique$default(unit, UniqueType.AddInCapital, null, false, 6, null)) {
            return SequencesKt.emptySequence();
        }
        var3_3 = new UnitAction[1];
        var4_4 = UnitActionType.AddInCapital;
        var5_5 = "Add to [" + ((Unique)SequencesKt.first(MapUnit.getMatchingUniques$default(unit, UniqueType.AddInCapital, null, false, 6, null))).getParams().get(0) + ']';
        var7_6 = new Function0<Unit>(unit){
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(0);
            }

            public final void invoke() {
                this.$unit.getCiv().getVictoryManager().getCurrentsSpaceshipParts().add(this.$unit.getName(), 1);
                MapUnit.destroy$default(this.$unit, false, 1, null);
            }
        };
        var8_7 = var7_6;
        var11_8 = 0;
        var10_9 = var3_3;
        $i$a$-takeIf-UnitActionsFromUniques$getAddInCapitalActions$2 = false;
        if (!tile.isCityCenter()) ** GOTO lbl-1000
        v0 = tile.getCity();
        Intrinsics.checkNotNull(v0);
        if (!v0.isCapital()) ** GOTO lbl-1000
        v1 = tile.getCity();
        Intrinsics.checkNotNull(v1);
        if (Intrinsics.areEqual(v1.getCiv(), unit.getCiv())) {
            v2 = true;
        } else lbl-1000:
        // 3 sources

        {
            v2 = false;
        }
        var6_12 = (var12_11 = v2) != false ? var7_6 : null;
        var10_9[var11_8] = new UnitAction(var4_4, 80.0f, var5_5, false, null, null, var6_12, 56, null);
        return SequencesKt.sequenceOf(var3_3);
    }

    @NotNull
    public final Sequence<UnitAction> getImprovementCreationActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object>(unit, tile, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ Tile $tile;
            {
                this.$unit = $unit;
                this.$tile = $tile;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        waterImprovementAction = UnitActionsFromUniques.access$getWaterImprovementAction(UnitActionsFromUniques.INSTANCE, this.$unit, this.$tile);
                        if (waterImprovementAction != null) {
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yield(waterImprovementAction, this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl18:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = $this$sequence.yieldAll(UnitActionsFromUniques.INSTANCE.getImprovementConstructionActionsFromGeneralUnique(this.$unit, this.$tile), (Continuation<Unit>)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl27:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super UnitAction> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final UnitAction getWaterImprovementAction(MapUnit unit, Tile tile) {
        if (!tile.isWater() || !MapUnit.hasUnique$default(unit, UniqueType.CreateWaterImprovements, null, false, 6, null) || tile.getResource() == null) {
            return null;
        }
        String string = tile.getTileResource().getImprovingImprovement(tile, unit.getCiv());
        if (string == null) {
            return null;
        }
        String improvementName = string;
        TileImprovement tileImprovement = tile.getRuleset().getTileImprovements().get(improvementName);
        if (tileImprovement == null) {
            return null;
        }
        TileImprovement improvement2 = tileImprovement;
        if (!tile.getImprovementFunctions().canBuildImprovement(improvement2, unit.getCiv())) {
            return null;
        }
        Function0<Unit> function0 = new Function0<Unit>(tile, improvementName, unit){
            final /* synthetic */ Tile $tile;
            final /* synthetic */ String $improvementName;
            final /* synthetic */ MapUnit $unit;
            {
                this.$tile = $tile;
                this.$improvementName = $improvementName;
                this.$unit = $unit;
                super(0);
            }

            public final void invoke() {
                this.$tile.setImprovement(this.$improvementName, this.$unit.getCiv(), this.$unit);
                MapUnit.destroy$default(this.$unit, false, 1, null);
            }
        };
        Function0 function02 = function0;
        Unique unique = null;
        UncivSound uncivSound = null;
        boolean bl = false;
        String string2 = "Create [" + improvementName + ']';
        float f = 82.0f;
        UnitActionType unitActionType = UnitActionType.CreateImprovement;
        boolean bl2 = false;
        boolean bl3 = unit.hasMovement();
        Function0<Unit> function03 = bl3 ? function0 : null;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 56;
        Function0 function04 = function03;
        Unique unique2 = unique;
        UncivSound uncivSound2 = uncivSound;
        boolean bl4 = bl;
        String string3 = string2;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        return new UnitAction(unitActionType2, f2, string3, bl4, uncivSound2, unique2, function04, n, defaultConstructorMarker);
    }

    @NotNull
    public final Sequence<UnitAction> getImprovementConstructionActionsFromGeneralUnique(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object>(unit, tile, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ Tile $tile;
            {
                this.$unit = $unit;
                this.$tile = $tile;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var36_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        uniquesToCheck = UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(this.$unit, UniqueType.ConstructImprovementInstantly);
                        civResources = this.$unit.getCiv().getCivResourcesByName();
                        var5_6 = uniquesToCheck.iterator();
                        while (var5_6.hasNext()) {
                            unique = var5_6.next();
                            improvementFilter = unique.getParams().get(0);
                            v0 = this.$tile.getRuleset().getTileImprovements().values();
                            Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
                            var9_10 = v0;
                            var10_11 = this.$unit;
                            var11_12 = this.$tile;
                            $i$f$filter = false;
                            var13_16 = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            var16_22 = $this$filterTo$iv$iv.iterator();
                            while (var16_22.hasNext()) {
                                element$iv$iv = var16_22.next();
                                it = (TileImprovement)element$iv$iv;
                                $i$a$-filter-UnitActionsFromUniques$getImprovementConstructionActionsFromGeneralUnique$1$improvements$1 = false;
                                Intrinsics.checkNotNull(it);
                                if (!TileImprovement.matchesFilter$default(it, improvementFilter, new StateForConditionals(null, null, var10_11, var11_12, null, null, null, null, null, null, false, 2035, null), false, 4, null)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            improvements = (List)destination$iv$iv;
                            var9_10 = improvements.iterator();
lbl33:
                            // 4 sources

                            while (var9_10.hasNext()) {
                                improvement = (TileImprovement)var9_10.next();
                                v1 = this.$tile.getImprovementFunctions();
                                Intrinsics.checkNotNull(improvement);
                                $this$any$iv = v1.getImprovementBuildingProblems(improvement, this.$unit.getCiv());
                                $i$f$any = false;
                                $this$filterTo$iv$iv = $this$any$iv.iterator();
                                while ($this$filterTo$iv$iv.hasNext()) {
                                    it = element$iv = $this$filterTo$iv$iv.next();
                                    $i$a$-any-UnitActionsFromUniques$getImprovementConstructionActionsFromGeneralUnique$1$1 = false;
                                    if (!it.getPermanent()) continue;
                                    v2 = true;
                                    ** GOTO lbl47
                                }
                                v2 = false;
lbl47:
                                // 2 sources

                                if (v2) continue;
                                $this$none$iv = IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)improvement, UniqueType.ConsumesResources, null, 2, null);
                                $i$f$none = false;
                                var14_18 = $this$none$iv.iterator();
                                while (var14_18.hasNext()) {
                                    element$iv = var14_18.next();
                                    improvementUnique = (Unique)element$iv;
                                    $i$a$-none-UnitActionsFromUniques$getImprovementConstructionActionsFromGeneralUnique$1$resourcesAvailable$1 = false;
                                    v3 = civResources.get(improvementUnique.getParams().get(1));
                                    if (v3 == null) {
                                        v3 = Boxing.boxInt(0);
                                    }
                                    var18_28 = v3;
                                    Intrinsics.checkNotNull(var18_28);
                                    v4 = ((Number)var18_28).intValue() < Integer.parseInt(improvementUnique.getParams().get(0));
                                    if (!v4) continue;
                                    v5 = false;
                                    ** GOTO lbl65
                                }
                                v5 = true;
lbl65:
                                // 2 sources

                                resourcesAvailable = v5;
                                var12_15 = new Function0<Unit>(this.$unit, improvement, unique){
                                    final /* synthetic */ MapUnit $unit;
                                    final /* synthetic */ TileImprovement $improvement;
                                    final /* synthetic */ Unique $unique;
                                    {
                                        this.$unit = $unit;
                                        this.$improvement = $improvement;
                                        this.$unique = $unique;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        Tile unitTile = this.$unit.getTile();
                                        unitTile.setImprovement(this.$improvement.getName(), this.$unit.getCiv(), this.$unit);
                                        CivInfoTransientCache.updateViewableTiles$default(this.$unit.getCiv().getCache(), null, 1, null);
                                        UnitActionModifiers.activateSideEffects$default(UnitActionModifiers.INSTANCE, this.$unit, this.$unique, false, 4, null);
                                    }
                                };
                                var13_16 = this.$unit;
                                var14_18 = this.$tile;
                                (Function0)var12_15;
                                var26_36 = unique;
                                var25_35 = null;
                                var24_34 = false;
                                var23_33 = UnitActionModifiers.INSTANCE.actionTextWithSideEffects("Create [" + improvement.getName() + ']', unique, this.$unit);
                                var22_32 = 85.0f;
                                var21_31 = UnitActionType.CreateImprovement;
                                var20_30 = $this$sequence;
                                $i$a$-takeIf-UnitActionsFromUniques$getImprovementConstructionActionsFromGeneralUnique$1$3 = false;
                                var28_38 = null;
                                var29_39 = 24;
                                var27_37 = resourcesAvailable && var13_16.hasMovement() && var14_18.getImprovementFunctions().canBuildImprovement(improvement, var13_16.getCiv()) && !var14_18.isMarkedForCreatesOneImprovement() && UnitActionModifiers.INSTANCE.canActivateSideEffects(var13_16, unique);
                                var30_40 = var27_37 != false ? var12_15 : null;
                                var31_41 = var26_36;
                                var32_42 = var25_35;
                                var33_43 = var23_33;
                                var34_44 = var22_32;
                                var35_45 = var21_31;
                                this.L$0 = $this$sequence;
                                this.L$1 = civResources;
                                this.L$2 = var5_6;
                                this.L$3 = unique;
                                this.L$4 = var9_10;
                                this.label = 1;
                                v6 = var20_30.yield(new UnitAction(var35_45, var34_44, var33_43, false, var32_42, var31_41, var30_40, var29_39, var28_38), this);
                                if (v6 != var36_2) continue;
                                return var36_2;
                            }
                        }
                        break;
                    }
                    case 1: {
                        var9_10 = (Iterator)this.L$4;
                        unique = (Unique)this.L$3;
                        var5_6 = (Iterator<Unique>)this.L$2;
                        civResources = (HashMap<String, Integer>)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v6 = $result;
                        ** GOTO lbl33
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super UnitAction> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @NotNull
    public final Sequence<UnitAction> getConnectRoadActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object>(unit, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        if (!MapUnit.hasUnique$default(this.$unit, UniqueType.BuildImprovements, null, false, 6, null)) {
                            return Unit.INSTANCE;
                        }
                        unitCivBestRoad = this.$unit.getCiv().getTech().getBestRoadAvailable();
                        if (unitCivBestRoad == RoadStatus.None) {
                            return Unit.INSTANCE;
                        }
                        $this$any$iv = uniquesToCheck = UnitActionModifiers.INSTANCE.getUsableUnitActionUniques(this.$unit, UniqueType.BuildImprovements);
                        $i$f$any = false;
                        var8_8 = $this$any$iv.iterator();
                        while (var8_8.hasNext()) {
                            it = element$iv = var8_8.next();
                            $i$a$-any-UnitActionsFromUniques$getConnectRoadActions$1$unitCanBuildRoad$1 = false;
                            if (!(Intrinsics.areEqual(it.getParams().get(0), "Land") != false || Constants.INSTANCE.getAll().contains(it.getParams().get(0)) != false)) continue;
                            v0 = true;
                            ** GOTO lbl21
                        }
                        v0 = false;
lbl21:
                        // 2 sources

                        if (v0) ** GOTO lbl-1000
                        $this$any$iv = uniquesToCheck;
                        $i$f$any = false;
                        var8_8 = $this$any$iv.iterator();
                        while (var8_8.hasNext()) {
                            it = element$iv = var8_8.next();
                            $i$a$-any-UnitActionsFromUniques$getConnectRoadActions$1$unitCanBuildRoad$2 = false;
                            if (!Intrinsics.areEqual(it.getParams().get(0), "Road")) continue;
                            v1 = true;
                            ** GOTO lbl32
                        }
                        v1 = false;
lbl32:
                        // 2 sources

                        if (v1 && (unitCivBestRoad == RoadStatus.Road || unitCivBestRoad == RoadStatus.Railroad)) ** GOTO lbl-1000
                        $this$any$iv = uniquesToCheck;
                        $i$f$any = false;
                        var8_8 = $this$any$iv.iterator();
                        while (var8_8.hasNext()) {
                            it = element$iv = var8_8.next();
                            $i$a$-any-UnitActionsFromUniques$getConnectRoadActions$1$unitCanBuildRoad$3 = false;
                            if (!Intrinsics.areEqual(it.getParams().get(0), "Railroad")) continue;
                            v2 = true;
                            ** GOTO lbl43
                        }
                        v2 = false;
lbl43:
                        // 2 sources

                        if (v2 && unitCivBestRoad == RoadStatus.Railroad) lbl-1000:
                        // 3 sources

                        {
                            v3 = true;
                        } else {
                            v3 = unitCanBuildRoad = false;
                        }
                        if (!unitCanBuildRoad) {
                            return Unit.INSTANCE;
                        }
                        worldScreen = GUI.INSTANCE.getWorldScreen();
                        this.label = 1;
                        v4 = $this$sequence.yield(new UnitAction(UnitActionType.ConnectRoad, 25.0f, null, this.$unit.isAutomatingRoadConnection(), null, null, new Function0<Unit>(worldScreen){
                            final /* synthetic */ WorldScreen $worldScreen;
                            {
                                this.$worldScreen = $worldScreen;
                                super(0);
                            }

                            public final void invoke() {
                                this.$worldScreen.getBottomUnitTable$core().setSelectedUnitIsConnectingRoad(!this.$worldScreen.getBottomUnitTable$core().getSelectedUnitIsConnectingRoad());
                                this.$worldScreen.setShouldUpdate(true);
                            }
                        }, 52, null), this);
                        if (v4 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl58
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl58:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super UnitAction> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @NotNull
    public final Sequence<UnitAction> getTransformActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object>(unit, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapUnit $unit;
            {
                this.$unit = $unit;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2;
                Iterator<T> iterator2;
                StateForConditionals stateForConditionals;
                Civilization civInfo;
                Tile unitTile;
                SequenceScope $this$sequence;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        $this$sequence = (SequenceScope)this.L$0;
                        unitTile = this.$unit.getTile();
                        civInfo = this.$unit.getCiv();
                        stateForConditionals = this.$unit.getCache().getState();
                        iterator2 = MapUnit.getMatchingUniques$default(this.$unit, UniqueType.CanTransform, stateForConditionals, false, 4, null).iterator();
                        break;
                    }
                    case 1: {
                        void $result;
                        iterator2 = (Iterator<T>)this.L$4;
                        stateForConditionals = (StateForConditionals)this.L$3;
                        civInfo = (Civilization)this.L$2;
                        unitTile = (Tile)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        object2 = $result;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (iterator2.hasNext()) {
                    void var11_24;
                    void $this$filterTo$iv$iv;
                    String resource2;
                    boolean bl;
                    BaseUnit unitToTransformTo;
                    Unique unique;
                    block10: {
                        unique = (Unique)iterator2.next();
                        unitToTransformTo = civInfo.getEquivalentUnit(unique.getParams().get(0));
                        Sequence<Unique> $this$any$iv = unitToTransformTo.getMatchingUniques(UniqueType.OnlyAvailable, StateForConditionals.Companion.getIgnoreConditionals());
                        boolean $i$f$any = false;
                        Iterator<Unique> iterator3 = $this$any$iv.iterator();
                        while (iterator3.hasNext()) {
                            Unique element$iv;
                            Unique it = element$iv = iterator3.next();
                            boolean bl2 = false;
                            if (!(!it.conditionalsApply(stateForConditionals))) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                    if (bl) continue;
                    Counter<String> resourceRequirementsDelta = new Counter<String>(null, 1, null);
                    for (Map.Entry<K, V> entry : ((Map)this.$unit.getResourceRequirementsPerTurn()).entrySet()) {
                        resource2 = (String)entry.getKey();
                        int amount = ((Number)entry.getValue()).intValue();
                        resourceRequirementsDelta.add(resource2, -amount);
                    }
                    for (Map.Entry<K, V> entry : ((Map)unitToTransformTo.getResourceRequirementsPerTurn(this.$unit.getCache().getState())).entrySet()) {
                        resource2 = (String)entry.getKey();
                        int amount = ((Number)entry.getValue()).intValue();
                        resourceRequirementsDelta.add(resource2, amount);
                    }
                    Set<Map.Entry<K, Integer>> set2 = resourceRequirementsDelta.entrySet();
                    Intrinsics.checkNotNullExpressionValue(set2, "<get-entries>(...)");
                    Iterable iterable = set2;
                    boolean $i$f$filter = false;
                    Iterable amount = iterable;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Map.Entry it = (Map.Entry)element$iv$iv;
                        boolean bl3 = false;
                        V v = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
                        if (!(((Number)v).intValue() > 0)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    String newResourceRequirementsString2 = CollectionsKt.joinToString$default((List)destination$iv$iv, null, null, null, 0, null, getTransformActions.newResourceRequirementsString.2.INSTANCE, 31, null);
                    String string2 = "Transform to [" + unitToTransformTo.getName() + "] ";
                    string2 = string2 + UnitActionModifiers.INSTANCE.getSideEffectString(this.$unit, unique, true);
                    if (((CharSequence)newResourceRequirementsString2).length() > 0) {
                        String string3 = string2 + "\n([" + newResourceRequirementsString2 + "])";
                    }
                    Function0<Unit> function0 = new Function0<Unit>(this.$unit, civInfo, unitTile, unitToTransformTo, unique){
                        final /* synthetic */ MapUnit $unit;
                        final /* synthetic */ Civilization $civInfo;
                        final /* synthetic */ Tile $unitTile;
                        final /* synthetic */ BaseUnit $unitToTransformTo;
                        final /* synthetic */ Unique $unique;
                        {
                            this.$unit = $unit;
                            this.$civInfo = $civInfo;
                            this.$unitTile = $unitTile;
                            this.$unitToTransformTo = $unitToTransformTo;
                            this.$unique = $unique;
                            super(0);
                        }

                        public final void invoke() {
                            float oldMovement = this.$unit.getCurrentMovement();
                            MapUnit.destroy$default(this.$unit, false, 1, null);
                            MapUnit newUnit = this.$civInfo.getUnits().placeUnitNearTile(this.$unitTile.getPosition(), this.$unitToTransformTo, this.$unit.getId());
                            if (newUnit == null) {
                                MapUnit mapUnit = this.$civInfo.getUnits().placeUnitNearTile(this.$unitTile.getPosition(), this.$unit.getBaseUnit(), this.$unit.getId());
                                Intrinsics.checkNotNull(mapUnit);
                                MapUnit resurrectedUnit = mapUnit;
                                this.$unit.copyStatisticsTo(resurrectedUnit);
                            } else {
                                this.$unit.copyStatisticsTo(newUnit);
                                newUnit.setCurrentMovement(oldMovement);
                                if ((int)newUnit.getCurrentMovement() > MapUnit.getMaxMovement$default(newUnit, false, 1, null)) {
                                    newUnit.setCurrentMovement(MapUnit.getMaxMovement$default(newUnit, false, 1, null));
                                }
                                UnitActionModifiers.INSTANCE.activateSideEffects(newUnit, this.$unique, true);
                            }
                        }
                    };
                    MapUnit mapUnit = this.$unit;
                    Function0 cfr_ignored_0 = (Function0)function0;
                    Unique unique2 = unique;
                    UncivSound uncivSound = null;
                    boolean bl4 = false;
                    void var23_40 = var11_24;
                    float f = 70.0f;
                    UnitActionType unitActionType = UnitActionType.Transform;
                    SequenceScope sequenceScope = $this$sequence;
                    boolean bl5 = false;
                    boolean bl6 = !mapUnit.isEmbarked() && UnitActionModifiers.INSTANCE.canActivateSideEffects(mapUnit, unique);
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 24;
                    Function0 function02 = bl6 ? function0 : null;
                    Unique unique3 = unique2;
                    UncivSound uncivSound2 = uncivSound;
                    void var33_50 = var23_40;
                    float f2 = f;
                    UnitActionType unitActionType2 = unitActionType;
                    this.L$0 = $this$sequence;
                    this.L$1 = unitTile;
                    this.L$2 = civInfo;
                    this.L$3 = stateForConditionals;
                    this.L$4 = iterator2;
                    this.label = 1;
                    object2 = sequenceScope.yield(new UnitAction(unitActionType2, f2, (String)var33_50, false, uncivSound2, unique3, function02, n, defaultConstructorMarker), this);
                    if (object2 != object3) continue;
                    return object3;
                }
                return Unit.INSTANCE;
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super UnitAction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super UnitAction> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Sequence<UnitAction> getBuildingImprovementsActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        block6: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (!unit.getCache().getHasUniqueToBuildImprovements()) {
                return SequencesKt.emptySequence();
            }
            if (!unit.hasMovement() || tile.isCityCenter()) ** GOTO lbl-1000
            v0 = unit.getCiv().getGameInfo().getRuleset().getTileImprovements().values();
            Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
            $this$any$iv = v0;
            $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                v1 = false;
            } else {
                for (E element$iv : $this$any$iv) {
                    it = (TileImprovement)element$iv;
                    $i$a$-any-UnitActionsFromUniques$getBuildingImprovementsActions$couldConstruct$1 = false;
                    v2 = tile.getImprovementFunctions();
                    Intrinsics.checkNotNull(it);
                    v3 = ImprovementPickerScreen.Companion.canReport((Collection<? extends ImprovementBuildingProblem>)SequencesKt.toSet(v2.getImprovementBuildingProblems(it, unit.getCiv()))) && MapUnit.canBuildImprovement$default(unit, it, null, 2, null);
                    if (!v3) continue;
                    v1 = true;
                    break block6;
                }
                v1 = false;
            }
        }
        if (v1) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v4 = false;
        }
        couldConstruct = v4;
        var4_3 = new UnitAction[1];
        var5_5 = new Function0<Unit>(tile, unit){
            final /* synthetic */ Tile $tile;
            final /* synthetic */ MapUnit $unit;
            {
                this.$tile = $tile;
                this.$unit = $unit;
                super(0);
            }

            public final void invoke() {
                GUI.INSTANCE.pushScreen(new ImprovementPickerScreen(this.$tile, this.$unit, getBuildingImprovementsActions.1.INSTANCE));
            }
        };
        var6_6 = var5_5;
        var17_12 = null;
        var16_13 = null;
        var15_14 = tile.hasImprovementInProgress();
        var14_15 = null;
        var13_16 = 85.0f;
        var12_17 = UnitActionType.ConstructImprovement;
        var11_18 = 0;
        var10_19 = var4_3;
        $i$a$-takeIf-UnitActionsFromUniques$getBuildingImprovementsActions$2 = false;
        var18_20 = couldConstruct;
        var19_21 = null;
        var20_22 = 52;
        var21_23 = var18_20 != false ? var5_5 : null;
        var22_24 = var17_12;
        var23_25 = var16_13;
        var24_26 = var15_14;
        var25_27 = var14_15;
        var26_28 = var13_16;
        var27_29 = var12_17;
        var10_19[var11_18] = new UnitAction(var27_29, var26_28, var25_27, var24_26, var23_25, var22_24, var21_23, var20_22, var19_21);
        return SequencesKt.sequenceOf(var4_3);
    }

    public final int getRepairTurns$core(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Tile tile = unit.getCurrentTile();
        if (!tile.isPillaged()) {
            return 0;
        }
        if (Intrinsics.areEqual(tile.getImprovementInProgress(), "Repair")) {
            return tile.getTurnsToImprovement();
        }
        TileImprovement tileImprovement = tile.getRuleset().getTileImprovements().get("Repair");
        Intrinsics.checkNotNull(tileImprovement);
        int repairTurns = tileImprovement.getTurnsToBuild(unit.getCiv(), unit);
        TileImprovement tileImprovement2 = tile.getImprovementToRepair();
        Intrinsics.checkNotNull(tileImprovement2);
        TileImprovement pillagedImprovement = tileImprovement2;
        int turnsToBuild = pillagedImprovement.getTurnsToBuild(unit.getCiv(), unit);
        return RangesKt.coerceAtMost(repairTurns, turnsToBuild);
    }

    @NotNull
    public final Sequence<UnitAction> getRepairActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        UnitAction[] unitActionArray = new UnitAction[]{this.getRepairAction(unit)};
        return SequencesKt.filterNotNull(SequencesKt.sequenceOf(unitActionArray));
    }

    @Nullable
    public final UnitAction getRepairAction(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (!unit.getCurrentTile().getRuleset().getTileImprovements().containsKey("Repair")) {
            return null;
        }
        if (!unit.getCache().getHasUniqueToBuildImprovements()) {
            return null;
        }
        if (unit.isEmbarked()) {
            return null;
        }
        Tile tile = unit.getTile();
        if (tile.isCityCenter()) {
            return null;
        }
        if (!tile.isPillaged()) {
            return null;
        }
        boolean couldConstruct = unit.hasMovement() && !tile.isCityCenter() && !Intrinsics.areEqual(tile.getImprovementInProgress(), "Repair") && !tile.isEnemyTerritory(unit.getCiv());
        int turnsToBuild = this.getRepairTurns$core(unit);
        StringBuilder stringBuilder = new StringBuilder().append((Object)UnitActionType.Repair).append(" [");
        TileImprovement tileImprovement = unit.getCurrentTile().getImprovementToRepair();
        Intrinsics.checkNotNull(tileImprovement);
        Function0<Unit> function0 = new Function0<Unit>(tile, turnsToBuild){
            final /* synthetic */ Tile $tile;
            final /* synthetic */ int $turnsToBuild;
            {
                this.$tile = $tile;
                this.$turnsToBuild = $turnsToBuild;
                super(0);
            }

            public final void invoke() {
                this.$tile.queueImprovement("Repair", this.$turnsToBuild);
            }
        };
        Function0 function02 = function0;
        Unique unique = null;
        UncivSound uncivSound = null;
        boolean bl = false;
        String string = stringBuilder.append(tileImprovement.getName()).append("] - [").append(turnsToBuild).append("\u23f3]").toString();
        float f = 90.0f;
        UnitActionType unitActionType = UnitActionType.Repair;
        boolean bl2 = false;
        boolean bl3 = couldConstruct;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 56;
        Function0 function03 = bl3 ? function0 : null;
        Unique unique2 = unique;
        UncivSound uncivSound2 = uncivSound;
        boolean bl4 = bl;
        String string2 = string;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        return new UnitAction(unitActionType2, f2, string2, bl4, uncivSound2, unique2, function03, n, defaultConstructorMarker);
    }

    public static final /* synthetic */ String access$getLeadersWePromisedNotToSettleNear(UnitActionsFromUniques $this, Civilization civInfo, Tile tile) {
        return $this.getLeadersWePromisedNotToSettleNear(civInfo, tile);
    }

    public static final /* synthetic */ UnitAction access$getWaterImprovementAction(UnitActionsFromUniques $this, MapUnit unit, Tile tile) {
        return $this.getWaterImprovementAction(unit, tile);
    }
}

