/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.streams;

import io.ktor.utils.io.bits.MemoryJvmKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import io.ktor.utils.io.pool.ObjectPool;
import io.ktor.utils.io.streams.ByteArraysKt;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J-\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lio/ktor/utils/io/streams/OutputStreamAdapter;", "Lio/ktor/utils/io/core/Output;", "pool", "Lio/ktor/utils/io/pool/ObjectPool;", "Lio/ktor/utils/io/core/internal/ChunkBuffer;", "stream", "Ljava/io/OutputStream;", "(Lio/ktor/utils/io/pool/ObjectPool;Ljava/io/OutputStream;)V", "closeDestination", "", "flush", "source", "Lio/ktor/utils/io/bits/Memory;", "offset", "", "length", "flush-62zg_DM", "(Ljava/nio/ByteBuffer;II)V", "ktor-io"})
final class OutputStreamAdapter
extends Output {
    @NotNull
    private final OutputStream stream;

    public OutputStreamAdapter(@NotNull ObjectPool<ChunkBuffer> pool, @NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter(pool, "pool");
        Intrinsics.checkNotNullParameter(stream, "stream");
        super(pool);
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flush-62zg_DM(@NotNull ByteBuffer source, int offset, int length) {
        Intrinsics.checkNotNullParameter(source, "source");
        ByteBuffer nioBuffer = source;
        if (nioBuffer.hasArray() && !nioBuffer.isReadOnly()) {
            this.stream.write(nioBuffer.array(), nioBuffer.arrayOffset() + offset, length);
            return;
        }
        byte[] array = ByteArraysKt.getByteArrayPool().borrow();
        ByteBuffer slice = MemoryJvmKt.sliceSafe(nioBuffer, offset, length);
        try {
            int partSize;
            while ((partSize = Math.min(slice.remaining(), array.length)) != 0) {
                slice.get(array, 0, partSize);
                this.stream.write(array, 0, partSize);
            }
        }
        finally {
            ByteArraysKt.getByteArrayPool().recycle(array);
        }
    }

    @Override
    protected void closeDestination() {
        this.stream.close();
    }
}

