/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.BaseTiledMapLoader;
import com.badlogic.gdx.maps.tiled.BaseTmjMapLoader;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;

public class TmjMapLoader
extends BaseTmjMapLoader<BaseTiledMapLoader.Parameters> {
    public TmjMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public TmjMapLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public TiledMap load(String fileName) {
        return this.load(fileName, new Parameters());
    }

    public TiledMap load(String fileName, Parameters parameter) {
        FileHandle tmjFile = this.resolve(fileName);
        this.root = this.json.parse(tmjFile);
        ObjectMap<String, Texture> textures = new ObjectMap<String, Texture>();
        Array<FileHandle> textureFiles = this.getDependencyFileHandles(tmjFile);
        for (FileHandle textureFile : textureFiles) {
            Texture texture = new Texture(textureFile, parameter.generateMipMaps);
            texture.setFilter(parameter.textureMinFilter, parameter.textureMagFilter);
            textures.put(textureFile.path(), texture);
        }
        TiledMap map2 = this.loadTiledMap(tmjFile, parameter, new ImageResolver.DirectImageResolver(textures));
        map2.setOwnedResources(textures.values().toArray());
        return map2;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle tmjFile, BaseTiledMapLoader.Parameters parameter) {
        this.map = this.loadTiledMap(tmjFile, parameter, new ImageResolver.AssetManagerImageResolver(manager));
    }

    @Override
    public TiledMap loadSync(AssetManager manager, String fileName, FileHandle file, BaseTiledMapLoader.Parameters parameter) {
        return this.map;
    }

    @Override
    protected Array<AssetDescriptor> getDependencyAssetDescriptors(FileHandle tmjFile, TextureLoader.TextureParameter textureParameter) {
        Array<AssetDescriptor> descriptors = new Array<AssetDescriptor>();
        Array<FileHandle> fileHandles2 = this.getDependencyFileHandles(tmjFile);
        for (FileHandle handle2 : fileHandles2) {
            descriptors.add(new AssetDescriptor<Texture>(handle2, Texture.class, textureParameter));
        }
        return descriptors;
    }

    protected Array<FileHandle> getDependencyFileHandles(FileHandle tmjFile) {
        Array<FileHandle> fileHandles2 = new Array<FileHandle>();
        for (JsonValue tileSet : this.root.get("tileSets")) {
            this.getTileSetDependencyFileHandle(fileHandles2, tmjFile, tileSet);
        }
        this.collectImageLayerFileHandles(this.root.get("layers"), tmjFile, fileHandles2);
        return fileHandles2;
    }

    private void collectImageLayerFileHandles(JsonValue layers, FileHandle tmjFile, Array<FileHandle> fileHandles2) {
        if (layers == null) {
            return;
        }
        for (JsonValue layer : layers) {
            String type2 = layer.getString("type", "");
            if (type2.equals("imagelayer")) {
                String source = layer.getString("image", null);
                if (source == null) continue;
                FileHandle handle2 = TmjMapLoader.getRelativeFileHandle(tmjFile, source);
                fileHandles2.add(handle2);
                continue;
            }
            if (!type2.equals("group")) continue;
            this.collectImageLayerFileHandles(layer.get("layers"), tmjFile, fileHandles2);
        }
    }

    protected Array<FileHandle> getTileSetDependencyFileHandle(FileHandle tmjFile, JsonValue tileSet) {
        Array<FileHandle> fileHandles2 = new Array<FileHandle>();
        return this.getTileSetDependencyFileHandle(fileHandles2, tmjFile, tileSet);
    }

    protected Array<FileHandle> getTileSetDependencyFileHandle(Array<FileHandle> fileHandles2, FileHandle tmjFile, JsonValue tileSet) {
        block5: {
            block6: {
                block4: {
                    String source = tileSet.getString("source", null);
                    if (source == null) break block4;
                    FileHandle tsxFile = TmjMapLoader.getRelativeFileHandle(tmjFile, source);
                    tileSet = this.json.parse(tsxFile);
                    if (tileSet.has("image")) {
                        String imageSource = tileSet.getString("image");
                        FileHandle image2 = TmjMapLoader.getRelativeFileHandle(tsxFile, imageSource);
                        fileHandles2.add(image2);
                    } else {
                        for (JsonValue tile : tileSet.get("tile")) {
                            String imageSource = tile.getString("image");
                            FileHandle image3 = TmjMapLoader.getRelativeFileHandle(tsxFile, imageSource);
                            fileHandles2.add(image3);
                        }
                    }
                    break block5;
                }
                if (!tileSet.has("image")) break block6;
                String imageSource = tileSet.getString("image");
                FileHandle image4 = TmjMapLoader.getRelativeFileHandle(tmjFile, imageSource);
                fileHandles2.add(image4);
                break block5;
            }
            JsonValue tiles2 = tileSet.get("tiles");
            if (tiles2 == null) break block5;
            for (JsonValue tile : tiles2) {
                String imageSource = tile.getString("image");
                FileHandle image5 = TmjMapLoader.getRelativeFileHandle(tmjFile, imageSource);
                fileHandles2.add(image5);
            }
        }
        return fileHandles2;
    }

    @Override
    protected void addStaticTiles(FileHandle tmjFile, ImageResolver imageResolver, TiledMapTileSet tileSet, JsonValue element, JsonValue tiles2, String name2, int firstgid, int tilewidth, int tileheight, int spacing, int margin, String source, int offsetX, int offsetY, String imageSource, int imageWidth, int imageHeight, FileHandle image2) {
        MapProperties props = tileSet.getProperties();
        if (image2 != null) {
            TextureRegion texture = imageResolver.getImage(image2.path());
            props.put("imagesource", imageSource);
            props.put("imagewidth", imageWidth);
            props.put("imageheight", imageHeight);
            props.put("tilewidth", tilewidth);
            props.put("tileheight", tileheight);
            props.put("margin", margin);
            props.put("spacing", spacing);
            int stopWidth = texture.getRegionWidth() - tilewidth;
            int stopHeight = texture.getRegionHeight() - tileheight;
            int id = firstgid;
            for (int y = margin; y <= stopHeight; y += tileheight + spacing) {
                for (int x = margin; x <= stopWidth; x += tilewidth + spacing) {
                    TextureRegion tileRegion = new TextureRegion(texture, x, y, tilewidth, tileheight);
                    int tileId = id++;
                    this.addStaticTiledMapTile(tileSet, tileRegion, tileId, offsetX, offsetY);
                }
            }
        } else {
            for (JsonValue tile : tiles2) {
                if (tile.has("image")) {
                    imageSource = tile.getString("image");
                    image2 = source != null ? TmjMapLoader.getRelativeFileHandle(TmjMapLoader.getRelativeFileHandle(tmjFile, source), imageSource) : TmjMapLoader.getRelativeFileHandle(tmjFile, imageSource);
                }
                TextureRegion texture = imageResolver.getImage(image2.path());
                int tileId = firstgid + tile.getInt("id");
                this.addStaticTiledMapTile(tileSet, texture, tileId, offsetX, offsetY);
            }
        }
    }

    public static class Parameters
    extends BaseTiledMapLoader.Parameters {
    }
}

