/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation;

import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.ThreatLevel;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityFocus;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.BFS;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.Specialist;
import com.unciv.models.ruleset.Speed;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.Personality;
import com.unciv.models.ruleset.nation.PersonalityValue;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.ruleset.unique.StateForConditionals;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.StatMap;
import com.unciv.models.stats.Stats;
import com.unciv.ui.screens.victoryscreen.RankingType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\tJ\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"J&\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"J\u0016\u0010'\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u0006J'\u0010(\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b*J\u001e\u0010+\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"J%\u0010,\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b-J\u0016\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006J\u000e\u00102\u001a\u0002032\u0006\u0010\b\u001a\u00020\t\u00a8\u00064"}, d2={"Lcom/unciv/logic/automation/Automation;", "", "()V", "afraidOfBarbarians", "", "civInfo", "Lcom/unciv/logic/civilization/Civilization;", "allowAutomatedConstruction", "city", "Lcom/unciv/logic/city/City;", "construction", "Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "allowCreateImprovementBuildings", "allowSpendingResource", "cityInfo", "chooseMilitaryUnit", "", "availableUnits", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "getFoodModWeight", "", "surplusFood", "getReservedSpaceResourceAmount", "", "getTileForConstructionImprovement", "Lcom/unciv/logic/map/tile/Tile;", "improvement", "Lcom/unciv/models/ruleset/tile/TileImprovement;", "providesUnneededCarryingSlots", "baseUnit", "rankSpecialist", "specialist", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "rankStatsForCityWork", "stats", "Lcom/unciv/models/stats/Stats;", "areWeRankingSpecialist", "rankStatsValue", "rankTile", "tile", "rankTile$core", "rankTileForCityWork", "rankTileForExpansion", "rankTileForExpansion$core", "threatAssessment", "Lcom/unciv/logic/automation/ThreatLevel;", "assessor", "assessed", "tryTrainMilitaryUnit", "", "core"})
@SourceDebugExtension(value={"SMAP\nAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Automation.kt\ncom/unciv/logic/automation/Automation\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,550:1\n1268#2,3:551\n1268#2,3:559\n1247#2,2:568\n1433#2,14:570\n1247#2,2:584\n1408#2,14:586\n1247#2,2:607\n1433#2,14:615\n2159#2,2:629\n1#3:554\n1774#4,4:555\n2624#4,3:562\n1747#4,3:565\n766#4:609\n857#4,2:610\n766#4:612\n857#4,2:613\n494#5,7:600\n*S KotlinDebug\n*F\n+ 1 Automation.kt\ncom/unciv/logic/automation/Automation\n*L\n212#1:551,3\n237#1:559,3\n263#1:568,2\n267#1:570,14\n269#1:584,2\n272#1:586,14\n345#1:607,2\n444#1:615,14\n516#1:629,2\n235#1:555,4\n241#1:562,3\n262#1:565,3\n403#1:609\n403#1:610,2\n404#1:612\n404#1:613,2\n283#1:600,7\n*E\n"})
public final class Automation {
    @NotNull
    public static final Automation INSTANCE = new Automation();

    private Automation() {
    }

    public final float rankTileForCityWork(@NotNull Tile tile, @NotNull City city2, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(city2, "city");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        Stats stats2 = tile.getStats().getTileStats(city2, city2.getCiv(), localUniqueCache);
        return this.rankStatsForCityWork(stats2, city2, false, localUniqueCache);
    }

    public final float rankSpecialist(@NotNull String specialist, @NotNull City city2, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(specialist, "specialist");
        Intrinsics.checkNotNullParameter(city2, "city");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        Stats stats2 = city2.getCityStats().getStatsOfSpecialist(specialist, localUniqueCache);
        float rank = this.rankStatsForCityWork(stats2, city2, true, localUniqueCache);
        float gpp = 0.0f;
        if (city2.getRuleset().getSpecialists().containsKey(specialist)) {
            Specialist specialist2 = city2.getRuleset().getSpecialists().get(specialist);
            Intrinsics.checkNotNull(specialist2);
            Specialist specialistInfo = specialist2;
            gpp = specialistInfo.getGreatPersonPoints().sumValues();
        }
        gpp = gpp * (float)(100 + city2.getCurrentGPPBonus()) / (float)100;
        return rank += gpp * (float)3;
    }

    private final float getFoodModWeight(City city2, float surplusFood) {
        float speed = city2.getCiv().getGameInfo().getSpeed().getModifier();
        if (city2.getCiv().getHappiness() < -8) {
            return 0.0f;
        }
        if (city2.getCiv().isAI()) {
            if (city2.getPopulation().getPopulation() < 5) {
                return 2.0f;
            }
            return 1.5f;
        }
        if (city2.getCityFocus() == CityFocus.NoFocus) {
            if (city2.getPopulation().getPopulation() < 5) {
                return 2.0f;
            }
            if (surplusFood > (float)city2.getPopulation().getFoodToNextPopulation() / ((float)10 * speed)) {
                return 0.75f;
            }
        }
        return 1.0f;
    }

    public final float rankStatsForCityWork(@NotNull Stats stats2, @NotNull City city2, boolean areWeRankingSpecialist, @NotNull LocalUniqueCache localUniqueCache) {
        float surplusFood;
        boolean starving;
        Intrinsics.checkNotNullParameter(stats2, "stats");
        Intrinsics.checkNotNullParameter(city2, "city");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        CityFocus cityAIFocus = city2.getCityFocus();
        Stats yieldStats = stats2.clone();
        Personality civPersonality = city2.getCiv().getPersonality();
        CityStats cityStatsObj = city2.getCityStats();
        Civilization civInfo = city2.getCiv();
        boolean allTechsAreResearched = civInfo.getTech().allTechsAreResearched();
        if (areWeRankingSpecialist) {
            Unique unique;
            Iterator iterator2 = LocalUniqueCache.forCityGetMatchingUniques$default(localUniqueCache, city2, UniqueType.FoodConsumptionBySpecialists, null, 4, null).iterator();
            while (iterator2.hasNext()) {
                unique = (Unique)iterator2.next();
                if (!City.matchesFilter$default(city2, unique.getParams().get(1), null, false, 6, null)) continue;
                yieldStats.setFood(yieldStats.getFood() - Float.parseFloat(unique.getParams().get(0)) / 100.0f * 2.0f);
            }
            iterator2 = LocalUniqueCache.forCityGetMatchingUniques$default(localUniqueCache, city2, UniqueType.UnhappinessFromPopulationTypePercentageChange, null, 4, null).iterator();
            while (iterator2.hasNext()) {
                unique = (Unique)iterator2.next();
                if (!Intrinsics.areEqual(unique.getParams().get(1), "Specialists") || !City.matchesFilter$default(city2, unique.getParams().get(2), null, false, 6, null)) continue;
                yieldStats.setHappiness(yieldStats.getHappiness() - Float.parseFloat(unique.getParams().get(0)) / 100.0f);
            }
        }
        boolean bl = starving = (surplusFood = city2.getCityStats().getCurrentCityStats().get(Stat.Food)) < 0.0f;
        if (cityStatsObj.canConvertFoodToProduction(surplusFood, city2.getCityConstructions().getCurrentConstruction())) {
            yieldStats.setProduction(yieldStats.getProduction() + (cityStatsObj.getProductionFromExcessiveFood(surplusFood + yieldStats.getFood()) - cityStatsObj.getProductionFromExcessiveFood(surplusFood)));
            yieldStats.setFood(0.0f);
        }
        float feedFood = 0.0f;
        if (starving) {
            feedFood = RangesKt.coerceAtLeast(Math.min(yieldStats.getFood(), -surplusFood), 0.0f);
        }
        float growthFood = yieldStats.getFood() - feedFood;
        if (city2.getAvoidGrowth()) {
            growthFood = 0.0f;
        }
        yieldStats.setFood(1.0f);
        yieldStats.applyRankingWeights();
        float foodBaseWeight = yieldStats.getFood();
        yieldStats.setFood(feedFood * (foodBaseWeight * (float)8));
        Unique growthNullifyingUnique = (Unique)SequencesKt.firstOrNull(City.getMatchingUniques$default(city2, UniqueType.NullifiesGrowth, null, false, 6, null));
        if (growthNullifyingUnique == null) {
            float newGrowthFood = growthFood;
            CityStats cityStats = new CityStats(city2);
            StatMap growthBonuses = cityStats.getGrowthBonus(growthFood);
            for (Map.Entry growthBonus : ((Map)growthBonuses).entrySet()) {
                newGrowthFood += ((Stats)growthBonus.getValue()).getFood();
            }
            if (city2.isWeLoveTheKingDayActive() && city2.getCiv().getHappiness() >= 0) {
                newGrowthFood += growthFood / (float)4;
            }
            newGrowthFood = RangesKt.coerceAtLeast(newGrowthFood, 0.0f);
            yieldStats.setFood(yieldStats.getFood() + newGrowthFood * foodBaseWeight * this.getFoodModWeight(city2, surplusFood));
        }
        if (city2.getPopulation().getPopulation() < 10) {
            yieldStats.setScience(yieldStats.getScience() / (float)2);
        }
        if (city2.getCiv().getStats().getStatsForNextTurn().getGold() < 0.0f) {
            yieldStats.setGold(yieldStats.getGold() * (float)2);
        }
        if (city2.getCiv().getHappiness() < 0) {
            yieldStats.setHappiness(yieldStats.getHappiness() * (float)2);
        }
        if (allTechsAreResearched) {
            yieldStats.setScience(yieldStats.getScience() * 0.0f);
        }
        if (city2.getCityConstructions().getCurrentConstruction() instanceof PerpetualConstruction) {
            yieldStats.setProduction(yieldStats.getProduction() / (float)6);
        }
        for (Stat stat : Stat.getEntries()) {
            float scaledFocus;
            if (city2.getCiv().wantsToFocusOn(stat)) {
                yieldStats.set(stat, yieldStats.get(stat) * 2.0f);
            }
            if ((scaledFocus = civPersonality.scaledFocus(PersonalityValue.Companion.get(stat))) == 1.0f) continue;
            yieldStats.set(stat, yieldStats.get(stat) * scaledFocus);
        }
        cityAIFocus.applyWeightTo(yieldStats);
        return SequencesKt.sumOfFloat(yieldStats.getValues());
    }

    public final void tryTrainMilitaryUnit(@NotNull City city2) {
        Intrinsics.checkNotNullParameter(city2, "city");
        if (city2.isPuppet()) {
            return;
        }
        IConstruction iConstruction = city2.getCityConstructions().getCurrentConstruction();
        BaseUnit baseUnit = iConstruction instanceof BaseUnit ? (BaseUnit)iConstruction : null;
        boolean bl = baseUnit != null ? baseUnit.isMilitary() : false;
        if (bl) {
            return;
        }
        Collection<BaseUnit> collection = city2.getCiv().getGameInfo().getRuleset().getUnits().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        String chosenUnitName = this.chooseMilitaryUnit(city2, CollectionsKt.asSequence((Iterable)collection));
        if (chosenUnitName != null) {
            city2.getCityConstructions().setCurrentConstructionFromQueue(chosenUnitName);
        }
    }

    public final boolean providesUnneededCarryingSlots(@NotNull BaseUnit baseUnit, @NotNull Civilization civInfo) {
        MapUnit it;
        Intrinsics.checkNotNullParameter(baseUnit, "baseUnit");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Unique carryUnique = (Unique)SequencesKt.first(IHasUniques.DefaultImpls.getMatchingUniques$default((IHasUniques)baseUnit, UniqueType.CarryAirUnits, null, 2, null));
        String carryFilter = carryUnique.getParams().get(1);
        Sequence<MapUnit> $this$count$iv = civInfo.getUnits().getCivUnits();
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<MapUnit> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            MapUnit element$iv;
            it = element$iv = iterator2.next();
            boolean bl = false;
            if (!MapUnit.matchesFilter$default(it, carryFilter, false, 2, null) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int totalCarriableUnits = count$iv;
        Sequence<MapUnit> sequence = civInfo.getUnits().getCivUnits();
        int n = 0;
        iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            MapUnit mapUnit;
            it = mapUnit = iterator2.next();
            int n2 = n;
            boolean bl = false;
            int n3 = Automation.providesUnneededCarryingSlots$getCarryAmount(carryFilter, it);
            n = n2 + n3;
        }
        int totalCarryingSlots = n;
        return totalCarriableUnits < totalCarryingSlots;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final String chooseMilitaryUnit(@NotNull City city, @NotNull Sequence<BaseUnit> availableUnits) {
        block40: {
            block36: {
                block39: {
                    block35: {
                        block34: {
                            block37: {
                                block33: {
                                    block38: {
                                        Intrinsics.checkNotNullParameter(city, "city");
                                        Intrinsics.checkNotNullParameter(availableUnits, "availableUnits");
                                        currentChoice = city.getCityConstructions().getCurrentConstruction();
                                        if (currentChoice instanceof BaseUnit && !((BaseUnit)currentChoice).isCivilian()) {
                                            return city.getCityConstructions().getCurrentConstructionFromQueue();
                                        }
                                        removeShips = new Ref.BooleanRef();
                                        removeShips.element = true;
                                        isMissingNavalUnitsForCityDefence = false;
                                        if (!city.isCoastal()) break block37;
                                        findWaterConnectedCitiesAndEnemies = new BFS(city.getCenterTile(), chooseMilitaryUnit.findWaterConnectedCitiesAndEnemies.1.INSTANCE);
                                        findWaterConnectedCitiesAndEnemies.stepToEnd();
                                        var8_7 = findWaterConnectedCitiesAndEnemies.getReachedTiles();
                                        $i$f$count = false;
                                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                                            v0 = 0;
                                        } else {
                                            count$iv = 0;
                                            for (T element$iv : $this$count$iv) {
                                                it = (Tile)element$iv;
                                                $i$a$-count-Automation$chooseMilitaryUnit$numberOfOurConnectedCities$1 = false;
                                                if (!(it.isCityCenter() != false && Intrinsics.areEqual(it.getOwner(), city.getCiv()) != false) || ++count$iv >= 0) continue;
                                                CollectionsKt.throwCountOverflow();
                                            }
                                            v0 = count$iv;
                                        }
                                        numberOfOurConnectedCities = v0;
                                        $i$f$count = findWaterConnectedCitiesAndEnemies.getReachedTiles();
                                        count$iv = 0;
                                        for (T element$iv : $i$f$count) {
                                            it = (Tile)element$iv;
                                            var22_57 = count$iv;
                                            $i$a$-sumOfInt-Automation$chooseMilitaryUnit$numberOfOurNavalMeleeUnits$1 = false;
                                            $this$count$iv = it.getUnits();
                                            $i$f$count = false;
                                            count$iv = 0;
                                            var18_53 = $this$count$iv.iterator();
                                            while (var18_53.hasNext()) {
                                                it = element$iv = var18_53.next();
                                                $i$a$-count-Automation$chooseMilitaryUnit$numberOfOurNavalMeleeUnits$1$1 = false;
                                                if (!Automation.chooseMilitaryUnit$isNavalMeleeUnit(it.getBaseUnit()) || ++count$iv >= 0) continue;
                                                CollectionsKt.throwCountOverflow();
                                            }
                                            var23_59 = count$iv;
                                            count$iv = var22_57 + var23_59;
                                        }
                                        numberOfOurNavalMeleeUnits = count$iv;
                                        isMissingNavalUnitsForCityDefence = numberOfOurConnectedCities > numberOfOurNavalMeleeUnits;
                                        $i$f$count = findWaterConnectedCitiesAndEnemies.getReachedTiles();
                                        var22_58 = removeShips;
                                        $i$f$none = false;
                                        if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) break block38;
                                        v1 = 1;
                                        break block33;
                                    }
                                    for (T element$iv : $this$none$iv) {
                                        it = (Tile)element$iv;
                                        $i$a$-none-Automation$chooseMilitaryUnit$1 = false;
                                        if (it.isCityCenter() && !Intrinsics.areEqual(it.getOwner(), city.getCiv())) ** GOTO lbl-1000
                                        if (it.getMilitaryUnit() != null) {
                                            v2 = it.getMilitaryUnit();
                                            Intrinsics.checkNotNull(v2);
                                            ** if (Intrinsics.areEqual((Object)v2.getCiv(), (Object)city.getCiv())) goto lbl-1000
                                        }
                                        ** GOTO lbl-1000
lbl-1000:
                                        // 2 sources

                                        {
                                            v3 = true;
                                            ** GOTO lbl68
                                        }
lbl-1000:
                                        // 2 sources

                                        {
                                            v3 = false;
                                        }
lbl68:
                                        // 2 sources

                                        if (!v3) continue;
                                        v1 = 0;
                                        break block33;
                                    }
                                    v1 = 1;
                                }
                                var23_59 = v1;
                                var22_58.element = var23_59;
                            }
                            militaryUnits = CollectionsKt.asSequence((Iterable)SequencesKt.toList(SequencesKt.filter(SequencesKt.filterNot(SequencesKt.filter(SequencesKt.filterNot(SequencesKt.filter(availableUnits, chooseMilitaryUnit.militaryUnits.1.INSTANCE), (Function1)new Function1<BaseUnit, Boolean>(removeShips){
                                final /* synthetic */ Ref.BooleanRef $removeShips;
                                {
                                    this.$removeShips = $removeShips;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(@NotNull BaseUnit it) {
                                    Intrinsics.checkNotNullParameter(it, "it");
                                    return this.$removeShips.element && it.isWaterUnit();
                                }
                            }), (Function1)new Function1<BaseUnit, Boolean>(city){
                                final /* synthetic */ City $city;
                                {
                                    this.$city = $city;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(@NotNull BaseUnit it) {
                                    Intrinsics.checkNotNullParameter(it, "it");
                                    return Automation.allowSpendingResource$default(Automation.INSTANCE, this.$city.getCiv(), it, null, 4, null);
                                }
                            }), (Function1)new Function1<BaseUnit, Boolean>(city){
                                final /* synthetic */ City $city;
                                {
                                    this.$city = $city;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(@NotNull BaseUnit it) {
                                    Intrinsics.checkNotNullParameter(it, "it");
                                    return IHasUniques.DefaultImpls.hasUnique$default((IHasUniques)it, UniqueType.CarryAirUnits, null, 2, null) && Automation.INSTANCE.providesUnneededCarryingSlots(it, this.$city.getCiv());
                                }
                            }), (Function1)new Function1<BaseUnit, Boolean>(city){
                                final /* synthetic */ City $city;
                                {
                                    this.$city = $city;
                                    super(1);
                                }

                                @NotNull
                                public final Boolean invoke(@NotNull BaseUnit it) {
                                    Intrinsics.checkNotNullParameter(it, "it");
                                    return it.isBuildable(this.$city.getCityConstructions());
                                }
                            })));
                            chosenUnit = null;
                            if (city.getCiv().isAtWar()) break block39;
                            $this$any$iv = city.getCiv().getCities();
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v4 = false;
                            } else {
                                $i$f$none = $this$any$iv.iterator();
                                while ($i$f$none.hasNext()) {
                                    element$iv = $i$f$none.next();
                                    it = (City)element$iv;
                                    $i$a$-any-Automation$chooseMilitaryUnit$2 = false;
                                    if (!(it.getCenterTile().getMilitaryUnit() == null)) continue;
                                    v4 = true;
                                    break block34;
                                }
                                v4 = false;
                            }
                        }
                        if (!v4) break block39;
                        $this$any$iv = militaryUnits;
                        $i$f$any = false;
                        $i$f$none = $this$any$iv.iterator();
                        while ($i$f$none.hasNext()) {
                            element$iv = $i$f$none.next();
                            it = (BaseUnit)element$iv;
                            $i$a$-any-Automation$chooseMilitaryUnit$3 = false;
                            if (!it.isRanged()) continue;
                            v5 = true;
                            break block35;
                        }
                        v5 = false;
                    }
                    if (!v5) break block39;
                    $this$any$iv = SequencesKt.filter(militaryUnits, chooseMilitaryUnit.4.INSTANCE);
                    $i$f$maxByOrNull = false;
                    iterator$iv = $this$maxByOrNull$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        v6 = null;
                    } else {
                        maxElem$iv = iterator$iv.next();
                        if (!iterator$iv.hasNext()) {
                            v6 = maxElem$iv;
                        } else {
                            it = (BaseUnit)maxElem$iv;
                            $i$a$-maxByOrNull-Automation$chooseMilitaryUnit$5 = false;
                            maxValue$iv = it.getCost();
                            do {
                                e$iv = iterator$iv.next();
                                it = (BaseUnit)e$iv;
                                $i$a$-maxByOrNull-Automation$chooseMilitaryUnit$5 = false;
                                v$iv = it.getCost();
                                if (maxValue$iv >= v$iv) continue;
                                maxElem$iv = e$iv;
                                maxValue$iv = v$iv;
                            } while (iterator$iv.hasNext());
                            v6 = maxElem$iv;
                        }
                    }
                    Intrinsics.checkNotNull(v6);
                    chosenUnit = v6;
                    break block40;
                }
                if (!isMissingNavalUnitsForCityDefence) ** GOTO lbl-1000
                $this$any$iv = militaryUnits;
                $i$f$any = false;
                iterator$iv = $this$any$iv.iterator();
                while (iterator$iv.hasNext()) {
                    element$iv = iterator$iv.next();
                    it = (BaseUnit)element$iv;
                    $i$a$-any-Automation$chooseMilitaryUnit$6 = false;
                    if (!Automation.chooseMilitaryUnit$isNavalMeleeUnit((BaseUnit)it)) continue;
                    v7 = true;
                    break block36;
                }
                v7 = false;
            }
            if (v7) {
                $this$any$iv = SequencesKt.filter(militaryUnits, chooseMilitaryUnit.7.INSTANCE);
                $i$f$maxByOrThrow = false;
                iterator$iv = $this$maxBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v8 = maxElem$iv;
                } else {
                    it = (BaseUnit)maxElem$iv;
                    $i$a$-maxByOrThrow-Automation$chooseMilitaryUnit$8 = false;
                    maxValue$iv = it.getCost();
                    do {
                        e$iv = iterator$iv.next();
                        it = (BaseUnit)e$iv;
                        $i$a$-maxByOrThrow-Automation$chooseMilitaryUnit$8 = false;
                        v$iv = it.getCost();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v8 = maxElem$iv;
                }
                chosenUnit = (BaseUnit)v8;
            } else lbl-1000:
            // 2 sources

            {
                bestUnitsForType = new HashMap<K, V>();
                $i$f$maxByOrThrow = militaryUnits.iterator();
                while ($i$f$maxByOrThrow.hasNext()) {
                    unit = (BaseUnit)$i$f$maxByOrThrow.next();
                    if (bestUnitsForType.get(unit.getUnitType()) != null) {
                        v9 = bestUnitsForType.get(unit.getUnitType());
                        Intrinsics.checkNotNull(v9);
                        if (((BaseUnit)v9).getCost() >= unit.getCost()) continue;
                    }
                    ((Map)bestUnitsForType).put(unit.getUnitType(), unit);
                }
                maxValue$iv = ((Iterable)((Map)bestUnitsForType).entrySet()).iterator();
                if (!maxValue$iv.hasNext()) {
                    v10 = null;
                } else {
                    it = (Map.Entry)maxValue$iv.next();
                    $i$a$-maxOfOrNull-Automation$chooseMilitaryUnit$bestForce$1 = false;
                    var13_37 = ((BaseUnit)it.getValue()).getForceEvaluation();
                    while (maxValue$iv.hasNext()) {
                        it = (Map.Entry)maxValue$iv.next();
                        $i$a$-maxOfOrNull-Automation$chooseMilitaryUnit$bestForce$1 = false;
                        if (var13_37.compareTo(it = (Comparable)Integer.valueOf(((BaseUnit)it.getValue()).getForceEvaluation())) >= 0) continue;
                        var13_37 = it;
                    }
                    v10 = var13_37;
                }
                v11 = (Integer)v10;
                if (v11 == null) {
                    return null;
                }
                bestForce = v11;
                $this$filterValues$iv = bestUnitsForType;
                $i$f$filterValues = false;
                result$iv = new LinkedHashMap<K, V>();
                for (Map.Entry<K, V> entry$iv : $this$filterValues$iv.entrySet()) {
                    it = (BaseUnit)entry$iv.getValue();
                    $i$a$-filterValues-Automation$chooseMilitaryUnit$9 = false;
                    if (!(it.getUniqueTo() != null || it.getForceEvaluation() > bestForce / 3)) continue;
                    result$iv.put(entry$iv.getKey(), entry$iv.getValue());
                }
                chosenUnit = (BaseUnit)CollectionsKt.random(((Map)result$iv).values(), Random.Default);
            }
        }
        return chosenUnit.getName();
    }

    public final boolean afraidOfBarbarians(@NotNull Civilization civInfo) {
        float multiplier;
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        if (civInfo.isCityState() || civInfo.isBarbarian()) {
            return false;
        }
        if (civInfo.getGameInfo().getGameParameters().getNoBarbarians()) {
            return false;
        }
        Speed speed = civInfo.getGameInfo().getSpeed();
        if ((float)civInfo.getGameInfo().getTurns() > (float)200 * speed.getBarbarianModifier()) {
            return false;
        }
        float f = multiplier = civInfo.getGameInfo().getGameParameters().getRagingBarbarians() ? 1.3f : 1.0f;
        if ((float)civInfo.getGameInfo().getTurns() > (float)120 * speed.getBarbarianModifier() * multiplier) {
            multiplier /= (float)2;
        }
        if (civInfo.getCities().isEmpty() || (float)SequencesKt.count(civInfo.getUnits().getCivUnits()) >= (float)4 * multiplier) {
            return false;
        }
        civInfo.getGameInfo().getTileMap().assignContinents(TileMap.AssignContinentsMode.Ensure);
        City city2 = Civilization.getCapital$default(civInfo, false, 1, null);
        Intrinsics.checkNotNull(city2);
        int startingContinent = city2.getCenterTile().getContinent();
        Integer startingContinentSize = civInfo.getGameInfo().getTileMap().getContinentSizes().get(startingContinent);
        return startingContinentSize == null || !((float)startingContinentSize.intValue() < (float)civInfo.getViewableTiles().size() * multiplier);
    }

    public final boolean allowAutomatedConstruction(@NotNull Civilization civInfo, @NotNull City city2, @NotNull INonPerpetualConstruction construction2) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(city2, "city");
        Intrinsics.checkNotNullParameter(construction2, "construction");
        return this.allowCreateImprovementBuildings(civInfo, city2, construction2) && this.allowSpendingResource(civInfo, construction2, city2);
    }

    public final boolean allowCreateImprovementBuildings(@NotNull Civilization civInfo, @NotNull City city2, @NotNull INonPerpetualConstruction construction2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(civInfo, "civInfo");
            Intrinsics.checkNotNullParameter(city2, "city");
            Intrinsics.checkNotNullParameter(construction2, "construction");
            if (!(construction2 instanceof Building)) {
                return true;
            }
            if (!((Building)construction2).hasCreateOneImprovementUnique()) {
                return true;
            }
            TileImprovement tileImprovement = ((Building)construction2).getImprovementToCreate(city2.getRuleset(), civInfo);
            if (tileImprovement == null) {
                return true;
            }
            TileImprovement improvement2 = tileImprovement;
            Sequence<Tile> $this$any$iv = city2.getTiles();
            boolean $i$f$any = false;
            Iterator<Tile> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Tile element$iv;
                Tile it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!it.getImprovementFunctions().canBuildImprovement(improvement2, civInfo)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final boolean allowSpendingResource(@NotNull Civilization civInfo, @NotNull INonPerpetualConstruction construction, @Nullable City cityInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(construction, "construction");
        if (civInfo.isCityState()) {
            return true;
        }
        if (civInfo.getGameInfo().getSpaceResources().contains(construction.getName())) {
            return true;
        }
        if (construction instanceof BaseUnit) {
            v0 = construction.getResourceRequirementsPerTurn(civInfo.getState());
        } else {
            v1 = cityInfo;
            if (v1 == null || (v1 = v1.getState()) == null) {
                v1 = civInfo.getState();
            }
            v0 = requiredResources = construction.getResourceRequirementsPerTurn((StateForConditionals)v1);
        }
        if (requiredResources.isEmpty()) {
            return true;
        }
        civResources = civInfo.getCivResourcesByName();
        for (Map.Entry<K, V> var7_7 : ((Map)requiredResources).entrySet()) {
            resource = (String)var7_7.getKey();
            amount = ((Number)var7_7.getValue()).intValue();
            futureForUnits = 0;
            futureForBuildings = 0;
            for (City city : civInfo.getCities()) {
                otherConstruction = city.getCityConstructions().getCurrentConstruction();
                if (otherConstruction instanceof Building) {
                    futureForBuildings += ((Number)otherConstruction.getResourceRequirementsPerTurn(city.getState()).get((Object)resource)).intValue();
                    continue;
                }
                futureForUnits += ((Number)otherConstruction.getResourceRequirementsPerTurn(civInfo.getState()).get((Object)resource)).intValue();
            }
            if (civInfo.getGameInfo().getSpaceResources().contains(resource)) {
                v2 = civResources.get(resource);
                Intrinsics.checkNotNull(v2);
                if (((Number)v2).intValue() - amount - futureForBuildings - futureForUnits < this.getReservedSpaceResourceAmount(civInfo)) {
                    return false;
                }
            }
            v3 = neededForBuilding = civInfo.getCache().getLastEraResourceUsedForBuilding().get(resource) != null;
            if (civInfo.getCache().getLastEraResourceUsedForUnit().get(resource) == null) ** GOTO lbl-1000
            v4 = civInfo.getCache().getLastEraResourceUsedForUnit().get(resource);
            Intrinsics.checkNotNull(v4);
            if (((Number)v4).intValue() >= civInfo.getEraNumber()) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = neededForUnits = false;
            }
            if (!neededForBuilding || !neededForUnits) continue;
            $this$filter$iv = civInfo.getDetailedCivResources();
            $i$f$filter = 0;
            var17_23 = $this$filter$iv;
            destination$iv$iv /* !! */  = new ArrayList<E>();
            $i$f$filterTo = false;
            var20_28 = $this$filterTo$iv$iv.iterator();
            while (var20_28.hasNext()) {
                element$iv$iv = var20_28.next();
                it = (ResourceSupplyList.ResourceSupply)element$iv$iv;
                $i$a$-filter-Automation$allowSpendingResource$usedForUnits$1 = false;
                if (!(Intrinsics.areEqual(it.getResource().getName(), resource) != false && Intrinsics.areEqual(it.getOrigin(), "Units") != false)) continue;
                destination$iv$iv /* !! */ .add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv /* !! */ ;
            $i$f$filter = 0;
            $this$filterTo$iv$iv = $this$filter$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                destination$iv$iv /* !! */  = $this$filterTo$iv$iv.next();
                $i$f$filterTo = (ResourceSupplyList.ResourceSupply)destination$iv$iv /* !! */ ;
                var25_38 = $i$f$filter;
                $i$a$-sumOfInt-Automation$allowSpendingResource$usedForUnits$2 = false;
                var26_39 = -it.getAmount();
                $i$f$filter = var25_38 + var26_39;
            }
            usedForUnits = $i$f$filter;
            $this$filter$iv = civInfo.getDetailedCivResources();
            $i$f$filter = false;
            destination$iv$iv /* !! */  = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (E element$iv$iv : $this$filterTo$iv$iv) {
                it = (ResourceSupplyList.ResourceSupply)element$iv$iv;
                $i$a$-filter-Automation$allowSpendingResource$usedForBuildings$1 = false;
                if (!(Intrinsics.areEqual(it.getResource().getName(), resource) != false && Intrinsics.areEqual(it.getOrigin(), "Buildings") != false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            var16_20 = (List)destination$iv$iv;
            var17_22 = 0;
            for (T var19_25 : var16_20) {
                $i$f$filterTo = (ResourceSupplyList.ResourceSupply)var19_25;
                var25_38 = var17_22;
                $i$a$-sumOfInt-Automation$allowSpendingResource$usedForBuildings$2 = false;
                var26_39 = -it.getAmount();
                var17_22 = var25_38 + var26_39;
            }
            usedForBuildings = var17_22;
            if (construction instanceof Building) {
                v6 = civResources.get(resource);
                Intrinsics.checkNotNull(v6);
                if (((Number)v6).intValue() + usedForUnits >= usedForBuildings + amount + futureForBuildings) continue;
                return false;
            }
            v7 = civResources.get(resource);
            Intrinsics.checkNotNull(v7);
            if (((Number)v7).intValue() + usedForBuildings >= usedForUnits + amount + futureForUnits) continue;
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean allowSpendingResource$default(Automation automation, Civilization civilization, INonPerpetualConstruction iNonPerpetualConstruction, City city2, int n, Object object) {
        if ((n & 4) != 0) {
            city2 = null;
        }
        return automation.allowSpendingResource(civilization, iNonPerpetualConstruction, city2);
    }

    public final int getReservedSpaceResourceAmount(@NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        return civInfo.wantsToFocusOn(Victory.Focus.Science) ? 3 : 2;
    }

    @NotNull
    public final ThreatLevel threatAssessment(@NotNull Civilization assessor, @NotNull Civilization assessed) {
        Intrinsics.checkNotNullParameter(assessor, "assessor");
        Intrinsics.checkNotNullParameter(assessed, "assessed");
        float powerLevelComparison = (float)assessed.getStatForRanking(RankingType.Force) / (float)assessor.getStatForRanking(RankingType.Force);
        return powerLevelComparison > 2.0f ? ThreatLevel.VeryHigh : (powerLevelComparison > 1.5f ? ThreatLevel.High : (powerLevelComparison < 0.5f ? ThreatLevel.VeryLow : (powerLevelComparison < 0.6666667f ? ThreatLevel.Low : ThreatLevel.Medium)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Tile getTileForConstructionImprovement(@NotNull City city2, @NotNull TileImprovement improvement2) {
        Object v0;
        void $this$maxByOrNull$iv;
        Intrinsics.checkNotNullParameter(city2, "city");
        Intrinsics.checkNotNullParameter(improvement2, "improvement");
        LocalUniqueCache localUniqueCache = new LocalUniqueCache(false, 1, null);
        Sequence<Tile> sequence = SequencesKt.filter(city2.getTiles(), (Function1)new Function1<Tile, Boolean>(city2, improvement2){
            final /* synthetic */ City $city;
            final /* synthetic */ TileImprovement $improvement;
            {
                this.$city = $city;
                this.$improvement = $improvement;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Tile it) {
                Intrinsics.checkNotNullParameter(it, "it");
                TileImprovement tileImprovement = it.getTileImprovement();
                return (tileImprovement != null ? !tileImprovement.hasUnique(UniqueType.AutomatedUnitsWillNotReplace, new StateForConditionals(this.$city.getCiv(), this.$city, null, it, null, null, null, null, null, null, false, 2036, null)) : false) && it.getImprovementFunctions().canBuildImprovement(this.$improvement, this.$city.getCiv());
            }
        });
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Tile it = (Tile)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = INSTANCE.rankTileForCityWork(it, city2, localUniqueCache);
                do {
                    Object e$iv = iterator$iv.next();
                    Tile it2 = (Tile)e$iv;
                    $i$a$-maxByOrNull-Automation$getTileForConstructionImprovement$2 = false;
                    float v$iv = INSTANCE.rankTileForCityWork(it2, city2, localUniqueCache);
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    public final float rankTile$core(@Nullable Tile tile, @NotNull Civilization civInfo, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        if (tile == null) {
            return 0.0f;
        }
        Civilization tileOwner = tile.getOwner();
        if (tileOwner != null && !Intrinsics.areEqual(tileOwner, civInfo)) {
            return 0.0f;
        }
        Stats stats2 = tile.getStats().getTileStats(null, civInfo, localUniqueCache);
        float rank = this.rankStatsValue(stats2, civInfo);
        if (tile.getImprovement() == null) {
            rank += 0.5f;
        }
        if (tile.isPillaged()) {
            rank += 0.6f;
        }
        if (tile.hasViewableResource(civInfo)) {
            TileResource resource2 = tile.getTileResource();
            if (resource2.getResourceType() != ResourceType.Bonus) {
                rank += 1.0f;
            }
            if (tile.getImprovement() == null) {
                rank += 1.0f;
            }
            if (tile.isPillaged()) {
                rank += 1.1f;
            }
        }
        return rank;
    }

    /*
     * Unable to fully structure code
     */
    public final int rankTileForExpansion$core(@NotNull Tile tile, @NotNull City city, @NotNull LocalUniqueCache localUniqueCache) {
        block16: {
            Intrinsics.checkNotNullParameter(tile, "tile");
            Intrinsics.checkNotNullParameter(city, "city");
            Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
            distance = tile.aerialDistanceTo(city.getCenterTile());
            score = distance * 100;
            if (tile.hasViewableResource(city.getCiv())) {
                if (tile.getTileResource().getResourceType() != ResourceType.Bonus) {
                    score -= 105;
                } else if (distance <= city.getWorkRange()) {
                    score -= 104;
                }
            } else {
                if (tile.isWater()) {
                    score += 3;
                }
                if (distance > city.getWorkRange()) {
                    score += 100;
                }
            }
            if (tile.getNaturalWonder() != null) {
                score -= 105;
            }
            score -= (int)SequencesKt.sumOfFloat(tile.getStats().getTileStats(city, city.getCiv(), localUniqueCache).getValues());
            adjacentNaturalWonder = false;
            var7_7 = SequencesKt.filter(tile.getNeighbors(), rankTileForExpansion.1.INSTANCE).iterator();
            while (var7_7.hasNext()) {
                adjacentTile = var7_7.next();
                adjacentDistance = city.getCenterTile().aerialDistanceTo(adjacentTile);
                if (adjacentTile.hasViewableResource(city.getCiv()) && (adjacentDistance < city.getWorkRange() || adjacentTile.getTileResource().getResourceType() != ResourceType.Bonus)) {
                    --score;
                }
                if (adjacentTile.getNaturalWonder() == null) continue;
                if (adjacentDistance < city.getWorkRange()) {
                    adjacentNaturalWonder = true;
                }
                --score;
            }
            if (adjacentNaturalWonder) {
                --score;
            }
            $this$none$iv = tile.getNeighbors();
            $i$f$none = false;
            var9_11 = $this$none$iv.iterator();
            while (var9_11.hasNext()) {
                it = element$iv = var9_11.next();
                $i$a$-none-Automation$rankTileForExpansion$2 = false;
                if (it.getCity() == null) ** GOTO lbl-1000
                v0 = it.getCity();
                Intrinsics.checkNotNull(v0);
                if (Intrinsics.areEqual(v0.getId(), city.getId())) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = false;
                break block16;
            }
            v2 = true;
        }
        if (v2) {
            score += 1000;
        }
        return score;
    }

    public final float rankStatsValue(@NotNull Stats stats2, @NotNull Civilization civInfo) {
        Intrinsics.checkNotNullParameter(stats2, "stats");
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        float rank = 0.0f;
        rank += stats2.getFood() * 1.2f;
        rank += civInfo.getGold() < 0 && civInfo.getStats().getStatsForNextTurn().getGold() <= 0.0f ? stats2.getGold() : stats2.getGold() / (float)3;
        rank += stats2.getHappiness();
        rank += stats2.getProduction();
        rank += stats2.getScience();
        rank += stats2.getCulture();
        return rank += stats2.getFaith();
    }

    /*
     * WARNING - void declaration
     */
    private static final int providesUnneededCarryingSlots$getCarryAmount(String carryFilter, MapUnit mapUnit) {
        int n;
        Unique unique = (Unique)SequencesKt.firstOrNull(MapUnit.getMatchingUniques$default(mapUnit, UniqueType.CarryAirUnits, null, false, 6, null));
        if (unique == null) {
            return 0;
        }
        Unique mapUnitCarryUnique = unique;
        if (!Intrinsics.areEqual(mapUnitCarryUnique.getParams().get(1), carryFilter)) {
            return 0;
        }
        Sequence sequence = SequencesKt.filter(MapUnit.getMatchingUniques$default(mapUnit, UniqueType.CarryExtraAirUnits, null, false, 6, null), (Function1)new Function1<Unique, Boolean>(carryFilter){
            final /* synthetic */ String $carryFilter;
            {
                this.$carryFilter = $carryFilter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Unique it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return Intrinsics.areEqual(it.getParams().get(1), this.$carryFilter);
            }
        });
        int n2 = Integer.parseInt(mapUnitCarryUnique.getParams().get(0));
        int n3 = 0;
        Iterator iterator2 = sequence.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object t = iterator2.next();
            Unique unique2 = (Unique)t;
            n = n3;
            boolean bl = false;
            int n4 = Integer.parseInt(it.getParams().get(0));
            n3 = n + n4;
        }
        n = n3;
        return n2 + n;
    }

    private static final boolean chooseMilitaryUnit$isNavalMeleeUnit(BaseUnit unit) {
        return unit.isMelee() && unit.getType().isWaterUnit();
    }

    public static final /* synthetic */ boolean access$chooseMilitaryUnit$isNavalMeleeUnit(BaseUnit unit) {
        return Automation.chooseMilitaryUnit$isNavalMeleeUnit(unit);
    }
}

